void init_state ();		/* initialization routines */
void read_geometry ();
void read_stress ();
void read_annual_temp ();
void read_annual_salt ();
void read_annual_temp_simple ();
void read_annual_salt_simple ();

void time_step ();		/* model run time code */
float density_crude (float s, float t, int iz);
float density (float s, float t, float hydrostatic_pressure);
/* Wall boundary condition routines */
void filt4s_wall_d (float ***q, float cwest, float ceast, float csouth, float cnorth);
void filt4m_wall_d (float ***q, float cwest, float ceast, float csouth, float cnorth);
void filt4p_wall_d (float **q, float cwest, float ceast, float csouth, float cnorth);
void wrap_q_wall_d (float **a, float cwest, float ceast, float csouth, float cnorth);
void wrap_q3_wall_d (float **a, float **b, float **c,
		float a_cwest, float a_ceast, float a_csouth, float a_cnorth,
		float b_cwest, float b_ceast, float b_csouth, float b_cnorth,
		float c_cwest, float c_ceast, float c_csouth, float c_cnorth);
void wrap_qz_wall_d (float ***a, float cwest, float ceast, float csouth, float cnorth);
void read_restart_slice_wall_d (float **a, FILE * tfile, float cwest, float ceast, float csouth, float cnorth);
void load_restart_wall ();
void send_and_receive_v (
                  int source_node, int tag, void *inbuffer,
                  int elem_len, int stride, int elem_count,
                  int dest_node, void *outbuffer);
void send_and_receive (
                int source_node, int tag, void *inbuffer, int buf_len,
                int dest_node, void *outbuffer);

void tidal_boundary (float **ptop, float time);

void write_picture_d (float **a, float vmax);	/* movie and history file output routines */
void write_history_slice_d (float ***a, int iz);

float *** memalloc3dfloat (char *varname, float ***a, int nz, int ny, int nx);
float ** memalloc2dfloat (char *varname, float **a, int ny, int nx);
float * memalloc1dfloat (char *varname, float *a, int n);
int ** memalloc2dint (char *varname, int **a, int ny, int nx);
unsigned char *** memalloc3duschar (char *varname, unsigned char ***a, int nz, int ny, int nx);
unsigned char ** memalloc2duschar (char *varname, unsigned char **a, int ny, int nx);
unsigned char * memalloc1duschar (char *varname, unsigned char *a, int n);
char * memalloc1dchar (char *varname, char *a, int n);

void free3d (void ***a, int Mz);
void free2d (void **);

int read_input_data(char *filename);

float f_max_d (float **a);	/* non-timestep utility routines */
void node_timer_clear (int n);
void node_timer_start (int n);
void node_timer_stop (int n);
float node_timer_busy (int n);
void load_restart ();
void read_restart_slice_d (float **a, FILE * tfile);
void save_restart ();
void write_restart_slice_d (float **a, FILE * tfile);
void global_write ();

/* SME wrapper routines */

#if __GNUG__ >= 2
#  pragma interface
#endif

int om3_get_procDim( int dim );
void om3_init( const char* data_dir, const char* output_dir, int argc, char *argv[] );
void om3_finalize();
void om3_run( double stop_time );
int om3_set_current_data_array(  const char* name, int init);
float om3_get_data_value( int jx, int jy, int jz );
void om3_set_data_value( int jx, int jy, int jz, float value );
void om3_wrap_boundary();
void om3_set_data_directory( const char* path );
void om3_set_output_directory( const char* path );
char* om3_tracer_name( int index, const char* tname );
int om3_get_tracer_index();

#ifdef OLD

void filt4s (float q[Mz][My][Mx]);
void filt4m (float q[Mz][My][Mx]);
void filt4p (float q[My][Mx]);
/* assumes doubly periodic */
void wrap_q (float a[My][Mx]);
void wrap_q3 (float a[My][Mx], float b[My][Mx], float c[My][Mx]);
void wrap_qz (float a[Mz][My][Mx]);

void filt4s_wall (float q[Mz][My][Mx], float cwest, float ceast, float csouth, float cnorth);
void filt4m_wall (float q[Mz][My][Mx], float cwest, float ceast, float csouth, float cnorth);
void filt4p_wall (float q[My][Mx], float cwest, float ceast, float csouth, float cnorth);
void wrap_q3_wall (float a[My][Mx], float b[My][Mx], float c[My][Mx],
		float a_cwest, float a_ceast, float a_csouth, float a_cnorth,
		float b_cwest, float b_ceast, float b_csouth, float b_cnorth,
		float c_cwest, float c_ceast, float c_csouth, float c_cnorth);
void wrap_qz_wall (float a[Mz][My][Mx], float cwest, float ceast, float csouth, float cnorth);
void read_restart_slice_wall (float a[My][Mx], FILE * tfile, float cwest, float ceast, float csouth, float cnorth);
void write_picture (float a[My][Mx], float vmax);	/* movie and history file output routines */
void fwrite_picture (float a[My][Mx], float vmax);
void write_history (float a[Mz][My][Mx]);
void write_history_slice (float a[Mz][My][Mx], int iz);
float f_max (float a[My][Mx]);	/* non-timestep utility routines */
void read_restart_slice (float a[My][Mx], FILE * tfile);
void write_restart_slice (float a[My][Mx], FILE * tfile);

#endif
