#include <stdio.h>
#include "defines.h"
#include "externvars.h" /* om3 external vars */
#include "routines.h"

int scmp(const char* a, const char* b) {
  int diff = 0;
  while ((diff = *a - *b++) == 0 && *a++ != 0);
  return diff;
}

int iabs( int iarg ) { return (iarg<0) ? -iarg : iarg; }

void dump_state_square( char* name, double time, int tx, int ty, int size, int local_coords ) {
	int ix, iy, iz, jx, jy, mx, my, jz = Nz-1;
	om3_set_current_data_array( name, 0 );
	
	printf("\n\n ******** Dump var %s(%p): time %f,  ", name, current_data_array, time );
	for (jy = 0; jy < Ny; jy++) {
		iy = jy - row * (My - 2) + 1;
		for (jx = 0; jx < Nx; jx++) {
			ix = jx - col * (Mx - 2) + 1;
			if ((ix >= 0) && (ix < Mx) && (iy >= 0) && (iy < My)) {
				if( local_coords ) {
				  if ( ( iabs(ix-tx) < size ) && ( iabs(iy-ty) < size ) ) {
					  printf("\nProc(%d,%d), cell(%d,%d): %f %f %f %f", row, col ,jx,jy,
					  current_data_array[jz][iy][ix],
					  current_data_array_x[jz][iy][ix],
					  current_data_array_l[jz][iy][ix],
					  current_data_array_dt[jz][iy][ix]);
				  }
				} else {
				  if ( ( iabs(jx-tx) < size ) && ( iabs(jy-ty) < size ) ) {
					  printf("\nProc(%d,%d), cell(%d,%d): %f %f %f %f", row, col ,jx, jy,
					  current_data_array[jz][iy][ix],
					  current_data_array_x[jz][iy][ix],
					  current_data_array_l[jz][iy][ix],
					  current_data_array_dt[jz][iy][ix]);
				  }
				}
			}
		}
	}
}

int om3_get_proc_dim( int dim ) {
  switch ( dim ) {
   case 0: return Nrows;
   case 1: return Ncols;
   case 2: return 1;
  }
}

int om3_get_grid_dim( int dim ) {
  switch ( dim ) {
   case 0: return Nx;
   case 1: return Ny;
   case 2: return Nz;
  }
}

int om3_set_current_data_array( const char* name, int init ) {
  current_data_array = NULL;
  if (name != NULL) { 
	if( SAME("u",name) ) { 
		current_data_array = u; 
		current_data_array_x = ux;  
		current_data_array_l = ul; 
		current_data_array_dt = dtu; 
	} 
	else if( SAME("v",name) ) { 
		current_data_array = v; 
		current_data_array_x = vx;  
		current_data_array_l = vl; 
		current_data_array_dt = dtv; 
	} 
	else if( SAME("t",name) ) { 
		current_data_array = t; 
		current_data_array_x = tx;  
		current_data_array_l = tl; 
		current_data_array_dt = dtt; 
	} 
	else if( (name[0] == 't') && (name[1] == 'r') ) { 
		if( isdigit( name[2] ) ) {
		  tracer_index = atoi( name+2 );
		} else if( name[2] == '\0' ) {
		  tracer_index = 0;
		} else {
		  	  printf("\nerror: Illegal tracer name %s", name ); 
		  	  current_data_array = NULL;
		  	  return 1;
		}
		if( (tracer_index >= NumTracers) || ( tracer_index < 0 ) ) {
		  	  printf("\nerror: Illegal tracer index %d", tracer_index ); 
		  	  current_data_array = NULL;
		  	  return 1;
		}
		current_data_array = tr[tracer_index]; 
		current_data_array_x = trx[tracer_index];  
		current_data_array_l = trl[tracer_index]; 
		current_data_array_dt = dttr[tracer_index]; 
	} 
	else if( SAME("s",name) ) { 
		current_data_array = s; 
		current_data_array_x = sx;  
		current_data_array_l = sl; 
		current_data_array_dt = dts; 
	} 
	else if( SAME("a",name) ) { 
		current_data_array = a; 
		current_data_array_x = ax;  
		current_data_array_l = al; 
		current_data_array_dt = dta; 
	} 
	else return 0;
  }
#ifdef DEBUG
  if (my_address == 0) {
	  printf("\nSetting current data array to %s: %p, tracer index = %d",name,current_data_array,tracer_index);
  }
#endif
  return 1;
}

void om3_set_output_directory( const char* path ) {
	strcpy( output_directory, path );
	if (my_address == 0 ) {
	   printf("info:  OM3-Setting output dir to %s\n",path);
	}
}

char* om3_tracer_name( int index, const char* tname ) {
  if( index >= NumTracers ) {
	 printf("error:  Illegal tracer index for %s: %d\n",tname,index);
	 return;
  }
  if( tname != NULL ) {
	tracer_name[index] = (char*) malloc( strlen(tname) );
	strcpy(tracer_name[index],tname);
	if (my_address == 0 ) {
	   printf("info:  Registering tracer %d: %s\n",index,tname);
	}
  }
  return tracer_name[index];
}

int om3_get_tracer_index() {
  return tracer_index;
}

float om3_get_data_value( int jx, int jy, int jz ) {
  static int cnt=0;
  int ix, iy, iz;
  static float rv;
  ix = jx - col * (Mx - 2) + 1;
  iy = jy - row * (My - 2) + 1;
  iz = (Nz-1) - jz;
  rv = current_data_array[ iz ][ iy ][ ix ];
#ifdef DEBUG
  if( (my_address == 0) && (cnt++ < 10)  ) {
	printf("\ndebug: om3_get_data_value: (%d,%d,%d) -> (%d,%d,%d) -> %f (%p) :: tuv ( %p %p %p ) -> ( %f %f %f )", jx, jy, jz, ix, iy, iz, rv, 
			current_data_array, t, u, v, t[ iz ][ iy ][ ix ], u[ iz ][ iy ][ ix ], v[ iz ][ iy ][ ix ] );
  }
#endif
  return rv;
}

void om3_set_data_directory( const char* path ) {
	strcpy( data_directory, path );
	if (my_address == 0 ) {
		printf("info: OM3-Setting data dir to %s\n",path);
	}
}

void om3_wrap_boundary() {
	int ix, iy, iz;
	
	wrap_qz_wall_d ( current_data_array, 1.0, 1.0, 1.0, 1.0 );

	for (iz = 0; iz < Mz; iz++) {	
	
	  if (row == 0)
		  for (ix = 0; ix < Mx; ix++) {
			current_data_array_x[iz][0][ix] = current_data_array_l[iz][0][ix] = current_data_array[iz][0][ix];
		  }
	  if (row == Nrows-1)
		  for (ix = 0; ix < Mx; ix++) {
			current_data_array_x[iz][My - 1][ix] = current_data_array_l[iz][My - 1][ix] = current_data_array[iz][My - 1][ix];
		  }
	  if (col == 0)
		  for (iy = 0; iy < My; iy++) {
			current_data_array_x[iz][iy][0] = current_data_array_l[iz][iy][0] = current_data_array[iz][iy][0];
		  }
	  if (col == Ncols-1)
		  for (iy = 0; iy < My; iy++) {
			current_data_array_x[iz][iy][Mx - 1] = current_data_array_l[iz][iy][Mx - 1] = current_data_array[iz][iy][Mx - 1];
		  }
	}
}


void om3_set_data_value( int jx, int jy, int jz, float value  ) {
  int iy = jy - row * (My - 2) + 1;
  int ix = jx - col * (Mx - 2) + 1;
  int iz = (Nz-1) - jz;
  if ((ix >= 0) && (ix < Mx) && (iy >= 0) && (iy < My)) {
	current_data_array[ iz ][ iy ][ ix ] = value;
	current_data_array_x[ iz ][ iy ][ ix ] = value;
	current_data_array_l[ iz ][ iy ][ ix ] = value;
  }
}
