#include <stdio.h>
#include <math.h>
#include <mpi.h>
#include "defines.h"
#include "externvars.h"
#include "routines.h"

void  time_step () {
	int ix, iy, iz, it, isplit, isub_split;
	float delt_spl;
	float dx, dy;
	float dcx, dcy, dcxm, dcym;
	float ramp1 = 60.0 * 60.0 * 12.0;
	float pfac;
	
	if (run_time < ramp1)
	{
		pfac = 10.0 * run_time/ramp1;
	}
	else
	{
		pfac = 10.0;
	}

	dcxm = Diff_Mks / (Delx * Delx);
	dcym = Diff_Mks / (Dely * Dely);
	dcx = Diff_Ratio * Diff_Mks / (Delx * Delx);
	dcy = Diff_Ratio * Diff_Mks / (Dely * Dely);

	/* Second order conservative dissipation on scalars */

	/*
	printf("Timestep: A %i\n",my_address);
	*/
	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 1; iy < My - 1; iy++)
		{
			for (ix = 1; ix < Mx - 1; ix++)
			{
				dts[iz][iy][ix] = 0.0;
				dtt[iz][iy][ix] = 0.0;
				dta[iz][iy][ix] = 0.0;

				for (it = 0; it < NumTracers; it++)
				{
					dttr[it][iz][iy][ix] = 0.0;
				}

				if InWater(h[iz][iy][ix])
				{
					if InWater(h[iz][iy][ix - 1])
					{
						dts[iz][iy][ix] -= dcx * (sl[iz][iy][ix] - sl[iz][iy][ix - 1]);
						dtt[iz][iy][ix] -= dcx * (tl[iz][iy][ix] - tl[iz][iy][ix - 1]);
						dta[iz][iy][ix] -= dcx * (al[iz][iy][ix] - al[iz][iy][ix - 1]);

						for (it = 0; it < NumTracers; it++)
						{
							dttr[it][iz][iy][ix] -= dcx * (trl[it][iz][iy][ix] - trl[it][iz][iy][ix - 1]);
						}
					}

					if InWater(h[iz][iy][ix + 1])
					{
						dts[iz][iy][ix] -= dcx * (sl[iz][iy][ix] - sl[iz][iy][ix + 1]);
						dtt[iz][iy][ix] -= dcx * (tl[iz][iy][ix] - tl[iz][iy][ix + 1]);
						dta[iz][iy][ix] -= dcx * (al[iz][iy][ix] - al[iz][iy][ix + 1]);

						for (it = 0; it < NumTracers; it++)
						{
							dttr[it][iz][iy][ix] -= dcx * (trl[it][iz][iy][ix] - trl[it][iz][iy][ix + 1]);
						}
					}

					if InWater(h[iz][iy - 1][ix])
					{
						dts[iz][iy][ix] -= dcy * (sl[iz][iy][ix] - sl[iz][iy - 1][ix]);
						dtt[iz][iy][ix] -= dcy * (tl[iz][iy][ix] - tl[iz][iy - 1][ix]);
						dta[iz][iy][ix] -= dcy * (al[iz][iy][ix] - al[iz][iy - 1][ix]);

						for (it = 0; it < NumTracers; it++)
						{
							dttr[it][iz][iy][ix] -= dcy * (trl[it][iz][iy][ix] - trl[it][iz][iy - 1][ix]);
						}
					}

					if InWater(h[iz][iy + 1][ix])
					{
						dts[iz][iy][ix] -= dcy * (sl[iz][iy][ix] - sl[iz][iy + 1][ix]);
						dtt[iz][iy][ix] -= dcy * (tl[iz][iy][ix] - tl[iz][iy + 1][ix]);
						dta[iz][iy][ix] -= dcy * (al[iz][iy][ix] - al[iz][iy + 1][ix]);

						for (it = 0; it < NumTracers; it++)
						{
							dttr[it][iz][iy][ix] -= dcy * (trl[it][iz][iy][ix] - trl[it][iz][iy + 1][ix]);
						}
						
					}
				}
			}
		}
	}

	/* Second order conservative dissipation on momentum */

	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 1; iy < My - 1; iy++)
		{
			for (ix = 1; ix < Mx - 1; ix++)
			{
				dtu[iz][iy][ix] = 0.0;
				dtv[iz][iy][ix] = 0.0;

				if InWater(uvh[iz][iy][ix])
				{
					if InWater(uvh[iz][iy][ix - 1])
					{
						dtu[iz][iy][ix] -= dcxm * (ul[iz][iy][ix] - ul[iz][iy][ix - 1]);
						dtv[iz][iy][ix] -= dcxm * (vl[iz][iy][ix] - vl[iz][iy][ix - 1]);
					}

					if InWater(uvh[iz][iy][ix + 1])
					{
						dtu[iz][iy][ix] -= dcxm * (ul[iz][iy][ix] - ul[iz][iy][ix + 1]);
						dtv[iz][iy][ix] -= dcxm * (vl[iz][iy][ix] - vl[iz][iy][ix + 1]);
					}

					if InWater(uvh[iz][iy - 1][ix])
					{
						dtu[iz][iy][ix] -= dcym * (ul[iz][iy][ix] - ul[iz][iy - 1][ix]);
						dtv[iz][iy][ix] -= dcym * (vl[iz][iy][ix] - vl[iz][iy - 1][ix]);
					}

					if InWater(uvh[iz][iy + 1][ix])
					{
						dtu[iz][iy][ix] -= dcym * (ul[iz][iy][ix] - ul[iz][iy + 1][ix]);
						dtv[iz][iy][ix] -= dcym * (vl[iz][iy][ix] - vl[iz][iy + 1][ix]);
					}
				}
			}
		}
	}

/* wind stress forcing on points with full dynamics */

	calculate_wind_stress(run_time); /* see wind_stress.c */

	for (iy = 1; iy < My - 1; iy++)
	{
		for (ix = 1; ix < Mx - 1; ix++)
		{
			if InWater(uvh[Nz - 1][iy][ix])
			{
/* orf must change with real data */
/*
				dtu[Nz - 1][iy][ix] += 0.0000;
				dtv[Nz - 1][iy][ix] += 0.0000;
*/
				dtu[Nz-1][iy][ix] += taux[iy][ix];
				dtv[Nz-1][iy][ix] += tauy[iy][ix];
			}
		}
	}

/* Surface forcing on T,S */

	for (iy = 1; iy < My - 1; iy++)
	{
		for (ix = 1; ix < Mx - 1; ix++)
		{
			if InWater(h[Nz - 1][iy][ix])
			{
				dtt[Nz-1][iy][ix] += Restore * (annual_temp[Nz-1][iy][ix] - tl[Nz-1][iy][ix]);
				dts[Nz-1][iy][ix] += Restore * (annual_salt[Nz-1][iy][ix] - sl[Nz-1][iy][ix]);
				t_forcing[iy][ix] += Delt * Restore * (annual_temp[Nz-1][iy][ix] - tl[Nz-1][iy][ix]);
				s_forcing[iy][ix] += Delt * Restore * (annual_salt[Nz-1][iy][ix] - sl[Nz-1][iy][ix]);
				
/* orf this will need to be changed back with real data */
/*
				dtt[Nz - 1][iy][ix] += Restore * (26.0 - tl[Nz - 1][iy][ix]);
				dts[Nz - 1][iy][ix] += Restore * (22.0 - sl[Nz - 1][iy][ix]);
				t_forcing[iy][ix] += Delt * Restore * (26.0 - tl[Nz - 1][iy][ix]);
				s_forcing[iy][ix] += Delt * Restore * (22.0 - sl[Nz - 1][iy][ix]);
*/
			}
		}
	}

/* Calculate Box u-advection dt's u,v,s,t.  Accumulate into dt arrays. */

	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 1; iy < My - 1; iy++)
		{
			double advc, advc1, advc2;

			advc = geo3[iy] * 1.0 / (4.0 * Delx);

			for (ix = 1; ix < Mx - 1; ix++)
			{
				if InWater(h[iz][iy][ix])
				{
					if InWater(h[iz][iy][ix - 1])
					advc1 = advc * (u[iz][iy][ix - 1] + u[iz][iy][ix]);
					else
					advc1 = 0.0;

					if InWater(h[iz][iy][ix + 1])
					advc2 = advc * (u[iz][iy][ix] + u[iz][iy][ix + 1]);
					else
					advc2 = 0.0;

					dtu[iz][iy][ix] += advc1 * (u[iz][iy][ix - 1] - u[iz][iy][ix])
					+ advc2 * (u[iz][iy][ix] - u[iz][iy][ix + 1]);

					dtv[iz][iy][ix] += advc1 * (v[iz][iy][ix - 1] - v[iz][iy][ix])
					+ advc2 * (v[iz][iy][ix] - v[iz][iy][ix + 1]);

					dts[iz][iy][ix] += advc1 * (s[iz][iy][ix - 1] - s[iz][iy][ix])
					+ advc2 * (s[iz][iy][ix] - s[iz][iy][ix + 1]);

					dtt[iz][iy][ix] += advc1 * (t[iz][iy][ix - 1] - t[iz][iy][ix])
					+ advc2 * (t[iz][iy][ix] - t[iz][iy][ix + 1]);

					dta[iz][iy][ix] += advc1 * (a[iz][iy][ix - 1] - a[iz][iy][ix])
					+ advc2 * (a[iz][iy][ix] - a[iz][iy][ix + 1]);

					for (it = 0; it < NumTracers; it++)
					{
						dttr[it][iz][iy][ix] += advc1 * (tr[it][iz][iy][ix - 1] - tr[it][iz][iy][ix])
						+ advc2 * (tr[it][iz][iy][ix] - tr[it][iz][iy][ix + 1]);
					}
				}
			}
		}
	}

	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 1; iy < My - 1; iy++)
		{
			double advc, advc1, advc2;

			advc = 1.0 / (4.0 * Dely);

			for (ix = 1; ix < Mx - 1; ix++)
			{
				if InWater(h[iz][iy][ix])
				{
					if InWater(h[iz][iy - 1][ix])
					advc1 = advc * (v[iz][iy - 1][ix] + v[iz][iy][ix]);
					else
					advc1 = 0.0;

					if InWater(h[iz][iy + 1][ix])
					advc2 = advc * (v[iz][iy][ix] + v[iz][iy + 1][ix]);
					else
					advc2 = 0.0;

					dtu[iz][iy][ix] += advc1 * (u[iz][iy - 1][ix] - u[iz][iy][ix])
					+ advc2 * (u[iz][iy][ix] - u[iz][iy + 1][ix]);

					dtv[iz][iy][ix] += advc1 * (v[iz][iy - 1][ix] - v[iz][iy][ix])
					+ advc2 * (v[iz][iy][ix] - v[iz][iy + 1][ix]);

					dts[iz][iy][ix] += advc1 * (s[iz][iy - 1][ix] - s[iz][iy][ix])
					+ advc2 * (s[iz][iy][ix] - s[iz][iy + 1][ix]);

					dtt[iz][iy][ix] += advc1 * (t[iz][iy - 1][ix] - t[iz][iy][ix])
					+ advc2 * (t[iz][iy][ix] - t[iz][iy + 1][ix]);

					dta[iz][iy][ix] += advc1 * (a[iz][iy - 1][ix] - a[iz][iy][ix])
					+ advc2 * (a[iz][iy][ix] - a[iz][iy + 1][ix]);

					for (it = 0; it < NumTracers; it++)
					{
						dttr[it][iz][iy][ix] += advc1 * (tr[it][iz][iy - 1][ix] - tr[it][iz][iy][ix])
						+ advc2 * (tr[it][iz][iy][ix] - tr[it][iz][iy + 1][ix]);
					}
				}
			}
		}
	}

	/* setup vx, wx, tx, sx for time split step */

	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 0; iy < My; iy++)
		{
			for (ix = 0; ix < Mx; ix++)
			{
				ux[iz][iy][ix] = ul[iz][iy][ix];

				vx[iz][iy][ix] = vl[iz][iy][ix];

				tx[iz][iy][ix] = tl[iz][iy][ix];

				sx[iz][iy][ix] = sl[iz][iy][ix];

				ax[iz][iy][ix] = al[iz][iy][ix];

				for (it = 0; it < NumTracers; it++)
				{
					trx[it][iz][iy][ix] = trl[it][iz][iy][ix];
				}
			}
		}
	}
	/* setup ptopx for time split step */

	for (iy = 0; iy < My; iy++)
	{
		for (ix = 0; ix < Mx; ix++)
		{
			ptopx[iy][ix] = ptopl[iy][ix];
		}
	}

	/* caluculate mixing parameters before split */

	for (iz = Mz - 1; iz > 0; iz--)	/* calculate downward mixing  not iz=0 */
	{
		for (iy = 1; iy < My - 1; iy++)
		{
			for (ix = 1; ix < Mx - 1; ix++)
			{
				if InWater(h[iz][iy][ix])
				{
					float shrsq, rr2, rr4, rr8;
					if InWater(h[iz - 1][iy][ix])	/* interior layer */
					{
						nsq[iz][iy][ix] = 9.8 *
						(density (sx[iz - 1][iy][ix], tx[iz - 1][iy][ix], 0.0) -
					density (sx[iz][iy][ix], tx[iz][iy][ix], 0.0))
						/ (0.5 * (h[iz - 1][iy][ix] + h[iz][iy][ix]));
					}
					else
					/* bottom layer */
					{
						if (iz < (Mz - 1))
						nsq[iz][iy][ix] = nsq[iz + 1][iy][ix];
						else
						nsq[iz][iy][ix] = 3.0e-5;	/* also top layer */
					}
					if (nsq[iz][iy][ix] < 1.0e-8)
					nsq[iz][iy][ix] = 1.0e-8;	/* clamp */
					if InWater(uvh[iz][iy][ix])	/* cell with active vels */
					{
						if InWater(uvh[iz - 1][iy][ix])
						{
							shrsq = (ux[iz][iy][ix] - ux[iz - 1][iy][ix]) *
							(ux[iz][iy][ix] - ux[iz - 1][iy][ix])
							+ (vx[iz][iy][ix] - vx[iz - 1][iy][ix]) *
							(vx[iz][iy][ix] - vx[iz - 1][iy][ix]);
						}
						else
						{
							shrsq = ux[iz][iy][ix] * ux[iz][iy][ix]
							+ vx[iz][iy][ix] * vx[iz][iy][ix];
						}
						shrsq /= 0.5 * (uvh[iz][iy][ix] + uvh[iz - 1][iy][ix]);
						shrsq /= 0.5 * (uvh[iz][iy][ix] + uvh[iz - 1][iy][ix]);
					}
					else
					shrsq = 0.0;
					if (shrsq < 0.01 * nsq[iz][iy][ix])
					shrsq = 0.01 * nsq[iz][iy][ix];		/* clamp */
					risq[iz][iy][ix] = nsq[iz][iy][ix] / shrsq;
					if (risq[iz][iy][ix] < 0.01)
					risq[iz][iy][ix] = 0.01;
					rr2 = 1.0 / risq[iz][iy][ix];
					rr4 = rr2 * rr2;
					rr8 = rr4 * rr4;
					kuv[iz][iy][ix] = (7.38e-8 * rr8) + 1.0e-4;
					if (kuv[iz][iy][ix] > 0.01)
					kuv[iz][iy][ix] = 0.01;
					kts[iz][iy][ix] = (2.75e-8 * rr8) + 1.0e-5;
					if (kts[iz][iy][ix] > 0.01)
					kts[iz][iy][ix] = 0.01;
				}
			}
		}
	}

	iz = 0;			/* calcualte downward mixing, bottom layer */
	{
		for (iy = 1; iy < My - 1; iy++)
		{
			for (ix = 1; ix < Mx - 1; ix++)
			{
				if InWater(h[iz][iy][ix])
				{
					float shrsq, rr2, rr4, rr8;

					nsq[iz][iy][ix] = nsq[iz + 1][iy][ix];

					if InWater(uvh[iz][iy][ix])	/* cell with active vels */
					{
						shrsq = ux[iz][iy][ix] * ux[iz][iy][ix]
							+ vx[iz][iy][ix] * vx[iz][iy][ix];
						shrsq /= 0.5 * uvh[iz][iy][ix];
						shrsq /= 0.5 * uvh[iz][iy][ix];
					}
				else
					shrsq = 0.0;
				if (shrsq < 0.01 * nsq[iz][iy][ix])
					shrsq = 0.01 * nsq[iz][iy][ix];	/* clamp */
				risq[iz][iy][ix] = nsq[iz][iy][ix] / shrsq;
				if (risq[iz][iy][ix] < 0.01)
					risq[iz][iy][ix] = 0.01;
				rr2 = 1.0 / risq[iz][iy][ix];
				rr4 = rr2 * rr2;
				rr8 = rr4 * rr4;
				kuv[iz][iy][ix] = (7.38e-8 * rr8) + 1.0e-4;
				if (kuv[iz][iy][ix] > 0.01)
					kuv[iz][iy][ix] = 0.01;
				kts[iz][iy][ix] = (2.75e-8 * rr8) + 1.0e-5;
				if (kts[iz][iy][ix] > 0.01)
					kts[iz][iy][ix] = 0.01;
				}
			}
		}
	}

	delt_spl = 2.0 * Delt / ((float) N_Split);

	for (iz = 0; iz < Mz - 1; iz++)	/* vertical advection of scalars - gradient calculation */
	{
		float dz;
		for (iy = 1; iy < My - 1; iy++)
		{
			for (ix = 1; ix < Mx - 1; ix++)
			{
				if (InWater(h[iz][iy][ix]) && InWater(h[iz + 1][iy][ix]))
				{
					dz = 1 / (0.5 * (h[iz][iy][ix] + h[iz + 1][iy][ix]));

					dzt[iz][iy][ix] = dz * (t[iz + 1][iy][ix] - t[iz][iy][ix]);
					dzs[iz][iy][ix] = dz * (s[iz + 1][iy][ix] - s[iz][iy][ix]);
					dza[iz][iy][ix] = dz * (a[iz + 1][iy][ix] - a[iz][iy][ix]);

					for (it = 0; it < NumTracers; it++)
					{
						dztr[it][iz][iy][ix] = dz * (tr[it][iz + 1][iy][ix] - tr[it][iz][iy][ix]);
					}
				}
				if (InWater(uvh[iz][iy][ix]) && InWater(uvh[iz + 1][iy][ix]))
				{
					dz = 1 / (0.5 * (h[iz][iy][ix] + h[iz + 1][iy][ix]));

					dzu[iz][iy][ix] = dz * (u[iz + 1][iy][ix] - u[iz][iy][ix]);
					dzv[iz][iy][ix] = dz * (v[iz + 1][iy][ix] - v[iz][iy][ix]);
				}
			}
		}
	}

	for (isplit = 0; isplit < N_Split; isplit++)	/* time split hydrostatic integration */
	{
		float dxdt, dydt;

		for (iz = 0; iz < Mz; iz++)		/* calculate vertical velocity */
		{
			float cwx, cwy;

			cwy = 1.0 / (2.0 * Dely);

			for (iy = 1; iy < My - 1; iy++)
			{
				cwx = geo3[iy] * 1.0 / (2.0 * Delx);
				for (ix = 1; ix < Mx - 1; ix++)
				{
					if InWater(h[iz][iy][ix])
					{
						if (iz == 0)
						{
							w[iz][iy][ix] =
							-cwx * (uvh[iz][iy][ix + 1] * ux[iz][iy][ix + 1]
								- uvh[iz][iy][ix - 1] * ux[iz][iy][ix - 1])
							- cwy * (geo2[iy] * uvh[iz][iy + 1][ix] * vx[iz][iy + 1][ix]
							- geo1[iy] * uvh[iz][iy - 1][ix] * vx[iz][iy - 1][ix]);
						}
						else
						{
							w[iz][iy][ix] = w[iz - 1][iy][ix]
							- cwx * (uvh[iz][iy][ix + 1] * ux[iz][iy][ix + 1]
							- uvh[iz][iy][ix - 1] * ux[iz][iy][ix - 1])
							- cwy * (geo2[iy] * uvh[iz][iy + 1][ix] * vx[iz][iy + 1][ix]
							- geo1[iy] * uvh[iz][iy - 1][ix] * vx[iz][iy - 1][ix]);
						}
					}
					else
					w[iz][iy][ix] = 0.0;
				}
			}
		}

		for (iz = 0; iz < Mz - 1; iz++)	/* vertical advection of scalars - update */
		{
			float dt;
			for (iy = 1; iy < My - 1; iy++)
			{
				for (ix = 1; ix < Mx - 1; ix++)
				{
					if (InWater(h[iz][iy][ix]) && InWater(h[iz + 1][iy][ix]))
					{
						dt = 0.5 * delt_spl;

						tx[iz][iy][ix] -= dt * w[iz][iy][ix] * dzt[iz][iy][ix];
						tx[iz + 1][iy][ix] -= dt * w[iz][iy][ix] * dzt[iz][iy][ix];

						sx[iz][iy][ix] -= dt * w[iz][iy][ix] * dzs[iz][iy][ix];
						sx[iz + 1][iy][ix] -= dt * w[iz][iy][ix] * dzs[iz][iy][ix];

						ax[iz][iy][ix] -= dt * w[iz][iy][ix] * dza[iz][iy][ix];
						ax[iz + 1][iy][ix] -= dt * w[iz][iy][ix] * dza[iz][iy][ix];

						for (it = 0; it < NumTracers; it++)
						{
							trx[it][iz][iy][ix] -= dt * w[iz][iy][ix] * dztr[it][iz][iy][ix];
							trx[it][iz + 1][iy][ix] -= dt * w[iz][iy][ix] * dztr[it][iz][iy][ix];
						}

					}
					if (InWater(uvh[iz][iy][ix]) && InWater(uvh[iz + 1][iy][ix]))
					{
						dt = 0.5 * delt_spl;

						ux[iz][iy][ix] -= dt * w[iz][iy][ix] * dzu[iz][iy][ix];
						ux[iz + 1][iy][ix] -= dt * w[iz][iy][ix] * dzu[iz][iy][ix];

						vx[iz][iy][ix] -= dt * w[iz][iy][ix] * dzv[iz][iy][ix];
						vx[iz + 1][iy][ix] -= dt * w[iz][iy][ix] * dzv[iz][iy][ix];
					}
				}
			}
		}

		for (iz = 0; iz < Mz; iz++)		/* time tendancies for scalars */
		{
			for (iy = 1; iy < My - 1; iy++)
			{
				for (ix = 1; ix < Mx - 1; ix++)
				{
					if InWater(h[iz][iy][ix])
					{
						tx[iz][iy][ix] += delt_spl * dtt[iz][iy][ix];
						sx[iz][iy][ix] += delt_spl * dts[iz][iy][ix];
						ax[iz][iy][ix] += delt_spl * dta[iz][iy][ix];

						for (it = 0; it < NumTracers; it++)
						{
							trx[it][iz][iy][ix] += delt_spl * dttr[it][iz][iy][ix];
						}

					}
				}
			}
		}

		for (iy = 1; iy < My - 1; iy++)
		{
			for (ix = 1; ix < Mx - 1; ix++)
			{
				p[Nz - 1][iy][ix] = 0.0;
			}
		}

		for (iz = Nz - 2; iz >= 0; iz--)	/* hydrostatic pressure integration */
		{
			for (iy = 1; iy < My - 1; iy++)
			{
				for (ix = 1; ix < Mx - 1; ix++)
				{
					p[iz][iy][ix] = p[iz + 1][iy][ix] +
					9.8 * 0.5 * (
							h[iz][iy][ix] * density (sx[iz][iy][ix], tx[iz][iy][ix], 0.0)
							+ h[iz + 1][iy][ix] * density (sx[iz + 1][iy][ix], tx[iz + 1][iy][ix], 0.0));
				}
			}
		}

		wrap_qz_wall_d (p,1.0,1.0,1.0,1.0);

		for (iy = 0; iy < My; iy++)		/* split barotropic mode u,v */
		{
			for (ix = 0; ix < Mx; ix++)
			{
				ubaro[iy][ix] = 0.0;
				vbaro[iy][ix] = 0.0;
				for (iz = 0; iz < Mz; iz++)
				{
					if InWater(uvh[iz][iy][ix])
					{
						ubaro[iy][ix] += h[iz][iy][ix] * ux[iz][iy][ix];
						vbaro[iy][ix] += h[iz][iy][ix] * vx[iz][iy][ix];
					}
				}
				ubaro[iy][ix] = ruvdepth[iy][ix] * ubaro[iy][ix];
				vbaro[iy][ix] = ruvdepth[iy][ix] * vbaro[iy][ix];
				for (iz = 0; iz < Mz; iz++)
				{
					if InWater(uvh[iz][iy][ix])
					{
						ux[iz][iy][ix] -= ubaro[iy][ix];
						vx[iz][iy][ix] -= vbaro[iy][ix];
					}
				}
			}
		}

		dy = 1.0 / (2.0 * Dely);

		for (iy = 1; iy < My - 1; iy++)	/* split barotropic mode dtu, dtv including pgf */
		{
			float pgfx, pgfy;
			dx = geo3[iy] * 1.0 / (2.0 * Delx);
			for (ix = 1; ix < Mx - 1; ix++)
			{
				dtubaro[iy][ix] = 0.0;
				dtvbaro[iy][ix] = 0.0;
				for (iz = 0; iz < Mz; iz++)
				{
					if InWater(uvh[iz][iy][ix])
					{
						pgfx = -dx * (p[iz][iy][ix + 1] - p[iz][iy][ix - 1]);
						dtubaro[iy][ix] += h[iz][iy][ix] * (pgfx + dtu[iz][iy][ix]);

						pgfy = -dy * (p[iz][iy + 1][ix] - p[iz][iy - 1][ix]);
						dtvbaro[iy][ix] += h[iz][iy][ix] * (pgfy + dtv[iz][iy][ix]);
					}
				}
				dtubaro[iy][ix] = ruvdepth[iy][ix] * dtubaro[iy][ix];
				dtvbaro[iy][ix] = ruvdepth[iy][ix] * dtvbaro[iy][ix];
			}
		}


		dydt = delt_spl / (2.0 * Dely);

		for (iz = 0; iz < Mz; iz++)
		{
			for (iy = 1; iy < My - 1; iy++)
			{
				float dtf, a, b, r, pgfx, pgfy;

				dxdt = geo3[iy] * delt_spl / (2.0 * Delx);

				dtf = delt_spl * f[iy];
				r = 1.0 / (1.0 + dtf * dtf);	/* norm for semi-implicit coriolis */

				for (ix = 1; ix < Mx - 1; ix++)
				{
					if InWater(uvh[iz][iy][ix])	/* no velocities in dry boxes */
					{
						pgfx = -dxdt * (p[iz][iy][ix + 1] - p[iz][iy][ix - 1]);
						a = delt_spl * (dtu[iz][iy][ix] - dtubaro[iy][ix]);

						pgfy = -dydt * (p[iz][iy + 1][ix] - p[iz][iy - 1][ix]);
						b = delt_spl * (dtv[iz][iy][ix] - dtvbaro[iy][ix]);

						ux[iz][iy][ix] = r * (ux[iz][iy][ix] + pgfx +
							 dtf * (vx[iz][iy][ix] + b + pgfy) + a);

						vx[iz][iy][ix] += pgfy - dtf * ux[iz][iy][ix] + b;
					}
				}
			}
		}

		for (isub_split = 0; isub_split < Sub_Split; isub_split++)	/* barotropic sub-cycle */
		{
			float delt_sub;

			delt_sub = delt_spl / Sub_Split;

			for (iy = 1; iy < My - 1; iy++)	/* Barotropic Pressure field predict */
			{
				float cwx, cwy;

				cwx = geo3[iy] * 1.0 / (2.0 * Delx);
				cwy = 1.0 / (2.0 * Dely);

				for (ix = 1; ix < Mx - 1; ix++)
				{
					ptstar[iy][ix] = ptopx[iy][ix] - G * delt_sub *
					(cwx * (uvdepth[iy][ix + 1] * ubaro[iy][ix + 1]
						- uvdepth[iy][ix - 1] * ubaro[iy][ix - 1])
				+ cwy * (geo2[iy] * uvdepth[iy + 1][ix] * vbaro[iy + 1][ix]
					 - geo1[iy] * uvdepth[iy - 1][ix] * vbaro[iy - 1][ix]));
				}
			}

			dydt = delt_sub / (2.0 * Dely);

			for (iy = 1; iy < My - 1; iy++)	/* barotropic u,v predict */
			{
				float dtf, a, b, /*  r, */ pgfx, pgfy;

				dxdt = geo3[iy] * delt_sub / (2.0 * Delx);

				dtf = delt_sub * f[iy];
				/* r = 1.0 / (1.0 + dtf * dtf); */	/* norm for semi-implicit coriolis */

				for (ix = 1; ix < Mx - 1; ix++)
				{

					if InWater(uvdepth[iy][ix])
					{
						pgfx = -dxdt * (ptopx[iy][ix + 1] - ptopx[iy][ix - 1]);
						a = delt_sub * dtubaro[iy][ix];

						pgfy = -dydt * (ptopx[iy + 1][ix] - ptopx[iy - 1][ix]);
						b = delt_sub * dtvbaro[iy][ix];

						ubstar[iy][ix] = ubaro[iy][ix] + pgfx + dtf * vbaro[iy][ix] + a;

						vbstar[iy][ix] = vbaro[iy][ix] + pgfy - dtf * ubaro[iy][ix] + b;
					}
				}
			}

			wrap_q3_wall_d (ubstar, vbstar, ptstar,
					-1.0,-1.0, 1.0, 1.0,
					 1.0, 1.0,-1.0,-1.0,
					 1.0, 1.0, 1.0, 1.0);

			for (iy = 1; iy < My - 1; iy++)	/* Barotropic Pressure field correct */
			{
				float cwx, cwy;

				cwx = geo3[iy] * 1.0 / (2.0 * Delx);
				cwy = 1.0 / (2.0 * Dely);

				for (ix = 1; ix < Mx - 1; ix++)
				{
					ptopx[iy][ix] = ptopx[iy][ix] - G * delt_sub *
					(cwx * (uvdepth[iy][ix + 1] * ubstar[iy][ix + 1]
						- uvdepth[iy][ix - 1] * ubstar[iy][ix - 1])
				+ cwy * (geo2[iy] * uvdepth[iy + 1][ix] * vbstar[iy + 1][ix]
					 - geo1[iy] * uvdepth[iy - 1][ix] * vbstar[iy - 1][ix]));
				}
			}

			dydt = delt_sub / (2.0 * Dely);

			for (iy = 1; iy < My - 1; iy++)	/* barotropic u,v correct */
			{
				float dtf, a, b, /* r, */ pgfx, pgfy;

				dxdt = geo3[iy] * delt_sub / (2.0 * Delx);

				dtf = delt_sub * f[iy];

				for (ix = 1; ix < Mx - 1; ix++)
				{

					if InWater(uvdepth[iy][ix])
					{
						pgfx = -dxdt * (ptstar[iy][ix + 1] - ptstar[iy][ix - 1]);
						a = delt_sub * dtubaro[iy][ix];

						pgfy = -dydt * (ptstar[iy + 1][ix] - ptstar[iy - 1][ix]);
						b = delt_sub * dtvbaro[iy][ix];

						ubaro[iy][ix] = ubaro[iy][ix] + pgfx + dtf * vbstar[iy][ix] + a;

						vbaro[iy][ix] = vbaro[iy][ix] + pgfy - dtf * ubstar[iy][ix] + b;
					}
				}
			}

			wrap_q3_wall_d (ubaro, vbaro, ptopx,
					-1.0,-1.0, 1.0, 1.0,
					 1.0, 1.0,-1.0,-1.0,
					 1.0, 1.0, 1.0, 1.0);
			filt4p_wall_d (ptopx,1.0,1.0,1.0,1.0);
			tidal_boundary(ptopx,run_time);

		}		/* end barotropic sub cycle */

		for (iz = 0; iz < Mz; iz++)		/* unsplit barotropic mode u,v */
		{
			for (iy = 1; iy < My - 1; iy++)
			{
				for (ix = 1; ix < Mx - 1; ix++)
				{
					if InWater(uvh[iz][iy][ix])
					{
						ux[iz][iy][ix] += ubaro[iy][ix];
						vx[iz][iy][ix] += vbaro[iy][ix];
					}
				}
			}
		}

		/* Vertical mixing */

		for (iz = 1; iz < Mz - 1; iz++)	/* Interior levels */
		{
			for (iy = 1; iy < My - 1; iy++)
			{
				for (ix = 1; ix < Mx - 1; ix++)
				{
					if InWater(uvh[iz][iy][ix])
					{
						float u_up_str, u_down_str, v_up_str, v_down_str, mix;

						if InWater(uvh[iz - 1][iy][ix])
						{
							u_down_str = (ux[iz][iy][ix] - ux[iz - 1][iy][ix]) /
							(0.5 * (uvh[iz][iy][ix] + uvh[iz - 1][iy][ix]));
							v_down_str = (vx[iz][iy][ix] - vx[iz - 1][iy][ix]) /
							(0.5 * (uvh[iz][iy][ix] + uvh[iz - 1][iy][ix]));
						}
						else
						{
							u_down_str = ux[iz][iy][ix] / (0.5 * (uvh[iz][iy][ix]));
							v_down_str = vx[iz][iy][ix] / (0.5 * (uvh[iz][iy][ix]));
						}
						u_up_str = (ux[iz + 1][iy][ix] - ux[iz][iy][ix]) /
						(0.5 * (uvh[iz + 1][iy][ix] + uvh[iz][iy][ix]));
						v_up_str = (vx[iz + 1][iy][ix] - vx[iz][iy][ix]) /
						(0.5 * (uvh[iz + 1][iy][ix] + uvh[iz][iy][ix]));

						u_down_str *= kuv[iz][iy][ix];
						v_down_str *= kuv[iz][iy][ix];
						u_up_str *= kuv[iz + 1][iy][ix];
						v_up_str *= kuv[iz + 1][iy][ix];

						mix = delt_spl / uvh[iz][iy][ix];
						mix_u[iz][iy][ix] = mix * (u_up_str - u_down_str);
						mix_v[iz][iy][ix] = mix * (v_up_str - v_down_str);
					}
/* mix scalars */
					if InWater(h[iz][iy][ix])
					{
						float t_up_str, t_down_str, s_up_str, s_down_str, a_up_str, a_down_str, scmix;
						float tr_up_str[NumTracers], tr_down_str[NumTracers];

						if InWater(h[iz - 1][iy][ix])
						{
							t_down_str = (tx[iz][iy][ix] - tx[iz - 1][iy][ix]) /
							(0.5 * (h[iz][iy][ix] + h[iz - 1][iy][ix]));
							s_down_str = (sx[iz][iy][ix] - sx[iz - 1][iy][ix]) /
							(0.5 * (h[iz][iy][ix] + h[iz - 1][iy][ix]));
							a_down_str = (ax[iz][iy][ix] - ax[iz - 1][iy][ix]) /
							(0.5 * (h[iz][iy][ix] + h[iz - 1][iy][ix]));

							for (it = 0; it < NumTracers; it++)
							{
								tr_down_str[it] = (trx[it][iz][iy][ix] - trx[it][iz - 1][iy][ix]) /
									(0.5 * (h[iz][iy][ix] + h[iz - 1][iy][ix]));
							}
						}
						else
						{
							t_down_str = 0.0;
							s_down_str = 0.0;
							a_down_str = 0.0;

							for (it = 0; it < NumTracers; it++) tr_down_str[it] = 0.0;
						}
						t_up_str = (tx[iz + 1][iy][ix] - tx[iz][iy][ix]) /
						(0.5 * (h[iz + 1][iy][ix] + h[iz][iy][ix]));
						s_up_str = (sx[iz + 1][iy][ix] - sx[iz][iy][ix]) /
						(0.5 * (h[iz + 1][iy][ix] + h[iz][iy][ix]));
						a_up_str = (ax[iz + 1][iy][ix] - ax[iz][iy][ix]) /
						(0.5 * (h[iz + 1][iy][ix] + h[iz][iy][ix]));

						for (it = 0; it < NumTracers; it++)
						{
							tr_up_str[it] = (trx[it][iz + 1][iy][ix] - trx[it][iz][iy][ix]) /
								(0.5 * (h[iz + 1][iy][ix] + h[iz][iy][ix]));
						}

						t_down_str *= kts[iz][iy][ix];
						s_down_str *= kts[iz][iy][ix];
						a_down_str *= kts[iz][iy][ix];
						t_up_str *= kts[iz + 1][iy][ix];
						s_up_str *= kts[iz + 1][iy][ix];
						a_up_str *= kts[iz + 1][iy][ix];

						for (it = 0; it < NumTracers; it++)
						{
							tr_down_str[it] *= kts[iz][iy][ix];
							tr_up_str[it] *= kts[iz +1][iy][ix];
						}

						scmix = delt_spl / h[iz][iy][ix];
						mix_t[iz][iy][ix] = scmix * (t_up_str - t_down_str);
						mix_s[iz][iy][ix] = scmix * (s_up_str - s_down_str);
						mix_a[iz][iy][ix] = scmix * (a_up_str - a_down_str);

						for (it = 0; it < NumTracers; it++)
						{
							mix_tr[it][iz][iy][ix] = scmix * (tr_up_str[it] - tr_down_str[it]);
						}
					}
				}
			}
		}

		iz = 0;		/* Bottom level */
		{
			for (iy = 1; iy < My - 1; iy++)
			{
				for (ix = 1; ix < Mx - 1; ix++)
				{
					if InWater(uvh[iz][iy][ix])
					{
						float u_up_str, u_down_str, v_up_str, v_down_str, mix;

						u_down_str = ux[iz][iy][ix] / (0.5 * (uvh[iz][iy][ix]));
						v_down_str = vx[iz][iy][ix] / (0.5 * (uvh[iz][iy][ix]));

						u_up_str = (ux[iz + 1][iy][ix] - ux[iz][iy][ix]) /
							(0.5 * (uvh[iz + 1][iy][ix] + uvh[iz][iy][ix]));
						v_up_str = (vx[iz + 1][iy][ix] - vx[iz][iy][ix]) /
							(0.5 * (uvh[iz + 1][iy][ix] + uvh[iz][iy][ix]));

						u_down_str *= kuv[iz][iy][ix];
						v_down_str *= kuv[iz][iy][ix];
						u_up_str *= kuv[iz + 1][iy][ix];
						v_up_str *= kuv[iz + 1][iy][ix];

						mix = delt_spl / uvh[iz][iy][ix];
						mix_u[iz][iy][ix] = mix * (u_up_str - u_down_str);
						mix_v[iz][iy][ix] = mix * (v_up_str - v_down_str);
					}
/* mix scalars */
					if InWater(h[iz][iy][ix])
					{
						float t_up_str, s_up_str, a_up_str, tr_up_str[NumTracers], scmix;

						t_up_str = (tx[iz + 1][iy][ix] - tx[iz][iy][ix]) /
							(0.5 * (h[iz + 1][iy][ix] + h[iz][iy][ix]));
						s_up_str = (sx[iz + 1][iy][ix] - sx[iz][iy][ix]) /
							(0.5 * (h[iz + 1][iy][ix] + h[iz][iy][ix]));
						a_up_str = (ax[iz + 1][iy][ix] - ax[iz][iy][ix]) /
							(0.5 * (h[iz + 1][iy][ix] + h[iz][iy][ix]));

						for (it = 0; it < NumTracers; it++)
						{
							tr_up_str[it] = (trx[it][iz + 1][iy][ix] - trx[it][iz][iy][ix]) /
								(0.5 * (h[iz + 1][iy][ix] + h[iz][iy][ix]));
						}

						t_up_str *= kts[iz + 1][iy][ix];
						s_up_str *= kts[iz + 1][iy][ix];
						a_up_str *= kts[iz + 1][iy][ix];

						for (it = 0; it < NumTracers; it++)
						{
							tr_up_str[it] *= kts[iz + 1][iy][ix];
						}

						scmix = delt_spl / h[iz][iy][ix];
						mix_t[iz][iy][ix] = scmix * (t_up_str);
						mix_s[iz][iy][ix] = scmix * (s_up_str);
						mix_a[iz][iy][ix] = scmix * (a_up_str);

						for (it = 0; it < NumTracers; it++)
						{
							mix_tr[it][iz][iy][ix] = scmix * (tr_up_str[it]);
						}
					}
				}
			}
		}

		iz = Nz - 1;	/* Top level */
		{
			for (iy = 1; iy < My - 1; iy++)
			{
				for (ix = 1; ix < Mx - 1; ix++)
				{
					if InWater(uvh[iz][iy][ix])
					{
						float u_down_str, v_down_str, mix;

						if InWater(uvh[iz - 1][iy][ix])
							{
								u_down_str = (ux[iz][iy][ix] - ux[iz - 1][iy][ix]) /
								(0.5 * (uvh[iz][iy][ix] + uvh[iz - 1][iy][ix]));
								v_down_str = (vx[iz][iy][ix] - vx[iz - 1][iy][ix]) /
								(0.5 * (uvh[iz][iy][ix] + uvh[iz - 1][iy][ix]));
						}
						else
						{
							u_down_str = ux[iz][iy][ix] / (0.5 * (uvh[iz][iy][ix]));
							v_down_str = vx[iz][iy][ix] / (0.5 * (uvh[iz][iy][ix]));
						}

						u_down_str *= kuv[iz][iy][ix];
						v_down_str *= kuv[iz][iy][ix];

						mix = delt_spl / uvh[iz][iy][ix];
						mix_u[iz][iy][ix] = mix * (-u_down_str);
						mix_v[iz][iy][ix] = mix * (-v_down_str);
					}
/* mix scalars */
					if InWater(h[iz][iy][ix])
					{
						float t_down_str, s_down_str, a_down_str, tr_down_str[NumTracers], scmix;

						if InWater(h[iz - 1][iy][ix])
						{
							t_down_str = (tx[iz][iy][ix] - tx[iz - 1][iy][ix]) /
								(0.5 * (h[iz][iy][ix] + h[iz - 1][iy][ix]));
							s_down_str = (sx[iz][iy][ix] - sx[iz - 1][iy][ix]) /
								(0.5 * (h[iz][iy][ix] + h[iz - 1][iy][ix]));
							a_down_str = (ax[iz][iy][ix] - ax[iz - 1][iy][ix]) /
								(0.5 * (h[iz][iy][ix] + h[iz - 1][iy][ix]));

							for (it = 0; it < NumTracers; it++)
							{
								tr_down_str[it] = (trx[it][iz][iy][ix] - trx[it][iz - 1][iy][ix]) /
									(0.5 * (h[iz][iy][ix] + h[iz - 1][iy][ix]));
							}
						}
						else
						{
							t_down_str = 0.0;
							s_down_str = 0.0;
							a_down_str = 0.0;

							for (it = 0; it < NumTracers; it++) tr_down_str[it] = 0.0;
						}

						t_down_str *= kts[iz][iy][ix];
						s_down_str *= kts[iz][iy][ix];
						a_down_str *= kts[iz][iy][ix];

						for (it = 0; it < NumTracers; it++)
						{
							tr_down_str[it] *= kts[iz][iy][ix];
						}

						scmix = delt_spl / h[iz][iy][ix];
						mix_t[iz][iy][ix] = scmix * (-t_down_str);
						mix_s[iz][iy][ix] = scmix * (-s_down_str);
						mix_a[iz][iy][ix] = scmix * (-a_down_str);

						for (it = 0; it < NumTracers; it++)
						{
							mix_tr[it][iz][iy][ix] = scmix * (-tr_down_str[it]);
						}
					}
				}
			}
		}

		for (iz = 0; iz < Mz; iz++)		/* mixing update */
		{
			for (iy = 1; iy < My - 1; iy++)
			{
				for (ix = 1; ix < Mx - 1; ix++)
				{
					if InWater(uvh[iz][iy][ix])
					{
						ux[iz][iy][ix] += mix_u[iz][iy][ix];
						vx[iz][iy][ix] += mix_v[iz][iy][ix];
					}
/* mix scalars */
					if InWater(h[iz][iy][ix])
					{
						tx[iz][iy][ix] += mix_t[iz][iy][ix];
						sx[iz][iy][ix] += mix_s[iz][iy][ix];
						ax[iz][iy][ix] += mix_a[iz][iy][ix];

						for (it = 0; it < NumTracers; it++)
						{
							trx[it][iz][iy][ix] += mix_tr[it][iz][iy][ix];
						}
					}
				}
			}
		}
		wrap_qz_wall_d (ux,-1.0,-1.0,1.0,1.0);
		wrap_qz_wall_d (vx,1.0,1.0,-1.0,-1.0);
		wrap_qz_wall_d (tx,1.0,1.0,1.0,1.0);
		wrap_qz_wall_d (sx,1.0,1.0,1.0,1.0);
		wrap_qz_wall_d (ax,1.0,1.0,1.0,1.0);

		for (it = 0; it < NumTracers; it++)
		{
			wrap_qz_wall_d(trx[it],1.0,1.0,1.0,1.0);
		}
	}			/* end timesplit part */

	for (iz = 0; iz < Mz; iz++)	/* calculate full pressure field for diagnostics */
	{
		for (iy = 1; iy < My - 1; iy++)
		{
			for (ix = 1; ix < Mx - 1; ix++)
			{
				p[iz][iy][ix] += ptopx[iy][ix];
			}
		}
	}

	for (iy = 0; iy < My; iy++)	/* convective adjustment */
	{
		for (ix = 0; ix < Mx; ix++)
		{
			int mixing, pass_count;

			mixing = 1;
			pass_count = 0;
			while (mixing && (pass_count++ < Nz))
			{
				mixing = 0;
				for (iz = Mz - 2; iz >= 0; iz--)
				{
					float d1, d2, snew, tnew, anew, trnew[NumTracers];
					if (InWater(h[iz][iy][ix]) && InWater(h[iz + 1][iy][ix]))
					{
						d1 = density (sx[iz][iy][ix], tx[iz][iy][ix], 0.0);
						d2 = density (sx[iz + 1][iy][ix], tx[iz + 1][iy][ix], 0.0);
						if (d2 > (d1 + 1.0e-5))
						{
							mixing = 1;

							snew = (sx[iz][iy][ix] * h[iz][iy][ix] +
								sx[iz + 1][iy][ix] * h[iz + 1][iy][ix]) /
							(h[iz][iy][ix] + h[iz + 1][iy][ix]);
							sx[iz][iy][ix] = sx[iz + 1][iy][ix] = snew;

							tnew = (tx[iz][iy][ix] * h[iz][iy][ix] +
								tx[iz + 1][iy][ix] * h[iz + 1][iy][ix]) /
							(h[iz][iy][ix] + h[iz + 1][iy][ix]);
							tx[iz][iy][ix] = tx[iz + 1][iy][ix] = tnew;

							anew = (ax[iz][iy][ix] * h[iz][iy][ix] +
								ax[iz + 1][iy][ix] * h[iz + 1][iy][ix]) /
							(h[iz][iy][ix] + h[iz + 1][iy][ix]);
							ax[iz][iy][ix] = ax[iz + 1][iy][ix] = anew;

							for (it = 0; it < NumTracers; it++)
							{
								trnew[it] = (trx[it][iz][iy][ix] * h[iz][iy][ix] +
									trx[it][iz + 1][iy][ix] * h[iz + 1][iy][ix]) /
								(h[iz][iy][ix] + h[iz + 1][iy][ix]);
								trx[it][iz][iy][ix] = trx[it][iz + 1][iy][ix] = trnew[it];
							}
						}
					}
				}
			}
		}
	}

/* Fourth order space filter */

	filt4m_wall_d (ux,-1.0,-1.0,1.0,1.0);
	filt4m_wall_d (vx,1.0,1.0,-1.0,-1.0);
	filt4s_wall_d (tx,1.0,1.0,1.0,1.0);
	filt4s_wall_d (sx,1.0,1.0,1.0,1.0);
	filt4s_wall_d (ax,1.0,1.0,1.0,1.0);

	for (it = 0; it < NumTracers; it++)
	{
		filt4s_wall_d (trx[it],1.0,1.0,1.0,1.0);
	}


/* Time filter */

	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 0; iy < My; iy++)
		{
			for (ix = 0; ix < Mx; ix++)
			{
				ul[iz][iy][ix] = 0.65 * u[iz][iy][ix]
				+ 0.175 * (ul[iz][iy][ix] + ux[iz][iy][ix]);
				u[iz][iy][ix] = ux[iz][iy][ix];

				vl[iz][iy][ix] = 0.65 * v[iz][iy][ix]
				+ 0.175 * (vl[iz][iy][ix] + vx[iz][iy][ix]);
				v[iz][iy][ix] = vx[iz][iy][ix];

				tl[iz][iy][ix] = 0.65 * t[iz][iy][ix]
				+ 0.175 * (tl[iz][iy][ix] + tx[iz][iy][ix]);
				t[iz][iy][ix] = tx[iz][iy][ix];

				sl[iz][iy][ix] = 0.65 * s[iz][iy][ix]
				+ 0.175 * (sl[iz][iy][ix] + sx[iz][iy][ix]);
				s[iz][iy][ix] = sx[iz][iy][ix];

				/* orf test */
				if (freshwater[iy][ix])
				{
					sl[iz][iy][ix] -= 0.03 * sl[iz][iy][ix];
					s[iz][iy][ix] -= 0.03 * s[iz][iy][ix];
				}

				al[iz][iy][ix] = 0.65 * a[iz][iy][ix]
				+ 0.175 * (al[iz][iy][ix] + ax[iz][iy][ix]);
				a[iz][iy][ix] = ax[iz][iy][ix];

				for (it = 0; it < NumTracers; it++)
				{
					trl[it][iz][iy][ix] = 0.65 * tr[it][iz][iy][ix]
					+ 0.175 * (trl[it][iz][iy][ix] + trx[it][iz][iy][ix]);
					tr[it][iz][iy][ix] = trx[it][iz][iy][ix];
				}
			}
		}
	}

	for (iy = 0; iy < My; iy++)
	{
		for (ix = 0; ix < Mx; ix++)
		{
			ptopl[iy][ix] = 0.65 * ptop[iy][ix]
			+ 0.175 * (ptopl[iy][ix] + ptopx[iy][ix]);
			ptop[iy][ix] = ptopx[iy][ix];

			if(freshwater[iy][ix])
			{
				ptopl[iy][ix] = pfac;
				ptop[iy][ix] = pfac;
			}
		}
	}
	tidal_boundary(ptopl,run_time);
	tidal_boundary(ptop,run_time);
}

