#include <stdio.h>
#include <math.h>
#include "defines.h"
#include "externvars.h"
#include "routines.h"

/* 1st 2 days, no wind stress
 * next day, ramp up to maximum wind stress
 * next 2 days keep max wind stress
 * next day ramp down to no wind stress
 *
 * let's roughly mimic Floyd moving from the south to the north 
 * passing to the east of the cbay
 * winds start out easterly, then northerly, then westerly
 * Note... wind stress is constant for all grid values, assumes
 * storm is much bigger than bay
 */

void calculate_wind_stress(double time)
{
	int ix, iy;
	float day = 60.0 * 60.0 * 24.0;
	float ramp1, peak1, peak2, ramp2;
	float max_amp = 0.0012; /* maximum wind stress */
	float amp;
	float ustr, vstr;
	float pi = 3.1415926545;
	float c1;

	ramp1 = 1.0 * day; /* start 1st ramp up at 2 days */
	peak1 = 2.0 * day; /* max wind stress starts at 3 days */
	peak2 = 5.0 * day; /* max wind stress ends at 5 days */
	ramp2 = 6.0 * day; /* end 2nd ramp down at 6 days */

	amp = 0.0; /* no wind stress 1st 2 days */
	
	if (time >= ramp1)
		c1 = pi * (time-ramp1)/(ramp2-ramp1);
	else c1 = 0.0;

	ustr = -cos(c1);
	vstr = -sin(c1);

	if (time >= ramp1)
	{
		amp = max_amp * (time-ramp1)/day; /* linearly ramp up to max wind stress */
	}
	if (time > peak1)
	{
		amp = max_amp; /* hold max */
	}
	if (time > peak2)
	{
		amp = max_amp * (1.0-((time-peak2)/day)); /* linearly ramp down to 0 */
	}

	if (time > ramp2) amp = 0.0;
	
	if (my_address==0)
	printf("time = %f amp = %f ustr = %f, vstr = %f taux = %f tauy = %f\n",(float)time,amp,ustr,vstr,amp*ustr,amp*vstr);

	for (iy = 0; iy < My; iy++)
	{
		for (ix = 0; ix < Mx; ix++)
		{
			taux[iy][ix] = amp * ustr;
			tauy[iy][ix] = amp * vstr;
		}
	}
}

