#include <stdio.h>
#include <math.h>
#include <mpi.h>
#include "defines.h"
#include "externvars.h"
#include "routines.h"

/*
float in_xz[Mz][Mx], out_xz[Mz][Mx];
float in_yz[Mz][My], out_yz[Mz][My];
float in_3x[3][Mx], out_3x[3][Mx];
float in_3y[3][My], out_3y[3][My];
*/

extern MPI_Datatype mpi_edge_type;

void 
wrap_qz_wall_d (float ***a, float cwest, float ceast, float csouth, float cnorth)
{
	int ix, iy, iz;
	int tag = 0;

/* rec from south, send north */
	for (iz = 0; iz < Mz; iz++)
	{
		for (ix = 0; ix < Mx; ix++)
		{
			out_xz[iz][ix] = a[iz][My - 2][ix];
		}
	}
	send_and_receive (south, tag, (void *) &(in_xz[0][0]), Mx * Mz * sizeof (float), north, (void *) &(out_xz[0][0]));
	if (row != 0)
	{
		for (iz = 0; iz < Mz; iz++)
		{
			for (ix = 0; ix < Mx; ix++)
			{
				a[iz][0][ix] = in_xz[iz][ix];
			}
		}
	}
	else
	{
		for (iz = 0; iz < Mz; iz++)
		{
			for (ix = 0; ix < Mx; ix++)
			{
				a[iz][0][ix] = csouth * a[iz][2][ix];
			}
		}
	}


/* rec from north, send south */
	for (iz = 0; iz < Mz; iz++)
	{
		for (ix = 0; ix < Mx; ix++)
		{
			out_xz[iz][ix] = a[iz][1][ix];
		}
	}
	send_and_receive (north, tag, (void *) &(in_xz[0][0]), Mx * Mz * sizeof (float), south, (void *) &(out_xz[0][0]));
	if (row != Nrows-1)
	{
		for (iz = 0; iz < Mz; iz++)
		{
			for (ix = 0; ix < Mx; ix++)
			{
				a[iz][My - 1][ix] = in_xz[iz][ix];
			}
		}
	}
	else
	{
		for (iz = 0; iz < Mz; iz++)
		{
			for (ix = 0; ix < Mx; ix++)
			{
				a[iz][My - 1][ix] = cnorth * a[iz][My - 3][ix];
			}
		}
	}


/* rec from west, send east */
	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 0; iy < My; iy++)
		{
			out_yz[iz][iy] = a[iz][iy][Mx - 2];
		}
	}
	send_and_receive (west, tag, (void *) &(in_yz[0][0]), My * Mz * sizeof (float), east, (void *) &(out_yz[0][0]));
	if (col != 0)
	{
		for (iz = 0; iz < Mz; iz++)
		{
			for (iy = 0; iy < My; iy++)
			{
				a[iz][iy][0] = in_yz[iz][iy];
			}
		}
	}
	else
	{
		for (iz = 0; iz < Mz; iz++)
		{
			for (iy = 0; iy < My; iy++)
			{
				a[iz][iy][0] = cwest * a[iz][iy][2];
			}
		}
	}


/* rec from east, send west */
	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 0; iy < My; iy++)
		{
			out_yz[iz][iy] = a[iz][iy][1];
		}
	}
	send_and_receive (east, tag, (void *) &(in_yz[0][0]), My * Mz * sizeof (float), west, (void *) &(out_yz[0][0]));
	if (col != Ncols-1)
	{
		for (iz = 0; iz < Mz; iz++)
		{
			for (iy = 0; iy < My; iy++)
			{
				a[iz][iy][Mx - 1] = in_yz[iz][iy];
			}
		}
	}
	else
	{
		for (iz = 0; iz < Mz; iz++)
		{
			for (iy = 0; iy < My; iy++)
			{
				a[iz][iy][Mx - 1] = ceast * a[iz][iy][Mx -3];
			}
		}
	}
}

void 
wrap_q3_wall_d (float **a, float **b, float **c,
		float a_cwest, float a_ceast, float a_csouth, float a_cnorth,
		float b_cwest, float b_ceast, float b_csouth, float b_cnorth,
		float c_cwest, float c_ceast, float c_csouth, float c_cnorth)
{
	int ix, iy;
	int tag = 0;

/* rec from south, send north */
	for (ix = 0; ix < Mx; ix++)
	{
		out_3x[0][ix] = a[My - 2][ix];
		out_3x[1][ix] = b[My - 2][ix];
		out_3x[2][ix] = c[My - 2][ix];
	}
	send_and_receive (south, tag, (void *) &(in_3x[0][0]), Mx * 3 * sizeof (float), north, (void *) &(out_3x[0][0]));
	if (row != 0)
	{
		for (ix = 0; ix < Mx; ix++)
		{
			a[0][ix] = in_3x[0][ix];
			b[0][ix] = in_3x[1][ix];
			c[0][ix] = in_3x[2][ix];
		}
	}
	else
	{
		for (ix = 0; ix < Mx; ix++)
		{
			a[0][ix] = a_csouth * a[2][ix];
			b[0][ix] = b_csouth * b[2][ix];
			c[0][ix] = c_csouth * c[2][ix];
		}
	}

/* rec from north, send south */
	for (ix = 0; ix < Mx; ix++)
	{
		out_3x[0][ix] = a[1][ix];
		out_3x[1][ix] = b[1][ix];
		out_3x[2][ix] = c[1][ix];
	}
	send_and_receive (north, tag, (void *) &(in_3x[0][0]), Mx * 3 * sizeof (float), south, (void *) &(out_3x[0][0]));
	if (row != Nrows-1)
	{
		for (ix = 0; ix < Mx; ix++)
		{
			a[My - 1][ix] = in_3x[0][ix];
			b[My - 1][ix] = in_3x[1][ix];
			c[My - 1][ix] = in_3x[2][ix];
		}
	}
	else
	{
		for (ix = 0; ix < Mx; ix++)
		{
			a[My - 1][ix] = a_cnorth * a[My -3][ix];
			b[My - 1][ix] = b_cnorth * b[My -3][ix];
			c[My - 1][ix] = c_cnorth * c[My -3][ix];
		}
	}


/* rec from west, send east */
	for (iy = 0; iy < My; iy++)
	{
		out_3y[0][iy] = a[iy][Mx - 2];
		out_3y[1][iy] = b[iy][Mx - 2];
		out_3y[2][iy] = c[iy][Mx - 2];
	}
	send_and_receive (west, tag, (void *) &(in_3y[0][0]), My * 3 * sizeof (float), east, (void *) &(out_3y[0][0]));
	if (col != 0)
	{
		for (iy = 0; iy < My; iy++)
		{
			a[iy][0] = in_3y[0][iy];
			b[iy][0] = in_3y[1][iy];
			c[iy][0] = in_3y[2][iy];
		}
	}
	else
	{
		for (iy = 0; iy < My; iy++)
		{
			a[iy][0] = a_cwest * a[iy][2];
			b[iy][0] = b_cwest * b[iy][2];
			c[iy][0] = c_cwest * c[iy][2];
		}
	}


/* rec from east, send west */
	for (iy = 0; iy < My; iy++)
	{
		out_3y[0][iy] = a[iy][1];
		out_3y[1][iy] = b[iy][1];
		out_3y[2][iy] = c[iy][1];
	}
	send_and_receive (east, tag, (void *) &(in_3y[0][0]), My * 3 * sizeof (float), west, (void *) &(out_3y[0][0]));
	if (col != Ncols-1)
	{
		for (iy = 0; iy < My; iy++)
		{
			a[iy][Mx - 1] = in_3y[0][iy];
			b[iy][Mx - 1] = in_3y[1][iy];
			c[iy][Mx - 1] = in_3y[2][iy];
		}
	}
	else
	{
		for (iy = 0; iy < My; iy++)
		{
			a[iy][Mx - 1] = a_ceast * a[iy][Mx -3];
			b[iy][Mx - 1] = b_ceast * b[iy][Mx -3];
			c[iy][Mx - 1] = c_ceast * c[iy][Mx -3];
		}
	}
}

void 
wrap_q_wall_d (float **a,float cwest,float ceast,float csouth,float cnorth)
{
	int msg_len, tag = 0, ellen = 0, elcnt = 0, stride = 0;
	char *msg_in, *msg_out;
	int ix, iy;

	msg_len = Mx * sizeof (float);

	msg_in = (void *) &(a[0][0]);	/* rec from south, send north */
	msg_out = (void *) &(a[My - 2][0]);

	send_and_receive (south, tag, msg_in, msg_len, north, msg_out);

	msg_in = (void *) &(a[My - 1][0]);	/* rec from north, send south */
	msg_out = (void *) &(a[1][0]);

	send_and_receive (north, tag, msg_in, msg_len, south, msg_out);

	msg_in = (void *) &(a[0][0]);	/* rec from west, send east */
	msg_out = (void *) &(a[0][Mx - 2]);
/* 
 * defined in mpi_edge_type
 *
 * ellen = sizeof(float);
 * elcnt = My;
 * stride = Mx * ellen;
 */

	send_and_receive_v (west, tag, msg_in, ellen, stride, elcnt, east, msg_out);

	msg_in = (void *) &(a[0][Mx - 1]);
	msg_out = (void *) &(a[0][1]);
/* 
 * defined in mpi_edge_type
 *
 * ellen = sizeof(float);
 * elcnt = My;
 * stride = Mx * ellen;
 */

	send_and_receive_v (east, tag, msg_in, ellen, stride, elcnt, west, msg_out);

	if (row == 0)
		for (ix = 0; ix < Mx; ix++) a[0][ix] = csouth * a[2][ix];
	if (row == Nrows-1)
		for (ix = 0; ix < Mx; ix++) a[My - 1][ix] = cnorth * a[My - 3][ix];
	if (col == 0)
		for (iy = 0; iy < My; iy++) a[iy][0] = cwest * a[iy][2];
	if (col == Ncols-1)
		for (iy = 0; iy < My; iy++) a[iy][Mx - 1] = ceast * a[iy][Mx - 3];

}

void
send_and_receive (
		int source_node, int tag, void *inbuffer, int buf_len,
		int dest_node, void *outbuffer)
{
	MPI_Status status;
	int result;
/*
#ifdef DEBUG
	if (source_node != dest_node)
	{
		printf ("error: OM3 SEND_RECEIVE: Source and dest node differ: %d %d\n",
			source_node, dest_node);
		exit (1);
	}
#endif
*/
	result = MPI_Sendrecv (outbuffer, buf_len, MPI_CHAR, dest_node, tag,
		  inbuffer, buf_len, MPI_CHAR, source_node, tag,
		  MPI_COMM_WORLD, &status);

	if (result != MPI_SUCCESS)
	{
		printf ("error: OM3 SEND_RECEIVE: Return code %d\n", result);
		exit (1);
	}
}

void
send_and_receive_v (
		  int source_node, int tag, void *inbuffer,
		  int elem_len, int stride, int elem_count,
		  int dest_node, void *outbuffer)
{
	MPI_Status status;
	int result;

#ifdef DEBUG
	if (source_node != dest_node)
	{
		printf ("error: OM3 SEND_RECEIVE_V: Source and dest node differ: %d %d\n",
			source_node, dest_node);
		exit (1);
	}
#endif

	result = MPI_Sendrecv (outbuffer, 1, mpi_edge_type, dest_node, tag,
		  inbuffer, 1, mpi_edge_type, source_node, tag,
		  MPI_COMM_WORLD, &status);

	if (result != MPI_SUCCESS)
	{
		printf ("error: OM3 SEND_RECEIVE_V: Return code %d\n", result);
		exit (1);
	}
}

/* End sp2 communications routines */


#ifdef OLD

void 
wrap_q_wall (float a[My][Mx],float cwest,float ceast,float csouth,float cnorth)
{
	int msg_len, tag = 0, ellen = 0, elcnt = 0, stride = 0;
	char *msg_in, *msg_out;
	int ix, iy;

	msg_len = Mx * sizeof (float);

	msg_in = (void *) &(a[0][0]);	/* rec from south, send north */
	msg_out = (void *) &(a[My - 2][0]);

	send_and_receive (south, tag, msg_in, msg_len, north, msg_out);

	msg_in = (void *) &(a[My - 1][0]);	/* rec from north, send south */
	msg_out = (void *) &(a[1][0]);

	send_and_receive (north, tag, msg_in, msg_len, south, msg_out);

	msg_in = (void *) &(a[0][0]);	/* rec from west, send east */
	msg_out = (void *) &(a[0][Mx - 2]);
/* 
 * defined in mpi_edge_type
 *
 * ellen = sizeof(float);
 * elcnt = My;
 * stride = Mx * ellen;
 */

	send_and_receive_v (west, tag, msg_in, ellen, stride, elcnt, east, msg_out);

	msg_in = (void *) &(a[0][Mx - 1]);
	msg_out = (void *) &(a[0][1]);
/* 
 * defined in mpi_edge_type
 *
 * ellen = sizeof(float);
 * elcnt = My;
 * stride = Mx * ellen;
 */

	send_and_receive_v (east, tag, msg_in, ellen, stride, elcnt, west, msg_out);

	if (row == 0)
		for (ix = 0; ix < Mx; ix++) a[0][ix] = csouth * a[2][ix];
	if (row == Nrows-1)
		for (ix = 0; ix < Mx; ix++) a[My - 1][ix] = cnorth * a[My - 3][ix];
	if (col == 0)
		for (iy = 0; iy < My; iy++) a[iy][0] = cwest * a[iy][2];
	if (col == Ncols-1)
		for (iy = 0; iy < My; iy++) a[iy][Mx - 1] = ceast * a[iy][Mx - 3];

}
void 
wrap_qz (float a[Mz][My][Mx])
{
	int ix, iy, iz;
	int tag = 0;

/* rec from south, send north */
	for (iz = 0; iz < Mz; iz++)
	{
		for (ix = 0; ix < Mx; ix++)
		{
			out_xz[iz][ix] = a[iz][My - 2][ix];
		}
	}
	send_and_receive (south, tag, in_xz, Mx * Mz * sizeof (float), north, out_xz);
	for (iz = 0; iz < Mz; iz++)
	{
		for (ix = 0; ix < Mx; ix++)
		{
			a[iz][0][ix] = in_xz[iz][ix];
		}
	}

/* rec from north, send south */
	for (iz = 0; iz < Mz; iz++)
	{
		for (ix = 0; ix < Mx; ix++)
		{
			out_xz[iz][ix] = a[iz][1][ix];
		}
	}
	send_and_receive (north, tag, in_xz, Mx * Mz * sizeof (float), south, out_xz);
	for (iz = 0; iz < Mz; iz++)
	{
		for (ix = 0; ix < Mx; ix++)
		{
			a[iz][My - 1][ix] = in_xz[iz][ix];
		}
	}

/* rec from west, send east */
	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 0; iy < My; iy++)
		{
			out_yz[iz][iy] = a[iz][iy][Mx - 2];
		}
	}
	send_and_receive (west, tag, in_yz, My * Mz * sizeof (float), east, out_yz);
	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 0; iy < My; iy++)
		{
			a[iz][iy][0] = in_yz[iz][iy];
		}
	}

/* rec from east, send west */
	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 0; iy < My; iy++)
		{
			out_yz[iz][iy] = a[iz][iy][1];
		}
	}
	send_and_receive (east, tag, in_yz, My * Mz * sizeof (float), west, out_yz);
	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 0; iy < My; iy++)
		{
			a[iz][iy][Mx - 1] = in_yz[iz][iy];
		}
	}
}
void 
wrap_qz_wall (float a[Mz][My][Mx], float cwest, float ceast, float csouth, float cnorth)
{
	int ix, iy, iz;
	int tag = 0;

/* rec from south, send north */
	for (iz = 0; iz < Mz; iz++)
	{
		for (ix = 0; ix < Mx; ix++)
		{
			out_xz[iz][ix] = a[iz][My - 2][ix];
		}
	}
	send_and_receive (south, tag, in_xz, Mx * Mz * sizeof (float), north, out_xz);
	if (row != 0)
	{
		for (iz = 0; iz < Mz; iz++)
		{
			for (ix = 0; ix < Mx; ix++)
			{
				a[iz][0][ix] = in_xz[iz][ix];
			}
		}
	}
	else
	{
		for (iz = 0; iz < Mz; iz++)
		{
			for (ix = 0; ix < Mx; ix++)
			{
				a[iz][0][ix] = csouth * a[iz][2][ix];
			}
		}
	}


/* rec from north, send south */
	for (iz = 0; iz < Mz; iz++)
	{
		for (ix = 0; ix < Mx; ix++)
		{
			out_xz[iz][ix] = a[iz][1][ix];
		}
	}
	send_and_receive (north, tag, in_xz, Mx * Mz * sizeof (float), south, out_xz);
	if (row != Nrows-1)
	{
		for (iz = 0; iz < Mz; iz++)
		{
			for (ix = 0; ix < Mx; ix++)
			{
				a[iz][My - 1][ix] = in_xz[iz][ix];
			}
		}
	}
	else
	{
		for (iz = 0; iz < Mz; iz++)
		{
			for (ix = 0; ix < Mx; ix++)
			{
				a[iz][My - 1][ix] = cnorth * a[iz][My - 3][ix];
			}
		}
	}


/* rec from west, send east */
	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 0; iy < My; iy++)
		{
			out_yz[iz][iy] = a[iz][iy][Mx - 2];
		}
	}
	send_and_receive (west, tag, in_yz, My * Mz * sizeof (float), east, out_yz);
	if (col != 0)
	{
		for (iz = 0; iz < Mz; iz++)
		{
			for (iy = 0; iy < My; iy++)
			{
				a[iz][iy][0] = in_yz[iz][iy];
			}
		}
	}
	else
	{
		for (iz = 0; iz < Mz; iz++)
		{
			for (iy = 0; iy < My; iy++)
			{
				a[iz][iy][0] = cwest * a[iz][iy][2];
			}
		}
	}


/* rec from east, send west */
	for (iz = 0; iz < Mz; iz++)
	{
		for (iy = 0; iy < My; iy++)
		{
			out_yz[iz][iy] = a[iz][iy][1];
		}
	}
	send_and_receive (east, tag, in_yz, My * Mz * sizeof (float), west, out_yz);
	if (col != Ncols-1)
	{
		for (iz = 0; iz < Mz; iz++)
		{
			for (iy = 0; iy < My; iy++)
			{
				a[iz][iy][Mx - 1] = in_yz[iz][iy];
			}
		}
	}
	else
	{
		for (iz = 0; iz < Mz; iz++)
		{
			for (iy = 0; iy < My; iy++)
			{
				a[iz][iy][Mx - 1] = ceast * a[iz][iy][Mx -3];
			}
		}
	}
}


void 
wrap_q3 (float a[My][Mx], float b[My][Mx], float c[My][Mx])
{
	int ix, iy;
	int tag = 0;

/* rec from south, send north */
	for (ix = 0; ix < Mx; ix++)
	{
		out_3x[0][ix] = a[My - 2][ix];
		out_3x[1][ix] = b[My - 2][ix];
		out_3x[2][ix] = c[My - 2][ix];
	}
	send_and_receive (south, tag, in_3x, Mx * 3 * sizeof (float), north, out_3x);
	for (ix = 0; ix < Mx; ix++)
	{
		a[0][ix] = in_3x[0][ix];
		b[0][ix] = in_3x[1][ix];
		c[0][ix] = in_3x[2][ix];
	}

/* rec from north, send south */
	for (ix = 0; ix < Mx; ix++)
	{
		out_3x[0][ix] = a[1][ix];
		out_3x[1][ix] = b[1][ix];
		out_3x[2][ix] = c[1][ix];
	}
	send_and_receive (north, tag, in_3x, Mx * 3 * sizeof (float), south, out_3x);
	for (ix = 0; ix < Mx; ix++)
	{
		a[My - 1][ix] = in_3x[0][ix];
		b[My - 1][ix] = in_3x[1][ix];
		c[My - 1][ix] = in_3x[2][ix];
	}

/* rec from west, send east */
	for (iy = 0; iy < My; iy++)
	{
		out_3y[0][iy] = a[iy][Mx - 2];
		out_3y[1][iy] = b[iy][Mx - 2];
		out_3y[2][iy] = c[iy][Mx - 2];
	}
	send_and_receive (west, tag, in_3y, My * 3 * sizeof (float), east, out_3y);
	for (iy = 0; iy < My; iy++)
	{
		a[iy][0] = in_3y[0][iy];
		b[iy][0] = in_3y[1][iy];
		c[iy][0] = in_3y[2][iy];
	}

/* rec from east, send west */
	for (iy = 0; iy < My; iy++)
	{
		out_3y[0][iy] = a[iy][1];
		out_3y[1][iy] = b[iy][1];
		out_3y[2][iy] = c[iy][1];
	}
	send_and_receive (east, tag, in_3y, My * 3 * sizeof (float), west, out_3y);
	for (iy = 0; iy < My; iy++)
	{
		a[iy][Mx - 1] = in_3y[0][iy];
		b[iy][Mx - 1] = in_3y[1][iy];
		c[iy][Mx - 1] = in_3y[2][iy];
	}
}
void 
wrap_q3_wall (float a[My][Mx], float b[My][Mx], float c[My][Mx],
		float a_cwest, float a_ceast, float a_csouth, float a_cnorth,
		float b_cwest, float b_ceast, float b_csouth, float b_cnorth,
		float c_cwest, float c_ceast, float c_csouth, float c_cnorth)
{
	int ix, iy;
	int tag = 0;

/* rec from south, send north */
	for (ix = 0; ix < Mx; ix++)
	{
		out_3x[0][ix] = a[My - 2][ix];
		out_3x[1][ix] = b[My - 2][ix];
		out_3x[2][ix] = c[My - 2][ix];
	}
	send_and_receive (south, tag, in_3x, Mx * 3 * sizeof (float), north, out_3x);
	if (row != 0)
	{
		for (ix = 0; ix < Mx; ix++)
		{
			a[0][ix] = in_3x[0][ix];
			b[0][ix] = in_3x[1][ix];
			c[0][ix] = in_3x[2][ix];
		}
	}
	else
	{
		for (ix = 0; ix < Mx; ix++)
		{
			a[0][ix] = a_csouth * a[2][ix];
			b[0][ix] = b_csouth * b[2][ix];
			c[0][ix] = c_csouth * c[2][ix];
		}
	}

/* rec from north, send south */
	for (ix = 0; ix < Mx; ix++)
	{
		out_3x[0][ix] = a[1][ix];
		out_3x[1][ix] = b[1][ix];
		out_3x[2][ix] = c[1][ix];
	}
	send_and_receive (north, tag, in_3x, Mx * 3 * sizeof (float), south, out_3x);
	if (row != Nrows-1)
	{
		for (ix = 0; ix < Mx; ix++)
		{
			a[My - 1][ix] = in_3x[0][ix];
			b[My - 1][ix] = in_3x[1][ix];
			c[My - 1][ix] = in_3x[2][ix];
		}
	}
	else
	{
		for (ix = 0; ix < Mx; ix++)
		{
			a[My - 1][ix] = a_cnorth * a[My -3][ix];
			b[My - 1][ix] = b_cnorth * b[My -3][ix];
			c[My - 1][ix] = c_cnorth * c[My -3][ix];
		}
	}


/* rec from west, send east */
	for (iy = 0; iy < My; iy++)
	{
		out_3y[0][iy] = a[iy][Mx - 2];
		out_3y[1][iy] = b[iy][Mx - 2];
		out_3y[2][iy] = c[iy][Mx - 2];
	}
	send_and_receive (west, tag, in_3y, My * 3 * sizeof (float), east, out_3y);
	if (col != 0)
	{
		for (iy = 0; iy < My; iy++)
		{
			a[iy][0] = in_3y[0][iy];
			b[iy][0] = in_3y[1][iy];
			c[iy][0] = in_3y[2][iy];
		}
	}
	else
	{
		for (iy = 0; iy < My; iy++)
		{
			a[iy][0] = a_cwest * a[iy][2];
			b[iy][0] = b_cwest * b[iy][2];
			c[iy][0] = c_cwest * c[iy][2];
		}
	}


/* rec from east, send west */
	for (iy = 0; iy < My; iy++)
	{
		out_3y[0][iy] = a[iy][1];
		out_3y[1][iy] = b[iy][1];
		out_3y[2][iy] = c[iy][1];
	}
	send_and_receive (east, tag, in_3y, My * 3 * sizeof (float), west, out_3y);
	if (col != Ncols-1)
	{
		for (iy = 0; iy < My; iy++)
		{
			a[iy][Mx - 1] = in_3y[0][iy];
			b[iy][Mx - 1] = in_3y[1][iy];
			c[iy][Mx - 1] = in_3y[2][iy];
		}
	}
	else
	{
		for (iy = 0; iy < My; iy++)
		{
			a[iy][Mx - 1] = a_ceast * a[iy][Mx -3];
			b[iy][Mx - 1] = b_ceast * b[iy][Mx -3];
			c[iy][Mx - 1] = c_ceast * c[iy][Mx -3];
		}
	}
}

void 
wrap_q (a)
float a[My][Mx];
{
	int msg_len, tag = 0, ellen = 0, elcnt = 0, stride = 0;
	char *msg_in, *msg_out;

	msg_len = Mx * sizeof (float);

	msg_in = (void *) &(a[0][0]);	/* rec from south, send north */
	msg_out = (void *) &(a[My - 2][0]);

	send_and_receive (south, tag, msg_in, msg_len, north, msg_out);

	msg_in = (void *) &(a[My - 1][0]);	/* rec from north, send south */
	msg_out = (void *) &(a[1][0]);

	send_and_receive (north, tag, msg_in, msg_len, south, msg_out);

	msg_in = (void *) &(a[0][0]);	/* rec from west, send east */
	msg_out = (void *) &(a[0][Mx - 2]);
/* 
 * defined in mpi_edge_type
 *
 * ellen = sizeof(float);
 * elcnt = My;
 * stride = Mx * ellen;
 */

	send_and_receive_v (west, tag, msg_in, ellen, stride, elcnt, east, msg_out);

	msg_in = (void *) &(a[0][Mx - 1]);
	msg_out = (void *) &(a[0][1]);
/* 
 * defined in mpi_edge_type
 *
 * ellen = sizeof(float);
 * elcnt = My;
 * stride = Mx * ellen;
 */
	send_and_receive_v (east, tag, msg_in, ellen, stride, elcnt, west, msg_out);
}

#endif /* OLD */
