#include <stdio.h>
#include <math.h>
#include <mpi.h>
#include "defines.h"
#include "externvars.h"
#include "routines.h"

void 
write_history_d (float ***a)
{
	int iz;

	for (iz = 0; iz < Mz; iz++)
	{
		write_history_slice_d (a, iz);
	}
}

/*
unsigned char hist_out[My][Mx][2];
unsigned char row_out[Mx - 2][2];
*/

void 
write_history_slice_d (float ***a, int iz)
{
	int ix, iy, ival;
	float xx, lxmin, lxmax, xmin, xmax, scale;
	int jrow, jcol, jy;
	unsigned char *histptr, *rowptr;

	/*
	unsigned char ***hist_out = memalloc3duschar("hist_out",hist_out,My,Mx,2);
	unsigned char **row_out = memalloc2duschar ("row_out",row_out,Mx-2,2);
	*/
	unsigned char *hist_out = memalloc1duschar("hist_out",hist_out,My*Mx*2);
	unsigned char *row_out = memalloc1duschar ("row_out",row_out,(Mx-2)*2);

	MPI_Status status;
	int ierr;


	lxmin = 1.0e10;
	lxmax = -1.0e10;

	for (iy = 1; iy < My - 1; iy++)
	{
		for (ix = 1; ix < Mx - 1; ix++)
		{
			if InWater(h[iz][iy][ix])
			{
				xx = a[iz][iy][ix];
				if (xx < lxmin)
				lxmin = xx;
				if (xx > lxmax)
				lxmax = xx;
			}
		}
	}

	MPI_Allreduce (&lxmax, &xmax, 1, MPI_FLOAT, MPI_MAX, MPI_COMM_WORLD);
	MPI_Allreduce (&lxmin, &xmin, 1, MPI_FLOAT, MPI_MIN, MPI_COMM_WORLD);

	if (my_address == 0)
	{
		fprintf (hfile, "%f %f\n", xmin, xmax);
	}
	xx = xmax - xmin;
	if (xx < 1.0e-10)
	xx = 1.0e-10;
	scale = 60000.0 / xx;

	for (iy = 1; iy < My - 1; iy++)
	{
		for (ix = 1; ix < Mx - 1; ix++)
		{
			if InWater(h[iz][iy][ix])
			{
				xx = a[iz][iy][ix];
				/*
				if ((iz==Mz-1) && (my_address==0))printf("[%2i][%2i][%2i] %f\n",iz,iy,ix,xx);
				*/
				ival = 100 + scale * (xx - xmin);
			}
			else
			ival = 0;

			/*
			hist_out[iy][ix][0] = ival / 256;
			hist_out[iy][ix][1] = ival % 256;
			*/
/*
unsigned char hist_out[My][Mx][2];
unsigned char row_out[Mx - 2][2];
*/
#define POINT2(y,x,mx) ((y)*(mx)+(x))
#define POINT3(z,y,x,my,mx) (((z)*(mx)*(my))+((y)*(mx))+(x))

			hist_out[POINT3(iy,ix,0,Mx,2)] = ival / 256;
			hist_out[POINT3(iy,ix,1,Mx,2)] = ival % 256;
		}
	}
	for (jy = 0; jy < Ny; jy++)	/* write xy field in natural order */
	{
		jrow = jy / (My - 2);
		iy = jy - jrow * (My - 2) + 1;
		for (jcol = 0; jcol < Ncols; jcol++)	/* write in column order */
		{
			if ((col == jcol) && (row == jrow))		/* Select source processor */
			{
				histptr = &(hist_out[POINT3(iy,1,0,Mx,2)]);
				ierr = MPI_Bsend ((void *)histptr, 2 * (Mx - 2),
				  MPI_CHAR, 0, 99, MPI_COMM_WORLD);
				/*
				ierr = MPI_Bsend ((void *)&(hist_out[iy][1][0]), 2 * (Mx - 2),
				  MPI_CHAR, 0, 99, MPI_COMM_WORLD);
				*/
				if (ierr != 0)
				{
					printf ("error: OM3 Bsend error in write_history_slice: %d\n", ierr);
					fflush (of);
					exit (1);
				}
			}
			if (my_address == 0)
			{
				MPI_Recv ((void *)row_out, 2 * (Mx - 2), MPI_CHAR, jrow * Ncols + jcol,
				 99, MPI_COMM_WORLD, &status);
				/*
				MPI_Recv ((void *)&(row_out[0][0]), 2 * (Mx - 2), MPI_CHAR, jrow * Ncols + jcol,
				 99, MPI_COMM_WORLD, &status);
				*/
				fwrite (row_out, sizeof (char), 2 * (Mx - 2), hfile);
			}
			MPI_Barrier (MPI_COMM_WORLD);

		}
	}
	free(hist_out);
	free(row_out);
	/*
	free3d((void ***)hist_out,Mz);
	free2d((void **)row_out);
	*/
}

#ifdef OLD

void 
write_history_slice (float a[Mz][My][Mx], int iz)
{
	int ix, iy, ival;
	float xx, lxmin, lxmax, xmin, xmax, scale;
	int jrow, jcol, jy;

	unsigned char row_out[Mx - 2][2];
	unsigned char hist_out = memalloc3duschar("hist_out",hist_out,My,Mx,2);
	unsigned char row_out = memalloc2duschar ("row_out",row_out,Mx-2,2);
	MPI_Status status;
	int ierr;


	lxmin = 1.0e10;
	lxmax = -1.0e10;

	for (iy = 1; iy < My - 1; iy++)
	{
		for (ix = 1; ix < Mx - 1; ix++)
		{
			if InWater(h[iz][iy][ix])
			{
				xx = a[iz][iy][ix];
				if (xx < lxmin)
				lxmin = xx;
				if (xx > lxmax)
				lxmax = xx;
			}
		}
	}

	MPI_Allreduce (&lxmax, &xmax, 1, MPI_FLOAT, MPI_MAX, MPI_COMM_WORLD);
	MPI_Allreduce (&lxmin, &xmin, 1, MPI_FLOAT, MPI_MIN, MPI_COMM_WORLD);

	if (my_address == 0)
	{
		fprintf (hfile, "%f %f\n", xmin, xmax);
	}
	xx = xmax - xmin;
	if (xx < 1.0e-10)
	xx = 1.0e-10;
	scale = 60000.0 / xx;

	for (iy = 1; iy < My - 1; iy++)
	{
		for (ix = 1; ix < Mx - 1; ix++)
		{
			if InWater(h[iz][iy][ix])
			{
				xx = a[iz][iy][ix];
				ival = 100 + scale * (xx - xmin);
			}
			else
			ival = 0;

			hist_out[iy][ix][0] = ival / 256;
			hist_out[iy][ix][1] = ival % 256;
		}
	}
	for (jy = 0; jy < Ny; jy++)	/* write xy field in natural order */
	{
		jrow = jy / (My - 2);
		iy = jy - jrow * (My - 2) + 1;
		for (jcol = 0; jcol < Ncols; jcol++)	/* write in column order */
		{
			if ((col == jcol) && (row == jrow))		/* Select source processor */
			{
				ierr = MPI_Bsend (&(hist_out[iy][1][0]), 2 * (Mx - 2),
				  MPI_CHAR, 0, 99, MPI_COMM_WORLD);
				if (ierr != 0)
				{
					printf ("error: OM3 Bsend error in write_history_slice: %d\n", ierr);
					fflush (of);
					exit (1);
				}
			}
			if (my_address == 0)
			{
				MPI_Recv (row_out, 2 * (Mx - 2), MPI_CHAR, jrow * Ncols + jcol,
				 99, MPI_COMM_WORLD, &status);
				fwrite (row_out, sizeof (char), 2 * (Mx - 2), hfile);
			}
			MPI_Barrier (MPI_COMM_WORLD);

		}
	}
}


void 
write_history (float a[Mz][My][Mx])
{
	int iz;

	for (iz = 0; iz < Mz; iz++)
	{
		write_history_slice (a, iz);
	}
}

#endif
