#include "CA1.h"


void gInitializeModel() {
	TModel::I().GlobalMod(&CA1_module::I());
	CA1_module::I().Initialize();
	CA1_module::I().SetMInfo(TModule::kisGlobal,True);
	CA_module::I().Initialize();
	CA1_module::I().MakeConnections();
	CA_module::I().MakeConnections();
}

// ---------------------------------------------------------------------------
//                    Class CA1_module 
// ---------------------------------------------------------------------------
CA1_module::CA1_module(char* name) :
	TIME("TIME"),
	TModule(name) {

}	
CA1_module* CA1_module::fInstance = NULL;
CA1_module* CA1_module::kNullModel = (CA1_module*)0x1;
int CA1_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int CA1_module::InitVars() {
	
	TIME.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int CA1_module::Initialize() {
	InitVars();
	CA1_module::I().AddSubModule(&CA_module::I());
	Model::I0().ModuleList().Alphabetize();
	return 1;
}

int CA1_module::SetupEvents() {
	return 0;
}

int CA1_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int CA1_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int CA1_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int CA1_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

int CA1_module::PostInit() {
	PostEventsByType(TEvent::kInit);
	return 1;
}

// ---------------------------------------------------------------------------
//                    Class CA_module 
// ---------------------------------------------------------------------------
CA_module::CA_module(char* name) :
	TIME("TIME"),
	STATE("STATE"),
	RULE("RULE"),
	COUNT("COUNT"),
	STATE_INIT("STATE_INIT"),
	STATE_SUM("STATE_SUM"),
	STATE_DIST_SUM("STATE_DIST_SUM"),
	CAT_MAP("CAT_MAP"),
	TModule(name) {

}	
int CA_module::STATE_I0_exe() {
	float value;

	STATE.UpdateIntegrator();
	switch( STATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = STATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  RULE.Value(p);
			STATE.Update( p, value, dT() );
		}
		STATE.GrabMemory();
		if( STATE.GetF(FLinkEdges) ) { STATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  RULE.Value();
			STATE.Update( value, dT() );
	  } break;
	}
	return 0;
}

int CA_module::STATE_i1_exe() {
	float value;

	STATE.UpdateIntegrator();
	switch( STATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = STATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  STATE_INIT.Value(p);
			STATE.InitValue( p, value );
		}
		STATE.GrabMemory();
		if( STATE.GetF(FLinkEdges) ) { STATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  STATE_INIT.Value();
			STATE.InitValue( value );
	  } break;
	}
	return 0;
}

int CA_module::RULE_u2_exe() {
	float value;

	switch( RULE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = RULE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( -STATE.Value(p)+ ( ( ( COUNT.Value(p) == ((float)3) ) ) ? ( ((float)1) ) : (  ( ( ( COUNT.Value(p) == ((float)2) ) ) ? ( ((float)1) ) : ( ((float)0) ) )  ) )  );
			RULE.Update( p, value );
		}
		RULE.GrabMemory();
		if( RULE.GetF(FICFlux) ) RULE.Cov().Set(0.0); 
		if( RULE.GetF(FLinkEdges) ) { RULE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( -STATE.Value()+ ( ( ( COUNT.Value() == ((float)3) ) ) ? ( ((float)1) ) : (  ( ( ( COUNT.Value() == ((float)2) ) ) ? ( ((float)1) ) : ( ((float)0) ) )  ) )  );
			RULE.Update( value );
	  } break;
	}
	return 0;
}

int CA_module::COUNT_u3_exe() {
	float value;

	switch( COUNT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = COUNT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( STATE.RelValue(p,0,1,0,CVariable::kDefaultBC)+STATE.RelValue(p,-1,0,0,CVariable::kDefaultBC) )+STATE.RelValue(p,1,0,0,CVariable::kDefaultBC) )+STATE.RelValue(p,0,-1,0,CVariable::kDefaultBC) )+STATE.Value(p) );
			COUNT.Update( p, value );
		}
		COUNT.GrabMemory();
		if( COUNT.GetF(FLinkEdges) ) { COUNT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( STATE.Value()+STATE.Value() )+STATE.Value() )+STATE.Value() )+STATE.Value() );
			COUNT.Update( value );
	  } break;
	}
	return 0;
}

int CA_module::STATE_INIT_u4_exe() {
	float value;

	switch( STATE_INIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = STATE_INIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)1);
			STATE_INIT.Update( p, value );
		}
		STATE_INIT.GrabMemory();
		if( STATE_INIT.GetF(FLinkEdges) ) { STATE_INIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)1);
			STATE_INIT.Update( value );
	  } break;
	}
	return 0;
}

int CA_module::STATE_SUM_vE8_exe() {
	float value;

			 Space::SSum(STATE_SUM, STATE);
	return 0;
}

int CA_module::STATE_DIST_SUM_vE9_exe() {
	float value;

			 Space::SSumDist(STATE_DIST_SUM, STATE, CAT_MAP);
	return 0;
}

int CA_module::CAT_MAP_u7_exe() {
	float value;

	switch( CAT_MAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CAT_MAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			CAT_MAP.Update( p, value );
		}
		CAT_MAP.GrabMemory();
		if( CAT_MAP.GetF(FLinkEdges) ) { CAT_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			CAT_MAP.Update( value );
	  } break;
	}
	return 0;
}

CA_module* CA_module::fInstance = NULL;
CA_module* CA_module::kNullModel = (CA_module*)0x1;
int CA_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int CA_module::InitVars() {
	
	TIME.SSInit(this);
	STATE.SSInit(this);
	STATE.SetLinkEdges();
	RULE.SSInit(this);
	RULE.SetDestination(&STATE);
	COUNT.SSInit(this);
	STATE_INIT.SSInit(this);
	STATE_SUM.SSInit(this);
	STATE_DIST_SUM.SSInit(this);
	CAT_MAP.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int CA_module::SetupEvents() {
	TExecuteCommand* I0 = (TExecuteCommand*) STATE.GetCommand("I0",TCommand::kIntegrate,TCommand::kCode);
	I0->SetExecutable(&STATE_I0_exe_g);
	I0->Code() = "I0 <- RULE";
	I0->AddDependency(RULE);
	I0->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i1 = (TExecuteCommand*) STATE.GetCommand("i1",TCommand::kInit,TCommand::kCode);
	i1->SetExecutable(&STATE_i1_exe_g);
	i1->Code() = "i1 <- STATE_INIT";
	i1->AddDependency(STATE_INIT);
	i1->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u2 = (TExecuteCommand*) RULE.GetCommand("u2",TCommand::kUpdate,TCommand::kCode);
	u2->SetExecutable(&RULE_u2_exe_g);
	u2->Code() = "u2 <- ( -STATE+ ( ( ( COUNT == ((float)3) ) ) ? ( ((float)1) ) : (  ( ( ( COUNT == ((float)2) ) ) ? ( ((float)1) ) : ( ((float)0) ) )  ) )  )";
	u2->AddDependency(STATE);
	u2->AddDependency(COUNT);
	u2->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u3 = (TExecuteCommand*) COUNT.GetCommand("u3",TCommand::kUpdate,TCommand::kCode);
	u3->SetExecutable(&COUNT_u3_exe_g);
	u3->Code() = "u3 <- ( ( ( ( STATE@(0,1,0)+STATE@(-1,0,0) )+STATE@(1,0,0) )+STATE@(0,-1,0) )+STATE )";
	u3->AddDependency(STATE,"0,1,0");
	u3->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u4 = (TExecuteCommand*) STATE_INIT.GetCommand("u4",TCommand::kUpdate,TCommand::kCode);
	u4->SetExecutable(&STATE_INIT_u4_exe_g);
	u4->Code() = "u4 <- ((float)1)";
	u4->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* vE8 = (TExecuteCommand*) STATE_SUM.GetCommand("vE8",TCommand::kFunction,TCommand::kCode);
	vE8->SetExecutable(&STATE_SUM_vE8_exe_g);
	vE8->Code() = "vE8 <- Function";
	vE8->GetFunction() = 's';
	vE8->AddDependency(STATE_SUM);
	vE8->AddDependency(STATE);
	vE8->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* vE9 = (TExecuteCommand*) STATE_DIST_SUM.GetCommand("vE9",TCommand::kFunction,TCommand::kCode);
	vE9->SetExecutable(&STATE_DIST_SUM_vE9_exe_g);
	vE9->Code() = "vE9 <- Function";
	vE9->GetFunction() = 'S';
	vE9->AddDependency(STATE_DIST_SUM);
	vE9->AddDependency(STATE);
	vE9->AddDependency(CAT_MAP);
	vE9->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u7 = (TExecuteCommand*) CAT_MAP.GetCommand("u7",TCommand::kUpdate,TCommand::kCode);
	u7->SetExecutable(&CAT_MAP_u7_exe_g);
	u7->Code() = "u7 <- ((float)0)";
	u7->SetObjInfo(TCommand::kDepIndex, 5);
	return 0;
}

int CA_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int CA_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int CA_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int CA_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}
