#include "Freud.h"


void gInitializeModel() {
	TModel::I().GlobalMod(&Freud_module::I());
	Freud_module::I().Initialize();
	Freud_module::I().SetMInfo(TModule::kisGlobal,True);
	Freud_module::I().MakeConnections();
}

// ---------------------------------------------------------------------------
//                    Class Freud_module 
// ---------------------------------------------------------------------------
Freud_module::Freud_module(char* name) :
	TIME("TIME"),
	BODILY_NEEDS("BODILY_NEEDS"),
	ARISING("ARISING"),
	SATISFYING("SATISFYING"),
	PSYCHIC_ENERGY("PSYCHIC_ENERGY"),
	GENERATING("GENERATING"),
	CONSUMING("CONSUMING"),
	TENSION("TENSION"),
	TENSION_GENERATION("TENSION_GENERATION"),
	DISCHARGING("DISCHARGING"),
	ENERGY_NEED("ENERGY_NEED"),
	NEED_PE_UNIT("NEED_PE_UNIT"),
	PE_NEED("PE_NEED"),
	TENSION_NEED("TENSION_NEED"),
	TENSION_PER_NEED("TENSION_PER_NEED"),
	PLEASURE("PLEASURE"),
	TModule(name) {

	BODILY_NEEDS.SetF(FHasNegFlux,True,"CG");
	SATISFYING.SetF(FHasNegFlux,True,"CG");
	PSYCHIC_ENERGY.SetF(FHasNegFlux,True,"CG");
	CONSUMING.SetF(FHasNegFlux,True,"CG");
	TENSION.SetF(FHasNegFlux,True,"CG");
	DISCHARGING.SetF(FHasNegFlux,True,"CG");
}	
int Freud_module::BODILY_NEEDS_I0_exe() {
	float value;
	int array_index[64];


	BODILY_NEEDS.UpdateIntegrator();
	switch( BODILY_NEEDS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = BODILY_NEEDS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ARISING.Value(p)-SATISFYING.Value(p) );
			BODILY_NEEDS.Update( p, value, dT() );
		}
		BODILY_NEEDS.GrabMemory();
		if( BODILY_NEEDS.GetF(FLinkEdges) ) { BODILY_NEEDS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ARISING.Value()-SATISFYING.Value() );
			BODILY_NEEDS.Update( value, dT() );
	  } break;
	}
	return 0;
}

int Freud_module::BODILY_NEEDS_i1_exe() {
	float value;
	int array_index[64];


	switch( BODILY_NEEDS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = BODILY_NEEDS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  .5;
			BODILY_NEEDS.InitValue( p, value );
		}
		BODILY_NEEDS.GrabMemory();
		if( BODILY_NEEDS.GetF(FLinkEdges) ) { BODILY_NEEDS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  .5;
			BODILY_NEEDS.InitValue( value );
	  } break;
	}
	return 0;
}

int Freud_module::ARISING_u2_exe() {
	float value;
	int array_index[64];


	switch( ARISING.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ARISING.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( .25+SL::Step(.1, ((float)5)) );
			ARISING.Update( p, value );
		}
		ARISING.GrabMemory();
		if( ARISING.GetF(FICFlux) ) ARISING.Cov().Set(0.0); 
		if( ARISING.GetF(FLinkEdges) ) { ARISING.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( .25+SL::Step(.1, ((float)5)) );
			ARISING.Update( value );
	  } break;
	}
	return 0;
}

int Freud_module::SATISFYING_u3_exe() {
	float value;
	int array_index[64];


	switch( SATISFYING.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SATISFYING.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( PSYCHIC_ENERGY.Value(p)*NEED_PE_UNIT.Value(p) );
			SATISFYING.Update( p, value );
		}
		SATISFYING.GrabMemory();
		if( SATISFYING.GetF(FICFlux) ) SATISFYING.Cov().Set(0.0); 
		if( SATISFYING.GetF(FLinkEdges) ) { SATISFYING.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( PSYCHIC_ENERGY.Value()*NEED_PE_UNIT.Value() );
			SATISFYING.Update( value );
	  } break;
	}
	return 0;
}

int Freud_module::PSYCHIC_ENERGY_I4_exe() {
	float value;
	int array_index[64];


	PSYCHIC_ENERGY.UpdateIntegrator();
	switch( PSYCHIC_ENERGY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PSYCHIC_ENERGY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( GENERATING.Value(p)-CONSUMING.Value(p) );
			PSYCHIC_ENERGY.Update( p, value, dT() );
		}
		PSYCHIC_ENERGY.GrabMemory();
		if( PSYCHIC_ENERGY.GetF(FLinkEdges) ) { PSYCHIC_ENERGY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( GENERATING.Value()-CONSUMING.Value() );
			PSYCHIC_ENERGY.Update( value, dT() );
	  } break;
	}
	return 0;
}

int Freud_module::PSYCHIC_ENERGY_i5_exe() {
	float value;
	int array_index[64];


	switch( PSYCHIC_ENERGY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PSYCHIC_ENERGY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  .5;
			PSYCHIC_ENERGY.InitValue( p, value );
		}
		PSYCHIC_ENERGY.GrabMemory();
		if( PSYCHIC_ENERGY.GetF(FLinkEdges) ) { PSYCHIC_ENERGY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  .5;
			PSYCHIC_ENERGY.InitValue( value );
	  } break;
	}
	return 0;
}

int Freud_module::GENERATING_u6_exe() {
	float value;
	int array_index[64];


	switch( GENERATING.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = GENERATING.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( BODILY_NEEDS.Value(p)*ENERGY_NEED.Value(p) );
			GENERATING.Update( p, value );
		}
		GENERATING.GrabMemory();
		if( GENERATING.GetF(FICFlux) ) GENERATING.Cov().Set(0.0); 
		if( GENERATING.GetF(FLinkEdges) ) { GENERATING.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( BODILY_NEEDS.Value()*ENERGY_NEED.Value() );
			GENERATING.Update( value );
	  } break;
	}
	return 0;
}

int Freud_module::CONSUMING_u7_exe() {
	float value;
	int array_index[64];


	switch( CONSUMING.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONSUMING.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( SATISFYING.Value(p)*PE_NEED.Value(p) );
			CONSUMING.Update( p, value );
		}
		CONSUMING.GrabMemory();
		if( CONSUMING.GetF(FICFlux) ) CONSUMING.Cov().Set(0.0); 
		if( CONSUMING.GetF(FLinkEdges) ) { CONSUMING.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( SATISFYING.Value()*PE_NEED.Value() );
			CONSUMING.Update( value );
	  } break;
	}
	return 0;
}

int Freud_module::TENSION_I8_exe() {
	float value;
	int array_index[64];


	TENSION.UpdateIntegrator();
	switch( TENSION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TENSION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( TENSION_GENERATION.Value(p)-DISCHARGING.Value(p) );
			TENSION.Update( p, value, dT() );
		}
		TENSION.GrabMemory();
		if( TENSION.GetF(FLinkEdges) ) { TENSION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( TENSION_GENERATION.Value()-DISCHARGING.Value() );
			TENSION.Update( value, dT() );
	  } break;
	}
	return 0;
}

int Freud_module::TENSION_i9_exe() {
	float value;
	int array_index[64];


	switch( TENSION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TENSION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  .5;
			TENSION.InitValue( p, value );
		}
		TENSION.GrabMemory();
		if( TENSION.GetF(FLinkEdges) ) { TENSION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  .5;
			TENSION.InitValue( value );
	  } break;
	}
	return 0;
}

int Freud_module::TENSION_GENERATION_u10_exe() {
	float value;
	int array_index[64];


	switch( TENSION_GENERATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TENSION_GENERATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( BODILY_NEEDS.Value(p)*TENSION_NEED.Value(p) );
			TENSION_GENERATION.Update( p, value );
		}
		TENSION_GENERATION.GrabMemory();
		if( TENSION_GENERATION.GetF(FICFlux) ) TENSION_GENERATION.Cov().Set(0.0); 
		if( TENSION_GENERATION.GetF(FLinkEdges) ) { TENSION_GENERATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( BODILY_NEEDS.Value()*TENSION_NEED.Value() );
			TENSION_GENERATION.Update( value );
	  } break;
	}
	return 0;
}

int Freud_module::DISCHARGING_u11_exe() {
	float value;
	int array_index[64];


	switch( DISCHARGING.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DISCHARGING.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( SATISFYING.Value(p)*TENSION_PER_NEED.Value(p) );
			DISCHARGING.Update( p, value );
		}
		DISCHARGING.GrabMemory();
		if( DISCHARGING.GetF(FICFlux) ) DISCHARGING.Cov().Set(0.0); 
		if( DISCHARGING.GetF(FLinkEdges) ) { DISCHARGING.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( SATISFYING.Value()*TENSION_PER_NEED.Value() );
			DISCHARGING.Update( value );
	  } break;
	}
	return 0;
}

int Freud_module::ENERGY_NEED_u12_exe() {
	float value;
	int array_index[64];


	switch( ENERGY_NEED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ENERGY_NEED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.2;
			ENERGY_NEED.Update( p, ENERGY_NEED.ParameterValue(value,p) );
		}
		ENERGY_NEED.GrabMemory();
		if( ENERGY_NEED.GetF(FLinkEdges) ) { ENERGY_NEED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.2;
			ENERGY_NEED.Update( ENERGY_NEED.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int Freud_module::NEED_PE_UNIT_u13_exe() {
	float value;
	int array_index[64];


	switch( NEED_PE_UNIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NEED_PE_UNIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.3;
			NEED_PE_UNIT.Update( p, NEED_PE_UNIT.ParameterValue(value,p) );
		}
		NEED_PE_UNIT.GrabMemory();
		if( NEED_PE_UNIT.GetF(FLinkEdges) ) { NEED_PE_UNIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.3;
			NEED_PE_UNIT.Update( NEED_PE_UNIT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int Freud_module::PE_NEED_u14_exe() {
	float value;
	int array_index[64];


	switch( PE_NEED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PE_NEED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  1;
			PE_NEED.Update( p, PE_NEED.ParameterValue(value,p) );
		}
		PE_NEED.GrabMemory();
		if( PE_NEED.GetF(FLinkEdges) ) { PE_NEED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  1;
			PE_NEED.Update( PE_NEED.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int Freud_module::TENSION_NEED_u15_exe() {
	float value;
	int array_index[64];


	switch( TENSION_NEED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TENSION_NEED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.9;
			TENSION_NEED.Update( p, TENSION_NEED.ParameterValue(value,p) );
		}
		TENSION_NEED.GrabMemory();
		if( TENSION_NEED.GetF(FLinkEdges) ) { TENSION_NEED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.9;
			TENSION_NEED.Update( TENSION_NEED.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int Freud_module::TENSION_PER_NEED_u16_exe() {
	float value;
	int array_index[64];


	switch( TENSION_PER_NEED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TENSION_PER_NEED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  1;
			TENSION_PER_NEED.Update( p, TENSION_PER_NEED.ParameterValue(value,p) );
		}
		TENSION_PER_NEED.GrabMemory();
		if( TENSION_PER_NEED.GetF(FLinkEdges) ) { TENSION_PER_NEED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  1;
			TENSION_PER_NEED.Update( TENSION_PER_NEED.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int Freud_module::PLEASURE_u17_exe() {
	float value;
	int array_index[64];


	switch( PLEASURE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PLEASURE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  Graph0(SATISFYING.Value(p));
			PLEASURE.Update( p, value );
		}
		PLEASURE.GrabMemory();
		if( PLEASURE.GetF(FLinkEdges) ) { PLEASURE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  Graph0(SATISFYING.Value());
			PLEASURE.Update( value );
	  } break;
	}
	return 0;
}

Freud_module* Freud_module::fInstance = NULL;
Freud_module* Freud_module::kNullModel = (Freud_module*)0x1;
int Freud_module::InitVars() {
	TIME.SSInit(this);
	BODILY_NEEDS.SSInit(this);
	ARISING.SSInit(this);
	ARISING.SetDestination(&BODILY_NEEDS);
	SATISFYING.SSInit(this);
	SATISFYING.SetOrigin(&BODILY_NEEDS);
	PSYCHIC_ENERGY.SSInit(this);
	GENERATING.SSInit(this);
	GENERATING.SetDestination(&PSYCHIC_ENERGY);
	CONSUMING.SSInit(this);
	CONSUMING.SetOrigin(&PSYCHIC_ENERGY);
	TENSION.SSInit(this);
	TENSION_GENERATION.SSInit(this);
	TENSION_GENERATION.SetDestination(&TENSION);
	DISCHARGING.SSInit(this);
	DISCHARGING.SetOrigin(&TENSION);
	ENERGY_NEED.SSInit(this);
	NEED_PE_UNIT.SSInit(this);
	PE_NEED.SSInit(this);
	TENSION_NEED.SSInit(this);
	TENSION_PER_NEED.SSInit(this);
	PLEASURE.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int Freud_module::SetupEvents() {
	TExecuteCommand* I0 = (TExecuteCommand*) BODILY_NEEDS.GetCommand("I0",TCommand::kIntegrate,TCommand::kCode);
	I0->SetExecutable(&BODILY_NEEDS_I0_exe_g);
	I0->Code() = "I0 <- ( ARISING-SATISFYING )";
	I0->AddDependency(ARISING);
	I0->AddDependency(SATISFYING);
	I0->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i1 = (TExecuteCommand*) BODILY_NEEDS.GetCommand("i1",TCommand::kInit,TCommand::kCode);
	i1->SetExecutable(&BODILY_NEEDS_i1_exe_g);
	i1->Code() = "i1 <- .5";
	i1->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u2 = (TExecuteCommand*) ARISING.GetCommand("u2",TCommand::kUpdate,TCommand::kCode);
	u2->SetExecutable(&ARISING_u2_exe_g);
	u2->Code() = "u2 <- ( .25+SL::Step(.1, ((float)5)) )";
	u2->AddDependency(TIME);
	u2->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u3 = (TExecuteCommand*) SATISFYING.GetCommand("u3",TCommand::kUpdate,TCommand::kCode);
	u3->SetExecutable(&SATISFYING_u3_exe_g);
	u3->Code() = "u3 <- ( PSYCHIC_ENERGY*NEED_PE_UNIT )";
	if( SATISFYING.GetF(FisClamped) ) { u3->AddDependency(BODILY_NEEDS); }
	u3->AddDependency(PSYCHIC_ENERGY);
	u3->AddDependency(NEED_PE_UNIT);
	u3->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I4 = (TExecuteCommand*) PSYCHIC_ENERGY.GetCommand("I4",TCommand::kIntegrate,TCommand::kCode);
	I4->SetExecutable(&PSYCHIC_ENERGY_I4_exe_g);
	I4->Code() = "I4 <- ( GENERATING-CONSUMING )";
	I4->AddDependency(GENERATING);
	I4->AddDependency(CONSUMING);
	I4->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i5 = (TExecuteCommand*) PSYCHIC_ENERGY.GetCommand("i5",TCommand::kInit,TCommand::kCode);
	i5->SetExecutable(&PSYCHIC_ENERGY_i5_exe_g);
	i5->Code() = "i5 <- .5";
	i5->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u6 = (TExecuteCommand*) GENERATING.GetCommand("u6",TCommand::kUpdate,TCommand::kCode);
	u6->SetExecutable(&GENERATING_u6_exe_g);
	u6->Code() = "u6 <- ( BODILY_NEEDS*ENERGY_NEED )";
	u6->AddDependency(BODILY_NEEDS);
	u6->AddDependency(ENERGY_NEED);
	u6->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u7 = (TExecuteCommand*) CONSUMING.GetCommand("u7",TCommand::kUpdate,TCommand::kCode);
	u7->SetExecutable(&CONSUMING_u7_exe_g);
	u7->Code() = "u7 <- ( SATISFYING*PE_NEED )";
	if( CONSUMING.GetF(FisClamped) ) { u7->AddDependency(PSYCHIC_ENERGY); }
	u7->AddDependency(SATISFYING);
	u7->AddDependency(PE_NEED);
	u7->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I8 = (TExecuteCommand*) TENSION.GetCommand("I8",TCommand::kIntegrate,TCommand::kCode);
	I8->SetExecutable(&TENSION_I8_exe_g);
	I8->Code() = "I8 <- ( TENSION_GENERATION-DISCHARGING )";
	I8->AddDependency(TENSION_GENERATION);
	I8->AddDependency(DISCHARGING);
	I8->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i9 = (TExecuteCommand*) TENSION.GetCommand("i9",TCommand::kInit,TCommand::kCode);
	i9->SetExecutable(&TENSION_i9_exe_g);
	i9->Code() = "i9 <- .5";
	i9->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u10 = (TExecuteCommand*) TENSION_GENERATION.GetCommand("u10",TCommand::kUpdate,TCommand::kCode);
	u10->SetExecutable(&TENSION_GENERATION_u10_exe_g);
	u10->Code() = "u10 <- ( BODILY_NEEDS*TENSION_NEED )";
	u10->AddDependency(BODILY_NEEDS);
	u10->AddDependency(TENSION_NEED);
	u10->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u11 = (TExecuteCommand*) DISCHARGING.GetCommand("u11",TCommand::kUpdate,TCommand::kCode);
	u11->SetExecutable(&DISCHARGING_u11_exe_g);
	u11->Code() = "u11 <- ( SATISFYING*TENSION_PER_NEED )";
	if( DISCHARGING.GetF(FisClamped) ) { u11->AddDependency(TENSION); }
	u11->AddDependency(SATISFYING);
	u11->AddDependency(TENSION_PER_NEED);
	u11->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u12 = (TExecuteCommand*) ENERGY_NEED.GetCommand("u12",TCommand::kUpdate,TCommand::kCode);
	u12->SetExecutable(&ENERGY_NEED_u12_exe_g);
	u12->Code() = "u12 <- 0.2";
	u12->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u13 = (TExecuteCommand*) NEED_PE_UNIT.GetCommand("u13",TCommand::kUpdate,TCommand::kCode);
	u13->SetExecutable(&NEED_PE_UNIT_u13_exe_g);
	u13->Code() = "u13 <- 0.3";
	u13->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u14 = (TExecuteCommand*) PE_NEED.GetCommand("u14",TCommand::kUpdate,TCommand::kCode);
	u14->SetExecutable(&PE_NEED_u14_exe_g);
	u14->Code() = "u14 <- 1";
	u14->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u15 = (TExecuteCommand*) TENSION_NEED.GetCommand("u15",TCommand::kUpdate,TCommand::kCode);
	u15->SetExecutable(&TENSION_NEED_u15_exe_g);
	u15->Code() = "u15 <- 0.9";
	u15->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u16 = (TExecuteCommand*) TENSION_PER_NEED.GetCommand("u16",TCommand::kUpdate,TCommand::kCode);
	u16->SetExecutable(&TENSION_PER_NEED_u16_exe_g);
	u16->Code() = "u16 <- 1";
	u16->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u17 = (TExecuteCommand*) PLEASURE.GetCommand("u17",TCommand::kUpdate,TCommand::kCode);
	u17->SetExecutable(&PLEASURE_u17_exe_g);
	u17->Code() = "u17 <- Graph0(SATISFYING)";
	u17->AddDependency(SATISFYING);
	u17->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int Freud_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int Freud_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int Freud_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int Freud_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

int Freud_module::PostInit() {
	PostEventsByType(TEvent::kInit);
	return 1;
}
