#ifndef __ModelEqns__
#define __ModelEqns__

#include "SpaceSim.h"

// ---------------------------------------------------------------------------
//                    Class Freud_module 
// ---------------------------------------------------------------------------

class Freud_module : public TModule {
protected:

	Freud_module(char* name);

public:

	TTime TIME;
	CStateVariable BODILY_NEEDS;
	CFluxVariable ARISING;
	CFluxVariable SATISFYING;
	CStateVariable PSYCHIC_ENERGY;
	CFluxVariable GENERATING;
	CFluxVariable CONSUMING;
	CStateVariable TENSION;
	CFluxVariable TENSION_GENERATION;
	CFluxVariable DISCHARGING;
	CAuxVariable ENERGY_NEED;
	CAuxVariable NEED_PE_UNIT;
	CAuxVariable PE_NEED;
	CAuxVariable TENSION_NEED;
	CAuxVariable TENSION_PER_NEED;
	CAuxVariable PLEASURE;
protected:

	int BODILY_NEEDS_I0_exe();
	friend int BODILY_NEEDS_I0_exe_g( Variable* v );
	int BODILY_NEEDS_i1_exe();
	friend int BODILY_NEEDS_i1_exe_g( Variable* v );
	int ARISING_u2_exe();
	friend int ARISING_u2_exe_g( Variable* v );
	int SATISFYING_u3_exe();
	friend int SATISFYING_u3_exe_g( Variable* v );
	int PSYCHIC_ENERGY_I4_exe();
	friend int PSYCHIC_ENERGY_I4_exe_g( Variable* v );
	int PSYCHIC_ENERGY_i5_exe();
	friend int PSYCHIC_ENERGY_i5_exe_g( Variable* v );
	int GENERATING_u6_exe();
	friend int GENERATING_u6_exe_g( Variable* v );
	int CONSUMING_u7_exe();
	friend int CONSUMING_u7_exe_g( Variable* v );
	int TENSION_I8_exe();
	friend int TENSION_I8_exe_g( Variable* v );
	int TENSION_i9_exe();
	friend int TENSION_i9_exe_g( Variable* v );
	int TENSION_GENERATION_u10_exe();
	friend int TENSION_GENERATION_u10_exe_g( Variable* v );
	int DISCHARGING_u11_exe();
	friend int DISCHARGING_u11_exe_g( Variable* v );
	int ENERGY_NEED_u12_exe();
	friend int ENERGY_NEED_u12_exe_g( Variable* v );
	int NEED_PE_UNIT_u13_exe();
	friend int NEED_PE_UNIT_u13_exe_g( Variable* v );
	int PE_NEED_u14_exe();
	friend int PE_NEED_u14_exe_g( Variable* v );
	int TENSION_NEED_u15_exe();
	friend int TENSION_NEED_u15_exe_g( Variable* v );
	int TENSION_PER_NEED_u16_exe();
	friend int TENSION_PER_NEED_u16_exe_g( Variable* v );
	int PLEASURE_u17_exe();
	friend int PLEASURE_u17_exe_g( Variable* v );
	static Freud_module* fInstance;
	static Freud_module* kNullModel;
public:
	inline static Freud_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new Freud_module("Freud_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (Freud_module&) *fInstance;
	}

	virtual int InitVars();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}

	inline double Graph0(double x) { 
		static double g[12][2] = {
			{ 0.0000E+00, 0.000000E+00},{ 5.0000E-02, 2.500000E-02},{ 1.0000E-01, 6.000000E-02},{ 1.5000E-01, 1.300000E-01},
			{ 2.0000E-01, 1.900000E-01},{ 2.5000E-01, 2.850000E-01},{ 3.0000E-01, 4.150000E-01},{ 3.5000E-01, 7.200000E-01},
			{ 4.0000E-01, 8.900000E-01},{ 4.5000E-01, 9.600000E-01},{ 5.0000E-01, 1.000000E+00}, };
		return SL::Graph( 0, x, 11, g); 
	}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit();
};


int BODILY_NEEDS_I0_exe_g(Variable* obj) { return Freud_module::I().BODILY_NEEDS_I0_exe(); }
int BODILY_NEEDS_i1_exe_g(Variable* obj) { return Freud_module::I().BODILY_NEEDS_i1_exe(); }
int ARISING_u2_exe_g(Variable* obj) { return Freud_module::I().ARISING_u2_exe(); }
int SATISFYING_u3_exe_g(Variable* obj) { return Freud_module::I().SATISFYING_u3_exe(); }
int PSYCHIC_ENERGY_I4_exe_g(Variable* obj) { return Freud_module::I().PSYCHIC_ENERGY_I4_exe(); }
int PSYCHIC_ENERGY_i5_exe_g(Variable* obj) { return Freud_module::I().PSYCHIC_ENERGY_i5_exe(); }
int GENERATING_u6_exe_g(Variable* obj) { return Freud_module::I().GENERATING_u6_exe(); }
int CONSUMING_u7_exe_g(Variable* obj) { return Freud_module::I().CONSUMING_u7_exe(); }
int TENSION_I8_exe_g(Variable* obj) { return Freud_module::I().TENSION_I8_exe(); }
int TENSION_i9_exe_g(Variable* obj) { return Freud_module::I().TENSION_i9_exe(); }
int TENSION_GENERATION_u10_exe_g(Variable* obj) { return Freud_module::I().TENSION_GENERATION_u10_exe(); }
int DISCHARGING_u11_exe_g(Variable* obj) { return Freud_module::I().DISCHARGING_u11_exe(); }
int ENERGY_NEED_u12_exe_g(Variable* obj) { return Freud_module::I().ENERGY_NEED_u12_exe(); }
int NEED_PE_UNIT_u13_exe_g(Variable* obj) { return Freud_module::I().NEED_PE_UNIT_u13_exe(); }
int PE_NEED_u14_exe_g(Variable* obj) { return Freud_module::I().PE_NEED_u14_exe(); }
int TENSION_NEED_u15_exe_g(Variable* obj) { return Freud_module::I().TENSION_NEED_u15_exe(); }
int TENSION_PER_NEED_u16_exe_g(Variable* obj) { return Freud_module::I().TENSION_PER_NEED_u16_exe(); }
int PLEASURE_u17_exe_g(Variable* obj) { return Freud_module::I().PLEASURE_u17_exe(); }

#endif
