//----------------------------------------------------------------------------------------
// main.cp
// Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//----------------------------------------------------------------------------------------

#include "SimLib.h"
#include "stdio.h"

#ifdef USE_TCL
#include <tcl.h>
extern int Tcl_AppInit(Tcl_Interp*);
#endif

//----------------------------------------------------------------------------------------
// main: 
//----------------------------------------------------------------------------------------

int main (int argc, char *argv[])
{
  int iproc = SS_Init (argc,argv);
  
  if (SS_UseTcl()) {
    
#ifdef USE_TCL
   
    printf ("\n");

    // initialize TCL interpreter and start it
    Tcl_Main(argc, argv, Tcl_AppInit);
    
#else
    
    printf ("Support for TCL interpreter not compiled in\n");
    return 255;
    
#endif
    
  } else {
    
    char inBuf[256];
    
    while( 1 ) {
      if( SS_UseJavaSocket() ) {
				SS_ExecuteJavaCommand (inBuf );
      } else {
				if( iproc == 0 ) {
					printf("\nSME>");
					gets(inBuf);
				}
				const char* rStr = SS_ExecuteCommand (inBuf);
				if( (iproc == 0) && rStr ) { printf("\nTCL> %s ",rStr); } 
      }
    }
  }
  SS_Exit();
} // main 

