#include "cbay.h"


void gInitializeModel() {
	TModel::I().GlobalMod(&cbay_module::I());
	cbay_module::I().Initialize();
	cbay_module::I().SetMInfo(TModule::kisGlobal,True);
	CONSUMERS_module::I().Initialize();
	DETRITUS_module::I().Initialize();
	DIN_module::I().Initialize();
	GLOBAL_module::I().Initialize();
	PHOSPHATE_module::I().Initialize();
	PHYTOPLANKTON_module::I().Initialize();
	SEAWEED_module::I().Initialize();
	TSS_module::I().Initialize();
	cbay_module::I().MakeConnections();
	CONSUMERS_module::I().MakeConnections();
	DETRITUS_module::I().MakeConnections();
	DIN_module::I().MakeConnections();
	GLOBAL_module::I().MakeConnections();
	PHOSPHATE_module::I().MakeConnections();
	PHYTOPLANKTON_module::I().MakeConnections();
	SEAWEED_module::I().MakeConnections();
	TSS_module::I().MakeConnections();
}

// ---------------------------------------------------------------------------
//                    Class cbay_module 
// ---------------------------------------------------------------------------
cbay_module::cbay_module(char* name) :
	TIME("TIME"),
	TModule(name) {

}	
cbay_module* cbay_module::fInstance = NULL;
cbay_module* cbay_module::kNullModel = (cbay_module*)0x1;
int cbay_module::InitVars() {
	TIME.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int cbay_module::Initialize() {
	InitVars();
	CONSUMERS_module::I().Init(this);
	DETRITUS_module::I().Init(this);
	DIN_module::I().Init(this);
	GLOBAL_module::I().Init(this);
	PHOSPHATE_module::I().Init(this);
	PHYTOPLANKTON_module::I().Init(this);
	SEAWEED_module::I().Init(this);
	TSS_module::I().Init(this);
	Model::I0().ModuleList().Alphabetize();
	return 1;
}

int cbay_module::MakeConnections() {
	CONSUMERS_module::I().P_CELL_AREA.Connect(&(GLOBAL_module::I().P_CELL_AREA));
	CONSUMERS_module::I().PHYTOPLANKTON.Connect(&(PHYTOPLANKTON_module::I().PHYTOPLANKTON));
	CONSUMERS_module::I().SEAWEEDS.Connect(&(SEAWEED_module::I().SEAWEEDS));
	CONSUMERS_module::I().DETRITUS.Connect(&(DETRITUS_module::I().DETRITUS));
	CONSUMERS_module::I().BOTTOM_MAP.Connect(&(GLOBAL_module::I().BOTTOM_MAP));
	CONSUMERS_module::I().SURFACE_MAP.Connect(&(GLOBAL_module::I().SURFACE_MAP));
	CONSUMERS_module::I().OM3_TEMP.Connect(&(GLOBAL_module::I().OM3_TEMP));
	DETRITUS_module::I().CONS_MORTALITY.Connect(&(CONSUMERS_module::I().CONS_MORTALITY));
	DETRITUS_module::I().PHT_MORTALITY.Connect(&(PHYTOPLANKTON_module::I().PHT_MORTALITY));
	DETRITUS_module::I().SW_MORT.Connect(&(SEAWEED_module::I().SW_MORT));
	DETRITUS_module::I().CONS_EGEST.Connect(&(CONSUMERS_module::I().CONS_EGEST));
	DETRITUS_module::I().COS_INGEST_DETR.Connect(&(CONSUMERS_module::I().COS_INGEST_DETR));
	DIN_module::I().SF_WATER.Connect(&(GLOBAL_module::I().SF_WATER));
	DIN_module::I().DETR_DECOMPOSED.Connect(&(DETRITUS_module::I().DETR_DECOMPOSED));
	DIN_module::I().PHT_NET_PROD.Connect(&(PHYTOPLANKTON_module::I().PHT_NET_PROD));
	DIN_module::I().P_PHT_NC.Connect(&(PHYTOPLANKTON_module::I().P_PHT_NC));
	DIN_module::I().BOTTOM_MAP.Connect(&(GLOBAL_module::I().BOTTOM_MAP));
	GLOBAL_module::I().TSS_CONC.Connect(&(TSS_module::I().TSS_CONC));
	GLOBAL_module::I().PHT_CONC.Connect(&(PHYTOPLANKTON_module::I().PHT_CONC));
	PHOSPHATE_module::I().SF_WATER.Connect(&(GLOBAL_module::I().SF_WATER));
	PHOSPHATE_module::I().DETR_DECOMPOSED.Connect(&(DETRITUS_module::I().DETR_DECOMPOSED));
	PHOSPHATE_module::I().PHT_NET_PROD.Connect(&(PHYTOPLANKTON_module::I().PHT_NET_PROD));
	PHOSPHATE_module::I().P_PHY_PC.Connect(&(PHYTOPLANKTON_module::I().P_PHY_PC));
	PHOSPHATE_module::I().BOTTOM_MAP.Connect(&(GLOBAL_module::I().BOTTOM_MAP));
	PHYTOPLANKTON_module::I().SF_WATER.Connect(&(GLOBAL_module::I().SF_WATER));
	PHYTOPLANKTON_module::I().CONS_INGEST_PHT.Connect(&(CONSUMERS_module::I().CONS_INGEST_PHT));
	PHYTOPLANKTON_module::I().LIGHT_TO_PHYTOPLANKTON.Connect(&(GLOBAL_module::I().LIGHT_TO_PHYTOPLANKTON));
	PHYTOPLANKTON_module::I().DIN_CONC.Connect(&(DIN_module::I().DIN_CONC));
	PHYTOPLANKTON_module::I().PO4_SF_WT_CONC.Connect(&(PHOSPHATE_module::I().PO4_SF_WT_CONC));
	PHYTOPLANKTON_module::I().OM3_TEMP.Connect(&(GLOBAL_module::I().OM3_TEMP));
	PHYTOPLANKTON_module::I().P_CHL_A_MAP.Connect(&(GLOBAL_module::I().P_CHL_A_MAP));
	SEAWEED_module::I().WATER_LAYER_DEPTH.Connect(&(GLOBAL_module::I().WATER_LAYER_DEPTH));
	SEAWEED_module::I().P_CELL_AREA.Connect(&(GLOBAL_module::I().P_CELL_AREA));
	SEAWEED_module::I().P_IC_PHT.Connect(&(PHYTOPLANKTON_module::I().P_IC_PHT));
	SEAWEED_module::I().SF_WATER.Connect(&(GLOBAL_module::I().SF_WATER));
	SEAWEED_module::I().CONS_INGEST_SW.Connect(&(CONSUMERS_module::I().CONS_INGEST_SW));
	SEAWEED_module::I().BOTTOM_MAP.Connect(&(GLOBAL_module::I().BOTTOM_MAP));
	SEAWEED_module::I().P_ON_MAP.Connect(&(GLOBAL_module::I().P_ON_MAP));
	SEAWEED_module::I().WATER_DEPTH.Connect(&(GLOBAL_module::I().WATER_DEPTH));
	SEAWEED_module::I().LIGHT_TO_PHYTOPLANKTON.Connect(&(GLOBAL_module::I().LIGHT_TO_PHYTOPLANKTON));
	SEAWEED_module::I().DIN_CONC.Connect(&(DIN_module::I().DIN_CONC));
	SEAWEED_module::I().PO4_SF_WT_CONC.Connect(&(PHOSPHATE_module::I().PO4_SF_WT_CONC));
	SEAWEED_module::I().OM3_TEMP.Connect(&(GLOBAL_module::I().OM3_TEMP));
	TSS_module::I().SF_WATER.Connect(&(GLOBAL_module::I().SF_WATER));
	TSS_module::I().BOTTOM_MAP.Connect(&(GLOBAL_module::I().BOTTOM_MAP));
	TSS_module::I().VEG_STRUCTURE.Connect(&(CONSUMERS_module::I().VEG_STRUCTURE));
	TSS_module::I().OM3_SHEAR_STRESS.Connect(&(GLOBAL_module::I().OM3_SHEAR_STRESS));
	return 0;
}

int cbay_module::SetupEvents() {
	return 0;
}

int cbay_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int cbay_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int cbay_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int cbay_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

int cbay_module::PostInit() {
	PostEventsByType(TEvent::kInit);
	return 1;
}

// ---------------------------------------------------------------------------
//                    Class CONSUMERS_module 
// ---------------------------------------------------------------------------
CONSUMERS_module::CONSUMERS_module(char* name) :
	TIME("TIME"),
	P_CELL_AREA("P_CELL_AREA"),
	PHYTOPLANKTON("PHYTOPLANKTON"),
	SEAWEEDS("SEAWEEDS"),
	DETRITUS("DETRITUS"),
	BOTTOM_MAP("BOTTOM_MAP"),
	SURFACE_MAP("SURFACE_MAP"),
	OM3_TEMP("OM3_TEMP"),
	CONS_MORTALITY("CONS_MORTALITY"),
	CONS_EGEST("CONS_EGEST"),
	COS_INGEST_DETR("COS_INGEST_DETR"),
	CONS_INGEST_PHT("CONS_INGEST_PHT"),
	CONS_INGEST_SW("CONS_INGEST_SW"),
	VEG_STRUCTURE("VEG_STRUCTURE"),
	CONSUMERS("CONSUMERS"),
	CONS_INGEST("CONS_INGEST"),
	CONS_IN_X("CONS_IN_X"),
	CONS_RESPIRATION("CONS_RESPIRATION"),
	CONS_OUT_X("CONS_OUT_X"),
	CONSDENS("CONSDENS"),
	CONSTOD("CONSTOD"),
	CONSTOE("CONSTOE"),
	CONSTON("CONSTON"),
	CONSTOS("CONSTOS"),
	CONSTOU("CONSTOU"),
	CONSTOW("CONSTOW"),
	CON_POT_INGEST("CON_POT_INGEST"),
	DENSITY_X_D("DENSITY_X_D"),
	DENSITY_X_E("DENSITY_X_E"),
	DENSITY_X_N("DENSITY_X_N"),
	DENSITY_X_S("DENSITY_X_S"),
	DENSITY_X_U("DENSITY_X_U"),
	DENSITY_X_W("DENSITY_X_W"),
	FOOD_X_D("FOOD_X_D"),
	FOOD_X_E("FOOD_X_E"),
	FOOD_X_N("FOOD_X_N"),
	FOOD_X_S("FOOD_X_S"),
	FOOD_X_UP("FOOD_X_UP"),
	FOOD_X_W("FOOD_X_W"),
	IC_CONSUMER("IC_CONSUMER"),
	OMTOTBIO("OMTOTBIO"),
	PREF_TOT("PREF_TOT"),
	RIVER_CON("RIVER_CON"),
	P_CONS_NC("P_CONS_NC"),
	P_CONS_PC("P_CONS_PC"),
	P_C_EGEST_EFF("P_C_EGEST_EFF"),
	P_C_MORT_RT("P_C_MORT_RT"),
	P_C_RESP_RT("P_C_RESP_RT"),
	P_DETR_PREF("P_DETR_PREF"),
	P_INGESTION_RT("P_INGESTION_RT"),
	P_PH_PREF("P_PH_PREF"),
	P_SW_PREF("P_SW_PREF"),
	P_TRAVEL_TIME("P_TRAVEL_TIME"),
	P_TRAVEL_TIME_DENS("P_TRAVEL_TIME_DENS"),
	P_VEG_DENS_COEFF("P_VEG_DENS_COEFF"),
	CONS_ACTIVITY("CONS_ACTIVITY"),
	TModule(name) {

	P_CELL_AREA.SetF(FisImport,True,"CG");
	PHYTOPLANKTON.SetF(FisImport,True,"CG");
	SEAWEEDS.SetF(FisImport,True,"CG");
	DETRITUS.SetF(FisImport,True,"CG");
	BOTTOM_MAP.SetF(FisImport,True,"CG");
	SURFACE_MAP.SetF(FisImport,True,"CG");
	OM3_TEMP.SetF(FisImport,True,"CG");
	CONS_MORTALITY.SetF(FisExport,True,"CG");
	CONS_MORTALITY.SetF(FHasNegFlux,True,"CG");
	CONS_EGEST.SetF(FisExport,True,"CG");
	CONS_EGEST.SetF(FHasNegFlux,True,"CG");
	COS_INGEST_DETR.SetF(FisExport,True,"CG");
	CONS_INGEST_PHT.SetF(FisExport,True,"CG");
	CONS_INGEST_SW.SetF(FisExport,True,"CG");
	VEG_STRUCTURE.SetF(FisExport,True,"CG");
	CONSUMERS.SetF(FHasNegFlux,True,"CG");
	CONS_RESPIRATION.SetF(FHasNegFlux,True,"CG");
	CONS_OUT_X.SetF(FHasNegFlux,True,"CG");
}	
int CONSUMERS_module::CONSUMERS_I0_exe() {
	float value;
	int array_index[64];


	CONSUMERS.UpdateIntegrator();
	switch( CONSUMERS.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* CONSUMERS_ptr = CONSUMERS.DataStart();
		const float* CONSUMERS_Eptr = CONSUMERS.GridEnd();
		float dt = dT();
		float* CONSUMERS_Rptr = CONSUMERS.RDataStart();
		float* CONS_INGEST_ptr = CONS_INGEST.DataStart();
		float* CONS_IN_X_ptr = CONS_IN_X.DataStart();
		float* CONS_EGEST_ptr = CONS_EGEST.DataStart();
		float* CONS_MORTALITY_ptr = CONS_MORTALITY.DataStart();
		float* CONS_RESPIRATION_ptr = CONS_RESPIRATION.DataStart();
		float* CONS_OUT_X_ptr = CONS_OUT_X.DataStart();
		switch( CONSUMERS.CurrentOrder() ) {
		  case 1: {
			if( CONSUMERS.Order() > 1 ) {
			float *CONSUMERS_IMptr0 = CONSUMERS.SIntegratorMemory().LastData();
			while( CONSUMERS_ptr < CONSUMERS_Eptr ) {
		 value =  ( ( ( ( ( (*(CONS_INGEST_ptr))+(*(CONS_IN_X_ptr)) )-(*(CONS_EGEST_ptr)) )-(*(CONS_MORTALITY_ptr)) )-(*(CONS_RESPIRATION_ptr)) )-(*(CONS_OUT_X_ptr)) );
				*CONSUMERS_ptr += value*dt;
				if(CONSUMERS_Rptr) { *CONSUMERS_Rptr++ = *CONSUMERS_ptr; }
				*CONSUMERS_IMptr0++ = value;
				CONSUMERS_ptr++;
				CONS_INGEST.UpdateDataPtr(CONS_INGEST_ptr);
				CONS_IN_X.UpdateDataPtr(CONS_IN_X_ptr);
				CONS_EGEST.UpdateDataPtr(CONS_EGEST_ptr);
				CONS_MORTALITY.UpdateDataPtr(CONS_MORTALITY_ptr);
				CONS_RESPIRATION.UpdateDataPtr(CONS_RESPIRATION_ptr);
				CONS_OUT_X.UpdateDataPtr(CONS_OUT_X_ptr);
			}
			} else {
			while( CONSUMERS_ptr < CONSUMERS_Eptr ) {
		 value =  ( ( ( ( ( (*(CONS_INGEST_ptr))+(*(CONS_IN_X_ptr)) )-(*(CONS_EGEST_ptr)) )-(*(CONS_MORTALITY_ptr)) )-(*(CONS_RESPIRATION_ptr)) )-(*(CONS_OUT_X_ptr)) );
				*CONSUMERS_ptr += value*dt;
				if(CONSUMERS_Rptr) { *CONSUMERS_Rptr++ = *CONSUMERS_ptr; }
				CONSUMERS_ptr++;
				CONS_INGEST.UpdateDataPtr(CONS_INGEST_ptr);
				CONS_IN_X.UpdateDataPtr(CONS_IN_X_ptr);
				CONS_EGEST.UpdateDataPtr(CONS_EGEST_ptr);
				CONS_MORTALITY.UpdateDataPtr(CONS_MORTALITY_ptr);
				CONS_RESPIRATION.UpdateDataPtr(CONS_RESPIRATION_ptr);
				CONS_OUT_X.UpdateDataPtr(CONS_OUT_X_ptr);
			}
			};
		  } break; case 2: {
			float *CONSUMERS_IMptr0 = CONSUMERS.SIntegratorMemory().LastData();
			float *CONSUMERS_IMptr1 = CONSUMERS.SIntegratorMemory().LastDataOffset(1);
			while( CONSUMERS_ptr < CONSUMERS_Eptr ) {
		 value =  ( ( ( ( ( (*(CONS_INGEST_ptr))+(*(CONS_IN_X_ptr)) )-(*(CONS_EGEST_ptr)) )-(*(CONS_MORTALITY_ptr)) )-(*(CONS_RESPIRATION_ptr)) )-(*(CONS_OUT_X_ptr)) );
				*CONSUMERS_IMptr0++ = value;
				*CONSUMERS_ptr += ( 1.5*value - 0.5* *CONSUMERS_IMptr1++ )*dt;
				if(CONSUMERS_Rptr) { *CONSUMERS_Rptr++ = *CONSUMERS_ptr; }
				CONSUMERS_ptr++;
				CONS_INGEST.UpdateDataPtr(CONS_INGEST_ptr);
				CONS_IN_X.UpdateDataPtr(CONS_IN_X_ptr);
				CONS_EGEST.UpdateDataPtr(CONS_EGEST_ptr);
				CONS_MORTALITY.UpdateDataPtr(CONS_MORTALITY_ptr);
				CONS_RESPIRATION.UpdateDataPtr(CONS_RESPIRATION_ptr);
				CONS_OUT_X.UpdateDataPtr(CONS_OUT_X_ptr);
			}
		  } break; case 3: {
			float *CONSUMERS_IMptr0 = CONSUMERS.SIntegratorMemory().LastData();
			float *CONSUMERS_IMptr1 = CONSUMERS.SIntegratorMemory().LastDataOffset(1);
			float *CONSUMERS_IMptr2 = CONSUMERS.SIntegratorMemory().LastDataOffset(2);
			while( CONSUMERS_ptr < CONSUMERS_Eptr ) {
		 value =  ( ( ( ( ( (*(CONS_INGEST_ptr))+(*(CONS_IN_X_ptr)) )-(*(CONS_EGEST_ptr)) )-(*(CONS_MORTALITY_ptr)) )-(*(CONS_RESPIRATION_ptr)) )-(*(CONS_OUT_X_ptr)) );
				*CONSUMERS_IMptr0++ = value;
				*CONSUMERS_ptr += (1.92*value - 1.33* *CONSUMERS_IMptr1++ + .42* *CONSUMERS_IMptr2++)*dt;
				if(CONSUMERS_Rptr) { *CONSUMERS_Rptr++ = *CONSUMERS_ptr; }
				CONSUMERS_ptr++;
				CONS_INGEST.UpdateDataPtr(CONS_INGEST_ptr);
				CONS_IN_X.UpdateDataPtr(CONS_IN_X_ptr);
				CONS_EGEST.UpdateDataPtr(CONS_EGEST_ptr);
				CONS_MORTALITY.UpdateDataPtr(CONS_MORTALITY_ptr);
				CONS_RESPIRATION.UpdateDataPtr(CONS_RESPIRATION_ptr);
				CONS_OUT_X.UpdateDataPtr(CONS_OUT_X_ptr);
			}
		  } break; case 4: {
			float *CONSUMERS_IMptr0 = CONSUMERS.SIntegratorMemory().LastData();
			float *CONSUMERS_IMptr1 = CONSUMERS.SIntegratorMemory().LastDataOffset(1);
			float *CONSUMERS_IMptr2 = CONSUMERS.SIntegratorMemory().LastDataOffset(2);
			float *CONSUMERS_IMptr3 = CONSUMERS.SIntegratorMemory().LastDataOffset(3);
			while( CONSUMERS_ptr < CONSUMERS_Eptr ) {
		 value =  ( ( ( ( ( (*(CONS_INGEST_ptr))+(*(CONS_IN_X_ptr)) )-(*(CONS_EGEST_ptr)) )-(*(CONS_MORTALITY_ptr)) )-(*(CONS_RESPIRATION_ptr)) )-(*(CONS_OUT_X_ptr)) );
				*CONSUMERS_IMptr0++ = value;
				*CONSUMERS_ptr += (2.29*value - 2.46* *CONSUMERS_IMptr1++  + 1.54* *CONSUMERS_IMptr2++ - .375* *CONSUMERS_IMptr3++ )*dt;
				if(CONSUMERS_Rptr) { *CONSUMERS_Rptr++ = *CONSUMERS_ptr; }
				CONSUMERS_ptr++;
				CONS_INGEST.UpdateDataPtr(CONS_INGEST_ptr);
				CONS_IN_X.UpdateDataPtr(CONS_IN_X_ptr);
				CONS_EGEST.UpdateDataPtr(CONS_EGEST_ptr);
				CONS_MORTALITY.UpdateDataPtr(CONS_MORTALITY_ptr);
				CONS_RESPIRATION.UpdateDataPtr(CONS_RESPIRATION_ptr);
				CONS_OUT_X.UpdateDataPtr(CONS_OUT_X_ptr);
			}
		  } break; default: { gPrintErr("Illegal Order in StateVar update!"); }
		};
		CONSUMERS.GrabMemory();
		if( CONSUMERS.GetF(FLinkEdges) ) { CONSUMERS.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONSUMERS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( ( ( ( CONS_INGEST.Value(p)+CONS_IN_X.Value(p) )-CONS_EGEST.Value(p) )-CONS_MORTALITY.Value(p) )-CONS_RESPIRATION.Value(p) )-CONS_OUT_X.Value(p) );
			CONSUMERS.Update( p, value, dT() );
		}
		CONSUMERS.GrabMemory();
		if( CONSUMERS.GetF(FLinkEdges) ) { CONSUMERS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( ( ( ( CONS_INGEST.Value()+CONS_IN_X.Value() )-CONS_EGEST.Value() )-CONS_MORTALITY.Value() )-CONS_RESPIRATION.Value() )-CONS_OUT_X.Value() );
			CONSUMERS.Update( value, dT() );
	  } break;
	}
	CONSUMERS.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::CONSUMERS_i1_exe() {
	float value;
	int array_index[64];


	switch( CONSUMERS.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* CONSUMERS_ptr = CONSUMERS.DataStart();
		const float* CONSUMERS_Eptr = CONSUMERS.GridEnd();
		float dt = dT();
		float* CONSUMERS_Rptr = CONSUMERS.RDataStart();
		float* IC_CONSUMER_ptr = IC_CONSUMER.DataStart();
		float* P_CELL_AREA_ptr = P_CELL_AREA.DataStart();
		while( CONSUMERS_ptr < CONSUMERS_Eptr ) {
		 value =  ( (*(IC_CONSUMER_ptr))*(*(P_CELL_AREA_ptr)) );
			if(CONSUMERS_Rptr) { *CONSUMERS_Rptr = *CONSUMERS_ptr = value;  CONSUMERS_Rptr++; }
			else { *CONSUMERS_ptr = value; }
			CONSUMERS_ptr++;
			IC_CONSUMER.UpdateDataPtr(IC_CONSUMER_ptr);
			P_CELL_AREA.UpdateDataPtr(P_CELL_AREA_ptr);
		}
		CONSUMERS.GrabMemory();
		if( CONSUMERS.GetF(FLinkEdges) ) { CONSUMERS.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONSUMERS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( IC_CONSUMER.Value(p)*P_CELL_AREA.Value(p) );
			CONSUMERS.InitValue( p, value );
		}
		CONSUMERS.GrabMemory();
		if( CONSUMERS.GetF(FLinkEdges) ) { CONSUMERS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( IC_CONSUMER.Value()*P_CELL_AREA.Value() );
			CONSUMERS.InitValue( value );
	  } break;
	}
	CONSUMERS.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::CONS_INGEST_u2_exe() {
	float value;
	int array_index[64];


	switch( CONS_INGEST.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* CONS_INGEST_ptr = CONS_INGEST.DataStart();
		const float* CONS_INGEST_Eptr = CONS_INGEST.GridEnd();
		float dt = dT();
		float* CONS_INGEST_PHT_ptr = CONS_INGEST_PHT.DataStart();
		float* CONS_INGEST_SW_ptr = CONS_INGEST_SW.DataStart();
		float* COS_INGEST_DETR_ptr = COS_INGEST_DETR.DataStart();
		int clamped = 0;
		while( CONS_INGEST_ptr < CONS_INGEST_Eptr ) {
		 value =  ( ( (*(CONS_INGEST_PHT_ptr))+(*(CONS_INGEST_SW_ptr)) )+(*(COS_INGEST_DETR_ptr)) );
			*CONS_INGEST_ptr = value;
			CONS_INGEST_ptr++;
			CONS_INGEST_PHT.UpdateDataPtr(CONS_INGEST_PHT_ptr);
			CONS_INGEST_SW.UpdateDataPtr(CONS_INGEST_SW_ptr);
			COS_INGEST_DETR.UpdateDataPtr(COS_INGEST_DETR_ptr);
		}
		if( CONS_INGEST.GetF(FICFlux) ) CONS_INGEST.Cov().Set(0.0); 
		CONS_INGEST.GrabMemory();
		if( CONS_INGEST.GetF(FLinkEdges) ) { CONS_INGEST.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONS_INGEST.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( CONS_INGEST_PHT.Value(p)+CONS_INGEST_SW.Value(p) )+COS_INGEST_DETR.Value(p) );
			CONS_INGEST.Update( p, value );
		}
		CONS_INGEST.GrabMemory();
		if( CONS_INGEST.GetF(FICFlux) ) CONS_INGEST.Cov().Set(0.0); 
		if( CONS_INGEST.GetF(FLinkEdges) ) { CONS_INGEST.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( CONS_INGEST_PHT.Value()+CONS_INGEST_SW.Value() )+COS_INGEST_DETR.Value() );
			CONS_INGEST.Update( value );
	  } break;
	}
	CONS_INGEST.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::CONS_IN_X_u3_exe() {
	float value;
	int array_index[64];


	switch( CONS_IN_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONS_IN_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( ( ( ( CONSTOE.RelValue(p,0,-1,0,CVariable::kDefaultBC)+CONSTON.RelValue(p,1,0,0,CVariable::kDefaultBC) )+CONSTOS.RelValue(p,-1,0,0,CVariable::kDefaultBC) )+CONSTOW.RelValue(p,0,1,0,CVariable::kDefaultBC) )+CONSTOD.RelValue(p,0,0,-1,CVariable::kDefaultBC) )+CONSTOU.RelValue(p,0,0,1,CVariable::kDefaultBC) );
			CONS_IN_X.Update( p, value );
		}
		CONS_IN_X.GrabMemory();
		if( CONS_IN_X.GetF(FICFlux) ) CONS_IN_X.Cov().Set(0.0); 
		if( CONS_IN_X.GetF(FLinkEdges) ) { CONS_IN_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( ( ( ( CONSTOE.Value()+CONSTON.Value() )+CONSTOS.Value() )+CONSTOW.Value() )+CONSTOD.Value() )+CONSTOU.Value() );
			CONS_IN_X.Update( value );
	  } break;
	}
	CONS_IN_X.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::CONS_EGEST_u4_exe() {
	float value;
	int array_index[64];


	switch( CONS_EGEST.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* CONS_EGEST_ptr = CONS_EGEST.DataStart();
		const float* CONS_EGEST_Eptr = CONS_EGEST.GridEnd();
		float dt = dT();
		float* CONS_EGEST_Optr = ((CStateVariable*)(CONS_EGEST.Origin()))->RDataStart();
		float* CONS_INGEST_ptr = CONS_INGEST.DataStart();
		float* P_C_EGEST_EFF_ptr = P_C_EGEST_EFF.DataStart();
		int clamped = CONSUMERS.GetF(FisClamped);
		while( CONS_EGEST_ptr < CONS_EGEST_Eptr ) {
		 value =  ( (*(CONS_INGEST_ptr))*(*(P_C_EGEST_EFF_ptr)) );
			*CONS_EGEST_ptr = value;
			if( clamped ) { SL::Clamp(CONS_EGEST_Optr++,CONS_EGEST_ptr,dt); }
			CONS_EGEST_ptr++;
			CONS_INGEST.UpdateDataPtr(CONS_INGEST_ptr);
			P_C_EGEST_EFF.UpdateDataPtr(P_C_EGEST_EFF_ptr);
		}
		if( CONS_EGEST.GetF(FICFlux) ) CONS_EGEST.Cov().Set(0.0); 
		CONS_EGEST.GrabMemory();
		if( CONS_EGEST.GetF(FLinkEdges) ) { CONS_EGEST.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONS_EGEST.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( CONS_INGEST.Value(p)*P_C_EGEST_EFF.Value(p) );
			CONS_EGEST.Update( p, value );
		}
		CONS_EGEST.GrabMemory();
		if( CONS_EGEST.GetF(FICFlux) ) CONS_EGEST.Cov().Set(0.0); 
		if( CONS_EGEST.GetF(FLinkEdges) ) { CONS_EGEST.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( CONS_INGEST.Value()*P_C_EGEST_EFF.Value() );
			CONS_EGEST.Update( value );
	  } break;
	}
	CONS_EGEST.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::CONS_MORTALITY_u5_exe() {
	float value;
	int array_index[64];


	switch( CONS_MORTALITY.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* CONS_MORTALITY_ptr = CONS_MORTALITY.DataStart();
		const float* CONS_MORTALITY_Eptr = CONS_MORTALITY.GridEnd();
		float dt = dT();
		float* CONS_MORTALITY_Optr = ((CStateVariable*)(CONS_MORTALITY.Origin()))->RDataStart();
		float* CONSUMERS_ptr = CONSUMERS.DataStart();
		float* P_C_MORT_RT_ptr = P_C_MORT_RT.DataStart();
		int clamped = CONSUMERS.GetF(FisClamped);
		while( CONS_MORTALITY_ptr < CONS_MORTALITY_Eptr ) {
		 value =  ( (*(CONSUMERS_ptr))*( (*(P_C_MORT_RT_ptr))*dT() ) );
			*CONS_MORTALITY_ptr = value;
			if( clamped ) { SL::Clamp(CONS_MORTALITY_Optr++,CONS_MORTALITY_ptr,dt); }
			CONS_MORTALITY_ptr++;
			CONSUMERS.UpdateDataPtr(CONSUMERS_ptr);
			P_C_MORT_RT.UpdateDataPtr(P_C_MORT_RT_ptr);
		}
		if( CONS_MORTALITY.GetF(FICFlux) ) CONS_MORTALITY.Cov().Set(0.0); 
		CONS_MORTALITY.GrabMemory();
		if( CONS_MORTALITY.GetF(FLinkEdges) ) { CONS_MORTALITY.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONS_MORTALITY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( CONSUMERS.Value(p)*( P_C_MORT_RT.Value(p)*dT() ) );
			CONS_MORTALITY.Update( p, value );
		}
		CONS_MORTALITY.GrabMemory();
		if( CONS_MORTALITY.GetF(FICFlux) ) CONS_MORTALITY.Cov().Set(0.0); 
		if( CONS_MORTALITY.GetF(FLinkEdges) ) { CONS_MORTALITY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( CONSUMERS.Value()*( P_C_MORT_RT.Value()*dT() ) );
			CONS_MORTALITY.Update( value );
	  } break;
	}
	CONS_MORTALITY.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::CONS_RESPIRATION_u6_exe() {
	float value;
	int array_index[64];


	switch( CONS_RESPIRATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* CONS_RESPIRATION_ptr = CONS_RESPIRATION.DataStart();
		const float* CONS_RESPIRATION_Eptr = CONS_RESPIRATION.GridEnd();
		float dt = dT();
		float* CONS_RESPIRATION_Optr = ((CStateVariable*)(CONS_RESPIRATION.Origin()))->RDataStart();
		float* CONSUMERS_ptr = CONSUMERS.DataStart();
		float* CONS_ACTIVITY_ptr = CONS_ACTIVITY.DataStart();
		float* P_C_RESP_RT_ptr = P_C_RESP_RT.DataStart();
		int clamped = CONSUMERS.GetF(FisClamped);
		while( CONS_RESPIRATION_ptr < CONS_RESPIRATION_Eptr ) {
		 value =  ( ( (*(CONSUMERS_ptr))*(*(CONS_ACTIVITY_ptr)) )*( (*(P_C_RESP_RT_ptr))*dT() ) );
			*CONS_RESPIRATION_ptr = value;
			if( clamped ) { SL::Clamp(CONS_RESPIRATION_Optr++,CONS_RESPIRATION_ptr,dt); }
			CONS_RESPIRATION_ptr++;
			CONSUMERS.UpdateDataPtr(CONSUMERS_ptr);
			CONS_ACTIVITY.UpdateDataPtr(CONS_ACTIVITY_ptr);
			P_C_RESP_RT.UpdateDataPtr(P_C_RESP_RT_ptr);
		}
		if( CONS_RESPIRATION.GetF(FICFlux) ) CONS_RESPIRATION.Cov().Set(0.0); 
		CONS_RESPIRATION.GrabMemory();
		if( CONS_RESPIRATION.GetF(FLinkEdges) ) { CONS_RESPIRATION.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONS_RESPIRATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( CONSUMERS.Value(p)*CONS_ACTIVITY.Value(p) )*( P_C_RESP_RT.Value(p)*dT() ) );
			CONS_RESPIRATION.Update( p, value );
		}
		CONS_RESPIRATION.GrabMemory();
		if( CONS_RESPIRATION.GetF(FICFlux) ) CONS_RESPIRATION.Cov().Set(0.0); 
		if( CONS_RESPIRATION.GetF(FLinkEdges) ) { CONS_RESPIRATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( CONSUMERS.Value()*CONS_ACTIVITY.Value() )*( P_C_RESP_RT.Value()*dT() ) );
			CONS_RESPIRATION.Update( value );
	  } break;
	}
	CONS_RESPIRATION.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::CONS_OUT_X_u7_exe() {
	float value;
	int array_index[64];


	switch( CONS_OUT_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* CONS_OUT_X_ptr = CONS_OUT_X.DataStart();
		const float* CONS_OUT_X_Eptr = CONS_OUT_X.GridEnd();
		float dt = dT();
		float* CONS_OUT_X_Optr = ((CStateVariable*)(CONS_OUT_X.Origin()))->RDataStart();
		float* CONSTOE_ptr = CONSTOE.DataStart();
		float* CONSTON_ptr = CONSTON.DataStart();
		float* CONSTOS_ptr = CONSTOS.DataStart();
		float* CONSTOW_ptr = CONSTOW.DataStart();
		float* CONSTOD_ptr = CONSTOD.DataStart();
		float* CONSTOU_ptr = CONSTOU.DataStart();
		int clamped = CONSUMERS.GetF(FisClamped);
		while( CONS_OUT_X_ptr < CONS_OUT_X_Eptr ) {
		 value =  ( ( ( ( ( (*(CONSTOE_ptr))+(*(CONSTON_ptr)) )+(*(CONSTOS_ptr)) )+(*(CONSTOW_ptr)) )+(*(CONSTOD_ptr)) )+(*(CONSTOU_ptr)) );
			*CONS_OUT_X_ptr = value;
			if( clamped ) { SL::Clamp(CONS_OUT_X_Optr++,CONS_OUT_X_ptr,dt); }
			CONS_OUT_X_ptr++;
			CONSTOE.UpdateDataPtr(CONSTOE_ptr);
			CONSTON.UpdateDataPtr(CONSTON_ptr);
			CONSTOS.UpdateDataPtr(CONSTOS_ptr);
			CONSTOW.UpdateDataPtr(CONSTOW_ptr);
			CONSTOD.UpdateDataPtr(CONSTOD_ptr);
			CONSTOU.UpdateDataPtr(CONSTOU_ptr);
		}
		if( CONS_OUT_X.GetF(FICFlux) ) CONS_OUT_X.Cov().Set(0.0); 
		CONS_OUT_X.GrabMemory();
		if( CONS_OUT_X.GetF(FLinkEdges) ) { CONS_OUT_X.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONS_OUT_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( ( ( ( CONSTOE.Value(p)+CONSTON.Value(p) )+CONSTOS.Value(p) )+CONSTOW.Value(p) )+CONSTOD.Value(p) )+CONSTOU.Value(p) );
			CONS_OUT_X.Update( p, value );
		}
		CONS_OUT_X.GrabMemory();
		if( CONS_OUT_X.GetF(FICFlux) ) CONS_OUT_X.Cov().Set(0.0); 
		if( CONS_OUT_X.GetF(FLinkEdges) ) { CONS_OUT_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( ( ( ( CONSTOE.Value()+CONSTON.Value() )+CONSTOS.Value() )+CONSTOW.Value() )+CONSTOD.Value() )+CONSTOU.Value() );
			CONS_OUT_X.Update( value );
	  } break;
	}
	CONS_OUT_X.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::CONSDENS_u8_exe() {
	float value;
	int array_index[64];


	switch( CONSDENS.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* CONSDENS_ptr = CONSDENS.DataStart();
		const float* CONSDENS_Eptr = CONSDENS.GridEnd();
		float* RIVER_CON_ptr = RIVER_CON.DataStart();
		float* CONSUMERS_ptr = CONSUMERS.DataStart();
		float* P_CELL_AREA_ptr = P_CELL_AREA.DataStart();
		while( CONSDENS_ptr < CONSDENS_Eptr ) {
		 value =  ( ( (*(RIVER_CON_ptr))+(*(CONSUMERS_ptr)) )*(*(P_CELL_AREA_ptr)) );
			*CONSDENS_ptr = value;
			CONSDENS_ptr++;
			RIVER_CON.UpdateDataPtr(RIVER_CON_ptr);
			CONSUMERS.UpdateDataPtr(CONSUMERS_ptr);
			P_CELL_AREA.UpdateDataPtr(P_CELL_AREA_ptr);
		}
		CONSDENS.GrabMemory();
		if( CONSDENS.GetF(FLinkEdges) ) { CONSDENS.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONSDENS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( RIVER_CON.Value(p)+CONSUMERS.Value(p) )*P_CELL_AREA.Value(p) );
			CONSDENS.Update( p, value );
		}
		CONSDENS.GrabMemory();
		if( CONSDENS.GetF(FLinkEdges) ) { CONSDENS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( RIVER_CON.Value()+CONSUMERS.Value() )*P_CELL_AREA.Value() );
			CONSDENS.Update( value );
	  } break;
	}
	CONSDENS.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::CONSTOD_u9_exe() {
	float value;
	int array_index[64];


	switch( CONSTOD.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* CONSTOD_ptr = CONSTOD.DataStart();
		const float* CONSTOD_Eptr = CONSTOD.GridEnd();
		float* DENSITY_X_D_ptr = DENSITY_X_D.DataStart();
		float* FOOD_X_D_ptr = FOOD_X_D.DataStart();
		float* CONSUMERS_ptr = CONSUMERS.DataStart();
		while( CONSTOD_ptr < CONSTOD_Eptr ) {
		 value =  ( ( (*(DENSITY_X_D_ptr))+(*(FOOD_X_D_ptr)) )*(*(CONSUMERS_ptr)) );
			*CONSTOD_ptr = value;
			CONSTOD_ptr++;
			DENSITY_X_D.UpdateDataPtr(DENSITY_X_D_ptr);
			FOOD_X_D.UpdateDataPtr(FOOD_X_D_ptr);
			CONSUMERS.UpdateDataPtr(CONSUMERS_ptr);
		}
		CONSTOD.GrabMemory();
		if( CONSTOD.GetF(FLinkEdges) ) { CONSTOD.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONSTOD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( DENSITY_X_D.Value(p)+FOOD_X_D.Value(p) )*CONSUMERS.Value(p) );
			CONSTOD.Update( p, value );
		}
		CONSTOD.GrabMemory();
		if( CONSTOD.GetF(FLinkEdges) ) { CONSTOD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( DENSITY_X_D.Value()+FOOD_X_D.Value() )*CONSUMERS.Value() );
			CONSTOD.Update( value );
	  } break;
	}
	CONSTOD.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::CONSTOE_u10_exe() {
	float value;
	int array_index[64];


	switch( CONSTOE.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* CONSTOE_ptr = CONSTOE.DataStart();
		const float* CONSTOE_Eptr = CONSTOE.GridEnd();
		float* DENSITY_X_E_ptr = DENSITY_X_E.DataStart();
		float* FOOD_X_E_ptr = FOOD_X_E.DataStart();
		float* CONSUMERS_ptr = CONSUMERS.DataStart();
		while( CONSTOE_ptr < CONSTOE_Eptr ) {
		 value =  ( ( (*(DENSITY_X_E_ptr))+(*(FOOD_X_E_ptr)) )*(*(CONSUMERS_ptr)) );
			*CONSTOE_ptr = value;
			CONSTOE_ptr++;
			DENSITY_X_E.UpdateDataPtr(DENSITY_X_E_ptr);
			FOOD_X_E.UpdateDataPtr(FOOD_X_E_ptr);
			CONSUMERS.UpdateDataPtr(CONSUMERS_ptr);
		}
		CONSTOE.GrabMemory();
		if( CONSTOE.GetF(FLinkEdges) ) { CONSTOE.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONSTOE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( DENSITY_X_E.Value(p)+FOOD_X_E.Value(p) )*CONSUMERS.Value(p) );
			CONSTOE.Update( p, value );
		}
		CONSTOE.GrabMemory();
		if( CONSTOE.GetF(FLinkEdges) ) { CONSTOE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( DENSITY_X_E.Value()+FOOD_X_E.Value() )*CONSUMERS.Value() );
			CONSTOE.Update( value );
	  } break;
	}
	CONSTOE.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::CONSTON_u11_exe() {
	float value;
	int array_index[64];


	switch( CONSTON.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* CONSTON_ptr = CONSTON.DataStart();
		const float* CONSTON_Eptr = CONSTON.GridEnd();
		float* DENSITY_X_N_ptr = DENSITY_X_N.DataStart();
		float* FOOD_X_N_ptr = FOOD_X_N.DataStart();
		float* CONSUMERS_ptr = CONSUMERS.DataStart();
		while( CONSTON_ptr < CONSTON_Eptr ) {
		 value =  ( ( (*(DENSITY_X_N_ptr))+(*(FOOD_X_N_ptr)) )*(*(CONSUMERS_ptr)) );
			*CONSTON_ptr = value;
			CONSTON_ptr++;
			DENSITY_X_N.UpdateDataPtr(DENSITY_X_N_ptr);
			FOOD_X_N.UpdateDataPtr(FOOD_X_N_ptr);
			CONSUMERS.UpdateDataPtr(CONSUMERS_ptr);
		}
		CONSTON.GrabMemory();
		if( CONSTON.GetF(FLinkEdges) ) { CONSTON.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONSTON.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( DENSITY_X_N.Value(p)+FOOD_X_N.Value(p) )*CONSUMERS.Value(p) );
			CONSTON.Update( p, value );
		}
		CONSTON.GrabMemory();
		if( CONSTON.GetF(FLinkEdges) ) { CONSTON.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( DENSITY_X_N.Value()+FOOD_X_N.Value() )*CONSUMERS.Value() );
			CONSTON.Update( value );
	  } break;
	}
	CONSTON.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::CONSTOS_u12_exe() {
	float value;
	int array_index[64];


	switch( CONSTOS.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* CONSTOS_ptr = CONSTOS.DataStart();
		const float* CONSTOS_Eptr = CONSTOS.GridEnd();
		float* DENSITY_X_S_ptr = DENSITY_X_S.DataStart();
		float* FOOD_X_S_ptr = FOOD_X_S.DataStart();
		float* CONSUMERS_ptr = CONSUMERS.DataStart();
		while( CONSTOS_ptr < CONSTOS_Eptr ) {
		 value =  ( ( (*(DENSITY_X_S_ptr))+(*(FOOD_X_S_ptr)) )*(*(CONSUMERS_ptr)) );
			*CONSTOS_ptr = value;
			CONSTOS_ptr++;
			DENSITY_X_S.UpdateDataPtr(DENSITY_X_S_ptr);
			FOOD_X_S.UpdateDataPtr(FOOD_X_S_ptr);
			CONSUMERS.UpdateDataPtr(CONSUMERS_ptr);
		}
		CONSTOS.GrabMemory();
		if( CONSTOS.GetF(FLinkEdges) ) { CONSTOS.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONSTOS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( DENSITY_X_S.Value(p)+FOOD_X_S.Value(p) )*CONSUMERS.Value(p) );
			CONSTOS.Update( p, value );
		}
		CONSTOS.GrabMemory();
		if( CONSTOS.GetF(FLinkEdges) ) { CONSTOS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( DENSITY_X_S.Value()+FOOD_X_S.Value() )*CONSUMERS.Value() );
			CONSTOS.Update( value );
	  } break;
	}
	CONSTOS.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::CONSTOU_u13_exe() {
	float value;
	int array_index[64];


	switch( CONSTOU.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* CONSTOU_ptr = CONSTOU.DataStart();
		const float* CONSTOU_Eptr = CONSTOU.GridEnd();
		float* DENSITY_X_U_ptr = DENSITY_X_U.DataStart();
		float* FOOD_X_UP_ptr = FOOD_X_UP.DataStart();
		float* CONSUMERS_ptr = CONSUMERS.DataStart();
		while( CONSTOU_ptr < CONSTOU_Eptr ) {
		 value =  ( ( (*(DENSITY_X_U_ptr))+(*(FOOD_X_UP_ptr)) )*(*(CONSUMERS_ptr)) );
			*CONSTOU_ptr = value;
			CONSTOU_ptr++;
			DENSITY_X_U.UpdateDataPtr(DENSITY_X_U_ptr);
			FOOD_X_UP.UpdateDataPtr(FOOD_X_UP_ptr);
			CONSUMERS.UpdateDataPtr(CONSUMERS_ptr);
		}
		CONSTOU.GrabMemory();
		if( CONSTOU.GetF(FLinkEdges) ) { CONSTOU.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONSTOU.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( DENSITY_X_U.Value(p)+FOOD_X_UP.Value(p) )*CONSUMERS.Value(p) );
			CONSTOU.Update( p, value );
		}
		CONSTOU.GrabMemory();
		if( CONSTOU.GetF(FLinkEdges) ) { CONSTOU.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( DENSITY_X_U.Value()+FOOD_X_UP.Value() )*CONSUMERS.Value() );
			CONSTOU.Update( value );
	  } break;
	}
	CONSTOU.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::CONSTOW_u14_exe() {
	float value;
	int array_index[64];


	switch( CONSTOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* CONSTOW_ptr = CONSTOW.DataStart();
		const float* CONSTOW_Eptr = CONSTOW.GridEnd();
		float* DENSITY_X_W_ptr = DENSITY_X_W.DataStart();
		float* FOOD_X_W_ptr = FOOD_X_W.DataStart();
		float* CONSUMERS_ptr = CONSUMERS.DataStart();
		while( CONSTOW_ptr < CONSTOW_Eptr ) {
		 value =  ( ( (*(DENSITY_X_W_ptr))+(*(FOOD_X_W_ptr)) )*(*(CONSUMERS_ptr)) );
			*CONSTOW_ptr = value;
			CONSTOW_ptr++;
			DENSITY_X_W.UpdateDataPtr(DENSITY_X_W_ptr);
			FOOD_X_W.UpdateDataPtr(FOOD_X_W_ptr);
			CONSUMERS.UpdateDataPtr(CONSUMERS_ptr);
		}
		CONSTOW.GrabMemory();
		if( CONSTOW.GetF(FLinkEdges) ) { CONSTOW.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONSTOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( DENSITY_X_W.Value(p)+FOOD_X_W.Value(p) )*CONSUMERS.Value(p) );
			CONSTOW.Update( p, value );
		}
		CONSTOW.GrabMemory();
		if( CONSTOW.GetF(FLinkEdges) ) { CONSTOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( DENSITY_X_W.Value()+FOOD_X_W.Value() )*CONSUMERS.Value() );
			CONSTOW.Update( value );
	  } break;
	}
	CONSTOW.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::CONS_INGEST_PHT_u15_exe() {
	float value;
	int array_index[64];


	switch( CONS_INGEST_PHT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* CONS_INGEST_PHT_ptr = CONS_INGEST_PHT.DataStart();
		const float* CONS_INGEST_PHT_Eptr = CONS_INGEST_PHT.GridEnd();
		float* PHYTOPLANKTON_ptr = PHYTOPLANKTON.DataStart();
		float* P_PH_PREF_ptr = P_PH_PREF.DataStart();
		float* PREF_TOT_ptr = PREF_TOT.DataStart();
		float* CON_POT_INGEST_ptr = CON_POT_INGEST.DataStart();
		while( CONS_INGEST_PHT_ptr < CONS_INGEST_PHT_Eptr ) {
		 value =  SL::Min((*(PHYTOPLANKTON_ptr)), ( ( (*(P_PH_PREF_ptr))/(*(PREF_TOT_ptr)) )*(*(CON_POT_INGEST_ptr)) ));
			*CONS_INGEST_PHT_ptr = value;
			CONS_INGEST_PHT_ptr++;
			PHYTOPLANKTON.UpdateDataPtr(PHYTOPLANKTON_ptr);
			P_PH_PREF.UpdateDataPtr(P_PH_PREF_ptr);
			PREF_TOT.UpdateDataPtr(PREF_TOT_ptr);
			CON_POT_INGEST.UpdateDataPtr(CON_POT_INGEST_ptr);
		}
		CONS_INGEST_PHT.GrabMemory();
		if( CONS_INGEST_PHT.GetF(FLinkEdges) ) { CONS_INGEST_PHT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONS_INGEST_PHT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  SL::Min(PHYTOPLANKTON.Value(p), ( ( P_PH_PREF.Value(p)/PREF_TOT.Value(p) )*CON_POT_INGEST.Value(p) ));
			CONS_INGEST_PHT.Update( p, value );
		}
		CONS_INGEST_PHT.GrabMemory();
		if( CONS_INGEST_PHT.GetF(FLinkEdges) ) { CONS_INGEST_PHT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  SL::Min(PHYTOPLANKTON.Value(), ( ( P_PH_PREF.Value()/PREF_TOT.Value() )*CON_POT_INGEST.Value() ));
			CONS_INGEST_PHT.Update( value );
	  } break;
	}
	CONS_INGEST_PHT.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::CONS_INGEST_SW_u16_exe() {
	float value;
	int array_index[64];


	switch( CONS_INGEST_SW.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* CONS_INGEST_SW_ptr = CONS_INGEST_SW.DataStart();
		const float* CONS_INGEST_SW_Eptr = CONS_INGEST_SW.GridEnd();
		float* SEAWEEDS_ptr = SEAWEEDS.DataStart();
		float* P_SW_PREF_ptr = P_SW_PREF.DataStart();
		float* PREF_TOT_ptr = PREF_TOT.DataStart();
		float* CON_POT_INGEST_ptr = CON_POT_INGEST.DataStart();
		while( CONS_INGEST_SW_ptr < CONS_INGEST_SW_Eptr ) {
		 value =  SL::Min((*(SEAWEEDS_ptr)), ( ( (*(P_SW_PREF_ptr))/(*(PREF_TOT_ptr)) )*(*(CON_POT_INGEST_ptr)) ));
			*CONS_INGEST_SW_ptr = value;
			CONS_INGEST_SW_ptr++;
			SEAWEEDS.UpdateDataPtr(SEAWEEDS_ptr);
			P_SW_PREF.UpdateDataPtr(P_SW_PREF_ptr);
			PREF_TOT.UpdateDataPtr(PREF_TOT_ptr);
			CON_POT_INGEST.UpdateDataPtr(CON_POT_INGEST_ptr);
		}
		CONS_INGEST_SW.GrabMemory();
		if( CONS_INGEST_SW.GetF(FLinkEdges) ) { CONS_INGEST_SW.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONS_INGEST_SW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  SL::Min(SEAWEEDS.Value(p), ( ( P_SW_PREF.Value(p)/PREF_TOT.Value(p) )*CON_POT_INGEST.Value(p) ));
			CONS_INGEST_SW.Update( p, value );
		}
		CONS_INGEST_SW.GrabMemory();
		if( CONS_INGEST_SW.GetF(FLinkEdges) ) { CONS_INGEST_SW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  SL::Min(SEAWEEDS.Value(), ( ( P_SW_PREF.Value()/PREF_TOT.Value() )*CON_POT_INGEST.Value() ));
			CONS_INGEST_SW.Update( value );
	  } break;
	}
	CONS_INGEST_SW.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::CON_POT_INGEST_u17_exe() {
	float value;
	int array_index[64];


	switch( CON_POT_INGEST.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* CON_POT_INGEST_ptr = CON_POT_INGEST.DataStart();
		const float* CON_POT_INGEST_Eptr = CON_POT_INGEST.GridEnd();
		float* OMTOTBIO_ptr = OMTOTBIO.DataStart();
		float* P_INGESTION_RT_ptr = P_INGESTION_RT.DataStart();
		float* CONS_ACTIVITY_ptr = CONS_ACTIVITY.DataStart();
		float* CONSUMERS_ptr = CONSUMERS.DataStart();
		while( CON_POT_INGEST_ptr < CON_POT_INGEST_Eptr ) {
		 value =  SL::Min((*(OMTOTBIO_ptr)), ( ( (*(P_INGESTION_RT_ptr))*(*(CONS_ACTIVITY_ptr)) )*(*(CONSUMERS_ptr)) ));
			*CON_POT_INGEST_ptr = value;
			CON_POT_INGEST_ptr++;
			OMTOTBIO.UpdateDataPtr(OMTOTBIO_ptr);
			P_INGESTION_RT.UpdateDataPtr(P_INGESTION_RT_ptr);
			CONS_ACTIVITY.UpdateDataPtr(CONS_ACTIVITY_ptr);
			CONSUMERS.UpdateDataPtr(CONSUMERS_ptr);
		}
		CON_POT_INGEST.GrabMemory();
		if( CON_POT_INGEST.GetF(FLinkEdges) ) { CON_POT_INGEST.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = CON_POT_INGEST.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  SL::Min(OMTOTBIO.Value(p), ( ( P_INGESTION_RT.Value(p)*CONS_ACTIVITY.Value(p) )*CONSUMERS.Value(p) ));
			CON_POT_INGEST.Update( p, value );
		}
		CON_POT_INGEST.GrabMemory();
		if( CON_POT_INGEST.GetF(FLinkEdges) ) { CON_POT_INGEST.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  SL::Min(OMTOTBIO.Value(), ( ( P_INGESTION_RT.Value()*CONS_ACTIVITY.Value() )*CONSUMERS.Value() ));
			CON_POT_INGEST.Update( value );
	  } break;
	}
	CON_POT_INGEST.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::COS_INGEST_DETR_u18_exe() {
	float value;
	int array_index[64];


	switch( COS_INGEST_DETR.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* COS_INGEST_DETR_ptr = COS_INGEST_DETR.DataStart();
		const float* COS_INGEST_DETR_Eptr = COS_INGEST_DETR.GridEnd();
		float* DETRITUS_ptr = DETRITUS.DataStart();
		float* P_DETR_PREF_ptr = P_DETR_PREF.DataStart();
		float* PREF_TOT_ptr = PREF_TOT.DataStart();
		float* CON_POT_INGEST_ptr = CON_POT_INGEST.DataStart();
		while( COS_INGEST_DETR_ptr < COS_INGEST_DETR_Eptr ) {
		 value =  SL::Min((*(DETRITUS_ptr)), ( ( (*(P_DETR_PREF_ptr))/(*(PREF_TOT_ptr)) )*(*(CON_POT_INGEST_ptr)) ));
			*COS_INGEST_DETR_ptr = value;
			COS_INGEST_DETR_ptr++;
			DETRITUS.UpdateDataPtr(DETRITUS_ptr);
			P_DETR_PREF.UpdateDataPtr(P_DETR_PREF_ptr);
			PREF_TOT.UpdateDataPtr(PREF_TOT_ptr);
			CON_POT_INGEST.UpdateDataPtr(CON_POT_INGEST_ptr);
		}
		COS_INGEST_DETR.GrabMemory();
		if( COS_INGEST_DETR.GetF(FLinkEdges) ) { COS_INGEST_DETR.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = COS_INGEST_DETR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  SL::Min(DETRITUS.Value(p), ( ( P_DETR_PREF.Value(p)/PREF_TOT.Value(p) )*CON_POT_INGEST.Value(p) ));
			COS_INGEST_DETR.Update( p, value );
		}
		COS_INGEST_DETR.GrabMemory();
		if( COS_INGEST_DETR.GetF(FLinkEdges) ) { COS_INGEST_DETR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  SL::Min(DETRITUS.Value(), ( ( P_DETR_PREF.Value()/PREF_TOT.Value() )*CON_POT_INGEST.Value() ));
			COS_INGEST_DETR.Update( value );
	  } break;
	}
	COS_INGEST_DETR.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::DENSITY_X_D_u19_exe() {
	float value;
	int array_index[64];


	switch( DENSITY_X_D.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DENSITY_X_D.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( ( CONSDENS.Value(p) <= CONSDENS.RelValue(p,0,0,1,CVariable::kDefaultBC) ) || ( CONSDENS.Value(p) <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME_DENS.Value(p)*( CONSDENS.Value(p)-CONSDENS.RelValue(p,0,0,1,CVariable::kDefaultBC) ) )/CONSDENS.Value(p) ) ) ) ;
			DENSITY_X_D.Update( p, value );
		}
		DENSITY_X_D.GrabMemory();
		if( DENSITY_X_D.GetF(FLinkEdges) ) { DENSITY_X_D.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( ( CONSDENS.Value() <= CONSDENS.Value() ) || ( CONSDENS.Value() <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME_DENS.Value()*( CONSDENS.Value()-CONSDENS.Value() ) )/CONSDENS.Value() ) ) ) ;
			DENSITY_X_D.Update( value );
	  } break;
	}
	DENSITY_X_D.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::DENSITY_X_E_u20_exe() {
	float value;
	int array_index[64];


	switch( DENSITY_X_E.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DENSITY_X_E.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( ( CONSDENS.Value(p) <= CONSDENS.RelValue(p,0,1,0,CVariable::kDefaultBC) ) || ( CONSDENS.Value(p) <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME_DENS.Value(p)*( CONSDENS.Value(p)-CONSDENS.RelValue(p,0,1,0,CVariable::kDefaultBC) ) )/CONSDENS.Value(p) ) ) ) ;
			DENSITY_X_E.Update( p, value );
		}
		DENSITY_X_E.GrabMemory();
		if( DENSITY_X_E.GetF(FLinkEdges) ) { DENSITY_X_E.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( ( CONSDENS.Value() <= CONSDENS.Value() ) || ( CONSDENS.Value() <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME_DENS.Value()*( CONSDENS.Value()-CONSDENS.Value() ) )/CONSDENS.Value() ) ) ) ;
			DENSITY_X_E.Update( value );
	  } break;
	}
	DENSITY_X_E.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::DENSITY_X_N_u21_exe() {
	float value;
	int array_index[64];


	switch( DENSITY_X_N.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DENSITY_X_N.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( ( CONSDENS.Value(p) <= CONSDENS.RelValue(p,-1,0,0,CVariable::kDefaultBC) ) || ( CONSDENS.Value(p) <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME_DENS.Value(p)*( CONSDENS.Value(p)-CONSDENS.RelValue(p,-1,0,0,CVariable::kDefaultBC) ) )/CONSDENS.Value(p) ) ) ) ;
			DENSITY_X_N.Update( p, value );
		}
		DENSITY_X_N.GrabMemory();
		if( DENSITY_X_N.GetF(FLinkEdges) ) { DENSITY_X_N.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( ( CONSDENS.Value() <= CONSDENS.Value() ) || ( CONSDENS.Value() <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME_DENS.Value()*( CONSDENS.Value()-CONSDENS.Value() ) )/CONSDENS.Value() ) ) ) ;
			DENSITY_X_N.Update( value );
	  } break;
	}
	DENSITY_X_N.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::DENSITY_X_S_u22_exe() {
	float value;
	int array_index[64];


	switch( DENSITY_X_S.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DENSITY_X_S.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( ( CONSDENS.Value(p) <= CONSDENS.RelValue(p,1,0,0,CVariable::kDefaultBC) ) || ( CONSDENS.Value(p) <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME_DENS.Value(p)*( CONSDENS.Value(p)-CONSDENS.RelValue(p,1,0,0,CVariable::kDefaultBC) ) )/CONSDENS.Value(p) ) ) ) ;
			DENSITY_X_S.Update( p, value );
		}
		DENSITY_X_S.GrabMemory();
		if( DENSITY_X_S.GetF(FLinkEdges) ) { DENSITY_X_S.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( ( CONSDENS.Value() <= CONSDENS.Value() ) || ( CONSDENS.Value() <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME_DENS.Value()*( CONSDENS.Value()-CONSDENS.Value() ) )/CONSDENS.Value() ) ) ) ;
			DENSITY_X_S.Update( value );
	  } break;
	}
	DENSITY_X_S.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::DENSITY_X_U_u23_exe() {
	float value;
	int array_index[64];


	switch( DENSITY_X_U.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DENSITY_X_U.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( ( CONSDENS.Value(p) <= CONSDENS.RelValue(p,0,0,-1,CVariable::kDefaultBC) ) || ( CONSDENS.Value(p) <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME_DENS.Value(p)*( CONSDENS.Value(p)-CONSDENS.RelValue(p,0,0,-1,CVariable::kDefaultBC) ) )/CONSDENS.Value(p) ) ) ) ;
			DENSITY_X_U.Update( p, value );
		}
		DENSITY_X_U.GrabMemory();
		if( DENSITY_X_U.GetF(FLinkEdges) ) { DENSITY_X_U.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( ( CONSDENS.Value() <= CONSDENS.Value() ) || ( CONSDENS.Value() <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME_DENS.Value()*( CONSDENS.Value()-CONSDENS.Value() ) )/CONSDENS.Value() ) ) ) ;
			DENSITY_X_U.Update( value );
	  } break;
	}
	DENSITY_X_U.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::DENSITY_X_W_u24_exe() {
	float value;
	int array_index[64];


	switch( DENSITY_X_W.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DENSITY_X_W.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( ( CONSDENS.Value(p) <= CONSDENS.RelValue(p,0,-1,0,CVariable::kDefaultBC) ) || ( CONSDENS.Value(p) <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME_DENS.Value(p)*( CONSDENS.Value(p)-CONSDENS.RelValue(p,0,-1,0,CVariable::kDefaultBC) ) )/CONSDENS.Value(p) ) ) ) ;
			DENSITY_X_W.Update( p, value );
		}
		DENSITY_X_W.GrabMemory();
		if( DENSITY_X_W.GetF(FLinkEdges) ) { DENSITY_X_W.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( ( CONSDENS.Value() <= CONSDENS.Value() ) || ( CONSDENS.Value() <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME_DENS.Value()*( CONSDENS.Value()-CONSDENS.Value() ) )/CONSDENS.Value() ) ) ) ;
			DENSITY_X_W.Update( value );
	  } break;
	}
	DENSITY_X_W.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::FOOD_X_D_u25_exe() {
	float value;
	int array_index[64];


	switch( FOOD_X_D.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FOOD_X_D.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( ( OMTOTBIO.Value(p) >= OMTOTBIO.RelValue(p,0,0,-1,CVariable::kDefaultBC) ) || ( OMTOTBIO.Value(p) <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME.Value(p)*( OMTOTBIO.RelValue(p,0,0,-1,CVariable::kDefaultBC)-OMTOTBIO.Value(p) ) )/OMTOTBIO.Value(p) ) ) ) ;
			FOOD_X_D.Update( p, value );
		}
		FOOD_X_D.GrabMemory();
		if( FOOD_X_D.GetF(FLinkEdges) ) { FOOD_X_D.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( ( OMTOTBIO.Value() >= OMTOTBIO.Value() ) || ( OMTOTBIO.Value() <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME.Value()*( OMTOTBIO.Value()-OMTOTBIO.Value() ) )/OMTOTBIO.Value() ) ) ) ;
			FOOD_X_D.Update( value );
	  } break;
	}
	FOOD_X_D.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::FOOD_X_E_u26_exe() {
	float value;
	int array_index[64];


	switch( FOOD_X_E.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FOOD_X_E.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( ( OMTOTBIO.Value(p) >= OMTOTBIO.RelValue(p,0,1,0,CVariable::kDefaultBC) ) || ( OMTOTBIO.Value(p) <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME.Value(p)*( OMTOTBIO.RelValue(p,0,1,0,CVariable::kDefaultBC)-OMTOTBIO.Value(p) ) )/OMTOTBIO.Value(p) ) ) ) ;
			FOOD_X_E.Update( p, value );
		}
		FOOD_X_E.GrabMemory();
		if( FOOD_X_E.GetF(FLinkEdges) ) { FOOD_X_E.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( ( OMTOTBIO.Value() >= OMTOTBIO.Value() ) || ( OMTOTBIO.Value() <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME.Value()*( OMTOTBIO.Value()-OMTOTBIO.Value() ) )/OMTOTBIO.Value() ) ) ) ;
			FOOD_X_E.Update( value );
	  } break;
	}
	FOOD_X_E.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::FOOD_X_N_u27_exe() {
	float value;
	int array_index[64];


	switch( FOOD_X_N.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FOOD_X_N.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( ( OMTOTBIO.Value(p) >= OMTOTBIO.RelValue(p,-1,0,0,CVariable::kDefaultBC) ) || ( OMTOTBIO.Value(p) <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME.Value(p)*( OMTOTBIO.RelValue(p,-1,0,0,CVariable::kDefaultBC)-OMTOTBIO.Value(p) ) )/OMTOTBIO.Value(p) ) ) ) ;
			FOOD_X_N.Update( p, value );
		}
		FOOD_X_N.GrabMemory();
		if( FOOD_X_N.GetF(FLinkEdges) ) { FOOD_X_N.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( ( OMTOTBIO.Value() >= OMTOTBIO.Value() ) || ( OMTOTBIO.Value() <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME.Value()*( OMTOTBIO.Value()-OMTOTBIO.Value() ) )/OMTOTBIO.Value() ) ) ) ;
			FOOD_X_N.Update( value );
	  } break;
	}
	FOOD_X_N.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::FOOD_X_S_u28_exe() {
	float value;
	int array_index[64];


	switch( FOOD_X_S.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FOOD_X_S.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( ( OMTOTBIO.Value(p) >= OMTOTBIO.RelValue(p,1,0,0,CVariable::kDefaultBC) ) || ( OMTOTBIO.Value(p) <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME.Value(p)*( OMTOTBIO.RelValue(p,1,0,0,CVariable::kDefaultBC)-OMTOTBIO.Value(p) ) )/OMTOTBIO.Value(p) ) ) ) ;
			FOOD_X_S.Update( p, value );
		}
		FOOD_X_S.GrabMemory();
		if( FOOD_X_S.GetF(FLinkEdges) ) { FOOD_X_S.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( ( OMTOTBIO.Value() >= OMTOTBIO.Value() ) || ( OMTOTBIO.Value() <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME.Value()*( OMTOTBIO.Value()-OMTOTBIO.Value() ) )/OMTOTBIO.Value() ) ) ) ;
			FOOD_X_S.Update( value );
	  } break;
	}
	FOOD_X_S.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::FOOD_X_UP_u29_exe() {
	float value;
	int array_index[64];


	switch( FOOD_X_UP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FOOD_X_UP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( ( OMTOTBIO.Value(p) >= OMTOTBIO.RelValue(p,0,0,1,CVariable::kDefaultBC) ) || ( OMTOTBIO.Value(p) <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME.Value(p)*( OMTOTBIO.RelValue(p,0,0,1,CVariable::kDefaultBC)-OMTOTBIO.Value(p) ) )/OMTOTBIO.Value(p) ) ) ) ;
			FOOD_X_UP.Update( p, value );
		}
		FOOD_X_UP.GrabMemory();
		if( FOOD_X_UP.GetF(FLinkEdges) ) { FOOD_X_UP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( ( OMTOTBIO.Value() >= OMTOTBIO.Value() ) || ( OMTOTBIO.Value() <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME.Value()*( OMTOTBIO.Value()-OMTOTBIO.Value() ) )/OMTOTBIO.Value() ) ) ) ;
			FOOD_X_UP.Update( value );
	  } break;
	}
	FOOD_X_UP.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::FOOD_X_W_u30_exe() {
	float value;
	int array_index[64];


	switch( FOOD_X_W.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FOOD_X_W.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( ( OMTOTBIO.Value(p) >= OMTOTBIO.RelValue(p,0,-1,0,CVariable::kDefaultBC) ) || ( OMTOTBIO.Value(p) <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME.Value(p)*( OMTOTBIO.RelValue(p,0,-1,0,CVariable::kDefaultBC)-OMTOTBIO.Value(p) ) )/OMTOTBIO.Value(p) ) ) ) ;
			FOOD_X_W.Update( p, value );
		}
		FOOD_X_W.GrabMemory();
		if( FOOD_X_W.GetF(FLinkEdges) ) { FOOD_X_W.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( ( OMTOTBIO.Value() >= OMTOTBIO.Value() ) || ( OMTOTBIO.Value() <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME.Value()*( OMTOTBIO.Value()-OMTOTBIO.Value() ) )/OMTOTBIO.Value() ) ) ) ;
			FOOD_X_W.Update( value );
	  } break;
	}
	FOOD_X_W.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::IC_CONSUMER_u31_exe() {
	float value;
	int array_index[64];


	switch( IC_CONSUMER.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* IC_CONSUMER_ptr = IC_CONSUMER.DataStart();
		const float* IC_CONSUMER_Eptr = IC_CONSUMER.GridEnd();
		 value =  0.001000;
		value = IC_CONSUMER.ParameterValue(value);
		while( IC_CONSUMER_ptr < IC_CONSUMER_Eptr ) {
			*IC_CONSUMER_ptr = value;
			IC_CONSUMER_ptr++;
		}
		IC_CONSUMER.GrabMemory();
		if( IC_CONSUMER.GetF(FLinkEdges) ) { IC_CONSUMER.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = IC_CONSUMER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.001000;
			IC_CONSUMER.Update( p, IC_CONSUMER.ParameterValue(value,p) );
		}
		IC_CONSUMER.GrabMemory();
		if( IC_CONSUMER.GetF(FLinkEdges) ) { IC_CONSUMER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.001000;
			IC_CONSUMER.Update( IC_CONSUMER.ParameterValue(value) );
	  } break;
	}
	IC_CONSUMER.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::OMTOTBIO_u32_exe() {
	float value;
	int array_index[64];


	switch( OMTOTBIO.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* OMTOTBIO_ptr = OMTOTBIO.DataStart();
		const float* OMTOTBIO_Eptr = OMTOTBIO.GridEnd();
		float* PHYTOPLANKTON_ptr = PHYTOPLANKTON.DataStart();
		float* SEAWEEDS_ptr = SEAWEEDS.DataStart();
		float* DETRITUS_ptr = DETRITUS.DataStart();
		while( OMTOTBIO_ptr < OMTOTBIO_Eptr ) {
		 value =  ( ( (*(PHYTOPLANKTON_ptr))+(*(SEAWEEDS_ptr)) )+(*(DETRITUS_ptr)) );
			*OMTOTBIO_ptr = value;
			OMTOTBIO_ptr++;
			PHYTOPLANKTON.UpdateDataPtr(PHYTOPLANKTON_ptr);
			SEAWEEDS.UpdateDataPtr(SEAWEEDS_ptr);
			DETRITUS.UpdateDataPtr(DETRITUS_ptr);
		}
		OMTOTBIO.GrabMemory();
		if( OMTOTBIO.GetF(FLinkEdges) ) { OMTOTBIO.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = OMTOTBIO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( PHYTOPLANKTON.Value(p)+SEAWEEDS.Value(p) )+DETRITUS.Value(p) );
			OMTOTBIO.Update( p, value );
		}
		OMTOTBIO.GrabMemory();
		if( OMTOTBIO.GetF(FLinkEdges) ) { OMTOTBIO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( PHYTOPLANKTON.Value()+SEAWEEDS.Value() )+DETRITUS.Value() );
			OMTOTBIO.Update( value );
	  } break;
	}
	OMTOTBIO.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::PREF_TOT_u33_exe() {
	float value;
	int array_index[64];


	switch( PREF_TOT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* PREF_TOT_ptr = PREF_TOT.DataStart();
		const float* PREF_TOT_Eptr = PREF_TOT.GridEnd();
		float* P_PH_PREF_ptr = P_PH_PREF.DataStart();
		float* P_SW_PREF_ptr = P_SW_PREF.DataStart();
		while( PREF_TOT_ptr < PREF_TOT_Eptr ) {
		 value =  ( (*(P_PH_PREF_ptr))+(*(P_SW_PREF_ptr)) );
			*PREF_TOT_ptr = value;
			PREF_TOT_ptr++;
			P_PH_PREF.UpdateDataPtr(P_PH_PREF_ptr);
			P_SW_PREF.UpdateDataPtr(P_SW_PREF_ptr);
		}
		PREF_TOT.GrabMemory();
		if( PREF_TOT.GetF(FLinkEdges) ) { PREF_TOT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = PREF_TOT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( P_PH_PREF.Value(p)+P_SW_PREF.Value(p) );
			PREF_TOT.Update( p, value );
		}
		PREF_TOT.GrabMemory();
		if( PREF_TOT.GetF(FLinkEdges) ) { PREF_TOT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( P_PH_PREF.Value()+P_SW_PREF.Value() );
			PREF_TOT.Update( value );
	  } break;
	}
	PREF_TOT.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::RIVER_CON_u34_exe() {
	float value;
	int array_index[64];


	switch( RIVER_CON.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* RIVER_CON_ptr = RIVER_CON.DataStart();
		const float* RIVER_CON_Eptr = RIVER_CON.GridEnd();
		 value =  0;
		value = RIVER_CON.ParameterValue(value);
		while( RIVER_CON_ptr < RIVER_CON_Eptr ) {
			*RIVER_CON_ptr = value;
			RIVER_CON_ptr++;
		}
		RIVER_CON.GrabMemory();
		if( RIVER_CON.GetF(FLinkEdges) ) { RIVER_CON.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = RIVER_CON.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0;
			RIVER_CON.Update( p, RIVER_CON.ParameterValue(value,p) );
		}
		RIVER_CON.GrabMemory();
		if( RIVER_CON.GetF(FLinkEdges) ) { RIVER_CON.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0;
			RIVER_CON.Update( RIVER_CON.ParameterValue(value) );
	  } break;
	}
	RIVER_CON.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::VEG_STRUCTURE_u35_exe() {
	float value;
	int array_index[64];


	switch( VEG_STRUCTURE.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* VEG_STRUCTURE_ptr = VEG_STRUCTURE.DataStart();
		const float* VEG_STRUCTURE_Eptr = VEG_STRUCTURE.GridEnd();
		float* P_VEG_DENS_COEFF_ptr = P_VEG_DENS_COEFF.DataStart();
		float* P_CELL_AREA_ptr = P_CELL_AREA.DataStart();
		float* SEAWEEDS_ptr = SEAWEEDS.DataStart();
		while( VEG_STRUCTURE_ptr < VEG_STRUCTURE_Eptr ) {
		 value =  ( ( (*(P_VEG_DENS_COEFF_ptr))/(*(P_CELL_AREA_ptr)) )*(*(SEAWEEDS_ptr)) );
			*VEG_STRUCTURE_ptr = value;
			VEG_STRUCTURE_ptr++;
			P_VEG_DENS_COEFF.UpdateDataPtr(P_VEG_DENS_COEFF_ptr);
			P_CELL_AREA.UpdateDataPtr(P_CELL_AREA_ptr);
			SEAWEEDS.UpdateDataPtr(SEAWEEDS_ptr);
		}
		VEG_STRUCTURE.GrabMemory();
		if( VEG_STRUCTURE.GetF(FLinkEdges) ) { VEG_STRUCTURE.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = VEG_STRUCTURE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( P_VEG_DENS_COEFF.Value(p)/P_CELL_AREA.Value(p) )*SEAWEEDS.Value(p) );
			VEG_STRUCTURE.Update( p, value );
		}
		VEG_STRUCTURE.GrabMemory();
		if( VEG_STRUCTURE.GetF(FLinkEdges) ) { VEG_STRUCTURE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( P_VEG_DENS_COEFF.Value()/P_CELL_AREA.Value() )*SEAWEEDS.Value() );
			VEG_STRUCTURE.Update( value );
	  } break;
	}
	VEG_STRUCTURE.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::P_CONS_NC_u36_exe() {
	float value;
	int array_index[64];


	switch( P_CONS_NC.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_CONS_NC_ptr = P_CONS_NC.DataStart();
		const float* P_CONS_NC_Eptr = P_CONS_NC.GridEnd();
		 value =  0.010000;
		value = P_CONS_NC.ParameterValue(value);
		while( P_CONS_NC_ptr < P_CONS_NC_Eptr ) {
			*P_CONS_NC_ptr = value;
			P_CONS_NC_ptr++;
		}
		P_CONS_NC.GrabMemory();
		if( P_CONS_NC.GetF(FLinkEdges) ) { P_CONS_NC.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_CONS_NC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.010000;
			P_CONS_NC.Update( p, P_CONS_NC.ParameterValue(value,p) );
		}
		P_CONS_NC.GrabMemory();
		if( P_CONS_NC.GetF(FLinkEdges) ) { P_CONS_NC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.010000;
			P_CONS_NC.Update( P_CONS_NC.ParameterValue(value) );
	  } break;
	}
	P_CONS_NC.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::P_CONS_PC_u37_exe() {
	float value;
	int array_index[64];


	switch( P_CONS_PC.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_CONS_PC_ptr = P_CONS_PC.DataStart();
		const float* P_CONS_PC_Eptr = P_CONS_PC.GridEnd();
		 value =  0.005000;
		value = P_CONS_PC.ParameterValue(value);
		while( P_CONS_PC_ptr < P_CONS_PC_Eptr ) {
			*P_CONS_PC_ptr = value;
			P_CONS_PC_ptr++;
		}
		P_CONS_PC.GrabMemory();
		if( P_CONS_PC.GetF(FLinkEdges) ) { P_CONS_PC.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_CONS_PC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.005000;
			P_CONS_PC.Update( p, P_CONS_PC.ParameterValue(value,p) );
		}
		P_CONS_PC.GrabMemory();
		if( P_CONS_PC.GetF(FLinkEdges) ) { P_CONS_PC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.005000;
			P_CONS_PC.Update( P_CONS_PC.ParameterValue(value) );
	  } break;
	}
	P_CONS_PC.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::P_C_EGEST_EFF_u38_exe() {
	float value;
	int array_index[64];


	switch( P_C_EGEST_EFF.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_C_EGEST_EFF_ptr = P_C_EGEST_EFF.DataStart();
		const float* P_C_EGEST_EFF_Eptr = P_C_EGEST_EFF.GridEnd();
		 value =  0.950000;
		value = P_C_EGEST_EFF.ParameterValue(value);
		while( P_C_EGEST_EFF_ptr < P_C_EGEST_EFF_Eptr ) {
			*P_C_EGEST_EFF_ptr = value;
			P_C_EGEST_EFF_ptr++;
		}
		P_C_EGEST_EFF.GrabMemory();
		if( P_C_EGEST_EFF.GetF(FLinkEdges) ) { P_C_EGEST_EFF.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_C_EGEST_EFF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.950000;
			P_C_EGEST_EFF.Update( p, P_C_EGEST_EFF.ParameterValue(value,p) );
		}
		P_C_EGEST_EFF.GrabMemory();
		if( P_C_EGEST_EFF.GetF(FLinkEdges) ) { P_C_EGEST_EFF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.950000;
			P_C_EGEST_EFF.Update( P_C_EGEST_EFF.ParameterValue(value) );
	  } break;
	}
	P_C_EGEST_EFF.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::P_C_MORT_RT_u39_exe() {
	float value;
	int array_index[64];


	switch( P_C_MORT_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_C_MORT_RT_ptr = P_C_MORT_RT.DataStart();
		const float* P_C_MORT_RT_Eptr = P_C_MORT_RT.GridEnd();
		 value =  2e-6;
		value = P_C_MORT_RT.ParameterValue(value);
		while( P_C_MORT_RT_ptr < P_C_MORT_RT_Eptr ) {
			*P_C_MORT_RT_ptr = value;
			P_C_MORT_RT_ptr++;
		}
		P_C_MORT_RT.GrabMemory();
		if( P_C_MORT_RT.GetF(FLinkEdges) ) { P_C_MORT_RT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_C_MORT_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  2e-6;
			P_C_MORT_RT.Update( p, P_C_MORT_RT.ParameterValue(value,p) );
		}
		P_C_MORT_RT.GrabMemory();
		if( P_C_MORT_RT.GetF(FLinkEdges) ) { P_C_MORT_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  2e-6;
			P_C_MORT_RT.Update( P_C_MORT_RT.ParameterValue(value) );
	  } break;
	}
	P_C_MORT_RT.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::P_C_RESP_RT_u40_exe() {
	float value;
	int array_index[64];


	switch( P_C_RESP_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_C_RESP_RT_ptr = P_C_RESP_RT.DataStart();
		const float* P_C_RESP_RT_Eptr = P_C_RESP_RT.GridEnd();
		 value =  0.000012;
		value = P_C_RESP_RT.ParameterValue(value);
		while( P_C_RESP_RT_ptr < P_C_RESP_RT_Eptr ) {
			*P_C_RESP_RT_ptr = value;
			P_C_RESP_RT_ptr++;
		}
		P_C_RESP_RT.GrabMemory();
		if( P_C_RESP_RT.GetF(FLinkEdges) ) { P_C_RESP_RT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_C_RESP_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.000012;
			P_C_RESP_RT.Update( p, P_C_RESP_RT.ParameterValue(value,p) );
		}
		P_C_RESP_RT.GrabMemory();
		if( P_C_RESP_RT.GetF(FLinkEdges) ) { P_C_RESP_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.000012;
			P_C_RESP_RT.Update( P_C_RESP_RT.ParameterValue(value) );
	  } break;
	}
	P_C_RESP_RT.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::P_DETR_PREF_u41_exe() {
	float value;
	int array_index[64];


	switch( P_DETR_PREF.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_DETR_PREF_ptr = P_DETR_PREF.DataStart();
		const float* P_DETR_PREF_Eptr = P_DETR_PREF.GridEnd();
		float* BOTTOM_MAP_ptr = BOTTOM_MAP.DataStart();
		float* SURFACE_MAP_ptr = SURFACE_MAP.DataStart();
		while( P_DETR_PREF_ptr < P_DETR_PREF_Eptr ) {
		 value =   ( ( ( (*(BOTTOM_MAP_ptr)) == ((float)1) ) ) ? ( ((float)7) ) : (  ( ( ( (*(SURFACE_MAP_ptr)) == ((float)1) ) ) ? ( ((float)0) ) : ( ((float)3) ) )  ) ) ;
			*P_DETR_PREF_ptr = value;
			P_DETR_PREF_ptr++;
			BOTTOM_MAP.UpdateDataPtr(BOTTOM_MAP_ptr);
			SURFACE_MAP.UpdateDataPtr(SURFACE_MAP_ptr);
		}
		P_DETR_PREF.GrabMemory();
		if( P_DETR_PREF.GetF(FLinkEdges) ) { P_DETR_PREF.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_DETR_PREF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( BOTTOM_MAP.Value(p) == ((float)1) ) ) ? ( ((float)7) ) : (  ( ( ( SURFACE_MAP.Value(p) == ((float)1) ) ) ? ( ((float)0) ) : ( ((float)3) ) )  ) ) ;
			P_DETR_PREF.Update( p, value );
		}
		P_DETR_PREF.GrabMemory();
		if( P_DETR_PREF.GetF(FLinkEdges) ) { P_DETR_PREF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( BOTTOM_MAP.Value() == ((float)1) ) ) ? ( ((float)7) ) : (  ( ( ( SURFACE_MAP.Value() == ((float)1) ) ) ? ( ((float)0) ) : ( ((float)3) ) )  ) ) ;
			P_DETR_PREF.Update( value );
	  } break;
	}
	P_DETR_PREF.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::P_INGESTION_RT_u42_exe() {
	float value;
	int array_index[64];


	switch( P_INGESTION_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_INGESTION_RT_ptr = P_INGESTION_RT.DataStart();
		const float* P_INGESTION_RT_Eptr = P_INGESTION_RT.GridEnd();
		 value =  0.000250;
		value = P_INGESTION_RT.ParameterValue(value);
		while( P_INGESTION_RT_ptr < P_INGESTION_RT_Eptr ) {
			*P_INGESTION_RT_ptr = value;
			P_INGESTION_RT_ptr++;
		}
		P_INGESTION_RT.GrabMemory();
		if( P_INGESTION_RT.GetF(FLinkEdges) ) { P_INGESTION_RT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_INGESTION_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.000250;
			P_INGESTION_RT.Update( p, P_INGESTION_RT.ParameterValue(value,p) );
		}
		P_INGESTION_RT.GrabMemory();
		if( P_INGESTION_RT.GetF(FLinkEdges) ) { P_INGESTION_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.000250;
			P_INGESTION_RT.Update( P_INGESTION_RT.ParameterValue(value) );
	  } break;
	}
	P_INGESTION_RT.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::P_PH_PREF_u43_exe() {
	float value;
	int array_index[64];


	switch( P_PH_PREF.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_PH_PREF_ptr = P_PH_PREF.DataStart();
		const float* P_PH_PREF_Eptr = P_PH_PREF.GridEnd();
		float* BOTTOM_MAP_ptr = BOTTOM_MAP.DataStart();
		float* SURFACE_MAP_ptr = SURFACE_MAP.DataStart();
		while( P_PH_PREF_ptr < P_PH_PREF_Eptr ) {
		 value =   ( ( ( (*(BOTTOM_MAP_ptr)) == ((float)1) ) ) ? ( ((float)1) ) : (  ( ( ( (*(SURFACE_MAP_ptr)) == ((float)1) ) ) ? ( ((float)7) ) : ( ((float)5) ) )  ) ) ;
			*P_PH_PREF_ptr = value;
			P_PH_PREF_ptr++;
			BOTTOM_MAP.UpdateDataPtr(BOTTOM_MAP_ptr);
			SURFACE_MAP.UpdateDataPtr(SURFACE_MAP_ptr);
		}
		P_PH_PREF.GrabMemory();
		if( P_PH_PREF.GetF(FLinkEdges) ) { P_PH_PREF.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_PH_PREF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( BOTTOM_MAP.Value(p) == ((float)1) ) ) ? ( ((float)1) ) : (  ( ( ( SURFACE_MAP.Value(p) == ((float)1) ) ) ? ( ((float)7) ) : ( ((float)5) ) )  ) ) ;
			P_PH_PREF.Update( p, value );
		}
		P_PH_PREF.GrabMemory();
		if( P_PH_PREF.GetF(FLinkEdges) ) { P_PH_PREF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( BOTTOM_MAP.Value() == ((float)1) ) ) ? ( ((float)1) ) : (  ( ( ( SURFACE_MAP.Value() == ((float)1) ) ) ? ( ((float)7) ) : ( ((float)5) ) )  ) ) ;
			P_PH_PREF.Update( value );
	  } break;
	}
	P_PH_PREF.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::P_SW_PREF_u44_exe() {
	float value;
	int array_index[64];


	switch( P_SW_PREF.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_SW_PREF_ptr = P_SW_PREF.DataStart();
		const float* P_SW_PREF_Eptr = P_SW_PREF.GridEnd();
		float* BOTTOM_MAP_ptr = BOTTOM_MAP.DataStart();
		float* SURFACE_MAP_ptr = SURFACE_MAP.DataStart();
		while( P_SW_PREF_ptr < P_SW_PREF_Eptr ) {
		 value =   ( ( ( (*(BOTTOM_MAP_ptr)) == ((float)1) ) ) ? ( ((float)7) ) : (  ( ( ( (*(SURFACE_MAP_ptr)) == ((float)1) ) ) ? ( ((float)0) ) : ( ((float)2) ) )  ) ) ;
			*P_SW_PREF_ptr = value;
			P_SW_PREF_ptr++;
			BOTTOM_MAP.UpdateDataPtr(BOTTOM_MAP_ptr);
			SURFACE_MAP.UpdateDataPtr(SURFACE_MAP_ptr);
		}
		P_SW_PREF.GrabMemory();
		if( P_SW_PREF.GetF(FLinkEdges) ) { P_SW_PREF.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_SW_PREF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( BOTTOM_MAP.Value(p) == ((float)1) ) ) ? ( ((float)7) ) : (  ( ( ( SURFACE_MAP.Value(p) == ((float)1) ) ) ? ( ((float)0) ) : ( ((float)2) ) )  ) ) ;
			P_SW_PREF.Update( p, value );
		}
		P_SW_PREF.GrabMemory();
		if( P_SW_PREF.GetF(FLinkEdges) ) { P_SW_PREF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( BOTTOM_MAP.Value() == ((float)1) ) ) ? ( ((float)7) ) : (  ( ( ( SURFACE_MAP.Value() == ((float)1) ) ) ? ( ((float)0) ) : ( ((float)2) ) )  ) ) ;
			P_SW_PREF.Update( value );
	  } break;
	}
	P_SW_PREF.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::P_TRAVEL_TIME_u45_exe() {
	float value;
	int array_index[64];


	switch( P_TRAVEL_TIME.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_TRAVEL_TIME_ptr = P_TRAVEL_TIME.DataStart();
		const float* P_TRAVEL_TIME_Eptr = P_TRAVEL_TIME.GridEnd();
		 value =  0.007;
		value = P_TRAVEL_TIME.ParameterValue(value);
		while( P_TRAVEL_TIME_ptr < P_TRAVEL_TIME_Eptr ) {
			*P_TRAVEL_TIME_ptr = value;
			P_TRAVEL_TIME_ptr++;
		}
		P_TRAVEL_TIME.GrabMemory();
		if( P_TRAVEL_TIME.GetF(FLinkEdges) ) { P_TRAVEL_TIME.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_TRAVEL_TIME.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.007;
			P_TRAVEL_TIME.Update( p, P_TRAVEL_TIME.ParameterValue(value,p) );
		}
		P_TRAVEL_TIME.GrabMemory();
		if( P_TRAVEL_TIME.GetF(FLinkEdges) ) { P_TRAVEL_TIME.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.007;
			P_TRAVEL_TIME.Update( P_TRAVEL_TIME.ParameterValue(value) );
	  } break;
	}
	P_TRAVEL_TIME.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::P_TRAVEL_TIME_DENS_u46_exe() {
	float value;
	int array_index[64];


	switch( P_TRAVEL_TIME_DENS.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_TRAVEL_TIME_DENS_ptr = P_TRAVEL_TIME_DENS.DataStart();
		const float* P_TRAVEL_TIME_DENS_Eptr = P_TRAVEL_TIME_DENS.GridEnd();
		 value =  0.000100;
		value = P_TRAVEL_TIME_DENS.ParameterValue(value);
		while( P_TRAVEL_TIME_DENS_ptr < P_TRAVEL_TIME_DENS_Eptr ) {
			*P_TRAVEL_TIME_DENS_ptr = value;
			P_TRAVEL_TIME_DENS_ptr++;
		}
		P_TRAVEL_TIME_DENS.GrabMemory();
		if( P_TRAVEL_TIME_DENS.GetF(FLinkEdges) ) { P_TRAVEL_TIME_DENS.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_TRAVEL_TIME_DENS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.000100;
			P_TRAVEL_TIME_DENS.Update( p, P_TRAVEL_TIME_DENS.ParameterValue(value,p) );
		}
		P_TRAVEL_TIME_DENS.GrabMemory();
		if( P_TRAVEL_TIME_DENS.GetF(FLinkEdges) ) { P_TRAVEL_TIME_DENS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.000100;
			P_TRAVEL_TIME_DENS.Update( P_TRAVEL_TIME_DENS.ParameterValue(value) );
	  } break;
	}
	P_TRAVEL_TIME_DENS.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::P_VEG_DENS_COEFF_u47_exe() {
	float value;
	int array_index[64];


	switch( P_VEG_DENS_COEFF.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_VEG_DENS_COEFF_ptr = P_VEG_DENS_COEFF.DataStart();
		const float* P_VEG_DENS_COEFF_Eptr = P_VEG_DENS_COEFF.GridEnd();
		 value =  0.100000;
		value = P_VEG_DENS_COEFF.ParameterValue(value);
		while( P_VEG_DENS_COEFF_ptr < P_VEG_DENS_COEFF_Eptr ) {
			*P_VEG_DENS_COEFF_ptr = value;
			P_VEG_DENS_COEFF_ptr++;
		}
		P_VEG_DENS_COEFF.GrabMemory();
		if( P_VEG_DENS_COEFF.GetF(FLinkEdges) ) { P_VEG_DENS_COEFF.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_VEG_DENS_COEFF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.100000;
			P_VEG_DENS_COEFF.Update( p, P_VEG_DENS_COEFF.ParameterValue(value,p) );
		}
		P_VEG_DENS_COEFF.GrabMemory();
		if( P_VEG_DENS_COEFF.GetF(FLinkEdges) ) { P_VEG_DENS_COEFF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.100000;
			P_VEG_DENS_COEFF.Update( P_VEG_DENS_COEFF.ParameterValue(value) );
	  } break;
	}
	P_VEG_DENS_COEFF.UpdateGOFComputation();
	return 0;
}

int CONSUMERS_module::CONS_ACTIVITY_u48_exe() {
	float value;
	int array_index[64];


	switch( CONS_ACTIVITY.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* CONS_ACTIVITY_ptr = CONS_ACTIVITY.DataStart();
		const float* CONS_ACTIVITY_Eptr = CONS_ACTIVITY.GridEnd();
		float* OM3_TEMP_ptr = OM3_TEMP.DataStart();
		while( CONS_ACTIVITY_ptr < CONS_ACTIVITY_Eptr ) {
		 value =  Graph0((*(OM3_TEMP_ptr)));
			*CONS_ACTIVITY_ptr = value;
			CONS_ACTIVITY_ptr++;
			OM3_TEMP.UpdateDataPtr(OM3_TEMP_ptr);
		}
		CONS_ACTIVITY.GrabMemory();
		if( CONS_ACTIVITY.GetF(FLinkEdges) ) { CONS_ACTIVITY.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONS_ACTIVITY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  Graph0(OM3_TEMP.Value(p));
			CONS_ACTIVITY.Update( p, value );
		}
		CONS_ACTIVITY.GrabMemory();
		if( CONS_ACTIVITY.GetF(FLinkEdges) ) { CONS_ACTIVITY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  Graph0(OM3_TEMP.Value());
			CONS_ACTIVITY.Update( value );
	  } break;
	}
	CONS_ACTIVITY.UpdateGOFComputation();
	return 0;
}

CONSUMERS_module* CONSUMERS_module::fInstance = NULL;
CONSUMERS_module* CONSUMERS_module::kNullModel = (CONSUMERS_module*)0x1;
int CONSUMERS_module::InitVars() {
	TIME.SSInit(this);
	P_CELL_AREA.SSInit(this);
	PHYTOPLANKTON.SSInit(this);
	SEAWEEDS.SSInit(this);
	DETRITUS.SSInit(this);
	BOTTOM_MAP.SSInit(this);
	SURFACE_MAP.SSInit(this);
	OM3_TEMP.SSInit(this);
	CONS_MORTALITY.SSInit(this);
	CONS_MORTALITY.SetOrigin(&CONSUMERS);
	CONS_EGEST.SSInit(this);
	CONS_EGEST.SetOrigin(&CONSUMERS);
	COS_INGEST_DETR.SSInit(this);
	CONS_INGEST_PHT.SSInit(this);
	CONS_INGEST_SW.SSInit(this);
	VEG_STRUCTURE.SSInit(this);
	CONSUMERS.SSInit(this);
	CONSUMERS.SetLinkEdges();
	CONS_INGEST.SSInit(this);
	CONS_INGEST.SetDestination(&CONSUMERS);
	CONS_IN_X.SSInit(this);
	CONS_IN_X.SetDestination(&CONSUMERS);
	CONS_RESPIRATION.SSInit(this);
	CONS_RESPIRATION.SetOrigin(&CONSUMERS);
	CONS_OUT_X.SSInit(this);
	CONS_OUT_X.SetOrigin(&CONSUMERS);
	CONSDENS.SSInit(this);
	CONSDENS.SetLinkEdges();
	CONSTOD.SSInit(this);
	CONSTOD.SetLinkEdges();
	CONSTOE.SSInit(this);
	CONSTOE.SetLinkEdges();
	CONSTON.SSInit(this);
	CONSTON.SetLinkEdges();
	CONSTOS.SSInit(this);
	CONSTOS.SetLinkEdges();
	CONSTOU.SSInit(this);
	CONSTOU.SetLinkEdges();
	CONSTOW.SSInit(this);
	CONSTOW.SetLinkEdges();
	CON_POT_INGEST.SSInit(this);
	DENSITY_X_D.SSInit(this);
	DENSITY_X_E.SSInit(this);
	DENSITY_X_N.SSInit(this);
	DENSITY_X_S.SSInit(this);
	DENSITY_X_U.SSInit(this);
	DENSITY_X_W.SSInit(this);
	FOOD_X_D.SSInit(this);
	FOOD_X_E.SSInit(this);
	FOOD_X_N.SSInit(this);
	FOOD_X_S.SSInit(this);
	FOOD_X_UP.SSInit(this);
	FOOD_X_W.SSInit(this);
	IC_CONSUMER.SSInit(this);
	OMTOTBIO.SSInit(this);
	OMTOTBIO.SetLinkEdges();
	PREF_TOT.SSInit(this);
	RIVER_CON.SSInit(this);
	P_CONS_NC.SSInit(this);
	P_CONS_PC.SSInit(this);
	P_C_EGEST_EFF.SSInit(this);
	P_C_MORT_RT.SSInit(this);
	P_C_RESP_RT.SSInit(this);
	P_DETR_PREF.SSInit(this);
	P_INGESTION_RT.SSInit(this);
	P_PH_PREF.SSInit(this);
	P_SW_PREF.SSInit(this);
	P_TRAVEL_TIME.SSInit(this);
	P_TRAVEL_TIME_DENS.SSInit(this);
	P_VEG_DENS_COEFF.SSInit(this);
	CONS_ACTIVITY.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int CONSUMERS_module::SetupEvents() {
	TImportCommand* P_CELL_AREA_import0 = (TImportCommand*) P_CELL_AREA.GetCommand("P_CELL_AREA_import0",TCommand::kUndefined,TCommand::kImport);
	P_CELL_AREA_import0->Code() = "Import P_CELL_AREA";
	P_CELL_AREA_import0->AddDependency(P_CELL_AREA);
	P_CELL_AREA_import0->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PHYTOPLANKTON_import1 = (TImportCommand*) PHYTOPLANKTON.GetCommand("PHYTOPLANKTON_import1",TCommand::kUndefined,TCommand::kImport);
	PHYTOPLANKTON_import1->Code() = "Import PHYTOPLANKTON";
	PHYTOPLANKTON_import1->AddDependency(PHYTOPLANKTON);
	PHYTOPLANKTON_import1->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SEAWEEDS_import2 = (TImportCommand*) SEAWEEDS.GetCommand("SEAWEEDS_import2",TCommand::kUndefined,TCommand::kImport);
	SEAWEEDS_import2->Code() = "Import SEAWEEDS";
	SEAWEEDS_import2->AddDependency(SEAWEEDS);
	SEAWEEDS_import2->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DETRITUS_import3 = (TImportCommand*) DETRITUS.GetCommand("DETRITUS_import3",TCommand::kUndefined,TCommand::kImport);
	DETRITUS_import3->Code() = "Import DETRITUS";
	DETRITUS_import3->AddDependency(DETRITUS);
	DETRITUS_import3->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* BOTTOM_MAP_import4 = (TImportCommand*) BOTTOM_MAP.GetCommand("BOTTOM_MAP_import4",TCommand::kUndefined,TCommand::kImport);
	BOTTOM_MAP_import4->Code() = "Import BOTTOM_MAP";
	BOTTOM_MAP_import4->AddDependency(BOTTOM_MAP);
	BOTTOM_MAP_import4->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SURFACE_MAP_import5 = (TImportCommand*) SURFACE_MAP.GetCommand("SURFACE_MAP_import5",TCommand::kUndefined,TCommand::kImport);
	SURFACE_MAP_import5->Code() = "Import SURFACE_MAP";
	SURFACE_MAP_import5->AddDependency(SURFACE_MAP);
	SURFACE_MAP_import5->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* OM3_TEMP_import6 = (TImportCommand*) OM3_TEMP.GetCommand("OM3_TEMP_import6",TCommand::kUndefined,TCommand::kImport);
	OM3_TEMP_import6->Code() = "Import OM3_TEMP";
	OM3_TEMP_import6->AddDependency(OM3_TEMP);
	OM3_TEMP_import6->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u5 = (TExecuteCommand*) CONS_MORTALITY.GetCommand("u5",TCommand::kUpdate,TCommand::kCode);
	u5->SetExecutable(&CONS_MORTALITY_u5_exe_g);
	u5->Code() = "u5 <- ( CONSUMERS*( P_C_MORT_RT*dT() ) )";
	if( CONS_MORTALITY.GetF(FisClamped) ) { u5->AddDependency(CONSUMERS); }
	u5->AddDependency(CONSUMERS);
	u5->AddDependency(P_C_MORT_RT);
	u5->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u4 = (TExecuteCommand*) CONS_EGEST.GetCommand("u4",TCommand::kUpdate,TCommand::kCode);
	u4->SetExecutable(&CONS_EGEST_u4_exe_g);
	u4->Code() = "u4 <- ( CONS_INGEST*P_C_EGEST_EFF )";
	if( CONS_EGEST.GetF(FisClamped) ) { u4->AddDependency(CONSUMERS); }
	u4->AddDependency(CONS_INGEST);
	u4->AddDependency(P_C_EGEST_EFF);
	u4->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u18 = (TExecuteCommand*) COS_INGEST_DETR.GetCommand("u18",TCommand::kUpdate,TCommand::kCode);
	u18->SetExecutable(&COS_INGEST_DETR_u18_exe_g);
	u18->Code() = "u18 <- SL::Min(DETRITUS, ( ( P_DETR_PREF/PREF_TOT )*CON_POT_INGEST ))";
	u18->AddDependency(DETRITUS);
	u18->AddDependency(P_DETR_PREF);
	u18->AddDependency(PREF_TOT);
	u18->AddDependency(CON_POT_INGEST);
	u18->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u15 = (TExecuteCommand*) CONS_INGEST_PHT.GetCommand("u15",TCommand::kUpdate,TCommand::kCode);
	u15->SetExecutable(&CONS_INGEST_PHT_u15_exe_g);
	u15->Code() = "u15 <- SL::Min(PHYTOPLANKTON, ( ( P_PH_PREF/PREF_TOT )*CON_POT_INGEST ))";
	u15->AddDependency(PHYTOPLANKTON);
	u15->AddDependency(P_PH_PREF);
	u15->AddDependency(PREF_TOT);
	u15->AddDependency(CON_POT_INGEST);
	u15->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u16 = (TExecuteCommand*) CONS_INGEST_SW.GetCommand("u16",TCommand::kUpdate,TCommand::kCode);
	u16->SetExecutable(&CONS_INGEST_SW_u16_exe_g);
	u16->Code() = "u16 <- SL::Min(SEAWEEDS, ( ( P_SW_PREF/PREF_TOT )*CON_POT_INGEST ))";
	u16->AddDependency(SEAWEEDS);
	u16->AddDependency(P_SW_PREF);
	u16->AddDependency(PREF_TOT);
	u16->AddDependency(CON_POT_INGEST);
	u16->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u35 = (TExecuteCommand*) VEG_STRUCTURE.GetCommand("u35",TCommand::kUpdate,TCommand::kCode);
	u35->SetExecutable(&VEG_STRUCTURE_u35_exe_g);
	u35->Code() = "u35 <- ( ( P_VEG_DENS_COEFF/P_CELL_AREA )*SEAWEEDS )";
	u35->AddDependency(P_VEG_DENS_COEFF);
	u35->AddDependency(P_CELL_AREA);
	u35->AddDependency(SEAWEEDS);
	u35->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I0 = (TExecuteCommand*) CONSUMERS.GetCommand("I0",TCommand::kIntegrate,TCommand::kCode);
	I0->SetExecutable(&CONSUMERS_I0_exe_g);
	I0->Code() = "I0 <- ( ( ( ( ( CONS_INGEST+CONS_IN_X )-CONS_EGEST )-CONS_MORTALITY )-CONS_RESPIRATION )-CONS_OUT_X )";
	I0->AddDependency(CONS_INGEST);
	I0->AddDependency(CONS_IN_X);
	I0->AddDependency(CONS_EGEST);
	I0->AddDependency(CONS_MORTALITY);
	I0->AddDependency(CONS_RESPIRATION);
	I0->AddDependency(CONS_OUT_X);
	I0->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i1 = (TExecuteCommand*) CONSUMERS.GetCommand("i1",TCommand::kInit,TCommand::kCode);
	i1->SetExecutable(&CONSUMERS_i1_exe_g);
	i1->Code() = "i1 <- ( IC_CONSUMER*P_CELL_AREA )";
	i1->AddDependency(IC_CONSUMER);
	i1->AddDependency(P_CELL_AREA);
	i1->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u2 = (TExecuteCommand*) CONS_INGEST.GetCommand("u2",TCommand::kUpdate,TCommand::kCode);
	u2->SetExecutable(&CONS_INGEST_u2_exe_g);
	u2->Code() = "u2 <- ( ( CONS_INGEST_PHT+CONS_INGEST_SW )+COS_INGEST_DETR )";
	u2->AddDependency(CONS_INGEST_PHT);
	u2->AddDependency(CONS_INGEST_SW);
	u2->AddDependency(COS_INGEST_DETR);
	u2->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u3 = (TExecuteCommand*) CONS_IN_X.GetCommand("u3",TCommand::kUpdate,TCommand::kCode);
	u3->SetExecutable(&CONS_IN_X_u3_exe_g);
	u3->Code() = "u3 <- ( ( ( ( ( CONSTOE+CONSTON )+CONSTOS )+CONSTOW )+CONSTOD )+CONSTOU )";
	u3->AddDependency(CONSTOE,"0,-1,0");
	u3->AddDependency(CONSTON,"1,0,0");
	u3->AddDependency(CONSTOS,"-1,0,0");
	u3->AddDependency(CONSTOW,"0,1,0");
	u3->AddDependency(CONSTOD,"0,0,-1");
	u3->AddDependency(CONSTOU,"0,0,1");
	u3->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u6 = (TExecuteCommand*) CONS_RESPIRATION.GetCommand("u6",TCommand::kUpdate,TCommand::kCode);
	u6->SetExecutable(&CONS_RESPIRATION_u6_exe_g);
	u6->Code() = "u6 <- ( ( CONSUMERS*CONS_ACTIVITY )*( P_C_RESP_RT*dT() ) )";
	if( CONS_RESPIRATION.GetF(FisClamped) ) { u6->AddDependency(CONSUMERS); }
	u6->AddDependency(CONSUMERS);
	u6->AddDependency(CONS_ACTIVITY);
	u6->AddDependency(P_C_RESP_RT);
	u6->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u7 = (TExecuteCommand*) CONS_OUT_X.GetCommand("u7",TCommand::kUpdate,TCommand::kCode);
	u7->SetExecutable(&CONS_OUT_X_u7_exe_g);
	u7->Code() = "u7 <- ( ( ( ( ( CONSTOE+CONSTON )+CONSTOS )+CONSTOW )+CONSTOD )+CONSTOU )";
	if( CONS_OUT_X.GetF(FisClamped) ) { u7->AddDependency(CONSUMERS); }
	u7->AddDependency(CONSTOE);
	u7->AddDependency(CONSTON);
	u7->AddDependency(CONSTOS);
	u7->AddDependency(CONSTOW);
	u7->AddDependency(CONSTOD);
	u7->AddDependency(CONSTOU);
	u7->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u8 = (TExecuteCommand*) CONSDENS.GetCommand("u8",TCommand::kUpdate,TCommand::kCode);
	u8->SetExecutable(&CONSDENS_u8_exe_g);
	u8->Code() = "u8 <- ( ( RIVER_CON+CONSUMERS )*P_CELL_AREA )";
	u8->AddDependency(RIVER_CON);
	u8->AddDependency(CONSUMERS);
	u8->AddDependency(P_CELL_AREA);
	u8->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u9 = (TExecuteCommand*) CONSTOD.GetCommand("u9",TCommand::kUpdate,TCommand::kCode);
	u9->SetExecutable(&CONSTOD_u9_exe_g);
	u9->Code() = "u9 <- ( ( DENSITY_X_D+FOOD_X_D )*CONSUMERS )";
	u9->AddDependency(DENSITY_X_D);
	u9->AddDependency(FOOD_X_D);
	u9->AddDependency(CONSUMERS);
	u9->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u10 = (TExecuteCommand*) CONSTOE.GetCommand("u10",TCommand::kUpdate,TCommand::kCode);
	u10->SetExecutable(&CONSTOE_u10_exe_g);
	u10->Code() = "u10 <- ( ( DENSITY_X_E+FOOD_X_E )*CONSUMERS )";
	u10->AddDependency(DENSITY_X_E);
	u10->AddDependency(FOOD_X_E);
	u10->AddDependency(CONSUMERS);
	u10->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u11 = (TExecuteCommand*) CONSTON.GetCommand("u11",TCommand::kUpdate,TCommand::kCode);
	u11->SetExecutable(&CONSTON_u11_exe_g);
	u11->Code() = "u11 <- ( ( DENSITY_X_N+FOOD_X_N )*CONSUMERS )";
	u11->AddDependency(DENSITY_X_N);
	u11->AddDependency(FOOD_X_N);
	u11->AddDependency(CONSUMERS);
	u11->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u12 = (TExecuteCommand*) CONSTOS.GetCommand("u12",TCommand::kUpdate,TCommand::kCode);
	u12->SetExecutable(&CONSTOS_u12_exe_g);
	u12->Code() = "u12 <- ( ( DENSITY_X_S+FOOD_X_S )*CONSUMERS )";
	u12->AddDependency(DENSITY_X_S);
	u12->AddDependency(FOOD_X_S);
	u12->AddDependency(CONSUMERS);
	u12->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u13 = (TExecuteCommand*) CONSTOU.GetCommand("u13",TCommand::kUpdate,TCommand::kCode);
	u13->SetExecutable(&CONSTOU_u13_exe_g);
	u13->Code() = "u13 <- ( ( DENSITY_X_U+FOOD_X_UP )*CONSUMERS )";
	u13->AddDependency(DENSITY_X_U);
	u13->AddDependency(FOOD_X_UP);
	u13->AddDependency(CONSUMERS);
	u13->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u14 = (TExecuteCommand*) CONSTOW.GetCommand("u14",TCommand::kUpdate,TCommand::kCode);
	u14->SetExecutable(&CONSTOW_u14_exe_g);
	u14->Code() = "u14 <- ( ( DENSITY_X_W+FOOD_X_W )*CONSUMERS )";
	u14->AddDependency(DENSITY_X_W);
	u14->AddDependency(FOOD_X_W);
	u14->AddDependency(CONSUMERS);
	u14->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u17 = (TExecuteCommand*) CON_POT_INGEST.GetCommand("u17",TCommand::kUpdate,TCommand::kCode);
	u17->SetExecutable(&CON_POT_INGEST_u17_exe_g);
	u17->Code() = "u17 <- SL::Min(OMTOTBIO, ( ( P_INGESTION_RT*CONS_ACTIVITY )*CONSUMERS ))";
	u17->AddDependency(OMTOTBIO);
	u17->AddDependency(P_INGESTION_RT);
	u17->AddDependency(CONS_ACTIVITY);
	u17->AddDependency(CONSUMERS);
	u17->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u19 = (TExecuteCommand*) DENSITY_X_D.GetCommand("u19",TCommand::kUpdate,TCommand::kCode);
	u19->SetExecutable(&DENSITY_X_D_u19_exe_g);
	u19->Code() = "u19 <-  ( ( ( ( CONSDENS <= CONSDENS ) || ( CONSDENS <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME_DENS*( CONSDENS-CONSDENS ) )/CONSDENS ) ) ) ";
	u19->AddDependency(CONSDENS,"0,0,1");
	u19->AddDependency(P_TRAVEL_TIME_DENS);
	u19->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u20 = (TExecuteCommand*) DENSITY_X_E.GetCommand("u20",TCommand::kUpdate,TCommand::kCode);
	u20->SetExecutable(&DENSITY_X_E_u20_exe_g);
	u20->Code() = "u20 <-  ( ( ( ( CONSDENS <= CONSDENS ) || ( CONSDENS <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME_DENS*( CONSDENS-CONSDENS ) )/CONSDENS ) ) ) ";
	u20->AddDependency(CONSDENS,"0,1,0");
	u20->AddDependency(P_TRAVEL_TIME_DENS);
	u20->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u21 = (TExecuteCommand*) DENSITY_X_N.GetCommand("u21",TCommand::kUpdate,TCommand::kCode);
	u21->SetExecutable(&DENSITY_X_N_u21_exe_g);
	u21->Code() = "u21 <-  ( ( ( ( CONSDENS <= CONSDENS ) || ( CONSDENS <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME_DENS*( CONSDENS-CONSDENS ) )/CONSDENS ) ) ) ";
	u21->AddDependency(CONSDENS,"-1,0,0");
	u21->AddDependency(P_TRAVEL_TIME_DENS);
	u21->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u22 = (TExecuteCommand*) DENSITY_X_S.GetCommand("u22",TCommand::kUpdate,TCommand::kCode);
	u22->SetExecutable(&DENSITY_X_S_u22_exe_g);
	u22->Code() = "u22 <-  ( ( ( ( CONSDENS <= CONSDENS ) || ( CONSDENS <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME_DENS*( CONSDENS-CONSDENS ) )/CONSDENS ) ) ) ";
	u22->AddDependency(CONSDENS,"1,0,0");
	u22->AddDependency(P_TRAVEL_TIME_DENS);
	u22->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u23 = (TExecuteCommand*) DENSITY_X_U.GetCommand("u23",TCommand::kUpdate,TCommand::kCode);
	u23->SetExecutable(&DENSITY_X_U_u23_exe_g);
	u23->Code() = "u23 <-  ( ( ( ( CONSDENS <= CONSDENS ) || ( CONSDENS <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME_DENS*( CONSDENS-CONSDENS ) )/CONSDENS ) ) ) ";
	u23->AddDependency(CONSDENS,"0,0,-1");
	u23->AddDependency(P_TRAVEL_TIME_DENS);
	u23->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u24 = (TExecuteCommand*) DENSITY_X_W.GetCommand("u24",TCommand::kUpdate,TCommand::kCode);
	u24->SetExecutable(&DENSITY_X_W_u24_exe_g);
	u24->Code() = "u24 <-  ( ( ( ( CONSDENS <= CONSDENS ) || ( CONSDENS <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME_DENS*( CONSDENS-CONSDENS ) )/CONSDENS ) ) ) ";
	u24->AddDependency(CONSDENS,"0,-1,0");
	u24->AddDependency(P_TRAVEL_TIME_DENS);
	u24->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u25 = (TExecuteCommand*) FOOD_X_D.GetCommand("u25",TCommand::kUpdate,TCommand::kCode);
	u25->SetExecutable(&FOOD_X_D_u25_exe_g);
	u25->Code() = "u25 <-  ( ( ( ( OMTOTBIO >= OMTOTBIO ) || ( OMTOTBIO <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME*( OMTOTBIO-OMTOTBIO ) )/OMTOTBIO ) ) ) ";
	u25->AddDependency(OMTOTBIO,"0,0,-1");
	u25->AddDependency(P_TRAVEL_TIME);
	u25->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u26 = (TExecuteCommand*) FOOD_X_E.GetCommand("u26",TCommand::kUpdate,TCommand::kCode);
	u26->SetExecutable(&FOOD_X_E_u26_exe_g);
	u26->Code() = "u26 <-  ( ( ( ( OMTOTBIO >= OMTOTBIO ) || ( OMTOTBIO <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME*( OMTOTBIO-OMTOTBIO ) )/OMTOTBIO ) ) ) ";
	u26->AddDependency(OMTOTBIO,"0,1,0");
	u26->AddDependency(P_TRAVEL_TIME);
	u26->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u27 = (TExecuteCommand*) FOOD_X_N.GetCommand("u27",TCommand::kUpdate,TCommand::kCode);
	u27->SetExecutable(&FOOD_X_N_u27_exe_g);
	u27->Code() = "u27 <-  ( ( ( ( OMTOTBIO >= OMTOTBIO ) || ( OMTOTBIO <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME*( OMTOTBIO-OMTOTBIO ) )/OMTOTBIO ) ) ) ";
	u27->AddDependency(OMTOTBIO,"-1,0,0");
	u27->AddDependency(P_TRAVEL_TIME);
	u27->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u28 = (TExecuteCommand*) FOOD_X_S.GetCommand("u28",TCommand::kUpdate,TCommand::kCode);
	u28->SetExecutable(&FOOD_X_S_u28_exe_g);
	u28->Code() = "u28 <-  ( ( ( ( OMTOTBIO >= OMTOTBIO ) || ( OMTOTBIO <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME*( OMTOTBIO-OMTOTBIO ) )/OMTOTBIO ) ) ) ";
	u28->AddDependency(OMTOTBIO,"1,0,0");
	u28->AddDependency(P_TRAVEL_TIME);
	u28->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u29 = (TExecuteCommand*) FOOD_X_UP.GetCommand("u29",TCommand::kUpdate,TCommand::kCode);
	u29->SetExecutable(&FOOD_X_UP_u29_exe_g);
	u29->Code() = "u29 <-  ( ( ( ( OMTOTBIO >= OMTOTBIO ) || ( OMTOTBIO <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME*( OMTOTBIO-OMTOTBIO ) )/OMTOTBIO ) ) ) ";
	u29->AddDependency(OMTOTBIO,"0,0,1");
	u29->AddDependency(P_TRAVEL_TIME);
	u29->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u30 = (TExecuteCommand*) FOOD_X_W.GetCommand("u30",TCommand::kUpdate,TCommand::kCode);
	u30->SetExecutable(&FOOD_X_W_u30_exe_g);
	u30->Code() = "u30 <-  ( ( ( ( OMTOTBIO >= OMTOTBIO ) || ( OMTOTBIO <  ((float)1E-8) ) ) ) ? ( ((float)0) ) : ( ( ( P_TRAVEL_TIME*( OMTOTBIO-OMTOTBIO ) )/OMTOTBIO ) ) ) ";
	u30->AddDependency(OMTOTBIO,"0,-1,0");
	u30->AddDependency(P_TRAVEL_TIME);
	u30->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u31 = (TExecuteCommand*) IC_CONSUMER.GetCommand("u31",TCommand::kUpdate,TCommand::kCode);
	u31->SetExecutable(&IC_CONSUMER_u31_exe_g);
	u31->Code() = "u31 <- 0.001000";
	u31->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u32 = (TExecuteCommand*) OMTOTBIO.GetCommand("u32",TCommand::kUpdate,TCommand::kCode);
	u32->SetExecutable(&OMTOTBIO_u32_exe_g);
	u32->Code() = "u32 <- ( ( PHYTOPLANKTON+SEAWEEDS )+DETRITUS )";
	u32->AddDependency(PHYTOPLANKTON);
	u32->AddDependency(SEAWEEDS);
	u32->AddDependency(DETRITUS);
	u32->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u33 = (TExecuteCommand*) PREF_TOT.GetCommand("u33",TCommand::kUpdate,TCommand::kCode);
	u33->SetExecutable(&PREF_TOT_u33_exe_g);
	u33->Code() = "u33 <- ( P_PH_PREF+P_SW_PREF )";
	u33->AddDependency(P_PH_PREF);
	u33->AddDependency(P_SW_PREF);
	u33->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u34 = (TExecuteCommand*) RIVER_CON.GetCommand("u34",TCommand::kUpdate,TCommand::kCode);
	u34->SetExecutable(&RIVER_CON_u34_exe_g);
	u34->Code() = "u34 <- 0";
	u34->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u36 = (TExecuteCommand*) P_CONS_NC.GetCommand("u36",TCommand::kUpdate,TCommand::kCode);
	u36->SetExecutable(&P_CONS_NC_u36_exe_g);
	u36->Code() = "u36 <- 0.010000";
	u36->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u37 = (TExecuteCommand*) P_CONS_PC.GetCommand("u37",TCommand::kUpdate,TCommand::kCode);
	u37->SetExecutable(&P_CONS_PC_u37_exe_g);
	u37->Code() = "u37 <- 0.005000";
	u37->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u38 = (TExecuteCommand*) P_C_EGEST_EFF.GetCommand("u38",TCommand::kUpdate,TCommand::kCode);
	u38->SetExecutable(&P_C_EGEST_EFF_u38_exe_g);
	u38->Code() = "u38 <- 0.950000";
	u38->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u39 = (TExecuteCommand*) P_C_MORT_RT.GetCommand("u39",TCommand::kUpdate,TCommand::kCode);
	u39->SetExecutable(&P_C_MORT_RT_u39_exe_g);
	u39->Code() = "u39 <- 2e-6";
	u39->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u40 = (TExecuteCommand*) P_C_RESP_RT.GetCommand("u40",TCommand::kUpdate,TCommand::kCode);
	u40->SetExecutable(&P_C_RESP_RT_u40_exe_g);
	u40->Code() = "u40 <- 0.000012";
	u40->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u41 = (TExecuteCommand*) P_DETR_PREF.GetCommand("u41",TCommand::kUpdate,TCommand::kCode);
	u41->SetExecutable(&P_DETR_PREF_u41_exe_g);
	u41->Code() = "u41 <-  ( ( ( BOTTOM_MAP == ((float)1) ) ) ? ( ((float)7) ) : (  ( ( ( SURFACE_MAP == ((float)1) ) ) ? ( ((float)0) ) : ( ((float)3) ) )  ) ) ";
	u41->AddDependency(BOTTOM_MAP);
	u41->AddDependency(SURFACE_MAP);
	u41->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u42 = (TExecuteCommand*) P_INGESTION_RT.GetCommand("u42",TCommand::kUpdate,TCommand::kCode);
	u42->SetExecutable(&P_INGESTION_RT_u42_exe_g);
	u42->Code() = "u42 <- 0.000250";
	u42->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u43 = (TExecuteCommand*) P_PH_PREF.GetCommand("u43",TCommand::kUpdate,TCommand::kCode);
	u43->SetExecutable(&P_PH_PREF_u43_exe_g);
	u43->Code() = "u43 <-  ( ( ( BOTTOM_MAP == ((float)1) ) ) ? ( ((float)1) ) : (  ( ( ( SURFACE_MAP == ((float)1) ) ) ? ( ((float)7) ) : ( ((float)5) ) )  ) ) ";
	u43->AddDependency(BOTTOM_MAP);
	u43->AddDependency(SURFACE_MAP);
	u43->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u44 = (TExecuteCommand*) P_SW_PREF.GetCommand("u44",TCommand::kUpdate,TCommand::kCode);
	u44->SetExecutable(&P_SW_PREF_u44_exe_g);
	u44->Code() = "u44 <-  ( ( ( BOTTOM_MAP == ((float)1) ) ) ? ( ((float)7) ) : (  ( ( ( SURFACE_MAP == ((float)1) ) ) ? ( ((float)0) ) : ( ((float)2) ) )  ) ) ";
	u44->AddDependency(BOTTOM_MAP);
	u44->AddDependency(SURFACE_MAP);
	u44->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u45 = (TExecuteCommand*) P_TRAVEL_TIME.GetCommand("u45",TCommand::kUpdate,TCommand::kCode);
	u45->SetExecutable(&P_TRAVEL_TIME_u45_exe_g);
	u45->Code() = "u45 <- 0.007";
	u45->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u46 = (TExecuteCommand*) P_TRAVEL_TIME_DENS.GetCommand("u46",TCommand::kUpdate,TCommand::kCode);
	u46->SetExecutable(&P_TRAVEL_TIME_DENS_u46_exe_g);
	u46->Code() = "u46 <- 0.000100";
	u46->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u47 = (TExecuteCommand*) P_VEG_DENS_COEFF.GetCommand("u47",TCommand::kUpdate,TCommand::kCode);
	u47->SetExecutable(&P_VEG_DENS_COEFF_u47_exe_g);
	u47->Code() = "u47 <- 0.100000";
	u47->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u48 = (TExecuteCommand*) CONS_ACTIVITY.GetCommand("u48",TCommand::kUpdate,TCommand::kCode);
	u48->SetExecutable(&CONS_ACTIVITY_u48_exe_g);
	u48->Code() = "u48 <- Graph0(OM3_TEMP)";
	u48->AddDependency(OM3_TEMP);
	u48->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int CONSUMERS_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int CONSUMERS_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int CONSUMERS_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int CONSUMERS_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class DETRITUS_module 
// ---------------------------------------------------------------------------
DETRITUS_module::DETRITUS_module(char* name) :
	TIME("TIME"),
	DETRITUS("DETRITUS"),
	CONS_MORTALITY("CONS_MORTALITY"),
	PHT_MORTALITY("PHT_MORTALITY"),
	SW_MORT("SW_MORT"),
	CONS_EGEST("CONS_EGEST"),
	COS_INGEST_DETR("COS_INGEST_DETR"),
	DETR_DECOMPOSED("DETR_DECOMPOSED"),
	DETRITUS_IN("DETRITUS_IN"),
	D_SINKING("D_SINKING"),
	DETRITUS_CONSUMED("DETRITUS_CONSUMED"),
	P_DETR_DECOMP_RT("P_DETR_DECOMP_RT"),
	P_D_SINK_RT("P_D_SINK_RT"),
	P_IC_DETRITUS("P_IC_DETRITUS"),
	TModule(name) {

	DETRITUS.SetF(FisExport,True,"CG");
	DETRITUS.SetF(FHasNegFlux,True,"CG");
	CONS_MORTALITY.SetF(FisImport,True,"CG");
	PHT_MORTALITY.SetF(FisImport,True,"CG");
	SW_MORT.SetF(FisImport,True,"CG");
	CONS_EGEST.SetF(FisImport,True,"CG");
	COS_INGEST_DETR.SetF(FisImport,True,"CG");
	DETR_DECOMPOSED.SetF(FisExport,True,"CG");
	DETR_DECOMPOSED.SetF(FHasNegFlux,True,"CG");
	D_SINKING.SetF(FHasNegFlux,True,"CG");
	DETRITUS_CONSUMED.SetF(FHasNegFlux,True,"CG");
}	
int DETRITUS_module::DETRITUS_I49_exe() {
	float value;
	int array_index[64];


	DETRITUS.UpdateIntegrator();
	switch( DETRITUS.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* DETRITUS_ptr = DETRITUS.DataStart();
		const float* DETRITUS_Eptr = DETRITUS.GridEnd();
		float dt = dT();
		float* DETRITUS_Rptr = DETRITUS.RDataStart();
		float* DETRITUS_IN_ptr = DETRITUS_IN.DataStart();
		float* D_SINKING_ptr = D_SINKING.DataStart();
		float* DETRITUS_CONSUMED_ptr = DETRITUS_CONSUMED.DataStart();
		float* DETR_DECOMPOSED_ptr = DETR_DECOMPOSED.DataStart();
		switch( DETRITUS.CurrentOrder() ) {
		  case 1: {
			if( DETRITUS.Order() > 1 ) {
			float *DETRITUS_IMptr0 = DETRITUS.SIntegratorMemory().LastData();
			while( DETRITUS_ptr < DETRITUS_Eptr ) {
		 value =  ( ( ( (*(DETRITUS_IN_ptr))-(*(D_SINKING_ptr)) )-(*(DETRITUS_CONSUMED_ptr)) )-(*(DETR_DECOMPOSED_ptr)) );
				*DETRITUS_ptr += value*dt;
				if(DETRITUS_Rptr) { *DETRITUS_Rptr++ = *DETRITUS_ptr; }
				*DETRITUS_IMptr0++ = value;
				DETRITUS_ptr++;
				DETRITUS_IN.UpdateDataPtr(DETRITUS_IN_ptr);
				D_SINKING.UpdateDataPtr(D_SINKING_ptr);
				DETRITUS_CONSUMED.UpdateDataPtr(DETRITUS_CONSUMED_ptr);
				DETR_DECOMPOSED.UpdateDataPtr(DETR_DECOMPOSED_ptr);
			}
			} else {
			while( DETRITUS_ptr < DETRITUS_Eptr ) {
		 value =  ( ( ( (*(DETRITUS_IN_ptr))-(*(D_SINKING_ptr)) )-(*(DETRITUS_CONSUMED_ptr)) )-(*(DETR_DECOMPOSED_ptr)) );
				*DETRITUS_ptr += value*dt;
				if(DETRITUS_Rptr) { *DETRITUS_Rptr++ = *DETRITUS_ptr; }
				DETRITUS_ptr++;
				DETRITUS_IN.UpdateDataPtr(DETRITUS_IN_ptr);
				D_SINKING.UpdateDataPtr(D_SINKING_ptr);
				DETRITUS_CONSUMED.UpdateDataPtr(DETRITUS_CONSUMED_ptr);
				DETR_DECOMPOSED.UpdateDataPtr(DETR_DECOMPOSED_ptr);
			}
			};
		  } break; case 2: {
			float *DETRITUS_IMptr0 = DETRITUS.SIntegratorMemory().LastData();
			float *DETRITUS_IMptr1 = DETRITUS.SIntegratorMemory().LastDataOffset(1);
			while( DETRITUS_ptr < DETRITUS_Eptr ) {
		 value =  ( ( ( (*(DETRITUS_IN_ptr))-(*(D_SINKING_ptr)) )-(*(DETRITUS_CONSUMED_ptr)) )-(*(DETR_DECOMPOSED_ptr)) );
				*DETRITUS_IMptr0++ = value;
				*DETRITUS_ptr += ( 1.5*value - 0.5* *DETRITUS_IMptr1++ )*dt;
				if(DETRITUS_Rptr) { *DETRITUS_Rptr++ = *DETRITUS_ptr; }
				DETRITUS_ptr++;
				DETRITUS_IN.UpdateDataPtr(DETRITUS_IN_ptr);
				D_SINKING.UpdateDataPtr(D_SINKING_ptr);
				DETRITUS_CONSUMED.UpdateDataPtr(DETRITUS_CONSUMED_ptr);
				DETR_DECOMPOSED.UpdateDataPtr(DETR_DECOMPOSED_ptr);
			}
		  } break; case 3: {
			float *DETRITUS_IMptr0 = DETRITUS.SIntegratorMemory().LastData();
			float *DETRITUS_IMptr1 = DETRITUS.SIntegratorMemory().LastDataOffset(1);
			float *DETRITUS_IMptr2 = DETRITUS.SIntegratorMemory().LastDataOffset(2);
			while( DETRITUS_ptr < DETRITUS_Eptr ) {
		 value =  ( ( ( (*(DETRITUS_IN_ptr))-(*(D_SINKING_ptr)) )-(*(DETRITUS_CONSUMED_ptr)) )-(*(DETR_DECOMPOSED_ptr)) );
				*DETRITUS_IMptr0++ = value;
				*DETRITUS_ptr += (1.92*value - 1.33* *DETRITUS_IMptr1++ + .42* *DETRITUS_IMptr2++)*dt;
				if(DETRITUS_Rptr) { *DETRITUS_Rptr++ = *DETRITUS_ptr; }
				DETRITUS_ptr++;
				DETRITUS_IN.UpdateDataPtr(DETRITUS_IN_ptr);
				D_SINKING.UpdateDataPtr(D_SINKING_ptr);
				DETRITUS_CONSUMED.UpdateDataPtr(DETRITUS_CONSUMED_ptr);
				DETR_DECOMPOSED.UpdateDataPtr(DETR_DECOMPOSED_ptr);
			}
		  } break; case 4: {
			float *DETRITUS_IMptr0 = DETRITUS.SIntegratorMemory().LastData();
			float *DETRITUS_IMptr1 = DETRITUS.SIntegratorMemory().LastDataOffset(1);
			float *DETRITUS_IMptr2 = DETRITUS.SIntegratorMemory().LastDataOffset(2);
			float *DETRITUS_IMptr3 = DETRITUS.SIntegratorMemory().LastDataOffset(3);
			while( DETRITUS_ptr < DETRITUS_Eptr ) {
		 value =  ( ( ( (*(DETRITUS_IN_ptr))-(*(D_SINKING_ptr)) )-(*(DETRITUS_CONSUMED_ptr)) )-(*(DETR_DECOMPOSED_ptr)) );
				*DETRITUS_IMptr0++ = value;
				*DETRITUS_ptr += (2.29*value - 2.46* *DETRITUS_IMptr1++  + 1.54* *DETRITUS_IMptr2++ - .375* *DETRITUS_IMptr3++ )*dt;
				if(DETRITUS_Rptr) { *DETRITUS_Rptr++ = *DETRITUS_ptr; }
				DETRITUS_ptr++;
				DETRITUS_IN.UpdateDataPtr(DETRITUS_IN_ptr);
				D_SINKING.UpdateDataPtr(D_SINKING_ptr);
				DETRITUS_CONSUMED.UpdateDataPtr(DETRITUS_CONSUMED_ptr);
				DETR_DECOMPOSED.UpdateDataPtr(DETR_DECOMPOSED_ptr);
			}
		  } break; default: { gPrintErr("Illegal Order in StateVar update!"); }
		};
		DETRITUS.GrabMemory();
		if( DETRITUS.GetF(FLinkEdges) ) { DETRITUS.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = DETRITUS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( ( DETRITUS_IN.Value(p)-D_SINKING.Value(p) )-DETRITUS_CONSUMED.Value(p) )-DETR_DECOMPOSED.Value(p) );
			DETRITUS.Update( p, value, dT() );
		}
		DETRITUS.GrabMemory();
		if( DETRITUS.GetF(FLinkEdges) ) { DETRITUS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( ( DETRITUS_IN.Value()-D_SINKING.Value() )-DETRITUS_CONSUMED.Value() )-DETR_DECOMPOSED.Value() );
			DETRITUS.Update( value, dT() );
	  } break;
	}
	DETRITUS.UpdateGOFComputation();
	return 0;
}

int DETRITUS_module::DETRITUS_i50_exe() {
	float value;
	int array_index[64];


	switch( DETRITUS.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* DETRITUS_ptr = DETRITUS.DataStart();
		const float* DETRITUS_Eptr = DETRITUS.GridEnd();
		float dt = dT();
		float* DETRITUS_Rptr = DETRITUS.RDataStart();
		float* P_IC_DETRITUS_ptr = P_IC_DETRITUS.DataStart();
		while( DETRITUS_ptr < DETRITUS_Eptr ) {
		 value =  (*(P_IC_DETRITUS_ptr));
			if(DETRITUS_Rptr) { *DETRITUS_Rptr = *DETRITUS_ptr = value;  DETRITUS_Rptr++; }
			else { *DETRITUS_ptr = value; }
			DETRITUS_ptr++;
			P_IC_DETRITUS.UpdateDataPtr(P_IC_DETRITUS_ptr);
		}
		DETRITUS.GrabMemory();
		if( DETRITUS.GetF(FLinkEdges) ) { DETRITUS.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = DETRITUS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  P_IC_DETRITUS.Value(p);
			DETRITUS.InitValue( p, value );
		}
		DETRITUS.GrabMemory();
		if( DETRITUS.GetF(FLinkEdges) ) { DETRITUS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  P_IC_DETRITUS.Value();
			DETRITUS.InitValue( value );
	  } break;
	}
	DETRITUS.UpdateGOFComputation();
	return 0;
}

int DETRITUS_module::DETRITUS_IN_u51_exe() {
	float value;
	int array_index[64];


	switch( DETRITUS_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* DETRITUS_IN_ptr = DETRITUS_IN.DataStart();
		const float* DETRITUS_IN_Eptr = DETRITUS_IN.GridEnd();
		float dt = dT();
		float* CONS_MORTALITY_ptr = CONS_MORTALITY.DataStart();
		float* PHT_MORTALITY_ptr = PHT_MORTALITY.DataStart();
		float* SW_MORT_ptr = SW_MORT.DataStart();
		float* CONS_EGEST_ptr = CONS_EGEST.DataStart();
		int clamped = 0;
		while( DETRITUS_IN_ptr < DETRITUS_IN_Eptr ) {
		 value =  ( ( ( (*(CONS_MORTALITY_ptr))+(*(PHT_MORTALITY_ptr)) )+(*(SW_MORT_ptr)) )+(*(CONS_EGEST_ptr)) );
			*DETRITUS_IN_ptr = value;
			DETRITUS_IN_ptr++;
			CONS_MORTALITY.UpdateDataPtr(CONS_MORTALITY_ptr);
			PHT_MORTALITY.UpdateDataPtr(PHT_MORTALITY_ptr);
			SW_MORT.UpdateDataPtr(SW_MORT_ptr);
			CONS_EGEST.UpdateDataPtr(CONS_EGEST_ptr);
		}
		if( DETRITUS_IN.GetF(FICFlux) ) DETRITUS_IN.Cov().Set(0.0); 
		DETRITUS_IN.GrabMemory();
		if( DETRITUS_IN.GetF(FLinkEdges) ) { DETRITUS_IN.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = DETRITUS_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( ( CONS_MORTALITY.Value(p)+PHT_MORTALITY.Value(p) )+SW_MORT.Value(p) )+CONS_EGEST.Value(p) );
			DETRITUS_IN.Update( p, value );
		}
		DETRITUS_IN.GrabMemory();
		if( DETRITUS_IN.GetF(FICFlux) ) DETRITUS_IN.Cov().Set(0.0); 
		if( DETRITUS_IN.GetF(FLinkEdges) ) { DETRITUS_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( ( CONS_MORTALITY.Value()+PHT_MORTALITY.Value() )+SW_MORT.Value() )+CONS_EGEST.Value() );
			DETRITUS_IN.Update( value );
	  } break;
	}
	DETRITUS_IN.UpdateGOFComputation();
	return 0;
}

int DETRITUS_module::D_SINKING_u52_exe() {
	float value;
	int array_index[64];


	switch( D_SINKING.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* D_SINKING_ptr = D_SINKING.DataStart();
		const float* D_SINKING_Eptr = D_SINKING.GridEnd();
		float dt = dT();
		float* D_SINKING_Optr = ((CStateVariable*)(D_SINKING.Origin()))->RDataStart();
		float* DETRITUS_ptr = DETRITUS.DataStart();
		float* P_D_SINK_RT_ptr = P_D_SINK_RT.DataStart();
		int clamped = DETRITUS.GetF(FisClamped);
		while( D_SINKING_ptr < D_SINKING_Eptr ) {
		 value =  ( (*(DETRITUS_ptr))*(*(P_D_SINK_RT_ptr)) );
			*D_SINKING_ptr = value;
			if( clamped ) { SL::Clamp(D_SINKING_Optr++,D_SINKING_ptr,dt); }
			D_SINKING_ptr++;
			DETRITUS.UpdateDataPtr(DETRITUS_ptr);
			P_D_SINK_RT.UpdateDataPtr(P_D_SINK_RT_ptr);
		}
		if( D_SINKING.GetF(FICFlux) ) D_SINKING.Cov().Set(0.0); 
		D_SINKING.GrabMemory();
		if( D_SINKING.GetF(FLinkEdges) ) { D_SINKING.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = D_SINKING.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( DETRITUS.Value(p)*P_D_SINK_RT.Value(p) );
			D_SINKING.Update( p, value );
		}
		D_SINKING.GrabMemory();
		if( D_SINKING.GetF(FICFlux) ) D_SINKING.Cov().Set(0.0); 
		if( D_SINKING.GetF(FLinkEdges) ) { D_SINKING.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( DETRITUS.Value()*P_D_SINK_RT.Value() );
			D_SINKING.Update( value );
	  } break;
	}
	D_SINKING.UpdateGOFComputation();
	return 0;
}

int DETRITUS_module::DETRITUS_CONSUMED_u53_exe() {
	float value;
	int array_index[64];


	switch( DETRITUS_CONSUMED.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* DETRITUS_CONSUMED_ptr = DETRITUS_CONSUMED.DataStart();
		const float* DETRITUS_CONSUMED_Eptr = DETRITUS_CONSUMED.GridEnd();
		float dt = dT();
		float* DETRITUS_CONSUMED_Optr = ((CStateVariable*)(DETRITUS_CONSUMED.Origin()))->RDataStart();
		float* COS_INGEST_DETR_ptr = COS_INGEST_DETR.DataStart();
		int clamped = DETRITUS.GetF(FisClamped);
		while( DETRITUS_CONSUMED_ptr < DETRITUS_CONSUMED_Eptr ) {
		 value =  (*(COS_INGEST_DETR_ptr));
			*DETRITUS_CONSUMED_ptr = value;
			if( clamped ) { SL::Clamp(DETRITUS_CONSUMED_Optr++,DETRITUS_CONSUMED_ptr,dt); }
			DETRITUS_CONSUMED_ptr++;
			COS_INGEST_DETR.UpdateDataPtr(COS_INGEST_DETR_ptr);
		}
		if( DETRITUS_CONSUMED.GetF(FICFlux) ) DETRITUS_CONSUMED.Cov().Set(0.0); 
		DETRITUS_CONSUMED.GrabMemory();
		if( DETRITUS_CONSUMED.GetF(FLinkEdges) ) { DETRITUS_CONSUMED.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = DETRITUS_CONSUMED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  COS_INGEST_DETR.Value(p);
			DETRITUS_CONSUMED.Update( p, value );
		}
		DETRITUS_CONSUMED.GrabMemory();
		if( DETRITUS_CONSUMED.GetF(FICFlux) ) DETRITUS_CONSUMED.Cov().Set(0.0); 
		if( DETRITUS_CONSUMED.GetF(FLinkEdges) ) { DETRITUS_CONSUMED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  COS_INGEST_DETR.Value();
			DETRITUS_CONSUMED.Update( value );
	  } break;
	}
	DETRITUS_CONSUMED.UpdateGOFComputation();
	return 0;
}

int DETRITUS_module::DETR_DECOMPOSED_u54_exe() {
	float value;
	int array_index[64];


	switch( DETR_DECOMPOSED.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* DETR_DECOMPOSED_ptr = DETR_DECOMPOSED.DataStart();
		const float* DETR_DECOMPOSED_Eptr = DETR_DECOMPOSED.GridEnd();
		float dt = dT();
		float* DETR_DECOMPOSED_Optr = ((CStateVariable*)(DETR_DECOMPOSED.Origin()))->RDataStart();
		float* P_DETR_DECOMP_RT_ptr = P_DETR_DECOMP_RT.DataStart();
		float* DETRITUS_ptr = DETRITUS.DataStart();
		int clamped = DETRITUS.GetF(FisClamped);
		while( DETR_DECOMPOSED_ptr < DETR_DECOMPOSED_Eptr ) {
		 value =  ( (*(P_DETR_DECOMP_RT_ptr))*(*(DETRITUS_ptr)) );
			*DETR_DECOMPOSED_ptr = value;
			if( clamped ) { SL::Clamp(DETR_DECOMPOSED_Optr++,DETR_DECOMPOSED_ptr,dt); }
			DETR_DECOMPOSED_ptr++;
			P_DETR_DECOMP_RT.UpdateDataPtr(P_DETR_DECOMP_RT_ptr);
			DETRITUS.UpdateDataPtr(DETRITUS_ptr);
		}
		if( DETR_DECOMPOSED.GetF(FICFlux) ) DETR_DECOMPOSED.Cov().Set(0.0); 
		DETR_DECOMPOSED.GrabMemory();
		if( DETR_DECOMPOSED.GetF(FLinkEdges) ) { DETR_DECOMPOSED.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = DETR_DECOMPOSED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( P_DETR_DECOMP_RT.Value(p)*DETRITUS.Value(p) );
			DETR_DECOMPOSED.Update( p, value );
		}
		DETR_DECOMPOSED.GrabMemory();
		if( DETR_DECOMPOSED.GetF(FICFlux) ) DETR_DECOMPOSED.Cov().Set(0.0); 
		if( DETR_DECOMPOSED.GetF(FLinkEdges) ) { DETR_DECOMPOSED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( P_DETR_DECOMP_RT.Value()*DETRITUS.Value() );
			DETR_DECOMPOSED.Update( value );
	  } break;
	}
	DETR_DECOMPOSED.UpdateGOFComputation();
	return 0;
}

int DETRITUS_module::P_DETR_DECOMP_RT_u55_exe() {
	float value;
	int array_index[64];


	switch( P_DETR_DECOMP_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_DETR_DECOMP_RT_ptr = P_DETR_DECOMP_RT.DataStart();
		const float* P_DETR_DECOMP_RT_Eptr = P_DETR_DECOMP_RT.GridEnd();
		 value =  0.005000;
		value = P_DETR_DECOMP_RT.ParameterValue(value);
		while( P_DETR_DECOMP_RT_ptr < P_DETR_DECOMP_RT_Eptr ) {
			*P_DETR_DECOMP_RT_ptr = value;
			P_DETR_DECOMP_RT_ptr++;
		}
		P_DETR_DECOMP_RT.GrabMemory();
		if( P_DETR_DECOMP_RT.GetF(FLinkEdges) ) { P_DETR_DECOMP_RT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_DETR_DECOMP_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.005000;
			P_DETR_DECOMP_RT.Update( p, P_DETR_DECOMP_RT.ParameterValue(value,p) );
		}
		P_DETR_DECOMP_RT.GrabMemory();
		if( P_DETR_DECOMP_RT.GetF(FLinkEdges) ) { P_DETR_DECOMP_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.005000;
			P_DETR_DECOMP_RT.Update( P_DETR_DECOMP_RT.ParameterValue(value) );
	  } break;
	}
	P_DETR_DECOMP_RT.UpdateGOFComputation();
	return 0;
}

int DETRITUS_module::P_D_SINK_RT_u56_exe() {
	float value;
	int array_index[64];


	switch( P_D_SINK_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_D_SINK_RT_ptr = P_D_SINK_RT.DataStart();
		const float* P_D_SINK_RT_Eptr = P_D_SINK_RT.GridEnd();
		 value =  0.010000;
		value = P_D_SINK_RT.ParameterValue(value);
		while( P_D_SINK_RT_ptr < P_D_SINK_RT_Eptr ) {
			*P_D_SINK_RT_ptr = value;
			P_D_SINK_RT_ptr++;
		}
		P_D_SINK_RT.GrabMemory();
		if( P_D_SINK_RT.GetF(FLinkEdges) ) { P_D_SINK_RT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_D_SINK_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.010000;
			P_D_SINK_RT.Update( p, P_D_SINK_RT.ParameterValue(value,p) );
		}
		P_D_SINK_RT.GrabMemory();
		if( P_D_SINK_RT.GetF(FLinkEdges) ) { P_D_SINK_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.010000;
			P_D_SINK_RT.Update( P_D_SINK_RT.ParameterValue(value) );
	  } break;
	}
	P_D_SINK_RT.UpdateGOFComputation();
	return 0;
}

int DETRITUS_module::P_IC_DETRITUS_u57_exe() {
	float value;
	int array_index[64];


	switch( P_IC_DETRITUS.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_IC_DETRITUS_ptr = P_IC_DETRITUS.DataStart();
		const float* P_IC_DETRITUS_Eptr = P_IC_DETRITUS.GridEnd();
		 value =  0.000100;
		value = P_IC_DETRITUS.ParameterValue(value);
		while( P_IC_DETRITUS_ptr < P_IC_DETRITUS_Eptr ) {
			*P_IC_DETRITUS_ptr = value;
			P_IC_DETRITUS_ptr++;
		}
		P_IC_DETRITUS.GrabMemory();
		if( P_IC_DETRITUS.GetF(FLinkEdges) ) { P_IC_DETRITUS.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_IC_DETRITUS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.000100;
			P_IC_DETRITUS.Update( p, P_IC_DETRITUS.ParameterValue(value,p) );
		}
		P_IC_DETRITUS.GrabMemory();
		if( P_IC_DETRITUS.GetF(FLinkEdges) ) { P_IC_DETRITUS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.000100;
			P_IC_DETRITUS.Update( P_IC_DETRITUS.ParameterValue(value) );
	  } break;
	}
	P_IC_DETRITUS.UpdateGOFComputation();
	return 0;
}

DETRITUS_module* DETRITUS_module::fInstance = NULL;
DETRITUS_module* DETRITUS_module::kNullModel = (DETRITUS_module*)0x1;
int DETRITUS_module::InitVars() {
	TIME.SSInit(this);
	DETRITUS.SSInit(this);
	DETRITUS.SetLinkEdges();
	CONS_MORTALITY.SSInit(this);
	PHT_MORTALITY.SSInit(this);
	SW_MORT.SSInit(this);
	CONS_EGEST.SSInit(this);
	COS_INGEST_DETR.SSInit(this);
	DETR_DECOMPOSED.SSInit(this);
	DETR_DECOMPOSED.SetOrigin(&DETRITUS);
	DETRITUS_IN.SSInit(this);
	DETRITUS_IN.SetDestination(&DETRITUS);
	D_SINKING.SSInit(this);
	D_SINKING.SetOrigin(&DETRITUS);
	DETRITUS_CONSUMED.SSInit(this);
	DETRITUS_CONSUMED.SetOrigin(&DETRITUS);
	P_DETR_DECOMP_RT.SSInit(this);
	P_D_SINK_RT.SSInit(this);
	P_IC_DETRITUS.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int DETRITUS_module::SetupEvents() {
	TExecuteCommand* I49 = (TExecuteCommand*) DETRITUS.GetCommand("I49",TCommand::kIntegrate,TCommand::kCode);
	I49->SetExecutable(&DETRITUS_I49_exe_g);
	I49->Code() = "I49 <- ( ( ( DETRITUS_IN-D_SINKING )-DETRITUS_CONSUMED )-DETR_DECOMPOSED )";
	I49->AddDependency(DETRITUS_IN);
	I49->AddDependency(D_SINKING);
	I49->AddDependency(DETRITUS_CONSUMED);
	I49->AddDependency(DETR_DECOMPOSED);
	I49->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i50 = (TExecuteCommand*) DETRITUS.GetCommand("i50",TCommand::kInit,TCommand::kCode);
	i50->SetExecutable(&DETRITUS_i50_exe_g);
	i50->Code() = "i50 <- P_IC_DETRITUS";
	i50->AddDependency(P_IC_DETRITUS);
	i50->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* CONS_MORTALITY_import0 = (TImportCommand*) CONS_MORTALITY.GetCommand("CONS_MORTALITY_import0",TCommand::kUndefined,TCommand::kImport);
	CONS_MORTALITY_import0->Code() = "Import CONS_MORTALITY";
	CONS_MORTALITY_import0->AddDependency(CONS_MORTALITY);
	CONS_MORTALITY_import0->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PHT_MORTALITY_import1 = (TImportCommand*) PHT_MORTALITY.GetCommand("PHT_MORTALITY_import1",TCommand::kUndefined,TCommand::kImport);
	PHT_MORTALITY_import1->Code() = "Import PHT_MORTALITY";
	PHT_MORTALITY_import1->AddDependency(PHT_MORTALITY);
	PHT_MORTALITY_import1->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SW_MORT_import2 = (TImportCommand*) SW_MORT.GetCommand("SW_MORT_import2",TCommand::kUndefined,TCommand::kImport);
	SW_MORT_import2->Code() = "Import SW_MORT";
	SW_MORT_import2->AddDependency(SW_MORT);
	SW_MORT_import2->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* CONS_EGEST_import3 = (TImportCommand*) CONS_EGEST.GetCommand("CONS_EGEST_import3",TCommand::kUndefined,TCommand::kImport);
	CONS_EGEST_import3->Code() = "Import CONS_EGEST";
	CONS_EGEST_import3->AddDependency(CONS_EGEST);
	CONS_EGEST_import3->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* COS_INGEST_DETR_import4 = (TImportCommand*) COS_INGEST_DETR.GetCommand("COS_INGEST_DETR_import4",TCommand::kUndefined,TCommand::kImport);
	COS_INGEST_DETR_import4->Code() = "Import COS_INGEST_DETR";
	COS_INGEST_DETR_import4->AddDependency(COS_INGEST_DETR);
	COS_INGEST_DETR_import4->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u54 = (TExecuteCommand*) DETR_DECOMPOSED.GetCommand("u54",TCommand::kUpdate,TCommand::kCode);
	u54->SetExecutable(&DETR_DECOMPOSED_u54_exe_g);
	u54->Code() = "u54 <- ( P_DETR_DECOMP_RT*DETRITUS )";
	if( DETR_DECOMPOSED.GetF(FisClamped) ) { u54->AddDependency(DETRITUS); }
	u54->AddDependency(P_DETR_DECOMP_RT);
	u54->AddDependency(DETRITUS);
	u54->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u51 = (TExecuteCommand*) DETRITUS_IN.GetCommand("u51",TCommand::kUpdate,TCommand::kCode);
	u51->SetExecutable(&DETRITUS_IN_u51_exe_g);
	u51->Code() = "u51 <- ( ( ( CONS_MORTALITY+PHT_MORTALITY )+SW_MORT )+CONS_EGEST )";
	u51->AddDependency(CONS_MORTALITY);
	u51->AddDependency(PHT_MORTALITY);
	u51->AddDependency(SW_MORT);
	u51->AddDependency(CONS_EGEST);
	u51->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u52 = (TExecuteCommand*) D_SINKING.GetCommand("u52",TCommand::kUpdate,TCommand::kCode);
	u52->SetExecutable(&D_SINKING_u52_exe_g);
	u52->Code() = "u52 <- ( DETRITUS*P_D_SINK_RT )";
	if( D_SINKING.GetF(FisClamped) ) { u52->AddDependency(DETRITUS); }
	u52->AddDependency(DETRITUS);
	u52->AddDependency(P_D_SINK_RT);
	u52->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u53 = (TExecuteCommand*) DETRITUS_CONSUMED.GetCommand("u53",TCommand::kUpdate,TCommand::kCode);
	u53->SetExecutable(&DETRITUS_CONSUMED_u53_exe_g);
	u53->Code() = "u53 <- COS_INGEST_DETR";
	if( DETRITUS_CONSUMED.GetF(FisClamped) ) { u53->AddDependency(DETRITUS); }
	u53->AddDependency(COS_INGEST_DETR);
	u53->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u55 = (TExecuteCommand*) P_DETR_DECOMP_RT.GetCommand("u55",TCommand::kUpdate,TCommand::kCode);
	u55->SetExecutable(&P_DETR_DECOMP_RT_u55_exe_g);
	u55->Code() = "u55 <- 0.005000";
	u55->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u56 = (TExecuteCommand*) P_D_SINK_RT.GetCommand("u56",TCommand::kUpdate,TCommand::kCode);
	u56->SetExecutable(&P_D_SINK_RT_u56_exe_g);
	u56->Code() = "u56 <- 0.010000";
	u56->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u57 = (TExecuteCommand*) P_IC_DETRITUS.GetCommand("u57",TCommand::kUpdate,TCommand::kCode);
	u57->SetExecutable(&P_IC_DETRITUS_u57_exe_g);
	u57->Code() = "u57 <- 0.000100";
	u57->SetObjInfo(TCommand::kDepIndex, 5);
	return 0;
}

int DETRITUS_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int DETRITUS_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int DETRITUS_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int DETRITUS_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class DIN_module 
// ---------------------------------------------------------------------------
DIN_module::DIN_module(char* name) :
	TIME("TIME"),
	SF_WATER("SF_WATER"),
	DETR_DECOMPOSED("DETR_DECOMPOSED"),
	PHT_NET_PROD("PHT_NET_PROD"),
	P_PHT_NC("P_PHT_NC"),
	BOTTOM_MAP("BOTTOM_MAP"),
	DIN_CONC("DIN_CONC"),
	DIN_SF_WT("DIN_SF_WT"),
	DIN_SF_WT_MINER("DIN_SF_WT_MINER"),
	DIN_UPFLOW("DIN_UPFLOW"),
	DIN_DNFLOW("DIN_DNFLOW"),
	DIN_SF_WT_UPTAKE("DIN_SF_WT_UPTAKE"),
	RIVER_N("RIVER_N"),
	P_DETR_NC_RT("P_DETR_NC_RT"),
	P_DIFFUSION_COEFF("P_DIFFUSION_COEFF"),
	P_DIN_SED_CONC_MAP("P_DIN_SED_CONC_MAP"),
	P_IC_DIN_SF_WT("P_IC_DIN_SF_WT"),
	TModule(name) {

	SF_WATER.SetF(FisImport,True,"CG");
	DETR_DECOMPOSED.SetF(FisImport,True,"CG");
	PHT_NET_PROD.SetF(FisImport,True,"CG");
	P_PHT_NC.SetF(FisImport,True,"CG");
	BOTTOM_MAP.SetF(FisImport,True,"CG");
	DIN_CONC.SetF(FisExport,True,"CG");
	DIN_SF_WT.SetF(FHasNegFlux,True,"CG");
	DIN_DNFLOW.SetF(FHasNegFlux,True,"CG");
	DIN_SF_WT_UPTAKE.SetF(FHasNegFlux,True,"CG");
}	
int DIN_module::DIN_SF_WT_I58_exe() {
	float value;
	int array_index[64];


	DIN_SF_WT.UpdateIntegrator();
	switch( DIN_SF_WT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* DIN_SF_WT_ptr = DIN_SF_WT.DataStart();
		const float* DIN_SF_WT_Eptr = DIN_SF_WT.GridEnd();
		float dt = dT();
		float* DIN_SF_WT_Rptr = DIN_SF_WT.RDataStart();
		float* RIVER_N_ptr = RIVER_N.DataStart();
		float* DIN_SF_WT_MINER_ptr = DIN_SF_WT_MINER.DataStart();
		float* DIN_UPFLOW_ptr = DIN_UPFLOW.DataStart();
		float* DIN_DNFLOW_ptr = DIN_DNFLOW.DataStart();
		float* DIN_SF_WT_UPTAKE_ptr = DIN_SF_WT_UPTAKE.DataStart();
		switch( DIN_SF_WT.CurrentOrder() ) {
		  case 1: {
			if( DIN_SF_WT.Order() > 1 ) {
			float *DIN_SF_WT_IMptr0 = DIN_SF_WT.SIntegratorMemory().LastData();
			while( DIN_SF_WT_ptr < DIN_SF_WT_Eptr ) {
		 value =  ( ( ( ( (*(RIVER_N_ptr))+(*(DIN_SF_WT_MINER_ptr)) )+(*(DIN_UPFLOW_ptr)) )-(*(DIN_DNFLOW_ptr)) )-(*(DIN_SF_WT_UPTAKE_ptr)) );
				*DIN_SF_WT_ptr += value*dt;
				if(DIN_SF_WT_Rptr) { *DIN_SF_WT_Rptr++ = *DIN_SF_WT_ptr; }
				*DIN_SF_WT_IMptr0++ = value;
				DIN_SF_WT_ptr++;
				RIVER_N.UpdateDataPtr(RIVER_N_ptr);
				DIN_SF_WT_MINER.UpdateDataPtr(DIN_SF_WT_MINER_ptr);
				DIN_UPFLOW.UpdateDataPtr(DIN_UPFLOW_ptr);
				DIN_DNFLOW.UpdateDataPtr(DIN_DNFLOW_ptr);
				DIN_SF_WT_UPTAKE.UpdateDataPtr(DIN_SF_WT_UPTAKE_ptr);
			}
			} else {
			while( DIN_SF_WT_ptr < DIN_SF_WT_Eptr ) {
		 value =  ( ( ( ( (*(RIVER_N_ptr))+(*(DIN_SF_WT_MINER_ptr)) )+(*(DIN_UPFLOW_ptr)) )-(*(DIN_DNFLOW_ptr)) )-(*(DIN_SF_WT_UPTAKE_ptr)) );
				*DIN_SF_WT_ptr += value*dt;
				if(DIN_SF_WT_Rptr) { *DIN_SF_WT_Rptr++ = *DIN_SF_WT_ptr; }
				DIN_SF_WT_ptr++;
				RIVER_N.UpdateDataPtr(RIVER_N_ptr);
				DIN_SF_WT_MINER.UpdateDataPtr(DIN_SF_WT_MINER_ptr);
				DIN_UPFLOW.UpdateDataPtr(DIN_UPFLOW_ptr);
				DIN_DNFLOW.UpdateDataPtr(DIN_DNFLOW_ptr);
				DIN_SF_WT_UPTAKE.UpdateDataPtr(DIN_SF_WT_UPTAKE_ptr);
			}
			};
		  } break; case 2: {
			float *DIN_SF_WT_IMptr0 = DIN_SF_WT.SIntegratorMemory().LastData();
			float *DIN_SF_WT_IMptr1 = DIN_SF_WT.SIntegratorMemory().LastDataOffset(1);
			while( DIN_SF_WT_ptr < DIN_SF_WT_Eptr ) {
		 value =  ( ( ( ( (*(RIVER_N_ptr))+(*(DIN_SF_WT_MINER_ptr)) )+(*(DIN_UPFLOW_ptr)) )-(*(DIN_DNFLOW_ptr)) )-(*(DIN_SF_WT_UPTAKE_ptr)) );
				*DIN_SF_WT_IMptr0++ = value;
				*DIN_SF_WT_ptr += ( 1.5*value - 0.5* *DIN_SF_WT_IMptr1++ )*dt;
				if(DIN_SF_WT_Rptr) { *DIN_SF_WT_Rptr++ = *DIN_SF_WT_ptr; }
				DIN_SF_WT_ptr++;
				RIVER_N.UpdateDataPtr(RIVER_N_ptr);
				DIN_SF_WT_MINER.UpdateDataPtr(DIN_SF_WT_MINER_ptr);
				DIN_UPFLOW.UpdateDataPtr(DIN_UPFLOW_ptr);
				DIN_DNFLOW.UpdateDataPtr(DIN_DNFLOW_ptr);
				DIN_SF_WT_UPTAKE.UpdateDataPtr(DIN_SF_WT_UPTAKE_ptr);
			}
		  } break; case 3: {
			float *DIN_SF_WT_IMptr0 = DIN_SF_WT.SIntegratorMemory().LastData();
			float *DIN_SF_WT_IMptr1 = DIN_SF_WT.SIntegratorMemory().LastDataOffset(1);
			float *DIN_SF_WT_IMptr2 = DIN_SF_WT.SIntegratorMemory().LastDataOffset(2);
			while( DIN_SF_WT_ptr < DIN_SF_WT_Eptr ) {
		 value =  ( ( ( ( (*(RIVER_N_ptr))+(*(DIN_SF_WT_MINER_ptr)) )+(*(DIN_UPFLOW_ptr)) )-(*(DIN_DNFLOW_ptr)) )-(*(DIN_SF_WT_UPTAKE_ptr)) );
				*DIN_SF_WT_IMptr0++ = value;
				*DIN_SF_WT_ptr += (1.92*value - 1.33* *DIN_SF_WT_IMptr1++ + .42* *DIN_SF_WT_IMptr2++)*dt;
				if(DIN_SF_WT_Rptr) { *DIN_SF_WT_Rptr++ = *DIN_SF_WT_ptr; }
				DIN_SF_WT_ptr++;
				RIVER_N.UpdateDataPtr(RIVER_N_ptr);
				DIN_SF_WT_MINER.UpdateDataPtr(DIN_SF_WT_MINER_ptr);
				DIN_UPFLOW.UpdateDataPtr(DIN_UPFLOW_ptr);
				DIN_DNFLOW.UpdateDataPtr(DIN_DNFLOW_ptr);
				DIN_SF_WT_UPTAKE.UpdateDataPtr(DIN_SF_WT_UPTAKE_ptr);
			}
		  } break; case 4: {
			float *DIN_SF_WT_IMptr0 = DIN_SF_WT.SIntegratorMemory().LastData();
			float *DIN_SF_WT_IMptr1 = DIN_SF_WT.SIntegratorMemory().LastDataOffset(1);
			float *DIN_SF_WT_IMptr2 = DIN_SF_WT.SIntegratorMemory().LastDataOffset(2);
			float *DIN_SF_WT_IMptr3 = DIN_SF_WT.SIntegratorMemory().LastDataOffset(3);
			while( DIN_SF_WT_ptr < DIN_SF_WT_Eptr ) {
		 value =  ( ( ( ( (*(RIVER_N_ptr))+(*(DIN_SF_WT_MINER_ptr)) )+(*(DIN_UPFLOW_ptr)) )-(*(DIN_DNFLOW_ptr)) )-(*(DIN_SF_WT_UPTAKE_ptr)) );
				*DIN_SF_WT_IMptr0++ = value;
				*DIN_SF_WT_ptr += (2.29*value - 2.46* *DIN_SF_WT_IMptr1++  + 1.54* *DIN_SF_WT_IMptr2++ - .375* *DIN_SF_WT_IMptr3++ )*dt;
				if(DIN_SF_WT_Rptr) { *DIN_SF_WT_Rptr++ = *DIN_SF_WT_ptr; }
				DIN_SF_WT_ptr++;
				RIVER_N.UpdateDataPtr(RIVER_N_ptr);
				DIN_SF_WT_MINER.UpdateDataPtr(DIN_SF_WT_MINER_ptr);
				DIN_UPFLOW.UpdateDataPtr(DIN_UPFLOW_ptr);
				DIN_DNFLOW.UpdateDataPtr(DIN_DNFLOW_ptr);
				DIN_SF_WT_UPTAKE.UpdateDataPtr(DIN_SF_WT_UPTAKE_ptr);
			}
		  } break; default: { gPrintErr("Illegal Order in StateVar update!"); }
		};
		DIN_SF_WT.GrabMemory();
		if( DIN_SF_WT.GetF(FLinkEdges) ) { DIN_SF_WT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_SF_WT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( ( ( RIVER_N.Value(p)+DIN_SF_WT_MINER.Value(p) )+DIN_UPFLOW.Value(p) )-DIN_DNFLOW.Value(p) )-DIN_SF_WT_UPTAKE.Value(p) );
			DIN_SF_WT.Update( p, value, dT() );
		}
		DIN_SF_WT.GrabMemory();
		if( DIN_SF_WT.GetF(FLinkEdges) ) { DIN_SF_WT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( ( ( RIVER_N.Value()+DIN_SF_WT_MINER.Value() )+DIN_UPFLOW.Value() )-DIN_DNFLOW.Value() )-DIN_SF_WT_UPTAKE.Value() );
			DIN_SF_WT.Update( value, dT() );
	  } break;
	}
	DIN_SF_WT.UpdateGOFComputation();
	return 0;
}

int DIN_module::DIN_SF_WT_i59_exe() {
	float value;
	int array_index[64];


	switch( DIN_SF_WT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* DIN_SF_WT_ptr = DIN_SF_WT.DataStart();
		const float* DIN_SF_WT_Eptr = DIN_SF_WT.GridEnd();
		float dt = dT();
		float* DIN_SF_WT_Rptr = DIN_SF_WT.RDataStart();
		float* SF_WATER_ptr = SF_WATER.DataStart();
		float* P_IC_DIN_SF_WT_ptr = P_IC_DIN_SF_WT.DataStart();
		while( DIN_SF_WT_ptr < DIN_SF_WT_Eptr ) {
		 value =  ( ( (*(SF_WATER_ptr))*(*(P_IC_DIN_SF_WT_ptr)) )*.001 );
			if(DIN_SF_WT_Rptr) { *DIN_SF_WT_Rptr = *DIN_SF_WT_ptr = value;  DIN_SF_WT_Rptr++; }
			else { *DIN_SF_WT_ptr = value; }
			DIN_SF_WT_ptr++;
			SF_WATER.UpdateDataPtr(SF_WATER_ptr);
			P_IC_DIN_SF_WT.UpdateDataPtr(P_IC_DIN_SF_WT_ptr);
		}
		DIN_SF_WT.GrabMemory();
		if( DIN_SF_WT.GetF(FLinkEdges) ) { DIN_SF_WT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_SF_WT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( SF_WATER.Value(p)*P_IC_DIN_SF_WT.Value(p) )*.001 );
			DIN_SF_WT.InitValue( p, value );
		}
		DIN_SF_WT.GrabMemory();
		if( DIN_SF_WT.GetF(FLinkEdges) ) { DIN_SF_WT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( SF_WATER.Value()*P_IC_DIN_SF_WT.Value() )*.001 );
			DIN_SF_WT.InitValue( value );
	  } break;
	}
	DIN_SF_WT.UpdateGOFComputation();
	return 0;
}

int DIN_module::DIN_SF_WT_MINER_u60_exe() {
	float value;
	int array_index[64];


	switch( DIN_SF_WT_MINER.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* DIN_SF_WT_MINER_ptr = DIN_SF_WT_MINER.DataStart();
		const float* DIN_SF_WT_MINER_Eptr = DIN_SF_WT_MINER.GridEnd();
		float dt = dT();
		float* DETR_DECOMPOSED_ptr = DETR_DECOMPOSED.DataStart();
		float* P_DETR_NC_RT_ptr = P_DETR_NC_RT.DataStart();
		int clamped = 0;
		while( DIN_SF_WT_MINER_ptr < DIN_SF_WT_MINER_Eptr ) {
		 value =  ( (*(DETR_DECOMPOSED_ptr))*(*(P_DETR_NC_RT_ptr)) );
			*DIN_SF_WT_MINER_ptr = value;
			DIN_SF_WT_MINER_ptr++;
			DETR_DECOMPOSED.UpdateDataPtr(DETR_DECOMPOSED_ptr);
			P_DETR_NC_RT.UpdateDataPtr(P_DETR_NC_RT_ptr);
		}
		if( DIN_SF_WT_MINER.GetF(FICFlux) ) DIN_SF_WT_MINER.Cov().Set(0.0); 
		DIN_SF_WT_MINER.GrabMemory();
		if( DIN_SF_WT_MINER.GetF(FLinkEdges) ) { DIN_SF_WT_MINER.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_SF_WT_MINER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( DETR_DECOMPOSED.Value(p)*P_DETR_NC_RT.Value(p) );
			DIN_SF_WT_MINER.Update( p, value );
		}
		DIN_SF_WT_MINER.GrabMemory();
		if( DIN_SF_WT_MINER.GetF(FICFlux) ) DIN_SF_WT_MINER.Cov().Set(0.0); 
		if( DIN_SF_WT_MINER.GetF(FLinkEdges) ) { DIN_SF_WT_MINER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( DETR_DECOMPOSED.Value()*P_DETR_NC_RT.Value() );
			DIN_SF_WT_MINER.Update( value );
	  } break;
	}
	DIN_SF_WT_MINER.UpdateGOFComputation();
	return 0;
}

int DIN_module::DIN_UPFLOW_u61_exe() {
	float value;
	int array_index[64];


	switch( DIN_UPFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* DIN_UPFLOW_ptr = DIN_UPFLOW.DataStart();
		const float* DIN_UPFLOW_Eptr = DIN_UPFLOW.GridEnd();
		float dt = dT();
		float* DIN_CONC_ptr = DIN_CONC.DataStart();
		float* P_DIN_SED_CONC_MAP_ptr = P_DIN_SED_CONC_MAP.DataStart();
		float* P_DIFFUSION_COEFF_ptr = P_DIFFUSION_COEFF.DataStart();
		int clamped = 0;
		while( DIN_UPFLOW_ptr < DIN_UPFLOW_Eptr ) {
		 value =   ( ( ( (*(DIN_CONC_ptr)) >= (*(P_DIN_SED_CONC_MAP_ptr)) ) ) ? ( ((float)0) ) : ( ( ( ( (*(P_DIN_SED_CONC_MAP_ptr))-(*(DIN_CONC_ptr)) )*(*(P_DIFFUSION_COEFF_ptr)) )*dT() ) ) ) ;
			*DIN_UPFLOW_ptr = value;
			DIN_UPFLOW_ptr++;
			DIN_CONC.UpdateDataPtr(DIN_CONC_ptr);
			P_DIN_SED_CONC_MAP.UpdateDataPtr(P_DIN_SED_CONC_MAP_ptr);
			P_DIFFUSION_COEFF.UpdateDataPtr(P_DIFFUSION_COEFF_ptr);
		}
		if( DIN_UPFLOW.GetF(FICFlux) ) DIN_UPFLOW.Cov().Set(0.0); 
		DIN_UPFLOW.GrabMemory();
		if( DIN_UPFLOW.GetF(FLinkEdges) ) { DIN_UPFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_UPFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( DIN_CONC.Value(p) >= P_DIN_SED_CONC_MAP.Value(p) ) ) ? ( ((float)0) ) : ( ( ( ( P_DIN_SED_CONC_MAP.Value(p)-DIN_CONC.Value(p) )*P_DIFFUSION_COEFF.Value(p) )*dT() ) ) ) ;
			DIN_UPFLOW.Update( p, value );
		}
		DIN_UPFLOW.GrabMemory();
		if( DIN_UPFLOW.GetF(FICFlux) ) DIN_UPFLOW.Cov().Set(0.0); 
		if( DIN_UPFLOW.GetF(FLinkEdges) ) { DIN_UPFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( DIN_CONC.Value() >= P_DIN_SED_CONC_MAP.Value() ) ) ? ( ((float)0) ) : ( ( ( ( P_DIN_SED_CONC_MAP.Value()-DIN_CONC.Value() )*P_DIFFUSION_COEFF.Value() )*dT() ) ) ) ;
			DIN_UPFLOW.Update( value );
	  } break;
	}
	DIN_UPFLOW.UpdateGOFComputation();
	return 0;
}

int DIN_module::DIN_DNFLOW_u62_exe() {
	float value;
	int array_index[64];


	switch( DIN_DNFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* DIN_DNFLOW_ptr = DIN_DNFLOW.DataStart();
		const float* DIN_DNFLOW_Eptr = DIN_DNFLOW.GridEnd();
		float dt = dT();
		float* DIN_DNFLOW_Optr = ((CStateVariable*)(DIN_DNFLOW.Origin()))->RDataStart();
		float* DIN_CONC_ptr = DIN_CONC.DataStart();
		float* P_DIN_SED_CONC_MAP_ptr = P_DIN_SED_CONC_MAP.DataStart();
		float* P_DIFFUSION_COEFF_ptr = P_DIFFUSION_COEFF.DataStart();
		int clamped = DIN_SF_WT.GetF(FisClamped);
		while( DIN_DNFLOW_ptr < DIN_DNFLOW_Eptr ) {
		 value =   ( ( ( (*(DIN_CONC_ptr)) <= (*(P_DIN_SED_CONC_MAP_ptr)) ) ) ? ( ((float)0) ) : ( ( ( ( (*(DIN_CONC_ptr))-(*(P_DIN_SED_CONC_MAP_ptr)) )*(*(P_DIFFUSION_COEFF_ptr)) )*dT() ) ) ) ;
			*DIN_DNFLOW_ptr = value;
			if( clamped ) { SL::Clamp(DIN_DNFLOW_Optr++,DIN_DNFLOW_ptr,dt); }
			DIN_DNFLOW_ptr++;
			DIN_CONC.UpdateDataPtr(DIN_CONC_ptr);
			P_DIN_SED_CONC_MAP.UpdateDataPtr(P_DIN_SED_CONC_MAP_ptr);
			P_DIFFUSION_COEFF.UpdateDataPtr(P_DIFFUSION_COEFF_ptr);
		}
		if( DIN_DNFLOW.GetF(FICFlux) ) DIN_DNFLOW.Cov().Set(0.0); 
		DIN_DNFLOW.GrabMemory();
		if( DIN_DNFLOW.GetF(FLinkEdges) ) { DIN_DNFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_DNFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( DIN_CONC.Value(p) <= P_DIN_SED_CONC_MAP.Value(p) ) ) ? ( ((float)0) ) : ( ( ( ( DIN_CONC.Value(p)-P_DIN_SED_CONC_MAP.Value(p) )*P_DIFFUSION_COEFF.Value(p) )*dT() ) ) ) ;
			DIN_DNFLOW.Update( p, value );
		}
		DIN_DNFLOW.GrabMemory();
		if( DIN_DNFLOW.GetF(FICFlux) ) DIN_DNFLOW.Cov().Set(0.0); 
		if( DIN_DNFLOW.GetF(FLinkEdges) ) { DIN_DNFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( DIN_CONC.Value() <= P_DIN_SED_CONC_MAP.Value() ) ) ? ( ((float)0) ) : ( ( ( ( DIN_CONC.Value()-P_DIN_SED_CONC_MAP.Value() )*P_DIFFUSION_COEFF.Value() )*dT() ) ) ) ;
			DIN_DNFLOW.Update( value );
	  } break;
	}
	DIN_DNFLOW.UpdateGOFComputation();
	return 0;
}

int DIN_module::DIN_SF_WT_UPTAKE_u63_exe() {
	float value;
	int array_index[64];


	switch( DIN_SF_WT_UPTAKE.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* DIN_SF_WT_UPTAKE_ptr = DIN_SF_WT_UPTAKE.DataStart();
		const float* DIN_SF_WT_UPTAKE_Eptr = DIN_SF_WT_UPTAKE.GridEnd();
		float dt = dT();
		float* DIN_SF_WT_UPTAKE_Optr = ((CStateVariable*)(DIN_SF_WT_UPTAKE.Origin()))->RDataStart();
		float* PHT_NET_PROD_ptr = PHT_NET_PROD.DataStart();
		float* P_PHT_NC_ptr = P_PHT_NC.DataStart();
		int clamped = DIN_SF_WT.GetF(FisClamped);
		while( DIN_SF_WT_UPTAKE_ptr < DIN_SF_WT_UPTAKE_Eptr ) {
		 value =  ( (*(PHT_NET_PROD_ptr))*(*(P_PHT_NC_ptr)) );
			*DIN_SF_WT_UPTAKE_ptr = value;
			if( clamped ) { SL::Clamp(DIN_SF_WT_UPTAKE_Optr++,DIN_SF_WT_UPTAKE_ptr,dt); }
			DIN_SF_WT_UPTAKE_ptr++;
			PHT_NET_PROD.UpdateDataPtr(PHT_NET_PROD_ptr);
			P_PHT_NC.UpdateDataPtr(P_PHT_NC_ptr);
		}
		if( DIN_SF_WT_UPTAKE.GetF(FICFlux) ) DIN_SF_WT_UPTAKE.Cov().Set(0.0); 
		DIN_SF_WT_UPTAKE.GrabMemory();
		if( DIN_SF_WT_UPTAKE.GetF(FLinkEdges) ) { DIN_SF_WT_UPTAKE.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_SF_WT_UPTAKE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( PHT_NET_PROD.Value(p)*P_PHT_NC.Value(p) );
			DIN_SF_WT_UPTAKE.Update( p, value );
		}
		DIN_SF_WT_UPTAKE.GrabMemory();
		if( DIN_SF_WT_UPTAKE.GetF(FICFlux) ) DIN_SF_WT_UPTAKE.Cov().Set(0.0); 
		if( DIN_SF_WT_UPTAKE.GetF(FLinkEdges) ) { DIN_SF_WT_UPTAKE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( PHT_NET_PROD.Value()*P_PHT_NC.Value() );
			DIN_SF_WT_UPTAKE.Update( value );
	  } break;
	}
	DIN_SF_WT_UPTAKE.UpdateGOFComputation();
	return 0;
}

int DIN_module::DIN_CONC_u64_exe() {
	float value;
	int array_index[64];


	switch( DIN_CONC.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* DIN_CONC_ptr = DIN_CONC.DataStart();
		const float* DIN_CONC_Eptr = DIN_CONC.GridEnd();
		float* DIN_SF_WT_ptr = DIN_SF_WT.DataStart();
		float* SF_WATER_ptr = SF_WATER.DataStart();
		while( DIN_CONC_ptr < DIN_CONC_Eptr ) {
		 value =  ( (*(DIN_SF_WT_ptr))/(*(SF_WATER_ptr)) );
			*DIN_CONC_ptr = value;
			DIN_CONC_ptr++;
			DIN_SF_WT.UpdateDataPtr(DIN_SF_WT_ptr);
			SF_WATER.UpdateDataPtr(SF_WATER_ptr);
		}
		DIN_CONC.GrabMemory();
		if( DIN_CONC.GetF(FLinkEdges) ) { DIN_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_CONC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( DIN_SF_WT.Value(p)/SF_WATER.Value(p) );
			DIN_CONC.Update( p, value );
		}
		DIN_CONC.GrabMemory();
		if( DIN_CONC.GetF(FLinkEdges) ) { DIN_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( DIN_SF_WT.Value()/SF_WATER.Value() );
			DIN_CONC.Update( value );
	  } break;
	}
	DIN_CONC.UpdateGOFComputation();
	return 0;
}

int DIN_module::RIVER_N_u65_exe() {
	float value;
	int array_index[64];


	switch( RIVER_N.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* RIVER_N_ptr = RIVER_N.DataStart();
		const float* RIVER_N_Eptr = RIVER_N.GridEnd();
		float dt = dT();
		int clamped = 0;
		while( RIVER_N_ptr < RIVER_N_Eptr ) {
		 value =  ((float)0);
			*RIVER_N_ptr = value;
			RIVER_N_ptr++;
		}
		if( RIVER_N.GetF(FICFlux) ) RIVER_N.Cov().Set(0.0); 
		RIVER_N.GrabMemory();
		if( RIVER_N.GetF(FLinkEdges) ) { RIVER_N.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = RIVER_N.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ((float)0);
			RIVER_N.Update( p, value );
		}
		RIVER_N.GrabMemory();
		if( RIVER_N.GetF(FICFlux) ) RIVER_N.Cov().Set(0.0); 
		if( RIVER_N.GetF(FLinkEdges) ) { RIVER_N.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ((float)0);
			RIVER_N.Update( value );
	  } break;
	}
	RIVER_N.UpdateGOFComputation();
	return 0;
}

int DIN_module::P_DETR_NC_RT_u66_exe() {
	float value;
	int array_index[64];


	switch( P_DETR_NC_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_DETR_NC_RT_ptr = P_DETR_NC_RT.DataStart();
		const float* P_DETR_NC_RT_Eptr = P_DETR_NC_RT.GridEnd();
		while( P_DETR_NC_RT_ptr < P_DETR_NC_RT_Eptr ) {
		 value =  ( ((float)16)/100 );
			*P_DETR_NC_RT_ptr = value;
			P_DETR_NC_RT_ptr++;
		}
		P_DETR_NC_RT.GrabMemory();
		if( P_DETR_NC_RT.GetF(FLinkEdges) ) { P_DETR_NC_RT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_DETR_NC_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ((float)16)/100 );
			P_DETR_NC_RT.Update( p, value );
		}
		P_DETR_NC_RT.GrabMemory();
		if( P_DETR_NC_RT.GetF(FLinkEdges) ) { P_DETR_NC_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ((float)16)/100 );
			P_DETR_NC_RT.Update( value );
	  } break;
	}
	P_DETR_NC_RT.UpdateGOFComputation();
	return 0;
}

int DIN_module::P_DIFFUSION_COEFF_u67_exe() {
	float value;
	int array_index[64];


	switch( P_DIFFUSION_COEFF.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_DIFFUSION_COEFF_ptr = P_DIFFUSION_COEFF.DataStart();
		const float* P_DIFFUSION_COEFF_Eptr = P_DIFFUSION_COEFF.GridEnd();
		float* BOTTOM_MAP_ptr = BOTTOM_MAP.DataStart();
		while( P_DIFFUSION_COEFF_ptr < P_DIFFUSION_COEFF_Eptr ) {
		 value =   ( ( ( (*(BOTTOM_MAP_ptr)) == ((float)1) ) ) ? ( 0.005 ) : ( 0.0 ) ) ;
			*P_DIFFUSION_COEFF_ptr = value;
			P_DIFFUSION_COEFF_ptr++;
			BOTTOM_MAP.UpdateDataPtr(BOTTOM_MAP_ptr);
		}
		P_DIFFUSION_COEFF.GrabMemory();
		if( P_DIFFUSION_COEFF.GetF(FLinkEdges) ) { P_DIFFUSION_COEFF.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_DIFFUSION_COEFF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( BOTTOM_MAP.Value(p) == ((float)1) ) ) ? ( 0.005 ) : ( 0.0 ) ) ;
			P_DIFFUSION_COEFF.Update( p, value );
		}
		P_DIFFUSION_COEFF.GrabMemory();
		if( P_DIFFUSION_COEFF.GetF(FLinkEdges) ) { P_DIFFUSION_COEFF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( BOTTOM_MAP.Value() == ((float)1) ) ) ? ( 0.005 ) : ( 0.0 ) ) ;
			P_DIFFUSION_COEFF.Update( value );
	  } break;
	}
	P_DIFFUSION_COEFF.UpdateGOFComputation();
	return 0;
}

int DIN_module::P_DIN_SED_CONC_MAP_u68_exe() {
	float value;
	int array_index[64];


	switch( P_DIN_SED_CONC_MAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_DIN_SED_CONC_MAP_ptr = P_DIN_SED_CONC_MAP.DataStart();
		const float* P_DIN_SED_CONC_MAP_Eptr = P_DIN_SED_CONC_MAP.GridEnd();
		 value =  4.200000;
		value = P_DIN_SED_CONC_MAP.ParameterValue(value);
		while( P_DIN_SED_CONC_MAP_ptr < P_DIN_SED_CONC_MAP_Eptr ) {
			*P_DIN_SED_CONC_MAP_ptr = value;
			P_DIN_SED_CONC_MAP_ptr++;
		}
		P_DIN_SED_CONC_MAP.GrabMemory();
		if( P_DIN_SED_CONC_MAP.GetF(FLinkEdges) ) { P_DIN_SED_CONC_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_DIN_SED_CONC_MAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  4.200000;
			P_DIN_SED_CONC_MAP.Update( p, P_DIN_SED_CONC_MAP.ParameterValue(value,p) );
		}
		P_DIN_SED_CONC_MAP.GrabMemory();
		if( P_DIN_SED_CONC_MAP.GetF(FLinkEdges) ) { P_DIN_SED_CONC_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  4.200000;
			P_DIN_SED_CONC_MAP.Update( P_DIN_SED_CONC_MAP.ParameterValue(value) );
	  } break;
	}
	P_DIN_SED_CONC_MAP.UpdateGOFComputation();
	return 0;
}

int DIN_module::P_IC_DIN_SF_WT_u69_exe() {
	float value;
	int array_index[64];


	switch( P_IC_DIN_SF_WT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_IC_DIN_SF_WT_ptr = P_IC_DIN_SF_WT.DataStart();
		const float* P_IC_DIN_SF_WT_Eptr = P_IC_DIN_SF_WT.GridEnd();
		 value =  0.01000;
		value = P_IC_DIN_SF_WT.ParameterValue(value);
		while( P_IC_DIN_SF_WT_ptr < P_IC_DIN_SF_WT_Eptr ) {
			*P_IC_DIN_SF_WT_ptr = value;
			P_IC_DIN_SF_WT_ptr++;
		}
		P_IC_DIN_SF_WT.GrabMemory();
		if( P_IC_DIN_SF_WT.GetF(FLinkEdges) ) { P_IC_DIN_SF_WT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_IC_DIN_SF_WT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.01000;
			P_IC_DIN_SF_WT.Update( p, P_IC_DIN_SF_WT.ParameterValue(value,p) );
		}
		P_IC_DIN_SF_WT.GrabMemory();
		if( P_IC_DIN_SF_WT.GetF(FLinkEdges) ) { P_IC_DIN_SF_WT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.01000;
			P_IC_DIN_SF_WT.Update( P_IC_DIN_SF_WT.ParameterValue(value) );
	  } break;
	}
	P_IC_DIN_SF_WT.UpdateGOFComputation();
	return 0;
}

DIN_module* DIN_module::fInstance = NULL;
DIN_module* DIN_module::kNullModel = (DIN_module*)0x1;
int DIN_module::InitVars() {
	TIME.SSInit(this);
	SF_WATER.SSInit(this);
	DETR_DECOMPOSED.SSInit(this);
	PHT_NET_PROD.SSInit(this);
	P_PHT_NC.SSInit(this);
	BOTTOM_MAP.SSInit(this);
	DIN_CONC.SSInit(this);
	DIN_SF_WT.SSInit(this);
	DIN_SF_WT.SetLinkEdges();
	DIN_SF_WT_MINER.SSInit(this);
	DIN_SF_WT_MINER.SetDestination(&DIN_SF_WT);
	DIN_UPFLOW.SSInit(this);
	DIN_UPFLOW.SetDestination(&DIN_SF_WT);
	DIN_DNFLOW.SSInit(this);
	DIN_DNFLOW.SetOrigin(&DIN_SF_WT);
	DIN_SF_WT_UPTAKE.SSInit(this);
	DIN_SF_WT_UPTAKE.SetOrigin(&DIN_SF_WT);
	RIVER_N.SSInit(this);
	RIVER_N.SetDestination(&DIN_SF_WT);
	P_DETR_NC_RT.SSInit(this);
	P_DIFFUSION_COEFF.SSInit(this);
	P_DIN_SED_CONC_MAP.SSInit(this);
	P_IC_DIN_SF_WT.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int DIN_module::SetupEvents() {
	TImportCommand* SF_WATER_import0 = (TImportCommand*) SF_WATER.GetCommand("SF_WATER_import0",TCommand::kUndefined,TCommand::kImport);
	SF_WATER_import0->Code() = "Import SF_WATER";
	SF_WATER_import0->AddDependency(SF_WATER);
	SF_WATER_import0->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DETR_DECOMPOSED_import1 = (TImportCommand*) DETR_DECOMPOSED.GetCommand("DETR_DECOMPOSED_import1",TCommand::kUndefined,TCommand::kImport);
	DETR_DECOMPOSED_import1->Code() = "Import DETR_DECOMPOSED";
	DETR_DECOMPOSED_import1->AddDependency(DETR_DECOMPOSED);
	DETR_DECOMPOSED_import1->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PHT_NET_PROD_import2 = (TImportCommand*) PHT_NET_PROD.GetCommand("PHT_NET_PROD_import2",TCommand::kUndefined,TCommand::kImport);
	PHT_NET_PROD_import2->Code() = "Import PHT_NET_PROD";
	PHT_NET_PROD_import2->AddDependency(PHT_NET_PROD);
	PHT_NET_PROD_import2->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P_PHT_NC_import3 = (TImportCommand*) P_PHT_NC.GetCommand("P_PHT_NC_import3",TCommand::kUndefined,TCommand::kImport);
	P_PHT_NC_import3->Code() = "Import P_PHT_NC";
	P_PHT_NC_import3->AddDependency(P_PHT_NC);
	P_PHT_NC_import3->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* BOTTOM_MAP_import4 = (TImportCommand*) BOTTOM_MAP.GetCommand("BOTTOM_MAP_import4",TCommand::kUndefined,TCommand::kImport);
	BOTTOM_MAP_import4->Code() = "Import BOTTOM_MAP";
	BOTTOM_MAP_import4->AddDependency(BOTTOM_MAP);
	BOTTOM_MAP_import4->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u64 = (TExecuteCommand*) DIN_CONC.GetCommand("u64",TCommand::kUpdate,TCommand::kCode);
	u64->SetExecutable(&DIN_CONC_u64_exe_g);
	u64->Code() = "u64 <- ( DIN_SF_WT/SF_WATER )";
	u64->AddDependency(DIN_SF_WT);
	u64->AddDependency(SF_WATER);
	u64->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I58 = (TExecuteCommand*) DIN_SF_WT.GetCommand("I58",TCommand::kIntegrate,TCommand::kCode);
	I58->SetExecutable(&DIN_SF_WT_I58_exe_g);
	I58->Code() = "I58 <- ( ( ( ( RIVER_N+DIN_SF_WT_MINER )+DIN_UPFLOW )-DIN_DNFLOW )-DIN_SF_WT_UPTAKE )";
	I58->AddDependency(RIVER_N);
	I58->AddDependency(DIN_SF_WT_MINER);
	I58->AddDependency(DIN_UPFLOW);
	I58->AddDependency(DIN_DNFLOW);
	I58->AddDependency(DIN_SF_WT_UPTAKE);
	I58->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i59 = (TExecuteCommand*) DIN_SF_WT.GetCommand("i59",TCommand::kInit,TCommand::kCode);
	i59->SetExecutable(&DIN_SF_WT_i59_exe_g);
	i59->Code() = "i59 <- ( ( SF_WATER*P_IC_DIN_SF_WT )*.001 )";
	i59->AddDependency(SF_WATER);
	i59->AddDependency(P_IC_DIN_SF_WT);
	i59->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u60 = (TExecuteCommand*) DIN_SF_WT_MINER.GetCommand("u60",TCommand::kUpdate,TCommand::kCode);
	u60->SetExecutable(&DIN_SF_WT_MINER_u60_exe_g);
	u60->Code() = "u60 <- ( DETR_DECOMPOSED*P_DETR_NC_RT )";
	u60->AddDependency(DETR_DECOMPOSED);
	u60->AddDependency(P_DETR_NC_RT);
	u60->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u61 = (TExecuteCommand*) DIN_UPFLOW.GetCommand("u61",TCommand::kUpdate,TCommand::kCode);
	u61->SetExecutable(&DIN_UPFLOW_u61_exe_g);
	u61->Code() = "u61 <-  ( ( ( DIN_CONC >= P_DIN_SED_CONC_MAP ) ) ? ( ((float)0) ) : ( ( ( ( P_DIN_SED_CONC_MAP-DIN_CONC )*P_DIFFUSION_COEFF )*dT() ) ) ) ";
	u61->AddDependency(DIN_CONC);
	u61->AddDependency(P_DIN_SED_CONC_MAP);
	u61->AddDependency(P_DIFFUSION_COEFF);
	u61->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u62 = (TExecuteCommand*) DIN_DNFLOW.GetCommand("u62",TCommand::kUpdate,TCommand::kCode);
	u62->SetExecutable(&DIN_DNFLOW_u62_exe_g);
	u62->Code() = "u62 <-  ( ( ( DIN_CONC <= P_DIN_SED_CONC_MAP ) ) ? ( ((float)0) ) : ( ( ( ( DIN_CONC-P_DIN_SED_CONC_MAP )*P_DIFFUSION_COEFF )*dT() ) ) ) ";
	if( DIN_DNFLOW.GetF(FisClamped) ) { u62->AddDependency(DIN_SF_WT); }
	u62->AddDependency(DIN_CONC);
	u62->AddDependency(P_DIN_SED_CONC_MAP);
	u62->AddDependency(P_DIFFUSION_COEFF);
	u62->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u63 = (TExecuteCommand*) DIN_SF_WT_UPTAKE.GetCommand("u63",TCommand::kUpdate,TCommand::kCode);
	u63->SetExecutable(&DIN_SF_WT_UPTAKE_u63_exe_g);
	u63->Code() = "u63 <- ( PHT_NET_PROD*P_PHT_NC )";
	if( DIN_SF_WT_UPTAKE.GetF(FisClamped) ) { u63->AddDependency(DIN_SF_WT); }
	u63->AddDependency(PHT_NET_PROD);
	u63->AddDependency(P_PHT_NC);
	u63->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u65 = (TExecuteCommand*) RIVER_N.GetCommand("u65",TCommand::kUpdate,TCommand::kCode);
	u65->SetExecutable(&RIVER_N_u65_exe_g);
	u65->Code() = "u65 <- ((float)0)";
	u65->SetObjInfo(TCommand::kDepIndex, 5);
	TImportCommand* RIVER_N_import5 = (TImportCommand*) RIVER_N.GetCommand("RIVER_N_import5",TCommand::kUndefined,TCommand::kImport);
	RIVER_N_import5->Code() = "Import RIVER_N";
	RIVER_N_import5->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u66 = (TExecuteCommand*) P_DETR_NC_RT.GetCommand("u66",TCommand::kUpdate,TCommand::kCode);
	u66->SetExecutable(&P_DETR_NC_RT_u66_exe_g);
	u66->Code() = "u66 <- ( ((float)16)/100 )";
	u66->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u67 = (TExecuteCommand*) P_DIFFUSION_COEFF.GetCommand("u67",TCommand::kUpdate,TCommand::kCode);
	u67->SetExecutable(&P_DIFFUSION_COEFF_u67_exe_g);
	u67->Code() = "u67 <-  ( ( ( BOTTOM_MAP == ((float)1) ) ) ? ( 0.005 ) : ( 0.0 ) ) ";
	u67->AddDependency(BOTTOM_MAP);
	u67->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u68 = (TExecuteCommand*) P_DIN_SED_CONC_MAP.GetCommand("u68",TCommand::kUpdate,TCommand::kCode);
	u68->SetExecutable(&P_DIN_SED_CONC_MAP_u68_exe_g);
	u68->Code() = "u68 <- 4.200000";
	u68->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u69 = (TExecuteCommand*) P_IC_DIN_SF_WT.GetCommand("u69",TCommand::kUpdate,TCommand::kCode);
	u69->SetExecutable(&P_IC_DIN_SF_WT_u69_exe_g);
	u69->Code() = "u69 <- 0.01000";
	u69->SetObjInfo(TCommand::kDepIndex, 5);
	return 0;
}

int DIN_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int DIN_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int DIN_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int DIN_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class GLOBAL_module 
// ---------------------------------------------------------------------------
GLOBAL_module::GLOBAL_module(char* name) :
	TIME("TIME"),
	P_CELL_AREA("P_CELL_AREA"),
	BOTTOM_MAP("BOTTOM_MAP"),
	SURFACE_MAP("SURFACE_MAP"),
	OM3_TEMP("OM3_TEMP"),
	SF_WATER("SF_WATER"),
	TSS_CONC("TSS_CONC"),
	PHT_CONC("PHT_CONC"),
	LIGHT_TO_PHYTOPLANKTON("LIGHT_TO_PHYTOPLANKTON"),
	P_CHL_A_MAP("P_CHL_A_MAP"),
	WATER_LAYER_DEPTH("WATER_LAYER_DEPTH"),
	P_ON_MAP("P_ON_MAP"),
	WATER_DEPTH("WATER_DEPTH"),
	OM3_SHEAR_STRESS("OM3_SHEAR_STRESS"),
	DAYS("DAYS"),
	COUNT_HOURS("COUNT_HOURS"),
	CURRENT_DIRECTION("CURRENT_DIRECTION"),
	CURRENT_VELOCITY("CURRENT_VELOCITY"),
	EC_H2O("EC_H2O"),
	EW_CURRENT_VECTOR("EW_CURRENT_VECTOR"),
	EW_VECTOR("EW_VECTOR"),
	EW_WIND_VECTOR("EW_WIND_VECTOR"),
	HOURS("HOURS"),
	NS_CURRENT_VECTOR("NS_CURRENT_VECTOR"),
	NS_VECTOR("NS_VECTOR"),
	NS_WIND_VECTOR("NS_WIND_VECTOR"),
	OM3_SALT_CONC("OM3_SALT_CONC"),
	OM3_UD_CURRENT_VECTOR("OM3_UD_CURRENT_VECTOR"),
	PHOTO_PERIOD("PHOTO_PERIOD"),
	RAND("RAND"),
	SDCLN("SDCLN"),
	SURFACE_LIGHT("SURFACE_LIGHT"),
	WATER_LAYER_HEIGHT("WATER_LAYER_HEIGHT"),
	X("X"),
	Y("Y"),
	P_EC_COEFF_SED("P_EC_COEFF_SED"),
	P_EC_COEFF_WATER("P_EC_COEFF_WATER"),
	P_IC_SED_ELEV("P_IC_SED_ELEV"),
	P_LATITUDE("P_LATITUDE"),
	DECLINE("DECLINE"),
	H_ANGLE("H_ANGLE"),
	SKEW_WEATHER("SKEW_WEATHER"),
	P_AIR_TEMP("P_AIR_TEMP"),
	P_LEAF_GROW_SEASON("P_LEAF_GROW_SEASON"),
	P_PRECIPITATION("P_PRECIPITATION"),
	P_WIND_DIRECTION("P_WIND_DIRECTION"),
	P_WIND_SPEED("P_WIND_SPEED"),
	TModule(name) {

	P_CELL_AREA.SetF(FisExport,True,"CG");
	BOTTOM_MAP.SetF(FisExport,True,"CG");
	SURFACE_MAP.SetF(FisExport,True,"CG");
	OM3_TEMP.SetF(FisExport,True,"CG");
	SF_WATER.SetF(FisExport,True,"CG");
	TSS_CONC.SetF(FisImport,True,"CG");
	PHT_CONC.SetF(FisImport,True,"CG");
	LIGHT_TO_PHYTOPLANKTON.SetF(FisExport,True,"CG");
	P_CHL_A_MAP.SetF(FisExport,True,"CG");
	WATER_LAYER_DEPTH.SetF(FisExport,True,"CG");
	P_ON_MAP.SetF(FisExport,True,"CG");
	WATER_DEPTH.SetF(FisExport,True,"CG");
	OM3_SHEAR_STRESS.SetF(FisExport,True,"CG");
}	
int GLOBAL_module::DAYS_I70_exe() {
	float value;
	int array_index[64];


	DAYS.UpdateIntegrator();
	switch( DAYS.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* DAYS_ptr = DAYS.DataStart();
		const float* DAYS_Eptr = DAYS.GridEnd();
		float dt = dT();
		float* DAYS_Rptr = DAYS.RDataStart();
		float* COUNT_HOURS_ptr = COUNT_HOURS.DataStart();
		switch( DAYS.CurrentOrder() ) {
		  case 1: {
			if( DAYS.Order() > 1 ) {
			float *DAYS_IMptr0 = DAYS.SIntegratorMemory().LastData();
			while( DAYS_ptr < DAYS_Eptr ) {
		 value =  (*(COUNT_HOURS_ptr));
				*DAYS_ptr += value*dt;
				if(DAYS_Rptr) { *DAYS_Rptr++ = *DAYS_ptr; }
				*DAYS_IMptr0++ = value;
				DAYS_ptr++;
				COUNT_HOURS.UpdateDataPtr(COUNT_HOURS_ptr);
			}
			} else {
			while( DAYS_ptr < DAYS_Eptr ) {
		 value =  (*(COUNT_HOURS_ptr));
				*DAYS_ptr += value*dt;
				if(DAYS_Rptr) { *DAYS_Rptr++ = *DAYS_ptr; }
				DAYS_ptr++;
				COUNT_HOURS.UpdateDataPtr(COUNT_HOURS_ptr);
			}
			};
		  } break; case 2: {
			float *DAYS_IMptr0 = DAYS.SIntegratorMemory().LastData();
			float *DAYS_IMptr1 = DAYS.SIntegratorMemory().LastDataOffset(1);
			while( DAYS_ptr < DAYS_Eptr ) {
		 value =  (*(COUNT_HOURS_ptr));
				*DAYS_IMptr0++ = value;
				*DAYS_ptr += ( 1.5*value - 0.5* *DAYS_IMptr1++ )*dt;
				if(DAYS_Rptr) { *DAYS_Rptr++ = *DAYS_ptr; }
				DAYS_ptr++;
				COUNT_HOURS.UpdateDataPtr(COUNT_HOURS_ptr);
			}
		  } break; case 3: {
			float *DAYS_IMptr0 = DAYS.SIntegratorMemory().LastData();
			float *DAYS_IMptr1 = DAYS.SIntegratorMemory().LastDataOffset(1);
			float *DAYS_IMptr2 = DAYS.SIntegratorMemory().LastDataOffset(2);
			while( DAYS_ptr < DAYS_Eptr ) {
		 value =  (*(COUNT_HOURS_ptr));
				*DAYS_IMptr0++ = value;
				*DAYS_ptr += (1.92*value - 1.33* *DAYS_IMptr1++ + .42* *DAYS_IMptr2++)*dt;
				if(DAYS_Rptr) { *DAYS_Rptr++ = *DAYS_ptr; }
				DAYS_ptr++;
				COUNT_HOURS.UpdateDataPtr(COUNT_HOURS_ptr);
			}
		  } break; case 4: {
			float *DAYS_IMptr0 = DAYS.SIntegratorMemory().LastData();
			float *DAYS_IMptr1 = DAYS.SIntegratorMemory().LastDataOffset(1);
			float *DAYS_IMptr2 = DAYS.SIntegratorMemory().LastDataOffset(2);
			float *DAYS_IMptr3 = DAYS.SIntegratorMemory().LastDataOffset(3);
			while( DAYS_ptr < DAYS_Eptr ) {
		 value =  (*(COUNT_HOURS_ptr));
				*DAYS_IMptr0++ = value;
				*DAYS_ptr += (2.29*value - 2.46* *DAYS_IMptr1++  + 1.54* *DAYS_IMptr2++ - .375* *DAYS_IMptr3++ )*dt;
				if(DAYS_Rptr) { *DAYS_Rptr++ = *DAYS_ptr; }
				DAYS_ptr++;
				COUNT_HOURS.UpdateDataPtr(COUNT_HOURS_ptr);
			}
		  } break; default: { gPrintErr("Illegal Order in StateVar update!"); }
		};
		DAYS.GrabMemory();
		if( DAYS.GetF(FLinkEdges) ) { DAYS.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = DAYS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  COUNT_HOURS.Value(p);
			DAYS.Update( p, value, dT() );
		}
		DAYS.GrabMemory();
		if( DAYS.GetF(FLinkEdges) ) { DAYS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  COUNT_HOURS.Value();
			DAYS.Update( value, dT() );
	  } break;
	}
	DAYS.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::DAYS_i71_exe() {
	float value;
	int array_index[64];


	switch( DAYS.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* DAYS_ptr = DAYS.DataStart();
		const float* DAYS_Eptr = DAYS.GridEnd();
		float dt = dT();
		float* DAYS_Rptr = DAYS.RDataStart();
		while( DAYS_ptr < DAYS_Eptr ) {
		 value =  ((float)0);
			if(DAYS_Rptr) { *DAYS_Rptr = *DAYS_ptr = value;  DAYS_Rptr++; }
			else { *DAYS_ptr = value; }
			DAYS_ptr++;
		}
		DAYS.GrabMemory();
		if( DAYS.GetF(FLinkEdges) ) { DAYS.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = DAYS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ((float)0);
			DAYS.InitValue( p, value );
		}
		DAYS.GrabMemory();
		if( DAYS.GetF(FLinkEdges) ) { DAYS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ((float)0);
			DAYS.InitValue( value );
	  } break;
	}
	DAYS.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::COUNT_HOURS_u72_exe() {
	float value;
	int array_index[64];


	switch( COUNT_HOURS.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* COUNT_HOURS_ptr = COUNT_HOURS.DataStart();
		const float* COUNT_HOURS_Eptr = COUNT_HOURS.GridEnd();
		float dt = dT();
		float* HOURS_ptr = HOURS.DataStart();
		int clamped = 0;
		while( COUNT_HOURS_ptr < COUNT_HOURS_Eptr ) {
		 value =   ( ( ( (*(HOURS_ptr)) == ((float)0) ) ) ? ( ( ((float)1)*dT() ) ) : ( ((float)0) ) ) ;
			*COUNT_HOURS_ptr = value;
			COUNT_HOURS_ptr++;
			HOURS.UpdateDataPtr(HOURS_ptr);
		}
		if( COUNT_HOURS.GetF(FICFlux) ) COUNT_HOURS.Cov().Set(0.0); 
		COUNT_HOURS.GrabMemory();
		if( COUNT_HOURS.GetF(FLinkEdges) ) { COUNT_HOURS.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = COUNT_HOURS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( HOURS.Value(p) == ((float)0) ) ) ? ( ( ((float)1)*dT() ) ) : ( ((float)0) ) ) ;
			COUNT_HOURS.Update( p, value );
		}
		COUNT_HOURS.GrabMemory();
		if( COUNT_HOURS.GetF(FICFlux) ) COUNT_HOURS.Cov().Set(0.0); 
		if( COUNT_HOURS.GetF(FLinkEdges) ) { COUNT_HOURS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( HOURS.Value() == ((float)0) ) ) ? ( ( ((float)1)*dT() ) ) : ( ((float)0) ) ) ;
			COUNT_HOURS.Update( value );
	  } break;
	}
	COUNT_HOURS.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::BOTTOM_MAP_u73_exe() {
	float value;
	int array_index[64];


	switch( BOTTOM_MAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* BOTTOM_MAP_ptr = BOTTOM_MAP.DataStart();
		const float* BOTTOM_MAP_Eptr = BOTTOM_MAP.GridEnd();
		 value =  1;
		value = BOTTOM_MAP.ParameterValue(value);
		while( BOTTOM_MAP_ptr < BOTTOM_MAP_Eptr ) {
			*BOTTOM_MAP_ptr = value;
			BOTTOM_MAP_ptr++;
		}
		BOTTOM_MAP.GrabMemory();
		if( BOTTOM_MAP.GetF(FLinkEdges) ) { BOTTOM_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = BOTTOM_MAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  1;
			BOTTOM_MAP.Update( p, BOTTOM_MAP.ParameterValue(value,p) );
		}
		BOTTOM_MAP.GrabMemory();
		if( BOTTOM_MAP.GetF(FLinkEdges) ) { BOTTOM_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  1;
			BOTTOM_MAP.Update( BOTTOM_MAP.ParameterValue(value) );
	  } break;
	}
	BOTTOM_MAP.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::CURRENT_DIRECTION_u74_exe() {
	float value;
	int array_index[64];


	switch( CURRENT_DIRECTION.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* CURRENT_DIRECTION_ptr = CURRENT_DIRECTION.DataStart();
		const float* CURRENT_DIRECTION_Eptr = CURRENT_DIRECTION.GridEnd();
		float* NS_VECTOR_ptr = NS_VECTOR.DataStart();
		float* EW_VECTOR_ptr = EW_VECTOR.DataStart();
		while( CURRENT_DIRECTION_ptr < CURRENT_DIRECTION_Eptr ) {
		 value =   ( ( ( ( (*(NS_VECTOR_ptr)) == ((float)0) ) && ( (*(EW_VECTOR_ptr)) == ((float)0) ) ) ) ? ( ((float)0) ) : (  ( ( ( ( ((float)450)-( SL::Arctan(( (*(NS_VECTOR_ptr))/(*(EW_VECTOR_ptr)) ))*( ((float)360)/( ((float)2)*3.141590 ) ) ) )*((float)360) ) ) ? ( ( ( ((float)450)-( SL::Arctan(( (*(NS_VECTOR_ptr))/(*(EW_VECTOR_ptr)) ))*( ((float)360)/( ((float)2)*3.141590 ) ) ) )-((float)360) ) ) : ( ( ((float)450)-( SL::Arctan(( (*(NS_VECTOR_ptr))/(*(EW_VECTOR_ptr)) ))*( ((float)360)/( ((float)2)*3.141590 ) ) ) ) ) )  ) ) ;
			*CURRENT_DIRECTION_ptr = value;
			CURRENT_DIRECTION_ptr++;
			NS_VECTOR.UpdateDataPtr(NS_VECTOR_ptr);
			EW_VECTOR.UpdateDataPtr(EW_VECTOR_ptr);
		}
		CURRENT_DIRECTION.GrabMemory();
		if( CURRENT_DIRECTION.GetF(FLinkEdges) ) { CURRENT_DIRECTION.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = CURRENT_DIRECTION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( ( NS_VECTOR.Value(p) == ((float)0) ) && ( EW_VECTOR.Value(p) == ((float)0) ) ) ) ? ( ((float)0) ) : (  ( ( ( ( ((float)450)-( SL::Arctan(( NS_VECTOR.Value(p)/EW_VECTOR.Value(p) ))*( ((float)360)/( ((float)2)*3.141590 ) ) ) )*((float)360) ) ) ? ( ( ( ((float)450)-( SL::Arctan(( NS_VECTOR.Value(p)/EW_VECTOR.Value(p) ))*( ((float)360)/( ((float)2)*3.141590 ) ) ) )-((float)360) ) ) : ( ( ((float)450)-( SL::Arctan(( NS_VECTOR.Value(p)/EW_VECTOR.Value(p) ))*( ((float)360)/( ((float)2)*3.141590 ) ) ) ) ) )  ) ) ;
			CURRENT_DIRECTION.Update( p, value );
		}
		CURRENT_DIRECTION.GrabMemory();
		if( CURRENT_DIRECTION.GetF(FLinkEdges) ) { CURRENT_DIRECTION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( ( NS_VECTOR.Value() == ((float)0) ) && ( EW_VECTOR.Value() == ((float)0) ) ) ) ? ( ((float)0) ) : (  ( ( ( ( ((float)450)-( SL::Arctan(( NS_VECTOR.Value()/EW_VECTOR.Value() ))*( ((float)360)/( ((float)2)*3.141590 ) ) ) )*((float)360) ) ) ? ( ( ( ((float)450)-( SL::Arctan(( NS_VECTOR.Value()/EW_VECTOR.Value() ))*( ((float)360)/( ((float)2)*3.141590 ) ) ) )-((float)360) ) ) : ( ( ((float)450)-( SL::Arctan(( NS_VECTOR.Value()/EW_VECTOR.Value() ))*( ((float)360)/( ((float)2)*3.141590 ) ) ) ) ) )  ) ) ;
			CURRENT_DIRECTION.Update( value );
	  } break;
	}
	CURRENT_DIRECTION.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::CURRENT_VELOCITY_u75_exe() {
	float value;
	int array_index[64];


	switch( CURRENT_VELOCITY.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* CURRENT_VELOCITY_ptr = CURRENT_VELOCITY.DataStart();
		const float* CURRENT_VELOCITY_Eptr = CURRENT_VELOCITY.GridEnd();
		float* EW_VECTOR_ptr = EW_VECTOR.DataStart();
		float* NS_VECTOR_ptr = NS_VECTOR.DataStart();
		while( CURRENT_VELOCITY_ptr < CURRENT_VELOCITY_Eptr ) {
		 value =  SL::Sqrt(( pow((double)(*(EW_VECTOR_ptr)),(double)((float)2) )+pow((double)(*(NS_VECTOR_ptr)),(double)((float)2) ) ));
			*CURRENT_VELOCITY_ptr = value;
			CURRENT_VELOCITY_ptr++;
			EW_VECTOR.UpdateDataPtr(EW_VECTOR_ptr);
			NS_VECTOR.UpdateDataPtr(NS_VECTOR_ptr);
		}
		CURRENT_VELOCITY.GrabMemory();
		if( CURRENT_VELOCITY.GetF(FLinkEdges) ) { CURRENT_VELOCITY.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = CURRENT_VELOCITY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  SL::Sqrt(( pow((double)EW_VECTOR.Value(p),(double)((float)2) )+pow((double)NS_VECTOR.Value(p),(double)((float)2) ) ));
			CURRENT_VELOCITY.Update( p, value );
		}
		CURRENT_VELOCITY.GrabMemory();
		if( CURRENT_VELOCITY.GetF(FLinkEdges) ) { CURRENT_VELOCITY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  SL::Sqrt(( pow((double)EW_VECTOR.Value(),(double)((float)2) )+pow((double)NS_VECTOR.Value(),(double)((float)2) ) ));
			CURRENT_VELOCITY.Update( value );
	  } break;
	}
	CURRENT_VELOCITY.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::EC_H2O_u76_exe() {
	float value;
	int array_index[64];


	switch( EC_H2O.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* EC_H2O_ptr = EC_H2O.DataStart();
		const float* EC_H2O_Eptr = EC_H2O.GridEnd();
		float* P_EC_COEFF_SED_ptr = P_EC_COEFF_SED.DataStart();
		float* TSS_CONC_ptr = TSS_CONC.DataStart();
		float* PHT_CONC_ptr = PHT_CONC.DataStart();
		float* P_EC_COEFF_WATER_ptr = P_EC_COEFF_WATER.DataStart();
		while( EC_H2O_ptr < EC_H2O_Eptr ) {
		 value =  ( ( (*(P_EC_COEFF_SED_ptr))*( (*(TSS_CONC_ptr))+(*(PHT_CONC_ptr)) ) )+(*(P_EC_COEFF_WATER_ptr)) );
			*EC_H2O_ptr = value;
			EC_H2O_ptr++;
			P_EC_COEFF_SED.UpdateDataPtr(P_EC_COEFF_SED_ptr);
			TSS_CONC.UpdateDataPtr(TSS_CONC_ptr);
			PHT_CONC.UpdateDataPtr(PHT_CONC_ptr);
			P_EC_COEFF_WATER.UpdateDataPtr(P_EC_COEFF_WATER_ptr);
		}
		EC_H2O.GrabMemory();
		if( EC_H2O.GetF(FLinkEdges) ) { EC_H2O.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = EC_H2O.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( P_EC_COEFF_SED.Value(p)*( TSS_CONC.Value(p)+PHT_CONC.Value(p) ) )+P_EC_COEFF_WATER.Value(p) );
			EC_H2O.Update( p, value );
		}
		EC_H2O.GrabMemory();
		if( EC_H2O.GetF(FLinkEdges) ) { EC_H2O.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( P_EC_COEFF_SED.Value()*( TSS_CONC.Value()+PHT_CONC.Value() ) )+P_EC_COEFF_WATER.Value() );
			EC_H2O.Update( value );
	  } break;
	}
	EC_H2O.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::EW_CURRENT_VECTOR_u77_exe() {
	float value;
	int array_index[64];


	switch( EW_CURRENT_VECTOR.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* EW_CURRENT_VECTOR_ptr = EW_CURRENT_VECTOR.DataStart();
		const float* EW_CURRENT_VECTOR_Eptr = EW_CURRENT_VECTOR.GridEnd();
		 value =  0;
		value = EW_CURRENT_VECTOR.ParameterValue(value);
		while( EW_CURRENT_VECTOR_ptr < EW_CURRENT_VECTOR_Eptr ) {
			*EW_CURRENT_VECTOR_ptr = value;
			EW_CURRENT_VECTOR_ptr++;
		}
		EW_CURRENT_VECTOR.GrabMemory();
		if( EW_CURRENT_VECTOR.GetF(FLinkEdges) ) { EW_CURRENT_VECTOR.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = EW_CURRENT_VECTOR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0;
			EW_CURRENT_VECTOR.Update( p, EW_CURRENT_VECTOR.ParameterValue(value,p) );
		}
		EW_CURRENT_VECTOR.GrabMemory();
		if( EW_CURRENT_VECTOR.GetF(FLinkEdges) ) { EW_CURRENT_VECTOR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0;
			EW_CURRENT_VECTOR.Update( EW_CURRENT_VECTOR.ParameterValue(value) );
	  } break;
	}
	EW_CURRENT_VECTOR.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::EW_VECTOR_u78_exe() {
	float value;
	int array_index[64];


	switch( EW_VECTOR.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* EW_VECTOR_ptr = EW_VECTOR.DataStart();
		const float* EW_VECTOR_Eptr = EW_VECTOR.GridEnd();
		float* EW_CURRENT_VECTOR_ptr = EW_CURRENT_VECTOR.DataStart();
		float* EW_WIND_VECTOR_ptr = EW_WIND_VECTOR.DataStart();
		while( EW_VECTOR_ptr < EW_VECTOR_Eptr ) {
		 value =  ( (*(EW_CURRENT_VECTOR_ptr))+( 0.035*(*(EW_WIND_VECTOR_ptr)) ) );
			*EW_VECTOR_ptr = value;
			EW_VECTOR_ptr++;
			EW_CURRENT_VECTOR.UpdateDataPtr(EW_CURRENT_VECTOR_ptr);
			EW_WIND_VECTOR.UpdateDataPtr(EW_WIND_VECTOR_ptr);
		}
		EW_VECTOR.GrabMemory();
		if( EW_VECTOR.GetF(FLinkEdges) ) { EW_VECTOR.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = EW_VECTOR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( EW_CURRENT_VECTOR.Value(p)+( 0.035*EW_WIND_VECTOR.Value(p) ) );
			EW_VECTOR.Update( p, value );
		}
		EW_VECTOR.GrabMemory();
		if( EW_VECTOR.GetF(FLinkEdges) ) { EW_VECTOR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( EW_CURRENT_VECTOR.Value()+( 0.035*EW_WIND_VECTOR.Value() ) );
			EW_VECTOR.Update( value );
	  } break;
	}
	EW_VECTOR.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::EW_WIND_VECTOR_u79_exe() {
	float value;
	int array_index[64];


	switch( EW_WIND_VECTOR.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* EW_WIND_VECTOR_ptr = EW_WIND_VECTOR.DataStart();
		const float* EW_WIND_VECTOR_Eptr = EW_WIND_VECTOR.GridEnd();
		float* P_WIND_SPEED_ptr = P_WIND_SPEED.DataStart();
		float* P_WIND_DIRECTION_ptr = P_WIND_DIRECTION.DataStart();
		while( EW_WIND_VECTOR_ptr < EW_WIND_VECTOR_Eptr ) {
		 value =  ( (*(P_WIND_SPEED_ptr))*SL::Sin(( ( ( (*(P_WIND_DIRECTION_ptr))*((float)2) )*3.141590 )/360 )) );
			*EW_WIND_VECTOR_ptr = value;
			EW_WIND_VECTOR_ptr++;
			P_WIND_SPEED.UpdateDataPtr(P_WIND_SPEED_ptr);
			P_WIND_DIRECTION.UpdateDataPtr(P_WIND_DIRECTION_ptr);
		}
		EW_WIND_VECTOR.GrabMemory();
		if( EW_WIND_VECTOR.GetF(FLinkEdges) ) { EW_WIND_VECTOR.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = EW_WIND_VECTOR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( P_WIND_SPEED.Value(p)*SL::Sin(( ( ( P_WIND_DIRECTION.Value(p)*((float)2) )*3.141590 )/360 )) );
			EW_WIND_VECTOR.Update( p, value );
		}
		EW_WIND_VECTOR.GrabMemory();
		if( EW_WIND_VECTOR.GetF(FLinkEdges) ) { EW_WIND_VECTOR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( P_WIND_SPEED.Value()*SL::Sin(( ( ( P_WIND_DIRECTION.Value()*((float)2) )*3.141590 )/360 )) );
			EW_WIND_VECTOR.Update( value );
	  } break;
	}
	EW_WIND_VECTOR.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::HOURS_u80_exe() {
	float value;
	int array_index[64];


	switch( HOURS.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* HOURS_ptr = HOURS.DataStart();
		const float* HOURS_Eptr = HOURS.GridEnd();
		float time = TIME.Value();
		while( HOURS_ptr < HOURS_Eptr ) {
		 value =  SL::Mod(time, ((float)24));
			*HOURS_ptr = value;
			HOURS_ptr++;
		}
		HOURS.GrabMemory();
		if( HOURS.GetF(FLinkEdges) ) { HOURS.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = HOURS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  SL::Mod(TIME.Value(), ((float)24));
			HOURS.Update( p, value );
		}
		HOURS.GrabMemory();
		if( HOURS.GetF(FLinkEdges) ) { HOURS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  SL::Mod(TIME.Value(), ((float)24));
			HOURS.Update( value );
	  } break;
	}
	HOURS.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::LIGHT_TO_PHYTOPLANKTON_u81_exe() {
	float value;
	int array_index[64];


	switch( LIGHT_TO_PHYTOPLANKTON.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* LIGHT_TO_PHYTOPLANKTON_ptr = LIGHT_TO_PHYTOPLANKTON.DataStart();
		const float* LIGHT_TO_PHYTOPLANKTON_Eptr = LIGHT_TO_PHYTOPLANKTON.GridEnd();
		float* SURFACE_LIGHT_ptr = SURFACE_LIGHT.DataStart();
		float* EC_H2O_ptr = EC_H2O.DataStart();
		float* WATER_LAYER_DEPTH_ptr = WATER_LAYER_DEPTH.DataStart();
		while( LIGHT_TO_PHYTOPLANKTON_ptr < LIGHT_TO_PHYTOPLANKTON_Eptr ) {
		 value =  ( (*(SURFACE_LIGHT_ptr))*SL::Exp(( -(*(EC_H2O_ptr))*(*(WATER_LAYER_DEPTH_ptr)) )) );
			*LIGHT_TO_PHYTOPLANKTON_ptr = value;
			LIGHT_TO_PHYTOPLANKTON_ptr++;
			SURFACE_LIGHT.UpdateDataPtr(SURFACE_LIGHT_ptr);
			EC_H2O.UpdateDataPtr(EC_H2O_ptr);
			WATER_LAYER_DEPTH.UpdateDataPtr(WATER_LAYER_DEPTH_ptr);
		}
		LIGHT_TO_PHYTOPLANKTON.GrabMemory();
		if( LIGHT_TO_PHYTOPLANKTON.GetF(FLinkEdges) ) { LIGHT_TO_PHYTOPLANKTON.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = LIGHT_TO_PHYTOPLANKTON.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( SURFACE_LIGHT.Value(p)*SL::Exp(( -EC_H2O.Value(p)*WATER_LAYER_DEPTH.Value(p) )) );
			LIGHT_TO_PHYTOPLANKTON.Update( p, value );
		}
		LIGHT_TO_PHYTOPLANKTON.GrabMemory();
		if( LIGHT_TO_PHYTOPLANKTON.GetF(FLinkEdges) ) { LIGHT_TO_PHYTOPLANKTON.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( SURFACE_LIGHT.Value()*SL::Exp(( -EC_H2O.Value()*WATER_LAYER_DEPTH.Value() )) );
			LIGHT_TO_PHYTOPLANKTON.Update( value );
	  } break;
	}
	LIGHT_TO_PHYTOPLANKTON.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::NS_CURRENT_VECTOR_u82_exe() {
	float value;
	int array_index[64];


	switch( NS_CURRENT_VECTOR.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* NS_CURRENT_VECTOR_ptr = NS_CURRENT_VECTOR.DataStart();
		const float* NS_CURRENT_VECTOR_Eptr = NS_CURRENT_VECTOR.GridEnd();
		 value =  0;
		value = NS_CURRENT_VECTOR.ParameterValue(value);
		while( NS_CURRENT_VECTOR_ptr < NS_CURRENT_VECTOR_Eptr ) {
			*NS_CURRENT_VECTOR_ptr = value;
			NS_CURRENT_VECTOR_ptr++;
		}
		NS_CURRENT_VECTOR.GrabMemory();
		if( NS_CURRENT_VECTOR.GetF(FLinkEdges) ) { NS_CURRENT_VECTOR.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = NS_CURRENT_VECTOR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0;
			NS_CURRENT_VECTOR.Update( p, NS_CURRENT_VECTOR.ParameterValue(value,p) );
		}
		NS_CURRENT_VECTOR.GrabMemory();
		if( NS_CURRENT_VECTOR.GetF(FLinkEdges) ) { NS_CURRENT_VECTOR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0;
			NS_CURRENT_VECTOR.Update( NS_CURRENT_VECTOR.ParameterValue(value) );
	  } break;
	}
	NS_CURRENT_VECTOR.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::NS_VECTOR_u83_exe() {
	float value;
	int array_index[64];


	switch( NS_VECTOR.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* NS_VECTOR_ptr = NS_VECTOR.DataStart();
		const float* NS_VECTOR_Eptr = NS_VECTOR.GridEnd();
		float* NS_CURRENT_VECTOR_ptr = NS_CURRENT_VECTOR.DataStart();
		float* NS_WIND_VECTOR_ptr = NS_WIND_VECTOR.DataStart();
		while( NS_VECTOR_ptr < NS_VECTOR_Eptr ) {
		 value =  ( (*(NS_CURRENT_VECTOR_ptr))+( 0.035*(*(NS_WIND_VECTOR_ptr)) ) );
			*NS_VECTOR_ptr = value;
			NS_VECTOR_ptr++;
			NS_CURRENT_VECTOR.UpdateDataPtr(NS_CURRENT_VECTOR_ptr);
			NS_WIND_VECTOR.UpdateDataPtr(NS_WIND_VECTOR_ptr);
		}
		NS_VECTOR.GrabMemory();
		if( NS_VECTOR.GetF(FLinkEdges) ) { NS_VECTOR.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = NS_VECTOR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( NS_CURRENT_VECTOR.Value(p)+( 0.035*NS_WIND_VECTOR.Value(p) ) );
			NS_VECTOR.Update( p, value );
		}
		NS_VECTOR.GrabMemory();
		if( NS_VECTOR.GetF(FLinkEdges) ) { NS_VECTOR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( NS_CURRENT_VECTOR.Value()+( 0.035*NS_WIND_VECTOR.Value() ) );
			NS_VECTOR.Update( value );
	  } break;
	}
	NS_VECTOR.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::NS_WIND_VECTOR_u84_exe() {
	float value;
	int array_index[64];


	switch( NS_WIND_VECTOR.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* NS_WIND_VECTOR_ptr = NS_WIND_VECTOR.DataStart();
		const float* NS_WIND_VECTOR_Eptr = NS_WIND_VECTOR.GridEnd();
		float* P_WIND_SPEED_ptr = P_WIND_SPEED.DataStart();
		float* P_WIND_DIRECTION_ptr = P_WIND_DIRECTION.DataStart();
		while( NS_WIND_VECTOR_ptr < NS_WIND_VECTOR_Eptr ) {
		 value =  ( (*(P_WIND_SPEED_ptr))*SL::Cos(( ( ( (*(P_WIND_DIRECTION_ptr))*((float)2) )*3.141590 )/360 )) );
			*NS_WIND_VECTOR_ptr = value;
			NS_WIND_VECTOR_ptr++;
			P_WIND_SPEED.UpdateDataPtr(P_WIND_SPEED_ptr);
			P_WIND_DIRECTION.UpdateDataPtr(P_WIND_DIRECTION_ptr);
		}
		NS_WIND_VECTOR.GrabMemory();
		if( NS_WIND_VECTOR.GetF(FLinkEdges) ) { NS_WIND_VECTOR.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = NS_WIND_VECTOR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( P_WIND_SPEED.Value(p)*SL::Cos(( ( ( P_WIND_DIRECTION.Value(p)*((float)2) )*3.141590 )/360 )) );
			NS_WIND_VECTOR.Update( p, value );
		}
		NS_WIND_VECTOR.GrabMemory();
		if( NS_WIND_VECTOR.GetF(FLinkEdges) ) { NS_WIND_VECTOR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( P_WIND_SPEED.Value()*SL::Cos(( ( ( P_WIND_DIRECTION.Value()*((float)2) )*3.141590 )/360 )) );
			NS_WIND_VECTOR.Update( value );
	  } break;
	}
	NS_WIND_VECTOR.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::OM3_SALT_CONC_u85_exe() {
	float value;
	int array_index[64];


	switch( OM3_SALT_CONC.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* OM3_SALT_CONC_ptr = OM3_SALT_CONC.DataStart();
		const float* OM3_SALT_CONC_Eptr = OM3_SALT_CONC.GridEnd();
		while( OM3_SALT_CONC_ptr < OM3_SALT_CONC_Eptr ) {
		 value =  ((float)1);
			*OM3_SALT_CONC_ptr = value;
			OM3_SALT_CONC_ptr++;
		}
		OM3_SALT_CONC.GrabMemory();
		if( OM3_SALT_CONC.GetF(FLinkEdges) ) { OM3_SALT_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = OM3_SALT_CONC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ((float)1);
			OM3_SALT_CONC.Update( p, value );
		}
		OM3_SALT_CONC.GrabMemory();
		if( OM3_SALT_CONC.GetF(FLinkEdges) ) { OM3_SALT_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ((float)1);
			OM3_SALT_CONC.Update( value );
	  } break;
	}
	OM3_SALT_CONC.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::OM3_SHEAR_STRESS_u86_exe() {
	float value;
	int array_index[64];


	switch( OM3_SHEAR_STRESS.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* OM3_SHEAR_STRESS_ptr = OM3_SHEAR_STRESS.DataStart();
		const float* OM3_SHEAR_STRESS_Eptr = OM3_SHEAR_STRESS.GridEnd();
		 value =  0;
		value = OM3_SHEAR_STRESS.ParameterValue(value);
		while( OM3_SHEAR_STRESS_ptr < OM3_SHEAR_STRESS_Eptr ) {
			*OM3_SHEAR_STRESS_ptr = value;
			OM3_SHEAR_STRESS_ptr++;
		}
		OM3_SHEAR_STRESS.GrabMemory();
		if( OM3_SHEAR_STRESS.GetF(FLinkEdges) ) { OM3_SHEAR_STRESS.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = OM3_SHEAR_STRESS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0;
			OM3_SHEAR_STRESS.Update( p, OM3_SHEAR_STRESS.ParameterValue(value,p) );
		}
		OM3_SHEAR_STRESS.GrabMemory();
		if( OM3_SHEAR_STRESS.GetF(FLinkEdges) ) { OM3_SHEAR_STRESS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0;
			OM3_SHEAR_STRESS.Update( OM3_SHEAR_STRESS.ParameterValue(value) );
	  } break;
	}
	OM3_SHEAR_STRESS.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::OM3_TEMP_u87_exe() {
	float value;
	int array_index[64];


	switch( OM3_TEMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* OM3_TEMP_ptr = OM3_TEMP.DataStart();
		const float* OM3_TEMP_Eptr = OM3_TEMP.GridEnd();
		 value =  10;
		value = OM3_TEMP.ParameterValue(value);
		while( OM3_TEMP_ptr < OM3_TEMP_Eptr ) {
			*OM3_TEMP_ptr = value;
			OM3_TEMP_ptr++;
		}
		OM3_TEMP.GrabMemory();
		if( OM3_TEMP.GetF(FLinkEdges) ) { OM3_TEMP.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = OM3_TEMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  10;
			OM3_TEMP.Update( p, OM3_TEMP.ParameterValue(value,p) );
		}
		OM3_TEMP.GrabMemory();
		if( OM3_TEMP.GetF(FLinkEdges) ) { OM3_TEMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  10;
			OM3_TEMP.Update( OM3_TEMP.ParameterValue(value) );
	  } break;
	}
	OM3_TEMP.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::OM3_UD_CURRENT_VECTOR_u88_exe() {
	float value;
	int array_index[64];


	switch( OM3_UD_CURRENT_VECTOR.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* OM3_UD_CURRENT_VECTOR_ptr = OM3_UD_CURRENT_VECTOR.DataStart();
		const float* OM3_UD_CURRENT_VECTOR_Eptr = OM3_UD_CURRENT_VECTOR.GridEnd();
		 value =  1;
		value = OM3_UD_CURRENT_VECTOR.ParameterValue(value);
		while( OM3_UD_CURRENT_VECTOR_ptr < OM3_UD_CURRENT_VECTOR_Eptr ) {
			*OM3_UD_CURRENT_VECTOR_ptr = value;
			OM3_UD_CURRENT_VECTOR_ptr++;
		}
		OM3_UD_CURRENT_VECTOR.GrabMemory();
		if( OM3_UD_CURRENT_VECTOR.GetF(FLinkEdges) ) { OM3_UD_CURRENT_VECTOR.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = OM3_UD_CURRENT_VECTOR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  1;
			OM3_UD_CURRENT_VECTOR.Update( p, OM3_UD_CURRENT_VECTOR.ParameterValue(value,p) );
		}
		OM3_UD_CURRENT_VECTOR.GrabMemory();
		if( OM3_UD_CURRENT_VECTOR.GetF(FLinkEdges) ) { OM3_UD_CURRENT_VECTOR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  1;
			OM3_UD_CURRENT_VECTOR.Update( OM3_UD_CURRENT_VECTOR.ParameterValue(value) );
	  } break;
	}
	OM3_UD_CURRENT_VECTOR.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::PHOTO_PERIOD_u89_exe() {
	float value;
	int array_index[64];


	switch( PHOTO_PERIOD.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* PHOTO_PERIOD_ptr = PHOTO_PERIOD.DataStart();
		const float* PHOTO_PERIOD_Eptr = PHOTO_PERIOD.GridEnd();
		float* H_ANGLE_ptr = H_ANGLE.DataStart();
		while( PHOTO_PERIOD_ptr < PHOTO_PERIOD_Eptr ) {
		 value =  ( 7.639437*(*(H_ANGLE_ptr)) );
			*PHOTO_PERIOD_ptr = value;
			PHOTO_PERIOD_ptr++;
			H_ANGLE.UpdateDataPtr(H_ANGLE_ptr);
		}
		PHOTO_PERIOD.GrabMemory();
		if( PHOTO_PERIOD.GetF(FLinkEdges) ) { PHOTO_PERIOD.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHOTO_PERIOD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( 7.639437*H_ANGLE.Value(p) );
			PHOTO_PERIOD.Update( p, value );
		}
		PHOTO_PERIOD.GrabMemory();
		if( PHOTO_PERIOD.GetF(FLinkEdges) ) { PHOTO_PERIOD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( 7.639437*H_ANGLE.Value() );
			PHOTO_PERIOD.Update( value );
	  } break;
	}
	PHOTO_PERIOD.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::RAND_u90_exe() {
	float value;
	int array_index[64];


	switch( RAND.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* RAND_ptr = RAND.DataStart();
		const float* RAND_Eptr = RAND.GridEnd();
		while( RAND_ptr < RAND_Eptr ) {
		 value =  SL::Rand(((float)0), ((float)98));
			*RAND_ptr = value;
			RAND_ptr++;
		}
		RAND.GrabMemory();
		if( RAND.GetF(FLinkEdges) ) { RAND.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = RAND.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  SL::Rand(((float)0), ((float)98));
			RAND.Update( p, value );
		}
		RAND.GrabMemory();
		if( RAND.GetF(FLinkEdges) ) { RAND.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  SL::Rand(((float)0), ((float)98));
			RAND.Update( value );
	  } break;
	}
	RAND.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::SDCLN_u91_exe() {
	float value;
	int array_index[64];


	switch( SDCLN.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* SDCLN_ptr = SDCLN.DataStart();
		const float* SDCLN_Eptr = SDCLN.GridEnd();
		float* DAYS_ptr = DAYS.DataStart();
		while( SDCLN_ptr < SDCLN_Eptr ) {
		 value =  ( ( ( ( 0.00678+( 0.39762*SL::Cos(( 0.0172142*( (*(DAYS_ptr))-((float)172) ) )) ) )+( 0.00613*SL::Sin(( 0.0172142*( (*(DAYS_ptr))-((float)172) ) )) ) )-( 0.00661*SL::Cos(( 0.034428*( (*(DAYS_ptr))-((float)172) ) )) ) )-( 0.00159*SL::Sin(( 0.034428*( (*(DAYS_ptr))-((float)172) ) )) ) );
			*SDCLN_ptr = value;
			SDCLN_ptr++;
			DAYS.UpdateDataPtr(DAYS_ptr);
		}
		SDCLN.GrabMemory();
		if( SDCLN.GetF(FLinkEdges) ) { SDCLN.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = SDCLN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( ( ( 0.00678+( 0.39762*SL::Cos(( 0.0172142*( DAYS.Value(p)-((float)172) ) )) ) )+( 0.00613*SL::Sin(( 0.0172142*( DAYS.Value(p)-((float)172) ) )) ) )-( 0.00661*SL::Cos(( 0.034428*( DAYS.Value(p)-((float)172) ) )) ) )-( 0.00159*SL::Sin(( 0.034428*( DAYS.Value(p)-((float)172) ) )) ) );
			SDCLN.Update( p, value );
		}
		SDCLN.GrabMemory();
		if( SDCLN.GetF(FLinkEdges) ) { SDCLN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( ( ( 0.00678+( 0.39762*SL::Cos(( 0.0172142*( DAYS.Value()-((float)172) ) )) ) )+( 0.00613*SL::Sin(( 0.0172142*( DAYS.Value()-((float)172) ) )) ) )-( 0.00661*SL::Cos(( 0.034428*( DAYS.Value()-((float)172) ) )) ) )-( 0.00159*SL::Sin(( 0.034428*( DAYS.Value()-((float)172) ) )) ) );
			SDCLN.Update( value );
	  } break;
	}
	SDCLN.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::SF_WATER_u92_exe() {
	float value;
	int array_index[64];


	switch( SF_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* SF_WATER_ptr = SF_WATER.DataStart();
		const float* SF_WATER_Eptr = SF_WATER.GridEnd();
		float* WATER_LAYER_HEIGHT_ptr = WATER_LAYER_HEIGHT.DataStart();
		float* P_CELL_AREA_ptr = P_CELL_AREA.DataStart();
		while( SF_WATER_ptr < SF_WATER_Eptr ) {
		 value =  ( (*(WATER_LAYER_HEIGHT_ptr))*(*(P_CELL_AREA_ptr)) );
			*SF_WATER_ptr = value;
			SF_WATER_ptr++;
			WATER_LAYER_HEIGHT.UpdateDataPtr(WATER_LAYER_HEIGHT_ptr);
			P_CELL_AREA.UpdateDataPtr(P_CELL_AREA_ptr);
		}
		SF_WATER.GrabMemory();
		if( SF_WATER.GetF(FLinkEdges) ) { SF_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = SF_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( WATER_LAYER_HEIGHT.Value(p)*P_CELL_AREA.Value(p) );
			SF_WATER.Update( p, value );
		}
		SF_WATER.GrabMemory();
		if( SF_WATER.GetF(FLinkEdges) ) { SF_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( WATER_LAYER_HEIGHT.Value()*P_CELL_AREA.Value() );
			SF_WATER.Update( value );
	  } break;
	}
	SF_WATER.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::SURFACE_LIGHT_u93_exe() {
	float value;
	int array_index[64];


	switch( SURFACE_LIGHT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* SURFACE_LIGHT_ptr = SURFACE_LIGHT.DataStart();
		const float* SURFACE_LIGHT_Eptr = SURFACE_LIGHT.GridEnd();
		float* SKEW_WEATHER_ptr = SKEW_WEATHER.DataStart();
		float* DAYS_ptr = DAYS.DataStart();
		while( SURFACE_LIGHT_ptr < SURFACE_LIGHT_Eptr ) {
		 value =  ( ( ((float)1)-(*(SKEW_WEATHER_ptr)) )*( 37.665+( 23.275*SL::Sin(( ( 0.016252*(*(DAYS_ptr)) )+5.0881 )) ) ) );
			*SURFACE_LIGHT_ptr = value;
			SURFACE_LIGHT_ptr++;
			SKEW_WEATHER.UpdateDataPtr(SKEW_WEATHER_ptr);
			DAYS.UpdateDataPtr(DAYS_ptr);
		}
		SURFACE_LIGHT.GrabMemory();
		if( SURFACE_LIGHT.GetF(FLinkEdges) ) { SURFACE_LIGHT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = SURFACE_LIGHT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( ((float)1)-SKEW_WEATHER.Value(p) )*( 37.665+( 23.275*SL::Sin(( ( 0.016252*DAYS.Value(p) )+5.0881 )) ) ) );
			SURFACE_LIGHT.Update( p, value );
		}
		SURFACE_LIGHT.GrabMemory();
		if( SURFACE_LIGHT.GetF(FLinkEdges) ) { SURFACE_LIGHT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( ((float)1)-SKEW_WEATHER.Value() )*( 37.665+( 23.275*SL::Sin(( ( 0.016252*DAYS.Value() )+5.0881 )) ) ) );
			SURFACE_LIGHT.Update( value );
	  } break;
	}
	SURFACE_LIGHT.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::SURFACE_MAP_u94_exe() {
	float value;
	int array_index[64];


	switch( SURFACE_MAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* SURFACE_MAP_ptr = SURFACE_MAP.DataStart();
		const float* SURFACE_MAP_Eptr = SURFACE_MAP.GridEnd();
		 value =  1;
		value = SURFACE_MAP.ParameterValue(value);
		while( SURFACE_MAP_ptr < SURFACE_MAP_Eptr ) {
			*SURFACE_MAP_ptr = value;
			SURFACE_MAP_ptr++;
		}
		SURFACE_MAP.GrabMemory();
		if( SURFACE_MAP.GetF(FLinkEdges) ) { SURFACE_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = SURFACE_MAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  1;
			SURFACE_MAP.Update( p, SURFACE_MAP.ParameterValue(value,p) );
		}
		SURFACE_MAP.GrabMemory();
		if( SURFACE_MAP.GetF(FLinkEdges) ) { SURFACE_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  1;
			SURFACE_MAP.Update( SURFACE_MAP.ParameterValue(value) );
	  } break;
	}
	SURFACE_MAP.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::WATER_DEPTH_u95_exe() {
	float value;
	int array_index[64];


	switch( WATER_DEPTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* WATER_DEPTH_ptr = WATER_DEPTH.DataStart();
		const float* WATER_DEPTH_Eptr = WATER_DEPTH.GridEnd();
		while( WATER_DEPTH_ptr < WATER_DEPTH_Eptr ) {
		 value =  ((float)7);
			*WATER_DEPTH_ptr = value;
			WATER_DEPTH_ptr++;
		}
		WATER_DEPTH.GrabMemory();
		if( WATER_DEPTH.GetF(FLinkEdges) ) { WATER_DEPTH.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = WATER_DEPTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ((float)7);
			WATER_DEPTH.Update( p, value );
		}
		WATER_DEPTH.GrabMemory();
		if( WATER_DEPTH.GetF(FLinkEdges) ) { WATER_DEPTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ((float)7);
			WATER_DEPTH.Update( value );
	  } break;
	}
	WATER_DEPTH.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::WATER_LAYER_DEPTH_u96_exe() {
	float value;
	int array_index[64];


	switch( WATER_LAYER_DEPTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* WATER_LAYER_DEPTH_ptr = WATER_LAYER_DEPTH.DataStart();
		const float* WATER_LAYER_DEPTH_Eptr = WATER_LAYER_DEPTH.GridEnd();
		while( WATER_LAYER_DEPTH_ptr < WATER_LAYER_DEPTH_Eptr ) {
		 value =  ((float)1);
			*WATER_LAYER_DEPTH_ptr = value;
			WATER_LAYER_DEPTH_ptr++;
		}
		WATER_LAYER_DEPTH.GrabMemory();
		if( WATER_LAYER_DEPTH.GetF(FLinkEdges) ) { WATER_LAYER_DEPTH.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = WATER_LAYER_DEPTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ((float)1);
			WATER_LAYER_DEPTH.Update( p, value );
		}
		WATER_LAYER_DEPTH.GrabMemory();
		if( WATER_LAYER_DEPTH.GetF(FLinkEdges) ) { WATER_LAYER_DEPTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ((float)1);
			WATER_LAYER_DEPTH.Update( value );
	  } break;
	}
	WATER_LAYER_DEPTH.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::WATER_LAYER_HEIGHT_u97_exe() {
	float value;
	int array_index[64];


	switch( WATER_LAYER_HEIGHT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* WATER_LAYER_HEIGHT_ptr = WATER_LAYER_HEIGHT.DataStart();
		const float* WATER_LAYER_HEIGHT_Eptr = WATER_LAYER_HEIGHT.GridEnd();
		while( WATER_LAYER_HEIGHT_ptr < WATER_LAYER_HEIGHT_Eptr ) {
		 value =  ((float)1);
			*WATER_LAYER_HEIGHT_ptr = value;
			WATER_LAYER_HEIGHT_ptr++;
		}
		WATER_LAYER_HEIGHT.GrabMemory();
		if( WATER_LAYER_HEIGHT.GetF(FLinkEdges) ) { WATER_LAYER_HEIGHT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = WATER_LAYER_HEIGHT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ((float)1);
			WATER_LAYER_HEIGHT.Update( p, value );
		}
		WATER_LAYER_HEIGHT.GrabMemory();
		if( WATER_LAYER_HEIGHT.GetF(FLinkEdges) ) { WATER_LAYER_HEIGHT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ((float)1);
			WATER_LAYER_HEIGHT.Update( value );
	  } break;
	}
	WATER_LAYER_HEIGHT.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::P_CELL_AREA_u100_exe() {
	float value;
	int array_index[64];


	switch( P_CELL_AREA.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_CELL_AREA_ptr = P_CELL_AREA.DataStart();
		const float* P_CELL_AREA_Eptr = P_CELL_AREA.GridEnd();
		 value =  9216;
		value = P_CELL_AREA.ParameterValue(value);
		while( P_CELL_AREA_ptr < P_CELL_AREA_Eptr ) {
			*P_CELL_AREA_ptr = value;
			P_CELL_AREA_ptr++;
		}
		P_CELL_AREA.GrabMemory();
		if( P_CELL_AREA.GetF(FLinkEdges) ) { P_CELL_AREA.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_CELL_AREA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  9216;
			P_CELL_AREA.Update( p, P_CELL_AREA.ParameterValue(value,p) );
		}
		P_CELL_AREA.GrabMemory();
		if( P_CELL_AREA.GetF(FLinkEdges) ) { P_CELL_AREA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  9216;
			P_CELL_AREA.Update( P_CELL_AREA.ParameterValue(value) );
	  } break;
	}
	P_CELL_AREA.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::P_CHL_A_MAP_u101_exe() {
	float value;
	int array_index[64];


	switch( P_CHL_A_MAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_CHL_A_MAP_ptr = P_CHL_A_MAP.DataStart();
		const float* P_CHL_A_MAP_Eptr = P_CHL_A_MAP.GridEnd();
		 value =  0;
		value = P_CHL_A_MAP.ParameterValue(value);
		while( P_CHL_A_MAP_ptr < P_CHL_A_MAP_Eptr ) {
			*P_CHL_A_MAP_ptr = value;
			P_CHL_A_MAP_ptr++;
		}
		P_CHL_A_MAP.GrabMemory();
		if( P_CHL_A_MAP.GetF(FLinkEdges) ) { P_CHL_A_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_CHL_A_MAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0;
			P_CHL_A_MAP.Update( p, P_CHL_A_MAP.ParameterValue(value,p) );
		}
		P_CHL_A_MAP.GrabMemory();
		if( P_CHL_A_MAP.GetF(FLinkEdges) ) { P_CHL_A_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0;
			P_CHL_A_MAP.Update( P_CHL_A_MAP.ParameterValue(value) );
	  } break;
	}
	P_CHL_A_MAP.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::P_EC_COEFF_SED_u102_exe() {
	float value;
	int array_index[64];


	switch( P_EC_COEFF_SED.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_EC_COEFF_SED_ptr = P_EC_COEFF_SED.DataStart();
		const float* P_EC_COEFF_SED_Eptr = P_EC_COEFF_SED.GridEnd();
		 value =  0.000700;
		value = P_EC_COEFF_SED.ParameterValue(value);
		while( P_EC_COEFF_SED_ptr < P_EC_COEFF_SED_Eptr ) {
			*P_EC_COEFF_SED_ptr = value;
			P_EC_COEFF_SED_ptr++;
		}
		P_EC_COEFF_SED.GrabMemory();
		if( P_EC_COEFF_SED.GetF(FLinkEdges) ) { P_EC_COEFF_SED.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_EC_COEFF_SED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.000700;
			P_EC_COEFF_SED.Update( p, P_EC_COEFF_SED.ParameterValue(value,p) );
		}
		P_EC_COEFF_SED.GrabMemory();
		if( P_EC_COEFF_SED.GetF(FLinkEdges) ) { P_EC_COEFF_SED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.000700;
			P_EC_COEFF_SED.Update( P_EC_COEFF_SED.ParameterValue(value) );
	  } break;
	}
	P_EC_COEFF_SED.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::P_EC_COEFF_WATER_u103_exe() {
	float value;
	int array_index[64];


	switch( P_EC_COEFF_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_EC_COEFF_WATER_ptr = P_EC_COEFF_WATER.DataStart();
		const float* P_EC_COEFF_WATER_Eptr = P_EC_COEFF_WATER.GridEnd();
		 value =  0.000070;
		value = P_EC_COEFF_WATER.ParameterValue(value);
		while( P_EC_COEFF_WATER_ptr < P_EC_COEFF_WATER_Eptr ) {
			*P_EC_COEFF_WATER_ptr = value;
			P_EC_COEFF_WATER_ptr++;
		}
		P_EC_COEFF_WATER.GrabMemory();
		if( P_EC_COEFF_WATER.GetF(FLinkEdges) ) { P_EC_COEFF_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_EC_COEFF_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.000070;
			P_EC_COEFF_WATER.Update( p, P_EC_COEFF_WATER.ParameterValue(value,p) );
		}
		P_EC_COEFF_WATER.GrabMemory();
		if( P_EC_COEFF_WATER.GetF(FLinkEdges) ) { P_EC_COEFF_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.000070;
			P_EC_COEFF_WATER.Update( P_EC_COEFF_WATER.ParameterValue(value) );
	  } break;
	}
	P_EC_COEFF_WATER.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::P_IC_SED_ELEV_u104_exe() {
	float value;
	int array_index[64];


	switch( P_IC_SED_ELEV.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_IC_SED_ELEV_ptr = P_IC_SED_ELEV.DataStart();
		const float* P_IC_SED_ELEV_Eptr = P_IC_SED_ELEV.GridEnd();
		 value =  3;
		value = P_IC_SED_ELEV.ParameterValue(value);
		while( P_IC_SED_ELEV_ptr < P_IC_SED_ELEV_Eptr ) {
			*P_IC_SED_ELEV_ptr = value;
			P_IC_SED_ELEV_ptr++;
		}
		P_IC_SED_ELEV.GrabMemory();
		if( P_IC_SED_ELEV.GetF(FLinkEdges) ) { P_IC_SED_ELEV.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_IC_SED_ELEV.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  3;
			P_IC_SED_ELEV.Update( p, P_IC_SED_ELEV.ParameterValue(value,p) );
		}
		P_IC_SED_ELEV.GrabMemory();
		if( P_IC_SED_ELEV.GetF(FLinkEdges) ) { P_IC_SED_ELEV.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  3;
			P_IC_SED_ELEV.Update( P_IC_SED_ELEV.ParameterValue(value) );
	  } break;
	}
	P_IC_SED_ELEV.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::P_LATITUDE_u105_exe() {
	float value;
	int array_index[64];


	switch( P_LATITUDE.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_LATITUDE_ptr = P_LATITUDE.DataStart();
		const float* P_LATITUDE_Eptr = P_LATITUDE.GridEnd();
		 value =  38.500000;
		value = P_LATITUDE.ParameterValue(value);
		while( P_LATITUDE_ptr < P_LATITUDE_Eptr ) {
			*P_LATITUDE_ptr = value;
			P_LATITUDE_ptr++;
		}
		P_LATITUDE.GrabMemory();
		if( P_LATITUDE.GetF(FLinkEdges) ) { P_LATITUDE.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_LATITUDE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  38.500000;
			P_LATITUDE.Update( p, P_LATITUDE.ParameterValue(value,p) );
		}
		P_LATITUDE.GrabMemory();
		if( P_LATITUDE.GetF(FLinkEdges) ) { P_LATITUDE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  38.500000;
			P_LATITUDE.Update( P_LATITUDE.ParameterValue(value) );
	  } break;
	}
	P_LATITUDE.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::P_ON_MAP_u106_exe() {
	float value;
	int array_index[64];


	switch( P_ON_MAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_ON_MAP_ptr = P_ON_MAP.DataStart();
		const float* P_ON_MAP_Eptr = P_ON_MAP.GridEnd();
		 value =  1;
		value = P_ON_MAP.ParameterValue(value);
		while( P_ON_MAP_ptr < P_ON_MAP_Eptr ) {
			*P_ON_MAP_ptr = value;
			P_ON_MAP_ptr++;
		}
		P_ON_MAP.GrabMemory();
		if( P_ON_MAP.GetF(FLinkEdges) ) { P_ON_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_ON_MAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  1;
			P_ON_MAP.Update( p, P_ON_MAP.ParameterValue(value,p) );
		}
		P_ON_MAP.GrabMemory();
		if( P_ON_MAP.GetF(FLinkEdges) ) { P_ON_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  1;
			P_ON_MAP.Update( P_ON_MAP.ParameterValue(value) );
	  } break;
	}
	P_ON_MAP.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::DECLINE_u107_exe() {
	float value;
	int array_index[64];


	switch( DECLINE.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* DECLINE_ptr = DECLINE.DataStart();
		const float* DECLINE_Eptr = DECLINE.GridEnd();
		float* SDCLN_ptr = SDCLN.DataStart();
		while( DECLINE_ptr < DECLINE_Eptr ) {
		 value =  Graph1((*(SDCLN_ptr)));
			*DECLINE_ptr = value;
			DECLINE_ptr++;
			SDCLN.UpdateDataPtr(SDCLN_ptr);
		}
		DECLINE.GrabMemory();
		if( DECLINE.GetF(FLinkEdges) ) { DECLINE.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = DECLINE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  Graph1(SDCLN.Value(p));
			DECLINE.Update( p, value );
		}
		DECLINE.GrabMemory();
		if( DECLINE.GetF(FLinkEdges) ) { DECLINE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  Graph1(SDCLN.Value());
			DECLINE.Update( value );
	  } break;
	}
	DECLINE.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::H_ANGLE_u108_exe() {
	float value;
	int array_index[64];


	switch( H_ANGLE.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* H_ANGLE_ptr = H_ANGLE.DataStart();
		const float* H_ANGLE_Eptr = H_ANGLE.GridEnd();
		float* P_LATITUDE_ptr = P_LATITUDE.DataStart();
		float* DECLINE_ptr = DECLINE.DataStart();
		while( H_ANGLE_ptr < H_ANGLE_Eptr ) {
		 value =  Graph2(( -SL::Tan(( (*(P_LATITUDE_ptr))*0.0174533 ))*SL::Tan((*(DECLINE_ptr))) ));
			*H_ANGLE_ptr = value;
			H_ANGLE_ptr++;
			P_LATITUDE.UpdateDataPtr(P_LATITUDE_ptr);
			DECLINE.UpdateDataPtr(DECLINE_ptr);
		}
		H_ANGLE.GrabMemory();
		if( H_ANGLE.GetF(FLinkEdges) ) { H_ANGLE.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = H_ANGLE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  Graph2(( -SL::Tan(( P_LATITUDE.Value(p)*0.0174533 ))*SL::Tan(DECLINE.Value(p)) ));
			H_ANGLE.Update( p, value );
		}
		H_ANGLE.GrabMemory();
		if( H_ANGLE.GetF(FLinkEdges) ) { H_ANGLE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  Graph2(( -SL::Tan(( P_LATITUDE.Value()*0.0174533 ))*SL::Tan(DECLINE.Value()) ));
			H_ANGLE.Update( value );
	  } break;
	}
	H_ANGLE.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::SKEW_WEATHER_u109_exe() {
	float value;
	int array_index[64];


	switch( SKEW_WEATHER.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* SKEW_WEATHER_ptr = SKEW_WEATHER.DataStart();
		const float* SKEW_WEATHER_Eptr = SKEW_WEATHER.GridEnd();
		float* RAND_ptr = RAND.DataStart();
		while( SKEW_WEATHER_ptr < SKEW_WEATHER_Eptr ) {
		 value =  Graph3((*(RAND_ptr)));
			*SKEW_WEATHER_ptr = value;
			SKEW_WEATHER_ptr++;
			RAND.UpdateDataPtr(RAND_ptr);
		}
		SKEW_WEATHER.GrabMemory();
		if( SKEW_WEATHER.GetF(FLinkEdges) ) { SKEW_WEATHER.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = SKEW_WEATHER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  Graph3(RAND.Value(p));
			SKEW_WEATHER.Update( p, value );
		}
		SKEW_WEATHER.GrabMemory();
		if( SKEW_WEATHER.GetF(FLinkEdges) ) { SKEW_WEATHER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  Graph3(RAND.Value());
			SKEW_WEATHER.Update( value );
	  } break;
	}
	SKEW_WEATHER.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::P_AIR_TEMP_u110_exe() {
	float value;
	int array_index[64];


	switch( P_AIR_TEMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_AIR_TEMP_ptr = P_AIR_TEMP.DataStart();
		const float* P_AIR_TEMP_Eptr = P_AIR_TEMP.GridEnd();
		float* DAYS_ptr = DAYS.DataStart();
		while( P_AIR_TEMP_ptr < P_AIR_TEMP_Eptr ) {
		 value =  Graph4((*(DAYS_ptr)));
			*P_AIR_TEMP_ptr = value;
			P_AIR_TEMP_ptr++;
			DAYS.UpdateDataPtr(DAYS_ptr);
		}
		P_AIR_TEMP.GrabMemory();
		if( P_AIR_TEMP.GetF(FLinkEdges) ) { P_AIR_TEMP.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_AIR_TEMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  Graph4(DAYS.Value(p));
			P_AIR_TEMP.Update( p, value );
		}
		P_AIR_TEMP.GrabMemory();
		if( P_AIR_TEMP.GetF(FLinkEdges) ) { P_AIR_TEMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  Graph4(DAYS.Value());
			P_AIR_TEMP.Update( value );
	  } break;
	}
	P_AIR_TEMP.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::P_LEAF_GROW_SEASON_u111_exe() {
	float value;
	int array_index[64];


	switch( P_LEAF_GROW_SEASON.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_LEAF_GROW_SEASON_ptr = P_LEAF_GROW_SEASON.DataStart();
		const float* P_LEAF_GROW_SEASON_Eptr = P_LEAF_GROW_SEASON.GridEnd();
		float* DAYS_ptr = DAYS.DataStart();
		while( P_LEAF_GROW_SEASON_ptr < P_LEAF_GROW_SEASON_Eptr ) {
		 value =  Graph5((*(DAYS_ptr)));
			*P_LEAF_GROW_SEASON_ptr = value;
			P_LEAF_GROW_SEASON_ptr++;
			DAYS.UpdateDataPtr(DAYS_ptr);
		}
		P_LEAF_GROW_SEASON.GrabMemory();
		if( P_LEAF_GROW_SEASON.GetF(FLinkEdges) ) { P_LEAF_GROW_SEASON.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_LEAF_GROW_SEASON.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  Graph5(DAYS.Value(p));
			P_LEAF_GROW_SEASON.Update( p, value );
		}
		P_LEAF_GROW_SEASON.GrabMemory();
		if( P_LEAF_GROW_SEASON.GetF(FLinkEdges) ) { P_LEAF_GROW_SEASON.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  Graph5(DAYS.Value());
			P_LEAF_GROW_SEASON.Update( value );
	  } break;
	}
	P_LEAF_GROW_SEASON.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::P_PRECIPITATION_u112_exe() {
	float value;
	int array_index[64];


	switch( P_PRECIPITATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_PRECIPITATION_ptr = P_PRECIPITATION.DataStart();
		const float* P_PRECIPITATION_Eptr = P_PRECIPITATION.GridEnd();
		float* DAYS_ptr = DAYS.DataStart();
		while( P_PRECIPITATION_ptr < P_PRECIPITATION_Eptr ) {
		 value =  Graph6((*(DAYS_ptr)));
			*P_PRECIPITATION_ptr = value;
			P_PRECIPITATION_ptr++;
			DAYS.UpdateDataPtr(DAYS_ptr);
		}
		P_PRECIPITATION.GrabMemory();
		if( P_PRECIPITATION.GetF(FLinkEdges) ) { P_PRECIPITATION.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_PRECIPITATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  Graph6(DAYS.Value(p));
			P_PRECIPITATION.Update( p, value );
		}
		P_PRECIPITATION.GrabMemory();
		if( P_PRECIPITATION.GetF(FLinkEdges) ) { P_PRECIPITATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  Graph6(DAYS.Value());
			P_PRECIPITATION.Update( value );
	  } break;
	}
	P_PRECIPITATION.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::P_WIND_DIRECTION_u113_exe() {
	float value;
	int array_index[64];


	switch( P_WIND_DIRECTION.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_WIND_DIRECTION_ptr = P_WIND_DIRECTION.DataStart();
		const float* P_WIND_DIRECTION_Eptr = P_WIND_DIRECTION.GridEnd();
		float* DAYS_ptr = DAYS.DataStart();
		while( P_WIND_DIRECTION_ptr < P_WIND_DIRECTION_Eptr ) {
		 value =  Graph7((*(DAYS_ptr)));
			*P_WIND_DIRECTION_ptr = value;
			P_WIND_DIRECTION_ptr++;
			DAYS.UpdateDataPtr(DAYS_ptr);
		}
		P_WIND_DIRECTION.GrabMemory();
		if( P_WIND_DIRECTION.GetF(FLinkEdges) ) { P_WIND_DIRECTION.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_WIND_DIRECTION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  Graph7(DAYS.Value(p));
			P_WIND_DIRECTION.Update( p, value );
		}
		P_WIND_DIRECTION.GrabMemory();
		if( P_WIND_DIRECTION.GetF(FLinkEdges) ) { P_WIND_DIRECTION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  Graph7(DAYS.Value());
			P_WIND_DIRECTION.Update( value );
	  } break;
	}
	P_WIND_DIRECTION.UpdateGOFComputation();
	return 0;
}

int GLOBAL_module::P_WIND_SPEED_u114_exe() {
	float value;
	int array_index[64];


	switch( P_WIND_SPEED.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_WIND_SPEED_ptr = P_WIND_SPEED.DataStart();
		const float* P_WIND_SPEED_Eptr = P_WIND_SPEED.GridEnd();
		float* DAYS_ptr = DAYS.DataStart();
		while( P_WIND_SPEED_ptr < P_WIND_SPEED_Eptr ) {
		 value =  Graph8((*(DAYS_ptr)));
			*P_WIND_SPEED_ptr = value;
			P_WIND_SPEED_ptr++;
			DAYS.UpdateDataPtr(DAYS_ptr);
		}
		P_WIND_SPEED.GrabMemory();
		if( P_WIND_SPEED.GetF(FLinkEdges) ) { P_WIND_SPEED.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_WIND_SPEED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  Graph8(DAYS.Value(p));
			P_WIND_SPEED.Update( p, value );
		}
		P_WIND_SPEED.GrabMemory();
		if( P_WIND_SPEED.GetF(FLinkEdges) ) { P_WIND_SPEED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  Graph8(DAYS.Value());
			P_WIND_SPEED.Update( value );
	  } break;
	}
	P_WIND_SPEED.UpdateGOFComputation();
	return 0;
}

GLOBAL_module* GLOBAL_module::fInstance = NULL;
GLOBAL_module* GLOBAL_module::kNullModel = (GLOBAL_module*)0x1;
int GLOBAL_module::InitVars() {
	TIME.SSInit(this);
	P_CELL_AREA.SSInit(this);
	BOTTOM_MAP.SSInit(this);
	SURFACE_MAP.SSInit(this);
	OM3_TEMP.SSInit(this);
	SF_WATER.SSInit(this);
	TSS_CONC.SSInit(this);
	PHT_CONC.SSInit(this);
	LIGHT_TO_PHYTOPLANKTON.SSInit(this);
	P_CHL_A_MAP.SSInit(this);
	WATER_LAYER_DEPTH.SSInit(this);
	P_ON_MAP.SSInit(this);
	WATER_DEPTH.SSInit(this);
	OM3_SHEAR_STRESS.SSInit(this);
	DAYS.SSInit(this);
	COUNT_HOURS.SSInit(this);
	COUNT_HOURS.SetDestination(&DAYS);
	CURRENT_DIRECTION.SSInit(this);
	CURRENT_VELOCITY.SSInit(this);
	EC_H2O.SSInit(this);
	EW_CURRENT_VECTOR.SSInit(this);
	EW_VECTOR.SSInit(this);
	EW_WIND_VECTOR.SSInit(this);
	HOURS.SSInit(this);
	NS_CURRENT_VECTOR.SSInit(this);
	NS_VECTOR.SSInit(this);
	NS_WIND_VECTOR.SSInit(this);
	OM3_SALT_CONC.SSInit(this);
	OM3_SALT_CONC.SetLinkEdges();
	OM3_UD_CURRENT_VECTOR.SSInit(this);
	PHOTO_PERIOD.SSInit(this);
	RAND.SSInit(this);
	SDCLN.SSInit(this);
	SURFACE_LIGHT.SSInit(this);
	WATER_LAYER_HEIGHT.SSInit(this);
	X.SSInit(this);
	Y.SSInit(this);
	P_EC_COEFF_SED.SSInit(this);
	P_EC_COEFF_WATER.SSInit(this);
	P_IC_SED_ELEV.SSInit(this);
	P_LATITUDE.SSInit(this);
	DECLINE.SSInit(this);
	H_ANGLE.SSInit(this);
	SKEW_WEATHER.SSInit(this);
	P_AIR_TEMP.SSInit(this);
	P_LEAF_GROW_SEASON.SSInit(this);
	P_PRECIPITATION.SSInit(this);
	P_WIND_DIRECTION.SSInit(this);
	P_WIND_SPEED.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int GLOBAL_module::SetupEvents() {
	TExecuteCommand* u100 = (TExecuteCommand*) P_CELL_AREA.GetCommand("u100",TCommand::kUpdate,TCommand::kCode);
	u100->SetExecutable(&P_CELL_AREA_u100_exe_g);
	u100->Code() = "u100 <- 9216";
	u100->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u73 = (TExecuteCommand*) BOTTOM_MAP.GetCommand("u73",TCommand::kUpdate,TCommand::kCode);
	u73->SetExecutable(&BOTTOM_MAP_u73_exe_g);
	u73->Code() = "u73 <- 1";
	u73->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u94 = (TExecuteCommand*) SURFACE_MAP.GetCommand("u94",TCommand::kUpdate,TCommand::kCode);
	u94->SetExecutable(&SURFACE_MAP_u94_exe_g);
	u94->Code() = "u94 <- 1";
	u94->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u87 = (TExecuteCommand*) OM3_TEMP.GetCommand("u87",TCommand::kUpdate,TCommand::kCode);
	u87->SetExecutable(&OM3_TEMP_u87_exe_g);
	u87->Code() = "u87 <- 10";
	u87->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u92 = (TExecuteCommand*) SF_WATER.GetCommand("u92",TCommand::kUpdate,TCommand::kCode);
	u92->SetExecutable(&SF_WATER_u92_exe_g);
	u92->Code() = "u92 <- ( WATER_LAYER_HEIGHT*P_CELL_AREA )";
	u92->AddDependency(WATER_LAYER_HEIGHT);
	u92->AddDependency(P_CELL_AREA);
	u92->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* TSS_CONC_import0 = (TImportCommand*) TSS_CONC.GetCommand("TSS_CONC_import0",TCommand::kUndefined,TCommand::kImport);
	TSS_CONC_import0->Code() = "Import TSS_CONC";
	TSS_CONC_import0->AddDependency(TSS_CONC);
	TSS_CONC_import0->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PHT_CONC_import1 = (TImportCommand*) PHT_CONC.GetCommand("PHT_CONC_import1",TCommand::kUndefined,TCommand::kImport);
	PHT_CONC_import1->Code() = "Import PHT_CONC";
	PHT_CONC_import1->AddDependency(PHT_CONC);
	PHT_CONC_import1->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u81 = (TExecuteCommand*) LIGHT_TO_PHYTOPLANKTON.GetCommand("u81",TCommand::kUpdate,TCommand::kCode);
	u81->SetExecutable(&LIGHT_TO_PHYTOPLANKTON_u81_exe_g);
	u81->Code() = "u81 <- ( SURFACE_LIGHT*SL::Exp(( -EC_H2O*WATER_LAYER_DEPTH )) )";
	u81->AddDependency(SURFACE_LIGHT);
	u81->AddDependency(EC_H2O);
	u81->AddDependency(WATER_LAYER_DEPTH);
	u81->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u101 = (TExecuteCommand*) P_CHL_A_MAP.GetCommand("u101",TCommand::kUpdate,TCommand::kCode);
	u101->SetExecutable(&P_CHL_A_MAP_u101_exe_g);
	u101->Code() = "u101 <- 0";
	u101->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u96 = (TExecuteCommand*) WATER_LAYER_DEPTH.GetCommand("u96",TCommand::kUpdate,TCommand::kCode);
	u96->SetExecutable(&WATER_LAYER_DEPTH_u96_exe_g);
	u96->Code() = "u96 <- ((float)1)";
	u96->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u106 = (TExecuteCommand*) P_ON_MAP.GetCommand("u106",TCommand::kUpdate,TCommand::kCode);
	u106->SetExecutable(&P_ON_MAP_u106_exe_g);
	u106->Code() = "u106 <- 1";
	u106->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u95 = (TExecuteCommand*) WATER_DEPTH.GetCommand("u95",TCommand::kUpdate,TCommand::kCode);
	u95->SetExecutable(&WATER_DEPTH_u95_exe_g);
	u95->Code() = "u95 <- ((float)7)";
	u95->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u86 = (TExecuteCommand*) OM3_SHEAR_STRESS.GetCommand("u86",TCommand::kUpdate,TCommand::kCode);
	u86->SetExecutable(&OM3_SHEAR_STRESS_u86_exe_g);
	u86->Code() = "u86 <- 0";
	u86->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* I70 = (TExecuteCommand*) DAYS.GetCommand("I70",TCommand::kIntegrate,TCommand::kCode);
	I70->SetExecutable(&DAYS_I70_exe_g);
	I70->Code() = "I70 <- COUNT_HOURS";
	I70->AddDependency(COUNT_HOURS);
	I70->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i71 = (TExecuteCommand*) DAYS.GetCommand("i71",TCommand::kInit,TCommand::kCode);
	i71->SetExecutable(&DAYS_i71_exe_g);
	i71->Code() = "i71 <- ((float)0)";
	i71->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u72 = (TExecuteCommand*) COUNT_HOURS.GetCommand("u72",TCommand::kUpdate,TCommand::kCode);
	u72->SetExecutable(&COUNT_HOURS_u72_exe_g);
	u72->Code() = "u72 <-  ( ( ( HOURS == ((float)0) ) ) ? ( ( ((float)1)*dT() ) ) : ( ((float)0) ) ) ";
	u72->AddDependency(HOURS);
	u72->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u74 = (TExecuteCommand*) CURRENT_DIRECTION.GetCommand("u74",TCommand::kUpdate,TCommand::kCode);
	u74->SetExecutable(&CURRENT_DIRECTION_u74_exe_g);
	u74->Code() = "u74 <-  ( ( ( ( NS_VECTOR == ((float)0) ) && ( EW_VECTOR == ((float)0) ) ) ) ? ( ((float)0) ) : (  ( ( ( ( ((float)450)-( SL::Arctan(( NS_VECTOR/EW_VECTOR ))*( ((float)360)/( ((float)2)*3.141590 ) ) ) )*((float)360) ) ) ? ( ( ( ((float)450)-( SL::Arctan(( NS_VECTOR/EW_VECTOR ))*( ((float)360)/( ((float)2)*3.141590 ) ) ) )-((float)360) ) ) : ( ( ((float)450)-( SL::Arctan(( NS_VECTOR/EW_VECTOR ))*( ((float)360)/( ((float)2)*3.141590 ) ) ) ) ) )  ) ) ";
	u74->AddDependency(NS_VECTOR);
	u74->AddDependency(EW_VECTOR);
	u74->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u75 = (TExecuteCommand*) CURRENT_VELOCITY.GetCommand("u75",TCommand::kUpdate,TCommand::kCode);
	u75->SetExecutable(&CURRENT_VELOCITY_u75_exe_g);
	u75->Code() = "u75 <- SL::Sqrt(( pow((double)EW_VECTOR,(double)((float)2) )+pow((double)NS_VECTOR,(double)((float)2) ) ))";
	u75->AddDependency(EW_VECTOR);
	u75->AddDependency(NS_VECTOR);
	u75->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u76 = (TExecuteCommand*) EC_H2O.GetCommand("u76",TCommand::kUpdate,TCommand::kCode);
	u76->SetExecutable(&EC_H2O_u76_exe_g);
	u76->Code() = "u76 <- ( ( P_EC_COEFF_SED*( TSS_CONC+PHT_CONC ) )+P_EC_COEFF_WATER )";
	u76->AddDependency(P_EC_COEFF_SED);
	u76->AddDependency(TSS_CONC);
	u76->AddDependency(PHT_CONC);
	u76->AddDependency(P_EC_COEFF_WATER);
	u76->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u77 = (TExecuteCommand*) EW_CURRENT_VECTOR.GetCommand("u77",TCommand::kUpdate,TCommand::kCode);
	u77->SetExecutable(&EW_CURRENT_VECTOR_u77_exe_g);
	u77->Code() = "u77 <- 0";
	u77->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u78 = (TExecuteCommand*) EW_VECTOR.GetCommand("u78",TCommand::kUpdate,TCommand::kCode);
	u78->SetExecutable(&EW_VECTOR_u78_exe_g);
	u78->Code() = "u78 <- ( EW_CURRENT_VECTOR+( 0.035*EW_WIND_VECTOR ) )";
	u78->AddDependency(EW_CURRENT_VECTOR);
	u78->AddDependency(EW_WIND_VECTOR);
	u78->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u79 = (TExecuteCommand*) EW_WIND_VECTOR.GetCommand("u79",TCommand::kUpdate,TCommand::kCode);
	u79->SetExecutable(&EW_WIND_VECTOR_u79_exe_g);
	u79->Code() = "u79 <- ( P_WIND_SPEED*SL::Sin(( ( ( P_WIND_DIRECTION*((float)2) )*3.141590 )/360 )) )";
	u79->AddDependency(P_WIND_SPEED);
	u79->AddDependency(P_WIND_DIRECTION);
	u79->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u80 = (TExecuteCommand*) HOURS.GetCommand("u80",TCommand::kUpdate,TCommand::kCode);
	u80->SetExecutable(&HOURS_u80_exe_g);
	u80->Code() = "u80 <- SL::Mod(TIME, ((float)24))";
	u80->AddDependency(TIME);
	u80->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u82 = (TExecuteCommand*) NS_CURRENT_VECTOR.GetCommand("u82",TCommand::kUpdate,TCommand::kCode);
	u82->SetExecutable(&NS_CURRENT_VECTOR_u82_exe_g);
	u82->Code() = "u82 <- 0";
	u82->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u83 = (TExecuteCommand*) NS_VECTOR.GetCommand("u83",TCommand::kUpdate,TCommand::kCode);
	u83->SetExecutable(&NS_VECTOR_u83_exe_g);
	u83->Code() = "u83 <- ( NS_CURRENT_VECTOR+( 0.035*NS_WIND_VECTOR ) )";
	u83->AddDependency(NS_CURRENT_VECTOR);
	u83->AddDependency(NS_WIND_VECTOR);
	u83->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u84 = (TExecuteCommand*) NS_WIND_VECTOR.GetCommand("u84",TCommand::kUpdate,TCommand::kCode);
	u84->SetExecutable(&NS_WIND_VECTOR_u84_exe_g);
	u84->Code() = "u84 <- ( P_WIND_SPEED*SL::Cos(( ( ( P_WIND_DIRECTION*((float)2) )*3.141590 )/360 )) )";
	u84->AddDependency(P_WIND_SPEED);
	u84->AddDependency(P_WIND_DIRECTION);
	u84->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u85 = (TExecuteCommand*) OM3_SALT_CONC.GetCommand("u85",TCommand::kUpdate,TCommand::kCode);
	u85->SetExecutable(&OM3_SALT_CONC_u85_exe_g);
	u85->Code() = "u85 <- ((float)1)";
	u85->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u88 = (TExecuteCommand*) OM3_UD_CURRENT_VECTOR.GetCommand("u88",TCommand::kUpdate,TCommand::kCode);
	u88->SetExecutable(&OM3_UD_CURRENT_VECTOR_u88_exe_g);
	u88->Code() = "u88 <- 1";
	u88->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u89 = (TExecuteCommand*) PHOTO_PERIOD.GetCommand("u89",TCommand::kUpdate,TCommand::kCode);
	u89->SetExecutable(&PHOTO_PERIOD_u89_exe_g);
	u89->Code() = "u89 <- ( 7.639437*H_ANGLE )";
	u89->AddDependency(H_ANGLE);
	u89->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u90 = (TExecuteCommand*) RAND.GetCommand("u90",TCommand::kUpdate,TCommand::kCode);
	u90->SetExecutable(&RAND_u90_exe_g);
	u90->Code() = "u90 <- SL::Rand(((float)0), ((float)98))";
	u90->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u91 = (TExecuteCommand*) SDCLN.GetCommand("u91",TCommand::kUpdate,TCommand::kCode);
	u91->SetExecutable(&SDCLN_u91_exe_g);
	u91->Code() = "u91 <- ( ( ( ( 0.00678+( 0.39762*SL::Cos(( 0.0172142*( DAYS-((float)172) ) )) ) )+( 0.00613*SL::Sin(( 0.0172142*( DAYS-((float)172) ) )) ) )-( 0.00661*SL::Cos(( 0.034428*( DAYS-((float)172) ) )) ) )-( 0.00159*SL::Sin(( 0.034428*( DAYS-((float)172) ) )) ) )";
	u91->AddDependency(DAYS);
	u91->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u93 = (TExecuteCommand*) SURFACE_LIGHT.GetCommand("u93",TCommand::kUpdate,TCommand::kCode);
	u93->SetExecutable(&SURFACE_LIGHT_u93_exe_g);
	u93->Code() = "u93 <- ( ( ((float)1)-SKEW_WEATHER )*( 37.665+( 23.275*SL::Sin(( ( 0.016252*DAYS )+5.0881 )) ) ) )";
	u93->AddDependency(SKEW_WEATHER);
	u93->AddDependency(DAYS);
	u93->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u97 = (TExecuteCommand*) WATER_LAYER_HEIGHT.GetCommand("u97",TCommand::kUpdate,TCommand::kCode);
	u97->SetExecutable(&WATER_LAYER_HEIGHT_u97_exe_g);
	u97->Code() = "u97 <- ((float)1)";
	u97->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u102 = (TExecuteCommand*) P_EC_COEFF_SED.GetCommand("u102",TCommand::kUpdate,TCommand::kCode);
	u102->SetExecutable(&P_EC_COEFF_SED_u102_exe_g);
	u102->Code() = "u102 <- 0.000700";
	u102->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u103 = (TExecuteCommand*) P_EC_COEFF_WATER.GetCommand("u103",TCommand::kUpdate,TCommand::kCode);
	u103->SetExecutable(&P_EC_COEFF_WATER_u103_exe_g);
	u103->Code() = "u103 <- 0.000070";
	u103->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u104 = (TExecuteCommand*) P_IC_SED_ELEV.GetCommand("u104",TCommand::kUpdate,TCommand::kCode);
	u104->SetExecutable(&P_IC_SED_ELEV_u104_exe_g);
	u104->Code() = "u104 <- 3";
	u104->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u105 = (TExecuteCommand*) P_LATITUDE.GetCommand("u105",TCommand::kUpdate,TCommand::kCode);
	u105->SetExecutable(&P_LATITUDE_u105_exe_g);
	u105->Code() = "u105 <- 38.500000";
	u105->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u107 = (TExecuteCommand*) DECLINE.GetCommand("u107",TCommand::kUpdate,TCommand::kCode);
	u107->SetExecutable(&DECLINE_u107_exe_g);
	u107->Code() = "u107 <- Graph1(SDCLN)";
	u107->AddDependency(SDCLN);
	u107->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u108 = (TExecuteCommand*) H_ANGLE.GetCommand("u108",TCommand::kUpdate,TCommand::kCode);
	u108->SetExecutable(&H_ANGLE_u108_exe_g);
	u108->Code() = "u108 <- Graph2(( -SL::Tan(( P_LATITUDE*0.0174533 ))*SL::Tan(DECLINE) ))";
	u108->AddDependency(P_LATITUDE);
	u108->AddDependency(DECLINE);
	u108->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u109 = (TExecuteCommand*) SKEW_WEATHER.GetCommand("u109",TCommand::kUpdate,TCommand::kCode);
	u109->SetExecutable(&SKEW_WEATHER_u109_exe_g);
	u109->Code() = "u109 <- Graph3(RAND)";
	u109->AddDependency(RAND);
	u109->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u110 = (TExecuteCommand*) P_AIR_TEMP.GetCommand("u110",TCommand::kUpdate,TCommand::kCode);
	u110->SetExecutable(&P_AIR_TEMP_u110_exe_g);
	u110->Code() = "u110 <- Graph4(DAYS)";
	u110->AddDependency(DAYS);
	u110->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u111 = (TExecuteCommand*) P_LEAF_GROW_SEASON.GetCommand("u111",TCommand::kUpdate,TCommand::kCode);
	u111->SetExecutable(&P_LEAF_GROW_SEASON_u111_exe_g);
	u111->Code() = "u111 <- Graph5(DAYS)";
	u111->AddDependency(DAYS);
	u111->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u112 = (TExecuteCommand*) P_PRECIPITATION.GetCommand("u112",TCommand::kUpdate,TCommand::kCode);
	u112->SetExecutable(&P_PRECIPITATION_u112_exe_g);
	u112->Code() = "u112 <- Graph6(DAYS)";
	u112->AddDependency(DAYS);
	u112->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u113 = (TExecuteCommand*) P_WIND_DIRECTION.GetCommand("u113",TCommand::kUpdate,TCommand::kCode);
	u113->SetExecutable(&P_WIND_DIRECTION_u113_exe_g);
	u113->Code() = "u113 <- Graph7(DAYS)";
	u113->AddDependency(DAYS);
	u113->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u114 = (TExecuteCommand*) P_WIND_SPEED.GetCommand("u114",TCommand::kUpdate,TCommand::kCode);
	u114->SetExecutable(&P_WIND_SPEED_u114_exe_g);
	u114->Code() = "u114 <- Graph8(DAYS)";
	u114->AddDependency(DAYS);
	u114->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int GLOBAL_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int GLOBAL_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int GLOBAL_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int GLOBAL_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class PHOSPHATE_module 
// ---------------------------------------------------------------------------
PHOSPHATE_module::PHOSPHATE_module(char* name) :
	TIME("TIME"),
	SF_WATER("SF_WATER"),
	DETR_DECOMPOSED("DETR_DECOMPOSED"),
	PHT_NET_PROD("PHT_NET_PROD"),
	P_PHY_PC("P_PHY_PC"),
	BOTTOM_MAP("BOTTOM_MAP"),
	PO4_SF_WT_CONC("PO4_SF_WT_CONC"),
	PO4_SF_WT("PO4_SF_WT"),
	PO4_MINERALIZATION("PO4_MINERALIZATION"),
	PO4_UPFL("PO4_UPFL"),
	PO4_SF_TO_SED__FL("PO4_SF_TO_SED__FL"),
	PO4_SF_WT_UPTAK("PO4_SF_WT_UPTAK"),
	RIVER_P("RIVER_P"),
	P_DETR_PC_RT("P_DETR_PC_RT"),
	P_IC_PO4("P_IC_PO4"),
	P_PO4_SED_WT_CONC("P_PO4_SED_WT_CONC"),
	P_SED_WAT_DIFFUSION_CF("P_SED_WAT_DIFFUSION_CF"),
	TModule(name) {

	SF_WATER.SetF(FisImport,True,"CG");
	DETR_DECOMPOSED.SetF(FisImport,True,"CG");
	PHT_NET_PROD.SetF(FisImport,True,"CG");
	P_PHY_PC.SetF(FisImport,True,"CG");
	BOTTOM_MAP.SetF(FisImport,True,"CG");
	PO4_SF_WT_CONC.SetF(FisExport,True,"CG");
	PO4_SF_WT.SetF(FHasNegFlux,True,"CG");
	PO4_SF_TO_SED__FL.SetF(FHasNegFlux,True,"CG");
	PO4_SF_WT_UPTAK.SetF(FHasNegFlux,True,"CG");
}	
int PHOSPHATE_module::PO4_SF_WT_I115_exe() {
	float value;
	int array_index[64];


	PO4_SF_WT.UpdateIntegrator();
	switch( PO4_SF_WT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* PO4_SF_WT_ptr = PO4_SF_WT.DataStart();
		const float* PO4_SF_WT_Eptr = PO4_SF_WT.GridEnd();
		float dt = dT();
		float* PO4_SF_WT_Rptr = PO4_SF_WT.RDataStart();
		float* RIVER_P_ptr = RIVER_P.DataStart();
		float* PO4_MINERALIZATION_ptr = PO4_MINERALIZATION.DataStart();
		float* PO4_UPFL_ptr = PO4_UPFL.DataStart();
		float* PO4_SF_TO_SED__FL_ptr = PO4_SF_TO_SED__FL.DataStart();
		float* PO4_SF_WT_UPTAK_ptr = PO4_SF_WT_UPTAK.DataStart();
		switch( PO4_SF_WT.CurrentOrder() ) {
		  case 1: {
			if( PO4_SF_WT.Order() > 1 ) {
			float *PO4_SF_WT_IMptr0 = PO4_SF_WT.SIntegratorMemory().LastData();
			while( PO4_SF_WT_ptr < PO4_SF_WT_Eptr ) {
		 value =  ( ( ( ( (*(RIVER_P_ptr))+(*(PO4_MINERALIZATION_ptr)) )+(*(PO4_UPFL_ptr)) )-(*(PO4_SF_TO_SED__FL_ptr)) )-(*(PO4_SF_WT_UPTAK_ptr)) );
				*PO4_SF_WT_ptr += value*dt;
				if(PO4_SF_WT_Rptr) { *PO4_SF_WT_Rptr++ = *PO4_SF_WT_ptr; }
				*PO4_SF_WT_IMptr0++ = value;
				PO4_SF_WT_ptr++;
				RIVER_P.UpdateDataPtr(RIVER_P_ptr);
				PO4_MINERALIZATION.UpdateDataPtr(PO4_MINERALIZATION_ptr);
				PO4_UPFL.UpdateDataPtr(PO4_UPFL_ptr);
				PO4_SF_TO_SED__FL.UpdateDataPtr(PO4_SF_TO_SED__FL_ptr);
				PO4_SF_WT_UPTAK.UpdateDataPtr(PO4_SF_WT_UPTAK_ptr);
			}
			} else {
			while( PO4_SF_WT_ptr < PO4_SF_WT_Eptr ) {
		 value =  ( ( ( ( (*(RIVER_P_ptr))+(*(PO4_MINERALIZATION_ptr)) )+(*(PO4_UPFL_ptr)) )-(*(PO4_SF_TO_SED__FL_ptr)) )-(*(PO4_SF_WT_UPTAK_ptr)) );
				*PO4_SF_WT_ptr += value*dt;
				if(PO4_SF_WT_Rptr) { *PO4_SF_WT_Rptr++ = *PO4_SF_WT_ptr; }
				PO4_SF_WT_ptr++;
				RIVER_P.UpdateDataPtr(RIVER_P_ptr);
				PO4_MINERALIZATION.UpdateDataPtr(PO4_MINERALIZATION_ptr);
				PO4_UPFL.UpdateDataPtr(PO4_UPFL_ptr);
				PO4_SF_TO_SED__FL.UpdateDataPtr(PO4_SF_TO_SED__FL_ptr);
				PO4_SF_WT_UPTAK.UpdateDataPtr(PO4_SF_WT_UPTAK_ptr);
			}
			};
		  } break; case 2: {
			float *PO4_SF_WT_IMptr0 = PO4_SF_WT.SIntegratorMemory().LastData();
			float *PO4_SF_WT_IMptr1 = PO4_SF_WT.SIntegratorMemory().LastDataOffset(1);
			while( PO4_SF_WT_ptr < PO4_SF_WT_Eptr ) {
		 value =  ( ( ( ( (*(RIVER_P_ptr))+(*(PO4_MINERALIZATION_ptr)) )+(*(PO4_UPFL_ptr)) )-(*(PO4_SF_TO_SED__FL_ptr)) )-(*(PO4_SF_WT_UPTAK_ptr)) );
				*PO4_SF_WT_IMptr0++ = value;
				*PO4_SF_WT_ptr += ( 1.5*value - 0.5* *PO4_SF_WT_IMptr1++ )*dt;
				if(PO4_SF_WT_Rptr) { *PO4_SF_WT_Rptr++ = *PO4_SF_WT_ptr; }
				PO4_SF_WT_ptr++;
				RIVER_P.UpdateDataPtr(RIVER_P_ptr);
				PO4_MINERALIZATION.UpdateDataPtr(PO4_MINERALIZATION_ptr);
				PO4_UPFL.UpdateDataPtr(PO4_UPFL_ptr);
				PO4_SF_TO_SED__FL.UpdateDataPtr(PO4_SF_TO_SED__FL_ptr);
				PO4_SF_WT_UPTAK.UpdateDataPtr(PO4_SF_WT_UPTAK_ptr);
			}
		  } break; case 3: {
			float *PO4_SF_WT_IMptr0 = PO4_SF_WT.SIntegratorMemory().LastData();
			float *PO4_SF_WT_IMptr1 = PO4_SF_WT.SIntegratorMemory().LastDataOffset(1);
			float *PO4_SF_WT_IMptr2 = PO4_SF_WT.SIntegratorMemory().LastDataOffset(2);
			while( PO4_SF_WT_ptr < PO4_SF_WT_Eptr ) {
		 value =  ( ( ( ( (*(RIVER_P_ptr))+(*(PO4_MINERALIZATION_ptr)) )+(*(PO4_UPFL_ptr)) )-(*(PO4_SF_TO_SED__FL_ptr)) )-(*(PO4_SF_WT_UPTAK_ptr)) );
				*PO4_SF_WT_IMptr0++ = value;
				*PO4_SF_WT_ptr += (1.92*value - 1.33* *PO4_SF_WT_IMptr1++ + .42* *PO4_SF_WT_IMptr2++)*dt;
				if(PO4_SF_WT_Rptr) { *PO4_SF_WT_Rptr++ = *PO4_SF_WT_ptr; }
				PO4_SF_WT_ptr++;
				RIVER_P.UpdateDataPtr(RIVER_P_ptr);
				PO4_MINERALIZATION.UpdateDataPtr(PO4_MINERALIZATION_ptr);
				PO4_UPFL.UpdateDataPtr(PO4_UPFL_ptr);
				PO4_SF_TO_SED__FL.UpdateDataPtr(PO4_SF_TO_SED__FL_ptr);
				PO4_SF_WT_UPTAK.UpdateDataPtr(PO4_SF_WT_UPTAK_ptr);
			}
		  } break; case 4: {
			float *PO4_SF_WT_IMptr0 = PO4_SF_WT.SIntegratorMemory().LastData();
			float *PO4_SF_WT_IMptr1 = PO4_SF_WT.SIntegratorMemory().LastDataOffset(1);
			float *PO4_SF_WT_IMptr2 = PO4_SF_WT.SIntegratorMemory().LastDataOffset(2);
			float *PO4_SF_WT_IMptr3 = PO4_SF_WT.SIntegratorMemory().LastDataOffset(3);
			while( PO4_SF_WT_ptr < PO4_SF_WT_Eptr ) {
		 value =  ( ( ( ( (*(RIVER_P_ptr))+(*(PO4_MINERALIZATION_ptr)) )+(*(PO4_UPFL_ptr)) )-(*(PO4_SF_TO_SED__FL_ptr)) )-(*(PO4_SF_WT_UPTAK_ptr)) );
				*PO4_SF_WT_IMptr0++ = value;
				*PO4_SF_WT_ptr += (2.29*value - 2.46* *PO4_SF_WT_IMptr1++  + 1.54* *PO4_SF_WT_IMptr2++ - .375* *PO4_SF_WT_IMptr3++ )*dt;
				if(PO4_SF_WT_Rptr) { *PO4_SF_WT_Rptr++ = *PO4_SF_WT_ptr; }
				PO4_SF_WT_ptr++;
				RIVER_P.UpdateDataPtr(RIVER_P_ptr);
				PO4_MINERALIZATION.UpdateDataPtr(PO4_MINERALIZATION_ptr);
				PO4_UPFL.UpdateDataPtr(PO4_UPFL_ptr);
				PO4_SF_TO_SED__FL.UpdateDataPtr(PO4_SF_TO_SED__FL_ptr);
				PO4_SF_WT_UPTAK.UpdateDataPtr(PO4_SF_WT_UPTAK_ptr);
			}
		  } break; default: { gPrintErr("Illegal Order in StateVar update!"); }
		};
		PO4_SF_WT.GrabMemory();
		if( PO4_SF_WT.GetF(FLinkEdges) ) { PO4_SF_WT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = PO4_SF_WT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( ( ( RIVER_P.Value(p)+PO4_MINERALIZATION.Value(p) )+PO4_UPFL.Value(p) )-PO4_SF_TO_SED__FL.Value(p) )-PO4_SF_WT_UPTAK.Value(p) );
			PO4_SF_WT.Update( p, value, dT() );
		}
		PO4_SF_WT.GrabMemory();
		if( PO4_SF_WT.GetF(FLinkEdges) ) { PO4_SF_WT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( ( ( RIVER_P.Value()+PO4_MINERALIZATION.Value() )+PO4_UPFL.Value() )-PO4_SF_TO_SED__FL.Value() )-PO4_SF_WT_UPTAK.Value() );
			PO4_SF_WT.Update( value, dT() );
	  } break;
	}
	PO4_SF_WT.UpdateGOFComputation();
	return 0;
}

int PHOSPHATE_module::PO4_SF_WT_i116_exe() {
	float value;
	int array_index[64];


	switch( PO4_SF_WT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* PO4_SF_WT_ptr = PO4_SF_WT.DataStart();
		const float* PO4_SF_WT_Eptr = PO4_SF_WT.GridEnd();
		float dt = dT();
		float* PO4_SF_WT_Rptr = PO4_SF_WT.RDataStart();
		float* SF_WATER_ptr = SF_WATER.DataStart();
		float* P_IC_PO4_ptr = P_IC_PO4.DataStart();
		while( PO4_SF_WT_ptr < PO4_SF_WT_Eptr ) {
		 value =  ( ( (*(SF_WATER_ptr))*(*(P_IC_PO4_ptr)) )*.001 );
			if(PO4_SF_WT_Rptr) { *PO4_SF_WT_Rptr = *PO4_SF_WT_ptr = value;  PO4_SF_WT_Rptr++; }
			else { *PO4_SF_WT_ptr = value; }
			PO4_SF_WT_ptr++;
			SF_WATER.UpdateDataPtr(SF_WATER_ptr);
			P_IC_PO4.UpdateDataPtr(P_IC_PO4_ptr);
		}
		PO4_SF_WT.GrabMemory();
		if( PO4_SF_WT.GetF(FLinkEdges) ) { PO4_SF_WT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = PO4_SF_WT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( SF_WATER.Value(p)*P_IC_PO4.Value(p) )*.001 );
			PO4_SF_WT.InitValue( p, value );
		}
		PO4_SF_WT.GrabMemory();
		if( PO4_SF_WT.GetF(FLinkEdges) ) { PO4_SF_WT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( SF_WATER.Value()*P_IC_PO4.Value() )*.001 );
			PO4_SF_WT.InitValue( value );
	  } break;
	}
	PO4_SF_WT.UpdateGOFComputation();
	return 0;
}

int PHOSPHATE_module::PO4_MINERALIZATION_u117_exe() {
	float value;
	int array_index[64];


	switch( PO4_MINERALIZATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* PO4_MINERALIZATION_ptr = PO4_MINERALIZATION.DataStart();
		const float* PO4_MINERALIZATION_Eptr = PO4_MINERALIZATION.GridEnd();
		float dt = dT();
		float* DETR_DECOMPOSED_ptr = DETR_DECOMPOSED.DataStart();
		float* P_DETR_PC_RT_ptr = P_DETR_PC_RT.DataStart();
		int clamped = 0;
		while( PO4_MINERALIZATION_ptr < PO4_MINERALIZATION_Eptr ) {
		 value =  ( (*(DETR_DECOMPOSED_ptr))*(*(P_DETR_PC_RT_ptr)) );
			*PO4_MINERALIZATION_ptr = value;
			PO4_MINERALIZATION_ptr++;
			DETR_DECOMPOSED.UpdateDataPtr(DETR_DECOMPOSED_ptr);
			P_DETR_PC_RT.UpdateDataPtr(P_DETR_PC_RT_ptr);
		}
		if( PO4_MINERALIZATION.GetF(FICFlux) ) PO4_MINERALIZATION.Cov().Set(0.0); 
		PO4_MINERALIZATION.GrabMemory();
		if( PO4_MINERALIZATION.GetF(FLinkEdges) ) { PO4_MINERALIZATION.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = PO4_MINERALIZATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( DETR_DECOMPOSED.Value(p)*P_DETR_PC_RT.Value(p) );
			PO4_MINERALIZATION.Update( p, value );
		}
		PO4_MINERALIZATION.GrabMemory();
		if( PO4_MINERALIZATION.GetF(FICFlux) ) PO4_MINERALIZATION.Cov().Set(0.0); 
		if( PO4_MINERALIZATION.GetF(FLinkEdges) ) { PO4_MINERALIZATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( DETR_DECOMPOSED.Value()*P_DETR_PC_RT.Value() );
			PO4_MINERALIZATION.Update( value );
	  } break;
	}
	PO4_MINERALIZATION.UpdateGOFComputation();
	return 0;
}

int PHOSPHATE_module::PO4_UPFL_u118_exe() {
	float value;
	int array_index[64];


	switch( PO4_UPFL.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* PO4_UPFL_ptr = PO4_UPFL.DataStart();
		const float* PO4_UPFL_Eptr = PO4_UPFL.GridEnd();
		float dt = dT();
		float* PO4_SF_WT_CONC_ptr = PO4_SF_WT_CONC.DataStart();
		float* P_PO4_SED_WT_CONC_ptr = P_PO4_SED_WT_CONC.DataStart();
		float* P_SED_WAT_DIFFUSION_CF_ptr = P_SED_WAT_DIFFUSION_CF.DataStart();
		int clamped = 0;
		while( PO4_UPFL_ptr < PO4_UPFL_Eptr ) {
		 value =   ( ( ( (*(PO4_SF_WT_CONC_ptr)) >= (*(P_PO4_SED_WT_CONC_ptr)) ) ) ? ( ((float)0) ) : ( ( ( (*(P_PO4_SED_WT_CONC_ptr))-(*(PO4_SF_WT_CONC_ptr)) )*(*(P_SED_WAT_DIFFUSION_CF_ptr)) ) ) ) ;
			*PO4_UPFL_ptr = value;
			PO4_UPFL_ptr++;
			PO4_SF_WT_CONC.UpdateDataPtr(PO4_SF_WT_CONC_ptr);
			P_PO4_SED_WT_CONC.UpdateDataPtr(P_PO4_SED_WT_CONC_ptr);
			P_SED_WAT_DIFFUSION_CF.UpdateDataPtr(P_SED_WAT_DIFFUSION_CF_ptr);
		}
		if( PO4_UPFL.GetF(FICFlux) ) PO4_UPFL.Cov().Set(0.0); 
		PO4_UPFL.GrabMemory();
		if( PO4_UPFL.GetF(FLinkEdges) ) { PO4_UPFL.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = PO4_UPFL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( PO4_SF_WT_CONC.Value(p) >= P_PO4_SED_WT_CONC.Value(p) ) ) ? ( ((float)0) ) : ( ( ( P_PO4_SED_WT_CONC.Value(p)-PO4_SF_WT_CONC.Value(p) )*P_SED_WAT_DIFFUSION_CF.Value(p) ) ) ) ;
			PO4_UPFL.Update( p, value );
		}
		PO4_UPFL.GrabMemory();
		if( PO4_UPFL.GetF(FICFlux) ) PO4_UPFL.Cov().Set(0.0); 
		if( PO4_UPFL.GetF(FLinkEdges) ) { PO4_UPFL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( PO4_SF_WT_CONC.Value() >= P_PO4_SED_WT_CONC.Value() ) ) ? ( ((float)0) ) : ( ( ( P_PO4_SED_WT_CONC.Value()-PO4_SF_WT_CONC.Value() )*P_SED_WAT_DIFFUSION_CF.Value() ) ) ) ;
			PO4_UPFL.Update( value );
	  } break;
	}
	PO4_UPFL.UpdateGOFComputation();
	return 0;
}

int PHOSPHATE_module::PO4_SF_TO_SED__FL_u119_exe() {
	float value;
	int array_index[64];


	switch( PO4_SF_TO_SED__FL.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* PO4_SF_TO_SED__FL_ptr = PO4_SF_TO_SED__FL.DataStart();
		const float* PO4_SF_TO_SED__FL_Eptr = PO4_SF_TO_SED__FL.GridEnd();
		float dt = dT();
		float* PO4_SF_TO_SED__FL_Optr = ((CStateVariable*)(PO4_SF_TO_SED__FL.Origin()))->RDataStart();
		float* PO4_SF_WT_CONC_ptr = PO4_SF_WT_CONC.DataStart();
		float* P_PO4_SED_WT_CONC_ptr = P_PO4_SED_WT_CONC.DataStart();
		float* P_SED_WAT_DIFFUSION_CF_ptr = P_SED_WAT_DIFFUSION_CF.DataStart();
		int clamped = PO4_SF_WT.GetF(FisClamped);
		while( PO4_SF_TO_SED__FL_ptr < PO4_SF_TO_SED__FL_Eptr ) {
		 value =   ( ( ( (*(PO4_SF_WT_CONC_ptr)) <= (*(P_PO4_SED_WT_CONC_ptr)) ) ) ? ( ((float)0) ) : ( ( ( (*(PO4_SF_WT_CONC_ptr))-(*(P_PO4_SED_WT_CONC_ptr)) )*(*(P_SED_WAT_DIFFUSION_CF_ptr)) ) ) ) ;
			*PO4_SF_TO_SED__FL_ptr = value;
			if( clamped ) { SL::Clamp(PO4_SF_TO_SED__FL_Optr++,PO4_SF_TO_SED__FL_ptr,dt); }
			PO4_SF_TO_SED__FL_ptr++;
			PO4_SF_WT_CONC.UpdateDataPtr(PO4_SF_WT_CONC_ptr);
			P_PO4_SED_WT_CONC.UpdateDataPtr(P_PO4_SED_WT_CONC_ptr);
			P_SED_WAT_DIFFUSION_CF.UpdateDataPtr(P_SED_WAT_DIFFUSION_CF_ptr);
		}
		if( PO4_SF_TO_SED__FL.GetF(FICFlux) ) PO4_SF_TO_SED__FL.Cov().Set(0.0); 
		PO4_SF_TO_SED__FL.GrabMemory();
		if( PO4_SF_TO_SED__FL.GetF(FLinkEdges) ) { PO4_SF_TO_SED__FL.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = PO4_SF_TO_SED__FL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( PO4_SF_WT_CONC.Value(p) <= P_PO4_SED_WT_CONC.Value(p) ) ) ? ( ((float)0) ) : ( ( ( PO4_SF_WT_CONC.Value(p)-P_PO4_SED_WT_CONC.Value(p) )*P_SED_WAT_DIFFUSION_CF.Value(p) ) ) ) ;
			PO4_SF_TO_SED__FL.Update( p, value );
		}
		PO4_SF_TO_SED__FL.GrabMemory();
		if( PO4_SF_TO_SED__FL.GetF(FICFlux) ) PO4_SF_TO_SED__FL.Cov().Set(0.0); 
		if( PO4_SF_TO_SED__FL.GetF(FLinkEdges) ) { PO4_SF_TO_SED__FL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( PO4_SF_WT_CONC.Value() <= P_PO4_SED_WT_CONC.Value() ) ) ? ( ((float)0) ) : ( ( ( PO4_SF_WT_CONC.Value()-P_PO4_SED_WT_CONC.Value() )*P_SED_WAT_DIFFUSION_CF.Value() ) ) ) ;
			PO4_SF_TO_SED__FL.Update( value );
	  } break;
	}
	PO4_SF_TO_SED__FL.UpdateGOFComputation();
	return 0;
}

int PHOSPHATE_module::PO4_SF_WT_UPTAK_u120_exe() {
	float value;
	int array_index[64];


	switch( PO4_SF_WT_UPTAK.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* PO4_SF_WT_UPTAK_ptr = PO4_SF_WT_UPTAK.DataStart();
		const float* PO4_SF_WT_UPTAK_Eptr = PO4_SF_WT_UPTAK.GridEnd();
		float dt = dT();
		float* PO4_SF_WT_UPTAK_Optr = ((CStateVariable*)(PO4_SF_WT_UPTAK.Origin()))->RDataStart();
		float* PHT_NET_PROD_ptr = PHT_NET_PROD.DataStart();
		float* P_PHY_PC_ptr = P_PHY_PC.DataStart();
		int clamped = PO4_SF_WT.GetF(FisClamped);
		while( PO4_SF_WT_UPTAK_ptr < PO4_SF_WT_UPTAK_Eptr ) {
		 value =  ( ( (*(PHT_NET_PROD_ptr))*(*(P_PHY_PC_ptr)) )*1.0 );
			*PO4_SF_WT_UPTAK_ptr = value;
			if( clamped ) { SL::Clamp(PO4_SF_WT_UPTAK_Optr++,PO4_SF_WT_UPTAK_ptr,dt); }
			PO4_SF_WT_UPTAK_ptr++;
			PHT_NET_PROD.UpdateDataPtr(PHT_NET_PROD_ptr);
			P_PHY_PC.UpdateDataPtr(P_PHY_PC_ptr);
		}
		if( PO4_SF_WT_UPTAK.GetF(FICFlux) ) PO4_SF_WT_UPTAK.Cov().Set(0.0); 
		PO4_SF_WT_UPTAK.GrabMemory();
		if( PO4_SF_WT_UPTAK.GetF(FLinkEdges) ) { PO4_SF_WT_UPTAK.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = PO4_SF_WT_UPTAK.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( PHT_NET_PROD.Value(p)*P_PHY_PC.Value(p) )*1.0 );
			PO4_SF_WT_UPTAK.Update( p, value );
		}
		PO4_SF_WT_UPTAK.GrabMemory();
		if( PO4_SF_WT_UPTAK.GetF(FICFlux) ) PO4_SF_WT_UPTAK.Cov().Set(0.0); 
		if( PO4_SF_WT_UPTAK.GetF(FLinkEdges) ) { PO4_SF_WT_UPTAK.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( PHT_NET_PROD.Value()*P_PHY_PC.Value() )*1.0 );
			PO4_SF_WT_UPTAK.Update( value );
	  } break;
	}
	PO4_SF_WT_UPTAK.UpdateGOFComputation();
	return 0;
}

int PHOSPHATE_module::PO4_SF_WT_CONC_u121_exe() {
	float value;
	int array_index[64];


	switch( PO4_SF_WT_CONC.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* PO4_SF_WT_CONC_ptr = PO4_SF_WT_CONC.DataStart();
		const float* PO4_SF_WT_CONC_Eptr = PO4_SF_WT_CONC.GridEnd();
		float* PO4_SF_WT_ptr = PO4_SF_WT.DataStart();
		float* SF_WATER_ptr = SF_WATER.DataStart();
		while( PO4_SF_WT_CONC_ptr < PO4_SF_WT_CONC_Eptr ) {
		 value =  ( (*(PO4_SF_WT_ptr))/(*(SF_WATER_ptr)) );
			*PO4_SF_WT_CONC_ptr = value;
			PO4_SF_WT_CONC_ptr++;
			PO4_SF_WT.UpdateDataPtr(PO4_SF_WT_ptr);
			SF_WATER.UpdateDataPtr(SF_WATER_ptr);
		}
		PO4_SF_WT_CONC.GrabMemory();
		if( PO4_SF_WT_CONC.GetF(FLinkEdges) ) { PO4_SF_WT_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = PO4_SF_WT_CONC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( PO4_SF_WT.Value(p)/SF_WATER.Value(p) );
			PO4_SF_WT_CONC.Update( p, value );
		}
		PO4_SF_WT_CONC.GrabMemory();
		if( PO4_SF_WT_CONC.GetF(FLinkEdges) ) { PO4_SF_WT_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( PO4_SF_WT.Value()/SF_WATER.Value() );
			PO4_SF_WT_CONC.Update( value );
	  } break;
	}
	PO4_SF_WT_CONC.UpdateGOFComputation();
	return 0;
}

int PHOSPHATE_module::RIVER_P_u122_exe() {
	float value;
	int array_index[64];


	switch( RIVER_P.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* RIVER_P_ptr = RIVER_P.DataStart();
		const float* RIVER_P_Eptr = RIVER_P.GridEnd();
		float dt = dT();
		int clamped = 0;
		 value =  0;
		value = RIVER_P.ParameterValue(value);
		while( RIVER_P_ptr < RIVER_P_Eptr ) {
			*RIVER_P_ptr = value;
			RIVER_P_ptr++;
		}
		if( RIVER_P.GetF(FICFlux) ) RIVER_P.Cov().Set(0.0); 
		RIVER_P.GrabMemory();
		if( RIVER_P.GetF(FLinkEdges) ) { RIVER_P.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = RIVER_P.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0;
			RIVER_P.Update( p, RIVER_P.ParameterValue(value,p) );
		}
		RIVER_P.GrabMemory();
		if( RIVER_P.GetF(FICFlux) ) RIVER_P.Cov().Set(0.0); 
		if( RIVER_P.GetF(FLinkEdges) ) { RIVER_P.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0;
			RIVER_P.Update( RIVER_P.ParameterValue(value) );
	  } break;
	}
	RIVER_P.UpdateGOFComputation();
	return 0;
}

int PHOSPHATE_module::P_DETR_PC_RT_u123_exe() {
	float value;
	int array_index[64];


	switch( P_DETR_PC_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_DETR_PC_RT_ptr = P_DETR_PC_RT.DataStart();
		const float* P_DETR_PC_RT_Eptr = P_DETR_PC_RT.GridEnd();
		while( P_DETR_PC_RT_ptr < P_DETR_PC_RT_Eptr ) {
		 value =  ( 0.0186*((float)2) );
			*P_DETR_PC_RT_ptr = value;
			P_DETR_PC_RT_ptr++;
		}
		P_DETR_PC_RT.GrabMemory();
		if( P_DETR_PC_RT.GetF(FLinkEdges) ) { P_DETR_PC_RT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_DETR_PC_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( 0.0186*((float)2) );
			P_DETR_PC_RT.Update( p, value );
		}
		P_DETR_PC_RT.GrabMemory();
		if( P_DETR_PC_RT.GetF(FLinkEdges) ) { P_DETR_PC_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( 0.0186*((float)2) );
			P_DETR_PC_RT.Update( value );
	  } break;
	}
	P_DETR_PC_RT.UpdateGOFComputation();
	return 0;
}

int PHOSPHATE_module::P_IC_PO4_u124_exe() {
	float value;
	int array_index[64];


	switch( P_IC_PO4.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_IC_PO4_ptr = P_IC_PO4.DataStart();
		const float* P_IC_PO4_Eptr = P_IC_PO4.GridEnd();
		 value =  0.002000;
		value = P_IC_PO4.ParameterValue(value);
		while( P_IC_PO4_ptr < P_IC_PO4_Eptr ) {
			*P_IC_PO4_ptr = value;
			P_IC_PO4_ptr++;
		}
		P_IC_PO4.GrabMemory();
		if( P_IC_PO4.GetF(FLinkEdges) ) { P_IC_PO4.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_IC_PO4.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.002000;
			P_IC_PO4.Update( p, P_IC_PO4.ParameterValue(value,p) );
		}
		P_IC_PO4.GrabMemory();
		if( P_IC_PO4.GetF(FLinkEdges) ) { P_IC_PO4.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.002000;
			P_IC_PO4.Update( P_IC_PO4.ParameterValue(value) );
	  } break;
	}
	P_IC_PO4.UpdateGOFComputation();
	return 0;
}

int PHOSPHATE_module::P_PO4_SED_WT_CONC_u125_exe() {
	float value;
	int array_index[64];


	switch( P_PO4_SED_WT_CONC.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_PO4_SED_WT_CONC_ptr = P_PO4_SED_WT_CONC.DataStart();
		const float* P_PO4_SED_WT_CONC_Eptr = P_PO4_SED_WT_CONC.GridEnd();
		 value =  1;
		value = P_PO4_SED_WT_CONC.ParameterValue(value);
		while( P_PO4_SED_WT_CONC_ptr < P_PO4_SED_WT_CONC_Eptr ) {
			*P_PO4_SED_WT_CONC_ptr = value;
			P_PO4_SED_WT_CONC_ptr++;
		}
		P_PO4_SED_WT_CONC.GrabMemory();
		if( P_PO4_SED_WT_CONC.GetF(FLinkEdges) ) { P_PO4_SED_WT_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_PO4_SED_WT_CONC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  1;
			P_PO4_SED_WT_CONC.Update( p, P_PO4_SED_WT_CONC.ParameterValue(value,p) );
		}
		P_PO4_SED_WT_CONC.GrabMemory();
		if( P_PO4_SED_WT_CONC.GetF(FLinkEdges) ) { P_PO4_SED_WT_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  1;
			P_PO4_SED_WT_CONC.Update( P_PO4_SED_WT_CONC.ParameterValue(value) );
	  } break;
	}
	P_PO4_SED_WT_CONC.UpdateGOFComputation();
	return 0;
}

int PHOSPHATE_module::P_SED_WAT_DIFFUSION_CF_u126_exe() {
	float value;
	int array_index[64];


	switch( P_SED_WAT_DIFFUSION_CF.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_SED_WAT_DIFFUSION_CF_ptr = P_SED_WAT_DIFFUSION_CF.DataStart();
		const float* P_SED_WAT_DIFFUSION_CF_Eptr = P_SED_WAT_DIFFUSION_CF.GridEnd();
		float* BOTTOM_MAP_ptr = BOTTOM_MAP.DataStart();
		while( P_SED_WAT_DIFFUSION_CF_ptr < P_SED_WAT_DIFFUSION_CF_Eptr ) {
		 value =   ( ( ( (*(BOTTOM_MAP_ptr)) == ((float)1) ) ) ? ( 0.001 ) : ( ((float)0) ) ) ;
			*P_SED_WAT_DIFFUSION_CF_ptr = value;
			P_SED_WAT_DIFFUSION_CF_ptr++;
			BOTTOM_MAP.UpdateDataPtr(BOTTOM_MAP_ptr);
		}
		P_SED_WAT_DIFFUSION_CF.GrabMemory();
		if( P_SED_WAT_DIFFUSION_CF.GetF(FLinkEdges) ) { P_SED_WAT_DIFFUSION_CF.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_SED_WAT_DIFFUSION_CF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( BOTTOM_MAP.Value(p) == ((float)1) ) ) ? ( 0.001 ) : ( ((float)0) ) ) ;
			P_SED_WAT_DIFFUSION_CF.Update( p, value );
		}
		P_SED_WAT_DIFFUSION_CF.GrabMemory();
		if( P_SED_WAT_DIFFUSION_CF.GetF(FLinkEdges) ) { P_SED_WAT_DIFFUSION_CF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( BOTTOM_MAP.Value() == ((float)1) ) ) ? ( 0.001 ) : ( ((float)0) ) ) ;
			P_SED_WAT_DIFFUSION_CF.Update( value );
	  } break;
	}
	P_SED_WAT_DIFFUSION_CF.UpdateGOFComputation();
	return 0;
}

PHOSPHATE_module* PHOSPHATE_module::fInstance = NULL;
PHOSPHATE_module* PHOSPHATE_module::kNullModel = (PHOSPHATE_module*)0x1;
int PHOSPHATE_module::InitVars() {
	TIME.SSInit(this);
	SF_WATER.SSInit(this);
	DETR_DECOMPOSED.SSInit(this);
	PHT_NET_PROD.SSInit(this);
	P_PHY_PC.SSInit(this);
	BOTTOM_MAP.SSInit(this);
	PO4_SF_WT_CONC.SSInit(this);
	PO4_SF_WT.SSInit(this);
	PO4_MINERALIZATION.SSInit(this);
	PO4_MINERALIZATION.SetDestination(&PO4_SF_WT);
	PO4_UPFL.SSInit(this);
	PO4_UPFL.SetDestination(&PO4_SF_WT);
	PO4_SF_TO_SED__FL.SSInit(this);
	PO4_SF_TO_SED__FL.SetOrigin(&PO4_SF_WT);
	PO4_SF_WT_UPTAK.SSInit(this);
	PO4_SF_WT_UPTAK.SetOrigin(&PO4_SF_WT);
	RIVER_P.SSInit(this);
	RIVER_P.SetDestination(&PO4_SF_WT);
	P_DETR_PC_RT.SSInit(this);
	P_IC_PO4.SSInit(this);
	P_PO4_SED_WT_CONC.SSInit(this);
	P_SED_WAT_DIFFUSION_CF.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int PHOSPHATE_module::SetupEvents() {
	TImportCommand* SF_WATER_import0 = (TImportCommand*) SF_WATER.GetCommand("SF_WATER_import0",TCommand::kUndefined,TCommand::kImport);
	SF_WATER_import0->Code() = "Import SF_WATER";
	SF_WATER_import0->AddDependency(SF_WATER);
	SF_WATER_import0->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DETR_DECOMPOSED_import1 = (TImportCommand*) DETR_DECOMPOSED.GetCommand("DETR_DECOMPOSED_import1",TCommand::kUndefined,TCommand::kImport);
	DETR_DECOMPOSED_import1->Code() = "Import DETR_DECOMPOSED";
	DETR_DECOMPOSED_import1->AddDependency(DETR_DECOMPOSED);
	DETR_DECOMPOSED_import1->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PHT_NET_PROD_import2 = (TImportCommand*) PHT_NET_PROD.GetCommand("PHT_NET_PROD_import2",TCommand::kUndefined,TCommand::kImport);
	PHT_NET_PROD_import2->Code() = "Import PHT_NET_PROD";
	PHT_NET_PROD_import2->AddDependency(PHT_NET_PROD);
	PHT_NET_PROD_import2->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P_PHY_PC_import3 = (TImportCommand*) P_PHY_PC.GetCommand("P_PHY_PC_import3",TCommand::kUndefined,TCommand::kImport);
	P_PHY_PC_import3->Code() = "Import P_PHY_PC";
	P_PHY_PC_import3->AddDependency(P_PHY_PC);
	P_PHY_PC_import3->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* BOTTOM_MAP_import4 = (TImportCommand*) BOTTOM_MAP.GetCommand("BOTTOM_MAP_import4",TCommand::kUndefined,TCommand::kImport);
	BOTTOM_MAP_import4->Code() = "Import BOTTOM_MAP";
	BOTTOM_MAP_import4->AddDependency(BOTTOM_MAP);
	BOTTOM_MAP_import4->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u121 = (TExecuteCommand*) PO4_SF_WT_CONC.GetCommand("u121",TCommand::kUpdate,TCommand::kCode);
	u121->SetExecutable(&PO4_SF_WT_CONC_u121_exe_g);
	u121->Code() = "u121 <- ( PO4_SF_WT/SF_WATER )";
	u121->AddDependency(PO4_SF_WT);
	u121->AddDependency(SF_WATER);
	u121->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I115 = (TExecuteCommand*) PO4_SF_WT.GetCommand("I115",TCommand::kIntegrate,TCommand::kCode);
	I115->SetExecutable(&PO4_SF_WT_I115_exe_g);
	I115->Code() = "I115 <- ( ( ( ( RIVER_P+PO4_MINERALIZATION )+PO4_UPFL )-PO4_SF_TO_SED__FL )-PO4_SF_WT_UPTAK )";
	I115->AddDependency(RIVER_P);
	I115->AddDependency(PO4_MINERALIZATION);
	I115->AddDependency(PO4_UPFL);
	I115->AddDependency(PO4_SF_TO_SED__FL);
	I115->AddDependency(PO4_SF_WT_UPTAK);
	I115->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i116 = (TExecuteCommand*) PO4_SF_WT.GetCommand("i116",TCommand::kInit,TCommand::kCode);
	i116->SetExecutable(&PO4_SF_WT_i116_exe_g);
	i116->Code() = "i116 <- ( ( SF_WATER*P_IC_PO4 )*.001 )";
	i116->AddDependency(SF_WATER);
	i116->AddDependency(P_IC_PO4);
	i116->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u117 = (TExecuteCommand*) PO4_MINERALIZATION.GetCommand("u117",TCommand::kUpdate,TCommand::kCode);
	u117->SetExecutable(&PO4_MINERALIZATION_u117_exe_g);
	u117->Code() = "u117 <- ( DETR_DECOMPOSED*P_DETR_PC_RT )";
	u117->AddDependency(DETR_DECOMPOSED);
	u117->AddDependency(P_DETR_PC_RT);
	u117->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u118 = (TExecuteCommand*) PO4_UPFL.GetCommand("u118",TCommand::kUpdate,TCommand::kCode);
	u118->SetExecutable(&PO4_UPFL_u118_exe_g);
	u118->Code() = "u118 <-  ( ( ( PO4_SF_WT_CONC >= P_PO4_SED_WT_CONC ) ) ? ( ((float)0) ) : ( ( ( P_PO4_SED_WT_CONC-PO4_SF_WT_CONC )*P_SED_WAT_DIFFUSION_CF ) ) ) ";
	u118->AddDependency(PO4_SF_WT_CONC);
	u118->AddDependency(P_PO4_SED_WT_CONC);
	u118->AddDependency(P_SED_WAT_DIFFUSION_CF);
	u118->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u119 = (TExecuteCommand*) PO4_SF_TO_SED__FL.GetCommand("u119",TCommand::kUpdate,TCommand::kCode);
	u119->SetExecutable(&PO4_SF_TO_SED__FL_u119_exe_g);
	u119->Code() = "u119 <-  ( ( ( PO4_SF_WT_CONC <= P_PO4_SED_WT_CONC ) ) ? ( ((float)0) ) : ( ( ( PO4_SF_WT_CONC-P_PO4_SED_WT_CONC )*P_SED_WAT_DIFFUSION_CF ) ) ) ";
	if( PO4_SF_TO_SED__FL.GetF(FisClamped) ) { u119->AddDependency(PO4_SF_WT); }
	u119->AddDependency(PO4_SF_WT_CONC);
	u119->AddDependency(P_PO4_SED_WT_CONC);
	u119->AddDependency(P_SED_WAT_DIFFUSION_CF);
	u119->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u120 = (TExecuteCommand*) PO4_SF_WT_UPTAK.GetCommand("u120",TCommand::kUpdate,TCommand::kCode);
	u120->SetExecutable(&PO4_SF_WT_UPTAK_u120_exe_g);
	u120->Code() = "u120 <- ( ( PHT_NET_PROD*P_PHY_PC )*1.0 )";
	if( PO4_SF_WT_UPTAK.GetF(FisClamped) ) { u120->AddDependency(PO4_SF_WT); }
	u120->AddDependency(PHT_NET_PROD);
	u120->AddDependency(P_PHY_PC);
	u120->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u122 = (TExecuteCommand*) RIVER_P.GetCommand("u122",TCommand::kUpdate,TCommand::kCode);
	u122->SetExecutable(&RIVER_P_u122_exe_g);
	u122->Code() = "u122 <- 0";
	u122->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u123 = (TExecuteCommand*) P_DETR_PC_RT.GetCommand("u123",TCommand::kUpdate,TCommand::kCode);
	u123->SetExecutable(&P_DETR_PC_RT_u123_exe_g);
	u123->Code() = "u123 <- ( 0.0186*((float)2) )";
	u123->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u124 = (TExecuteCommand*) P_IC_PO4.GetCommand("u124",TCommand::kUpdate,TCommand::kCode);
	u124->SetExecutable(&P_IC_PO4_u124_exe_g);
	u124->Code() = "u124 <- 0.002000";
	u124->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u125 = (TExecuteCommand*) P_PO4_SED_WT_CONC.GetCommand("u125",TCommand::kUpdate,TCommand::kCode);
	u125->SetExecutable(&P_PO4_SED_WT_CONC_u125_exe_g);
	u125->Code() = "u125 <- 1";
	u125->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u126 = (TExecuteCommand*) P_SED_WAT_DIFFUSION_CF.GetCommand("u126",TCommand::kUpdate,TCommand::kCode);
	u126->SetExecutable(&P_SED_WAT_DIFFUSION_CF_u126_exe_g);
	u126->Code() = "u126 <-  ( ( ( BOTTOM_MAP == ((float)1) ) ) ? ( 0.001 ) : ( ((float)0) ) ) ";
	u126->AddDependency(BOTTOM_MAP);
	u126->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int PHOSPHATE_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int PHOSPHATE_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int PHOSPHATE_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int PHOSPHATE_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class PHYTOPLANKTON_module 
// ---------------------------------------------------------------------------
PHYTOPLANKTON_module::PHYTOPLANKTON_module(char* name) :
	TIME("TIME"),
	PHYTOPLANKTON("PHYTOPLANKTON"),
	PHT_MORTALITY("PHT_MORTALITY"),
	PHT_NET_PROD("PHT_NET_PROD"),
	P_PHT_NC("P_PHT_NC"),
	PHT_CONC("PHT_CONC"),
	P_PHY_PC("P_PHY_PC"),
	SF_WATER("SF_WATER"),
	CONS_INGEST_PHT("CONS_INGEST_PHT"),
	LIGHT_TO_PHYTOPLANKTON("LIGHT_TO_PHYTOPLANKTON"),
	DIN_CONC("DIN_CONC"),
	PO4_SF_WT_CONC("PO4_SF_WT_CONC"),
	OM3_TEMP("OM3_TEMP"),
	P_CHL_A_MAP("P_CHL_A_MAP"),
	P_IC_PHT("P_IC_PHT"),
	PHT_GROSS_PP("PHT_GROSS_PP"),
	PHT_RESP("PHT_RESP"),
	PHT_CONSUMED("PHT_CONSUMED"),
	PHT_LIGHT_LIM("PHT_LIGHT_LIM"),
	PHT_NUT_LIMIT("PHT_NUT_LIMIT"),
	PHT_PROD_LIM("PHT_PROD_LIM"),
	PHT_TEMP_LIM("PHT_TEMP_LIM"),
	RIVER_PHT("RIVER_PHT"),
	P_PHT_GROSS_PP_RT("P_PHT_GROSS_PP_RT"),
	P_PHT_MAX_T("P_PHT_MAX_T"),
	P_PHT_MIN_T("P_PHT_MIN_T"),
	P_PHT_MORTALITY_RT("P_PHT_MORTALITY_RT"),
	P_PHT_N_SAT("P_PHT_N_SAT"),
	P_PHT_OPT_T("P_PHT_OPT_T"),
	P_PHT_P_SAT("P_PHT_P_SAT"),
	P_PHT_RESP_RT("P_PHT_RESP_RT"),
	CHL_CONC("CHL_CONC"),
	CHL_CONV_FACTOR("CHL_CONV_FACTOR"),
	TModule(name) {

	PHYTOPLANKTON.SetF(FisExport,True,"CG");
	PHYTOPLANKTON.SetF(FHasNegFlux,True,"CG");
	PHT_MORTALITY.SetF(FisExport,True,"CG");
	PHT_MORTALITY.SetF(FHasNegFlux,True,"CG");
	PHT_NET_PROD.SetF(FisExport,True,"CG");
	P_PHT_NC.SetF(FisExport,True,"CG");
	PHT_CONC.SetF(FisExport,True,"CG");
	P_PHY_PC.SetF(FisExport,True,"CG");
	SF_WATER.SetF(FisImport,True,"CG");
	CONS_INGEST_PHT.SetF(FisImport,True,"CG");
	LIGHT_TO_PHYTOPLANKTON.SetF(FisImport,True,"CG");
	DIN_CONC.SetF(FisImport,True,"CG");
	PO4_SF_WT_CONC.SetF(FisImport,True,"CG");
	OM3_TEMP.SetF(FisImport,True,"CG");
	P_CHL_A_MAP.SetF(FisImport,True,"CG");
	P_IC_PHT.SetF(FisExport,True,"CG");
	PHT_RESP.SetF(FHasNegFlux,True,"CG");
	PHT_CONSUMED.SetF(FHasNegFlux,True,"CG");
}	
int PHYTOPLANKTON_module::PHYTOPLANKTON_I127_exe() {
	float value;
	int array_index[64];


	PHYTOPLANKTON.UpdateIntegrator();
	switch( PHYTOPLANKTON.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* PHYTOPLANKTON_ptr = PHYTOPLANKTON.DataStart();
		const float* PHYTOPLANKTON_Eptr = PHYTOPLANKTON.GridEnd();
		float dt = dT();
		float* PHYTOPLANKTON_Rptr = PHYTOPLANKTON.RDataStart();
		float* PHT_GROSS_PP_ptr = PHT_GROSS_PP.DataStart();
		float* PHT_RESP_ptr = PHT_RESP.DataStart();
		float* PHT_CONSUMED_ptr = PHT_CONSUMED.DataStart();
		float* PHT_MORTALITY_ptr = PHT_MORTALITY.DataStart();
		switch( PHYTOPLANKTON.CurrentOrder() ) {
		  case 1: {
			if( PHYTOPLANKTON.Order() > 1 ) {
			float *PHYTOPLANKTON_IMptr0 = PHYTOPLANKTON.SIntegratorMemory().LastData();
			while( PHYTOPLANKTON_ptr < PHYTOPLANKTON_Eptr ) {
		 value =  ( ( ( (*(PHT_GROSS_PP_ptr))-(*(PHT_RESP_ptr)) )-(*(PHT_CONSUMED_ptr)) )-(*(PHT_MORTALITY_ptr)) );
				*PHYTOPLANKTON_ptr += value*dt;
				if(PHYTOPLANKTON_Rptr) { *PHYTOPLANKTON_Rptr++ = *PHYTOPLANKTON_ptr; }
				*PHYTOPLANKTON_IMptr0++ = value;
				PHYTOPLANKTON_ptr++;
				PHT_GROSS_PP.UpdateDataPtr(PHT_GROSS_PP_ptr);
				PHT_RESP.UpdateDataPtr(PHT_RESP_ptr);
				PHT_CONSUMED.UpdateDataPtr(PHT_CONSUMED_ptr);
				PHT_MORTALITY.UpdateDataPtr(PHT_MORTALITY_ptr);
			}
			} else {
			while( PHYTOPLANKTON_ptr < PHYTOPLANKTON_Eptr ) {
		 value =  ( ( ( (*(PHT_GROSS_PP_ptr))-(*(PHT_RESP_ptr)) )-(*(PHT_CONSUMED_ptr)) )-(*(PHT_MORTALITY_ptr)) );
				*PHYTOPLANKTON_ptr += value*dt;
				if(PHYTOPLANKTON_Rptr) { *PHYTOPLANKTON_Rptr++ = *PHYTOPLANKTON_ptr; }
				PHYTOPLANKTON_ptr++;
				PHT_GROSS_PP.UpdateDataPtr(PHT_GROSS_PP_ptr);
				PHT_RESP.UpdateDataPtr(PHT_RESP_ptr);
				PHT_CONSUMED.UpdateDataPtr(PHT_CONSUMED_ptr);
				PHT_MORTALITY.UpdateDataPtr(PHT_MORTALITY_ptr);
			}
			};
		  } break; case 2: {
			float *PHYTOPLANKTON_IMptr0 = PHYTOPLANKTON.SIntegratorMemory().LastData();
			float *PHYTOPLANKTON_IMptr1 = PHYTOPLANKTON.SIntegratorMemory().LastDataOffset(1);
			while( PHYTOPLANKTON_ptr < PHYTOPLANKTON_Eptr ) {
		 value =  ( ( ( (*(PHT_GROSS_PP_ptr))-(*(PHT_RESP_ptr)) )-(*(PHT_CONSUMED_ptr)) )-(*(PHT_MORTALITY_ptr)) );
				*PHYTOPLANKTON_IMptr0++ = value;
				*PHYTOPLANKTON_ptr += ( 1.5*value - 0.5* *PHYTOPLANKTON_IMptr1++ )*dt;
				if(PHYTOPLANKTON_Rptr) { *PHYTOPLANKTON_Rptr++ = *PHYTOPLANKTON_ptr; }
				PHYTOPLANKTON_ptr++;
				PHT_GROSS_PP.UpdateDataPtr(PHT_GROSS_PP_ptr);
				PHT_RESP.UpdateDataPtr(PHT_RESP_ptr);
				PHT_CONSUMED.UpdateDataPtr(PHT_CONSUMED_ptr);
				PHT_MORTALITY.UpdateDataPtr(PHT_MORTALITY_ptr);
			}
		  } break; case 3: {
			float *PHYTOPLANKTON_IMptr0 = PHYTOPLANKTON.SIntegratorMemory().LastData();
			float *PHYTOPLANKTON_IMptr1 = PHYTOPLANKTON.SIntegratorMemory().LastDataOffset(1);
			float *PHYTOPLANKTON_IMptr2 = PHYTOPLANKTON.SIntegratorMemory().LastDataOffset(2);
			while( PHYTOPLANKTON_ptr < PHYTOPLANKTON_Eptr ) {
		 value =  ( ( ( (*(PHT_GROSS_PP_ptr))-(*(PHT_RESP_ptr)) )-(*(PHT_CONSUMED_ptr)) )-(*(PHT_MORTALITY_ptr)) );
				*PHYTOPLANKTON_IMptr0++ = value;
				*PHYTOPLANKTON_ptr += (1.92*value - 1.33* *PHYTOPLANKTON_IMptr1++ + .42* *PHYTOPLANKTON_IMptr2++)*dt;
				if(PHYTOPLANKTON_Rptr) { *PHYTOPLANKTON_Rptr++ = *PHYTOPLANKTON_ptr; }
				PHYTOPLANKTON_ptr++;
				PHT_GROSS_PP.UpdateDataPtr(PHT_GROSS_PP_ptr);
				PHT_RESP.UpdateDataPtr(PHT_RESP_ptr);
				PHT_CONSUMED.UpdateDataPtr(PHT_CONSUMED_ptr);
				PHT_MORTALITY.UpdateDataPtr(PHT_MORTALITY_ptr);
			}
		  } break; case 4: {
			float *PHYTOPLANKTON_IMptr0 = PHYTOPLANKTON.SIntegratorMemory().LastData();
			float *PHYTOPLANKTON_IMptr1 = PHYTOPLANKTON.SIntegratorMemory().LastDataOffset(1);
			float *PHYTOPLANKTON_IMptr2 = PHYTOPLANKTON.SIntegratorMemory().LastDataOffset(2);
			float *PHYTOPLANKTON_IMptr3 = PHYTOPLANKTON.SIntegratorMemory().LastDataOffset(3);
			while( PHYTOPLANKTON_ptr < PHYTOPLANKTON_Eptr ) {
		 value =  ( ( ( (*(PHT_GROSS_PP_ptr))-(*(PHT_RESP_ptr)) )-(*(PHT_CONSUMED_ptr)) )-(*(PHT_MORTALITY_ptr)) );
				*PHYTOPLANKTON_IMptr0++ = value;
				*PHYTOPLANKTON_ptr += (2.29*value - 2.46* *PHYTOPLANKTON_IMptr1++  + 1.54* *PHYTOPLANKTON_IMptr2++ - .375* *PHYTOPLANKTON_IMptr3++ )*dt;
				if(PHYTOPLANKTON_Rptr) { *PHYTOPLANKTON_Rptr++ = *PHYTOPLANKTON_ptr; }
				PHYTOPLANKTON_ptr++;
				PHT_GROSS_PP.UpdateDataPtr(PHT_GROSS_PP_ptr);
				PHT_RESP.UpdateDataPtr(PHT_RESP_ptr);
				PHT_CONSUMED.UpdateDataPtr(PHT_CONSUMED_ptr);
				PHT_MORTALITY.UpdateDataPtr(PHT_MORTALITY_ptr);
			}
		  } break; default: { gPrintErr("Illegal Order in StateVar update!"); }
		};
		PHYTOPLANKTON.GrabMemory();
		if( PHYTOPLANKTON.GetF(FLinkEdges) ) { PHYTOPLANKTON.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHYTOPLANKTON.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( ( PHT_GROSS_PP.Value(p)-PHT_RESP.Value(p) )-PHT_CONSUMED.Value(p) )-PHT_MORTALITY.Value(p) );
			PHYTOPLANKTON.Update( p, value, dT() );
		}
		PHYTOPLANKTON.GrabMemory();
		if( PHYTOPLANKTON.GetF(FLinkEdges) ) { PHYTOPLANKTON.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( ( PHT_GROSS_PP.Value()-PHT_RESP.Value() )-PHT_CONSUMED.Value() )-PHT_MORTALITY.Value() );
			PHYTOPLANKTON.Update( value, dT() );
	  } break;
	}
	PHYTOPLANKTON.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::PHYTOPLANKTON_i128_exe() {
	float value;
	int array_index[64];


	switch( PHYTOPLANKTON.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* PHYTOPLANKTON_ptr = PHYTOPLANKTON.DataStart();
		const float* PHYTOPLANKTON_Eptr = PHYTOPLANKTON.GridEnd();
		float dt = dT();
		float* PHYTOPLANKTON_Rptr = PHYTOPLANKTON.RDataStart();
		float* CHL_CONC_ptr = CHL_CONC.DataStart();
		float* CHL_CONV_FACTOR_ptr = CHL_CONV_FACTOR.DataStart();
		while( PHYTOPLANKTON_ptr < PHYTOPLANKTON_Eptr ) {
		 value =  ( (*(CHL_CONC_ptr))*(*(CHL_CONV_FACTOR_ptr)) );
			if(PHYTOPLANKTON_Rptr) { *PHYTOPLANKTON_Rptr = *PHYTOPLANKTON_ptr = value;  PHYTOPLANKTON_Rptr++; }
			else { *PHYTOPLANKTON_ptr = value; }
			PHYTOPLANKTON_ptr++;
			CHL_CONC.UpdateDataPtr(CHL_CONC_ptr);
			CHL_CONV_FACTOR.UpdateDataPtr(CHL_CONV_FACTOR_ptr);
		}
		PHYTOPLANKTON.GrabMemory();
		if( PHYTOPLANKTON.GetF(FLinkEdges) ) { PHYTOPLANKTON.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHYTOPLANKTON.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( CHL_CONC.Value(p)*CHL_CONV_FACTOR.Value(p) );
			PHYTOPLANKTON.InitValue( p, value );
		}
		PHYTOPLANKTON.GrabMemory();
		if( PHYTOPLANKTON.GetF(FLinkEdges) ) { PHYTOPLANKTON.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( CHL_CONC.Value()*CHL_CONV_FACTOR.Value() );
			PHYTOPLANKTON.InitValue( value );
	  } break;
	}
	PHYTOPLANKTON.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::PHT_GROSS_PP_u129_exe() {
	float value;
	int array_index[64];


	switch( PHT_GROSS_PP.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* PHT_GROSS_PP_ptr = PHT_GROSS_PP.DataStart();
		const float* PHT_GROSS_PP_Eptr = PHT_GROSS_PP.GridEnd();
		float dt = dT();
		float* PHT_PROD_LIM_ptr = PHT_PROD_LIM.DataStart();
		float* P_PHT_GROSS_PP_RT_ptr = P_PHT_GROSS_PP_RT.DataStart();
		float* PHYTOPLANKTON_ptr = PHYTOPLANKTON.DataStart();
		int clamped = 0;
		while( PHT_GROSS_PP_ptr < PHT_GROSS_PP_Eptr ) {
		 value =  ( ( (*(PHT_PROD_LIM_ptr))*(*(P_PHT_GROSS_PP_RT_ptr)) )*( (*(PHYTOPLANKTON_ptr))/60 ) );
			*PHT_GROSS_PP_ptr = value;
			PHT_GROSS_PP_ptr++;
			PHT_PROD_LIM.UpdateDataPtr(PHT_PROD_LIM_ptr);
			P_PHT_GROSS_PP_RT.UpdateDataPtr(P_PHT_GROSS_PP_RT_ptr);
			PHYTOPLANKTON.UpdateDataPtr(PHYTOPLANKTON_ptr);
		}
		if( PHT_GROSS_PP.GetF(FICFlux) ) PHT_GROSS_PP.Cov().Set(0.0); 
		PHT_GROSS_PP.GrabMemory();
		if( PHT_GROSS_PP.GetF(FLinkEdges) ) { PHT_GROSS_PP.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_GROSS_PP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( PHT_PROD_LIM.Value(p)*P_PHT_GROSS_PP_RT.Value(p) )*( PHYTOPLANKTON.Value(p)/60 ) );
			PHT_GROSS_PP.Update( p, value );
		}
		PHT_GROSS_PP.GrabMemory();
		if( PHT_GROSS_PP.GetF(FICFlux) ) PHT_GROSS_PP.Cov().Set(0.0); 
		if( PHT_GROSS_PP.GetF(FLinkEdges) ) { PHT_GROSS_PP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( PHT_PROD_LIM.Value()*P_PHT_GROSS_PP_RT.Value() )*( PHYTOPLANKTON.Value()/60 ) );
			PHT_GROSS_PP.Update( value );
	  } break;
	}
	PHT_GROSS_PP.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::PHT_RESP_u130_exe() {
	float value;
	int array_index[64];


	switch( PHT_RESP.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* PHT_RESP_ptr = PHT_RESP.DataStart();
		const float* PHT_RESP_Eptr = PHT_RESP.GridEnd();
		float dt = dT();
		float* PHT_RESP_Optr = ((CStateVariable*)(PHT_RESP.Origin()))->RDataStart();
		float* SF_WATER_ptr = SF_WATER.DataStart();
		float* P_PHT_RESP_RT_ptr = P_PHT_RESP_RT.DataStart();
		float* PHT_TEMP_LIM_ptr = PHT_TEMP_LIM.DataStart();
		float* PHYTOPLANKTON_ptr = PHYTOPLANKTON.DataStart();
		float* PHT_GROSS_PP_ptr = PHT_GROSS_PP.DataStart();
		int clamped = PHYTOPLANKTON.GetF(FisClamped);
		while( PHT_RESP_ptr < PHT_RESP_Eptr ) {
		 value =   ( ( ( (*(SF_WATER_ptr)) >  ((float)0) ) ) ? ( SL::Min(( ( ( (*(P_PHT_RESP_RT_ptr))*(*(PHT_TEMP_LIM_ptr)) )*(*(PHYTOPLANKTON_ptr)) )*dT() ), (*(PHT_GROSS_PP_ptr))) ) : ( ((float)0) ) ) ;
			*PHT_RESP_ptr = value;
			if( clamped ) { SL::Clamp(PHT_RESP_Optr++,PHT_RESP_ptr,dt); }
			PHT_RESP_ptr++;
			SF_WATER.UpdateDataPtr(SF_WATER_ptr);
			P_PHT_RESP_RT.UpdateDataPtr(P_PHT_RESP_RT_ptr);
			PHT_TEMP_LIM.UpdateDataPtr(PHT_TEMP_LIM_ptr);
			PHYTOPLANKTON.UpdateDataPtr(PHYTOPLANKTON_ptr);
			PHT_GROSS_PP.UpdateDataPtr(PHT_GROSS_PP_ptr);
		}
		if( PHT_RESP.GetF(FICFlux) ) PHT_RESP.Cov().Set(0.0); 
		PHT_RESP.GrabMemory();
		if( PHT_RESP.GetF(FLinkEdges) ) { PHT_RESP.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_RESP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( SF_WATER.Value(p) >  ((float)0) ) ) ? ( SL::Min(( ( ( P_PHT_RESP_RT.Value(p)*PHT_TEMP_LIM.Value(p) )*PHYTOPLANKTON.Value(p) )*dT() ), PHT_GROSS_PP.Value(p)) ) : ( ((float)0) ) ) ;
			PHT_RESP.Update( p, value );
		}
		PHT_RESP.GrabMemory();
		if( PHT_RESP.GetF(FICFlux) ) PHT_RESP.Cov().Set(0.0); 
		if( PHT_RESP.GetF(FLinkEdges) ) { PHT_RESP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( SF_WATER.Value() >  ((float)0) ) ) ? ( SL::Min(( ( ( P_PHT_RESP_RT.Value()*PHT_TEMP_LIM.Value() )*PHYTOPLANKTON.Value() )*dT() ), PHT_GROSS_PP.Value()) ) : ( ((float)0) ) ) ;
			PHT_RESP.Update( value );
	  } break;
	}
	PHT_RESP.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::PHT_CONSUMED_u131_exe() {
	float value;
	int array_index[64];


	switch( PHT_CONSUMED.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* PHT_CONSUMED_ptr = PHT_CONSUMED.DataStart();
		const float* PHT_CONSUMED_Eptr = PHT_CONSUMED.GridEnd();
		float dt = dT();
		float* PHT_CONSUMED_Optr = ((CStateVariable*)(PHT_CONSUMED.Origin()))->RDataStart();
		float* CONS_INGEST_PHT_ptr = CONS_INGEST_PHT.DataStart();
		int clamped = PHYTOPLANKTON.GetF(FisClamped);
		while( PHT_CONSUMED_ptr < PHT_CONSUMED_Eptr ) {
		 value =  (*(CONS_INGEST_PHT_ptr));
			*PHT_CONSUMED_ptr = value;
			if( clamped ) { SL::Clamp(PHT_CONSUMED_Optr++,PHT_CONSUMED_ptr,dt); }
			PHT_CONSUMED_ptr++;
			CONS_INGEST_PHT.UpdateDataPtr(CONS_INGEST_PHT_ptr);
		}
		if( PHT_CONSUMED.GetF(FICFlux) ) PHT_CONSUMED.Cov().Set(0.0); 
		PHT_CONSUMED.GrabMemory();
		if( PHT_CONSUMED.GetF(FLinkEdges) ) { PHT_CONSUMED.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_CONSUMED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  CONS_INGEST_PHT.Value(p);
			PHT_CONSUMED.Update( p, value );
		}
		PHT_CONSUMED.GrabMemory();
		if( PHT_CONSUMED.GetF(FICFlux) ) PHT_CONSUMED.Cov().Set(0.0); 
		if( PHT_CONSUMED.GetF(FLinkEdges) ) { PHT_CONSUMED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  CONS_INGEST_PHT.Value();
			PHT_CONSUMED.Update( value );
	  } break;
	}
	PHT_CONSUMED.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::PHT_MORTALITY_u132_exe() {
	float value;
	int array_index[64];


	switch( PHT_MORTALITY.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* PHT_MORTALITY_ptr = PHT_MORTALITY.DataStart();
		const float* PHT_MORTALITY_Eptr = PHT_MORTALITY.GridEnd();
		float dt = dT();
		float* PHT_MORTALITY_Optr = ((CStateVariable*)(PHT_MORTALITY.Origin()))->RDataStart();
		float* PHYTOPLANKTON_ptr = PHYTOPLANKTON.DataStart();
		float* P_PHT_MORTALITY_RT_ptr = P_PHT_MORTALITY_RT.DataStart();
		int clamped = PHYTOPLANKTON.GetF(FisClamped);
		while( PHT_MORTALITY_ptr < PHT_MORTALITY_Eptr ) {
		 value =  ( (*(PHYTOPLANKTON_ptr))*( (*(P_PHT_MORTALITY_RT_ptr))*dT() ) );
			*PHT_MORTALITY_ptr = value;
			if( clamped ) { SL::Clamp(PHT_MORTALITY_Optr++,PHT_MORTALITY_ptr,dt); }
			PHT_MORTALITY_ptr++;
			PHYTOPLANKTON.UpdateDataPtr(PHYTOPLANKTON_ptr);
			P_PHT_MORTALITY_RT.UpdateDataPtr(P_PHT_MORTALITY_RT_ptr);
		}
		if( PHT_MORTALITY.GetF(FICFlux) ) PHT_MORTALITY.Cov().Set(0.0); 
		PHT_MORTALITY.GrabMemory();
		if( PHT_MORTALITY.GetF(FLinkEdges) ) { PHT_MORTALITY.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_MORTALITY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( PHYTOPLANKTON.Value(p)*( P_PHT_MORTALITY_RT.Value(p)*dT() ) );
			PHT_MORTALITY.Update( p, value );
		}
		PHT_MORTALITY.GrabMemory();
		if( PHT_MORTALITY.GetF(FICFlux) ) PHT_MORTALITY.Cov().Set(0.0); 
		if( PHT_MORTALITY.GetF(FLinkEdges) ) { PHT_MORTALITY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( PHYTOPLANKTON.Value()*( P_PHT_MORTALITY_RT.Value()*dT() ) );
			PHT_MORTALITY.Update( value );
	  } break;
	}
	PHT_MORTALITY.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::PHT_CONC_u133_exe() {
	float value;
	int array_index[64];


	switch( PHT_CONC.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* PHT_CONC_ptr = PHT_CONC.DataStart();
		const float* PHT_CONC_Eptr = PHT_CONC.GridEnd();
		float* RIVER_PHT_ptr = RIVER_PHT.DataStart();
		float* PHYTOPLANKTON_ptr = PHYTOPLANKTON.DataStart();
		float* SF_WATER_ptr = SF_WATER.DataStart();
		while( PHT_CONC_ptr < PHT_CONC_Eptr ) {
		 value =  SL::Max(( (*(RIVER_PHT_ptr))+( (*(PHYTOPLANKTON_ptr))/(*(SF_WATER_ptr)) ) ), ((float)0));
			*PHT_CONC_ptr = value;
			PHT_CONC_ptr++;
			RIVER_PHT.UpdateDataPtr(RIVER_PHT_ptr);
			PHYTOPLANKTON.UpdateDataPtr(PHYTOPLANKTON_ptr);
			SF_WATER.UpdateDataPtr(SF_WATER_ptr);
		}
		PHT_CONC.GrabMemory();
		if( PHT_CONC.GetF(FLinkEdges) ) { PHT_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_CONC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  SL::Max(( RIVER_PHT.Value(p)+( PHYTOPLANKTON.Value(p)/SF_WATER.Value(p) ) ), ((float)0));
			PHT_CONC.Update( p, value );
		}
		PHT_CONC.GrabMemory();
		if( PHT_CONC.GetF(FLinkEdges) ) { PHT_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  SL::Max(( RIVER_PHT.Value()+( PHYTOPLANKTON.Value()/SF_WATER.Value() ) ), ((float)0));
			PHT_CONC.Update( value );
	  } break;
	}
	PHT_CONC.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::PHT_LIGHT_LIM_u134_exe() {
	float value;
	int array_index[64];


	switch( PHT_LIGHT_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* PHT_LIGHT_LIM_ptr = PHT_LIGHT_LIM.DataStart();
		const float* PHT_LIGHT_LIM_Eptr = PHT_LIGHT_LIM.GridEnd();
		float* LIGHT_TO_PHYTOPLANKTON_ptr = LIGHT_TO_PHYTOPLANKTON.DataStart();
		while( PHT_LIGHT_LIM_ptr < PHT_LIGHT_LIM_Eptr ) {
		 value =  SL::Min(( ((float)3)*(*(LIGHT_TO_PHYTOPLANKTON_ptr)) ), ((float)1));
			*PHT_LIGHT_LIM_ptr = value;
			PHT_LIGHT_LIM_ptr++;
			LIGHT_TO_PHYTOPLANKTON.UpdateDataPtr(LIGHT_TO_PHYTOPLANKTON_ptr);
		}
		PHT_LIGHT_LIM.GrabMemory();
		if( PHT_LIGHT_LIM.GetF(FLinkEdges) ) { PHT_LIGHT_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_LIGHT_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  SL::Min(( ((float)3)*LIGHT_TO_PHYTOPLANKTON.Value(p) ), ((float)1));
			PHT_LIGHT_LIM.Update( p, value );
		}
		PHT_LIGHT_LIM.GrabMemory();
		if( PHT_LIGHT_LIM.GetF(FLinkEdges) ) { PHT_LIGHT_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  SL::Min(( ((float)3)*LIGHT_TO_PHYTOPLANKTON.Value() ), ((float)1));
			PHT_LIGHT_LIM.Update( value );
	  } break;
	}
	PHT_LIGHT_LIM.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::PHT_NET_PROD_u135_exe() {
	float value;
	int array_index[64];


	switch( PHT_NET_PROD.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* PHT_NET_PROD_ptr = PHT_NET_PROD.DataStart();
		const float* PHT_NET_PROD_Eptr = PHT_NET_PROD.GridEnd();
		float* PHT_GROSS_PP_ptr = PHT_GROSS_PP.DataStart();
		float* PHT_RESP_ptr = PHT_RESP.DataStart();
		while( PHT_NET_PROD_ptr < PHT_NET_PROD_Eptr ) {
		 value =  ( (*(PHT_GROSS_PP_ptr))-(*(PHT_RESP_ptr)) );
			*PHT_NET_PROD_ptr = value;
			PHT_NET_PROD_ptr++;
			PHT_GROSS_PP.UpdateDataPtr(PHT_GROSS_PP_ptr);
			PHT_RESP.UpdateDataPtr(PHT_RESP_ptr);
		}
		PHT_NET_PROD.GrabMemory();
		if( PHT_NET_PROD.GetF(FLinkEdges) ) { PHT_NET_PROD.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_NET_PROD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( PHT_GROSS_PP.Value(p)-PHT_RESP.Value(p) );
			PHT_NET_PROD.Update( p, value );
		}
		PHT_NET_PROD.GrabMemory();
		if( PHT_NET_PROD.GetF(FLinkEdges) ) { PHT_NET_PROD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( PHT_GROSS_PP.Value()-PHT_RESP.Value() );
			PHT_NET_PROD.Update( value );
	  } break;
	}
	PHT_NET_PROD.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::PHT_NUT_LIMIT_u136_exe() {
	float value;
	int array_index[64];


	switch( PHT_NUT_LIMIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* PHT_NUT_LIMIT_ptr = PHT_NUT_LIMIT.DataStart();
		const float* PHT_NUT_LIMIT_Eptr = PHT_NUT_LIMIT.GridEnd();
		float* DIN_CONC_ptr = DIN_CONC.DataStart();
		float* P_PHT_N_SAT_ptr = P_PHT_N_SAT.DataStart();
		float* PO4_SF_WT_CONC_ptr = PO4_SF_WT_CONC.DataStart();
		float* P_PHT_P_SAT_ptr = P_PHT_P_SAT.DataStart();
		while( PHT_NUT_LIMIT_ptr < PHT_NUT_LIMIT_Eptr ) {
		 value =  SL::Min(( (*(DIN_CONC_ptr))/( (*(DIN_CONC_ptr))+(*(P_PHT_N_SAT_ptr)) ) ), ( (*(PO4_SF_WT_CONC_ptr))/( (*(PO4_SF_WT_CONC_ptr))+(*(P_PHT_P_SAT_ptr)) ) ));
			*PHT_NUT_LIMIT_ptr = value;
			PHT_NUT_LIMIT_ptr++;
			DIN_CONC.UpdateDataPtr(DIN_CONC_ptr);
			P_PHT_N_SAT.UpdateDataPtr(P_PHT_N_SAT_ptr);
			PO4_SF_WT_CONC.UpdateDataPtr(PO4_SF_WT_CONC_ptr);
			P_PHT_P_SAT.UpdateDataPtr(P_PHT_P_SAT_ptr);
		}
		PHT_NUT_LIMIT.GrabMemory();
		if( PHT_NUT_LIMIT.GetF(FLinkEdges) ) { PHT_NUT_LIMIT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_NUT_LIMIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  SL::Min(( DIN_CONC.Value(p)/( DIN_CONC.Value(p)+P_PHT_N_SAT.Value(p) ) ), ( PO4_SF_WT_CONC.Value(p)/( PO4_SF_WT_CONC.Value(p)+P_PHT_P_SAT.Value(p) ) ));
			PHT_NUT_LIMIT.Update( p, value );
		}
		PHT_NUT_LIMIT.GrabMemory();
		if( PHT_NUT_LIMIT.GetF(FLinkEdges) ) { PHT_NUT_LIMIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  SL::Min(( DIN_CONC.Value()/( DIN_CONC.Value()+P_PHT_N_SAT.Value() ) ), ( PO4_SF_WT_CONC.Value()/( PO4_SF_WT_CONC.Value()+P_PHT_P_SAT.Value() ) ));
			PHT_NUT_LIMIT.Update( value );
	  } break;
	}
	PHT_NUT_LIMIT.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::PHT_PROD_LIM_u137_exe() {
	float value;
	int array_index[64];


	switch( PHT_PROD_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* PHT_PROD_LIM_ptr = PHT_PROD_LIM.DataStart();
		const float* PHT_PROD_LIM_Eptr = PHT_PROD_LIM.GridEnd();
		float* SF_WATER_ptr = SF_WATER.DataStart();
		float* PHT_LIGHT_LIM_ptr = PHT_LIGHT_LIM.DataStart();
		float* PHT_NUT_LIMIT_ptr = PHT_NUT_LIMIT.DataStart();
		float* PHT_TEMP_LIM_ptr = PHT_TEMP_LIM.DataStart();
		while( PHT_PROD_LIM_ptr < PHT_PROD_LIM_Eptr ) {
		 value =   ( ( ( (*(SF_WATER_ptr)) >  ((float)0) ) ) ? ( SL::Min((*(PHT_LIGHT_LIM_ptr)), (*(PHT_NUT_LIMIT_ptr)), (*(PHT_TEMP_LIM_ptr))) ) : ( ((float)0) ) ) ;
			*PHT_PROD_LIM_ptr = value;
			PHT_PROD_LIM_ptr++;
			SF_WATER.UpdateDataPtr(SF_WATER_ptr);
			PHT_LIGHT_LIM.UpdateDataPtr(PHT_LIGHT_LIM_ptr);
			PHT_NUT_LIMIT.UpdateDataPtr(PHT_NUT_LIMIT_ptr);
			PHT_TEMP_LIM.UpdateDataPtr(PHT_TEMP_LIM_ptr);
		}
		PHT_PROD_LIM.GrabMemory();
		if( PHT_PROD_LIM.GetF(FLinkEdges) ) { PHT_PROD_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_PROD_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( SF_WATER.Value(p) >  ((float)0) ) ) ? ( SL::Min(PHT_LIGHT_LIM.Value(p), PHT_NUT_LIMIT.Value(p), PHT_TEMP_LIM.Value(p)) ) : ( ((float)0) ) ) ;
			PHT_PROD_LIM.Update( p, value );
		}
		PHT_PROD_LIM.GrabMemory();
		if( PHT_PROD_LIM.GetF(FLinkEdges) ) { PHT_PROD_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( SF_WATER.Value() >  ((float)0) ) ) ? ( SL::Min(PHT_LIGHT_LIM.Value(), PHT_NUT_LIMIT.Value(), PHT_TEMP_LIM.Value()) ) : ( ((float)0) ) ) ;
			PHT_PROD_LIM.Update( value );
	  } break;
	}
	PHT_PROD_LIM.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::PHT_TEMP_LIM_u138_exe() {
	float value;
	int array_index[64];


	switch( PHT_TEMP_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* PHT_TEMP_LIM_ptr = PHT_TEMP_LIM.DataStart();
		const float* PHT_TEMP_LIM_Eptr = PHT_TEMP_LIM.GridEnd();
		float* OM3_TEMP_ptr = OM3_TEMP.DataStart();
		float* P_PHT_MAX_T_ptr = P_PHT_MAX_T.DataStart();
		float* P_PHT_MIN_T_ptr = P_PHT_MIN_T.DataStart();
		float* P_PHT_OPT_T_ptr = P_PHT_OPT_T.DataStart();
		while( PHT_TEMP_LIM_ptr < PHT_TEMP_LIM_Eptr ) {
		 value =   ( ( ( ( (*(OM3_TEMP_ptr)) >  (*(P_PHT_MAX_T_ptr)) ) || ( (*(OM3_TEMP_ptr)) <  (*(P_PHT_MIN_T_ptr)) ) ) ) ? ( ((float)0) ) : ( ( ((float)1)-SL::Abs(( ( (*(OM3_TEMP_ptr))-(*(P_PHT_OPT_T_ptr)) )/( (*(OM3_TEMP_ptr))+(*(P_PHT_OPT_T_ptr)) ) )) ) ) ) ;
			*PHT_TEMP_LIM_ptr = value;
			PHT_TEMP_LIM_ptr++;
			OM3_TEMP.UpdateDataPtr(OM3_TEMP_ptr);
			P_PHT_MAX_T.UpdateDataPtr(P_PHT_MAX_T_ptr);
			P_PHT_MIN_T.UpdateDataPtr(P_PHT_MIN_T_ptr);
			P_PHT_OPT_T.UpdateDataPtr(P_PHT_OPT_T_ptr);
		}
		PHT_TEMP_LIM.GrabMemory();
		if( PHT_TEMP_LIM.GetF(FLinkEdges) ) { PHT_TEMP_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_TEMP_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( ( OM3_TEMP.Value(p) >  P_PHT_MAX_T.Value(p) ) || ( OM3_TEMP.Value(p) <  P_PHT_MIN_T.Value(p) ) ) ) ? ( ((float)0) ) : ( ( ((float)1)-SL::Abs(( ( OM3_TEMP.Value(p)-P_PHT_OPT_T.Value(p) )/( OM3_TEMP.Value(p)+P_PHT_OPT_T.Value(p) ) )) ) ) ) ;
			PHT_TEMP_LIM.Update( p, value );
		}
		PHT_TEMP_LIM.GrabMemory();
		if( PHT_TEMP_LIM.GetF(FLinkEdges) ) { PHT_TEMP_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( ( OM3_TEMP.Value() >  P_PHT_MAX_T.Value() ) || ( OM3_TEMP.Value() <  P_PHT_MIN_T.Value() ) ) ) ? ( ((float)0) ) : ( ( ((float)1)-SL::Abs(( ( OM3_TEMP.Value()-P_PHT_OPT_T.Value() )/( OM3_TEMP.Value()+P_PHT_OPT_T.Value() ) )) ) ) ) ;
			PHT_TEMP_LIM.Update( value );
	  } break;
	}
	PHT_TEMP_LIM.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::RIVER_PHT_u139_exe() {
	float value;
	int array_index[64];


	switch( RIVER_PHT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* RIVER_PHT_ptr = RIVER_PHT.DataStart();
		const float* RIVER_PHT_Eptr = RIVER_PHT.GridEnd();
		 value =  0;
		value = RIVER_PHT.ParameterValue(value);
		while( RIVER_PHT_ptr < RIVER_PHT_Eptr ) {
			*RIVER_PHT_ptr = value;
			RIVER_PHT_ptr++;
		}
		RIVER_PHT.GrabMemory();
		if( RIVER_PHT.GetF(FLinkEdges) ) { RIVER_PHT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = RIVER_PHT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0;
			RIVER_PHT.Update( p, RIVER_PHT.ParameterValue(value,p) );
		}
		RIVER_PHT.GrabMemory();
		if( RIVER_PHT.GetF(FLinkEdges) ) { RIVER_PHT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0;
			RIVER_PHT.Update( RIVER_PHT.ParameterValue(value) );
	  } break;
	}
	RIVER_PHT.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::P_IC_PHT_u140_exe() {
	float value;
	int array_index[64];


	switch( P_IC_PHT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_IC_PHT_ptr = P_IC_PHT.DataStart();
		const float* P_IC_PHT_Eptr = P_IC_PHT.GridEnd();
		float* P_CHL_A_MAP_ptr = P_CHL_A_MAP.DataStart();
		while( P_IC_PHT_ptr < P_IC_PHT_Eptr ) {
		 value =  ( ((float)60)*(*(P_CHL_A_MAP_ptr)) );
			*P_IC_PHT_ptr = value;
			P_IC_PHT_ptr++;
			P_CHL_A_MAP.UpdateDataPtr(P_CHL_A_MAP_ptr);
		}
		P_IC_PHT.GrabMemory();
		if( P_IC_PHT.GetF(FLinkEdges) ) { P_IC_PHT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_IC_PHT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ((float)60)*P_CHL_A_MAP.Value(p) );
			P_IC_PHT.Update( p, value );
		}
		P_IC_PHT.GrabMemory();
		if( P_IC_PHT.GetF(FLinkEdges) ) { P_IC_PHT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ((float)60)*P_CHL_A_MAP.Value() );
			P_IC_PHT.Update( value );
	  } break;
	}
	P_IC_PHT.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::P_PHT_GROSS_PP_RT_u141_exe() {
	float value;
	int array_index[64];


	switch( P_PHT_GROSS_PP_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_PHT_GROSS_PP_RT_ptr = P_PHT_GROSS_PP_RT.DataStart();
		const float* P_PHT_GROSS_PP_RT_Eptr = P_PHT_GROSS_PP_RT.GridEnd();
		float* OM3_TEMP_ptr = OM3_TEMP.DataStart();
		while( P_PHT_GROSS_PP_RT_ptr < P_PHT_GROSS_PP_RT_Eptr ) {
		 value =  ( ((float)24)*SL::Exp(( 0.09*(*(OM3_TEMP_ptr)) )) );
			*P_PHT_GROSS_PP_RT_ptr = value;
			P_PHT_GROSS_PP_RT_ptr++;
			OM3_TEMP.UpdateDataPtr(OM3_TEMP_ptr);
		}
		P_PHT_GROSS_PP_RT.GrabMemory();
		if( P_PHT_GROSS_PP_RT.GetF(FLinkEdges) ) { P_PHT_GROSS_PP_RT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_PHT_GROSS_PP_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ((float)24)*SL::Exp(( 0.09*OM3_TEMP.Value(p) )) );
			P_PHT_GROSS_PP_RT.Update( p, value );
		}
		P_PHT_GROSS_PP_RT.GrabMemory();
		if( P_PHT_GROSS_PP_RT.GetF(FLinkEdges) ) { P_PHT_GROSS_PP_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ((float)24)*SL::Exp(( 0.09*OM3_TEMP.Value() )) );
			P_PHT_GROSS_PP_RT.Update( value );
	  } break;
	}
	P_PHT_GROSS_PP_RT.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::P_PHT_MAX_T_u142_exe() {
	float value;
	int array_index[64];


	switch( P_PHT_MAX_T.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_PHT_MAX_T_ptr = P_PHT_MAX_T.DataStart();
		const float* P_PHT_MAX_T_Eptr = P_PHT_MAX_T.GridEnd();
		 value =  20;
		value = P_PHT_MAX_T.ParameterValue(value);
		while( P_PHT_MAX_T_ptr < P_PHT_MAX_T_Eptr ) {
			*P_PHT_MAX_T_ptr = value;
			P_PHT_MAX_T_ptr++;
		}
		P_PHT_MAX_T.GrabMemory();
		if( P_PHT_MAX_T.GetF(FLinkEdges) ) { P_PHT_MAX_T.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_PHT_MAX_T.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  20;
			P_PHT_MAX_T.Update( p, P_PHT_MAX_T.ParameterValue(value,p) );
		}
		P_PHT_MAX_T.GrabMemory();
		if( P_PHT_MAX_T.GetF(FLinkEdges) ) { P_PHT_MAX_T.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  20;
			P_PHT_MAX_T.Update( P_PHT_MAX_T.ParameterValue(value) );
	  } break;
	}
	P_PHT_MAX_T.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::P_PHT_MIN_T_u143_exe() {
	float value;
	int array_index[64];


	switch( P_PHT_MIN_T.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_PHT_MIN_T_ptr = P_PHT_MIN_T.DataStart();
		const float* P_PHT_MIN_T_Eptr = P_PHT_MIN_T.GridEnd();
		 value =  0;
		value = P_PHT_MIN_T.ParameterValue(value);
		while( P_PHT_MIN_T_ptr < P_PHT_MIN_T_Eptr ) {
			*P_PHT_MIN_T_ptr = value;
			P_PHT_MIN_T_ptr++;
		}
		P_PHT_MIN_T.GrabMemory();
		if( P_PHT_MIN_T.GetF(FLinkEdges) ) { P_PHT_MIN_T.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_PHT_MIN_T.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0;
			P_PHT_MIN_T.Update( p, P_PHT_MIN_T.ParameterValue(value,p) );
		}
		P_PHT_MIN_T.GrabMemory();
		if( P_PHT_MIN_T.GetF(FLinkEdges) ) { P_PHT_MIN_T.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0;
			P_PHT_MIN_T.Update( P_PHT_MIN_T.ParameterValue(value) );
	  } break;
	}
	P_PHT_MIN_T.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::P_PHT_MORTALITY_RT_u144_exe() {
	float value;
	int array_index[64];


	switch( P_PHT_MORTALITY_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_PHT_MORTALITY_RT_ptr = P_PHT_MORTALITY_RT.DataStart();
		const float* P_PHT_MORTALITY_RT_Eptr = P_PHT_MORTALITY_RT.GridEnd();
		 value =  2e-4;
		value = P_PHT_MORTALITY_RT.ParameterValue(value);
		while( P_PHT_MORTALITY_RT_ptr < P_PHT_MORTALITY_RT_Eptr ) {
			*P_PHT_MORTALITY_RT_ptr = value;
			P_PHT_MORTALITY_RT_ptr++;
		}
		P_PHT_MORTALITY_RT.GrabMemory();
		if( P_PHT_MORTALITY_RT.GetF(FLinkEdges) ) { P_PHT_MORTALITY_RT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_PHT_MORTALITY_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  2e-4;
			P_PHT_MORTALITY_RT.Update( p, P_PHT_MORTALITY_RT.ParameterValue(value,p) );
		}
		P_PHT_MORTALITY_RT.GrabMemory();
		if( P_PHT_MORTALITY_RT.GetF(FLinkEdges) ) { P_PHT_MORTALITY_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  2e-4;
			P_PHT_MORTALITY_RT.Update( P_PHT_MORTALITY_RT.ParameterValue(value) );
	  } break;
	}
	P_PHT_MORTALITY_RT.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::P_PHT_NC_u145_exe() {
	float value;
	int array_index[64];


	switch( P_PHT_NC.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_PHT_NC_ptr = P_PHT_NC.DataStart();
		const float* P_PHT_NC_Eptr = P_PHT_NC.GridEnd();
		while( P_PHT_NC_ptr < P_PHT_NC_Eptr ) {
		 value =  ( .016*((float)4) );
			*P_PHT_NC_ptr = value;
			P_PHT_NC_ptr++;
		}
		P_PHT_NC.GrabMemory();
		if( P_PHT_NC.GetF(FLinkEdges) ) { P_PHT_NC.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_PHT_NC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( .016*((float)4) );
			P_PHT_NC.Update( p, value );
		}
		P_PHT_NC.GrabMemory();
		if( P_PHT_NC.GetF(FLinkEdges) ) { P_PHT_NC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( .016*((float)4) );
			P_PHT_NC.Update( value );
	  } break;
	}
	P_PHT_NC.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::P_PHT_N_SAT_u146_exe() {
	float value;
	int array_index[64];


	switch( P_PHT_N_SAT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_PHT_N_SAT_ptr = P_PHT_N_SAT.DataStart();
		const float* P_PHT_N_SAT_Eptr = P_PHT_N_SAT.GridEnd();
		 value =  0.0000025;
		value = P_PHT_N_SAT.ParameterValue(value);
		while( P_PHT_N_SAT_ptr < P_PHT_N_SAT_Eptr ) {
			*P_PHT_N_SAT_ptr = value;
			P_PHT_N_SAT_ptr++;
		}
		P_PHT_N_SAT.GrabMemory();
		if( P_PHT_N_SAT.GetF(FLinkEdges) ) { P_PHT_N_SAT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_PHT_N_SAT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.0000025;
			P_PHT_N_SAT.Update( p, P_PHT_N_SAT.ParameterValue(value,p) );
		}
		P_PHT_N_SAT.GrabMemory();
		if( P_PHT_N_SAT.GetF(FLinkEdges) ) { P_PHT_N_SAT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.0000025;
			P_PHT_N_SAT.Update( P_PHT_N_SAT.ParameterValue(value) );
	  } break;
	}
	P_PHT_N_SAT.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::P_PHT_OPT_T_u147_exe() {
	float value;
	int array_index[64];


	switch( P_PHT_OPT_T.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_PHT_OPT_T_ptr = P_PHT_OPT_T.DataStart();
		const float* P_PHT_OPT_T_Eptr = P_PHT_OPT_T.GridEnd();
		 value =  15;
		value = P_PHT_OPT_T.ParameterValue(value);
		while( P_PHT_OPT_T_ptr < P_PHT_OPT_T_Eptr ) {
			*P_PHT_OPT_T_ptr = value;
			P_PHT_OPT_T_ptr++;
		}
		P_PHT_OPT_T.GrabMemory();
		if( P_PHT_OPT_T.GetF(FLinkEdges) ) { P_PHT_OPT_T.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_PHT_OPT_T.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  15;
			P_PHT_OPT_T.Update( p, P_PHT_OPT_T.ParameterValue(value,p) );
		}
		P_PHT_OPT_T.GrabMemory();
		if( P_PHT_OPT_T.GetF(FLinkEdges) ) { P_PHT_OPT_T.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  15;
			P_PHT_OPT_T.Update( P_PHT_OPT_T.ParameterValue(value) );
	  } break;
	}
	P_PHT_OPT_T.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::P_PHT_P_SAT_u148_exe() {
	float value;
	int array_index[64];


	switch( P_PHT_P_SAT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_PHT_P_SAT_ptr = P_PHT_P_SAT.DataStart();
		const float* P_PHT_P_SAT_Eptr = P_PHT_P_SAT.GridEnd();
		 value =  0.0000001;
		value = P_PHT_P_SAT.ParameterValue(value);
		while( P_PHT_P_SAT_ptr < P_PHT_P_SAT_Eptr ) {
			*P_PHT_P_SAT_ptr = value;
			P_PHT_P_SAT_ptr++;
		}
		P_PHT_P_SAT.GrabMemory();
		if( P_PHT_P_SAT.GetF(FLinkEdges) ) { P_PHT_P_SAT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_PHT_P_SAT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.0000001;
			P_PHT_P_SAT.Update( p, P_PHT_P_SAT.ParameterValue(value,p) );
		}
		P_PHT_P_SAT.GrabMemory();
		if( P_PHT_P_SAT.GetF(FLinkEdges) ) { P_PHT_P_SAT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.0000001;
			P_PHT_P_SAT.Update( P_PHT_P_SAT.ParameterValue(value) );
	  } break;
	}
	P_PHT_P_SAT.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::P_PHT_RESP_RT_u149_exe() {
	float value;
	int array_index[64];


	switch( P_PHT_RESP_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_PHT_RESP_RT_ptr = P_PHT_RESP_RT.DataStart();
		const float* P_PHT_RESP_RT_Eptr = P_PHT_RESP_RT.GridEnd();
		 value =  0.000140;
		value = P_PHT_RESP_RT.ParameterValue(value);
		while( P_PHT_RESP_RT_ptr < P_PHT_RESP_RT_Eptr ) {
			*P_PHT_RESP_RT_ptr = value;
			P_PHT_RESP_RT_ptr++;
		}
		P_PHT_RESP_RT.GrabMemory();
		if( P_PHT_RESP_RT.GetF(FLinkEdges) ) { P_PHT_RESP_RT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_PHT_RESP_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.000140;
			P_PHT_RESP_RT.Update( p, P_PHT_RESP_RT.ParameterValue(value,p) );
		}
		P_PHT_RESP_RT.GrabMemory();
		if( P_PHT_RESP_RT.GetF(FLinkEdges) ) { P_PHT_RESP_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.000140;
			P_PHT_RESP_RT.Update( P_PHT_RESP_RT.ParameterValue(value) );
	  } break;
	}
	P_PHT_RESP_RT.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::P_PHY_PC_u150_exe() {
	float value;
	int array_index[64];


	switch( P_PHY_PC.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_PHY_PC_ptr = P_PHY_PC.DataStart();
		const float* P_PHY_PC_Eptr = P_PHY_PC.GridEnd();
		 value =  0.018600;
		value = P_PHY_PC.ParameterValue(value);
		while( P_PHY_PC_ptr < P_PHY_PC_Eptr ) {
			*P_PHY_PC_ptr = value;
			P_PHY_PC_ptr++;
		}
		P_PHY_PC.GrabMemory();
		if( P_PHY_PC.GetF(FLinkEdges) ) { P_PHY_PC.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_PHY_PC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.018600;
			P_PHY_PC.Update( p, P_PHY_PC.ParameterValue(value,p) );
		}
		P_PHY_PC.GrabMemory();
		if( P_PHY_PC.GetF(FLinkEdges) ) { P_PHY_PC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.018600;
			P_PHY_PC.Update( P_PHY_PC.ParameterValue(value) );
	  } break;
	}
	P_PHY_PC.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::CHL_CONC_u151_exe() {
	float value;
	int array_index[64];


	switch( CHL_CONC.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* CHL_CONC_ptr = CHL_CONC.DataStart();
		const float* CHL_CONC_Eptr = CHL_CONC.GridEnd();
		while( CHL_CONC_ptr < CHL_CONC_Eptr ) {
		 value =  ((float)1);
			*CHL_CONC_ptr = value;
			CHL_CONC_ptr++;
		}
		CHL_CONC.GrabMemory();
		if( CHL_CONC.GetF(FLinkEdges) ) { CHL_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = CHL_CONC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ((float)1);
			CHL_CONC.Update( p, value );
		}
		CHL_CONC.GrabMemory();
		if( CHL_CONC.GetF(FLinkEdges) ) { CHL_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ((float)1);
			CHL_CONC.Update( value );
	  } break;
	}
	CHL_CONC.UpdateGOFComputation();
	return 0;
}

int PHYTOPLANKTON_module::CHL_CONV_FACTOR_u152_exe() {
	float value;
	int array_index[64];


	switch( CHL_CONV_FACTOR.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* CHL_CONV_FACTOR_ptr = CHL_CONV_FACTOR.DataStart();
		const float* CHL_CONV_FACTOR_Eptr = CHL_CONV_FACTOR.GridEnd();
		 value =  0.003;
		value = CHL_CONV_FACTOR.ParameterValue(value);
		while( CHL_CONV_FACTOR_ptr < CHL_CONV_FACTOR_Eptr ) {
			*CHL_CONV_FACTOR_ptr = value;
			CHL_CONV_FACTOR_ptr++;
		}
		CHL_CONV_FACTOR.GrabMemory();
		if( CHL_CONV_FACTOR.GetF(FLinkEdges) ) { CHL_CONV_FACTOR.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = CHL_CONV_FACTOR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.003;
			CHL_CONV_FACTOR.Update( p, CHL_CONV_FACTOR.ParameterValue(value,p) );
		}
		CHL_CONV_FACTOR.GrabMemory();
		if( CHL_CONV_FACTOR.GetF(FLinkEdges) ) { CHL_CONV_FACTOR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.003;
			CHL_CONV_FACTOR.Update( CHL_CONV_FACTOR.ParameterValue(value) );
	  } break;
	}
	CHL_CONV_FACTOR.UpdateGOFComputation();
	return 0;
}

PHYTOPLANKTON_module* PHYTOPLANKTON_module::fInstance = NULL;
PHYTOPLANKTON_module* PHYTOPLANKTON_module::kNullModel = (PHYTOPLANKTON_module*)0x1;
int PHYTOPLANKTON_module::InitVars() {
	TIME.SSInit(this);
	PHYTOPLANKTON.SSInit(this);
	PHYTOPLANKTON.SetLinkEdges();
	PHT_MORTALITY.SSInit(this);
	PHT_MORTALITY.SetOrigin(&PHYTOPLANKTON);
	PHT_NET_PROD.SSInit(this);
	P_PHT_NC.SSInit(this);
	PHT_CONC.SSInit(this);
	P_PHY_PC.SSInit(this);
	SF_WATER.SSInit(this);
	CONS_INGEST_PHT.SSInit(this);
	LIGHT_TO_PHYTOPLANKTON.SSInit(this);
	DIN_CONC.SSInit(this);
	PO4_SF_WT_CONC.SSInit(this);
	OM3_TEMP.SSInit(this);
	P_CHL_A_MAP.SSInit(this);
	P_IC_PHT.SSInit(this);
	PHT_GROSS_PP.SSInit(this);
	PHT_GROSS_PP.SetDestination(&PHYTOPLANKTON);
	PHT_RESP.SSInit(this);
	PHT_RESP.SetOrigin(&PHYTOPLANKTON);
	PHT_CONSUMED.SSInit(this);
	PHT_CONSUMED.SetOrigin(&PHYTOPLANKTON);
	PHT_LIGHT_LIM.SSInit(this);
	PHT_NUT_LIMIT.SSInit(this);
	PHT_PROD_LIM.SSInit(this);
	PHT_TEMP_LIM.SSInit(this);
	RIVER_PHT.SSInit(this);
	P_PHT_GROSS_PP_RT.SSInit(this);
	P_PHT_MAX_T.SSInit(this);
	P_PHT_MIN_T.SSInit(this);
	P_PHT_MORTALITY_RT.SSInit(this);
	P_PHT_N_SAT.SSInit(this);
	P_PHT_OPT_T.SSInit(this);
	P_PHT_P_SAT.SSInit(this);
	P_PHT_RESP_RT.SSInit(this);
	CHL_CONC.SSInit(this);
	CHL_CONV_FACTOR.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int PHYTOPLANKTON_module::SetupEvents() {
	TExecuteCommand* I127 = (TExecuteCommand*) PHYTOPLANKTON.GetCommand("I127",TCommand::kIntegrate,TCommand::kCode);
	I127->SetExecutable(&PHYTOPLANKTON_I127_exe_g);
	I127->Code() = "I127 <- ( ( ( PHT_GROSS_PP-PHT_RESP )-PHT_CONSUMED )-PHT_MORTALITY )";
	I127->AddDependency(PHT_GROSS_PP);
	I127->AddDependency(PHT_RESP);
	I127->AddDependency(PHT_CONSUMED);
	I127->AddDependency(PHT_MORTALITY);
	I127->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i128 = (TExecuteCommand*) PHYTOPLANKTON.GetCommand("i128",TCommand::kInit,TCommand::kCode);
	i128->SetExecutable(&PHYTOPLANKTON_i128_exe_g);
	i128->Code() = "i128 <- ( CHL_CONC*CHL_CONV_FACTOR )";
	i128->AddDependency(CHL_CONC);
	i128->AddDependency(CHL_CONV_FACTOR);
	i128->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u132 = (TExecuteCommand*) PHT_MORTALITY.GetCommand("u132",TCommand::kUpdate,TCommand::kCode);
	u132->SetExecutable(&PHT_MORTALITY_u132_exe_g);
	u132->Code() = "u132 <- ( PHYTOPLANKTON*( P_PHT_MORTALITY_RT*dT() ) )";
	if( PHT_MORTALITY.GetF(FisClamped) ) { u132->AddDependency(PHYTOPLANKTON); }
	u132->AddDependency(PHYTOPLANKTON);
	u132->AddDependency(P_PHT_MORTALITY_RT);
	u132->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u135 = (TExecuteCommand*) PHT_NET_PROD.GetCommand("u135",TCommand::kUpdate,TCommand::kCode);
	u135->SetExecutable(&PHT_NET_PROD_u135_exe_g);
	u135->Code() = "u135 <- ( PHT_GROSS_PP-PHT_RESP )";
	u135->AddDependency(PHT_GROSS_PP);
	u135->AddDependency(PHT_RESP);
	u135->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u145 = (TExecuteCommand*) P_PHT_NC.GetCommand("u145",TCommand::kUpdate,TCommand::kCode);
	u145->SetExecutable(&P_PHT_NC_u145_exe_g);
	u145->Code() = "u145 <- ( .016*((float)4) )";
	u145->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u133 = (TExecuteCommand*) PHT_CONC.GetCommand("u133",TCommand::kUpdate,TCommand::kCode);
	u133->SetExecutable(&PHT_CONC_u133_exe_g);
	u133->Code() = "u133 <- SL::Max(( RIVER_PHT+( PHYTOPLANKTON/SF_WATER ) ), ((float)0))";
	u133->AddDependency(RIVER_PHT);
	u133->AddDependency(PHYTOPLANKTON);
	u133->AddDependency(SF_WATER);
	u133->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u150 = (TExecuteCommand*) P_PHY_PC.GetCommand("u150",TCommand::kUpdate,TCommand::kCode);
	u150->SetExecutable(&P_PHY_PC_u150_exe_g);
	u150->Code() = "u150 <- 0.018600";
	u150->SetObjInfo(TCommand::kDepIndex, 5);
	TImportCommand* SF_WATER_import0 = (TImportCommand*) SF_WATER.GetCommand("SF_WATER_import0",TCommand::kUndefined,TCommand::kImport);
	SF_WATER_import0->Code() = "Import SF_WATER";
	SF_WATER_import0->AddDependency(SF_WATER);
	SF_WATER_import0->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* CONS_INGEST_PHT_import1 = (TImportCommand*) CONS_INGEST_PHT.GetCommand("CONS_INGEST_PHT_import1",TCommand::kUndefined,TCommand::kImport);
	CONS_INGEST_PHT_import1->Code() = "Import CONS_INGEST_PHT";
	CONS_INGEST_PHT_import1->AddDependency(CONS_INGEST_PHT);
	CONS_INGEST_PHT_import1->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* LIGHT_TO_PHYTOPLANKTON_import2 = (TImportCommand*) LIGHT_TO_PHYTOPLANKTON.GetCommand("LIGHT_TO_PHYTOPLANKTON_import2",TCommand::kUndefined,TCommand::kImport);
	LIGHT_TO_PHYTOPLANKTON_import2->Code() = "Import LIGHT_TO_PHYTOPLANKTON";
	LIGHT_TO_PHYTOPLANKTON_import2->AddDependency(LIGHT_TO_PHYTOPLANKTON);
	LIGHT_TO_PHYTOPLANKTON_import2->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DIN_CONC_import3 = (TImportCommand*) DIN_CONC.GetCommand("DIN_CONC_import3",TCommand::kUndefined,TCommand::kImport);
	DIN_CONC_import3->Code() = "Import DIN_CONC";
	DIN_CONC_import3->AddDependency(DIN_CONC);
	DIN_CONC_import3->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PO4_SF_WT_CONC_import4 = (TImportCommand*) PO4_SF_WT_CONC.GetCommand("PO4_SF_WT_CONC_import4",TCommand::kUndefined,TCommand::kImport);
	PO4_SF_WT_CONC_import4->Code() = "Import PO4_SF_WT_CONC";
	PO4_SF_WT_CONC_import4->AddDependency(PO4_SF_WT_CONC);
	PO4_SF_WT_CONC_import4->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* OM3_TEMP_import5 = (TImportCommand*) OM3_TEMP.GetCommand("OM3_TEMP_import5",TCommand::kUndefined,TCommand::kImport);
	OM3_TEMP_import5->Code() = "Import OM3_TEMP";
	OM3_TEMP_import5->AddDependency(OM3_TEMP);
	OM3_TEMP_import5->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P_CHL_A_MAP_import6 = (TImportCommand*) P_CHL_A_MAP.GetCommand("P_CHL_A_MAP_import6",TCommand::kUndefined,TCommand::kImport);
	P_CHL_A_MAP_import6->Code() = "Import P_CHL_A_MAP";
	P_CHL_A_MAP_import6->AddDependency(P_CHL_A_MAP);
	P_CHL_A_MAP_import6->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u140 = (TExecuteCommand*) P_IC_PHT.GetCommand("u140",TCommand::kUpdate,TCommand::kCode);
	u140->SetExecutable(&P_IC_PHT_u140_exe_g);
	u140->Code() = "u140 <- ( ((float)60)*P_CHL_A_MAP )";
	u140->AddDependency(P_CHL_A_MAP);
	u140->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u129 = (TExecuteCommand*) PHT_GROSS_PP.GetCommand("u129",TCommand::kUpdate,TCommand::kCode);
	u129->SetExecutable(&PHT_GROSS_PP_u129_exe_g);
	u129->Code() = "u129 <- ( ( PHT_PROD_LIM*P_PHT_GROSS_PP_RT )*( PHYTOPLANKTON/60 ) )";
	u129->AddDependency(PHT_PROD_LIM);
	u129->AddDependency(P_PHT_GROSS_PP_RT);
	u129->AddDependency(PHYTOPLANKTON);
	u129->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u130 = (TExecuteCommand*) PHT_RESP.GetCommand("u130",TCommand::kUpdate,TCommand::kCode);
	u130->SetExecutable(&PHT_RESP_u130_exe_g);
	u130->Code() = "u130 <-  ( ( ( SF_WATER >  ((float)0) ) ) ? ( SL::Min(( ( ( P_PHT_RESP_RT*PHT_TEMP_LIM )*PHYTOPLANKTON )*dT() ), PHT_GROSS_PP) ) : ( ((float)0) ) ) ";
	if( PHT_RESP.GetF(FisClamped) ) { u130->AddDependency(PHYTOPLANKTON); }
	u130->AddDependency(SF_WATER);
	u130->AddDependency(P_PHT_RESP_RT);
	u130->AddDependency(PHT_TEMP_LIM);
	u130->AddDependency(PHYTOPLANKTON);
	u130->AddDependency(PHT_GROSS_PP);
	u130->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u131 = (TExecuteCommand*) PHT_CONSUMED.GetCommand("u131",TCommand::kUpdate,TCommand::kCode);
	u131->SetExecutable(&PHT_CONSUMED_u131_exe_g);
	u131->Code() = "u131 <- CONS_INGEST_PHT";
	if( PHT_CONSUMED.GetF(FisClamped) ) { u131->AddDependency(PHYTOPLANKTON); }
	u131->AddDependency(CONS_INGEST_PHT);
	u131->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u134 = (TExecuteCommand*) PHT_LIGHT_LIM.GetCommand("u134",TCommand::kUpdate,TCommand::kCode);
	u134->SetExecutable(&PHT_LIGHT_LIM_u134_exe_g);
	u134->Code() = "u134 <- SL::Min(( ((float)3)*LIGHT_TO_PHYTOPLANKTON ), ((float)1))";
	u134->AddDependency(LIGHT_TO_PHYTOPLANKTON);
	u134->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u136 = (TExecuteCommand*) PHT_NUT_LIMIT.GetCommand("u136",TCommand::kUpdate,TCommand::kCode);
	u136->SetExecutable(&PHT_NUT_LIMIT_u136_exe_g);
	u136->Code() = "u136 <- SL::Min(( DIN_CONC/( DIN_CONC+P_PHT_N_SAT ) ), ( PO4_SF_WT_CONC/( PO4_SF_WT_CONC+P_PHT_P_SAT ) ))";
	u136->AddDependency(DIN_CONC);
	u136->AddDependency(P_PHT_N_SAT);
	u136->AddDependency(PO4_SF_WT_CONC);
	u136->AddDependency(P_PHT_P_SAT);
	u136->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u137 = (TExecuteCommand*) PHT_PROD_LIM.GetCommand("u137",TCommand::kUpdate,TCommand::kCode);
	u137->SetExecutable(&PHT_PROD_LIM_u137_exe_g);
	u137->Code() = "u137 <-  ( ( ( SF_WATER >  ((float)0) ) ) ? ( SL::Min(PHT_LIGHT_LIM, PHT_NUT_LIMIT, PHT_TEMP_LIM) ) : ( ((float)0) ) ) ";
	u137->AddDependency(SF_WATER);
	u137->AddDependency(PHT_LIGHT_LIM);
	u137->AddDependency(PHT_NUT_LIMIT);
	u137->AddDependency(PHT_TEMP_LIM);
	u137->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u138 = (TExecuteCommand*) PHT_TEMP_LIM.GetCommand("u138",TCommand::kUpdate,TCommand::kCode);
	u138->SetExecutable(&PHT_TEMP_LIM_u138_exe_g);
	u138->Code() = "u138 <-  ( ( ( ( OM3_TEMP >  P_PHT_MAX_T ) || ( OM3_TEMP <  P_PHT_MIN_T ) ) ) ? ( ((float)0) ) : ( ( ((float)1)-SL::Abs(( ( OM3_TEMP-P_PHT_OPT_T )/( OM3_TEMP+P_PHT_OPT_T ) )) ) ) ) ";
	u138->AddDependency(OM3_TEMP);
	u138->AddDependency(P_PHT_MAX_T);
	u138->AddDependency(P_PHT_MIN_T);
	u138->AddDependency(P_PHT_OPT_T);
	u138->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u139 = (TExecuteCommand*) RIVER_PHT.GetCommand("u139",TCommand::kUpdate,TCommand::kCode);
	u139->SetExecutable(&RIVER_PHT_u139_exe_g);
	u139->Code() = "u139 <- 0";
	u139->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u141 = (TExecuteCommand*) P_PHT_GROSS_PP_RT.GetCommand("u141",TCommand::kUpdate,TCommand::kCode);
	u141->SetExecutable(&P_PHT_GROSS_PP_RT_u141_exe_g);
	u141->Code() = "u141 <- ( ((float)24)*SL::Exp(( 0.09*OM3_TEMP )) )";
	u141->AddDependency(OM3_TEMP);
	u141->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u142 = (TExecuteCommand*) P_PHT_MAX_T.GetCommand("u142",TCommand::kUpdate,TCommand::kCode);
	u142->SetExecutable(&P_PHT_MAX_T_u142_exe_g);
	u142->Code() = "u142 <- 20";
	u142->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u143 = (TExecuteCommand*) P_PHT_MIN_T.GetCommand("u143",TCommand::kUpdate,TCommand::kCode);
	u143->SetExecutable(&P_PHT_MIN_T_u143_exe_g);
	u143->Code() = "u143 <- 0";
	u143->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u144 = (TExecuteCommand*) P_PHT_MORTALITY_RT.GetCommand("u144",TCommand::kUpdate,TCommand::kCode);
	u144->SetExecutable(&P_PHT_MORTALITY_RT_u144_exe_g);
	u144->Code() = "u144 <- 2e-4";
	u144->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u146 = (TExecuteCommand*) P_PHT_N_SAT.GetCommand("u146",TCommand::kUpdate,TCommand::kCode);
	u146->SetExecutable(&P_PHT_N_SAT_u146_exe_g);
	u146->Code() = "u146 <- 0.0000025";
	u146->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u147 = (TExecuteCommand*) P_PHT_OPT_T.GetCommand("u147",TCommand::kUpdate,TCommand::kCode);
	u147->SetExecutable(&P_PHT_OPT_T_u147_exe_g);
	u147->Code() = "u147 <- 15";
	u147->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u148 = (TExecuteCommand*) P_PHT_P_SAT.GetCommand("u148",TCommand::kUpdate,TCommand::kCode);
	u148->SetExecutable(&P_PHT_P_SAT_u148_exe_g);
	u148->Code() = "u148 <- 0.0000001";
	u148->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u149 = (TExecuteCommand*) P_PHT_RESP_RT.GetCommand("u149",TCommand::kUpdate,TCommand::kCode);
	u149->SetExecutable(&P_PHT_RESP_RT_u149_exe_g);
	u149->Code() = "u149 <- 0.000140";
	u149->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u151 = (TExecuteCommand*) CHL_CONC.GetCommand("u151",TCommand::kUpdate,TCommand::kCode);
	u151->SetExecutable(&CHL_CONC_u151_exe_g);
	u151->Code() = "u151 <- ((float)1)";
	u151->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u152 = (TExecuteCommand*) CHL_CONV_FACTOR.GetCommand("u152",TCommand::kUpdate,TCommand::kCode);
	u152->SetExecutable(&CHL_CONV_FACTOR_u152_exe_g);
	u152->Code() = "u152 <- 0.003";
	u152->SetObjInfo(TCommand::kDepIndex, 5);
	return 0;
}

int PHYTOPLANKTON_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int PHYTOPLANKTON_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int PHYTOPLANKTON_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int PHYTOPLANKTON_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class SEAWEED_module 
// ---------------------------------------------------------------------------
SEAWEED_module::SEAWEED_module(char* name) :
	TIME("TIME"),
	SEAWEEDS("SEAWEEDS"),
	SW_MORT("SW_MORT"),
	WATER_LAYER_DEPTH("WATER_LAYER_DEPTH"),
	P_CELL_AREA("P_CELL_AREA"),
	P_IC_PHT("P_IC_PHT"),
	SF_WATER("SF_WATER"),
	CONS_INGEST_SW("CONS_INGEST_SW"),
	BOTTOM_MAP("BOTTOM_MAP"),
	P_ON_MAP("P_ON_MAP"),
	WATER_DEPTH("WATER_DEPTH"),
	LIGHT_TO_PHYTOPLANKTON("LIGHT_TO_PHYTOPLANKTON"),
	DIN_CONC("DIN_CONC"),
	PO4_SF_WT_CONC("PO4_SF_WT_CONC"),
	OM3_TEMP("OM3_TEMP"),
	SW_GROSS_PP("SW_GROSS_PP"),
	SW_EXCHANGE("SW_EXCHANGE"),
	SW_RESP("SW_RESP"),
	SW_CONSUMED("SW_CONSUMED"),
	IC_SEAWEED("IC_SEAWEED"),
	OVERALL_FLOW_VELOCITY("OVERALL_FLOW_VELOCITY"),
	SW_CONC("SW_CONC"),
	SW_LIGHT_LIM("SW_LIGHT_LIM"),
	SW_NET_PROD("SW_NET_PROD"),
	SW_NUT_LIMIT("SW_NUT_LIMIT"),
	SW_PROD_LIM("SW_PROD_LIM"),
	SW_TEMP_LIM("SW_TEMP_LIM"),
	P_SW_MAX_T("P_SW_MAX_T"),
	P_SW_MIN_T("P_SW_MIN_T"),
	P_SW_MORT_RT("P_SW_MORT_RT"),
	P_SW_NC("P_SW_NC"),
	P_SW_N_SAT("P_SW_N_SAT"),
	P_SW_OPT_T("P_SW_OPT_T"),
	P_SW_PC("P_SW_PC"),
	P_SW_PP_RT("P_SW_PP_RT"),
	P_SW_P_SAT("P_SW_P_SAT"),
	P_SW_RESP_RT("P_SW_RESP_RT"),
	TModule(name) {

	SEAWEEDS.SetF(FisExport,True,"CG");
	SEAWEEDS.SetF(FHasNegFlux,True,"CG");
	SW_MORT.SetF(FisExport,True,"CG");
	SW_MORT.SetF(FHasNegFlux,True,"CG");
	WATER_LAYER_DEPTH.SetF(FisImport,True,"CG");
	P_CELL_AREA.SetF(FisImport,True,"CG");
	P_IC_PHT.SetF(FisImport,True,"CG");
	SF_WATER.SetF(FisImport,True,"CG");
	CONS_INGEST_SW.SetF(FisImport,True,"CG");
	BOTTOM_MAP.SetF(FisImport,True,"CG");
	P_ON_MAP.SetF(FisImport,True,"CG");
	WATER_DEPTH.SetF(FisImport,True,"CG");
	LIGHT_TO_PHYTOPLANKTON.SetF(FisImport,True,"CG");
	DIN_CONC.SetF(FisImport,True,"CG");
	PO4_SF_WT_CONC.SetF(FisImport,True,"CG");
	OM3_TEMP.SetF(FisImport,True,"CG");
	SW_EXCHANGE.SetF(FHasNegFlux,True,"CG");
	SW_RESP.SetF(FHasNegFlux,True,"CG");
	SW_CONSUMED.SetF(FHasNegFlux,True,"CG");
}	
int SEAWEED_module::SEAWEEDS_I153_exe() {
	float value;
	int array_index[64];


	SEAWEEDS.UpdateIntegrator();
	switch( SEAWEEDS.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* SEAWEEDS_ptr = SEAWEEDS.DataStart();
		const float* SEAWEEDS_Eptr = SEAWEEDS.GridEnd();
		float dt = dT();
		float* SEAWEEDS_Rptr = SEAWEEDS.RDataStart();
		float* SW_GROSS_PP_ptr = SW_GROSS_PP.DataStart();
		float* SW_EXCHANGE_ptr = SW_EXCHANGE.DataStart();
		float* SW_RESP_ptr = SW_RESP.DataStart();
		float* SW_CONSUMED_ptr = SW_CONSUMED.DataStart();
		float* SW_MORT_ptr = SW_MORT.DataStart();
		switch( SEAWEEDS.CurrentOrder() ) {
		  case 1: {
			if( SEAWEEDS.Order() > 1 ) {
			float *SEAWEEDS_IMptr0 = SEAWEEDS.SIntegratorMemory().LastData();
			while( SEAWEEDS_ptr < SEAWEEDS_Eptr ) {
		 value =  ( ( ( ( (*(SW_GROSS_PP_ptr))-(*(SW_EXCHANGE_ptr)) )-(*(SW_RESP_ptr)) )-(*(SW_CONSUMED_ptr)) )-(*(SW_MORT_ptr)) );
				*SEAWEEDS_ptr += value*dt;
				if(SEAWEEDS_Rptr) { *SEAWEEDS_Rptr++ = *SEAWEEDS_ptr; }
				*SEAWEEDS_IMptr0++ = value;
				SEAWEEDS_ptr++;
				SW_GROSS_PP.UpdateDataPtr(SW_GROSS_PP_ptr);
				SW_EXCHANGE.UpdateDataPtr(SW_EXCHANGE_ptr);
				SW_RESP.UpdateDataPtr(SW_RESP_ptr);
				SW_CONSUMED.UpdateDataPtr(SW_CONSUMED_ptr);
				SW_MORT.UpdateDataPtr(SW_MORT_ptr);
			}
			} else {
			while( SEAWEEDS_ptr < SEAWEEDS_Eptr ) {
		 value =  ( ( ( ( (*(SW_GROSS_PP_ptr))-(*(SW_EXCHANGE_ptr)) )-(*(SW_RESP_ptr)) )-(*(SW_CONSUMED_ptr)) )-(*(SW_MORT_ptr)) );
				*SEAWEEDS_ptr += value*dt;
				if(SEAWEEDS_Rptr) { *SEAWEEDS_Rptr++ = *SEAWEEDS_ptr; }
				SEAWEEDS_ptr++;
				SW_GROSS_PP.UpdateDataPtr(SW_GROSS_PP_ptr);
				SW_EXCHANGE.UpdateDataPtr(SW_EXCHANGE_ptr);
				SW_RESP.UpdateDataPtr(SW_RESP_ptr);
				SW_CONSUMED.UpdateDataPtr(SW_CONSUMED_ptr);
				SW_MORT.UpdateDataPtr(SW_MORT_ptr);
			}
			};
		  } break; case 2: {
			float *SEAWEEDS_IMptr0 = SEAWEEDS.SIntegratorMemory().LastData();
			float *SEAWEEDS_IMptr1 = SEAWEEDS.SIntegratorMemory().LastDataOffset(1);
			while( SEAWEEDS_ptr < SEAWEEDS_Eptr ) {
		 value =  ( ( ( ( (*(SW_GROSS_PP_ptr))-(*(SW_EXCHANGE_ptr)) )-(*(SW_RESP_ptr)) )-(*(SW_CONSUMED_ptr)) )-(*(SW_MORT_ptr)) );
				*SEAWEEDS_IMptr0++ = value;
				*SEAWEEDS_ptr += ( 1.5*value - 0.5* *SEAWEEDS_IMptr1++ )*dt;
				if(SEAWEEDS_Rptr) { *SEAWEEDS_Rptr++ = *SEAWEEDS_ptr; }
				SEAWEEDS_ptr++;
				SW_GROSS_PP.UpdateDataPtr(SW_GROSS_PP_ptr);
				SW_EXCHANGE.UpdateDataPtr(SW_EXCHANGE_ptr);
				SW_RESP.UpdateDataPtr(SW_RESP_ptr);
				SW_CONSUMED.UpdateDataPtr(SW_CONSUMED_ptr);
				SW_MORT.UpdateDataPtr(SW_MORT_ptr);
			}
		  } break; case 3: {
			float *SEAWEEDS_IMptr0 = SEAWEEDS.SIntegratorMemory().LastData();
			float *SEAWEEDS_IMptr1 = SEAWEEDS.SIntegratorMemory().LastDataOffset(1);
			float *SEAWEEDS_IMptr2 = SEAWEEDS.SIntegratorMemory().LastDataOffset(2);
			while( SEAWEEDS_ptr < SEAWEEDS_Eptr ) {
		 value =  ( ( ( ( (*(SW_GROSS_PP_ptr))-(*(SW_EXCHANGE_ptr)) )-(*(SW_RESP_ptr)) )-(*(SW_CONSUMED_ptr)) )-(*(SW_MORT_ptr)) );
				*SEAWEEDS_IMptr0++ = value;
				*SEAWEEDS_ptr += (1.92*value - 1.33* *SEAWEEDS_IMptr1++ + .42* *SEAWEEDS_IMptr2++)*dt;
				if(SEAWEEDS_Rptr) { *SEAWEEDS_Rptr++ = *SEAWEEDS_ptr; }
				SEAWEEDS_ptr++;
				SW_GROSS_PP.UpdateDataPtr(SW_GROSS_PP_ptr);
				SW_EXCHANGE.UpdateDataPtr(SW_EXCHANGE_ptr);
				SW_RESP.UpdateDataPtr(SW_RESP_ptr);
				SW_CONSUMED.UpdateDataPtr(SW_CONSUMED_ptr);
				SW_MORT.UpdateDataPtr(SW_MORT_ptr);
			}
		  } break; case 4: {
			float *SEAWEEDS_IMptr0 = SEAWEEDS.SIntegratorMemory().LastData();
			float *SEAWEEDS_IMptr1 = SEAWEEDS.SIntegratorMemory().LastDataOffset(1);
			float *SEAWEEDS_IMptr2 = SEAWEEDS.SIntegratorMemory().LastDataOffset(2);
			float *SEAWEEDS_IMptr3 = SEAWEEDS.SIntegratorMemory().LastDataOffset(3);
			while( SEAWEEDS_ptr < SEAWEEDS_Eptr ) {
		 value =  ( ( ( ( (*(SW_GROSS_PP_ptr))-(*(SW_EXCHANGE_ptr)) )-(*(SW_RESP_ptr)) )-(*(SW_CONSUMED_ptr)) )-(*(SW_MORT_ptr)) );
				*SEAWEEDS_IMptr0++ = value;
				*SEAWEEDS_ptr += (2.29*value - 2.46* *SEAWEEDS_IMptr1++  + 1.54* *SEAWEEDS_IMptr2++ - .375* *SEAWEEDS_IMptr3++ )*dt;
				if(SEAWEEDS_Rptr) { *SEAWEEDS_Rptr++ = *SEAWEEDS_ptr; }
				SEAWEEDS_ptr++;
				SW_GROSS_PP.UpdateDataPtr(SW_GROSS_PP_ptr);
				SW_EXCHANGE.UpdateDataPtr(SW_EXCHANGE_ptr);
				SW_RESP.UpdateDataPtr(SW_RESP_ptr);
				SW_CONSUMED.UpdateDataPtr(SW_CONSUMED_ptr);
				SW_MORT.UpdateDataPtr(SW_MORT_ptr);
			}
		  } break; default: { gPrintErr("Illegal Order in StateVar update!"); }
		};
		SEAWEEDS.GrabMemory();
		if( SEAWEEDS.GetF(FLinkEdges) ) { SEAWEEDS.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = SEAWEEDS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( ( ( SW_GROSS_PP.Value(p)-SW_EXCHANGE.Value(p) )-SW_RESP.Value(p) )-SW_CONSUMED.Value(p) )-SW_MORT.Value(p) );
			SEAWEEDS.Update( p, value, dT() );
		}
		SEAWEEDS.GrabMemory();
		if( SEAWEEDS.GetF(FLinkEdges) ) { SEAWEEDS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( ( ( SW_GROSS_PP.Value()-SW_EXCHANGE.Value() )-SW_RESP.Value() )-SW_CONSUMED.Value() )-SW_MORT.Value() );
			SEAWEEDS.Update( value, dT() );
	  } break;
	}
	SEAWEEDS.UpdateGOFComputation();
	return 0;
}

int SEAWEED_module::SEAWEEDS_i154_exe() {
	float value;
	int array_index[64];


	switch( SEAWEEDS.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* SEAWEEDS_ptr = SEAWEEDS.DataStart();
		const float* SEAWEEDS_Eptr = SEAWEEDS.GridEnd();
		float dt = dT();
		float* SEAWEEDS_Rptr = SEAWEEDS.RDataStart();
		float* WATER_LAYER_DEPTH_ptr = WATER_LAYER_DEPTH.DataStart();
		float* P_CELL_AREA_ptr = P_CELL_AREA.DataStart();
		float* P_IC_PHT_ptr = P_IC_PHT.DataStart();
		while( SEAWEEDS_ptr < SEAWEEDS_Eptr ) {
		 value =  ( ( ( (*(WATER_LAYER_DEPTH_ptr))*(*(P_CELL_AREA_ptr)) )*(*(P_IC_PHT_ptr)) )*.001 );
			if(SEAWEEDS_Rptr) { *SEAWEEDS_Rptr = *SEAWEEDS_ptr = value;  SEAWEEDS_Rptr++; }
			else { *SEAWEEDS_ptr = value; }
			SEAWEEDS_ptr++;
			WATER_LAYER_DEPTH.UpdateDataPtr(WATER_LAYER_DEPTH_ptr);
			P_CELL_AREA.UpdateDataPtr(P_CELL_AREA_ptr);
			P_IC_PHT.UpdateDataPtr(P_IC_PHT_ptr);
		}
		SEAWEEDS.GrabMemory();
		if( SEAWEEDS.GetF(FLinkEdges) ) { SEAWEEDS.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = SEAWEEDS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( ( WATER_LAYER_DEPTH.Value(p)*P_CELL_AREA.Value(p) )*P_IC_PHT.Value(p) )*.001 );
			SEAWEEDS.InitValue( p, value );
		}
		SEAWEEDS.GrabMemory();
		if( SEAWEEDS.GetF(FLinkEdges) ) { SEAWEEDS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( ( WATER_LAYER_DEPTH.Value()*P_CELL_AREA.Value() )*P_IC_PHT.Value() )*.001 );
			SEAWEEDS.InitValue( value );
	  } break;
	}
	SEAWEEDS.UpdateGOFComputation();
	return 0;
}

int SEAWEED_module::SW_GROSS_PP_u155_exe() {
	float value;
	int array_index[64];


	switch( SW_GROSS_PP.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* SW_GROSS_PP_ptr = SW_GROSS_PP.DataStart();
		const float* SW_GROSS_PP_Eptr = SW_GROSS_PP.GridEnd();
		float dt = dT();
		float* SW_PROD_LIM_ptr = SW_PROD_LIM.DataStart();
		float* P_SW_PP_RT_ptr = P_SW_PP_RT.DataStart();
		float* SEAWEEDS_ptr = SEAWEEDS.DataStart();
		int clamped = 0;
		while( SW_GROSS_PP_ptr < SW_GROSS_PP_Eptr ) {
		 value =  ( ( ( (*(SW_PROD_LIM_ptr))*(*(P_SW_PP_RT_ptr)) )/dT() )*(*(SEAWEEDS_ptr)) );
			*SW_GROSS_PP_ptr = value;
			SW_GROSS_PP_ptr++;
			SW_PROD_LIM.UpdateDataPtr(SW_PROD_LIM_ptr);
			P_SW_PP_RT.UpdateDataPtr(P_SW_PP_RT_ptr);
			SEAWEEDS.UpdateDataPtr(SEAWEEDS_ptr);
		}
		if( SW_GROSS_PP.GetF(FICFlux) ) SW_GROSS_PP.Cov().Set(0.0); 
		SW_GROSS_PP.GrabMemory();
		if( SW_GROSS_PP.GetF(FLinkEdges) ) { SW_GROSS_PP.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_GROSS_PP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ( ( SW_PROD_LIM.Value(p)*P_SW_PP_RT.Value(p) )/dT() )*SEAWEEDS.Value(p) );
			SW_GROSS_PP.Update( p, value );
		}
		SW_GROSS_PP.GrabMemory();
		if( SW_GROSS_PP.GetF(FICFlux) ) SW_GROSS_PP.Cov().Set(0.0); 
		if( SW_GROSS_PP.GetF(FLinkEdges) ) { SW_GROSS_PP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ( ( SW_PROD_LIM.Value()*P_SW_PP_RT.Value() )/dT() )*SEAWEEDS.Value() );
			SW_GROSS_PP.Update( value );
	  } break;
	}
	SW_GROSS_PP.UpdateGOFComputation();
	return 0;
}

int SEAWEED_module::SW_EXCHANGE_u156_exe() {
	float value;
	int array_index[64];


	switch( SW_EXCHANGE.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* SW_EXCHANGE_ptr = SW_EXCHANGE.DataStart();
		const float* SW_EXCHANGE_Eptr = SW_EXCHANGE.GridEnd();
		float dt = dT();
		float* SW_EXCHANGE_Optr = ((CStateVariable*)(SW_EXCHANGE.Origin()))->RDataStart();
		float* OVERALL_FLOW_VELOCITY_ptr = OVERALL_FLOW_VELOCITY.DataStart();
		int clamped = SEAWEEDS.GetF(FisClamped);
		while( SW_EXCHANGE_ptr < SW_EXCHANGE_Eptr ) {
		 value =   ( ( ( (*(OVERALL_FLOW_VELOCITY_ptr)) >  0.5 ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			*SW_EXCHANGE_ptr = value;
			if( clamped ) { SL::Clamp(SW_EXCHANGE_Optr++,SW_EXCHANGE_ptr,dt); }
			SW_EXCHANGE_ptr++;
			OVERALL_FLOW_VELOCITY.UpdateDataPtr(OVERALL_FLOW_VELOCITY_ptr);
		}
		if( SW_EXCHANGE.GetF(FICFlux) ) SW_EXCHANGE.Cov().Set(0.0); 
		SW_EXCHANGE.GrabMemory();
		if( SW_EXCHANGE.GetF(FLinkEdges) ) { SW_EXCHANGE.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_EXCHANGE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( OVERALL_FLOW_VELOCITY.Value(p) >  0.5 ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			SW_EXCHANGE.Update( p, value );
		}
		SW_EXCHANGE.GrabMemory();
		if( SW_EXCHANGE.GetF(FICFlux) ) SW_EXCHANGE.Cov().Set(0.0); 
		if( SW_EXCHANGE.GetF(FLinkEdges) ) { SW_EXCHANGE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( OVERALL_FLOW_VELOCITY.Value() >  0.5 ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			SW_EXCHANGE.Update( value );
	  } break;
	}
	SW_EXCHANGE.UpdateGOFComputation();
	return 0;
}

int SEAWEED_module::SW_RESP_u157_exe() {
	float value;
	int array_index[64];


	switch( SW_RESP.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* SW_RESP_ptr = SW_RESP.DataStart();
		const float* SW_RESP_Eptr = SW_RESP.GridEnd();
		float dt = dT();
		float* SW_RESP_Optr = ((CStateVariable*)(SW_RESP.Origin()))->RDataStart();
		float* SF_WATER_ptr = SF_WATER.DataStart();
		float* P_SW_RESP_RT_ptr = P_SW_RESP_RT.DataStart();
		float* SW_TEMP_LIM_ptr = SW_TEMP_LIM.DataStart();
		float* SEAWEEDS_ptr = SEAWEEDS.DataStart();
		int clamped = SEAWEEDS.GetF(FisClamped);
		while( SW_RESP_ptr < SW_RESP_Eptr ) {
		 value =   ( ( ( (*(SF_WATER_ptr)) >  ((float)0) ) ) ? ( ( ( ( (*(P_SW_RESP_RT_ptr))*dT() )*(*(SW_TEMP_LIM_ptr)) )*(*(SEAWEEDS_ptr)) ) ) : ( ((float)0) ) ) ;
			*SW_RESP_ptr = value;
			if( clamped ) { SL::Clamp(SW_RESP_Optr++,SW_RESP_ptr,dt); }
			SW_RESP_ptr++;
			SF_WATER.UpdateDataPtr(SF_WATER_ptr);
			P_SW_RESP_RT.UpdateDataPtr(P_SW_RESP_RT_ptr);
			SW_TEMP_LIM.UpdateDataPtr(SW_TEMP_LIM_ptr);
			SEAWEEDS.UpdateDataPtr(SEAWEEDS_ptr);
		}
		if( SW_RESP.GetF(FICFlux) ) SW_RESP.Cov().Set(0.0); 
		SW_RESP.GrabMemory();
		if( SW_RESP.GetF(FLinkEdges) ) { SW_RESP.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_RESP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( SF_WATER.Value(p) >  ((float)0) ) ) ? ( ( ( ( P_SW_RESP_RT.Value(p)*dT() )*SW_TEMP_LIM.Value(p) )*SEAWEEDS.Value(p) ) ) : ( ((float)0) ) ) ;
			SW_RESP.Update( p, value );
		}
		SW_RESP.GrabMemory();
		if( SW_RESP.GetF(FICFlux) ) SW_RESP.Cov().Set(0.0); 
		if( SW_RESP.GetF(FLinkEdges) ) { SW_RESP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( SF_WATER.Value() >  ((float)0) ) ) ? ( ( ( ( P_SW_RESP_RT.Value()*dT() )*SW_TEMP_LIM.Value() )*SEAWEEDS.Value() ) ) : ( ((float)0) ) ) ;
			SW_RESP.Update( value );
	  } break;
	}
	SW_RESP.UpdateGOFComputation();
	return 0;
}

int SEAWEED_module::SW_CONSUMED_u158_exe() {
	float value;
	int array_index[64];


	switch( SW_CONSUMED.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* SW_CONSUMED_ptr = SW_CONSUMED.DataStart();
		const float* SW_CONSUMED_Eptr = SW_CONSUMED.GridEnd();
		float dt = dT();
		float* SW_CONSUMED_Optr = ((CStateVariable*)(SW_CONSUMED.Origin()))->RDataStart();
		float* CONS_INGEST_SW_ptr = CONS_INGEST_SW.DataStart();
		int clamped = SEAWEEDS.GetF(FisClamped);
		while( SW_CONSUMED_ptr < SW_CONSUMED_Eptr ) {
		 value =  (*(CONS_INGEST_SW_ptr));
			*SW_CONSUMED_ptr = value;
			if( clamped ) { SL::Clamp(SW_CONSUMED_Optr++,SW_CONSUMED_ptr,dt); }
			SW_CONSUMED_ptr++;
			CONS_INGEST_SW.UpdateDataPtr(CONS_INGEST_SW_ptr);
		}
		if( SW_CONSUMED.GetF(FICFlux) ) SW_CONSUMED.Cov().Set(0.0); 
		SW_CONSUMED.GrabMemory();
		if( SW_CONSUMED.GetF(FLinkEdges) ) { SW_CONSUMED.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_CONSUMED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  CONS_INGEST_SW.Value(p);
			SW_CONSUMED.Update( p, value );
		}
		SW_CONSUMED.GrabMemory();
		if( SW_CONSUMED.GetF(FICFlux) ) SW_CONSUMED.Cov().Set(0.0); 
		if( SW_CONSUMED.GetF(FLinkEdges) ) { SW_CONSUMED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  CONS_INGEST_SW.Value();
			SW_CONSUMED.Update( value );
	  } break;
	}
	SW_CONSUMED.UpdateGOFComputation();
	return 0;
}

int SEAWEED_module::SW_MORT_u159_exe() {
	float value;
	int array_index[64];


	switch( SW_MORT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* SW_MORT_ptr = SW_MORT.DataStart();
		const float* SW_MORT_Eptr = SW_MORT.GridEnd();
		float dt = dT();
		float* SW_MORT_Optr = ((CStateVariable*)(SW_MORT.Origin()))->RDataStart();
		float* SEAWEEDS_ptr = SEAWEEDS.DataStart();
		float* P_SW_MORT_RT_ptr = P_SW_MORT_RT.DataStart();
		int clamped = SEAWEEDS.GetF(FisClamped);
		while( SW_MORT_ptr < SW_MORT_Eptr ) {
		 value =  ( (*(SEAWEEDS_ptr))*( (*(P_SW_MORT_RT_ptr))*dT() ) );
			*SW_MORT_ptr = value;
			if( clamped ) { SL::Clamp(SW_MORT_Optr++,SW_MORT_ptr,dt); }
			SW_MORT_ptr++;
			SEAWEEDS.UpdateDataPtr(SEAWEEDS_ptr);
			P_SW_MORT_RT.UpdateDataPtr(P_SW_MORT_RT_ptr);
		}
		if( SW_MORT.GetF(FICFlux) ) SW_MORT.Cov().Set(0.0); 
		SW_MORT.GrabMemory();
		if( SW_MORT.GetF(FLinkEdges) ) { SW_MORT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_MORT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( SEAWEEDS.Value(p)*( P_SW_MORT_RT.Value(p)*dT() ) );
			SW_MORT.Update( p, value );
		}
		SW_MORT.GrabMemory();
		if( SW_MORT.GetF(FICFlux) ) SW_MORT.Cov().Set(0.0); 
		if( SW_MORT.GetF(FLinkEdges) ) { SW_MORT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( SEAWEEDS.Value()*( P_SW_MORT_RT.Value()*dT() ) );
			SW_MORT.Update( value );
	  } break;
	}
	SW_MORT.UpdateGOFComputation();
	return 0;
}

int SEAWEED_module::IC_SEAWEED_u160_exe() {
	float value;
	int array_index[64];


	switch( IC_SEAWEED.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* IC_SEAWEED_ptr = IC_SEAWEED.DataStart();
		const float* IC_SEAWEED_Eptr = IC_SEAWEED.GridEnd();
		float* BOTTOM_MAP_ptr = BOTTOM_MAP.DataStart();
		while( IC_SEAWEED_ptr < IC_SEAWEED_Eptr ) {
		 value =   ( ( ( (*(BOTTOM_MAP_ptr)) == ((float)1) ) ) ? ( 0.001 ) : ( ((float)0) ) ) ;
			*IC_SEAWEED_ptr = value;
			IC_SEAWEED_ptr++;
			BOTTOM_MAP.UpdateDataPtr(BOTTOM_MAP_ptr);
		}
		IC_SEAWEED.GrabMemory();
		if( IC_SEAWEED.GetF(FLinkEdges) ) { IC_SEAWEED.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = IC_SEAWEED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( BOTTOM_MAP.Value(p) == ((float)1) ) ) ? ( 0.001 ) : ( ((float)0) ) ) ;
			IC_SEAWEED.Update( p, value );
		}
		IC_SEAWEED.GrabMemory();
		if( IC_SEAWEED.GetF(FLinkEdges) ) { IC_SEAWEED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( BOTTOM_MAP.Value() == ((float)1) ) ) ? ( 0.001 ) : ( ((float)0) ) ) ;
			IC_SEAWEED.Update( value );
	  } break;
	}
	IC_SEAWEED.UpdateGOFComputation();
	return 0;
}

int SEAWEED_module::OVERALL_FLOW_VELOCITY_u161_exe() {
	float value;
	int array_index[64];


	switch( OVERALL_FLOW_VELOCITY.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* OVERALL_FLOW_VELOCITY_ptr = OVERALL_FLOW_VELOCITY.DataStart();
		const float* OVERALL_FLOW_VELOCITY_Eptr = OVERALL_FLOW_VELOCITY.GridEnd();
		 value =  0;
		value = OVERALL_FLOW_VELOCITY.ParameterValue(value);
		while( OVERALL_FLOW_VELOCITY_ptr < OVERALL_FLOW_VELOCITY_Eptr ) {
			*OVERALL_FLOW_VELOCITY_ptr = value;
			OVERALL_FLOW_VELOCITY_ptr++;
		}
		OVERALL_FLOW_VELOCITY.GrabMemory();
		if( OVERALL_FLOW_VELOCITY.GetF(FLinkEdges) ) { OVERALL_FLOW_VELOCITY.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = OVERALL_FLOW_VELOCITY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0;
			OVERALL_FLOW_VELOCITY.Update( p, OVERALL_FLOW_VELOCITY.ParameterValue(value,p) );
		}
		OVERALL_FLOW_VELOCITY.GrabMemory();
		if( OVERALL_FLOW_VELOCITY.GetF(FLinkEdges) ) { OVERALL_FLOW_VELOCITY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0;
			OVERALL_FLOW_VELOCITY.Update( OVERALL_FLOW_VELOCITY.ParameterValue(value) );
	  } break;
	}
	OVERALL_FLOW_VELOCITY.UpdateGOFComputation();
	return 0;
}

int SEAWEED_module::SW_CONC_u162_exe() {
	float value;
	int array_index[64];


	switch( SW_CONC.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* SW_CONC_ptr = SW_CONC.DataStart();
		const float* SW_CONC_Eptr = SW_CONC.GridEnd();
		float* P_ON_MAP_ptr = P_ON_MAP.DataStart();
		float* WATER_DEPTH_ptr = WATER_DEPTH.DataStart();
		float* SEAWEEDS_ptr = SEAWEEDS.DataStart();
		float* SF_WATER_ptr = SF_WATER.DataStart();
		while( SW_CONC_ptr < SW_CONC_Eptr ) {
		 value =   ( ( ( ( (*(P_ON_MAP_ptr)) <  ((float)2) ) && ( (*(WATER_DEPTH_ptr)) >  0.01 ) ) ) ? ( ( (*(SEAWEEDS_ptr))/(*(SF_WATER_ptr)) ) ) : ( ((float)0) ) ) ;
			*SW_CONC_ptr = value;
			SW_CONC_ptr++;
			P_ON_MAP.UpdateDataPtr(P_ON_MAP_ptr);
			WATER_DEPTH.UpdateDataPtr(WATER_DEPTH_ptr);
			SEAWEEDS.UpdateDataPtr(SEAWEEDS_ptr);
			SF_WATER.UpdateDataPtr(SF_WATER_ptr);
		}
		SW_CONC.GrabMemory();
		if( SW_CONC.GetF(FLinkEdges) ) { SW_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_CONC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( ( P_ON_MAP.Value(p) <  ((float)2) ) && ( WATER_DEPTH.Value(p) >  0.01 ) ) ) ? ( ( SEAWEEDS.Value(p)/SF_WATER.Value(p) ) ) : ( ((float)0) ) ) ;
			SW_CONC.Update( p, value );
		}
		SW_CONC.GrabMemory();
		if( SW_CONC.GetF(FLinkEdges) ) { SW_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( ( P_ON_MAP.Value() <  ((float)2) ) && ( WATER_DEPTH.Value() >  0.01 ) ) ) ? ( ( SEAWEEDS.Value()/SF_WATER.Value() ) ) : ( ((float)0) ) ) ;
			SW_CONC.Update( value );
	  } break;
	}
	SW_CONC.UpdateGOFComputation();
	return 0;
}

int SEAWEED_module::SW_LIGHT_LIM_u163_exe() {
	float value;
	int array_index[64];


	switch( SW_LIGHT_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* SW_LIGHT_LIM_ptr = SW_LIGHT_LIM.DataStart();
		const float* SW_LIGHT_LIM_Eptr = SW_LIGHT_LIM.GridEnd();
		float* LIGHT_TO_PHYTOPLANKTON_ptr = LIGHT_TO_PHYTOPLANKTON.DataStart();
		while( SW_LIGHT_LIM_ptr < SW_LIGHT_LIM_Eptr ) {
		 value =  SL::Min(( (*(LIGHT_TO_PHYTOPLANKTON_ptr))*((float)3) ), ((float)1));
			*SW_LIGHT_LIM_ptr = value;
			SW_LIGHT_LIM_ptr++;
			LIGHT_TO_PHYTOPLANKTON.UpdateDataPtr(LIGHT_TO_PHYTOPLANKTON_ptr);
		}
		SW_LIGHT_LIM.GrabMemory();
		if( SW_LIGHT_LIM.GetF(FLinkEdges) ) { SW_LIGHT_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_LIGHT_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  SL::Min(( LIGHT_TO_PHYTOPLANKTON.Value(p)*((float)3) ), ((float)1));
			SW_LIGHT_LIM.Update( p, value );
		}
		SW_LIGHT_LIM.GrabMemory();
		if( SW_LIGHT_LIM.GetF(FLinkEdges) ) { SW_LIGHT_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  SL::Min(( LIGHT_TO_PHYTOPLANKTON.Value()*((float)3) ), ((float)1));
			SW_LIGHT_LIM.Update( value );
	  } break;
	}
	SW_LIGHT_LIM.UpdateGOFComputation();
	return 0;
}

int SEAWEED_module::SW_NET_PROD_u164_exe() {
	float value;
	int array_index[64];


	switch( SW_NET_PROD.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* SW_NET_PROD_ptr = SW_NET_PROD.DataStart();
		const float* SW_NET_PROD_Eptr = SW_NET_PROD.GridEnd();
		float* SW_GROSS_PP_ptr = SW_GROSS_PP.DataStart();
		float* SW_RESP_ptr = SW_RESP.DataStart();
		while( SW_NET_PROD_ptr < SW_NET_PROD_Eptr ) {
		 value =  ( (*(SW_GROSS_PP_ptr))-(*(SW_RESP_ptr)) );
			*SW_NET_PROD_ptr = value;
			SW_NET_PROD_ptr++;
			SW_GROSS_PP.UpdateDataPtr(SW_GROSS_PP_ptr);
			SW_RESP.UpdateDataPtr(SW_RESP_ptr);
		}
		SW_NET_PROD.GrabMemory();
		if( SW_NET_PROD.GetF(FLinkEdges) ) { SW_NET_PROD.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_NET_PROD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( SW_GROSS_PP.Value(p)-SW_RESP.Value(p) );
			SW_NET_PROD.Update( p, value );
		}
		SW_NET_PROD.GrabMemory();
		if( SW_NET_PROD.GetF(FLinkEdges) ) { SW_NET_PROD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( SW_GROSS_PP.Value()-SW_RESP.Value() );
			SW_NET_PROD.Update( value );
	  } break;
	}
	SW_NET_PROD.UpdateGOFComputation();
	return 0;
}

int SEAWEED_module::SW_NUT_LIMIT_u165_exe() {
	float value;
	int array_index[64];


	switch( SW_NUT_LIMIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* SW_NUT_LIMIT_ptr = SW_NUT_LIMIT.DataStart();
		const float* SW_NUT_LIMIT_Eptr = SW_NUT_LIMIT.GridEnd();
		float* DIN_CONC_ptr = DIN_CONC.DataStart();
		float* P_SW_N_SAT_ptr = P_SW_N_SAT.DataStart();
		float* PO4_SF_WT_CONC_ptr = PO4_SF_WT_CONC.DataStart();
		float* P_SW_P_SAT_ptr = P_SW_P_SAT.DataStart();
		while( SW_NUT_LIMIT_ptr < SW_NUT_LIMIT_Eptr ) {
		 value =  SL::Min(( (*(DIN_CONC_ptr))/( (*(DIN_CONC_ptr))+(*(P_SW_N_SAT_ptr)) ) ), ( (*(PO4_SF_WT_CONC_ptr))/( (*(PO4_SF_WT_CONC_ptr))+(*(P_SW_P_SAT_ptr)) ) ));
			*SW_NUT_LIMIT_ptr = value;
			SW_NUT_LIMIT_ptr++;
			DIN_CONC.UpdateDataPtr(DIN_CONC_ptr);
			P_SW_N_SAT.UpdateDataPtr(P_SW_N_SAT_ptr);
			PO4_SF_WT_CONC.UpdateDataPtr(PO4_SF_WT_CONC_ptr);
			P_SW_P_SAT.UpdateDataPtr(P_SW_P_SAT_ptr);
		}
		SW_NUT_LIMIT.GrabMemory();
		if( SW_NUT_LIMIT.GetF(FLinkEdges) ) { SW_NUT_LIMIT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_NUT_LIMIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  SL::Min(( DIN_CONC.Value(p)/( DIN_CONC.Value(p)+P_SW_N_SAT.Value(p) ) ), ( PO4_SF_WT_CONC.Value(p)/( PO4_SF_WT_CONC.Value(p)+P_SW_P_SAT.Value(p) ) ));
			SW_NUT_LIMIT.Update( p, value );
		}
		SW_NUT_LIMIT.GrabMemory();
		if( SW_NUT_LIMIT.GetF(FLinkEdges) ) { SW_NUT_LIMIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  SL::Min(( DIN_CONC.Value()/( DIN_CONC.Value()+P_SW_N_SAT.Value() ) ), ( PO4_SF_WT_CONC.Value()/( PO4_SF_WT_CONC.Value()+P_SW_P_SAT.Value() ) ));
			SW_NUT_LIMIT.Update( value );
	  } break;
	}
	SW_NUT_LIMIT.UpdateGOFComputation();
	return 0;
}

int SEAWEED_module::SW_PROD_LIM_u166_exe() {
	float value;
	int array_index[64];


	switch( SW_PROD_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* SW_PROD_LIM_ptr = SW_PROD_LIM.DataStart();
		const float* SW_PROD_LIM_Eptr = SW_PROD_LIM.GridEnd();
		float* SF_WATER_ptr = SF_WATER.DataStart();
		float* SW_TEMP_LIM_ptr = SW_TEMP_LIM.DataStart();
		float* SW_NUT_LIMIT_ptr = SW_NUT_LIMIT.DataStart();
		float* SW_LIGHT_LIM_ptr = SW_LIGHT_LIM.DataStart();
		while( SW_PROD_LIM_ptr < SW_PROD_LIM_Eptr ) {
		 value =   ( ( ( (*(SF_WATER_ptr)) >  ((float)0) ) ) ? ( SL::Min((*(SW_TEMP_LIM_ptr)), (*(SW_NUT_LIMIT_ptr)), (*(SW_TEMP_LIM_ptr)), (*(SW_LIGHT_LIM_ptr))) ) : ( ((float)0) ) ) ;
			*SW_PROD_LIM_ptr = value;
			SW_PROD_LIM_ptr++;
			SF_WATER.UpdateDataPtr(SF_WATER_ptr);
			SW_TEMP_LIM.UpdateDataPtr(SW_TEMP_LIM_ptr);
			SW_NUT_LIMIT.UpdateDataPtr(SW_NUT_LIMIT_ptr);
			SW_LIGHT_LIM.UpdateDataPtr(SW_LIGHT_LIM_ptr);
		}
		SW_PROD_LIM.GrabMemory();
		if( SW_PROD_LIM.GetF(FLinkEdges) ) { SW_PROD_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_PROD_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( SF_WATER.Value(p) >  ((float)0) ) ) ? ( SL::Min(SW_TEMP_LIM.Value(p), SW_NUT_LIMIT.Value(p), SW_TEMP_LIM.Value(p), SW_LIGHT_LIM.Value(p)) ) : ( ((float)0) ) ) ;
			SW_PROD_LIM.Update( p, value );
		}
		SW_PROD_LIM.GrabMemory();
		if( SW_PROD_LIM.GetF(FLinkEdges) ) { SW_PROD_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( SF_WATER.Value() >  ((float)0) ) ) ? ( SL::Min(SW_TEMP_LIM.Value(), SW_NUT_LIMIT.Value(), SW_TEMP_LIM.Value(), SW_LIGHT_LIM.Value()) ) : ( ((float)0) ) ) ;
			SW_PROD_LIM.Update( value );
	  } break;
	}
	SW_PROD_LIM.UpdateGOFComputation();
	return 0;
}

int SEAWEED_module::SW_TEMP_LIM_u167_exe() {
	float value;
	int array_index[64];


	switch( SW_TEMP_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* SW_TEMP_LIM_ptr = SW_TEMP_LIM.DataStart();
		const float* SW_TEMP_LIM_Eptr = SW_TEMP_LIM.GridEnd();
		float* OM3_TEMP_ptr = OM3_TEMP.DataStart();
		float* P_SW_MAX_T_ptr = P_SW_MAX_T.DataStart();
		float* P_SW_MIN_T_ptr = P_SW_MIN_T.DataStart();
		float* P_SW_OPT_T_ptr = P_SW_OPT_T.DataStart();
		while( SW_TEMP_LIM_ptr < SW_TEMP_LIM_Eptr ) {
		 value =   ( ( ( ( (*(OM3_TEMP_ptr)) >  (*(P_SW_MAX_T_ptr)) ) || ( (*(OM3_TEMP_ptr)) <  (*(P_SW_MIN_T_ptr)) ) ) ) ? ( ((float)0) ) : ( ( ((float)1)-SL::Abs(( ( (*(OM3_TEMP_ptr))-(*(P_SW_OPT_T_ptr)) )/( (*(OM3_TEMP_ptr))+(*(P_SW_OPT_T_ptr)) ) )) ) ) ) ;
			*SW_TEMP_LIM_ptr = value;
			SW_TEMP_LIM_ptr++;
			OM3_TEMP.UpdateDataPtr(OM3_TEMP_ptr);
			P_SW_MAX_T.UpdateDataPtr(P_SW_MAX_T_ptr);
			P_SW_MIN_T.UpdateDataPtr(P_SW_MIN_T_ptr);
			P_SW_OPT_T.UpdateDataPtr(P_SW_OPT_T_ptr);
		}
		SW_TEMP_LIM.GrabMemory();
		if( SW_TEMP_LIM.GetF(FLinkEdges) ) { SW_TEMP_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_TEMP_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( ( OM3_TEMP.Value(p) >  P_SW_MAX_T.Value(p) ) || ( OM3_TEMP.Value(p) <  P_SW_MIN_T.Value(p) ) ) ) ? ( ((float)0) ) : ( ( ((float)1)-SL::Abs(( ( OM3_TEMP.Value(p)-P_SW_OPT_T.Value(p) )/( OM3_TEMP.Value(p)+P_SW_OPT_T.Value(p) ) )) ) ) ) ;
			SW_TEMP_LIM.Update( p, value );
		}
		SW_TEMP_LIM.GrabMemory();
		if( SW_TEMP_LIM.GetF(FLinkEdges) ) { SW_TEMP_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( ( OM3_TEMP.Value() >  P_SW_MAX_T.Value() ) || ( OM3_TEMP.Value() <  P_SW_MIN_T.Value() ) ) ) ? ( ((float)0) ) : ( ( ((float)1)-SL::Abs(( ( OM3_TEMP.Value()-P_SW_OPT_T.Value() )/( OM3_TEMP.Value()+P_SW_OPT_T.Value() ) )) ) ) ) ;
			SW_TEMP_LIM.Update( value );
	  } break;
	}
	SW_TEMP_LIM.UpdateGOFComputation();
	return 0;
}

int SEAWEED_module::P_SW_MAX_T_u168_exe() {
	float value;
	int array_index[64];


	switch( P_SW_MAX_T.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_SW_MAX_T_ptr = P_SW_MAX_T.DataStart();
		const float* P_SW_MAX_T_Eptr = P_SW_MAX_T.GridEnd();
		 value =  40;
		value = P_SW_MAX_T.ParameterValue(value);
		while( P_SW_MAX_T_ptr < P_SW_MAX_T_Eptr ) {
			*P_SW_MAX_T_ptr = value;
			P_SW_MAX_T_ptr++;
		}
		P_SW_MAX_T.GrabMemory();
		if( P_SW_MAX_T.GetF(FLinkEdges) ) { P_SW_MAX_T.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_SW_MAX_T.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  40;
			P_SW_MAX_T.Update( p, P_SW_MAX_T.ParameterValue(value,p) );
		}
		P_SW_MAX_T.GrabMemory();
		if( P_SW_MAX_T.GetF(FLinkEdges) ) { P_SW_MAX_T.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  40;
			P_SW_MAX_T.Update( P_SW_MAX_T.ParameterValue(value) );
	  } break;
	}
	P_SW_MAX_T.UpdateGOFComputation();
	return 0;
}

int SEAWEED_module::P_SW_MIN_T_u169_exe() {
	float value;
	int array_index[64];


	switch( P_SW_MIN_T.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_SW_MIN_T_ptr = P_SW_MIN_T.DataStart();
		const float* P_SW_MIN_T_Eptr = P_SW_MIN_T.GridEnd();
		 value =  0;
		value = P_SW_MIN_T.ParameterValue(value);
		while( P_SW_MIN_T_ptr < P_SW_MIN_T_Eptr ) {
			*P_SW_MIN_T_ptr = value;
			P_SW_MIN_T_ptr++;
		}
		P_SW_MIN_T.GrabMemory();
		if( P_SW_MIN_T.GetF(FLinkEdges) ) { P_SW_MIN_T.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_SW_MIN_T.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0;
			P_SW_MIN_T.Update( p, P_SW_MIN_T.ParameterValue(value,p) );
		}
		P_SW_MIN_T.GrabMemory();
		if( P_SW_MIN_T.GetF(FLinkEdges) ) { P_SW_MIN_T.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0;
			P_SW_MIN_T.Update( P_SW_MIN_T.ParameterValue(value) );
	  } break;
	}
	P_SW_MIN_T.UpdateGOFComputation();
	return 0;
}

int SEAWEED_module::P_SW_MORT_RT_u170_exe() {
	float value;
	int array_index[64];


	switch( P_SW_MORT_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_SW_MORT_RT_ptr = P_SW_MORT_RT.DataStart();
		const float* P_SW_MORT_RT_Eptr = P_SW_MORT_RT.GridEnd();
		while( P_SW_MORT_RT_ptr < P_SW_MORT_RT_Eptr ) {
		 value =  ( ((float)2e-3)/24 );
			*P_SW_MORT_RT_ptr = value;
			P_SW_MORT_RT_ptr++;
		}
		P_SW_MORT_RT.GrabMemory();
		if( P_SW_MORT_RT.GetF(FLinkEdges) ) { P_SW_MORT_RT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_SW_MORT_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( ((float)2e-3)/24 );
			P_SW_MORT_RT.Update( p, value );
		}
		P_SW_MORT_RT.GrabMemory();
		if( P_SW_MORT_RT.GetF(FLinkEdges) ) { P_SW_MORT_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( ((float)2e-3)/24 );
			P_SW_MORT_RT.Update( value );
	  } break;
	}
	P_SW_MORT_RT.UpdateGOFComputation();
	return 0;
}

int SEAWEED_module::P_SW_NC_u171_exe() {
	float value;
	int array_index[64];


	switch( P_SW_NC.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_SW_NC_ptr = P_SW_NC.DataStart();
		const float* P_SW_NC_Eptr = P_SW_NC.GridEnd();
		 value =  0.010000;
		value = P_SW_NC.ParameterValue(value);
		while( P_SW_NC_ptr < P_SW_NC_Eptr ) {
			*P_SW_NC_ptr = value;
			P_SW_NC_ptr++;
		}
		P_SW_NC.GrabMemory();
		if( P_SW_NC.GetF(FLinkEdges) ) { P_SW_NC.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_SW_NC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.010000;
			P_SW_NC.Update( p, P_SW_NC.ParameterValue(value,p) );
		}
		P_SW_NC.GrabMemory();
		if( P_SW_NC.GetF(FLinkEdges) ) { P_SW_NC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.010000;
			P_SW_NC.Update( P_SW_NC.ParameterValue(value) );
	  } break;
	}
	P_SW_NC.UpdateGOFComputation();
	return 0;
}

int SEAWEED_module::P_SW_N_SAT_u172_exe() {
	float value;
	int array_index[64];


	switch( P_SW_N_SAT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_SW_N_SAT_ptr = P_SW_N_SAT.DataStart();
		const float* P_SW_N_SAT_Eptr = P_SW_N_SAT.GridEnd();
		 value =  0.000025;
		value = P_SW_N_SAT.ParameterValue(value);
		while( P_SW_N_SAT_ptr < P_SW_N_SAT_Eptr ) {
			*P_SW_N_SAT_ptr = value;
			P_SW_N_SAT_ptr++;
		}
		P_SW_N_SAT.GrabMemory();
		if( P_SW_N_SAT.GetF(FLinkEdges) ) { P_SW_N_SAT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_SW_N_SAT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.000025;
			P_SW_N_SAT.Update( p, P_SW_N_SAT.ParameterValue(value,p) );
		}
		P_SW_N_SAT.GrabMemory();
		if( P_SW_N_SAT.GetF(FLinkEdges) ) { P_SW_N_SAT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.000025;
			P_SW_N_SAT.Update( P_SW_N_SAT.ParameterValue(value) );
	  } break;
	}
	P_SW_N_SAT.UpdateGOFComputation();
	return 0;
}

int SEAWEED_module::P_SW_OPT_T_u173_exe() {
	float value;
	int array_index[64];


	switch( P_SW_OPT_T.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_SW_OPT_T_ptr = P_SW_OPT_T.DataStart();
		const float* P_SW_OPT_T_Eptr = P_SW_OPT_T.GridEnd();
		 value =  20;
		value = P_SW_OPT_T.ParameterValue(value);
		while( P_SW_OPT_T_ptr < P_SW_OPT_T_Eptr ) {
			*P_SW_OPT_T_ptr = value;
			P_SW_OPT_T_ptr++;
		}
		P_SW_OPT_T.GrabMemory();
		if( P_SW_OPT_T.GetF(FLinkEdges) ) { P_SW_OPT_T.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_SW_OPT_T.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  20;
			P_SW_OPT_T.Update( p, P_SW_OPT_T.ParameterValue(value,p) );
		}
		P_SW_OPT_T.GrabMemory();
		if( P_SW_OPT_T.GetF(FLinkEdges) ) { P_SW_OPT_T.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  20;
			P_SW_OPT_T.Update( P_SW_OPT_T.ParameterValue(value) );
	  } break;
	}
	P_SW_OPT_T.UpdateGOFComputation();
	return 0;
}

int SEAWEED_module::P_SW_PC_u174_exe() {
	float value;
	int array_index[64];


	switch( P_SW_PC.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_SW_PC_ptr = P_SW_PC.DataStart();
		const float* P_SW_PC_Eptr = P_SW_PC.GridEnd();
		 value =  0.005000;
		value = P_SW_PC.ParameterValue(value);
		while( P_SW_PC_ptr < P_SW_PC_Eptr ) {
			*P_SW_PC_ptr = value;
			P_SW_PC_ptr++;
		}
		P_SW_PC.GrabMemory();
		if( P_SW_PC.GetF(FLinkEdges) ) { P_SW_PC.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_SW_PC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.005000;
			P_SW_PC.Update( p, P_SW_PC.ParameterValue(value,p) );
		}
		P_SW_PC.GrabMemory();
		if( P_SW_PC.GetF(FLinkEdges) ) { P_SW_PC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.005000;
			P_SW_PC.Update( P_SW_PC.ParameterValue(value) );
	  } break;
	}
	P_SW_PC.UpdateGOFComputation();
	return 0;
}

int SEAWEED_module::P_SW_PP_RT_u175_exe() {
	float value;
	int array_index[64];


	switch( P_SW_PP_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_SW_PP_RT_ptr = P_SW_PP_RT.DataStart();
		const float* P_SW_PP_RT_Eptr = P_SW_PP_RT.GridEnd();
		 value =  0.025000;
		value = P_SW_PP_RT.ParameterValue(value);
		while( P_SW_PP_RT_ptr < P_SW_PP_RT_Eptr ) {
			*P_SW_PP_RT_ptr = value;
			P_SW_PP_RT_ptr++;
		}
		P_SW_PP_RT.GrabMemory();
		if( P_SW_PP_RT.GetF(FLinkEdges) ) { P_SW_PP_RT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_SW_PP_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.025000;
			P_SW_PP_RT.Update( p, P_SW_PP_RT.ParameterValue(value,p) );
		}
		P_SW_PP_RT.GrabMemory();
		if( P_SW_PP_RT.GetF(FLinkEdges) ) { P_SW_PP_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.025000;
			P_SW_PP_RT.Update( P_SW_PP_RT.ParameterValue(value) );
	  } break;
	}
	P_SW_PP_RT.UpdateGOFComputation();
	return 0;
}

int SEAWEED_module::P_SW_P_SAT_u176_exe() {
	float value;
	int array_index[64];


	switch( P_SW_P_SAT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_SW_P_SAT_ptr = P_SW_P_SAT.DataStart();
		const float* P_SW_P_SAT_Eptr = P_SW_P_SAT.GridEnd();
		 value =  0.000002;
		value = P_SW_P_SAT.ParameterValue(value);
		while( P_SW_P_SAT_ptr < P_SW_P_SAT_Eptr ) {
			*P_SW_P_SAT_ptr = value;
			P_SW_P_SAT_ptr++;
		}
		P_SW_P_SAT.GrabMemory();
		if( P_SW_P_SAT.GetF(FLinkEdges) ) { P_SW_P_SAT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_SW_P_SAT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.000002;
			P_SW_P_SAT.Update( p, P_SW_P_SAT.ParameterValue(value,p) );
		}
		P_SW_P_SAT.GrabMemory();
		if( P_SW_P_SAT.GetF(FLinkEdges) ) { P_SW_P_SAT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.000002;
			P_SW_P_SAT.Update( P_SW_P_SAT.ParameterValue(value) );
	  } break;
	}
	P_SW_P_SAT.UpdateGOFComputation();
	return 0;
}

int SEAWEED_module::P_SW_RESP_RT_u177_exe() {
	float value;
	int array_index[64];


	switch( P_SW_RESP_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_SW_RESP_RT_ptr = P_SW_RESP_RT.DataStart();
		const float* P_SW_RESP_RT_Eptr = P_SW_RESP_RT.GridEnd();
		while( P_SW_RESP_RT_ptr < P_SW_RESP_RT_Eptr ) {
		 value =  ( 1.25e-5/24 );
			*P_SW_RESP_RT_ptr = value;
			P_SW_RESP_RT_ptr++;
		}
		P_SW_RESP_RT.GrabMemory();
		if( P_SW_RESP_RT.GetF(FLinkEdges) ) { P_SW_RESP_RT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_SW_RESP_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( 1.25e-5/24 );
			P_SW_RESP_RT.Update( p, value );
		}
		P_SW_RESP_RT.GrabMemory();
		if( P_SW_RESP_RT.GetF(FLinkEdges) ) { P_SW_RESP_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( 1.25e-5/24 );
			P_SW_RESP_RT.Update( value );
	  } break;
	}
	P_SW_RESP_RT.UpdateGOFComputation();
	return 0;
}

SEAWEED_module* SEAWEED_module::fInstance = NULL;
SEAWEED_module* SEAWEED_module::kNullModel = (SEAWEED_module*)0x1;
int SEAWEED_module::InitVars() {
	TIME.SSInit(this);
	SEAWEEDS.SSInit(this);
	SW_MORT.SSInit(this);
	SW_MORT.SetOrigin(&SEAWEEDS);
	WATER_LAYER_DEPTH.SSInit(this);
	P_CELL_AREA.SSInit(this);
	P_IC_PHT.SSInit(this);
	SF_WATER.SSInit(this);
	CONS_INGEST_SW.SSInit(this);
	BOTTOM_MAP.SSInit(this);
	P_ON_MAP.SSInit(this);
	WATER_DEPTH.SSInit(this);
	LIGHT_TO_PHYTOPLANKTON.SSInit(this);
	DIN_CONC.SSInit(this);
	PO4_SF_WT_CONC.SSInit(this);
	OM3_TEMP.SSInit(this);
	SW_GROSS_PP.SSInit(this);
	SW_GROSS_PP.SetDestination(&SEAWEEDS);
	SW_EXCHANGE.SSInit(this);
	SW_EXCHANGE.SetOrigin(&SEAWEEDS);
	SW_RESP.SSInit(this);
	SW_RESP.SetOrigin(&SEAWEEDS);
	SW_CONSUMED.SSInit(this);
	SW_CONSUMED.SetOrigin(&SEAWEEDS);
	IC_SEAWEED.SSInit(this);
	OVERALL_FLOW_VELOCITY.SSInit(this);
	SW_CONC.SSInit(this);
	SW_LIGHT_LIM.SSInit(this);
	SW_NET_PROD.SSInit(this);
	SW_NUT_LIMIT.SSInit(this);
	SW_PROD_LIM.SSInit(this);
	SW_TEMP_LIM.SSInit(this);
	P_SW_MAX_T.SSInit(this);
	P_SW_MIN_T.SSInit(this);
	P_SW_MORT_RT.SSInit(this);
	P_SW_NC.SSInit(this);
	P_SW_N_SAT.SSInit(this);
	P_SW_OPT_T.SSInit(this);
	P_SW_PC.SSInit(this);
	P_SW_PP_RT.SSInit(this);
	P_SW_P_SAT.SSInit(this);
	P_SW_RESP_RT.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int SEAWEED_module::SetupEvents() {
	TExecuteCommand* I153 = (TExecuteCommand*) SEAWEEDS.GetCommand("I153",TCommand::kIntegrate,TCommand::kCode);
	I153->SetExecutable(&SEAWEEDS_I153_exe_g);
	I153->Code() = "I153 <- ( ( ( ( SW_GROSS_PP-SW_EXCHANGE )-SW_RESP )-SW_CONSUMED )-SW_MORT )";
	I153->AddDependency(SW_GROSS_PP);
	I153->AddDependency(SW_EXCHANGE);
	I153->AddDependency(SW_RESP);
	I153->AddDependency(SW_CONSUMED);
	I153->AddDependency(SW_MORT);
	I153->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i154 = (TExecuteCommand*) SEAWEEDS.GetCommand("i154",TCommand::kInit,TCommand::kCode);
	i154->SetExecutable(&SEAWEEDS_i154_exe_g);
	i154->Code() = "i154 <- ( ( ( WATER_LAYER_DEPTH*P_CELL_AREA )*P_IC_PHT )*.001 )";
	i154->AddDependency(WATER_LAYER_DEPTH);
	i154->AddDependency(P_CELL_AREA);
	i154->AddDependency(P_IC_PHT);
	i154->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u159 = (TExecuteCommand*) SW_MORT.GetCommand("u159",TCommand::kUpdate,TCommand::kCode);
	u159->SetExecutable(&SW_MORT_u159_exe_g);
	u159->Code() = "u159 <- ( SEAWEEDS*( P_SW_MORT_RT*dT() ) )";
	if( SW_MORT.GetF(FisClamped) ) { u159->AddDependency(SEAWEEDS); }
	u159->AddDependency(SEAWEEDS);
	u159->AddDependency(P_SW_MORT_RT);
	u159->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* WATER_LAYER_DEPTH_import0 = (TImportCommand*) WATER_LAYER_DEPTH.GetCommand("WATER_LAYER_DEPTH_import0",TCommand::kUndefined,TCommand::kImport);
	WATER_LAYER_DEPTH_import0->Code() = "Import WATER_LAYER_DEPTH";
	WATER_LAYER_DEPTH_import0->AddDependency(WATER_LAYER_DEPTH);
	WATER_LAYER_DEPTH_import0->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P_CELL_AREA_import1 = (TImportCommand*) P_CELL_AREA.GetCommand("P_CELL_AREA_import1",TCommand::kUndefined,TCommand::kImport);
	P_CELL_AREA_import1->Code() = "Import P_CELL_AREA";
	P_CELL_AREA_import1->AddDependency(P_CELL_AREA);
	P_CELL_AREA_import1->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P_IC_PHT_import2 = (TImportCommand*) P_IC_PHT.GetCommand("P_IC_PHT_import2",TCommand::kUndefined,TCommand::kImport);
	P_IC_PHT_import2->Code() = "Import P_IC_PHT";
	P_IC_PHT_import2->AddDependency(P_IC_PHT);
	P_IC_PHT_import2->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WATER_import3 = (TImportCommand*) SF_WATER.GetCommand("SF_WATER_import3",TCommand::kUndefined,TCommand::kImport);
	SF_WATER_import3->Code() = "Import SF_WATER";
	SF_WATER_import3->AddDependency(SF_WATER);
	SF_WATER_import3->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* CONS_INGEST_SW_import4 = (TImportCommand*) CONS_INGEST_SW.GetCommand("CONS_INGEST_SW_import4",TCommand::kUndefined,TCommand::kImport);
	CONS_INGEST_SW_import4->Code() = "Import CONS_INGEST_SW";
	CONS_INGEST_SW_import4->AddDependency(CONS_INGEST_SW);
	CONS_INGEST_SW_import4->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* BOTTOM_MAP_import5 = (TImportCommand*) BOTTOM_MAP.GetCommand("BOTTOM_MAP_import5",TCommand::kUndefined,TCommand::kImport);
	BOTTOM_MAP_import5->Code() = "Import BOTTOM_MAP";
	BOTTOM_MAP_import5->AddDependency(BOTTOM_MAP);
	BOTTOM_MAP_import5->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P_ON_MAP_import6 = (TImportCommand*) P_ON_MAP.GetCommand("P_ON_MAP_import6",TCommand::kUndefined,TCommand::kImport);
	P_ON_MAP_import6->Code() = "Import P_ON_MAP";
	P_ON_MAP_import6->AddDependency(P_ON_MAP);
	P_ON_MAP_import6->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* WATER_DEPTH_import7 = (TImportCommand*) WATER_DEPTH.GetCommand("WATER_DEPTH_import7",TCommand::kUndefined,TCommand::kImport);
	WATER_DEPTH_import7->Code() = "Import WATER_DEPTH";
	WATER_DEPTH_import7->AddDependency(WATER_DEPTH);
	WATER_DEPTH_import7->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* LIGHT_TO_PHYTOPLANKTON_import8 = (TImportCommand*) LIGHT_TO_PHYTOPLANKTON.GetCommand("LIGHT_TO_PHYTOPLANKTON_import8",TCommand::kUndefined,TCommand::kImport);
	LIGHT_TO_PHYTOPLANKTON_import8->Code() = "Import LIGHT_TO_PHYTOPLANKTON";
	LIGHT_TO_PHYTOPLANKTON_import8->AddDependency(LIGHT_TO_PHYTOPLANKTON);
	LIGHT_TO_PHYTOPLANKTON_import8->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DIN_CONC_import9 = (TImportCommand*) DIN_CONC.GetCommand("DIN_CONC_import9",TCommand::kUndefined,TCommand::kImport);
	DIN_CONC_import9->Code() = "Import DIN_CONC";
	DIN_CONC_import9->AddDependency(DIN_CONC);
	DIN_CONC_import9->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PO4_SF_WT_CONC_import10 = (TImportCommand*) PO4_SF_WT_CONC.GetCommand("PO4_SF_WT_CONC_import10",TCommand::kUndefined,TCommand::kImport);
	PO4_SF_WT_CONC_import10->Code() = "Import PO4_SF_WT_CONC";
	PO4_SF_WT_CONC_import10->AddDependency(PO4_SF_WT_CONC);
	PO4_SF_WT_CONC_import10->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* OM3_TEMP_import11 = (TImportCommand*) OM3_TEMP.GetCommand("OM3_TEMP_import11",TCommand::kUndefined,TCommand::kImport);
	OM3_TEMP_import11->Code() = "Import OM3_TEMP";
	OM3_TEMP_import11->AddDependency(OM3_TEMP);
	OM3_TEMP_import11->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u155 = (TExecuteCommand*) SW_GROSS_PP.GetCommand("u155",TCommand::kUpdate,TCommand::kCode);
	u155->SetExecutable(&SW_GROSS_PP_u155_exe_g);
	u155->Code() = "u155 <- ( ( ( SW_PROD_LIM*P_SW_PP_RT )/dT() )*SEAWEEDS )";
	u155->AddDependency(SW_PROD_LIM);
	u155->AddDependency(P_SW_PP_RT);
	u155->AddDependency(SEAWEEDS);
	u155->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u156 = (TExecuteCommand*) SW_EXCHANGE.GetCommand("u156",TCommand::kUpdate,TCommand::kCode);
	u156->SetExecutable(&SW_EXCHANGE_u156_exe_g);
	u156->Code() = "u156 <-  ( ( ( OVERALL_FLOW_VELOCITY >  0.5 ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ";
	if( SW_EXCHANGE.GetF(FisClamped) ) { u156->AddDependency(SEAWEEDS); }
	u156->AddDependency(OVERALL_FLOW_VELOCITY);
	u156->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u157 = (TExecuteCommand*) SW_RESP.GetCommand("u157",TCommand::kUpdate,TCommand::kCode);
	u157->SetExecutable(&SW_RESP_u157_exe_g);
	u157->Code() = "u157 <-  ( ( ( SF_WATER >  ((float)0) ) ) ? ( ( ( ( P_SW_RESP_RT*dT() )*SW_TEMP_LIM )*SEAWEEDS ) ) : ( ((float)0) ) ) ";
	if( SW_RESP.GetF(FisClamped) ) { u157->AddDependency(SEAWEEDS); }
	u157->AddDependency(SF_WATER);
	u157->AddDependency(P_SW_RESP_RT);
	u157->AddDependency(SW_TEMP_LIM);
	u157->AddDependency(SEAWEEDS);
	u157->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u158 = (TExecuteCommand*) SW_CONSUMED.GetCommand("u158",TCommand::kUpdate,TCommand::kCode);
	u158->SetExecutable(&SW_CONSUMED_u158_exe_g);
	u158->Code() = "u158 <- CONS_INGEST_SW";
	if( SW_CONSUMED.GetF(FisClamped) ) { u158->AddDependency(SEAWEEDS); }
	u158->AddDependency(CONS_INGEST_SW);
	u158->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u160 = (TExecuteCommand*) IC_SEAWEED.GetCommand("u160",TCommand::kUpdate,TCommand::kCode);
	u160->SetExecutable(&IC_SEAWEED_u160_exe_g);
	u160->Code() = "u160 <-  ( ( ( BOTTOM_MAP == ((float)1) ) ) ? ( 0.001 ) : ( ((float)0) ) ) ";
	u160->AddDependency(BOTTOM_MAP);
	u160->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u161 = (TExecuteCommand*) OVERALL_FLOW_VELOCITY.GetCommand("u161",TCommand::kUpdate,TCommand::kCode);
	u161->SetExecutable(&OVERALL_FLOW_VELOCITY_u161_exe_g);
	u161->Code() = "u161 <- 0";
	u161->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u162 = (TExecuteCommand*) SW_CONC.GetCommand("u162",TCommand::kUpdate,TCommand::kCode);
	u162->SetExecutable(&SW_CONC_u162_exe_g);
	u162->Code() = "u162 <-  ( ( ( ( P_ON_MAP <  ((float)2) ) && ( WATER_DEPTH >  0.01 ) ) ) ? ( ( SEAWEEDS/SF_WATER ) ) : ( ((float)0) ) ) ";
	u162->AddDependency(P_ON_MAP);
	u162->AddDependency(WATER_DEPTH);
	u162->AddDependency(SEAWEEDS);
	u162->AddDependency(SF_WATER);
	u162->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u163 = (TExecuteCommand*) SW_LIGHT_LIM.GetCommand("u163",TCommand::kUpdate,TCommand::kCode);
	u163->SetExecutable(&SW_LIGHT_LIM_u163_exe_g);
	u163->Code() = "u163 <- SL::Min(( LIGHT_TO_PHYTOPLANKTON*((float)3) ), ((float)1))";
	u163->AddDependency(LIGHT_TO_PHYTOPLANKTON);
	u163->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u164 = (TExecuteCommand*) SW_NET_PROD.GetCommand("u164",TCommand::kUpdate,TCommand::kCode);
	u164->SetExecutable(&SW_NET_PROD_u164_exe_g);
	u164->Code() = "u164 <- ( SW_GROSS_PP-SW_RESP )";
	u164->AddDependency(SW_GROSS_PP);
	u164->AddDependency(SW_RESP);
	u164->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u165 = (TExecuteCommand*) SW_NUT_LIMIT.GetCommand("u165",TCommand::kUpdate,TCommand::kCode);
	u165->SetExecutable(&SW_NUT_LIMIT_u165_exe_g);
	u165->Code() = "u165 <- SL::Min(( DIN_CONC/( DIN_CONC+P_SW_N_SAT ) ), ( PO4_SF_WT_CONC/( PO4_SF_WT_CONC+P_SW_P_SAT ) ))";
	u165->AddDependency(DIN_CONC);
	u165->AddDependency(P_SW_N_SAT);
	u165->AddDependency(PO4_SF_WT_CONC);
	u165->AddDependency(P_SW_P_SAT);
	u165->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u166 = (TExecuteCommand*) SW_PROD_LIM.GetCommand("u166",TCommand::kUpdate,TCommand::kCode);
	u166->SetExecutable(&SW_PROD_LIM_u166_exe_g);
	u166->Code() = "u166 <-  ( ( ( SF_WATER >  ((float)0) ) ) ? ( SL::Min(SW_TEMP_LIM, SW_NUT_LIMIT, SW_TEMP_LIM, SW_LIGHT_LIM) ) : ( ((float)0) ) ) ";
	u166->AddDependency(SF_WATER);
	u166->AddDependency(SW_TEMP_LIM);
	u166->AddDependency(SW_NUT_LIMIT);
	u166->AddDependency(SW_LIGHT_LIM);
	u166->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u167 = (TExecuteCommand*) SW_TEMP_LIM.GetCommand("u167",TCommand::kUpdate,TCommand::kCode);
	u167->SetExecutable(&SW_TEMP_LIM_u167_exe_g);
	u167->Code() = "u167 <-  ( ( ( ( OM3_TEMP >  P_SW_MAX_T ) || ( OM3_TEMP <  P_SW_MIN_T ) ) ) ? ( ((float)0) ) : ( ( ((float)1)-SL::Abs(( ( OM3_TEMP-P_SW_OPT_T )/( OM3_TEMP+P_SW_OPT_T ) )) ) ) ) ";
	u167->AddDependency(OM3_TEMP);
	u167->AddDependency(P_SW_MAX_T);
	u167->AddDependency(P_SW_MIN_T);
	u167->AddDependency(P_SW_OPT_T);
	u167->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u168 = (TExecuteCommand*) P_SW_MAX_T.GetCommand("u168",TCommand::kUpdate,TCommand::kCode);
	u168->SetExecutable(&P_SW_MAX_T_u168_exe_g);
	u168->Code() = "u168 <- 40";
	u168->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u169 = (TExecuteCommand*) P_SW_MIN_T.GetCommand("u169",TCommand::kUpdate,TCommand::kCode);
	u169->SetExecutable(&P_SW_MIN_T_u169_exe_g);
	u169->Code() = "u169 <- 0";
	u169->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u170 = (TExecuteCommand*) P_SW_MORT_RT.GetCommand("u170",TCommand::kUpdate,TCommand::kCode);
	u170->SetExecutable(&P_SW_MORT_RT_u170_exe_g);
	u170->Code() = "u170 <- ( ((float)2e-3)/24 )";
	u170->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u171 = (TExecuteCommand*) P_SW_NC.GetCommand("u171",TCommand::kUpdate,TCommand::kCode);
	u171->SetExecutable(&P_SW_NC_u171_exe_g);
	u171->Code() = "u171 <- 0.010000";
	u171->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u172 = (TExecuteCommand*) P_SW_N_SAT.GetCommand("u172",TCommand::kUpdate,TCommand::kCode);
	u172->SetExecutable(&P_SW_N_SAT_u172_exe_g);
	u172->Code() = "u172 <- 0.000025";
	u172->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u173 = (TExecuteCommand*) P_SW_OPT_T.GetCommand("u173",TCommand::kUpdate,TCommand::kCode);
	u173->SetExecutable(&P_SW_OPT_T_u173_exe_g);
	u173->Code() = "u173 <- 20";
	u173->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u174 = (TExecuteCommand*) P_SW_PC.GetCommand("u174",TCommand::kUpdate,TCommand::kCode);
	u174->SetExecutable(&P_SW_PC_u174_exe_g);
	u174->Code() = "u174 <- 0.005000";
	u174->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u175 = (TExecuteCommand*) P_SW_PP_RT.GetCommand("u175",TCommand::kUpdate,TCommand::kCode);
	u175->SetExecutable(&P_SW_PP_RT_u175_exe_g);
	u175->Code() = "u175 <- 0.025000";
	u175->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u176 = (TExecuteCommand*) P_SW_P_SAT.GetCommand("u176",TCommand::kUpdate,TCommand::kCode);
	u176->SetExecutable(&P_SW_P_SAT_u176_exe_g);
	u176->Code() = "u176 <- 0.000002";
	u176->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u177 = (TExecuteCommand*) P_SW_RESP_RT.GetCommand("u177",TCommand::kUpdate,TCommand::kCode);
	u177->SetExecutable(&P_SW_RESP_RT_u177_exe_g);
	u177->Code() = "u177 <- ( 1.25e-5/24 )";
	u177->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int SEAWEED_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int SEAWEED_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int SEAWEED_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int SEAWEED_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class TSS_module 
// ---------------------------------------------------------------------------
TSS_module::TSS_module(char* name) :
	TIME("TIME"),
	TSS_CONC("TSS_CONC"),
	SF_WATER("SF_WATER"),
	BOTTOM_MAP("BOTTOM_MAP"),
	VEG_STRUCTURE("VEG_STRUCTURE"),
	OM3_SHEAR_STRESS("OM3_SHEAR_STRESS"),
	SUS_SED("SUS_SED"),
	SED_SUSP("SED_SUSP"),
	SED_DEPO("SED_DEPO"),
	POT_EROS("POT_EROS"),
	RIVER_TSS("RIVER_TSS"),
	SHEAR_RES("SHEAR_RES"),
	STRESS_EFFECT("STRESS_EFFECT"),
	P_IC_TSS("P_IC_TSS"),
	P_RESISTANCE_COEFF("P_RESISTANCE_COEFF"),
	P_SETTLING_RT("P_SETTLING_RT"),
	TModule(name) {

	TSS_CONC.SetF(FisExport,True,"CG");
	SF_WATER.SetF(FisImport,True,"CG");
	BOTTOM_MAP.SetF(FisImport,True,"CG");
	VEG_STRUCTURE.SetF(FisImport,True,"CG");
	OM3_SHEAR_STRESS.SetF(FisImport,True,"CG");
	SUS_SED.SetF(FHasNegFlux,True,"CG");
	SED_DEPO.SetF(FHasNegFlux,True,"CG");
}	
int TSS_module::SUS_SED_I178_exe() {
	float value;
	int array_index[64];


	SUS_SED.UpdateIntegrator();
	switch( SUS_SED.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* SUS_SED_ptr = SUS_SED.DataStart();
		const float* SUS_SED_Eptr = SUS_SED.GridEnd();
		float dt = dT();
		float* SUS_SED_Rptr = SUS_SED.RDataStart();
		float* SED_SUSP_ptr = SED_SUSP.DataStart();
		float* SED_DEPO_ptr = SED_DEPO.DataStart();
		switch( SUS_SED.CurrentOrder() ) {
		  case 1: {
			if( SUS_SED.Order() > 1 ) {
			float *SUS_SED_IMptr0 = SUS_SED.SIntegratorMemory().LastData();
			while( SUS_SED_ptr < SUS_SED_Eptr ) {
		 value =  ( (*(SED_SUSP_ptr))-(*(SED_DEPO_ptr)) );
				*SUS_SED_ptr += value*dt;
				if(SUS_SED_Rptr) { *SUS_SED_Rptr++ = *SUS_SED_ptr; }
				*SUS_SED_IMptr0++ = value;
				SUS_SED_ptr++;
				SED_SUSP.UpdateDataPtr(SED_SUSP_ptr);
				SED_DEPO.UpdateDataPtr(SED_DEPO_ptr);
			}
			} else {
			while( SUS_SED_ptr < SUS_SED_Eptr ) {
		 value =  ( (*(SED_SUSP_ptr))-(*(SED_DEPO_ptr)) );
				*SUS_SED_ptr += value*dt;
				if(SUS_SED_Rptr) { *SUS_SED_Rptr++ = *SUS_SED_ptr; }
				SUS_SED_ptr++;
				SED_SUSP.UpdateDataPtr(SED_SUSP_ptr);
				SED_DEPO.UpdateDataPtr(SED_DEPO_ptr);
			}
			};
		  } break; case 2: {
			float *SUS_SED_IMptr0 = SUS_SED.SIntegratorMemory().LastData();
			float *SUS_SED_IMptr1 = SUS_SED.SIntegratorMemory().LastDataOffset(1);
			while( SUS_SED_ptr < SUS_SED_Eptr ) {
		 value =  ( (*(SED_SUSP_ptr))-(*(SED_DEPO_ptr)) );
				*SUS_SED_IMptr0++ = value;
				*SUS_SED_ptr += ( 1.5*value - 0.5* *SUS_SED_IMptr1++ )*dt;
				if(SUS_SED_Rptr) { *SUS_SED_Rptr++ = *SUS_SED_ptr; }
				SUS_SED_ptr++;
				SED_SUSP.UpdateDataPtr(SED_SUSP_ptr);
				SED_DEPO.UpdateDataPtr(SED_DEPO_ptr);
			}
		  } break; case 3: {
			float *SUS_SED_IMptr0 = SUS_SED.SIntegratorMemory().LastData();
			float *SUS_SED_IMptr1 = SUS_SED.SIntegratorMemory().LastDataOffset(1);
			float *SUS_SED_IMptr2 = SUS_SED.SIntegratorMemory().LastDataOffset(2);
			while( SUS_SED_ptr < SUS_SED_Eptr ) {
		 value =  ( (*(SED_SUSP_ptr))-(*(SED_DEPO_ptr)) );
				*SUS_SED_IMptr0++ = value;
				*SUS_SED_ptr += (1.92*value - 1.33* *SUS_SED_IMptr1++ + .42* *SUS_SED_IMptr2++)*dt;
				if(SUS_SED_Rptr) { *SUS_SED_Rptr++ = *SUS_SED_ptr; }
				SUS_SED_ptr++;
				SED_SUSP.UpdateDataPtr(SED_SUSP_ptr);
				SED_DEPO.UpdateDataPtr(SED_DEPO_ptr);
			}
		  } break; case 4: {
			float *SUS_SED_IMptr0 = SUS_SED.SIntegratorMemory().LastData();
			float *SUS_SED_IMptr1 = SUS_SED.SIntegratorMemory().LastDataOffset(1);
			float *SUS_SED_IMptr2 = SUS_SED.SIntegratorMemory().LastDataOffset(2);
			float *SUS_SED_IMptr3 = SUS_SED.SIntegratorMemory().LastDataOffset(3);
			while( SUS_SED_ptr < SUS_SED_Eptr ) {
		 value =  ( (*(SED_SUSP_ptr))-(*(SED_DEPO_ptr)) );
				*SUS_SED_IMptr0++ = value;
				*SUS_SED_ptr += (2.29*value - 2.46* *SUS_SED_IMptr1++  + 1.54* *SUS_SED_IMptr2++ - .375* *SUS_SED_IMptr3++ )*dt;
				if(SUS_SED_Rptr) { *SUS_SED_Rptr++ = *SUS_SED_ptr; }
				SUS_SED_ptr++;
				SED_SUSP.UpdateDataPtr(SED_SUSP_ptr);
				SED_DEPO.UpdateDataPtr(SED_DEPO_ptr);
			}
		  } break; default: { gPrintErr("Illegal Order in StateVar update!"); }
		};
		SUS_SED.GrabMemory();
		if( SUS_SED.GetF(FLinkEdges) ) { SUS_SED.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = SUS_SED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( SED_SUSP.Value(p)-SED_DEPO.Value(p) );
			SUS_SED.Update( p, value, dT() );
		}
		SUS_SED.GrabMemory();
		if( SUS_SED.GetF(FLinkEdges) ) { SUS_SED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( SED_SUSP.Value()-SED_DEPO.Value() );
			SUS_SED.Update( value, dT() );
	  } break;
	}
	SUS_SED.UpdateGOFComputation();
	return 0;
}

int TSS_module::SUS_SED_i179_exe() {
	float value;
	int array_index[64];


	switch( SUS_SED.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* SUS_SED_ptr = SUS_SED.DataStart();
		const float* SUS_SED_Eptr = SUS_SED.GridEnd();
		float dt = dT();
		float* SUS_SED_Rptr = SUS_SED.RDataStart();
		float* SF_WATER_ptr = SF_WATER.DataStart();
		float* P_IC_TSS_ptr = P_IC_TSS.DataStart();
		while( SUS_SED_ptr < SUS_SED_Eptr ) {
		 value =  ( (*(SF_WATER_ptr))*(*(P_IC_TSS_ptr)) );
			if(SUS_SED_Rptr) { *SUS_SED_Rptr = *SUS_SED_ptr = value;  SUS_SED_Rptr++; }
			else { *SUS_SED_ptr = value; }
			SUS_SED_ptr++;
			SF_WATER.UpdateDataPtr(SF_WATER_ptr);
			P_IC_TSS.UpdateDataPtr(P_IC_TSS_ptr);
		}
		SUS_SED.GrabMemory();
		if( SUS_SED.GetF(FLinkEdges) ) { SUS_SED.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = SUS_SED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( SF_WATER.Value(p)*P_IC_TSS.Value(p) );
			SUS_SED.InitValue( p, value );
		}
		SUS_SED.GrabMemory();
		if( SUS_SED.GetF(FLinkEdges) ) { SUS_SED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( SF_WATER.Value()*P_IC_TSS.Value() );
			SUS_SED.InitValue( value );
	  } break;
	}
	SUS_SED.UpdateGOFComputation();
	return 0;
}

int TSS_module::SED_SUSP_u180_exe() {
	float value;
	int array_index[64];


	switch( SED_SUSP.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* SED_SUSP_ptr = SED_SUSP.DataStart();
		const float* SED_SUSP_Eptr = SED_SUSP.GridEnd();
		float dt = dT();
		float* POT_EROS_ptr = POT_EROS.DataStart();
		int clamped = 0;
		while( SED_SUSP_ptr < SED_SUSP_Eptr ) {
		 value =   ( ( ( (*(POT_EROS_ptr)) >  ((float)0) ) ) ? ( (*(POT_EROS_ptr)) ) : ( ((float)0) ) ) ;
			*SED_SUSP_ptr = value;
			SED_SUSP_ptr++;
			POT_EROS.UpdateDataPtr(POT_EROS_ptr);
		}
		if( SED_SUSP.GetF(FICFlux) ) SED_SUSP.Cov().Set(0.0); 
		SED_SUSP.GrabMemory();
		if( SED_SUSP.GetF(FLinkEdges) ) { SED_SUSP.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = SED_SUSP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( POT_EROS.Value(p) >  ((float)0) ) ) ? ( POT_EROS.Value(p) ) : ( ((float)0) ) ) ;
			SED_SUSP.Update( p, value );
		}
		SED_SUSP.GrabMemory();
		if( SED_SUSP.GetF(FICFlux) ) SED_SUSP.Cov().Set(0.0); 
		if( SED_SUSP.GetF(FLinkEdges) ) { SED_SUSP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( POT_EROS.Value() >  ((float)0) ) ) ? ( POT_EROS.Value() ) : ( ((float)0) ) ) ;
			SED_SUSP.Update( value );
	  } break;
	}
	SED_SUSP.UpdateGOFComputation();
	return 0;
}

int TSS_module::SED_DEPO_u181_exe() {
	float value;
	int array_index[64];


	switch( SED_DEPO.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* SED_DEPO_ptr = SED_DEPO.DataStart();
		const float* SED_DEPO_Eptr = SED_DEPO.GridEnd();
		float dt = dT();
		float* SED_DEPO_Optr = ((CStateVariable*)(SED_DEPO.Origin()))->RDataStart();
		float* P_SETTLING_RT_ptr = P_SETTLING_RT.DataStart();
		float* SUS_SED_ptr = SUS_SED.DataStart();
		int clamped = SUS_SED.GetF(FisClamped);
		while( SED_DEPO_ptr < SED_DEPO_Eptr ) {
		 value =  ( (*(P_SETTLING_RT_ptr))*(*(SUS_SED_ptr)) );
			*SED_DEPO_ptr = value;
			if( clamped ) { SL::Clamp(SED_DEPO_Optr++,SED_DEPO_ptr,dt); }
			SED_DEPO_ptr++;
			P_SETTLING_RT.UpdateDataPtr(P_SETTLING_RT_ptr);
			SUS_SED.UpdateDataPtr(SUS_SED_ptr);
		}
		if( SED_DEPO.GetF(FICFlux) ) SED_DEPO.Cov().Set(0.0); 
		SED_DEPO.GrabMemory();
		if( SED_DEPO.GetF(FLinkEdges) ) { SED_DEPO.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = SED_DEPO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( P_SETTLING_RT.Value(p)*SUS_SED.Value(p) );
			SED_DEPO.Update( p, value );
		}
		SED_DEPO.GrabMemory();
		if( SED_DEPO.GetF(FICFlux) ) SED_DEPO.Cov().Set(0.0); 
		if( SED_DEPO.GetF(FLinkEdges) ) { SED_DEPO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( P_SETTLING_RT.Value()*SUS_SED.Value() );
			SED_DEPO.Update( value );
	  } break;
	}
	SED_DEPO.UpdateGOFComputation();
	return 0;
}

int TSS_module::POT_EROS_u182_exe() {
	float value;
	int array_index[64];


	switch( POT_EROS.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* POT_EROS_ptr = POT_EROS.DataStart();
		const float* POT_EROS_Eptr = POT_EROS.GridEnd();
		float* BOTTOM_MAP_ptr = BOTTOM_MAP.DataStart();
		float* STRESS_EFFECT_ptr = STRESS_EFFECT.DataStart();
		while( POT_EROS_ptr < POT_EROS_Eptr ) {
		 value =   ( ( ( (*(BOTTOM_MAP_ptr)) == ((float)1) ) ) ? ( (*(STRESS_EFFECT_ptr)) ) : ( ((float)0) ) ) ;
			*POT_EROS_ptr = value;
			POT_EROS_ptr++;
			BOTTOM_MAP.UpdateDataPtr(BOTTOM_MAP_ptr);
			STRESS_EFFECT.UpdateDataPtr(STRESS_EFFECT_ptr);
		}
		POT_EROS.GrabMemory();
		if( POT_EROS.GetF(FLinkEdges) ) { POT_EROS.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = POT_EROS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( BOTTOM_MAP.Value(p) == ((float)1) ) ) ? ( STRESS_EFFECT.Value(p) ) : ( ((float)0) ) ) ;
			POT_EROS.Update( p, value );
		}
		POT_EROS.GrabMemory();
		if( POT_EROS.GetF(FLinkEdges) ) { POT_EROS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( BOTTOM_MAP.Value() == ((float)1) ) ) ? ( STRESS_EFFECT.Value() ) : ( ((float)0) ) ) ;
			POT_EROS.Update( value );
	  } break;
	}
	POT_EROS.UpdateGOFComputation();
	return 0;
}

int TSS_module::RIVER_TSS_u183_exe() {
	float value;
	int array_index[64];


	switch( RIVER_TSS.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* RIVER_TSS_ptr = RIVER_TSS.DataStart();
		const float* RIVER_TSS_Eptr = RIVER_TSS.GridEnd();
		 value =  0;
		value = RIVER_TSS.ParameterValue(value);
		while( RIVER_TSS_ptr < RIVER_TSS_Eptr ) {
			*RIVER_TSS_ptr = value;
			RIVER_TSS_ptr++;
		}
		RIVER_TSS.GrabMemory();
		if( RIVER_TSS.GetF(FLinkEdges) ) { RIVER_TSS.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = RIVER_TSS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0;
			RIVER_TSS.Update( p, RIVER_TSS.ParameterValue(value,p) );
		}
		RIVER_TSS.GrabMemory();
		if( RIVER_TSS.GetF(FLinkEdges) ) { RIVER_TSS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0;
			RIVER_TSS.Update( RIVER_TSS.ParameterValue(value) );
	  } break;
	}
	RIVER_TSS.UpdateGOFComputation();
	return 0;
}

int TSS_module::SHEAR_RES_u184_exe() {
	float value;
	int array_index[64];


	switch( SHEAR_RES.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* SHEAR_RES_ptr = SHEAR_RES.DataStart();
		const float* SHEAR_RES_Eptr = SHEAR_RES.GridEnd();
		float* P_RESISTANCE_COEFF_ptr = P_RESISTANCE_COEFF.DataStart();
		float* VEG_STRUCTURE_ptr = VEG_STRUCTURE.DataStart();
		while( SHEAR_RES_ptr < SHEAR_RES_Eptr ) {
		 value =  ( (*(P_RESISTANCE_COEFF_ptr))*( ((float)1)+(*(VEG_STRUCTURE_ptr)) ) );
			*SHEAR_RES_ptr = value;
			SHEAR_RES_ptr++;
			P_RESISTANCE_COEFF.UpdateDataPtr(P_RESISTANCE_COEFF_ptr);
			VEG_STRUCTURE.UpdateDataPtr(VEG_STRUCTURE_ptr);
		}
		SHEAR_RES.GrabMemory();
		if( SHEAR_RES.GetF(FLinkEdges) ) { SHEAR_RES.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = SHEAR_RES.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  ( P_RESISTANCE_COEFF.Value(p)*( ((float)1)+VEG_STRUCTURE.Value(p) ) );
			SHEAR_RES.Update( p, value );
		}
		SHEAR_RES.GrabMemory();
		if( SHEAR_RES.GetF(FLinkEdges) ) { SHEAR_RES.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  ( P_RESISTANCE_COEFF.Value()*( ((float)1)+VEG_STRUCTURE.Value() ) );
			SHEAR_RES.Update( value );
	  } break;
	}
	SHEAR_RES.UpdateGOFComputation();
	return 0;
}

int TSS_module::STRESS_EFFECT_u185_exe() {
	float value;
	int array_index[64];


	switch( STRESS_EFFECT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* STRESS_EFFECT_ptr = STRESS_EFFECT.DataStart();
		const float* STRESS_EFFECT_Eptr = STRESS_EFFECT.GridEnd();
		float* OM3_SHEAR_STRESS_ptr = OM3_SHEAR_STRESS.DataStart();
		float* SHEAR_RES_ptr = SHEAR_RES.DataStart();
		while( STRESS_EFFECT_ptr < STRESS_EFFECT_Eptr ) {
		 value =   ( ( ( (*(OM3_SHEAR_STRESS_ptr)) >  (*(SHEAR_RES_ptr)) ) ) ? ( ( (*(OM3_SHEAR_STRESS_ptr))-(*(SHEAR_RES_ptr)) ) ) : ( ((float)0) ) ) ;
			*STRESS_EFFECT_ptr = value;
			STRESS_EFFECT_ptr++;
			OM3_SHEAR_STRESS.UpdateDataPtr(OM3_SHEAR_STRESS_ptr);
			SHEAR_RES.UpdateDataPtr(SHEAR_RES_ptr);
		}
		STRESS_EFFECT.GrabMemory();
		if( STRESS_EFFECT.GetF(FLinkEdges) ) { STRESS_EFFECT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = STRESS_EFFECT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =   ( ( ( OM3_SHEAR_STRESS.Value(p) >  SHEAR_RES.Value(p) ) ) ? ( ( OM3_SHEAR_STRESS.Value(p)-SHEAR_RES.Value(p) ) ) : ( ((float)0) ) ) ;
			STRESS_EFFECT.Update( p, value );
		}
		STRESS_EFFECT.GrabMemory();
		if( STRESS_EFFECT.GetF(FLinkEdges) ) { STRESS_EFFECT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =   ( ( ( OM3_SHEAR_STRESS.Value() >  SHEAR_RES.Value() ) ) ? ( ( OM3_SHEAR_STRESS.Value()-SHEAR_RES.Value() ) ) : ( ((float)0) ) ) ;
			STRESS_EFFECT.Update( value );
	  } break;
	}
	STRESS_EFFECT.UpdateGOFComputation();
	return 0;
}

int TSS_module::TSS_CONC_u186_exe() {
	float value;
	int array_index[64];


	switch( TSS_CONC.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* TSS_CONC_ptr = TSS_CONC.DataStart();
		const float* TSS_CONC_Eptr = TSS_CONC.GridEnd();
		float* RIVER_TSS_ptr = RIVER_TSS.DataStart();
		float* SUS_SED_ptr = SUS_SED.DataStart();
		float* SF_WATER_ptr = SF_WATER.DataStart();
		while( TSS_CONC_ptr < TSS_CONC_Eptr ) {
		 value =  SL::Max(( (*(RIVER_TSS_ptr))+( (*(SUS_SED_ptr))/(*(SF_WATER_ptr)) ) ), ((float)0));
			*TSS_CONC_ptr = value;
			TSS_CONC_ptr++;
			RIVER_TSS.UpdateDataPtr(RIVER_TSS_ptr);
			SUS_SED.UpdateDataPtr(SUS_SED_ptr);
			SF_WATER.UpdateDataPtr(SF_WATER_ptr);
		}
		TSS_CONC.GrabMemory();
		if( TSS_CONC.GetF(FLinkEdges) ) { TSS_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = TSS_CONC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  SL::Max(( RIVER_TSS.Value(p)+( SUS_SED.Value(p)/SF_WATER.Value(p) ) ), ((float)0));
			TSS_CONC.Update( p, value );
		}
		TSS_CONC.GrabMemory();
		if( TSS_CONC.GetF(FLinkEdges) ) { TSS_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  SL::Max(( RIVER_TSS.Value()+( SUS_SED.Value()/SF_WATER.Value() ) ), ((float)0));
			TSS_CONC.Update( value );
	  } break;
	}
	TSS_CONC.UpdateGOFComputation();
	return 0;
}

int TSS_module::P_IC_TSS_u187_exe() {
	float value;
	int array_index[64];


	switch( P_IC_TSS.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_IC_TSS_ptr = P_IC_TSS.DataStart();
		const float* P_IC_TSS_Eptr = P_IC_TSS.GridEnd();
		 value =  0.008000;
		value = P_IC_TSS.ParameterValue(value);
		while( P_IC_TSS_ptr < P_IC_TSS_Eptr ) {
			*P_IC_TSS_ptr = value;
			P_IC_TSS_ptr++;
		}
		P_IC_TSS.GrabMemory();
		if( P_IC_TSS.GetF(FLinkEdges) ) { P_IC_TSS.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_IC_TSS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.008000;
			P_IC_TSS.Update( p, P_IC_TSS.ParameterValue(value,p) );
		}
		P_IC_TSS.GrabMemory();
		if( P_IC_TSS.GetF(FLinkEdges) ) { P_IC_TSS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.008000;
			P_IC_TSS.Update( P_IC_TSS.ParameterValue(value) );
	  } break;
	}
	P_IC_TSS.UpdateGOFComputation();
	return 0;
}

int TSS_module::P_RESISTANCE_COEFF_u188_exe() {
	float value;
	int array_index[64];


	switch( P_RESISTANCE_COEFF.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_RESISTANCE_COEFF_ptr = P_RESISTANCE_COEFF.DataStart();
		const float* P_RESISTANCE_COEFF_Eptr = P_RESISTANCE_COEFF.GridEnd();
		 value =  0.000100;
		value = P_RESISTANCE_COEFF.ParameterValue(value);
		while( P_RESISTANCE_COEFF_ptr < P_RESISTANCE_COEFF_Eptr ) {
			*P_RESISTANCE_COEFF_ptr = value;
			P_RESISTANCE_COEFF_ptr++;
		}
		P_RESISTANCE_COEFF.GrabMemory();
		if( P_RESISTANCE_COEFF.GetF(FLinkEdges) ) { P_RESISTANCE_COEFF.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_RESISTANCE_COEFF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.000100;
			P_RESISTANCE_COEFF.Update( p, P_RESISTANCE_COEFF.ParameterValue(value,p) );
		}
		P_RESISTANCE_COEFF.GrabMemory();
		if( P_RESISTANCE_COEFF.GetF(FLinkEdges) ) { P_RESISTANCE_COEFF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.000100;
			P_RESISTANCE_COEFF.Update( P_RESISTANCE_COEFF.ParameterValue(value) );
	  } break;
	}
	P_RESISTANCE_COEFF.UpdateGOFComputation();
	return 0;
}

int TSS_module::P_SETTLING_RT_u189_exe() {
	float value;
	int array_index[64];


	switch( P_SETTLING_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: {
		float* P_SETTLING_RT_ptr = P_SETTLING_RT.DataStart();
		const float* P_SETTLING_RT_Eptr = P_SETTLING_RT.GridEnd();
		 value =  0.046800;
		value = P_SETTLING_RT.ParameterValue(value);
		while( P_SETTLING_RT_ptr < P_SETTLING_RT_Eptr ) {
			*P_SETTLING_RT_ptr = value;
			P_SETTLING_RT_ptr++;
		}
		P_SETTLING_RT.GrabMemory();
		if( P_SETTLING_RT.GetF(FLinkEdges) ) { P_SETTLING_RT.LinkEdges(); }
	  } break;
	  case CVariable::kSpatial: {
		DistributedGrid& g = P_SETTLING_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
		 value =  0.046800;
			P_SETTLING_RT.Update( p, P_SETTLING_RT.ParameterValue(value,p) );
		}
		P_SETTLING_RT.GrabMemory();
		if( P_SETTLING_RT.GetF(FLinkEdges) ) { P_SETTLING_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
		 value =  0.046800;
			P_SETTLING_RT.Update( P_SETTLING_RT.ParameterValue(value) );
	  } break;
	}
	P_SETTLING_RT.UpdateGOFComputation();
	return 0;
}

TSS_module* TSS_module::fInstance = NULL;
TSS_module* TSS_module::kNullModel = (TSS_module*)0x1;
int TSS_module::InitVars() {
	TIME.SSInit(this);
	TSS_CONC.SSInit(this);
	SF_WATER.SSInit(this);
	BOTTOM_MAP.SSInit(this);
	VEG_STRUCTURE.SSInit(this);
	OM3_SHEAR_STRESS.SSInit(this);
	SUS_SED.SSInit(this);
	SUS_SED.SetLinkEdges();
	SED_SUSP.SSInit(this);
	SED_SUSP.SetDestination(&SUS_SED);
	SED_DEPO.SSInit(this);
	SED_DEPO.SetOrigin(&SUS_SED);
	POT_EROS.SSInit(this);
	RIVER_TSS.SSInit(this);
	SHEAR_RES.SSInit(this);
	STRESS_EFFECT.SSInit(this);
	P_IC_TSS.SSInit(this);
	P_RESISTANCE_COEFF.SSInit(this);
	P_SETTLING_RT.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int TSS_module::SetupEvents() {
	TExecuteCommand* u186 = (TExecuteCommand*) TSS_CONC.GetCommand("u186",TCommand::kUpdate,TCommand::kCode);
	u186->SetExecutable(&TSS_CONC_u186_exe_g);
	u186->Code() = "u186 <- SL::Max(( RIVER_TSS+( SUS_SED/SF_WATER ) ), ((float)0))";
	u186->AddDependency(RIVER_TSS);
	u186->AddDependency(SUS_SED);
	u186->AddDependency(SF_WATER);
	u186->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WATER_import0 = (TImportCommand*) SF_WATER.GetCommand("SF_WATER_import0",TCommand::kUndefined,TCommand::kImport);
	SF_WATER_import0->Code() = "Import SF_WATER";
	SF_WATER_import0->AddDependency(SF_WATER);
	SF_WATER_import0->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* BOTTOM_MAP_import1 = (TImportCommand*) BOTTOM_MAP.GetCommand("BOTTOM_MAP_import1",TCommand::kUndefined,TCommand::kImport);
	BOTTOM_MAP_import1->Code() = "Import BOTTOM_MAP";
	BOTTOM_MAP_import1->AddDependency(BOTTOM_MAP);
	BOTTOM_MAP_import1->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* VEG_STRUCTURE_import2 = (TImportCommand*) VEG_STRUCTURE.GetCommand("VEG_STRUCTURE_import2",TCommand::kUndefined,TCommand::kImport);
	VEG_STRUCTURE_import2->Code() = "Import VEG_STRUCTURE";
	VEG_STRUCTURE_import2->AddDependency(VEG_STRUCTURE);
	VEG_STRUCTURE_import2->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* OM3_SHEAR_STRESS_import3 = (TImportCommand*) OM3_SHEAR_STRESS.GetCommand("OM3_SHEAR_STRESS_import3",TCommand::kUndefined,TCommand::kImport);
	OM3_SHEAR_STRESS_import3->Code() = "Import OM3_SHEAR_STRESS";
	OM3_SHEAR_STRESS_import3->AddDependency(OM3_SHEAR_STRESS);
	OM3_SHEAR_STRESS_import3->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I178 = (TExecuteCommand*) SUS_SED.GetCommand("I178",TCommand::kIntegrate,TCommand::kCode);
	I178->SetExecutable(&SUS_SED_I178_exe_g);
	I178->Code() = "I178 <- ( SED_SUSP-SED_DEPO )";
	I178->AddDependency(SED_SUSP);
	I178->AddDependency(SED_DEPO);
	I178->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i179 = (TExecuteCommand*) SUS_SED.GetCommand("i179",TCommand::kInit,TCommand::kCode);
	i179->SetExecutable(&SUS_SED_i179_exe_g);
	i179->Code() = "i179 <- ( SF_WATER*P_IC_TSS )";
	i179->AddDependency(SF_WATER);
	i179->AddDependency(P_IC_TSS);
	i179->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u180 = (TExecuteCommand*) SED_SUSP.GetCommand("u180",TCommand::kUpdate,TCommand::kCode);
	u180->SetExecutable(&SED_SUSP_u180_exe_g);
	u180->Code() = "u180 <-  ( ( ( POT_EROS >  ((float)0) ) ) ? ( POT_EROS ) : ( ((float)0) ) ) ";
	u180->AddDependency(POT_EROS);
	u180->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u181 = (TExecuteCommand*) SED_DEPO.GetCommand("u181",TCommand::kUpdate,TCommand::kCode);
	u181->SetExecutable(&SED_DEPO_u181_exe_g);
	u181->Code() = "u181 <- ( P_SETTLING_RT*SUS_SED )";
	if( SED_DEPO.GetF(FisClamped) ) { u181->AddDependency(SUS_SED); }
	u181->AddDependency(P_SETTLING_RT);
	u181->AddDependency(SUS_SED);
	u181->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u182 = (TExecuteCommand*) POT_EROS.GetCommand("u182",TCommand::kUpdate,TCommand::kCode);
	u182->SetExecutable(&POT_EROS_u182_exe_g);
	u182->Code() = "u182 <-  ( ( ( BOTTOM_MAP == ((float)1) ) ) ? ( STRESS_EFFECT ) : ( ((float)0) ) ) ";
	u182->AddDependency(BOTTOM_MAP);
	u182->AddDependency(STRESS_EFFECT);
	u182->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u183 = (TExecuteCommand*) RIVER_TSS.GetCommand("u183",TCommand::kUpdate,TCommand::kCode);
	u183->SetExecutable(&RIVER_TSS_u183_exe_g);
	u183->Code() = "u183 <- 0";
	u183->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u184 = (TExecuteCommand*) SHEAR_RES.GetCommand("u184",TCommand::kUpdate,TCommand::kCode);
	u184->SetExecutable(&SHEAR_RES_u184_exe_g);
	u184->Code() = "u184 <- ( P_RESISTANCE_COEFF*( ((float)1)+VEG_STRUCTURE ) )";
	u184->AddDependency(P_RESISTANCE_COEFF);
	u184->AddDependency(VEG_STRUCTURE);
	u184->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u185 = (TExecuteCommand*) STRESS_EFFECT.GetCommand("u185",TCommand::kUpdate,TCommand::kCode);
	u185->SetExecutable(&STRESS_EFFECT_u185_exe_g);
	u185->Code() = "u185 <-  ( ( ( OM3_SHEAR_STRESS >  SHEAR_RES ) ) ? ( ( OM3_SHEAR_STRESS-SHEAR_RES ) ) : ( ((float)0) ) ) ";
	u185->AddDependency(OM3_SHEAR_STRESS);
	u185->AddDependency(SHEAR_RES);
	u185->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u187 = (TExecuteCommand*) P_IC_TSS.GetCommand("u187",TCommand::kUpdate,TCommand::kCode);
	u187->SetExecutable(&P_IC_TSS_u187_exe_g);
	u187->Code() = "u187 <- 0.008000";
	u187->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u188 = (TExecuteCommand*) P_RESISTANCE_COEFF.GetCommand("u188",TCommand::kUpdate,TCommand::kCode);
	u188->SetExecutable(&P_RESISTANCE_COEFF_u188_exe_g);
	u188->Code() = "u188 <- 0.000100";
	u188->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u189 = (TExecuteCommand*) P_SETTLING_RT.GetCommand("u189",TCommand::kUpdate,TCommand::kCode);
	u189->SetExecutable(&P_SETTLING_RT_u189_exe_g);
	u189->Code() = "u189 <- 0.046800";
	u189->SetObjInfo(TCommand::kDepIndex, 5);
	return 0;
}

int TSS_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int TSS_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int TSS_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int TSS_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}
