#ifndef __ModelEqns__
#define __ModelEqns__

#include "SpaceSim.h"

// ---------------------------------------------------------------------------
//                    Class cbay_module 
// ---------------------------------------------------------------------------

class cbay_module : public TModule {
protected:

	cbay_module(char* name);

public:

	TTime TIME;
protected:

	static cbay_module* fInstance;
	static cbay_module* kNullModel;
public:
	inline static cbay_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new cbay_module("cbay_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (cbay_module&) *fInstance;
	}

	virtual int InitVars();
	int Initialize();
	int MakeConnections();
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit();
};


// ---------------------------------------------------------------------------
//                    Class CONSUMERS_module 
// ---------------------------------------------------------------------------

class CONSUMERS_module : public TModule {
protected:

	CONSUMERS_module(char* name);

public:

	TTime TIME;
	CAuxVariable P_CELL_AREA;
	CStateVariable PHYTOPLANKTON;
	CStateVariable SEAWEEDS;
	CStateVariable DETRITUS;
	CAuxVariable BOTTOM_MAP;
	CAuxVariable SURFACE_MAP;
	CAuxVariable OM3_TEMP;
	CFluxVariable CONS_MORTALITY;
	CFluxVariable CONS_EGEST;
	CAuxVariable COS_INGEST_DETR;
	CAuxVariable CONS_INGEST_PHT;
	CAuxVariable CONS_INGEST_SW;
	CAuxVariable VEG_STRUCTURE;
	CStateVariable CONSUMERS;
	CFluxVariable CONS_INGEST;
	CFluxVariable CONS_IN_X;
	CFluxVariable CONS_RESPIRATION;
	CFluxVariable CONS_OUT_X;
	CAuxVariable CONSDENS;
	CAuxVariable CONSTOD;
	CAuxVariable CONSTOE;
	CAuxVariable CONSTON;
	CAuxVariable CONSTOS;
	CAuxVariable CONSTOU;
	CAuxVariable CONSTOW;
	CAuxVariable CON_POT_INGEST;
	CAuxVariable DENSITY_X_D;
	CAuxVariable DENSITY_X_E;
	CAuxVariable DENSITY_X_N;
	CAuxVariable DENSITY_X_S;
	CAuxVariable DENSITY_X_U;
	CAuxVariable DENSITY_X_W;
	CAuxVariable FOOD_X_D;
	CAuxVariable FOOD_X_E;
	CAuxVariable FOOD_X_N;
	CAuxVariable FOOD_X_S;
	CAuxVariable FOOD_X_UP;
	CAuxVariable FOOD_X_W;
	CAuxVariable IC_CONSUMER;
	CAuxVariable OMTOTBIO;
	CAuxVariable PREF_TOT;
	CAuxVariable RIVER_CON;
	CAuxVariable P_CONS_NC;
	CAuxVariable P_CONS_PC;
	CAuxVariable P_C_EGEST_EFF;
	CAuxVariable P_C_MORT_RT;
	CAuxVariable P_C_RESP_RT;
	CAuxVariable P_DETR_PREF;
	CAuxVariable P_INGESTION_RT;
	CAuxVariable P_PH_PREF;
	CAuxVariable P_SW_PREF;
	CAuxVariable P_TRAVEL_TIME;
	CAuxVariable P_TRAVEL_TIME_DENS;
	CAuxVariable P_VEG_DENS_COEFF;
	CAuxVariable CONS_ACTIVITY;
protected:

	int CONSUMERS_I0_exe();
	friend int CONSUMERS_I0_exe_g( Variable* v );
	int CONSUMERS_i1_exe();
	friend int CONSUMERS_i1_exe_g( Variable* v );
	int CONS_INGEST_u2_exe();
	friend int CONS_INGEST_u2_exe_g( Variable* v );
	int CONS_IN_X_u3_exe();
	friend int CONS_IN_X_u3_exe_g( Variable* v );
	int CONS_EGEST_u4_exe();
	friend int CONS_EGEST_u4_exe_g( Variable* v );
	int CONS_MORTALITY_u5_exe();
	friend int CONS_MORTALITY_u5_exe_g( Variable* v );
	int CONS_RESPIRATION_u6_exe();
	friend int CONS_RESPIRATION_u6_exe_g( Variable* v );
	int CONS_OUT_X_u7_exe();
	friend int CONS_OUT_X_u7_exe_g( Variable* v );
	int CONSDENS_u8_exe();
	friend int CONSDENS_u8_exe_g( Variable* v );
	int CONSTOD_u9_exe();
	friend int CONSTOD_u9_exe_g( Variable* v );
	int CONSTOE_u10_exe();
	friend int CONSTOE_u10_exe_g( Variable* v );
	int CONSTON_u11_exe();
	friend int CONSTON_u11_exe_g( Variable* v );
	int CONSTOS_u12_exe();
	friend int CONSTOS_u12_exe_g( Variable* v );
	int CONSTOU_u13_exe();
	friend int CONSTOU_u13_exe_g( Variable* v );
	int CONSTOW_u14_exe();
	friend int CONSTOW_u14_exe_g( Variable* v );
	int CONS_INGEST_PHT_u15_exe();
	friend int CONS_INGEST_PHT_u15_exe_g( Variable* v );
	int CONS_INGEST_SW_u16_exe();
	friend int CONS_INGEST_SW_u16_exe_g( Variable* v );
	int CON_POT_INGEST_u17_exe();
	friend int CON_POT_INGEST_u17_exe_g( Variable* v );
	int COS_INGEST_DETR_u18_exe();
	friend int COS_INGEST_DETR_u18_exe_g( Variable* v );
	int DENSITY_X_D_u19_exe();
	friend int DENSITY_X_D_u19_exe_g( Variable* v );
	int DENSITY_X_E_u20_exe();
	friend int DENSITY_X_E_u20_exe_g( Variable* v );
	int DENSITY_X_N_u21_exe();
	friend int DENSITY_X_N_u21_exe_g( Variable* v );
	int DENSITY_X_S_u22_exe();
	friend int DENSITY_X_S_u22_exe_g( Variable* v );
	int DENSITY_X_U_u23_exe();
	friend int DENSITY_X_U_u23_exe_g( Variable* v );
	int DENSITY_X_W_u24_exe();
	friend int DENSITY_X_W_u24_exe_g( Variable* v );
	int FOOD_X_D_u25_exe();
	friend int FOOD_X_D_u25_exe_g( Variable* v );
	int FOOD_X_E_u26_exe();
	friend int FOOD_X_E_u26_exe_g( Variable* v );
	int FOOD_X_N_u27_exe();
	friend int FOOD_X_N_u27_exe_g( Variable* v );
	int FOOD_X_S_u28_exe();
	friend int FOOD_X_S_u28_exe_g( Variable* v );
	int FOOD_X_UP_u29_exe();
	friend int FOOD_X_UP_u29_exe_g( Variable* v );
	int FOOD_X_W_u30_exe();
	friend int FOOD_X_W_u30_exe_g( Variable* v );
	int IC_CONSUMER_u31_exe();
	friend int IC_CONSUMER_u31_exe_g( Variable* v );
	int OMTOTBIO_u32_exe();
	friend int OMTOTBIO_u32_exe_g( Variable* v );
	int PREF_TOT_u33_exe();
	friend int PREF_TOT_u33_exe_g( Variable* v );
	int RIVER_CON_u34_exe();
	friend int RIVER_CON_u34_exe_g( Variable* v );
	int VEG_STRUCTURE_u35_exe();
	friend int VEG_STRUCTURE_u35_exe_g( Variable* v );
	int P_CONS_NC_u36_exe();
	friend int P_CONS_NC_u36_exe_g( Variable* v );
	int P_CONS_PC_u37_exe();
	friend int P_CONS_PC_u37_exe_g( Variable* v );
	int P_C_EGEST_EFF_u38_exe();
	friend int P_C_EGEST_EFF_u38_exe_g( Variable* v );
	int P_C_MORT_RT_u39_exe();
	friend int P_C_MORT_RT_u39_exe_g( Variable* v );
	int P_C_RESP_RT_u40_exe();
	friend int P_C_RESP_RT_u40_exe_g( Variable* v );
	int P_DETR_PREF_u41_exe();
	friend int P_DETR_PREF_u41_exe_g( Variable* v );
	int P_INGESTION_RT_u42_exe();
	friend int P_INGESTION_RT_u42_exe_g( Variable* v );
	int P_PH_PREF_u43_exe();
	friend int P_PH_PREF_u43_exe_g( Variable* v );
	int P_SW_PREF_u44_exe();
	friend int P_SW_PREF_u44_exe_g( Variable* v );
	int P_TRAVEL_TIME_u45_exe();
	friend int P_TRAVEL_TIME_u45_exe_g( Variable* v );
	int P_TRAVEL_TIME_DENS_u46_exe();
	friend int P_TRAVEL_TIME_DENS_u46_exe_g( Variable* v );
	int P_VEG_DENS_COEFF_u47_exe();
	friend int P_VEG_DENS_COEFF_u47_exe_g( Variable* v );
	int CONS_ACTIVITY_u48_exe();
	friend int CONS_ACTIVITY_u48_exe_g( Variable* v );
	static CONSUMERS_module* fInstance;
	static CONSUMERS_module* kNullModel;
public:
	inline static CONSUMERS_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new CONSUMERS_module("CONSUMERS_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (CONSUMERS_module&) *fInstance;
	}

	virtual int InitVars();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}

	inline double Graph0(double x) { 
		static double g[14][2] = {
			{ 1.0000E+00, 2.500000E-02},{ 2.0000E+00, 4.500000E-02},{ 3.0000E+00, 1.050000E-01},{ 4.0000E+00, 1.350000E-01},
			{ 5.0000E+00, 2.800000E-01},{ 6.0000E+00, 5.700000E-01},{ 7.0000E+00, 8.150000E-01},{ 8.0000E+00, 9.600000E-01},
			{ 9.0000E+00, 1.000000E+00},{ 1.0000E+01, 1.000000E+00},{ 1.1000E+01, 9.400000E-01},{ 1.2000E+01, 5.000000E-02},
			{ 1.3000E+01, 4.000000E-02}, };
		return SL::Graph( 0, x, 13, g); 
	}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int CONSUMERS_I0_exe_g(Variable* obj) { return CONSUMERS_module::I().CONSUMERS_I0_exe(); }
int CONSUMERS_i1_exe_g(Variable* obj) { return CONSUMERS_module::I().CONSUMERS_i1_exe(); }
int CONS_INGEST_u2_exe_g(Variable* obj) { return CONSUMERS_module::I().CONS_INGEST_u2_exe(); }
int CONS_IN_X_u3_exe_g(Variable* obj) { return CONSUMERS_module::I().CONS_IN_X_u3_exe(); }
int CONS_EGEST_u4_exe_g(Variable* obj) { return CONSUMERS_module::I().CONS_EGEST_u4_exe(); }
int CONS_MORTALITY_u5_exe_g(Variable* obj) { return CONSUMERS_module::I().CONS_MORTALITY_u5_exe(); }
int CONS_RESPIRATION_u6_exe_g(Variable* obj) { return CONSUMERS_module::I().CONS_RESPIRATION_u6_exe(); }
int CONS_OUT_X_u7_exe_g(Variable* obj) { return CONSUMERS_module::I().CONS_OUT_X_u7_exe(); }
int CONSDENS_u8_exe_g(Variable* obj) { return CONSUMERS_module::I().CONSDENS_u8_exe(); }
int CONSTOD_u9_exe_g(Variable* obj) { return CONSUMERS_module::I().CONSTOD_u9_exe(); }
int CONSTOE_u10_exe_g(Variable* obj) { return CONSUMERS_module::I().CONSTOE_u10_exe(); }
int CONSTON_u11_exe_g(Variable* obj) { return CONSUMERS_module::I().CONSTON_u11_exe(); }
int CONSTOS_u12_exe_g(Variable* obj) { return CONSUMERS_module::I().CONSTOS_u12_exe(); }
int CONSTOU_u13_exe_g(Variable* obj) { return CONSUMERS_module::I().CONSTOU_u13_exe(); }
int CONSTOW_u14_exe_g(Variable* obj) { return CONSUMERS_module::I().CONSTOW_u14_exe(); }
int CONS_INGEST_PHT_u15_exe_g(Variable* obj) { return CONSUMERS_module::I().CONS_INGEST_PHT_u15_exe(); }
int CONS_INGEST_SW_u16_exe_g(Variable* obj) { return CONSUMERS_module::I().CONS_INGEST_SW_u16_exe(); }
int CON_POT_INGEST_u17_exe_g(Variable* obj) { return CONSUMERS_module::I().CON_POT_INGEST_u17_exe(); }
int COS_INGEST_DETR_u18_exe_g(Variable* obj) { return CONSUMERS_module::I().COS_INGEST_DETR_u18_exe(); }
int DENSITY_X_D_u19_exe_g(Variable* obj) { return CONSUMERS_module::I().DENSITY_X_D_u19_exe(); }
int DENSITY_X_E_u20_exe_g(Variable* obj) { return CONSUMERS_module::I().DENSITY_X_E_u20_exe(); }
int DENSITY_X_N_u21_exe_g(Variable* obj) { return CONSUMERS_module::I().DENSITY_X_N_u21_exe(); }
int DENSITY_X_S_u22_exe_g(Variable* obj) { return CONSUMERS_module::I().DENSITY_X_S_u22_exe(); }
int DENSITY_X_U_u23_exe_g(Variable* obj) { return CONSUMERS_module::I().DENSITY_X_U_u23_exe(); }
int DENSITY_X_W_u24_exe_g(Variable* obj) { return CONSUMERS_module::I().DENSITY_X_W_u24_exe(); }
int FOOD_X_D_u25_exe_g(Variable* obj) { return CONSUMERS_module::I().FOOD_X_D_u25_exe(); }
int FOOD_X_E_u26_exe_g(Variable* obj) { return CONSUMERS_module::I().FOOD_X_E_u26_exe(); }
int FOOD_X_N_u27_exe_g(Variable* obj) { return CONSUMERS_module::I().FOOD_X_N_u27_exe(); }
int FOOD_X_S_u28_exe_g(Variable* obj) { return CONSUMERS_module::I().FOOD_X_S_u28_exe(); }
int FOOD_X_UP_u29_exe_g(Variable* obj) { return CONSUMERS_module::I().FOOD_X_UP_u29_exe(); }
int FOOD_X_W_u30_exe_g(Variable* obj) { return CONSUMERS_module::I().FOOD_X_W_u30_exe(); }
int IC_CONSUMER_u31_exe_g(Variable* obj) { return CONSUMERS_module::I().IC_CONSUMER_u31_exe(); }
int OMTOTBIO_u32_exe_g(Variable* obj) { return CONSUMERS_module::I().OMTOTBIO_u32_exe(); }
int PREF_TOT_u33_exe_g(Variable* obj) { return CONSUMERS_module::I().PREF_TOT_u33_exe(); }
int RIVER_CON_u34_exe_g(Variable* obj) { return CONSUMERS_module::I().RIVER_CON_u34_exe(); }
int VEG_STRUCTURE_u35_exe_g(Variable* obj) { return CONSUMERS_module::I().VEG_STRUCTURE_u35_exe(); }
int P_CONS_NC_u36_exe_g(Variable* obj) { return CONSUMERS_module::I().P_CONS_NC_u36_exe(); }
int P_CONS_PC_u37_exe_g(Variable* obj) { return CONSUMERS_module::I().P_CONS_PC_u37_exe(); }
int P_C_EGEST_EFF_u38_exe_g(Variable* obj) { return CONSUMERS_module::I().P_C_EGEST_EFF_u38_exe(); }
int P_C_MORT_RT_u39_exe_g(Variable* obj) { return CONSUMERS_module::I().P_C_MORT_RT_u39_exe(); }
int P_C_RESP_RT_u40_exe_g(Variable* obj) { return CONSUMERS_module::I().P_C_RESP_RT_u40_exe(); }
int P_DETR_PREF_u41_exe_g(Variable* obj) { return CONSUMERS_module::I().P_DETR_PREF_u41_exe(); }
int P_INGESTION_RT_u42_exe_g(Variable* obj) { return CONSUMERS_module::I().P_INGESTION_RT_u42_exe(); }
int P_PH_PREF_u43_exe_g(Variable* obj) { return CONSUMERS_module::I().P_PH_PREF_u43_exe(); }
int P_SW_PREF_u44_exe_g(Variable* obj) { return CONSUMERS_module::I().P_SW_PREF_u44_exe(); }
int P_TRAVEL_TIME_u45_exe_g(Variable* obj) { return CONSUMERS_module::I().P_TRAVEL_TIME_u45_exe(); }
int P_TRAVEL_TIME_DENS_u46_exe_g(Variable* obj) { return CONSUMERS_module::I().P_TRAVEL_TIME_DENS_u46_exe(); }
int P_VEG_DENS_COEFF_u47_exe_g(Variable* obj) { return CONSUMERS_module::I().P_VEG_DENS_COEFF_u47_exe(); }
int CONS_ACTIVITY_u48_exe_g(Variable* obj) { return CONSUMERS_module::I().CONS_ACTIVITY_u48_exe(); }
// ---------------------------------------------------------------------------
//                    Class DETRITUS_module 
// ---------------------------------------------------------------------------

class DETRITUS_module : public TModule {
protected:

	DETRITUS_module(char* name);

public:

	TTime TIME;
	CStateVariable DETRITUS;
	CFluxVariable CONS_MORTALITY;
	CFluxVariable PHT_MORTALITY;
	CFluxVariable SW_MORT;
	CFluxVariable CONS_EGEST;
	CAuxVariable COS_INGEST_DETR;
	CFluxVariable DETR_DECOMPOSED;
	CFluxVariable DETRITUS_IN;
	CFluxVariable D_SINKING;
	CFluxVariable DETRITUS_CONSUMED;
	CAuxVariable P_DETR_DECOMP_RT;
	CAuxVariable P_D_SINK_RT;
	CAuxVariable P_IC_DETRITUS;
protected:

	int DETRITUS_I49_exe();
	friend int DETRITUS_I49_exe_g( Variable* v );
	int DETRITUS_i50_exe();
	friend int DETRITUS_i50_exe_g( Variable* v );
	int DETRITUS_IN_u51_exe();
	friend int DETRITUS_IN_u51_exe_g( Variable* v );
	int D_SINKING_u52_exe();
	friend int D_SINKING_u52_exe_g( Variable* v );
	int DETRITUS_CONSUMED_u53_exe();
	friend int DETRITUS_CONSUMED_u53_exe_g( Variable* v );
	int DETR_DECOMPOSED_u54_exe();
	friend int DETR_DECOMPOSED_u54_exe_g( Variable* v );
	int P_DETR_DECOMP_RT_u55_exe();
	friend int P_DETR_DECOMP_RT_u55_exe_g( Variable* v );
	int P_D_SINK_RT_u56_exe();
	friend int P_D_SINK_RT_u56_exe_g( Variable* v );
	int P_IC_DETRITUS_u57_exe();
	friend int P_IC_DETRITUS_u57_exe_g( Variable* v );
	static DETRITUS_module* fInstance;
	static DETRITUS_module* kNullModel;
public:
	inline static DETRITUS_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new DETRITUS_module("DETRITUS_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (DETRITUS_module&) *fInstance;
	}

	virtual int InitVars();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int DETRITUS_I49_exe_g(Variable* obj) { return DETRITUS_module::I().DETRITUS_I49_exe(); }
int DETRITUS_i50_exe_g(Variable* obj) { return DETRITUS_module::I().DETRITUS_i50_exe(); }
int DETRITUS_IN_u51_exe_g(Variable* obj) { return DETRITUS_module::I().DETRITUS_IN_u51_exe(); }
int D_SINKING_u52_exe_g(Variable* obj) { return DETRITUS_module::I().D_SINKING_u52_exe(); }
int DETRITUS_CONSUMED_u53_exe_g(Variable* obj) { return DETRITUS_module::I().DETRITUS_CONSUMED_u53_exe(); }
int DETR_DECOMPOSED_u54_exe_g(Variable* obj) { return DETRITUS_module::I().DETR_DECOMPOSED_u54_exe(); }
int P_DETR_DECOMP_RT_u55_exe_g(Variable* obj) { return DETRITUS_module::I().P_DETR_DECOMP_RT_u55_exe(); }
int P_D_SINK_RT_u56_exe_g(Variable* obj) { return DETRITUS_module::I().P_D_SINK_RT_u56_exe(); }
int P_IC_DETRITUS_u57_exe_g(Variable* obj) { return DETRITUS_module::I().P_IC_DETRITUS_u57_exe(); }
// ---------------------------------------------------------------------------
//                    Class DIN_module 
// ---------------------------------------------------------------------------

class DIN_module : public TModule {
protected:

	DIN_module(char* name);

public:

	TTime TIME;
	CAuxVariable SF_WATER;
	CFluxVariable DETR_DECOMPOSED;
	CAuxVariable PHT_NET_PROD;
	CAuxVariable P_PHT_NC;
	CAuxVariable BOTTOM_MAP;
	CAuxVariable DIN_CONC;
	CStateVariable DIN_SF_WT;
	CFluxVariable DIN_SF_WT_MINER;
	CFluxVariable DIN_UPFLOW;
	CFluxVariable DIN_DNFLOW;
	CFluxVariable DIN_SF_WT_UPTAKE;
	CFluxVariable RIVER_N;
	CAuxVariable P_DETR_NC_RT;
	CAuxVariable P_DIFFUSION_COEFF;
	CAuxVariable P_DIN_SED_CONC_MAP;
	CAuxVariable P_IC_DIN_SF_WT;
protected:

	int DIN_SF_WT_I58_exe();
	friend int DIN_SF_WT_I58_exe_g( Variable* v );
	int DIN_SF_WT_i59_exe();
	friend int DIN_SF_WT_i59_exe_g( Variable* v );
	int DIN_SF_WT_MINER_u60_exe();
	friend int DIN_SF_WT_MINER_u60_exe_g( Variable* v );
	int DIN_UPFLOW_u61_exe();
	friend int DIN_UPFLOW_u61_exe_g( Variable* v );
	int DIN_DNFLOW_u62_exe();
	friend int DIN_DNFLOW_u62_exe_g( Variable* v );
	int DIN_SF_WT_UPTAKE_u63_exe();
	friend int DIN_SF_WT_UPTAKE_u63_exe_g( Variable* v );
	int DIN_CONC_u64_exe();
	friend int DIN_CONC_u64_exe_g( Variable* v );
	int RIVER_N_u65_exe();
	friend int RIVER_N_u65_exe_g( Variable* v );
	int P_DETR_NC_RT_u66_exe();
	friend int P_DETR_NC_RT_u66_exe_g( Variable* v );
	int P_DIFFUSION_COEFF_u67_exe();
	friend int P_DIFFUSION_COEFF_u67_exe_g( Variable* v );
	int P_DIN_SED_CONC_MAP_u68_exe();
	friend int P_DIN_SED_CONC_MAP_u68_exe_g( Variable* v );
	int P_IC_DIN_SF_WT_u69_exe();
	friend int P_IC_DIN_SF_WT_u69_exe_g( Variable* v );
	static DIN_module* fInstance;
	static DIN_module* kNullModel;
public:
	inline static DIN_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new DIN_module("DIN_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (DIN_module&) *fInstance;
	}

	virtual int InitVars();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int DIN_SF_WT_I58_exe_g(Variable* obj) { return DIN_module::I().DIN_SF_WT_I58_exe(); }
int DIN_SF_WT_i59_exe_g(Variable* obj) { return DIN_module::I().DIN_SF_WT_i59_exe(); }
int DIN_SF_WT_MINER_u60_exe_g(Variable* obj) { return DIN_module::I().DIN_SF_WT_MINER_u60_exe(); }
int DIN_UPFLOW_u61_exe_g(Variable* obj) { return DIN_module::I().DIN_UPFLOW_u61_exe(); }
int DIN_DNFLOW_u62_exe_g(Variable* obj) { return DIN_module::I().DIN_DNFLOW_u62_exe(); }
int DIN_SF_WT_UPTAKE_u63_exe_g(Variable* obj) { return DIN_module::I().DIN_SF_WT_UPTAKE_u63_exe(); }
int DIN_CONC_u64_exe_g(Variable* obj) { return DIN_module::I().DIN_CONC_u64_exe(); }
int RIVER_N_u65_exe_g(Variable* obj) { return DIN_module::I().RIVER_N_u65_exe(); }
int P_DETR_NC_RT_u66_exe_g(Variable* obj) { return DIN_module::I().P_DETR_NC_RT_u66_exe(); }
int P_DIFFUSION_COEFF_u67_exe_g(Variable* obj) { return DIN_module::I().P_DIFFUSION_COEFF_u67_exe(); }
int P_DIN_SED_CONC_MAP_u68_exe_g(Variable* obj) { return DIN_module::I().P_DIN_SED_CONC_MAP_u68_exe(); }
int P_IC_DIN_SF_WT_u69_exe_g(Variable* obj) { return DIN_module::I().P_IC_DIN_SF_WT_u69_exe(); }
// ---------------------------------------------------------------------------
//                    Class GLOBAL_module 
// ---------------------------------------------------------------------------

class GLOBAL_module : public TModule {
protected:

	GLOBAL_module(char* name);

public:

	TTime TIME;
	CAuxVariable P_CELL_AREA;
	CAuxVariable BOTTOM_MAP;
	CAuxVariable SURFACE_MAP;
	CAuxVariable OM3_TEMP;
	CAuxVariable SF_WATER;
	CAuxVariable TSS_CONC;
	CAuxVariable PHT_CONC;
	CAuxVariable LIGHT_TO_PHYTOPLANKTON;
	CAuxVariable P_CHL_A_MAP;
	CAuxVariable WATER_LAYER_DEPTH;
	CAuxVariable P_ON_MAP;
	CAuxVariable WATER_DEPTH;
	CAuxVariable OM3_SHEAR_STRESS;
	CStateVariable DAYS;
	CFluxVariable COUNT_HOURS;
	CAuxVariable CURRENT_DIRECTION;
	CAuxVariable CURRENT_VELOCITY;
	CAuxVariable EC_H2O;
	CAuxVariable EW_CURRENT_VECTOR;
	CAuxVariable EW_VECTOR;
	CAuxVariable EW_WIND_VECTOR;
	CAuxVariable HOURS;
	CAuxVariable NS_CURRENT_VECTOR;
	CAuxVariable NS_VECTOR;
	CAuxVariable NS_WIND_VECTOR;
	CAuxVariable OM3_SALT_CONC;
	CAuxVariable OM3_UD_CURRENT_VECTOR;
	CAuxVariable PHOTO_PERIOD;
	CAuxVariable RAND;
	CAuxVariable SDCLN;
	CAuxVariable SURFACE_LIGHT;
	CAuxVariable WATER_LAYER_HEIGHT;
	CAuxVariable X;
	CAuxVariable Y;
	CAuxVariable P_EC_COEFF_SED;
	CAuxVariable P_EC_COEFF_WATER;
	CAuxVariable P_IC_SED_ELEV;
	CAuxVariable P_LATITUDE;
	CAuxVariable DECLINE;
	CAuxVariable H_ANGLE;
	CAuxVariable SKEW_WEATHER;
	CAuxVariable P_AIR_TEMP;
	CAuxVariable P_LEAF_GROW_SEASON;
	CAuxVariable P_PRECIPITATION;
	CAuxVariable P_WIND_DIRECTION;
	CAuxVariable P_WIND_SPEED;
protected:

	int DAYS_I70_exe();
	friend int DAYS_I70_exe_g( Variable* v );
	int DAYS_i71_exe();
	friend int DAYS_i71_exe_g( Variable* v );
	int COUNT_HOURS_u72_exe();
	friend int COUNT_HOURS_u72_exe_g( Variable* v );
	int BOTTOM_MAP_u73_exe();
	friend int BOTTOM_MAP_u73_exe_g( Variable* v );
	int CURRENT_DIRECTION_u74_exe();
	friend int CURRENT_DIRECTION_u74_exe_g( Variable* v );
	int CURRENT_VELOCITY_u75_exe();
	friend int CURRENT_VELOCITY_u75_exe_g( Variable* v );
	int EC_H2O_u76_exe();
	friend int EC_H2O_u76_exe_g( Variable* v );
	int EW_CURRENT_VECTOR_u77_exe();
	friend int EW_CURRENT_VECTOR_u77_exe_g( Variable* v );
	int EW_VECTOR_u78_exe();
	friend int EW_VECTOR_u78_exe_g( Variable* v );
	int EW_WIND_VECTOR_u79_exe();
	friend int EW_WIND_VECTOR_u79_exe_g( Variable* v );
	int HOURS_u80_exe();
	friend int HOURS_u80_exe_g( Variable* v );
	int LIGHT_TO_PHYTOPLANKTON_u81_exe();
	friend int LIGHT_TO_PHYTOPLANKTON_u81_exe_g( Variable* v );
	int NS_CURRENT_VECTOR_u82_exe();
	friend int NS_CURRENT_VECTOR_u82_exe_g( Variable* v );
	int NS_VECTOR_u83_exe();
	friend int NS_VECTOR_u83_exe_g( Variable* v );
	int NS_WIND_VECTOR_u84_exe();
	friend int NS_WIND_VECTOR_u84_exe_g( Variable* v );
	int OM3_SALT_CONC_u85_exe();
	friend int OM3_SALT_CONC_u85_exe_g( Variable* v );
	int OM3_SHEAR_STRESS_u86_exe();
	friend int OM3_SHEAR_STRESS_u86_exe_g( Variable* v );
	int OM3_TEMP_u87_exe();
	friend int OM3_TEMP_u87_exe_g( Variable* v );
	int OM3_UD_CURRENT_VECTOR_u88_exe();
	friend int OM3_UD_CURRENT_VECTOR_u88_exe_g( Variable* v );
	int PHOTO_PERIOD_u89_exe();
	friend int PHOTO_PERIOD_u89_exe_g( Variable* v );
	int RAND_u90_exe();
	friend int RAND_u90_exe_g( Variable* v );
	int SDCLN_u91_exe();
	friend int SDCLN_u91_exe_g( Variable* v );
	int SF_WATER_u92_exe();
	friend int SF_WATER_u92_exe_g( Variable* v );
	int SURFACE_LIGHT_u93_exe();
	friend int SURFACE_LIGHT_u93_exe_g( Variable* v );
	int SURFACE_MAP_u94_exe();
	friend int SURFACE_MAP_u94_exe_g( Variable* v );
	int WATER_DEPTH_u95_exe();
	friend int WATER_DEPTH_u95_exe_g( Variable* v );
	int WATER_LAYER_DEPTH_u96_exe();
	friend int WATER_LAYER_DEPTH_u96_exe_g( Variable* v );
	int WATER_LAYER_HEIGHT_u97_exe();
	friend int WATER_LAYER_HEIGHT_u97_exe_g( Variable* v );
	int P_CELL_AREA_u100_exe();
	friend int P_CELL_AREA_u100_exe_g( Variable* v );
	int P_CHL_A_MAP_u101_exe();
	friend int P_CHL_A_MAP_u101_exe_g( Variable* v );
	int P_EC_COEFF_SED_u102_exe();
	friend int P_EC_COEFF_SED_u102_exe_g( Variable* v );
	int P_EC_COEFF_WATER_u103_exe();
	friend int P_EC_COEFF_WATER_u103_exe_g( Variable* v );
	int P_IC_SED_ELEV_u104_exe();
	friend int P_IC_SED_ELEV_u104_exe_g( Variable* v );
	int P_LATITUDE_u105_exe();
	friend int P_LATITUDE_u105_exe_g( Variable* v );
	int P_ON_MAP_u106_exe();
	friend int P_ON_MAP_u106_exe_g( Variable* v );
	int DECLINE_u107_exe();
	friend int DECLINE_u107_exe_g( Variable* v );
	int H_ANGLE_u108_exe();
	friend int H_ANGLE_u108_exe_g( Variable* v );
	int SKEW_WEATHER_u109_exe();
	friend int SKEW_WEATHER_u109_exe_g( Variable* v );
	int P_AIR_TEMP_u110_exe();
	friend int P_AIR_TEMP_u110_exe_g( Variable* v );
	int P_LEAF_GROW_SEASON_u111_exe();
	friend int P_LEAF_GROW_SEASON_u111_exe_g( Variable* v );
	int P_PRECIPITATION_u112_exe();
	friend int P_PRECIPITATION_u112_exe_g( Variable* v );
	int P_WIND_DIRECTION_u113_exe();
	friend int P_WIND_DIRECTION_u113_exe_g( Variable* v );
	int P_WIND_SPEED_u114_exe();
	friend int P_WIND_SPEED_u114_exe_g( Variable* v );
	static GLOBAL_module* fInstance;
	static GLOBAL_module* kNullModel;
public:
	inline static GLOBAL_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new GLOBAL_module("GLOBAL_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (GLOBAL_module&) *fInstance;
	}

	virtual int InitVars();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}

	inline double Graph1(double x) { 
		static double g[10][2] = {
			{ -1.0000E+00, -1.570000E+00},{ -7.5000E-01, -1.120000E+00},{ -5.0000E-01, -6.440000E-01},{ -2.5000E-01, -3.050000E-01},
			{ 0.0000E+00, 0.000000E+00},{ 2.5000E-01, 3.050000E-01},{ 5.0000E-01, 6.440000E-01},{ 7.5000E-01, 1.120000E+00},
			{ 1.0000E+00, 1.570000E+00}, };
		return SL::Graph( 0, x, 9, g); 
	}

	inline double Graph2(double x) { 
		static double g[10][2] = {
			{ -1.0000E+00, 3.140000E+00},{ -7.5000E-01, 2.420000E+00},{ -5.0000E-01, 2.090000E+00},{ -2.5000E-01, 1.820000E+00},
			{ 0.0000E+00, 1.570000E+00},{ 2.5000E-01, 1.320000E+00},{ 5.0000E-01, 1.050000E+00},{ 7.5000E-01, 7.230000E-01},
			{ 1.0000E+00, 0.000000E+00}, };
		return SL::Graph( 0, x, 9, g); 
	}

	inline double Graph3(double x) { 
		static double g[12][2] = {
			{ 0.0000E+00, 0.000000E+00},{ 1.0000E+01, 3.700000E-02},{ 2.0000E+01, 8.000000E-02},{ 3.0000E+01, 1.290000E-01},
			{ 4.0000E+01, 1.880000E-01},{ 5.0000E+01, 2.640000E-01},{ 6.0000E+01, 3.810000E-01},{ 7.0000E+01, 5.090000E-01},
			{ 8.0000E+01, 6.590000E-01},{ 9.0000E+01, 8.040000E-01},{ 1.0000E+02, 9.560000E-01}, };
		return SL::Graph( 0, x, 11, g); 
	}

	inline double Graph4(double x) { 
		static double g[366][2] = {
			{ 0.0000E+00, -7.800000E+00},{ 1.0000E+00, -9.400000E+00},{ 2.0100E+00, -1.110000E+01},{ 3.0100E+00, -8.900000E+00},
			{ 4.0100E+00, -7.800000E+00},{ 5.0100E+00, -8.300000E+00},{ 6.0200E+00, -5.000000E+00},{ 7.0200E+00, -6.100000E+00},
			{ 8.0200E+00, -7.200000E+00},{ 9.0200E+00, -8.900000E+00},{ 1.0000E+01, -9.400000E+00},{ 1.1000E+01, -7.200000E+00},
			{ 1.2000E+01, -7.200000E+00},{ 1.3000E+01, -4.400000E+00},{ 1.4000E+01, -5.000000E+00},{ 1.5000E+01, -5.600000E+00},
			{ 1.6000E+01, -1.220000E+01},{ 1.7000E+01, -1.670000E+01},{ 1.8000E+01, -1.220000E+01},{ 1.9100E+01, -1.330000E+01},
			{ 2.0100E+01, -1.000000E+01},{ 2.1100E+01, -1.060000E+01},{ 2.2100E+01, -8.300000E+00},{ 2.3100E+01, -8.300000E+00},
			{ 2.4100E+01, -1.500000E+01},{ 2.5100E+01, -1.720000E+01},{ 2.6100E+01, -1.670000E+01},{ 2.7100E+01, -1.330000E+01},
			{ 2.8100E+01, -9.400000E+00},{ 2.9100E+01, -1.110000E+01},{ 3.0100E+01, -8.900000E+00},{ 3.1100E+01, -8.300000E+00},
			{ 3.2100E+01, -4.400000E+00},{ 3.3100E+01, -4.400000E+00},{ 3.4100E+01, -6.100000E+00},{ 3.5100E+01, -8.900000E+00},
			{ 3.6100E+01, -8.300000E+00},{ 3.7100E+01, -2.200000E+00},{ 3.8100E+01, -6.100000E+00},{ 3.9100E+01, -7.800000E+00},
			{ 4.0100E+01, -1.000000E+01},{ 4.1100E+01, -1.170000E+01},{ 4.2100E+01, -1.280000E+01},{ 4.3100E+01, -1.330000E+01},
			{ 4.4100E+01, -1.940000E+01},{ 4.5100E+01, -2.060000E+01},{ 4.6100E+01, -1.060000E+01},{ 4.7100E+01, -5.000000E+00},
			{ 4.8100E+01, -7.800000E+00},{ 4.9100E+01, -8.900000E+00},{ 5.0100E+01, -9.400000E+00},{ 5.1100E+01, -6.700000E+00},
			{ 5.2100E+01, -4.400000E+00},{ 5.3100E+01, -5.600000E+00},{ 5.4100E+01, -7.800000E+00},{ 5.5200E+01, -6.700000E+00},
			{ 5.6200E+01, -4.400000E+00},{ 5.7200E+01, -3.300000E+00},{ 5.8200E+01, -1.700000E+00},{ 5.9200E+01, -4.400000E+00},
			{ 6.0200E+01, -9.400000E+00},{ 6.1200E+01, -9.400000E+00},{ 6.2200E+01, -9.400000E+00},{ 6.3200E+01, -6.700000E+00},
			{ 6.4200E+01, -2.800000E+00},{ 6.5200E+01, 2.800000E+00},{ 6.6200E+01, 6.100000E+00},{ 6.7200E+01, -6.000000E-01},
			{ 6.8200E+01, -8.900000E+00},{ 6.9200E+01, -1.000000E+01},{ 7.0200E+01, -7.200000E+00},{ 7.1200E+01, -9.400000E+00},
			{ 7.2200E+01, -6.100000E+00},{ 7.3200E+01, -5.000000E+00},{ 7.4200E+01, -5.600000E+00},{ 7.5200E+01, -7.800000E+00},
			{ 7.6200E+01, -3.300000E+00},{ 7.7200E+01, -4.400000E+00},{ 7.8200E+01, -5.000000E+00},{ 7.9200E+01, -6.100000E+00},
			{ 8.0200E+01, -3.900000E+00},{ 8.1200E+01, -1.700000E+00},{ 8.2200E+01, 7.200000E+00},{ 8.3200E+01, 9.400000E+00},
			{ 8.4200E+01, 3.900000E+00},{ 8.5200E+01, 5.600000E+00},{ 8.6200E+01, 2.800000E+00},{ 8.7200E+01, 6.700000E+00},
			{ 8.8200E+01, 6.700000E+00},{ 8.9200E+01, 2.200000E+00},{ 9.0200E+01, 2.800000E+00},{ 9.1300E+01, 2.200000E+00},
			{ 9.2300E+01, 5.600000E+00},{ 9.3300E+01, 3.300000E+00},{ 9.4300E+01, -6.000000E-01},{ 9.5300E+01, -3.300000E+00},
			{ 9.6300E+01, -3.300000E+00},{ 9.7300E+01, 0.000000E+00},{ 9.8300E+01, 0.000000E+00},{ 9.9300E+01, 9.400000E+00},
			{ 1.0000E+02, 1.280000E+01},{ 1.0100E+02, 1.000000E+01},{ 1.0200E+02, 7.200000E+00},{ 1.0300E+02, 6.100000E+00},
			{ 1.0400E+02, 5.000000E+00},{ 1.0500E+02, 4.400000E+00},{ 1.0600E+02, -3.300000E+00},{ 1.0700E+02, 2.800000E+00},
			{ 1.0800E+02, 8.300000E+00},{ 1.0900E+02, 6.700000E+00},{ 1.1000E+02, 1.220000E+01},{ 1.1100E+02, 1.220000E+01},
			{ 1.1200E+02, 1.700000E+00},{ 1.1300E+02, 8.900000E+00},{ 1.1400E+02, 7.800000E+00},{ 1.1500E+02, 3.300000E+00},
			{ 1.1600E+02, 6.000000E-01},{ 1.1700E+02, -1.700000E+00},{ 1.1800E+02, -1.100000E+00},{ 1.1900E+02, 2.200000E+00},
			{ 1.2000E+02, 5.600000E+00},{ 1.2100E+02, 1.060000E+01},{ 1.2200E+02, 8.300000E+00},{ 1.2300E+02, 5.000000E+00},
			{ 1.2400E+02, -1.100000E+00},{ 1.2500E+02, -1.700000E+00},{ 1.2600E+02, 1.330000E+01},{ 1.2700E+02, 1.110000E+01},
			{ 1.2800E+02, 1.170000E+01},{ 1.2900E+02, 1.940000E+01},{ 1.3000E+02, 1.720000E+01},{ 1.3100E+02, 1.280000E+01},
			{ 1.3200E+02, 1.110000E+01},{ 1.3300E+02, 7.800000E+00},{ 1.3400E+02, 1.060000E+01},{ 1.3500E+02, 1.060000E+01},
			{ 1.3600E+02, 1.280000E+01},{ 1.3700E+02, 1.170000E+01},{ 1.3800E+02, 6.100000E+00},{ 1.3900E+02, 5.600000E+00},
			{ 1.4000E+02, 1.000000E+01},{ 1.4100E+02, 1.780000E+01},{ 1.4200E+02, 1.670000E+01},{ 1.4300E+02, 6.000000E-01},
			{ 1.4400E+02, 7.200000E+00},{ 1.4500E+02, 1.110000E+01},{ 1.4600E+02, 1.000000E+01},{ 1.4700E+02, 1.890000E+01},
			{ 1.4800E+02, 1.940000E+01},{ 1.4900E+02, 2.330000E+01},{ 1.5000E+02, 2.440000E+01},{ 1.5100E+02, 2.000000E+01},
			{ 1.5200E+02, 1.940000E+01},{ 1.5300E+02, 8.300000E+00},{ 1.5400E+02, 5.600000E+00},{ 1.5500E+02, 1.170000E+01},
			{ 1.5600E+02, 1.110000E+01},{ 1.5700E+02, 1.220000E+01},{ 1.5800E+02, 1.170000E+01},{ 1.5900E+02, 1.330000E+01},
			{ 1.6000E+02, 1.170000E+01},{ 1.6100E+02, 1.500000E+01},{ 1.6200E+02, 1.440000E+01},{ 1.6300E+02, 1.780000E+01},
			{ 1.6400E+02, 1.830000E+01},{ 1.6500E+02, 1.890000E+01},{ 1.6600E+02, 1.890000E+01},{ 1.6700E+02, 1.780000E+01},
			{ 1.6800E+02, 1.670000E+01},{ 1.6900E+02, 2.000000E+01},{ 1.7000E+02, 2.000000E+01},{ 1.7100E+02, 1.780000E+01},
			{ 1.7200E+02, 1.330000E+01},{ 1.7300E+02, 8.300000E+00},{ 1.7400E+02, 1.890000E+01},{ 1.7500E+02, 1.830000E+01},
			{ 1.7600E+02, 7.200000E+00},{ 1.7700E+02, 6.100000E+00},{ 1.7800E+02, 1.440000E+01},{ 1.7900E+02, 1.780000E+01},
			{ 1.8000E+02, 1.940000E+01},{ 1.8100E+02, 1.720000E+01},{ 1.8200E+02, 1.280000E+01},{ 1.8400E+02, 8.300000E+00},
			{ 1.8500E+02, 1.940000E+01},{ 1.8600E+02, 1.780000E+01},{ 1.8700E+02, 1.780000E+01},{ 1.8800E+02, 1.610000E+01},
			{ 1.8900E+02, 1.500000E+01},{ 1.9000E+02, 2.060000E+01},{ 1.9100E+02, 1.830000E+01},{ 1.9200E+02, 1.560000E+01},
			{ 1.9300E+02, 1.560000E+01},{ 1.9400E+02, 1.560000E+01},{ 1.9500E+02, 1.670000E+01},{ 1.9600E+02, 1.670000E+01},
			{ 1.9700E+02, 1.330000E+01},{ 1.9800E+02, 1.670000E+01},{ 1.9900E+02, 2.220000E+01},{ 2.0000E+02, 2.060000E+01},
			{ 2.0100E+02, 1.610000E+01},{ 2.0200E+02, 1.440000E+01},{ 2.0300E+02, 1.500000E+01},{ 2.0400E+02, 1.890000E+01},
			{ 2.0500E+02, 2.330000E+01},{ 2.0600E+02, 2.280000E+01},{ 2.0700E+02, 1.940000E+01},{ 2.0800E+02, 1.830000E+01},
			{ 2.0900E+02, 1.500000E+01},{ 2.1000E+02, 1.280000E+01},{ 2.1100E+02, 1.610000E+01},{ 2.1200E+02, 1.500000E+01},
			{ 2.1300E+02, 1.560000E+01},{ 2.1400E+02, 1.500000E+01},{ 2.1500E+02, 1.610000E+01},{ 2.1600E+02, 1.830000E+01},
			{ 2.1700E+02, 1.560000E+01},{ 2.1800E+02, 1.440000E+01},{ 2.1900E+02, 1.440000E+01},{ 2.2000E+02, 2.000000E+01},
			{ 2.2100E+02, 1.720000E+01},{ 2.2200E+02, 1.060000E+01},{ 2.2300E+02, 1.560000E+01},{ 2.2400E+02, 1.440000E+01},
			{ 2.2500E+02, 1.500000E+01},{ 2.2600E+02, 1.780000E+01},{ 2.2700E+02, 1.940000E+01},{ 2.2800E+02, 2.330000E+01},
			{ 2.2900E+02, 2.440000E+01},{ 2.3000E+02, 2.330000E+01},{ 2.3100E+02, 2.110000E+01},{ 2.3200E+02, 1.780000E+01},
			{ 2.3300E+02, 1.720000E+01},{ 2.3400E+02, 1.560000E+01},{ 2.3500E+02, 1.170000E+01},{ 2.3600E+02, 1.060000E+01},
			{ 2.3700E+02, 1.330000E+01},{ 2.3800E+02, 1.220000E+01},{ 2.3900E+02, 1.220000E+01},{ 2.4000E+02, 7.800000E+00},
			{ 2.4100E+02, 6.100000E+00},{ 2.4200E+02, 1.440000E+01},{ 2.4300E+02, 1.560000E+01},{ 2.4400E+02, 1.390000E+01},
			{ 2.4500E+02, 1.170000E+01},{ 2.4600E+02, 1.060000E+01},{ 2.4700E+02, 1.110000E+01},{ 2.4800E+02, 1.500000E+01},
			{ 2.4900E+02, 1.390000E+01},{ 2.5000E+02, 1.330000E+01},{ 2.5100E+02, 1.670000E+01},{ 2.5200E+02, 1.670000E+01},
			{ 2.5300E+02, 1.780000E+01},{ 2.5400E+02, 1.500000E+01},{ 2.5500E+02, 1.000000E+01},{ 2.5600E+02, 7.200000E+00},
			{ 2.5700E+02, 1.440000E+01},{ 2.5800E+02, 1.280000E+01},{ 2.5900E+02, 1.500000E+01},{ 2.6000E+02, 1.330000E+01},
			{ 2.6100E+02, 6.700000E+00},{ 2.6200E+02, 3.900000E+00},{ 2.6300E+02, 2.800000E+00},{ 2.6400E+02, 6.100000E+00},
			{ 2.6500E+02, 7.200000E+00},{ 2.6600E+02, 1.000000E+01},{ 2.6700E+02, 8.300000E+00},{ 2.6800E+02, 7.200000E+00},
			{ 2.6900E+02, 8.900000E+00},{ 2.7000E+02, 7.200000E+00},{ 2.7100E+02, 1.280000E+01},{ 2.7200E+02, 1.670000E+01},
			{ 2.7300E+02, 1.330000E+01},{ 2.7400E+02, 7.800000E+00},{ 2.7500E+02, 9.400000E+00},{ 2.7600E+02, 1.110000E+01},
			{ 2.7700E+02, 7.200000E+00},{ 2.7800E+02, 8.300000E+00},{ 2.7900E+02, 1.060000E+01},{ 2.8000E+02, 7.800000E+00},
			{ 2.8100E+02, 6.700000E+00},{ 2.8200E+02, 3.300000E+00},{ 2.8300E+02, 8.300000E+00},{ 2.8400E+02, 5.600000E+00},
			{ 2.8500E+02, -6.000000E-01},{ 2.8600E+02, 2.200000E+00},{ 2.8700E+02, 3.300000E+00},{ 2.8800E+02, 7.800000E+00},
			{ 2.8900E+02, 5.600000E+00},{ 2.9000E+02, 6.100000E+00},{ 2.9100E+02, 9.400000E+00},{ 2.9200E+02, 8.300000E+00},
			{ 2.9300E+02, 3.900000E+00},{ 2.9400E+02, 7.200000E+00},{ 2.9500E+02, 0.000000E+00},{ 2.9600E+02, 2.800000E+00},
			{ 2.9700E+02, 7.800000E+00},{ 2.9800E+02, 4.400000E+00},{ 2.9900E+02, 2.800000E+00},{ 3.0000E+02, 1.700000E+00},
			{ 3.0100E+02, 6.700000E+00},{ 3.0200E+02, 3.300000E+00},{ 3.0300E+02, 1.700000E+00},{ 3.0400E+02, 2.200000E+00},
			{ 3.0500E+02, 2.800000E+00},{ 3.0600E+02, -6.000000E-01},{ 3.0700E+02, 2.200000E+00},{ 3.0800E+02, 1.330000E+01},
			{ 3.0900E+02, 7.800000E+00},{ 3.1000E+02, 6.000000E-01},{ 3.1100E+02, -4.400000E+00},{ 3.1200E+02, 1.100000E+00},
			{ 3.1300E+02, 6.700000E+00},{ 3.1400E+02, 3.900000E+00},{ 3.1500E+02, -9.400000E+00},{ 3.1600E+02, -6.700000E+00},
			{ 3.1700E+02, -6.000000E-01},{ 3.1800E+02, 2.200000E+00},{ 3.1900E+02, 6.000000E-01},{ 3.2000E+02, -1.100000E+00},
			{ 3.2100E+02, 6.000000E-01},{ 3.2200E+02, 1.110000E+01},{ 3.2300E+02, 5.600000E+00},{ 3.2400E+02, -4.400000E+00},
			{ 3.2500E+02, -5.000000E+00},{ 3.2600E+02, -1.000000E+01},{ 3.2700E+02, -4.400000E+00},{ 3.2800E+02, 3.900000E+00},
			{ 3.2900E+02, -2.200000E+00},{ 3.3000E+02, -3.300000E+00},{ 3.3100E+02, -3.300000E+00},{ 3.3200E+02, -7.800000E+00},
			{ 3.3300E+02, -5.600000E+00},{ 3.3400E+02, 2.200000E+00},{ 3.3500E+02, 2.200000E+00},{ 3.3600E+02, -3.300000E+00},
			{ 3.3700E+02, -6.100000E+00},{ 3.3800E+02, -8.900000E+00},{ 3.3900E+02, -8.900000E+00},{ 3.4000E+02, -7.800000E+00},
			{ 3.4100E+02, -1.700000E+00},{ 3.4200E+02, -2.800000E+00},{ 3.4300E+02, 2.800000E+00},{ 3.4400E+02, 2.800000E+00},
			{ 3.4500E+02, -2.800000E+00},{ 3.4600E+02, -5.000000E+00},{ 3.4700E+02, -4.400000E+00},{ 3.4800E+02, -3.300000E+00},
			{ 3.4900E+02, -6.700000E+00},{ 3.5000E+02, -8.900000E+00},{ 3.5100E+02, -1.000000E+01},{ 3.5200E+02, -1.220000E+01},
			{ 3.5300E+02, -7.800000E+00},{ 3.5400E+02, -8.900000E+00},{ 3.5500E+02, -4.400000E+00},{ 3.5600E+02, -5.000000E+00},
			{ 3.5700E+02, -4.400000E+00},{ 3.5800E+02, -5.000000E+00},{ 3.5900E+02, -5.600000E+00},{ 3.6000E+02, -5.600000E+00},
			{ 3.6100E+02, -8.300000E+00},{ 3.6200E+02, -1.060000E+01},{ 3.6300E+02, -1.560000E+01},{ 3.6400E+02, -2.000000E+01},
			{ 3.6500E+02, -1.060000E+01}, };
		return SL::Graph( 0, x, 365, g); 
	}

	inline double Graph5(double x) { 
		static double g[12][2] = {
			{ 1.0000E+00, 2.000000E-02},{ 3.7400E+01, 8.500000E-02},{ 7.3800E+01, 1.450000E-01},{ 1.1000E+02, 2.000000E-01},
			{ 1.4700E+02, 4.250000E-01},{ 1.8300E+02, 8.550000E-01},{ 2.1900E+02, 9.900000E-01},{ 2.5600E+02, 9.800000E-01},
			{ 2.9200E+02, 6.350000E-01},{ 3.2900E+02, 3.050000E-01},{ 3.6500E+02, 1.100000E-01}, };
		return SL::Graph( 0, x, 11, g); 
	}

	inline double Graph6(double x) { 
		static double g[12][2] = {
			{ 0.0000E+00, 0.000000E+00},{ 1.0000E+01, 0.000000E+00},{ 2.0000E+01, 0.000000E+00},{ 3.0000E+01, 0.000000E+00},
			{ 4.0000E+01, 0.000000E+00},{ 5.0000E+01, 0.000000E+00},{ 6.0000E+01, 0.000000E+00},{ 7.0000E+01, 0.000000E+00},
			{ 8.0000E+01, 0.000000E+00},{ 9.0000E+01, 0.000000E+00},{ 1.0000E+02, 0.000000E+00}, };
		return SL::Graph( 0, x, 11, g); 
	}

	inline double Graph7(double x) { 
		static double g[366][2] = {
			{ 1.0000E+00, 2.530000E+02},{ 2.0000E+00, 2.280000E+02},{ 3.0000E+00, 2.120000E+02},{ 4.0000E+00, 2.370000E+02},
			{ 5.0000E+00, 2.040000E+02},{ 6.0000E+00, 2.410000E+02},{ 7.0000E+00, 2.750000E+02},{ 8.0000E+00, 2.830000E+02},
			{ 9.0000E+00, 2.200000E+02},{ 1.0000E+01, 2.370000E+02},{ 1.1000E+01, 2.670000E+02},{ 1.2000E+01, 2.010000E+02},
			{ 1.3000E+01, 2.510000E+02},{ 1.4000E+01, 3.280000E+02},{ 1.5000E+01, 2.860000E+02},{ 1.6000E+01, 2.470000E+02},
			{ 1.7000E+01, 1.780000E+02},{ 1.8000E+01, 2.040000E+02},{ 1.9000E+01, 1.470000E+02},{ 2.0000E+01, 1.840000E+02},
			{ 2.1000E+01, 2.570000E+02},{ 2.2000E+01, 1.840000E+02},{ 2.3000E+01, 2.990000E+02},{ 2.4000E+01, 2.730000E+02},
			{ 2.5000E+01, 2.500000E+02},{ 2.6000E+01, 1.480000E+02},{ 2.7000E+01, 1.630000E+02},{ 2.8000E+01, 2.620000E+02},
			{ 2.9000E+01, 2.410000E+02},{ 3.0000E+01, 2.070000E+02},{ 3.1000E+01, 2.590000E+02},{ 3.2000E+01, 2.180000E+02},
			{ 3.3000E+01, 2.410000E+02},{ 3.4000E+01, 2.690000E+02},{ 3.5000E+01, 1.860000E+02},{ 3.6000E+01, 2.850000E+02},
			{ 3.7000E+01, 2.980000E+02},{ 3.8000E+01, 2.250000E+02},{ 3.9000E+01, 2.570000E+02},{ 4.0000E+01, 1.990000E+02},
			{ 4.1000E+01, 2.220000E+02},{ 4.2000E+01, 2.890000E+02},{ 4.3000E+01, 2.870000E+02},{ 4.4000E+01, 2.410000E+02},
			{ 4.5000E+01, 1.800000E+02},{ 4.6000E+01, 2.950000E+02},{ 4.7000E+01, 2.720000E+02},{ 4.8000E+01, 1.970000E+02},
			{ 4.9000E+01, 8.600000E+01},{ 5.0000E+01, 1.710000E+02},{ 5.1000E+01, 1.850000E+02},{ 5.2000E+01, 1.570000E+02},
			{ 5.3000E+01, 2.770000E+02},{ 5.4000E+01, 2.230000E+02},{ 5.5000E+01, 2.350000E+02},{ 5.6000E+01, 3.090000E+02},
			{ 5.7000E+01, 2.750000E+02},{ 5.8000E+01, 2.580000E+02},{ 5.9000E+01, 2.410000E+02},{ 6.0000E+01, 2.240000E+02},
			{ 6.1000E+01, 2.930000E+02},{ 6.2000E+01, 1.770000E+02},{ 6.3000E+01, 1.850000E+02},{ 6.4000E+01, 2.080000E+02},
			{ 6.5000E+01, 1.290000E+02},{ 6.6000E+01, 2.530000E+02},{ 6.7000E+01, 2.950000E+02},{ 6.8000E+01, 2.050000E+02},
			{ 6.9000E+01, 2.070000E+02},{ 7.0000E+01, 2.790000E+02},{ 7.1000E+01, 2.140000E+02},{ 7.2000E+01, 8.200000E+01},
			{ 7.3000E+01, 1.870000E+02},{ 7.4000E+01, 1.700000E+02},{ 7.5000E+01, 1.420000E+02},{ 7.6000E+01, 2.520000E+02},
			{ 7.7000E+01, 2.110000E+02},{ 7.8000E+01, 1.860000E+02},{ 7.9000E+01, 2.790000E+02},{ 8.0000E+01, 2.700000E+02},
			{ 8.1000E+01, 2.150000E+02},{ 8.2000E+01, 1.850000E+02},{ 8.3000E+01, 2.680000E+02},{ 8.4000E+01, 2.010000E+02},
			{ 8.5000E+01, 1.850000E+02},{ 8.6000E+01, 1.810000E+02},{ 8.7000E+01, 2.610000E+02},{ 8.8000E+01, 1.980000E+02},
			{ 8.9000E+01, 1.480000E+02},{ 9.0000E+01, 2.910000E+02},{ 9.1000E+01, 1.960000E+02},{ 9.2000E+01, 2.450000E+02},
			{ 9.3000E+01, 2.840000E+02},{ 9.4000E+01, 2.010000E+02},{ 9.5000E+01, 1.000000E+02},{ 9.6000E+01, 1.430000E+02},
			{ 9.7000E+01, 6.500000E+01},{ 9.8000E+01, 1.470000E+02},{ 9.9000E+01, 1.890000E+02},{ 1.0000E+02, 2.690000E+02},
			{ 1.0100E+02, 1.530000E+02},{ 1.0200E+02, 1.810000E+02},{ 1.0300E+02, 1.980000E+02},{ 1.0400E+02, 1.720000E+02},
			{ 1.0500E+02, 1.780000E+02},{ 1.0600E+02, 1.980000E+02},{ 1.0700E+02, 1.390000E+02},{ 1.0800E+02, 1.010000E+02},
			{ 1.0900E+02, 1.380000E+02},{ 1.1000E+02, 1.540000E+02},{ 1.1100E+02, 1.390000E+02},{ 1.1200E+02, 2.490000E+02},
			{ 1.1300E+02, 1.750000E+02},{ 1.1400E+02, 1.520000E+02},{ 1.1500E+02, 1.160000E+02},{ 1.1600E+02, 1.140000E+02},
			{ 1.1700E+02, 1.610000E+02},{ 1.1800E+02, 1.520000E+02},{ 1.1900E+02, 1.520000E+02},{ 1.2000E+02, 1.180000E+02},
			{ 1.2100E+02, 1.810000E+02},{ 1.2200E+02, 2.560000E+02},{ 1.2300E+02, 2.990000E+02},{ 1.2400E+02, 2.560000E+02},
			{ 1.2500E+02, 1.670000E+02},{ 1.2600E+02, 7.900000E+01},{ 1.2700E+02, 9.100000E+01},{ 1.2800E+02, 1.380000E+02},
			{ 1.2900E+02, 1.390000E+02},{ 1.3000E+02, 1.850000E+02},{ 1.3100E+02, 1.190000E+02},{ 1.3200E+02, 1.110000E+02},
			{ 1.3300E+02, 1.420000E+02},{ 1.3400E+02, 1.330000E+02},{ 1.3500E+02, 2.010000E+02},{ 1.3600E+02, 1.280000E+02},
			{ 1.3700E+02, 1.220000E+02},{ 1.3800E+02, 1.150000E+02},{ 1.3900E+02, 1.430000E+02},{ 1.4000E+02, 8.800000E+01},
			{ 1.4100E+02, 1.360000E+02},{ 1.4200E+02, 8.500000E+01},{ 1.4300E+02, 1.270000E+02},{ 1.4400E+02, 1.710000E+02},
			{ 1.4500E+02, 1.540000E+02},{ 1.4600E+02, 1.030000E+02},{ 1.4700E+02, 1.750000E+02},{ 1.4800E+02, 2.210000E+02},
			{ 1.4900E+02, 2.030000E+02},{ 1.5000E+02, 2.540000E+02},{ 1.5100E+02, 1.300000E+02},{ 1.5200E+02, 1.340000E+02},
			{ 1.5300E+02, 2.320000E+02},{ 1.5400E+02, 2.630000E+02},{ 1.5500E+02, 1.910000E+02},{ 1.5600E+02, 1.660000E+02},
			{ 1.5700E+02, 1.650000E+02},{ 1.5800E+02, 1.220000E+02},{ 1.5900E+02, 1.970000E+02},{ 1.6000E+02, 2.820000E+02},
			{ 1.6100E+02, 2.080000E+02},{ 1.6200E+02, 1.670000E+02},{ 1.6300E+02, 7.100000E+01},{ 1.6400E+02, 2.180000E+02},
			{ 1.6500E+02, 2.130000E+02},{ 1.6600E+02, 2.140000E+02},{ 1.6700E+02, 1.610000E+02},{ 1.6800E+02, 2.850000E+02},
			{ 1.6900E+02, 2.650000E+02},{ 1.7000E+02, 2.500000E+02},{ 1.7100E+02, 1.250000E+02},{ 1.7200E+02, 1.720000E+02},
			{ 1.7300E+02, 1.360000E+02},{ 1.7400E+02, 1.620000E+02},{ 1.7500E+02, 2.230000E+02},{ 1.7600E+02, 2.810000E+02},
			{ 1.7700E+02, 2.630000E+02},{ 1.7800E+02, 1.560000E+02},{ 1.7900E+02, 2.270000E+02},{ 1.8000E+02, 2.570000E+02},
			{ 1.8100E+02, 2.900000E+02},{ 1.8200E+02, 2.540000E+02},{ 1.8300E+02, 1.970000E+02},{ 1.8400E+02, 2.470000E+02},
			{ 1.8500E+02, 2.220000E+02},{ 1.8600E+02, 1.980000E+02},{ 1.8700E+02, 1.430000E+02},{ 1.8800E+02, 1.580000E+02},
			{ 1.8900E+02, 2.490000E+02},{ 1.9000E+02, 2.650000E+02},{ 1.9100E+02, 2.870000E+02},{ 1.9200E+02, 2.750000E+02},
			{ 1.9300E+02, 1.590000E+02},{ 1.9400E+02, 1.150000E+02},{ 1.9500E+02, 1.200000E+02},{ 1.9600E+02, 2.790000E+02},
			{ 1.9700E+02, 1.950000E+02},{ 1.9800E+02, 2.110000E+02},{ 1.9900E+02, 1.620000E+02},{ 2.0000E+02, 9.100000E+01},
			{ 2.0100E+02, 1.890000E+02},{ 2.0200E+02, 2.710000E+02},{ 2.0300E+02, 1.550000E+02},{ 2.0400E+02, 1.890000E+02},
			{ 2.0500E+02, 2.030000E+02},{ 2.0600E+02, 1.910000E+02},{ 2.0700E+02, 1.770000E+02},{ 2.0800E+02, 1.720000E+02},
			{ 2.0900E+02, 1.820000E+02},{ 2.1000E+02, 1.190000E+02},{ 2.1100E+02, 9.500000E+01},{ 2.1200E+02, 1.500000E+02},
			{ 2.1300E+02, 1.710000E+02},{ 2.1400E+02, 1.780000E+02},{ 2.1500E+02, 1.630000E+02},{ 2.1600E+02, 2.720000E+02},
			{ 2.1700E+02, 2.230000E+02},{ 2.1800E+02, 1.840000E+02},{ 2.1900E+02, 1.820000E+02},{ 2.2000E+02, 1.920000E+02},
			{ 2.2100E+02, 2.450000E+02},{ 2.2200E+02, 2.180000E+02},{ 2.2300E+02, 2.150000E+02},{ 2.2400E+02, 2.050000E+02},
			{ 2.2500E+02, 1.970000E+02},{ 2.2600E+02, 1.530000E+02},{ 2.2700E+02, 1.750000E+02},{ 2.2800E+02, 2.160000E+02},
			{ 2.2900E+02, 1.470000E+02},{ 2.3000E+02, 6.100000E+01},{ 2.3100E+02, 2.000000E+02},{ 2.3200E+02, 1.590000E+02},
			{ 2.3300E+02, 1.700000E+02},{ 2.3400E+02, 2.860000E+02},{ 2.3500E+02, 2.000000E+02},{ 2.3600E+02, 2.440000E+02},
			{ 2.3700E+02, 2.770000E+02},{ 2.3800E+02, 2.250000E+02},{ 2.3900E+02, 2.190000E+02},{ 2.4000E+02, 2.910000E+02},
			{ 2.4100E+02, 2.280000E+02},{ 2.4200E+02, 2.340000E+02},{ 2.4300E+02, 1.910000E+02},{ 2.4400E+02, 1.960000E+02},
			{ 2.4500E+02, 1.450000E+02},{ 2.4600E+02, 5.400000E+01},{ 2.4700E+02, 1.300000E+02},{ 2.4800E+02, 1.620000E+02},
			{ 2.4900E+02, 2.160000E+02},{ 2.5000E+02, 2.620000E+02},{ 2.5100E+02, 2.020000E+02},{ 2.5200E+02, 2.180000E+02},
			{ 2.5300E+02, 1.980000E+02},{ 2.5400E+02, 1.970000E+02},{ 2.5500E+02, 1.890000E+02},{ 2.5600E+02, 2.560000E+02},
			{ 2.5700E+02, 2.830000E+02},{ 2.5800E+02, 2.610000E+02},{ 2.5900E+02, 2.280000E+02},{ 2.6000E+02, 2.730000E+02},
			{ 2.6100E+02, 2.180000E+02},{ 2.6200E+02, 2.050000E+02},{ 2.6300E+02, 1.220000E+02},{ 2.6400E+02, 1.340000E+02},
			{ 2.6500E+02, 1.880000E+02},{ 2.6600E+02, 1.570000E+02},{ 2.6700E+02, 1.420000E+02},{ 2.6800E+02, 2.650000E+02},
			{ 2.6900E+02, 2.140000E+02},{ 2.7000E+02, 1.390000E+02},{ 2.7100E+02, 2.200000E+02},{ 2.7200E+02, 1.400000E+02},
			{ 2.7300E+02, 1.980000E+02},{ 2.7400E+02, 2.710000E+02},{ 2.7500E+02, 1.490000E+02},{ 2.7600E+02, 1.770000E+02},
			{ 2.7700E+02, 2.520000E+02},{ 2.7800E+02, 3.020000E+02},{ 2.7900E+02, 2.480000E+02},{ 2.8000E+02, 2.340000E+02},
			{ 2.8100E+02, 1.910000E+02},{ 2.8200E+02, 2.770000E+02},{ 2.8300E+02, 3.120000E+02},{ 2.8400E+02, 1.700000E+02},
			{ 2.8500E+02, 1.820000E+02},{ 2.8600E+02, 1.980000E+02},{ 2.8700E+02, 1.560000E+02},{ 2.8800E+02, 2.450000E+02},
			{ 2.8900E+02, 2.100000E+02},{ 2.9000E+02, 1.000000E+02},{ 2.9100E+02, 2.530000E+02},{ 2.9200E+02, 2.370000E+02},
			{ 2.9300E+02, 1.630000E+02},{ 2.9400E+02, 2.090000E+02},{ 2.9500E+02, 2.110000E+02},{ 2.9600E+02, 2.520000E+02},
			{ 2.9700E+02, 3.110000E+02},{ 2.9800E+02, 2.200000E+02},{ 2.9900E+02, 1.530000E+02},{ 3.0000E+02, 2.150000E+02},
			{ 3.0100E+02, 2.620000E+02},{ 3.0200E+02, 2.000000E+02},{ 3.0300E+02, 2.670000E+02},{ 3.0400E+02, 2.190000E+02},
			{ 3.0500E+02, 2.170000E+02},{ 3.0600E+02, 2.180000E+02},{ 3.0700E+02, 2.200000E+02},{ 3.0800E+02, 2.550000E+02},
			{ 3.0900E+02, 1.880000E+02},{ 3.1000E+02, 2.710000E+02},{ 3.1100E+02, 2.080000E+02},{ 3.1200E+02, 1.880000E+02},
			{ 3.1300E+02, 2.240000E+02},{ 3.1400E+02, 2.850000E+02},{ 3.1500E+02, 1.820000E+02},{ 3.1600E+02, 2.350000E+02},
			{ 3.1700E+02, 2.700000E+02},{ 3.1800E+02, 2.430000E+02},{ 3.1900E+02, 2.210000E+02},{ 3.2000E+02, 1.880000E+02},
			{ 3.2100E+02, 2.110000E+02},{ 3.2200E+02, 2.150000E+02},{ 3.2300E+02, 1.960000E+02},{ 3.2400E+02, 2.190000E+02},
			{ 3.2500E+02, 2.050000E+02},{ 3.2600E+02, 2.840000E+02},{ 3.2700E+02, 1.930000E+02},{ 3.2800E+02, 2.250000E+02},
			{ 3.2900E+02, 2.960000E+02},{ 3.3000E+02, 2.300000E+02},{ 3.3100E+02, 2.840000E+02},{ 3.3200E+02, 2.220000E+02},
			{ 3.3300E+02, 2.340000E+02},{ 3.3400E+02, 3.250000E+02},{ 3.3500E+02, 3.250000E+02},{ 3.3600E+02, 2.120000E+02},
			{ 3.3700E+02, 1.720000E+02},{ 3.3800E+02, 2.390000E+02},{ 3.3900E+02, 2.520000E+02},{ 3.4000E+02, 2.230000E+02},
			{ 3.4100E+02, 2.410000E+02},{ 3.4200E+02, 2.460000E+02},{ 3.4300E+02, 1.670000E+02},{ 3.4400E+02, 2.270000E+02},
			{ 3.4500E+02, 2.250000E+02},{ 3.4600E+02, 2.420000E+02},{ 3.4700E+02, 3.040000E+02},{ 3.4800E+02, 2.270000E+02},
			{ 3.4900E+02, 2.340000E+02},{ 3.5000E+02, 1.480000E+02},{ 3.5100E+02, 1.350000E+02},{ 3.5200E+02, 1.650000E+02},
			{ 3.5300E+02, 1.850000E+02},{ 3.5400E+02, 3.180000E+02},{ 3.5500E+02, 2.860000E+02},{ 3.5600E+02, 2.070000E+02},
			{ 3.5700E+02, 2.250000E+02},{ 3.5800E+02, 1.840000E+02},{ 3.5900E+02, 1.510000E+02},{ 3.6000E+02, 2.770000E+02},
			{ 3.6100E+02, 2.810000E+02},{ 3.6200E+02, 2.410000E+02},{ 3.6300E+02, 2.490000E+02},{ 3.6400E+02, 2.020000E+02},
			{ 3.6500E+02, 3.220000E+02}, };
		return SL::Graph( 0, x, 365, g); 
	}

	inline double Graph8(double x) { 
		static double g[366][2] = {
			{ 1.0000E+00, 9.850000E+00},{ 2.0000E+00, 8.780000E+00},{ 3.0000E+00, 1.120000E+01},{ 4.0000E+00, 9.080000E+00},
			{ 5.0000E+00, 1.080000E+01},{ 6.0000E+00, 1.260000E+01},{ 7.0000E+00, 9.460000E+00},{ 8.0000E+00, 1.120000E+01},
			{ 9.0000E+00, 1.290000E+01},{ 1.0000E+01, 1.180000E+01},{ 1.1000E+01, 7.120000E+00},{ 1.2000E+01, 1.330000E+01},
			{ 1.3000E+01, 7.500000E+00},{ 1.4000E+01, 1.480000E+01},{ 1.5000E+01, 1.070000E+01},{ 1.6000E+01, 6.490000E+00},
			{ 1.7000E+01, 6.490000E+00},{ 1.8000E+01, 7.920000E+00},{ 1.9000E+01, 5.630000E+00},{ 2.0000E+01, 6.680000E+00},
			{ 2.1000E+01, 8.420000E+00},{ 2.2000E+01, 6.680000E+00},{ 2.3000E+01, 1.160000E+01},{ 2.4000E+01, 8.500000E+00},
			{ 2.5000E+01, 9.950000E+00},{ 2.6000E+01, 2.060000E+01},{ 2.7000E+01, 1.640000E+01},{ 2.8000E+01, 1.270000E+01},
			{ 2.9000E+01, 9.560000E+00},{ 3.0000E+01, 8.030000E+00},{ 3.1000E+01, 1.100000E+01},{ 3.2000E+01, 5.440000E+00},
			{ 3.3000E+01, 9.700000E+00},{ 3.4000E+01, 7.260000E+00},{ 3.5000E+01, 7.030000E+00},{ 3.6000E+01, 7.030000E+00},
			{ 3.7000E+01, 1.250000E+01},{ 3.8000E+01, 6.920000E+00},{ 3.9000E+01, 4.670000E+00},{ 4.0000E+01, 4.610000E+00},
			{ 4.1000E+01, 4.730000E+00},{ 4.2000E+01, 6.200000E+00},{ 4.3000E+01, 6.400000E+00},{ 4.4000E+01, 5.640000E+00},
			{ 4.5000E+01, 8.030000E+00},{ 4.6000E+01, 9.220000E+00},{ 4.7000E+01, 7.260000E+00},{ 4.8000E+01, 7.200000E+00},
			{ 4.9000E+01, 1.070000E+01},{ 5.0000E+01, 9.890000E+00},{ 5.1000E+01, 5.730000E+00},{ 5.2000E+01, 9.180000E+00},
			{ 5.3000E+01, 1.440000E+01},{ 5.4000E+01, 8.510000E+00},{ 5.5000E+01, 6.690000E+00},{ 5.6000E+01, 1.100000E+01},
			{ 5.7000E+01, 1.130000E+01},{ 5.8000E+01, 8.980000E+00},{ 5.9000E+01, 6.680000E+00},{ 6.0000E+01, 5.680000E+00},
			{ 6.1000E+01, 7.690000E+00},{ 6.2000E+01, 5.100000E+00},{ 6.3000E+01, 5.820000E+00},{ 6.4000E+01, 5.720000E+00},
			{ 6.5000E+01, 8.980000E+00},{ 6.6000E+01, 1.670000E+01},{ 6.7000E+01, 1.510000E+01},{ 6.8000E+01, 4.920000E+00},
			{ 6.9000E+01, 8.600000E+00},{ 7.0000E+01, 9.750000E+00},{ 7.1000E+01, 7.250000E+00},{ 7.2000E+01, 7.210000E+00},
			{ 7.3000E+01, 9.030000E+00},{ 7.4000E+01, 1.090000E+01},{ 7.5000E+01, 4.530000E+00},{ 7.6000E+01, 7.250000E+00},
			{ 7.7000E+01, 7.640000E+00},{ 7.8000E+01, 1.510000E+01},{ 7.9000E+01, 1.540000E+01},{ 8.0000E+01, 1.120000E+01},
			{ 8.1000E+01, 6.890000E+00},{ 8.2000E+01, 1.300000E+01},{ 8.3000E+01, 1.150000E+01},{ 8.4000E+01, 6.720000E+00},
			{ 8.5000E+01, 1.220000E+01},{ 8.6000E+01, 9.760000E+00},{ 8.7000E+01, 1.130000E+01},{ 8.8000E+01, 1.020000E+01},
			{ 8.9000E+01, 9.890000E+00},{ 9.0000E+01, 1.090000E+01},{ 9.1000E+01, 1.180000E+01},{ 9.2000E+01, 1.180000E+01},
			{ 9.3000E+01, 1.130000E+01},{ 9.4000E+01, 6.780000E+00},{ 9.5000E+01, 1.140000E+01},{ 9.6000E+01, 8.360000E+00},
			{ 9.7000E+01, 1.090000E+01},{ 9.8000E+01, 8.700000E+00},{ 9.9000E+01, 7.450000E+00},{ 1.0000E+02, 7.600000E+00},
			{ 1.0100E+02, 8.930000E+00},{ 1.0200E+02, 7.200000E+00},{ 1.0300E+02, 1.140000E+01},{ 1.0400E+02, 6.620000E+00},
			{ 1.0500E+02, 7.420000E+00},{ 1.0600E+02, 8.170000E+00},{ 1.0700E+02, 1.010000E+01},{ 1.0800E+02, 1.260000E+01},
			{ 1.0900E+02, 9.450000E+00},{ 1.1000E+02, 7.020000E+00},{ 1.1100E+02, 9.700000E+00},{ 1.1200E+02, 9.550000E+00},
			{ 1.1300E+02, 1.200000E+01},{ 1.1400E+02, 1.430000E+01},{ 1.1500E+02, 1.260000E+01},{ 1.1600E+02, 7.300000E+00},
			{ 1.1700E+02, 9.460000E+00},{ 1.1800E+02, 6.920000E+00},{ 1.1900E+02, 6.390000E+00},{ 1.2000E+02, 6.970000E+00},
			{ 1.2100E+02, 9.030000E+00},{ 1.2200E+02, 1.250000E+01},{ 1.2300E+02, 1.210000E+01},{ 1.2400E+02, 8.650000E+00},
			{ 1.2500E+02, 9.040000E+00},{ 1.2600E+02, 7.790000E+00},{ 1.2700E+02, 7.980000E+00},{ 1.2800E+02, 9.170000E+00},
			{ 1.2900E+02, 1.040000E+01},{ 1.3000E+02, 7.210000E+00},{ 1.3100E+02, 8.360000E+00},{ 1.3200E+02, 1.530000E+01},
			{ 1.3300E+02, 1.040000E+01},{ 1.3400E+02, 6.390000E+00},{ 1.3500E+02, 8.940000E+00},{ 1.3600E+02, 6.200000E+00},
			{ 1.3700E+02, 5.680000E+00},{ 1.3800E+02, 7.680000E+00},{ 1.3900E+02, 9.760000E+00},{ 1.4000E+02, 9.470000E+00},
			{ 1.4100E+02, 8.980000E+00},{ 1.4200E+02, 6.020000E+00},{ 1.4300E+02, 6.500000E+00},{ 1.4400E+02, 6.780000E+00},
			{ 1.4500E+02, 9.130000E+00},{ 1.4600E+02, 9.070000E+00},{ 1.4700E+02, 9.990000E+00},{ 1.4800E+02, 8.260000E+00},
			{ 1.4900E+02, 7.530000E+00},{ 1.5000E+02, 8.080000E+00},{ 1.5100E+02, 6.250000E+00},{ 1.5200E+02, 8.830000E+00},
			{ 1.5300E+02, 1.170000E+01},{ 1.5400E+02, 1.200000E+01},{ 1.5500E+02, 1.200000E+01},{ 1.5600E+02, 7.590000E+00},
			{ 1.5700E+02, 7.640000E+00},{ 1.5800E+02, 7.990000E+00},{ 1.5900E+02, 7.930000E+00},{ 1.6000E+02, 1.110000E+01},
			{ 1.6100E+02, 9.170000E+00},{ 1.6200E+02, 6.400000E+00},{ 1.6300E+02, 8.750000E+00},{ 1.6400E+02, 7.030000E+00},
			{ 1.6500E+02, 8.300000E+00},{ 1.6600E+02, 6.680000E+00},{ 1.6700E+02, 9.650000E+00},{ 1.6800E+02, 1.400000E+01},
			{ 1.6900E+02, 1.070000E+01},{ 1.7000E+02, 7.880000E+00},{ 1.7100E+02, 6.390000E+00},{ 1.7200E+02, 8.260000E+00},
			{ 1.7300E+02, 6.100000E+00},{ 1.7400E+02, 6.400000E+00},{ 1.7500E+02, 1.120000E+01},{ 1.7600E+02, 1.310000E+01},
			{ 1.7700E+02, 1.080000E+01},{ 1.7800E+02, 5.920000E+00},{ 1.7900E+02, 6.880000E+00},{ 1.8000E+02, 9.080000E+00},
			{ 1.8100E+02, 9.990000E+00},{ 1.8200E+02, 1.050000E+01},{ 1.8300E+02, 1.040000E+01},{ 1.8400E+02, 6.300000E+00},
			{ 1.8500E+02, 9.600000E+00},{ 1.8600E+02, 6.880000E+00},{ 1.8700E+02, 6.580000E+00},{ 1.8800E+02, 7.250000E+00},
			{ 1.8900E+02, 8.020000E+00},{ 1.9000E+02, 7.210000E+00},{ 1.9100E+02, 9.990000E+00},{ 1.9200E+02, 6.600000E+00},
			{ 1.9300E+02, 5.020000E+00},{ 1.9400E+02, 6.640000E+00},{ 1.9500E+02, 5.630000E+00},{ 1.9600E+02, 8.930000E+00},
			{ 1.9700E+02, 8.020000E+00},{ 1.9800E+02, 7.880000E+00},{ 1.9900E+02, 7.500000E+00},{ 2.0000E+02, 6.110000E+00},
			{ 2.0100E+02, 8.180000E+00},{ 2.0200E+02, 7.930000E+00},{ 2.0300E+02, 7.740000E+00},{ 2.0400E+02, 5.670000E+00},
			{ 2.0500E+02, 8.260000E+00},{ 2.0600E+02, 1.060000E+01},{ 2.0700E+02, 9.550000E+00},{ 2.0800E+02, 6.390000E+00},
			{ 2.0900E+02, 5.720000E+00},{ 2.1000E+02, 5.350000E+00},{ 2.1100E+02, 1.080000E+01},{ 2.1200E+02, 7.350000E+00},
			{ 2.1300E+02, 8.120000E+00},{ 2.1400E+02, 6.580000E+00},{ 2.1500E+02, 5.970000E+00},{ 2.1600E+02, 7.600000E+00},
			{ 2.1700E+02, 8.270000E+00},{ 2.1800E+02, 6.970000E+00},{ 2.1900E+02, 8.460000E+00},{ 2.2000E+02, 6.930000E+00},
			{ 2.2100E+02, 6.300000E+00},{ 2.2200E+02, 7.550000E+00},{ 2.2300E+02, 8.800000E+00},{ 2.2400E+02, 6.730000E+00},
			{ 2.2500E+02, 7.210000E+00},{ 2.2600E+02, 6.400000E+00},{ 2.2700E+02, 7.220000E+00},{ 2.2800E+02, 6.580000E+00},
			{ 2.2900E+02, 6.010000E+00},{ 2.3000E+02, 5.480000E+00},{ 2.3100E+02, 1.010000E+01},{ 2.3200E+02, 7.030000E+00},
			{ 2.3300E+02, 7.210000E+00},{ 2.3400E+02, 8.450000E+00},{ 2.3500E+02, 8.120000E+00},{ 2.3600E+02, 1.600000E+01},
			{ 2.3700E+02, 1.210000E+01},{ 2.3800E+02, 8.220000E+00},{ 2.3900E+02, 1.110000E+01},{ 2.4000E+02, 7.210000E+00},
			{ 2.4100E+02, 6.530000E+00},{ 2.4200E+02, 7.170000E+00},{ 2.4300E+02, 6.320000E+00},{ 2.4400E+02, 6.740000E+00},
			{ 2.4500E+02, 5.540000E+00},{ 2.4600E+02, 9.560000E+00},{ 2.4700E+02, 5.970000E+00},{ 2.4800E+02, 6.670000E+00},
			{ 2.4900E+02, 7.080000E+00},{ 2.5000E+02, 6.880000E+00},{ 2.5100E+02, 6.540000E+00},{ 2.5200E+02, 7.680000E+00},
			{ 2.5300E+02, 7.640000E+00},{ 2.5400E+02, 1.080000E+01},{ 2.5500E+02, 1.030000E+01},{ 2.5600E+02, 8.940000E+00},
			{ 2.5700E+02, 1.000000E+01},{ 2.5800E+02, 8.260000E+00},{ 2.5900E+02, 1.360000E+01},{ 2.6000E+02, 7.970000E+00},
			{ 2.6100E+02, 7.460000E+00},{ 2.6200E+02, 5.150000E+00},{ 2.6300E+02, 5.490000E+00},{ 2.6400E+02, 5.670000E+00},
			{ 2.6500E+02, 6.490000E+00},{ 2.6600E+02, 5.970000E+00},{ 2.6700E+02, 5.730000E+00},{ 2.6800E+02, 8.510000E+00},
			{ 2.6900E+02, 5.730000E+00},{ 2.7000E+02, 8.840000E+00},{ 2.7100E+02, 6.060000E+00},{ 2.7200E+02, 5.150000E+00},
			{ 2.7300E+02, 9.320000E+00},{ 2.7400E+02, 1.010000E+01},{ 2.7500E+02, 5.060000E+00},{ 2.7600E+02, 6.300000E+00},
			{ 2.7700E+02, 8.170000E+00},{ 2.7800E+02, 7.780000E+00},{ 2.7900E+02, 1.320000E+01},{ 2.8000E+02, 7.970000E+00},
			{ 2.8100E+02, 1.080000E+01},{ 2.8200E+02, 1.110000E+01},{ 2.8300E+02, 9.320000E+00},{ 2.8400E+02, 5.680000E+00},
			{ 2.8500E+02, 5.720000E+00},{ 2.8600E+02, 6.210000E+00},{ 2.8700E+02, 5.100000E+00},{ 2.8800E+02, 1.070000E+01},
			{ 2.8900E+02, 5.290000E+00},{ 2.9000E+02, 1.070000E+01},{ 2.9100E+02, 8.790000E+00},{ 2.9200E+02, 4.710000E+00},
			{ 2.9300E+02, 6.590000E+00},{ 2.9400E+02, 7.350000E+00},{ 2.9500E+02, 7.600000E+00},{ 2.9600E+02, 1.280000E+01},
			{ 2.9700E+02, 9.230000E+00},{ 2.9800E+02, 4.820000E+00},{ 2.9900E+02, 5.540000E+00},{ 3.0000E+02, 8.690000E+00},
			{ 3.0100E+02, 4.920000E+00},{ 3.0200E+02, 7.690000E+00},{ 3.0300E+02, 1.120000E+01},{ 3.0400E+02, 7.790000E+00},
			{ 3.0500E+02, 1.090000E+01},{ 3.0600E+02, 7.200000E+00},{ 3.0700E+02, 6.500000E+00},{ 3.0800E+02, 1.250000E+01},
			{ 3.0900E+02, 6.780000E+00},{ 3.1000E+02, 8.790000E+00},{ 3.1100E+02, 5.290000E+00},{ 3.1200E+02, 7.490000E+00},
			{ 3.1300E+02, 7.780000E+00},{ 3.1400E+02, 1.090000E+01},{ 3.1500E+02, 3.370000E+00},{ 3.1600E+02, 4.870000E+00},
			{ 3.1700E+02, 1.270000E+01},{ 3.1800E+02, 1.040000E+01},{ 3.1900E+02, 9.810000E+00},{ 3.2000E+02, 4.430000E+00},
			{ 3.2100E+02, 6.870000E+00},{ 3.2200E+02, 7.780000E+00},{ 3.2300E+02, 1.430000E+01},{ 3.2400E+02, 8.750000E+00},
			{ 3.2500E+02, 1.820000E+01},{ 3.2600E+02, 1.250000E+01},{ 3.2700E+02, 7.540000E+00},{ 3.2800E+02, 1.270000E+01},
			{ 3.2900E+02, 7.780000E+00},{ 3.3000E+02, 8.750000E+00},{ 3.3100E+02, 9.900000E+00},{ 3.3200E+02, 6.110000E+00},
			{ 3.3300E+02, 5.870000E+00},{ 3.3400E+02, 1.290000E+01},{ 3.3500E+02, 9.710000E+00},{ 3.3600E+02, 7.030000E+00},
			{ 3.3700E+02, 1.570000E+01},{ 3.3800E+02, 1.240000E+01},{ 3.3900E+02, 1.170000E+01},{ 3.4000E+02, 9.120000E+00},
			{ 3.4100E+02, 8.930000E+00},{ 3.4200E+02, 1.350000E+01},{ 3.4300E+02, 1.250000E+01},{ 3.4400E+02, 7.550000E+00},
			{ 3.4500E+02, 6.780000E+00},{ 3.4600E+02, 8.460000E+00},{ 3.4700E+02, 1.080000E+01},{ 3.4800E+02, 8.460000E+00},
			{ 3.4900E+02, 9.040000E+00},{ 3.5000E+02, 6.010000E+00},{ 3.5100E+02, 8.220000E+00},{ 3.5200E+02, 1.030000E+01},
			{ 3.5300E+02, 1.460000E+01},{ 3.5400E+02, 8.270000E+00},{ 3.5500E+02, 8.600000E+00},{ 3.5600E+02, 6.780000E+00},
			{ 3.5700E+02, 8.990000E+00},{ 3.5800E+02, 5.200000E+00},{ 3.5900E+02, 1.130000E+01},{ 3.6000E+02, 6.550000E+00},
			{ 3.6100E+02, 4.670000E+00},{ 3.6200E+02, 4.880000E+00},{ 3.6300E+02, 5.530000E+00},{ 3.6400E+02, 7.470000E+00},
			{ 3.6500E+02, 1.360000E+01}, };
		return SL::Graph( 0, x, 365, g); 
	}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int DAYS_I70_exe_g(Variable* obj) { return GLOBAL_module::I().DAYS_I70_exe(); }
int DAYS_i71_exe_g(Variable* obj) { return GLOBAL_module::I().DAYS_i71_exe(); }
int COUNT_HOURS_u72_exe_g(Variable* obj) { return GLOBAL_module::I().COUNT_HOURS_u72_exe(); }
int BOTTOM_MAP_u73_exe_g(Variable* obj) { return GLOBAL_module::I().BOTTOM_MAP_u73_exe(); }
int CURRENT_DIRECTION_u74_exe_g(Variable* obj) { return GLOBAL_module::I().CURRENT_DIRECTION_u74_exe(); }
int CURRENT_VELOCITY_u75_exe_g(Variable* obj) { return GLOBAL_module::I().CURRENT_VELOCITY_u75_exe(); }
int EC_H2O_u76_exe_g(Variable* obj) { return GLOBAL_module::I().EC_H2O_u76_exe(); }
int EW_CURRENT_VECTOR_u77_exe_g(Variable* obj) { return GLOBAL_module::I().EW_CURRENT_VECTOR_u77_exe(); }
int EW_VECTOR_u78_exe_g(Variable* obj) { return GLOBAL_module::I().EW_VECTOR_u78_exe(); }
int EW_WIND_VECTOR_u79_exe_g(Variable* obj) { return GLOBAL_module::I().EW_WIND_VECTOR_u79_exe(); }
int HOURS_u80_exe_g(Variable* obj) { return GLOBAL_module::I().HOURS_u80_exe(); }
int LIGHT_TO_PHYTOPLANKTON_u81_exe_g(Variable* obj) { return GLOBAL_module::I().LIGHT_TO_PHYTOPLANKTON_u81_exe(); }
int NS_CURRENT_VECTOR_u82_exe_g(Variable* obj) { return GLOBAL_module::I().NS_CURRENT_VECTOR_u82_exe(); }
int NS_VECTOR_u83_exe_g(Variable* obj) { return GLOBAL_module::I().NS_VECTOR_u83_exe(); }
int NS_WIND_VECTOR_u84_exe_g(Variable* obj) { return GLOBAL_module::I().NS_WIND_VECTOR_u84_exe(); }
int OM3_SALT_CONC_u85_exe_g(Variable* obj) { return GLOBAL_module::I().OM3_SALT_CONC_u85_exe(); }
int OM3_SHEAR_STRESS_u86_exe_g(Variable* obj) { return GLOBAL_module::I().OM3_SHEAR_STRESS_u86_exe(); }
int OM3_TEMP_u87_exe_g(Variable* obj) { return GLOBAL_module::I().OM3_TEMP_u87_exe(); }
int OM3_UD_CURRENT_VECTOR_u88_exe_g(Variable* obj) { return GLOBAL_module::I().OM3_UD_CURRENT_VECTOR_u88_exe(); }
int PHOTO_PERIOD_u89_exe_g(Variable* obj) { return GLOBAL_module::I().PHOTO_PERIOD_u89_exe(); }
int RAND_u90_exe_g(Variable* obj) { return GLOBAL_module::I().RAND_u90_exe(); }
int SDCLN_u91_exe_g(Variable* obj) { return GLOBAL_module::I().SDCLN_u91_exe(); }
int SF_WATER_u92_exe_g(Variable* obj) { return GLOBAL_module::I().SF_WATER_u92_exe(); }
int SURFACE_LIGHT_u93_exe_g(Variable* obj) { return GLOBAL_module::I().SURFACE_LIGHT_u93_exe(); }
int SURFACE_MAP_u94_exe_g(Variable* obj) { return GLOBAL_module::I().SURFACE_MAP_u94_exe(); }
int WATER_DEPTH_u95_exe_g(Variable* obj) { return GLOBAL_module::I().WATER_DEPTH_u95_exe(); }
int WATER_LAYER_DEPTH_u96_exe_g(Variable* obj) { return GLOBAL_module::I().WATER_LAYER_DEPTH_u96_exe(); }
int WATER_LAYER_HEIGHT_u97_exe_g(Variable* obj) { return GLOBAL_module::I().WATER_LAYER_HEIGHT_u97_exe(); }
int P_CELL_AREA_u100_exe_g(Variable* obj) { return GLOBAL_module::I().P_CELL_AREA_u100_exe(); }
int P_CHL_A_MAP_u101_exe_g(Variable* obj) { return GLOBAL_module::I().P_CHL_A_MAP_u101_exe(); }
int P_EC_COEFF_SED_u102_exe_g(Variable* obj) { return GLOBAL_module::I().P_EC_COEFF_SED_u102_exe(); }
int P_EC_COEFF_WATER_u103_exe_g(Variable* obj) { return GLOBAL_module::I().P_EC_COEFF_WATER_u103_exe(); }
int P_IC_SED_ELEV_u104_exe_g(Variable* obj) { return GLOBAL_module::I().P_IC_SED_ELEV_u104_exe(); }
int P_LATITUDE_u105_exe_g(Variable* obj) { return GLOBAL_module::I().P_LATITUDE_u105_exe(); }
int P_ON_MAP_u106_exe_g(Variable* obj) { return GLOBAL_module::I().P_ON_MAP_u106_exe(); }
int DECLINE_u107_exe_g(Variable* obj) { return GLOBAL_module::I().DECLINE_u107_exe(); }
int H_ANGLE_u108_exe_g(Variable* obj) { return GLOBAL_module::I().H_ANGLE_u108_exe(); }
int SKEW_WEATHER_u109_exe_g(Variable* obj) { return GLOBAL_module::I().SKEW_WEATHER_u109_exe(); }
int P_AIR_TEMP_u110_exe_g(Variable* obj) { return GLOBAL_module::I().P_AIR_TEMP_u110_exe(); }
int P_LEAF_GROW_SEASON_u111_exe_g(Variable* obj) { return GLOBAL_module::I().P_LEAF_GROW_SEASON_u111_exe(); }
int P_PRECIPITATION_u112_exe_g(Variable* obj) { return GLOBAL_module::I().P_PRECIPITATION_u112_exe(); }
int P_WIND_DIRECTION_u113_exe_g(Variable* obj) { return GLOBAL_module::I().P_WIND_DIRECTION_u113_exe(); }
int P_WIND_SPEED_u114_exe_g(Variable* obj) { return GLOBAL_module::I().P_WIND_SPEED_u114_exe(); }
// ---------------------------------------------------------------------------
//                    Class PHOSPHATE_module 
// ---------------------------------------------------------------------------

class PHOSPHATE_module : public TModule {
protected:

	PHOSPHATE_module(char* name);

public:

	TTime TIME;
	CAuxVariable SF_WATER;
	CFluxVariable DETR_DECOMPOSED;
	CAuxVariable PHT_NET_PROD;
	CAuxVariable P_PHY_PC;
	CAuxVariable BOTTOM_MAP;
	CAuxVariable PO4_SF_WT_CONC;
	CStateVariable PO4_SF_WT;
	CFluxVariable PO4_MINERALIZATION;
	CFluxVariable PO4_UPFL;
	CFluxVariable PO4_SF_TO_SED__FL;
	CFluxVariable PO4_SF_WT_UPTAK;
	CFluxVariable RIVER_P;
	CAuxVariable P_DETR_PC_RT;
	CAuxVariable P_IC_PO4;
	CAuxVariable P_PO4_SED_WT_CONC;
	CAuxVariable P_SED_WAT_DIFFUSION_CF;
protected:

	int PO4_SF_WT_I115_exe();
	friend int PO4_SF_WT_I115_exe_g( Variable* v );
	int PO4_SF_WT_i116_exe();
	friend int PO4_SF_WT_i116_exe_g( Variable* v );
	int PO4_MINERALIZATION_u117_exe();
	friend int PO4_MINERALIZATION_u117_exe_g( Variable* v );
	int PO4_UPFL_u118_exe();
	friend int PO4_UPFL_u118_exe_g( Variable* v );
	int PO4_SF_TO_SED__FL_u119_exe();
	friend int PO4_SF_TO_SED__FL_u119_exe_g( Variable* v );
	int PO4_SF_WT_UPTAK_u120_exe();
	friend int PO4_SF_WT_UPTAK_u120_exe_g( Variable* v );
	int PO4_SF_WT_CONC_u121_exe();
	friend int PO4_SF_WT_CONC_u121_exe_g( Variable* v );
	int RIVER_P_u122_exe();
	friend int RIVER_P_u122_exe_g( Variable* v );
	int P_DETR_PC_RT_u123_exe();
	friend int P_DETR_PC_RT_u123_exe_g( Variable* v );
	int P_IC_PO4_u124_exe();
	friend int P_IC_PO4_u124_exe_g( Variable* v );
	int P_PO4_SED_WT_CONC_u125_exe();
	friend int P_PO4_SED_WT_CONC_u125_exe_g( Variable* v );
	int P_SED_WAT_DIFFUSION_CF_u126_exe();
	friend int P_SED_WAT_DIFFUSION_CF_u126_exe_g( Variable* v );
	static PHOSPHATE_module* fInstance;
	static PHOSPHATE_module* kNullModel;
public:
	inline static PHOSPHATE_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new PHOSPHATE_module("PHOSPHATE_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (PHOSPHATE_module&) *fInstance;
	}

	virtual int InitVars();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int PO4_SF_WT_I115_exe_g(Variable* obj) { return PHOSPHATE_module::I().PO4_SF_WT_I115_exe(); }
int PO4_SF_WT_i116_exe_g(Variable* obj) { return PHOSPHATE_module::I().PO4_SF_WT_i116_exe(); }
int PO4_MINERALIZATION_u117_exe_g(Variable* obj) { return PHOSPHATE_module::I().PO4_MINERALIZATION_u117_exe(); }
int PO4_UPFL_u118_exe_g(Variable* obj) { return PHOSPHATE_module::I().PO4_UPFL_u118_exe(); }
int PO4_SF_TO_SED__FL_u119_exe_g(Variable* obj) { return PHOSPHATE_module::I().PO4_SF_TO_SED__FL_u119_exe(); }
int PO4_SF_WT_UPTAK_u120_exe_g(Variable* obj) { return PHOSPHATE_module::I().PO4_SF_WT_UPTAK_u120_exe(); }
int PO4_SF_WT_CONC_u121_exe_g(Variable* obj) { return PHOSPHATE_module::I().PO4_SF_WT_CONC_u121_exe(); }
int RIVER_P_u122_exe_g(Variable* obj) { return PHOSPHATE_module::I().RIVER_P_u122_exe(); }
int P_DETR_PC_RT_u123_exe_g(Variable* obj) { return PHOSPHATE_module::I().P_DETR_PC_RT_u123_exe(); }
int P_IC_PO4_u124_exe_g(Variable* obj) { return PHOSPHATE_module::I().P_IC_PO4_u124_exe(); }
int P_PO4_SED_WT_CONC_u125_exe_g(Variable* obj) { return PHOSPHATE_module::I().P_PO4_SED_WT_CONC_u125_exe(); }
int P_SED_WAT_DIFFUSION_CF_u126_exe_g(Variable* obj) { return PHOSPHATE_module::I().P_SED_WAT_DIFFUSION_CF_u126_exe(); }
// ---------------------------------------------------------------------------
//                    Class PHYTOPLANKTON_module 
// ---------------------------------------------------------------------------

class PHYTOPLANKTON_module : public TModule {
protected:

	PHYTOPLANKTON_module(char* name);

public:

	TTime TIME;
	CStateVariable PHYTOPLANKTON;
	CFluxVariable PHT_MORTALITY;
	CAuxVariable PHT_NET_PROD;
	CAuxVariable P_PHT_NC;
	CAuxVariable PHT_CONC;
	CAuxVariable P_PHY_PC;
	CAuxVariable SF_WATER;
	CAuxVariable CONS_INGEST_PHT;
	CAuxVariable LIGHT_TO_PHYTOPLANKTON;
	CAuxVariable DIN_CONC;
	CAuxVariable PO4_SF_WT_CONC;
	CAuxVariable OM3_TEMP;
	CAuxVariable P_CHL_A_MAP;
	CAuxVariable P_IC_PHT;
	CFluxVariable PHT_GROSS_PP;
	CFluxVariable PHT_RESP;
	CFluxVariable PHT_CONSUMED;
	CAuxVariable PHT_LIGHT_LIM;
	CAuxVariable PHT_NUT_LIMIT;
	CAuxVariable PHT_PROD_LIM;
	CAuxVariable PHT_TEMP_LIM;
	CAuxVariable RIVER_PHT;
	CAuxVariable P_PHT_GROSS_PP_RT;
	CAuxVariable P_PHT_MAX_T;
	CAuxVariable P_PHT_MIN_T;
	CAuxVariable P_PHT_MORTALITY_RT;
	CAuxVariable P_PHT_N_SAT;
	CAuxVariable P_PHT_OPT_T;
	CAuxVariable P_PHT_P_SAT;
	CAuxVariable P_PHT_RESP_RT;
	CAuxVariable CHL_CONC;
	CAuxVariable CHL_CONV_FACTOR;
protected:

	int PHYTOPLANKTON_I127_exe();
	friend int PHYTOPLANKTON_I127_exe_g( Variable* v );
	int PHYTOPLANKTON_i128_exe();
	friend int PHYTOPLANKTON_i128_exe_g( Variable* v );
	int PHT_GROSS_PP_u129_exe();
	friend int PHT_GROSS_PP_u129_exe_g( Variable* v );
	int PHT_RESP_u130_exe();
	friend int PHT_RESP_u130_exe_g( Variable* v );
	int PHT_CONSUMED_u131_exe();
	friend int PHT_CONSUMED_u131_exe_g( Variable* v );
	int PHT_MORTALITY_u132_exe();
	friend int PHT_MORTALITY_u132_exe_g( Variable* v );
	int PHT_CONC_u133_exe();
	friend int PHT_CONC_u133_exe_g( Variable* v );
	int PHT_LIGHT_LIM_u134_exe();
	friend int PHT_LIGHT_LIM_u134_exe_g( Variable* v );
	int PHT_NET_PROD_u135_exe();
	friend int PHT_NET_PROD_u135_exe_g( Variable* v );
	int PHT_NUT_LIMIT_u136_exe();
	friend int PHT_NUT_LIMIT_u136_exe_g( Variable* v );
	int PHT_PROD_LIM_u137_exe();
	friend int PHT_PROD_LIM_u137_exe_g( Variable* v );
	int PHT_TEMP_LIM_u138_exe();
	friend int PHT_TEMP_LIM_u138_exe_g( Variable* v );
	int RIVER_PHT_u139_exe();
	friend int RIVER_PHT_u139_exe_g( Variable* v );
	int P_IC_PHT_u140_exe();
	friend int P_IC_PHT_u140_exe_g( Variable* v );
	int P_PHT_GROSS_PP_RT_u141_exe();
	friend int P_PHT_GROSS_PP_RT_u141_exe_g( Variable* v );
	int P_PHT_MAX_T_u142_exe();
	friend int P_PHT_MAX_T_u142_exe_g( Variable* v );
	int P_PHT_MIN_T_u143_exe();
	friend int P_PHT_MIN_T_u143_exe_g( Variable* v );
	int P_PHT_MORTALITY_RT_u144_exe();
	friend int P_PHT_MORTALITY_RT_u144_exe_g( Variable* v );
	int P_PHT_NC_u145_exe();
	friend int P_PHT_NC_u145_exe_g( Variable* v );
	int P_PHT_N_SAT_u146_exe();
	friend int P_PHT_N_SAT_u146_exe_g( Variable* v );
	int P_PHT_OPT_T_u147_exe();
	friend int P_PHT_OPT_T_u147_exe_g( Variable* v );
	int P_PHT_P_SAT_u148_exe();
	friend int P_PHT_P_SAT_u148_exe_g( Variable* v );
	int P_PHT_RESP_RT_u149_exe();
	friend int P_PHT_RESP_RT_u149_exe_g( Variable* v );
	int P_PHY_PC_u150_exe();
	friend int P_PHY_PC_u150_exe_g( Variable* v );
	int CHL_CONC_u151_exe();
	friend int CHL_CONC_u151_exe_g( Variable* v );
	int CHL_CONV_FACTOR_u152_exe();
	friend int CHL_CONV_FACTOR_u152_exe_g( Variable* v );
	static PHYTOPLANKTON_module* fInstance;
	static PHYTOPLANKTON_module* kNullModel;
public:
	inline static PHYTOPLANKTON_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new PHYTOPLANKTON_module("PHYTOPLANKTON_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (PHYTOPLANKTON_module&) *fInstance;
	}

	virtual int InitVars();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int PHYTOPLANKTON_I127_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHYTOPLANKTON_I127_exe(); }
int PHYTOPLANKTON_i128_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHYTOPLANKTON_i128_exe(); }
int PHT_GROSS_PP_u129_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_GROSS_PP_u129_exe(); }
int PHT_RESP_u130_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_RESP_u130_exe(); }
int PHT_CONSUMED_u131_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_CONSUMED_u131_exe(); }
int PHT_MORTALITY_u132_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_MORTALITY_u132_exe(); }
int PHT_CONC_u133_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_CONC_u133_exe(); }
int PHT_LIGHT_LIM_u134_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_LIGHT_LIM_u134_exe(); }
int PHT_NET_PROD_u135_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_NET_PROD_u135_exe(); }
int PHT_NUT_LIMIT_u136_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_NUT_LIMIT_u136_exe(); }
int PHT_PROD_LIM_u137_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_PROD_LIM_u137_exe(); }
int PHT_TEMP_LIM_u138_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().PHT_TEMP_LIM_u138_exe(); }
int RIVER_PHT_u139_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().RIVER_PHT_u139_exe(); }
int P_IC_PHT_u140_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().P_IC_PHT_u140_exe(); }
int P_PHT_GROSS_PP_RT_u141_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().P_PHT_GROSS_PP_RT_u141_exe(); }
int P_PHT_MAX_T_u142_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().P_PHT_MAX_T_u142_exe(); }
int P_PHT_MIN_T_u143_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().P_PHT_MIN_T_u143_exe(); }
int P_PHT_MORTALITY_RT_u144_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().P_PHT_MORTALITY_RT_u144_exe(); }
int P_PHT_NC_u145_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().P_PHT_NC_u145_exe(); }
int P_PHT_N_SAT_u146_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().P_PHT_N_SAT_u146_exe(); }
int P_PHT_OPT_T_u147_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().P_PHT_OPT_T_u147_exe(); }
int P_PHT_P_SAT_u148_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().P_PHT_P_SAT_u148_exe(); }
int P_PHT_RESP_RT_u149_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().P_PHT_RESP_RT_u149_exe(); }
int P_PHY_PC_u150_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().P_PHY_PC_u150_exe(); }
int CHL_CONC_u151_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().CHL_CONC_u151_exe(); }
int CHL_CONV_FACTOR_u152_exe_g(Variable* obj) { return PHYTOPLANKTON_module::I().CHL_CONV_FACTOR_u152_exe(); }
// ---------------------------------------------------------------------------
//                    Class SEAWEED_module 
// ---------------------------------------------------------------------------

class SEAWEED_module : public TModule {
protected:

	SEAWEED_module(char* name);

public:

	TTime TIME;
	CStateVariable SEAWEEDS;
	CFluxVariable SW_MORT;
	CAuxVariable WATER_LAYER_DEPTH;
	CAuxVariable P_CELL_AREA;
	CAuxVariable P_IC_PHT;
	CAuxVariable SF_WATER;
	CAuxVariable CONS_INGEST_SW;
	CAuxVariable BOTTOM_MAP;
	CAuxVariable P_ON_MAP;
	CAuxVariable WATER_DEPTH;
	CAuxVariable LIGHT_TO_PHYTOPLANKTON;
	CAuxVariable DIN_CONC;
	CAuxVariable PO4_SF_WT_CONC;
	CAuxVariable OM3_TEMP;
	CFluxVariable SW_GROSS_PP;
	CFluxVariable SW_EXCHANGE;
	CFluxVariable SW_RESP;
	CFluxVariable SW_CONSUMED;
	CAuxVariable IC_SEAWEED;
	CAuxVariable OVERALL_FLOW_VELOCITY;
	CAuxVariable SW_CONC;
	CAuxVariable SW_LIGHT_LIM;
	CAuxVariable SW_NET_PROD;
	CAuxVariable SW_NUT_LIMIT;
	CAuxVariable SW_PROD_LIM;
	CAuxVariable SW_TEMP_LIM;
	CAuxVariable P_SW_MAX_T;
	CAuxVariable P_SW_MIN_T;
	CAuxVariable P_SW_MORT_RT;
	CAuxVariable P_SW_NC;
	CAuxVariable P_SW_N_SAT;
	CAuxVariable P_SW_OPT_T;
	CAuxVariable P_SW_PC;
	CAuxVariable P_SW_PP_RT;
	CAuxVariable P_SW_P_SAT;
	CAuxVariable P_SW_RESP_RT;
protected:

	int SEAWEEDS_I153_exe();
	friend int SEAWEEDS_I153_exe_g( Variable* v );
	int SEAWEEDS_i154_exe();
	friend int SEAWEEDS_i154_exe_g( Variable* v );
	int SW_GROSS_PP_u155_exe();
	friend int SW_GROSS_PP_u155_exe_g( Variable* v );
	int SW_EXCHANGE_u156_exe();
	friend int SW_EXCHANGE_u156_exe_g( Variable* v );
	int SW_RESP_u157_exe();
	friend int SW_RESP_u157_exe_g( Variable* v );
	int SW_CONSUMED_u158_exe();
	friend int SW_CONSUMED_u158_exe_g( Variable* v );
	int SW_MORT_u159_exe();
	friend int SW_MORT_u159_exe_g( Variable* v );
	int IC_SEAWEED_u160_exe();
	friend int IC_SEAWEED_u160_exe_g( Variable* v );
	int OVERALL_FLOW_VELOCITY_u161_exe();
	friend int OVERALL_FLOW_VELOCITY_u161_exe_g( Variable* v );
	int SW_CONC_u162_exe();
	friend int SW_CONC_u162_exe_g( Variable* v );
	int SW_LIGHT_LIM_u163_exe();
	friend int SW_LIGHT_LIM_u163_exe_g( Variable* v );
	int SW_NET_PROD_u164_exe();
	friend int SW_NET_PROD_u164_exe_g( Variable* v );
	int SW_NUT_LIMIT_u165_exe();
	friend int SW_NUT_LIMIT_u165_exe_g( Variable* v );
	int SW_PROD_LIM_u166_exe();
	friend int SW_PROD_LIM_u166_exe_g( Variable* v );
	int SW_TEMP_LIM_u167_exe();
	friend int SW_TEMP_LIM_u167_exe_g( Variable* v );
	int P_SW_MAX_T_u168_exe();
	friend int P_SW_MAX_T_u168_exe_g( Variable* v );
	int P_SW_MIN_T_u169_exe();
	friend int P_SW_MIN_T_u169_exe_g( Variable* v );
	int P_SW_MORT_RT_u170_exe();
	friend int P_SW_MORT_RT_u170_exe_g( Variable* v );
	int P_SW_NC_u171_exe();
	friend int P_SW_NC_u171_exe_g( Variable* v );
	int P_SW_N_SAT_u172_exe();
	friend int P_SW_N_SAT_u172_exe_g( Variable* v );
	int P_SW_OPT_T_u173_exe();
	friend int P_SW_OPT_T_u173_exe_g( Variable* v );
	int P_SW_PC_u174_exe();
	friend int P_SW_PC_u174_exe_g( Variable* v );
	int P_SW_PP_RT_u175_exe();
	friend int P_SW_PP_RT_u175_exe_g( Variable* v );
	int P_SW_P_SAT_u176_exe();
	friend int P_SW_P_SAT_u176_exe_g( Variable* v );
	int P_SW_RESP_RT_u177_exe();
	friend int P_SW_RESP_RT_u177_exe_g( Variable* v );
	static SEAWEED_module* fInstance;
	static SEAWEED_module* kNullModel;
public:
	inline static SEAWEED_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new SEAWEED_module("SEAWEED_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (SEAWEED_module&) *fInstance;
	}

	virtual int InitVars();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int SEAWEEDS_I153_exe_g(Variable* obj) { return SEAWEED_module::I().SEAWEEDS_I153_exe(); }
int SEAWEEDS_i154_exe_g(Variable* obj) { return SEAWEED_module::I().SEAWEEDS_i154_exe(); }
int SW_GROSS_PP_u155_exe_g(Variable* obj) { return SEAWEED_module::I().SW_GROSS_PP_u155_exe(); }
int SW_EXCHANGE_u156_exe_g(Variable* obj) { return SEAWEED_module::I().SW_EXCHANGE_u156_exe(); }
int SW_RESP_u157_exe_g(Variable* obj) { return SEAWEED_module::I().SW_RESP_u157_exe(); }
int SW_CONSUMED_u158_exe_g(Variable* obj) { return SEAWEED_module::I().SW_CONSUMED_u158_exe(); }
int SW_MORT_u159_exe_g(Variable* obj) { return SEAWEED_module::I().SW_MORT_u159_exe(); }
int IC_SEAWEED_u160_exe_g(Variable* obj) { return SEAWEED_module::I().IC_SEAWEED_u160_exe(); }
int OVERALL_FLOW_VELOCITY_u161_exe_g(Variable* obj) { return SEAWEED_module::I().OVERALL_FLOW_VELOCITY_u161_exe(); }
int SW_CONC_u162_exe_g(Variable* obj) { return SEAWEED_module::I().SW_CONC_u162_exe(); }
int SW_LIGHT_LIM_u163_exe_g(Variable* obj) { return SEAWEED_module::I().SW_LIGHT_LIM_u163_exe(); }
int SW_NET_PROD_u164_exe_g(Variable* obj) { return SEAWEED_module::I().SW_NET_PROD_u164_exe(); }
int SW_NUT_LIMIT_u165_exe_g(Variable* obj) { return SEAWEED_module::I().SW_NUT_LIMIT_u165_exe(); }
int SW_PROD_LIM_u166_exe_g(Variable* obj) { return SEAWEED_module::I().SW_PROD_LIM_u166_exe(); }
int SW_TEMP_LIM_u167_exe_g(Variable* obj) { return SEAWEED_module::I().SW_TEMP_LIM_u167_exe(); }
int P_SW_MAX_T_u168_exe_g(Variable* obj) { return SEAWEED_module::I().P_SW_MAX_T_u168_exe(); }
int P_SW_MIN_T_u169_exe_g(Variable* obj) { return SEAWEED_module::I().P_SW_MIN_T_u169_exe(); }
int P_SW_MORT_RT_u170_exe_g(Variable* obj) { return SEAWEED_module::I().P_SW_MORT_RT_u170_exe(); }
int P_SW_NC_u171_exe_g(Variable* obj) { return SEAWEED_module::I().P_SW_NC_u171_exe(); }
int P_SW_N_SAT_u172_exe_g(Variable* obj) { return SEAWEED_module::I().P_SW_N_SAT_u172_exe(); }
int P_SW_OPT_T_u173_exe_g(Variable* obj) { return SEAWEED_module::I().P_SW_OPT_T_u173_exe(); }
int P_SW_PC_u174_exe_g(Variable* obj) { return SEAWEED_module::I().P_SW_PC_u174_exe(); }
int P_SW_PP_RT_u175_exe_g(Variable* obj) { return SEAWEED_module::I().P_SW_PP_RT_u175_exe(); }
int P_SW_P_SAT_u176_exe_g(Variable* obj) { return SEAWEED_module::I().P_SW_P_SAT_u176_exe(); }
int P_SW_RESP_RT_u177_exe_g(Variable* obj) { return SEAWEED_module::I().P_SW_RESP_RT_u177_exe(); }
// ---------------------------------------------------------------------------
//                    Class TSS_module 
// ---------------------------------------------------------------------------

class TSS_module : public TModule {
protected:

	TSS_module(char* name);

public:

	TTime TIME;
	CAuxVariable TSS_CONC;
	CAuxVariable SF_WATER;
	CAuxVariable BOTTOM_MAP;
	CAuxVariable VEG_STRUCTURE;
	CAuxVariable OM3_SHEAR_STRESS;
	CStateVariable SUS_SED;
	CFluxVariable SED_SUSP;
	CFluxVariable SED_DEPO;
	CAuxVariable POT_EROS;
	CAuxVariable RIVER_TSS;
	CAuxVariable SHEAR_RES;
	CAuxVariable STRESS_EFFECT;
	CAuxVariable P_IC_TSS;
	CAuxVariable P_RESISTANCE_COEFF;
	CAuxVariable P_SETTLING_RT;
protected:

	int SUS_SED_I178_exe();
	friend int SUS_SED_I178_exe_g( Variable* v );
	int SUS_SED_i179_exe();
	friend int SUS_SED_i179_exe_g( Variable* v );
	int SED_SUSP_u180_exe();
	friend int SED_SUSP_u180_exe_g( Variable* v );
	int SED_DEPO_u181_exe();
	friend int SED_DEPO_u181_exe_g( Variable* v );
	int POT_EROS_u182_exe();
	friend int POT_EROS_u182_exe_g( Variable* v );
	int RIVER_TSS_u183_exe();
	friend int RIVER_TSS_u183_exe_g( Variable* v );
	int SHEAR_RES_u184_exe();
	friend int SHEAR_RES_u184_exe_g( Variable* v );
	int STRESS_EFFECT_u185_exe();
	friend int STRESS_EFFECT_u185_exe_g( Variable* v );
	int TSS_CONC_u186_exe();
	friend int TSS_CONC_u186_exe_g( Variable* v );
	int P_IC_TSS_u187_exe();
	friend int P_IC_TSS_u187_exe_g( Variable* v );
	int P_RESISTANCE_COEFF_u188_exe();
	friend int P_RESISTANCE_COEFF_u188_exe_g( Variable* v );
	int P_SETTLING_RT_u189_exe();
	friend int P_SETTLING_RT_u189_exe_g( Variable* v );
	static TSS_module* fInstance;
	static TSS_module* kNullModel;
public:
	inline static TSS_module& I() {
		if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
		else if(fInstance == NULL) {
			fInstance = kNullModel;
			fInstance = new TSS_module("TSS_module");
			Model::I0().ModuleList().Insert(*fInstance);
		}
		return (TSS_module&) *fInstance;
	}

	virtual int InitVars();
	int Initialize() { InitVars(); return 0; }
	int MakeConnections() { return 0;}
	int SetupEvents();
	int PostFirstUpdate();
	int PostFinalUpdate();
	int PostImport();
	int PostIntegrate();
	int PostInit() { return 0;}
};


int SUS_SED_I178_exe_g(Variable* obj) { return TSS_module::I().SUS_SED_I178_exe(); }
int SUS_SED_i179_exe_g(Variable* obj) { return TSS_module::I().SUS_SED_i179_exe(); }
int SED_SUSP_u180_exe_g(Variable* obj) { return TSS_module::I().SED_SUSP_u180_exe(); }
int SED_DEPO_u181_exe_g(Variable* obj) { return TSS_module::I().SED_DEPO_u181_exe(); }
int POT_EROS_u182_exe_g(Variable* obj) { return TSS_module::I().POT_EROS_u182_exe(); }
int RIVER_TSS_u183_exe_g(Variable* obj) { return TSS_module::I().RIVER_TSS_u183_exe(); }
int SHEAR_RES_u184_exe_g(Variable* obj) { return TSS_module::I().SHEAR_RES_u184_exe(); }
int STRESS_EFFECT_u185_exe_g(Variable* obj) { return TSS_module::I().STRESS_EFFECT_u185_exe(); }
int TSS_CONC_u186_exe_g(Variable* obj) { return TSS_module::I().TSS_CONC_u186_exe(); }
int P_IC_TSS_u187_exe_g(Variable* obj) { return TSS_module::I().P_IC_TSS_u187_exe(); }
int P_RESISTANCE_COEFF_u188_exe_g(Variable* obj) { return TSS_module::I().P_RESISTANCE_COEFF_u188_exe(); }
int P_SETTLING_RT_u189_exe_g(Variable* obj) { return TSS_module::I().P_SETTLING_RT_u189_exe(); }

#endif
