#ifndef _BitString_h
#define _BitString_h 1
#include "Environ.h"

/* A bitstring is an array of _BS_word. */
typedef unsigned long _BS_word;

#define _BS_CHAR_BIT 8
#define _BS_BITS_PER_WORD (_BS_CHAR_BIT*sizeof(_BS_word))
#define _BS_WORDS_NEEDED(NBITS) ((NBITS+_BS_BITS_PER_WORD-1)/_BS_BITS_PER_WORD)
#define BITSTRBITS  _BS_BITS_PER_WORD
#define _BS_BITMASK(BITNO) ((_BS_word)1 << (BITNO))

// primitive bit extraction

// These must be inlined regardless of optimization.

inline int BitStr_index(int l) { return (unsigned)(l) / BITSTRBITS; }
inline int BitStr_pos(int l) { return l & (BITSTRBITS - 1); }

class BitString {

  unsigned int     _length;        // length in bits
  _BS_word*        _data;          // bits start here

	void resize( int size ); 

public:

	BitString() { _data=NULL; _length=0; }

	void set(int p);
	void clear();
	
	inline int test(int i) const {
		return ( (unsigned)(i) >= _length ) ? 0 :  ((_data[BitStr_index(i)] & (1 << (BitStr_pos(i)))) != 0);
	}
		
};


#endif
