//----------------------------------------------------------------------------------------
//	UCStream.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------
  
#ifndef __UCStream__
#define __UCStream__
  
#include "Globals.h"
#include "Environ.h"

    
//========================================================================================
// 								class CStream 
//========================================================================================
  
class CStream  {

protected:

  FILE* fFile;
  CString* fData;
  int sindex;
     
public:
  CStream(const char* fileName, const char* ioMode);	
  CStream( CString* data );		       
  CStream();		       
  int Open(const char* path, const char* ioMode);
  virtual void Close();
	
  inline int get () { 
	if (fData) { return ( sindex == 0 ) ? -1 : (*fData)[--sindex]; } 
	else       { return fgetc(fFile); }
  }	
  inline int put (char c) { 
	if (fData) { (*fData)+=c; sindex++; return 1; } 
	else       { return fputc(c,fFile); }
  }
  inline int puts (const char* str) { 
	if(fData) { (*fData)+=str; sindex=fData->length(); return 1; } 
	else      { return fprintf(fFile,"%s",str); }
  }
  inline int unget (char c) { 
	if(fData)  { (*fData)(sindex++)=c; return 1; } 
	else       { return ungetc(c,fFile); }
  }
  	
  inline int peek () { int c = get(); ungetc(c,fFile); return c; }
	 
  inline FILE* Stream() { return fFile; }
  inline FILE* operator()() { return fFile; }
    
  int scanForward ( char tchar, int upto=0, int line_break=0) ;
  void processEnvVars(CString& str);
  int skipWhite ( char& nextChar );
                   
  CStream& operator>>( int& i );    
  CStream& operator<<( int i );    
  CStream& operator<<( unsigned long i );    

  CStream& operator>>( float& f );    
  CStream& operator<<( float f );    
  CStream& operator<<( double f );    

  CStream& operator>>( char* str );    
  CStream& operator<<( const char* str );    

  CStream& operator>>( char& c );    
  CStream& operator<<( char c );    
  CStream& operator<<( byte c ); 
  CStream& operator<<( CString& str );    
};

#endif


