#ifndef _TString_h
#define _TString_h 1

// #include <iostream.h>
#include "Utilities.h"
#include "TObjects.h"


#undef OK

typedef class TStrRep TStrRep;

class TStrRep                     // internal TString representations
{
	friend class TString;
	friend class TSubString;
	friend class CString;
	
  unsigned short    len;         // TString length 
  unsigned short    sz;          // allocated space
  char*              s;          // the TString starts here 
                                 // (at least 1 char for trailing null)
                                 // allocated & expanded via non-public fcts
public:
                                
	TStrRep( int size, char* str=(char*)NULL ) ;
	~TStrRep() { delete[] s; }
	void	clean_control_chars(); 
	
	static inline TStrRep* Snew(int newsiz) { return  new  TStrRep(newsiz); }
	static TStrRep*     Salloc(TStrRep*, const char*, int, int);
	static TStrRep*     Scopy(TStrRep*, const TStrRep*);
	static TStrRep*     Scat(TStrRep*, const char*, int, const char*, int);
	static TStrRep*     Scat(TStrRep*, const char*, int,const char*,int, const char*,int);
	static TStrRep*     Sprepend(TStrRep*, const char*, int);
	static TStrRep*     Sreverse(const TStrRep*, TStrRep*);
	static TStrRep*     Supcase(const TStrRep*, TStrRep*);
	static TStrRep*     Sdowncase(const TStrRep*, TStrRep*);
	static TStrRep*     Scapitalize(const TStrRep*, TStrRep*);
	static TStrRep*     Sinsert( TStrRep* old, const char* t, int tlen, int iloc );
	static TStrRep*     Sresize(TStrRep* old, int newlen);

};

// primitive ops on TTStrReps -- nearly all TString fns go through these.


// These classes need to be defined in the order given

class TString;
class TSubString;

class TSubString
{
  friend class      TString;
protected:

  TString&           S;        // The TString I'm a TSubString of
  unsigned short    pos;      // starting position in S's rep
  unsigned short    len;      // length of TSubString

  void              assign(const TStrRep*, const char*, int = -1);
                    TSubString(TString& x, int p, int l);
                    TSubString(const TSubString& x);

public:

// Note there are no public constructors. TSubStrings are always
// created via TString operations

                   ~TSubString();

  TSubString&        operator =  (const TString&     y);
  TSubString&        operator =  (const TSubString&  y);
  TSubString&        operator =  (const char* t);
  TSubString&        operator =  (char        c);

// return 1 if target appears anywhere in TSubString; else 0

  int               contains(char        c) const;
  int               contains(const TString&     y) const;
  int               contains(const TSubString&  y) const;
  int               contains(const char* t) const;

// status

  inline unsigned int      length() const;
  inline int               empty() const;
  inline const char*       chars() const ;

  int               OK() const; 

};


class TString : public TObject
{
  friend class      TSubString;

protected:
  TStrRep*           rep;   // TStrings are pointers to their representations

// some helper functions

  int               search(int, int, const char*, int = -1) const;
  int               search(int, int, char) const;
  int               match(int, int, int, const char*, int = -1) const;
  int               _gsub(const char*, int, const char* ,int);
  TSubString         _substr(int, int);

public:

// constructors & assignment

                    TString();
                    TString(const TString& x);
                    TString(const TSubString&  x);
                    TString(const char* t);
                    TString(const char* t, int len);
                    TString(char c);

                    ~TString();

  TString&           operator =  (const TString&     y);
  TString&           operator =  (const char* y);
  TString&           operator =  (char        c);
  TString&           operator =  (const TSubString&  y);
  
  TString&           set(const char* y);

// concatenation

  TString&           operator += (const TString&     y); 
  TString&           operator += (const TSubString&  y);
  TString&           operator += (const char* t);
  TString&           operator += (char        c);

  void              prepend(const TString&     y); 
  void              prepend(const TSubString&  y);
  void              prepend(const char* t);
  void              prepend(char        c);
  
  TString&          strip(const char* k);

  virtual VObject* dup() const;

// procedural versions:
// concatenate first 2 args, store result in last arg

  friend inline void     cat(const TString&, const TString&, TString&);
  friend inline void     cat(const TString&, const TSubString&, TString&);
  friend inline void     cat(const TString&, const char*, TString&);
  friend inline void     cat(const TString&, char, TString&);

  friend inline void     cat(const TSubString&, const TString&, TString&);
  friend inline void     cat(const TSubString&, const TSubString&, TString&);
  friend inline void     cat(const TSubString&, const char*, TString&);
  friend inline void     cat(const TSubString&, char, TString&);

  friend inline void     cat(const char*, const TString&, TString&);
  friend inline void     cat(const char*, const TSubString&, TString&);
  friend inline void     cat(const char*, const char*, TString&);
  friend inline void     cat(const char*, char, TString&);

// double concatenation, by request. (yes, there are too many versions, 
// but if one is supported, then the others should be too...)
// Concatenate first 3 args, store in last arg

  friend inline void     cat(const TString&,const TString&, const TString&,TString&);
  friend inline void     cat(const TString&,const TString&,const TSubString&,TString&);
  friend inline void     cat(const TString&,const TString&, const char*, TString&);
  friend inline void     cat(const TString&,const TString&, char, TString&);
  friend inline void     cat(const TString&,const TSubString&,const TString&,TString&);
  inline friend void     cat(const TString&,const TSubString&,const TSubString&,TString&);
  friend inline void     cat(const TString&,const TSubString&, const char*, TString&);
  friend inline void     cat(const TString&,const TSubString&, char, TString&);
  friend inline void     cat(const TString&,const char*, const TString&,    TString&);
  friend inline void     cat(const TString&,const char*, const TSubString&, TString&);
  friend inline void     cat(const TString&,const char*, const char*, TString&);
  friend inline void     cat(const TString&,const char*, char, TString&);

  friend inline void     cat(const char*, const TString&, const TString&,TString&);
  friend inline void     cat(const char*,const TString&,const TSubString&,TString&);
  friend inline void     cat(const char*,const TString&, const char*, TString&);
  friend inline void     cat(const char*,const TString&, char, TString&);
  friend inline void     cat(const char*,const TSubString&,const TString&,TString&);
  friend inline void     cat(const char*,const TSubString&,const TSubString&,TString&);
  friend inline void     cat(const char*,const TSubString&, const char*, TString&);
  friend inline void     cat(const char*,const TSubString&, char, TString&);
  friend inline void     cat(const char*,const char*, const TString&,    TString&);
  friend inline void     cat(const char*,const char*, const TSubString&, TString&);
  friend inline void     cat(const char*,const char*, const char*, TString&);
  friend inline void     cat(const char*,const char*, char, TString&);


// searching & matching

	int searchLine(int& start, int sl, char c, char end_char=0 ) const;

// return position of target in TString or -1 for failure

  int               index(char        c, int startpos = 0) const;      
  int               index(const TString&     y, int startpos = 0) const;      
  int               index(const TSubString&  y, int startpos = 0) const;      
  int               index(const char* t, int startpos = 0) const; 
  inline int        find(const char* t, int startpos = 0) const { return index(t,startpos); }
  inline int        find(char        c, int startpos = 0) const { return index(c,startpos); }
  
	virtual Bool equals( const VObject& b ) const { return (strcmp(chars(),((TString&)b).chars()) == 0); }
	virtual Bool equals( const char* s ) const { return (strcmp(chars(),s) == 0); }
	virtual Bool equals_nocase( const TString& b ) const { 
	  TString s0(*this), s1(b); s0.upcase(); s1.upcase();
	  return (strcmp(s0.chars(),s1.chars()) == 0); 
	}
 
	inline void	clean_control_chars() { rep->clean_control_chars(); }

// return 1 if target appears anyhere in TString; else 0

  int               contains(char        c) const;
  int               contains(const TString&     y) const;
  int               contains(const TSubString&  y) const;
  int               contains(const char* t) const;

// return 1 if target appears anywhere after position pos 
// (or before, if pos is negative) in TString; else 0

  int               contains(char        c, int pos) const;
  int               contains(const TString&     y, int pos) const;
  int               contains(const TSubString&  y, int pos) const;
  int               contains(const char* t, int pos) const;

// return 1 if target appears at position pos in TString; else 0

  int               matches(char        c, int pos = 0) const;
  int               matches(const TString&     y, int pos = 0) const;
  int               matches(const TSubString&  y, int pos = 0) const;
  int               matches(const char* t, int pos = 0) const;

//  return number of occurences of target in TString

  int               freq(char        c) const; 
  int               freq(const TString&     y) const;
  int               freq(const TSubString&  y) const;
  int               freq(const char* t) const;

  int               starts_with( const char* t, int tl = -1 ) const;
  
// TSubString extraction

// Note that you can't take a TSubString of a const TString, since
// this leaves open the possiblility of indirectly modifying the
// TString through the TSubString

  TSubString         at(int         pos, int len);
  TSubString         operator () (int         pos, int len); // synonym for at
  
  inline TSubString left(int count) { return  before( count ); }
  inline TSubString mid(int ifrom, int count = -1) { return  at( ifrom, count ); }
  inline TSubString sub(int ifrom, int to = -1)  { return  ( to < 0 ) ? from(ifrom) : at( ifrom, to-ifrom ); }
  inline TSubString right(int count) { return  after( count ); }   

  TSubString         at(const TString&     x, int startpos = 0); 
  TSubString         at(const TSubString&  x, int startpos = 0);  
  TSubString         at(const char* t, int startpos = 0); 
  TSubString         at(char        c, int startpos = 0); 

  TSubString         before(int          pos); 
  TSubString         before(const TString&      x, int startpos = 0); 
  TSubString         before(const TSubString&   x, int startpos = 0); 
  TSubString         before(const char*  t, int startpos = 0); 
  TSubString         before(char         c, int startpos = 0); 

  TSubString         through(int          pos); 
  TSubString         through(const TString&      x, int startpos = 0); 
  TSubString         through(const TSubString&   x, int startpos = 0); 
  TSubString         through(const char*  t, int startpos = 0); 
  TSubString         through(char         c, int startpos = 0); 

  TSubString         from(int          pos); 
  TSubString         from(const TString&      x, int startpos = 0); 
  TSubString         from(const TSubString&   x, int startpos = 0); 
  TSubString         from(const char*  t, int startpos = 0); 
  TSubString         from(char         c, int startpos = 0); 

  TSubString         after(int         pos); 
  TSubString         after(const TString&     x, int startpos = 0); 
  TSubString         after(const TSubString&  x, int startpos = 0); 
  TSubString         after(const char* t, int startpos = 0); 
  TSubString         after(char        c, int startpos = 0); 

	TSubString getTSubString(char c, int& startpos, char endChar=0);  // gets TSubString from startpos to next occurrence of char c

// deletion

// delete len chars from end of string
 void 							truncate( int len );
 
// delete len chars starting at pos
  void              del(int         pos, int len);

// delete the first occurrence of target after startpos

  void              del(const TString&     y, int startpos = 0);
  void              del(const TSubString&  y, int startpos = 0);
  void              del(const char* t, int startpos = 0);
  void              del(char        c, int startpos = 0);

// global substitution: substitute all occurrences of pat with repl

  int               gsub(const TString&     pat, const TString&     repl);
  int               gsub(const TSubString&  pat, const TString&     repl);
  int               gsub(const char* pat, const TString&     repl);
  int               gsub(const char* pat, const char* repl);

// friends & utilities

// split TString into array res at separators; return number of elements

  friend int        split(const TString& x, TString res[], int maxn, 
                          const TString& sep);

  friend void     common_prefix(TString& ret, const TString& x, const TString& y, 
                                  int startpos = 0);
  friend void     common_suffix(TString& ret, const TString& x, const TString& y, 
                                  int startpos = -1);
  friend void     replicate(TString& ret, char        c, int n);
  friend void     replicate(TString& ret, const TString&     y, int n);
  friend void     join(TString& ret, TString src[], int n, const TString& sep);
  inline void cut(int len) { truncate( len ); }

// simple builtin transformations

  friend inline TString     reverse(const TString& x);
  friend inline TString     upcase(const TString& x);
  friend inline TString     downcase(const TString& x);
  friend inline TString     capitalize(const TString& x);

// in-place versions of above

  void              reverse();
  void              upcase();
  void              downcase();
  void              capitalize();

// element extraction

//  char&             operator [] (int i);
  const char&       operator [] (int i) const;
  char              elem(int i) const;
  char              firstchar() const;
  char              lastchar() const;

// conversion

                    operator const char*() const;
  inline const char*       chars() const;
  inline char*             data();
	inline char*      operator () (int i) const { return &(rep->s[i]); }


// status

  inline unsigned int      length() const;
  inline int               empty() const;

// preallocate some space for TString
  void              alloc(int newsize);

// report current allocation (not length!)

  inline int               allocation() const;


  void     error(const char* msg) const;

  int               OK() const;
};

typedef TString StrTmp; // for backward compatibility

// other externs

int        compare(const TString&    x, const TString&     y);
int        compare(const TString&    x, const TSubString&  y);
int        compare(const TString&    x, const char* y);
int        compare(const TSubString& x, const TString&     y);
int        compare(const TSubString& x, const TSubString&  y);
int        compare(const TSubString& x, const char* y);
int        fcompare(const TString&   x, const TString&     y); // ignore case

extern TStrRep  _nilTStrRep;
extern TString _nilTString;

// status reports, needed before defining other things

unsigned int TString::length() const {  return (rep==NULL) ? 0 : rep->len; }
int         TString::empty() const { return (rep==NULL) ? 1 : rep->len == 0; }
const char* TString::chars() const { return (rep==NULL) ? NULL : &(rep->s[0]); }
char*        TString::data() { return (rep==NULL) ? NULL : &(rep->s[0]); }
int         TString::allocation() const { return (rep==NULL) ? 0 : rep->sz; }

unsigned int TSubString::length() const { return len; }
int         TSubString::empty() const { return len == 0; }
const char* TSubString::chars() const { return &(S.rep->s[pos]); }


// constructors

inline TString::TString() 
  : rep(&_nilTStrRep) {}
inline TString::TString(const TString& x) 
  : rep( TStrRep::Scopy(0, x.rep)) {}
inline TString::TString(const char* t) 
  : rep( TStrRep::Salloc(0, t, -1, -1)) {}
inline TString::TString(const char* t, int tlen)
  : rep( TStrRep::Salloc(0, t, tlen, tlen)) {}
inline TString::TString(const TSubString& y)
  : rep( TStrRep::Salloc(0, y.chars(), y.length(), y.length())) {}
inline TString::TString(char c) 
  : rep( TStrRep::Salloc(0, &c, 1, 1)) {}

inline TString::~TString() { if (rep != &_nilTStrRep) delete rep; }

inline TSubString::TSubString(const TSubString& x)
  :S(x.S), pos(x.pos), len(x.len) {}
inline TSubString::TSubString(TString& x, int first, int l)
  :S(x), pos(first), len(l) {}

inline TSubString::~TSubString() {}

// assignment

inline TString& TString::operator =  (const TString& y)
{ 
  rep =  TStrRep::Scopy(rep, y.rep);
  return *this;
}

inline TString& TString::operator=(const char* t)
{
  rep =  TStrRep::Salloc(rep, t, -1, -1);
  return *this;
}

inline TString& TString::set(const char* t) {
  rep =  TStrRep::Salloc(rep, t, -1, -1);
  return *this;
}

inline TString& TString::operator=(const TSubString&  y)
{
  rep =  TStrRep::Salloc(rep, y.chars(), y.length(), y.length());
  return *this;
}

inline TString& TString::operator=(char c)
{
  rep =  TStrRep::Salloc(rep, &c, 1, 1);
  return *this;
}


inline TSubString& TSubString::operator = (const char* ys)
{
  assign(0, ys);
  return *this;
}

inline TSubString& TSubString::operator = (char ch)
{
  assign(0, &ch, 1);
  return *this;
}

inline TSubString& TSubString::operator = (const TString& y)
{
  assign(y.rep, y.chars(), y.length());
  return *this;
}

inline TSubString& TSubString::operator = (const TSubString& y)
{
  assign(y.S.rep, y.chars(), y.length());
  return *this;
}

// Zillions of cats...

inline void cat(const TString& x, const TString& y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, x.chars(), x.length(), y.chars(), y.length());
}

inline void cat(const TString& x, const TSubString& y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, x.chars(), x.length(), y.chars(), y.length());
}

inline void cat(const TString& x, const char* y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, x.chars(), x.length(), y, -1);
}

inline void cat(const TString& x, char y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, x.chars(), x.length(), &y, 1);
}

inline void cat(const TSubString& x, const TString& y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, x.chars(), x.length(), y.chars(), y.length());
}

inline void cat(const TSubString& x, const TSubString& y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, x.chars(), x.length(), y.chars(), y.length());
}

inline void cat(const TSubString& x, const char* y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, x.chars(), x.length(), y, -1);
}

inline void cat(const TSubString& x, char y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, x.chars(), x.length(), &y, 1);
}

inline void cat(const char* x, const TString& y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, x, -1, y.chars(), y.length());
}

inline void cat(const char* x, const TSubString& y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, x, -1, y.chars(), y.length());
}

inline void cat(const char* x, const char* y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, x, -1, y, -1);
}

inline void cat(const char* x, char y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, x, -1, &y, 1);
}

inline void cat(const TString& a, const TString& x, const TString& y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, a.chars(), a.length(), x.chars(), x.length(), y.chars(), y.length());
}

inline void cat(const TString& a, const TString& x, const TSubString& y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, a.chars(), a.length(), x.chars(), x.length(), y.chars(), y.length());
}

inline void cat(const TString& a, const TString& x, const char* y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, a.chars(), a.length(), x.chars(), x.length(), y, -1);
}

inline void cat(const TString& a, const TString& x, char y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, a.chars(), a.length(), x.chars(), x.length(), &y, 1);
}

inline void cat(const TString& a, const TSubString& x, const TString& y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, a.chars(), a.length(), x.chars(), x.length(), y.chars(), y.length());
}

inline void cat(const TString& a, const TSubString& x, const TSubString& y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, a.chars(), a.length(), x.chars(), x.length(), y.chars(), y.length());
}

inline void cat(const TString& a, const TSubString& x, const char* y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, a.chars(), a.length(), x.chars(), x.length(), y, -1);
}

inline void cat(const TString& a, const TSubString& x, char y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, a.chars(), a.length(), x.chars(), x.length(), &y, 1);
}

inline void cat(const TString& a, const char* x, const TString& y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, a.chars(), a.length(), x, -1, y.chars(), y.length());
}

inline void cat(const TString& a, const char* x, const TSubString& y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, a.chars(), a.length(), x, -1, y.chars(), y.length());
}

inline void cat(const TString& a, const char* x, const char* y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, a.chars(), a.length(), x, -1, y, -1);
}

inline void cat(const TString& a, const char* x, char y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, a.chars(), a.length(), x, -1, &y, 1);
}


inline void cat(const char* a, const TString& x, const TString& y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, a, -1, x.chars(), x.length(), y.chars(), y.length());
}

inline void cat(const char* a, const TString& x, const TSubString& y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, a, -1, x.chars(), x.length(), y.chars(), y.length());
}

inline void cat(const char* a, const TString& x, const char* y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, a, -1, x.chars(), x.length(), y, -1);
}

inline void cat(const char* a, const TString& x, char y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, a, -1, x.chars(), x.length(), &y, 1);
}

inline void cat(const char* a, const TSubString& x, const TString& y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, a, -1, x.chars(), x.length(), y.chars(), y.length());
}

inline void cat(const char* a, const TSubString& x, const TSubString& y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, a, -1, x.chars(), x.length(), y.chars(), y.length());
}

inline void cat(const char* a, const TSubString& x, const char* y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, a, -1, x.chars(), x.length(), y, -1);
}

inline void cat(const char* a, const TSubString& x, char y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, a, -1, x.chars(), x.length(), &y, 1);
}

inline void cat(const char* a, const char* x, const TString& y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, a, -1, x, -1, y.chars(), y.length());
}

inline void cat(const char* a, const char* x, const TSubString& y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, a, -1, x, -1, y.chars(), y.length());
}

inline void cat(const char* a, const char* x, const char* y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, a, -1, x, -1, y, -1);
}

inline void cat(const char* a, const char* x, char y, TString& r)
{
  r.rep =  TStrRep::Scat(r.rep, a, -1, x, -1, &y, 1);
}


// operator versions

inline TString& TString::operator +=(const TString& y)
{
  cat(*this, y, *this);
  return *this;
}

inline TString& TString::operator +=(const TSubString& y)
{
  cat(*this, y, *this);
  return *this;
}

inline TString& TString::operator += (const char* y)
{
  cat(*this, y, *this);
  return *this;
}

inline TString& TString:: operator +=(char y)
{
  cat(*this, y, *this);
  return *this;
}

// constructive concatenation

#if defined(__GNUG__) && !defined(_G_NO_NRV)

inline TString operator + (const TString& x, const TString& y) return r;
{
  cat(x, y, r);
}

inline TString operator + (const TString& x, const TSubString& y) return r;
{
  cat(x, y, r);
}

inline TString operator + (const TString& x, const char* y) return r;
{
  cat(x, y, r);
}

inline TString operator + (const TString& x, char y) return r;
{
  cat(x, y, r);
}

inline TString operator + (const TSubString& x, const TString& y) return r;
{
  cat(x, y, r);
}

inline TString operator + (const TSubString& x, const TSubString& y) return r;
{
  cat(x, y, r);
}

inline TString operator + (const TSubString& x, const char* y) return r;
{
  cat(x, y, r);
}

inline TString operator + (const TSubString& x, char y) return r;
{
  cat(x, y, r);
}

inline TString operator + (const char* x, const TString& y) return r;
{
  cat(x, y, r);
}

inline TString operator + (const char* x, const TSubString& y) return r;
{
  cat(x, y, r);
}

inline TString reverse(const TString& x) return r;
{
  r.rep = TStrRep::Sreverse(x.rep, r.rep);
}

inline TString upcase(const TString& x) return r;
{
  r.rep = TStrRep::Supcase(x.rep, r.rep);
}

inline TString downcase(const TString& x) return r;
{
  r.rep = TStrRep::Sdowncase(x.rep, r.rep);
}

inline TString capitalize(const TString& x) return r;
{
  r.rep = TStrRep::Scapitalize(x.rep, r.rep);
}

#else /* NO_NRV */

inline TString operator + (const TString& x, const TString& y)
{
  TString r;  cat(x, y, r);  return r;
}

inline TString operator + (const TString& x, const TSubString& y) 
{
  TString r; cat(x, y, r); return r;
}

inline TString operator + (const TString& x, const char* y) 
{
  TString r; cat(x, y, r); return r;
}

inline TString operator + (const TString& x, char y) 
{
  TString r; cat(x, y, r); return r;
}

inline TString operator + (const TSubString& x, const TString& y) 
{
  TString r; cat(x, y, r); return r;
}

inline TString operator + (const TSubString& x, const TSubString& y) 
{
  TString r; cat(x, y, r); return r;
}

inline TString operator + (const TSubString& x, const char* y) 
{
  TString r; cat(x, y, r); return r;
}

inline TString operator + (const TSubString& x, char y) 
{
  TString r; cat(x, y, r); return r;
}

inline TString operator + (const char* x, const TString& y) 
{
  TString r; cat(x, y, r); return r;
}

inline TString operator + (const char* x, const TSubString& y) 
{
  TString r; cat(x, y, r); return r;
}

inline TString reverse(const TString& x) 
{
  TString r; r.rep =  TStrRep::Sreverse(x.rep, r.rep); return r;
}

inline TString upcase(const TString& x) 
{
  TString r; r.rep =  TStrRep::Supcase(x.rep, r.rep); return r;
}

inline TString downcase(const TString& x) 
{
  TString r; r.rep =  TStrRep::Sdowncase(x.rep, r.rep); return r;
}

inline TString capitalize(const TString& x) 
{
  TString r; r.rep =  TStrRep::Scapitalize(x.rep, r.rep); return r;
}

#endif

// prepend

inline void TString::prepend(const TString& y)
{
  rep =  TStrRep::Sprepend(rep, y.chars(), y.length());
}

inline void TString::prepend(const char* y)
{
  rep =  TStrRep::Sprepend(rep, y, -1); 
}

inline void TString::prepend(char y)
{
  rep =  TStrRep::Sprepend(rep, &y, 1); 
}

inline void TString::prepend(const TSubString& y)
{
  rep =  TStrRep::Sprepend(rep, y.chars(), y.length());
}

// misc transformations


inline void TString::reverse()
{
  rep =  TStrRep::Sreverse(rep, rep);
}


inline void TString::upcase()
{
  rep =  TStrRep::Supcase(rep, rep);
}


inline void TString::downcase()
{
  rep =  TStrRep::Sdowncase(rep, rep);
}


inline void TString::capitalize()
{
  rep =  TStrRep::Scapitalize(rep, rep);
}

// element extraction
/*
inline char&  TString::operator [] (int i) 
{ 
  if (((unsigned)i) >= length()) error("invalid index");
  return rep->s[i];
}
*/
inline const char&  TString::operator [] (int i) const
{ 
  if (((unsigned)i) >= length()) error("invalid index");
  return rep->s[i];
}

inline char  TString::elem (int i) const
{ 
  if (((unsigned)i) >= length()) error("invalid index");
  return rep->s[i];
}

inline char  TString::firstchar() const
{ 
  return elem(0);
}

inline char  TString::lastchar() const
{ 
  return elem(length() - 1);
}

// searching

inline int TString::index(char c, int startpos) const
{
  return search(startpos, length(), c);
}

inline int TString::index(const char* t, int startpos) const
{   
  return search(startpos, length(), t);
}

inline int TString::index(const TString& y, int startpos) const
{   
  return search(startpos, length(), y.chars(), y.length());
}

inline int TString::index(const TSubString& y, int startpos) const
{   
  return search(startpos, length(), y.chars(), y.length());
}

inline int TString::contains(char c) const
{
  return search(0, length(), c) >= 0;
}

inline int TString::contains(const char* t) const
{   
  return search(0, length(), t) >= 0;
}

inline int TString::contains(const TString& y) const
{   
  return search(0, length(), y.chars(), y.length()) >= 0;
}

inline int TString::contains(const TSubString& y) const
{   
  return search(0, length(), y.chars(), y.length()) >= 0;
}

inline int TString::contains(char c, int p) const
{
  return match(p, length(), 0, &c, 1) >= 0;
}

inline int TString::contains(const char* t, int p) const
{
  return match(p, length(), 0, t) >= 0;
}

inline int TString::contains(const TString& y, int p) const
{
  return match(p, length(), 0, y.chars(), y.length()) >= 0;
}

inline int TString::contains(const TSubString& y, int p) const
{
  return match(p, length(), 0, y.chars(), y.length()) >= 0;
}

inline int TString::matches(const TSubString& y, int p) const
{
  return match(p, length(), 1, y.chars(), y.length()) >= 0;
}

inline int TString::matches(const TString& y, int p) const
{
  return match(p, length(), 1, y.chars(), y.length()) >= 0;
}

inline int TString::matches(const char* t, int p) const
{
  return match(p, length(), 1, t) >= 0;
}

inline int TString::matches(char c, int p) const
{
  return match(p, length(), 1, &c, 1) >= 0;
}

inline int TSubString::contains(const char* t) const
{   
  return S.search(pos, pos+len, t) >= 0;
}

inline int TSubString::contains(const TString& y) const
{   
  return S.search(pos, pos+len, y.chars(), y.length()) >= 0;
}

inline int TSubString::contains(const TSubString&  y) const
{   
  return S.search(pos, pos+len, y.chars(), y.length()) >= 0;
}

inline int TSubString::contains(char c) const
{
  return S.search(pos, pos+len, c) >= 0;
}

inline int TString::gsub(const TString& pat, const TString& r)
{
  return _gsub(pat.chars(), pat.length(), r.chars(), r.length());
}

inline int TString::gsub(const TSubString&  pat, const TString& r)
{
  return _gsub(pat.chars(), pat.length(), r.chars(), r.length());
}

inline int TString::gsub(const char* pat, const TString& r)
{
  return _gsub(pat, -1, r.chars(), r.length());
}

inline int TString::gsub(const char* pat, const char* r)
{
  return _gsub(pat, -1, r, -1);
}

// a zillion comparison operators

inline int operator==(const TString& x, const TString& y) 
{
  return compare(x, y) == 0; 
}

inline int operator!=(const TString& x, const TString& y)
{
  return compare(x, y) != 0; 
}

inline int operator>(const TString& x, const TString& y)
{
  return compare(x, y) > 0; 
}

inline int operator>=(const TString& x, const TString& y)
{
  return compare(x, y) >= 0; 
}

inline int operator<(const TString& x, const TString& y)
{
  return compare(x, y) < 0; 
}

inline int operator<=(const TString& x, const TString& y)
{
  return compare(x, y) <= 0; 
}

inline int operator==(const TString& x, const TSubString&  y) 
{
  return compare(x, y) == 0; 
}

inline int operator!=(const TString& x, const TSubString&  y)
{
  return compare(x, y) != 0; 
}

inline int operator>(const TString& x, const TSubString&  y)      
{
  return compare(x, y) > 0; 
}

inline int operator>=(const TString& x, const TSubString&  y)
{
  return compare(x, y) >= 0; 
}

inline int operator<(const TString& x, const TSubString&  y) 
{
  return compare(x, y) < 0; 
}

inline int operator<=(const TString& x, const TSubString&  y)
{
  return compare(x, y) <= 0; 
}

inline int operator==(const TString& x, const char* t) 
{
  return compare(x, t) == 0; 
}

inline int operator!=(const TString& x, const char* t) 
{
  return compare(x, t) != 0; 
}

inline int operator>(const TString& x, const char* t)  
{
  return compare(x, t) > 0; 
}

inline int operator>=(const TString& x, const char* t) 
{
  return compare(x, t) >= 0; 
}

inline int operator<(const TString& x, const char* t)  
{
  return compare(x, t) < 0; 
}

inline int operator<=(const TString& x, const char* t) 
{
  return compare(x, t) <= 0; 
}

inline int operator==(const TSubString& x, const TString& y) 
{
  return compare(y, x) == 0; 
}

inline int operator!=(const TSubString& x, const TString& y)
{
  return compare(y, x) != 0;
}

inline int operator>(const TSubString& x, const TString& y)      
{
  return compare(y, x) < 0;
}

inline int operator>=(const TSubString& x, const TString& y)     
{
  return compare(y, x) <= 0;
}

inline int operator<(const TSubString& x, const TString& y)      
{
  return compare(y, x) > 0;
}

inline int operator<=(const TSubString& x, const TString& y)     
{
  return compare(y, x) >= 0;
}

inline int operator==(const TSubString& x, const TSubString&  y) 
{
  return compare(x, y) == 0; 
}

inline int operator!=(const TSubString& x, const TSubString&  y)
{
  return compare(x, y) != 0;
}

inline int operator>(const TSubString& x, const TSubString&  y)      
{
  return compare(x, y) > 0;
}

inline int operator>=(const TSubString& x, const TSubString&  y)
{
  return compare(x, y) >= 0;
}

inline int operator<(const TSubString& x, const TSubString&  y) 
{
  return compare(x, y) < 0;
}

inline int operator<=(const TSubString& x, const TSubString&  y)
{
  return compare(x, y) <= 0;
}

inline int operator==(const TSubString& x, const char* t) 
{
  return compare(x, t) == 0; 
}

inline int operator!=(const TSubString& x, const char* t) 
{
  return compare(x, t) != 0;
}

inline int operator>(const TSubString& x, const char* t)  
{
  return compare(x, t) > 0; 
}

inline int operator>=(const TSubString& x, const char* t) 
{
  return compare(x, t) >= 0; 
}

inline int operator<(const TSubString& x, const char* t)  
{
  return compare(x, t) < 0; 
}

inline int operator<=(const TSubString& x, const char* t) 
{
  return compare(x, t) <= 0; 
}


// a helper needed by at, before, etc.

inline TSubString TString::_substr(int first, int l)
{
  if (first < 0 || (unsigned)(first + l) > length() )
    return TSubString(_nilTString, 0, 0) ;
  else 
    return TSubString(*this, first, l);
}

static const int kCStringBuff = 20;

class CString : public TString {

  void ReAlloc( int len );
  int scan_relcode(int ioff1) const;

public:

  CString() : TString() {;}
  CString( const char* s ) : TString(s) {;}
  CString( const TString& s ) : TString(s) {;}
  CString( const TSubString& s ) : TString(s) {;}
  CString( const char* s, int l ) : TString(s,l) {;}
  CString( char c ) : TString(c) {;}

//  operator char*() { return rep->s; }
  operator const char*() const { return rep->s; }

  inline char  operator [] (int i) const { return (((unsigned)i) < rep->len ) ? rep->s[i] : 0; }

  inline char&  operator () (int i) { 
    if (((unsigned)i) >= rep->sz || rep == &_nilTStrRep  ) ReAlloc(i + kCStringBuff);
    if (((unsigned)i) >= rep->len ) { rep->len = i+1; rep->s[i+1] = 0; }
    return rep->s[i];
  }
	inline void allocate(int size) {
   if (((unsigned)size) >= rep->sz || rep == &_nilTStrRep  ) ReAlloc(size);
	}
	void resize();
			
  inline void clear() { rep->len=0; memset(rep->s,0,rep->sz); }

  int size() const;
/*  
  inline operator > ( TString& s ) {
    return ( compare(*this,s) > 0 );
  }
  inline operator >= ( TString& s ) {
    return ( compare(*this,s) >= 0 );
  }
  inline operator < ( TString& s ) {
    return ( compare(*this,s) < 0 );
  }
  inline operator <= ( TString& s ) {
    return ( compare(*this,s) <= 0 );
  }
*/
  inline CString& appendIndex( long int i, int width=0 ) { 
		char s[50]; 
		switch(width) {
			case 0: sprintf(s,"%li",i); break;
			case 1: sprintf(s,"%01li",i); break;
			case 2: sprintf(s,"%02li",i); break;
			case 3: sprintf(s,"%03li",i); break;
			case 4: sprintf(s,"%04li",i); break;
			default: sprintf(s,"%05li",i); break;
		}
		return (CString&) TString::operator+=(s); 
	}
  inline CString& operator+=( const char* cs ) { return (CString&) TString::operator+=(cs); }
  inline CString& operator+=( float f ) { char s[50]; sprintf(s,"%f",f); return (CString&) TString::operator+=(s); }
  inline CString& operator+=( double f ) { char s[50]; sprintf(s,"%.3e",f); return (CString&) TString::operator+=(s); }
  inline CString& operator+=( byte b ) { char s[10]; sprintf(s,"%d",b); return (CString&) TString::operator+=(s); }
  inline CString& operator+=( char ch ) { return (CString&) TString::operator+=(ch); }
  inline CString& operator=( float f ) { char s[50]; sprintf(s,"%f",f); return (CString&) TString::operator=(s); }
  inline CString& operator=( long int i ) { char s[50]; sprintf(s,"%li",i); return (CString&) TString::operator=(s); }
  inline CString& operator=( char ch ) { return (CString&) TString::operator=(ch); }
	inline CString& operator =  ( const CString& y ) {  rep = TStrRep::Scopy(rep, y.rep); return *this; }
	inline CString& operator =  ( const TString& y ) {  return (CString&) TString::operator=( y );  }
	inline CString& operator =  ( const char* s ) {  rep->len=0; cat(*this, s, *this); return *this; }
	inline CString& operator =  ( const TSubString&  y ) {  return  (CString&) TString::operator=( y );  }
	inline CString& operator +=  ( const TSubString&  y ) {  return  (CString&) TString::operator+=( y );  }

  CString& trim( char schar=0, char echar=0 );
  int containsName( const char* name, int start = 0, Bool checkBeg=True, Bool CheckEnd=True ) const;
  virtual VObject* dup() const;
	
  inline void insert(const TString& y, int iloc){
    rep = TStrRep::Sinsert(rep, y.chars(), y.length(), iloc );
  }

	inline int readLine( FILE* fp ) {
		clear();
		int ch;
		while( (ch = fgetc(fp)) != EOF ) {
			if( ch == '\n' ) { TString::operator+=('\0'); return 1;}
			else { TString::operator+=(ch); }
		}
		return 0;
	}
	 
  inline void insert(const char* y, int iloc) {
    rep = TStrRep::Sinsert(rep, y, -1, iloc ); 
  }

  
  inline void insert(char y, int iloc) {
    rep = TStrRep::Sinsert(rep, &y, 1, iloc ); 
  }
  
  inline void insert(const TSubString& y, int iloc) {
    rep = TStrRep::Sinsert(rep, y.chars(), y.length(), iloc );
  }

  int replaceName( CString& name, CString& repl, Bool checkBeg=True, Bool CheckEnd=True  );

	int ProcSend( int from_proc, int to_proc );
	int splitColumns( CString res[], int nres );
};

inline CString operator+( CString& s, const char* cs ) { return (CString) ( (TString&)s + cs ); }

inline CString operator+( const CString& s, const char* cs ) { 
  CString cstr = (CString) ( (TString&)s + cs );
  return cstr; }

static const CString gNullString = "";

class TFilename : public CString
{
public:
  // @FPUB

  TFilename(const char* n = "") : CString(n) {}
  TFilename(const TString& n) : CString(n) {}

  const CString& operator =(const char* s) { return (const CString&) set(s); }
  const CString& operator =(const CString& s) { return (const CString&) set((const char*)s); }
  // assegnazione tra TFile e stringa

  const char* ext() const;      // Ritorna l'estensione
  void ext(const char*);        // Imposta come estensione la stringa puntata da char*

  const char* name() const;     // Ritorna il nome del file
  const char* path() const;     // Ritorna il nome del direttorio
//  const TFilename& temp(const char* prefix = NULL);     // Genera il nome di un file temporaneo
//  const TFilename& tempdir();   // Genera il nome della directory temporanea
};

// @C
// Classe TToken_string : public TString
// @END

class TToken_string : public CString
{
  // @DPRIV
  char _separator;      // Carattere separatore
  char _sep2;           // Eventuale separatore finale (es. {})
  int _last;            // Puntatore all'ultimo

protected:
  // @FPROT

  virtual TObject* dup() const; // Crea un duplicato della token string
  bool set_item(const char* v, int n);
  
public:
  // @FPUB
  TToken_string(const char* = "", char separator = '|');
  TToken_string(int n, char separator = '|');
  TToken_string(const TToken_string& s);

  // creates a tokenstring out of s replacing all consecutive occurrences
  // of chars in sep with tokenstring separator
  TToken_string& tokenize(const char* s, const char* sep = " \t\n");

  // Setta il separatore a s
  void separator(char s) { _separator = s; }    
  
  // Rimette all'inizio il puntatore
  void restart() { _last = empty() ? -1 : 0; } 
  const TString& operator =(const char* s) 
  { set(s);restart();return *this; }
  const TString& operator =(const TString& s) 
  { set(s);restart();return *this; }

  void add(const char* s, int n = -1); // Aggiunge una stringa
  void add(char c, int pos = -1);      // Aggiunge un char
  void add(long n, int pos = -1);      // Aggiunge un intero
  void add(int n, int pos = -1);       // Aggiunge un intero
  void destroy(int pos);        // Toglie la stringa pos
  const char* get();            // Ritorna il prossimo token
  const char* get(int n);       // Ritorna un token (-1 = prossimo; -2 = ultimo; n = ennesimo)
  char get_char(int n = -1);    // Ritorna un carattere
  int get_int(int n = -1);      // Ritorna un intero
  long get_long(int n = -1);    // Ritorna un intero esteso
  float get_float(int n = -1);  // Ritorna un float
  int get_pos(const char* s);   // Ritorna la posizione dell'item s
  int items() const;            // Ritorna il numero di token presenti
  bool empty_items() const;     // Controlla se tutti i token sono nulli
};

///////////////////////////////////////////////////////////
// @DES Paragraph
///////////////////////////////////////////////////////////

class TParagraph_string : public TToken_string
{
  int _width;
  bool _fixed;

protected:
  void tokenize();

public:
  TParagraph_string(const char* s, int width);
  const TString& operator =(const char* s);
  void set_width(int width) { _width = width; }
};

//----------------------------------------------------------------------------------------
//						TNamedObject
//----------------------------------------------------------------------------------------
  
class TNamedObject : public TOrderedObject
{
protected:

  friend int TNamedObjectCMP( const TNamedObject& a, const TNamedObject& b );
  friend int TNamedObjectEQ( const TNamedObject& a, const TNamedObject& b );
  CString fName;
  PixVec* fP;

public:

  TNamedObject(int index, const char* name=0): TOrderedObject(index) {  fP=NULL; if(name) fName = name; }
  TNamedObject(const char* name=0): TOrderedObject() {  fP=NULL;  if(name) fName = name; }
//  inline char* Name() { return fName; }
  inline const char* Name() const { return fName; }
  inline virtual const char* QualifiedName() const { return fName; }
//  inline CString& SName() { return fName; } 

  void name_break(const char* name) const;
  inline const CString& SName() const { return fName; } 
  inline CString& SName() { return fName; } 
  int Register(Pix p, int index);
  Pix GetListPix(int listIndex) ;
};

inline int TNamedObjectEQ( const TNamedObject& a, const TNamedObject& b ) {
  return ( a.fName == b.fName );
}
inline int TNamedObjectCMP( const TNamedObject& a, const TNamedObject& b ) {
  return compare(a.fName,b.fName);
}

#endif
