#include "DLnkList.h"
#include "Environ.h"

int test = 0;

void TOrderedObjectDLList::error(char* msg) const
{
  gPrintScreen(msg);
  BreakToSourceDebugger_();
}


int TOrderedObjectDLList::length() const
{
  int l = 0;
  TOrderedObjectDLListNode* t = h;
  if (t != 0) do { ++l; t = t->fd; } while (t != h);
  return l;
}

TOrderedObjectDLList& TOrderedObjectDLList::operator = (const TOrderedObjectDLList& a)
{
  if (h != a.h)
  {
    clear();
    if (a.h != 0)
    {
      TOrderedObjectDLListNode* p = a.h;
      TOrderedObjectDLListNode* t = GetNode(p->hd,this,p->Index()); mIndex++;
      h = t;
      p = p->fd;
      while (p != a.h)
      {
        TOrderedObjectDLListNode* n = GetNode(p->hd,this,p->Index()); mIndex++;
        t->fd = n;
        n->bk = t;
        t = n;
        p = p->fd;
      }
      t->fd = h;
      h->bk = t;
    }
  }
  return *this;
}

int TOrderedObjectDLList::CopyToPixVec( PixVec& a, int start ) {
	if (h != 0)  {
		a.elem(start++) = h;
		TOrderedObjectDLListNode* p = h->fd;
		while ( (p != h) && (p != 0) )  {
			a.elem(start++) = p;
			p = p->fd;
		}
	}
  a.fill(0,start);
	return start;
}

int TOrderedObjectDLList::CopyFromPixVec( PixVec& a, int start ) {
	TOrderedObjectDLListNode *p1, *p0 = (h = (TOrderedObjectDLListNode*)a[start]);
	if( h ) {
		while( (p1 = (TOrderedObjectDLListNode*)a[++start]) != 0 ) {
			p0->fd = p1;
			p1->bk = p0;
			p0 = p1;
		}
		p0->fd = h;
		h->bk = p0;
	}
	return start;
}

TOrderedObjectDLList& TOrderedObjectDLList::operator += (const TOrderedObjectDLList& a)
{
  if (h != a.h)
  {
    if (a.h != 0)
    {
      TOrderedObjectDLListNode* p = a.h;
      TOrderedObjectDLListNode* t = GetNode(p->hd,this,p->Index()); mIndex++;
      if ( h == 0 ) h = t;
      else h->bk->fd = t;
      t->bk = h->bk;
      p = p->fd;
      while (p != a.h)
      {
        TOrderedObjectDLListNode* n = GetNode(p->hd,this,p->Index()); mIndex++;
        t->fd = n;
        n->bk = t;
        t = n;
        p = p->fd;
      }
      t->fd = h;
      h->bk = t;
    }
  }
  return *this;
}

void TOrderedObjectDLList::clear()
{
  if (h == 0)
    return;

  TOrderedObjectDLListNode* p = h->fd;
  h->fd = 0;
  h = 0;

	_MemMgr.Free();
}

void TOrderedObjectDLList::free()
{
  if (h == 0)
    return;

  TOrderedObjectDLListNode* p = h->fd;
  h->fd = 0;
  h = 0;

  while (p != 0)
  {
    TOrderedObjectDLListNode* nxt = p->fd;
    TOrderedObject* obj = (p->hd);
    delete obj;
    p = nxt;
  }
	_MemMgr.Free();

}


Pix TOrderedObjectDLList::prepend(TOrderedObject& item)
{
  TOrderedObjectDLListNode* t = GetNode(&item,this,mIndex++);
  if (h == 0)
    t->fd = t->bk = h = t;
  else
  {
    t->fd = h;
    t->bk = h->bk;
    h->bk->fd = t;
    h->bk = t;
    h = t;
  }
  return Pix(t);
}

Pix TOrderedObjectDLList::append(TOrderedObject& item)
{
  TOrderedObjectDLListNode* t = GetNode(&item,this,mIndex++);
  if (h == 0)
    t->fd = t->bk = h = t;
  else
  {
    t->bk = h->bk;
    t->bk->fd = t;
    t->fd = h;
    h->bk = t;
  }
  return Pix(t);
}

Pix TOrderedObjectDLList::append(TOrderedObject& item, unsigned int index )
{
  TOrderedObjectDLListNode* t = GetNode(&item,this,index);
  mIndex++;
  if (h == 0)
    t->fd = t->bk = h = t;
  else
  {
    t->bk = h->bk;
    t->bk->fd = t;
    t->fd = h;
    h->bk = t;
  }
  return Pix(t);
}

Pix TOrderedObjectDLList::move( Pix pt, Pix pm0, Pix pm1 )  	// Move pm0-pm1 in front of pt
{
  if(pm1==0) pm1 = pm0;
#ifdef DEBUG
  if (pt == 0) error("null Pix");
  if( checkPixOwnership && !owns(pt) ) error( " Pix not owned by Set" );
  if (pm0 == 0) error("null Pix");
  if( checkPixOwnership && !owns(pm0) ) error( " Pix not owned by Set" );
  if( checkPixOwnership && !owns(pm1) ) error( " Pix not owned by Set" );
#endif
  TOrderedObjectDLListNode* t0 = (TOrderedObjectDLListNode*) pm0;
  TOrderedObjectDLListNode* t1 = (TOrderedObjectDLListNode*) pm1;
  TOrderedObjectDLListNode* u = (TOrderedObjectDLListNode*) pt;
  if ( t0 == h || t0 == u ) return pm0;
  if (t1->fd == t0) { h = 0; }
  else {
    t0->bk->fd = t1->fd;
    t1->fd->bk = t0->bk;
  }
  t0->bk = u->bk;
  t1->fd = u;
  u->bk->fd = t0;
  u->bk = t1;
  if (u == h) h = t0;
  return Pix(t0);
}

void TOrderedObjectDLList::swap( Pix p0, Pix p1 ) 
{
  if(p0==p1) return;
#ifdef DEBUG
  if (p0 == 0) error("null Pix");
  if( checkPixOwnership && !owns(p0) ) error( " Pix not owned by Set" );
  if (p1 == 0) error("null Pix");
  if( checkPixOwnership && !owns(p1) ) error( " Pix not owned by Set" );
#endif
  TOrderedObjectDLListNode* t0 = (TOrderedObjectDLListNode*) p0;
  TOrderedObjectDLListNode* t1 = (TOrderedObjectDLListNode*) p1;
  if( h == t0 ) h = t1;
  if( h == t1 ) h = t0;
	t0->bk->fd = t1;
	t1->bk->fd = t0;
	t1->fd->bk = t0;
	t0->fd->bk = t1;
	
  TOrderedObjectDLListNode* t0f = t0->fd;
  TOrderedObjectDLListNode* t0b = t0->bk;
  t0->bk = t1->bk;
  t0->fd = t1->fd;
  t1->fd = t0f;
  t1->bk = t0b;
}

Pix  TOrderedObjectDLList::find( TOrderedObject* item ) const {
  for( Pix p = first(); p; next(p) ) {
   TOrderedObjectDLListNode* u = (TOrderedObjectDLListNode*) p;
   if( (u->hd) == item ) return p;
  }
  return 0;
}

Pix  TOrderedObjectDLList::find( int index ) const {
  for( Pix p = first(); p; next(p) ) {
   TOrderedObjectDLListNode* u = (TOrderedObjectDLListNode*) p;
   if( (u->hd->Index()) == index ) return p;
  }
  return 0;
}

Pix  TOrderedObjectDLList::findBefore( Pix p0, TOrderedObject* item ) const {
  for( Pix p = prev(p0); p; prev(p) ) {
   TOrderedObjectDLListNode* u = (TOrderedObjectDLListNode*) p;
   if( (u->hd) == item ) return p;
  }
  return 0;
}

Pix  TOrderedObjectDLList::findAfter( Pix p0, TOrderedObject* item ) const {
  for( Pix p = next(p0); p; next(p) ) {
   TOrderedObjectDLListNode* u = (TOrderedObjectDLListNode*) p;
   if( (u->hd) == item ) return p;
  }
  return 0;
}

Pix  TOrderedObjectDLList::find( TOrderedObject& item ) const {
  for( Pix p = first(); p; next(p) ) {
   TOrderedObjectDLListNode* u = (TOrderedObjectDLListNode*) p;
   if( *(u->hd) == item ) return p;
  }
  return 0;
}

Pix TOrderedObjectDLList::ins_after(Pix p, TOrderedObject& item)
{
  if (p == 0) return prepend(item);
#ifdef DEBUG
  if( checkPixOwnership && !owns(p) ) error( " Pix not owned by Set" );
#endif
  TOrderedObjectDLListNode* u = (TOrderedObjectDLListNode*) p;
  TOrderedObjectDLListNode* t = GetNode(&item, this, mIndex++, u, u->fd);
  u->fd->bk = t;
  u->fd = t;
  return Pix(t);
}

inline const char* node_name( TOrderedObjectDLListNode* n ) { return ((TNamedObject*)(n->hd))->Name(); }

int TOrderedObjectDLList::sort( NodeRankFn nrf ){
  int pDebug = ( gDebug > 2 ) ? 1 : 0;
  if( h==0 || h->bk == h ) return 0; 
 
  TOrderedObjectDLListNode* u = h;
  unsigned int q = UINT_MAX/length();
  unsigned int index = 0;

  do {
    u->SetIndex( index += q ) ;	
  } while( ( u = u->fd ) != h );

  if( pDebug ) { 
    u=h;
    sprintf(gMsgStr,"\n\n %% Initial Rank: "); gPrintLog();
    do {
      sprintf(gMsgStr," %s(%u) ", node_name(u), u->Index() );
      gPrintLog();
    } while( ( u = u->fd ) != h );
  }

  startRanking: u=h;

  do {
    if( (*nrf)(*u) ) goto startRanking;
  } while( ( u = u->fd ) != h );


  int cnt = 0;
  startSort:
  if( cnt++ == 500 ) { gProgramBreak("Long Sort."); return 0; }

  if( pDebug ) { 
    u=h;
    sprintf(gMsgStr,"\n %% New Rank: "); gPrintLog();
    do {
      sprintf(gMsgStr," %s(%u) ", node_name(u), u->Index() );
      gPrintLog();
    } while( ( u = u->fd ) != h );
  }

  TOrderedObjectDLListNode* t = h;
  while( t != h->bk ) {
    TOrderedObjectDLListNode* u1 = h->bk;
    while( u1 != t ) {
      if( t->Index() > u1->Index() ) {
				TOrderedObjectDLListNode* u0 = u1;
				while( (u0 != h) && ( u0->bk != t )  && (u0->bk->Index() <= t->Index())  ) { u0 = u0->bk; }
				move( t, u0, u1 );                   // move u0 - u1 in front of t.
				if( pDebug ) {
					sprintf(gMsgStr,"\n\n %% List Move: ( %s(%u) ... %s(%u) ) -> %s(%u)\n",
						node_name(u0), u0->Index(), node_name(u1), u1->Index(), node_name(t), t->Index() );
					gPrintLog();
				}
				goto startSort;
      }
      u1 = u1->bk;
    }
    t = t->fd;
  }
  return 1;
}

unsigned long pixIndex(Pix p) {
#ifdef DEBUG
	if( p==0 ) { gPrintErr(" NULL pix error in sort " ); return 0; }
#endif
	return ((TOrderedObjectDLListNode*)p)->Index();
}

void pixPrinter( Pix p1, Pix p2 ) {
#ifdef DEBUG
	if( (p1==0) || (p2==0) ) { gPrintErr(" NULL pix error in sort " ); return; }
#endif
	TNamedObject& n1 = (TNamedObject&)((TOrderedObjectDLListNode*)p1)->Object();
	TNamedObject& n2 = (TNamedObject&)((TOrderedObjectDLListNode*)p2)->Object();
	gPrintScreen( format(" Swap: %s <-> %s ", n1.Name(), n2.Name() ) );
}

int TOrderedObjectDLList::is_sortable( NodeRankFn nrf ){
  if( h==0 || h->bk == h ) return 0; 
 
  TOrderedObjectDLListNode* u = h;
  unsigned int q = UINT_MAX/length();
  unsigned int index = 0;

  do {
    u->SetIndex( index += q ) ;	
  } while( ( u = u->fd ) != h );

  int cnt = 0;
  startRanking: u=h;
  if( cnt++ > 2000 ) { return 0; }
  do {
    if( (*nrf)(*u) ) goto startRanking;
  } while( ( u = u->fd ) != h );
  return cnt;
}

int TOrderedObjectDLList::qsort( NodeRankFn nrf ){
  static PixVec sortVec(250,(Pix)0);
  int pDebug = ( gDebug > 2 ) ? 1 : 0;
  if( h==0 || h->bk == h ) return 0; 
 
  TOrderedObjectDLListNode* u = h;
  unsigned int q = UINT_MAX/length();
  unsigned int index = 0;

  do {
    u->SetIndex( index += q ) ;	
  } while( ( u = u->fd ) != h );

  int cnt = 0, print_swaps = 0;
  startRanking: u=h;
  if( cnt++ > 2000 ) { 
	gDebug = 5; 
	if( cnt > 2020 ) { 
	  gPrintErr("Circular dependencies in sort"); 
	}
	if( cnt > 2025 ) { gDebug = 2;  return cnt; }
  }
  do {
    if( (*nrf)(*u) ) goto startRanking;
  } while( ( u = u->fd ) != h );

  int length = CopyToPixVec( sortVec );

 if( pDebug ) { 
    u=h;
    sprintf(gMsgStr,"\n %% Rank before sort, len = %d: ", length ); gPrintLog();
    do {
      sprintf(gMsgStr," %-40s %20u ", node_name(u), u->Index() );
      gPrintLog();
    } while( ( u = u->fd ) != h );
  }

	sortVec.qsort( 0, length-1, &pixIndex );	
	length = CopyFromPixVec( sortVec );

 if( pDebug ) { 
    u=h;
    sprintf(gMsgStr,"\n %% Rank after sort, len = %d: ", length ); gPrintLog();
    do {
      sprintf(gMsgStr," %-40s %20u ", node_name(u), u->Index() );
      gPrintLog();
    } while( ( u = u->fd ) != h );
  }
	
  return cnt;
}

/*  
int TOrderedObjectDLList::qsort( TOrderedObjectDLListNode*& first, TOrderedObjectDLListNode*& last, int cnt ) {
	if( first == last ) return 0;
	static TOrderedObjectDLListNode* lo0 = 0;
	static TOrderedObjectDLListNode* hi0 = 0;
	TOrderedObjectDLListNode* lo = first;
	TOrderedObjectDLListNode* hi = last;
	TOrderedObjectDLListNode* lo1 = first;
	TOrderedObjectDLListNode* hi1 = last;
	if( cnt == 0 ) { lo0 = lo; hi0 = hi; }
	float mid = 0; 
	int lcnt=0, pDebug = ( gDebug > 2 ) ? 1 : 0;
	while( (lo1=lo1->fd) != hi ) { 
		mid += lo1->Index(); lcnt++; 
	}
	mid /= lcnt;

	while( lo != hi ) {
		 while( ( lo != hi0 )  && ( lo->Index() < mid ) ) lo = lo->fd;
		 while( ( hi != lo )  && ( hi->Index() > mid ) ) hi = hi->bk;

		 if( lo != hi )   {
				 lo1 = lo;
				 hi1 = hi;
				 lo = lo->fd;
				 hi = hi->bk;
				 swap(lo1, hi1);
				 if( pDebug ) {
					 sprintf(gMsgStr,"\n %% List Swap: %s(%u) <-(%f)-> %s(%u)", node_name(lo1), lo1->Index(), mid, node_name(hi1), hi1->Index() );
					 gPrintLog();
				 }
			}
	}
	static int next_Partition = 0;	
	if( (lo0 != hi) &&  (next_Partition == 0) ) {
		first = lo0;
		last =  hi;
		next_Partition = 1;
		return 1;
	}
	if( lo != hi0  &&  (next_Partition == 1) ) {
		first = lo;
		last = hi0;
		next_Partition = 0;
		return 1;
	}
	if( (lo0 != hi)  ) {
		first = lo0;
		last =  hi;
		return 1;
	}
	if( lo != hi0  ) {
		first = lo;
		last = hi0;
		return 1;
	}

	return 0;
}
*/

int TOrderedObjectDLList::sort( ESortType st ){
  if( h==0 || h->bk == h ) return 0; 
 
  TOrderedObjectDLListNode* u = h;

  int cnt = 0;
  startSort:
  if( cnt++ == 1000 ) { gProgramBreak("Long Sort."); return 0; }
  if( cnt == 500 ) { Env::debugger_stop_here(); }

  TOrderedObjectDLListNode* t = h;
  while( t != h->bk ) {
    TOrderedObjectDLListNode* u1 = h->bk;
    while( u1 != t ) {
      if( index_test(st,t,u1) ) {
				TOrderedObjectDLListNode* u0 = u1;
				while( (u0 != h) && ( u0->bk != t ) && index_test(st,t,u0)  ) { u0 = u0->bk; }
				move( t, u0, u1 );                   // move u0 - u1 in front of t.
				goto startSort;
      }
      u1 = u1->bk;
    }
    t = t->fd;
  }
  return 1;
}

Pix TOrderedObjectDLList::ins_before(Pix p, TOrderedObject& item)
{
#ifdef DEBUG
  if (p == 0) error("null Pix");
  if( checkPixOwnership && !owns(p) ) error( " Pix not owned by Set" );
#endif
  TOrderedObjectDLListNode* u = (TOrderedObjectDLListNode*) p;
  TOrderedObjectDLListNode* t = GetNode(&item, this, mIndex++, u->bk, u);
  u->bk->fd = t;
  u->bk = t;
  if (u == h) h = t;
  return Pix(t);
}

void TOrderedObjectDLList::join(TOrderedObjectDLList& b)
{
  TOrderedObjectDLListNode* t = b.h;
  b.h = 0;
  if (h == 0)
    h = t;
  else if (t != 0)
  {
    TOrderedObjectDLListNode* l = t->bk;
    h->bk->fd = t;
    t->bk = h->bk;
    h->bk = l;
    l->fd = h;
  }
}

void TOrderedObjectDLList::del(Pix& p, int dir, int free_obj)
{
#ifdef DEBUG
  if (p == 0) error("null Pix");
  if( checkPixOwnership && !owns(p) ) error( " Pix not owned by Set" );
#endif
  TOrderedObjectDLListNode* t = (TOrderedObjectDLListNode*) p;
  TOrderedObject& res = *(t->hd);
  if (t->fd == t)
  {
    h = 0;
    p = 0;
  }
  else
  {
    if (dir < 0)
    {
      if (t == h)
        p = 0;
      else
        p = Pix(t->bk);
    }
    else
    {
      if (t == h->bk)
        p = 0;
      else
        p = Pix(t->fd);
    }
    t->bk->fd = t->fd;
    t->fd->bk = t->bk;
    if (t == h) h = t->fd;
  }
  if(free_obj) delete &res;
}

void TOrderedObjectDLList::del_next_node(Pix& p, int free_obj)
{
  if (p == 0)
  {
    del_front(free_obj);
    return;
  }
#ifdef DEBUG
  if( checkPixOwnership && !owns(p) ) error( " Pix not owned by Set" );
#endif
  TOrderedObjectDLListNode* b = (TOrderedObjectDLListNode*) p;
  TOrderedObjectDLListNode* t = b->fd;
  TOrderedObject& res = *(t->hd);

  if (b == t)
  {
    h = 0;
    p = 0;
  }
  else
  {
    t->bk->fd = t->fd;
    t->fd->bk = t->bk;
    if (t == h) h = t->fd;
  }
  if(free_obj) { delete &res; }
}

TOrderedObject& TOrderedObjectDLList::remove_front( )
{
  if (h == 0)
    error("remove_front of empty list");
  TOrderedObjectDLListNode* t = h;
  TOrderedObject& res = *(t->hd);
  if (h->fd == h)
    h = 0;
  else
  {
    h->fd->bk = h->bk;
    h->bk->fd = h->fd;
    h = h->fd;
  }
  return res;
}

void TOrderedObjectDLList::del_upto ( Pix p, int free_obj) {
#ifdef DEBUG
  if( checkPixOwnership && !owns(p) ) error( " Pix not owned by Set" );
#endif
  while( p != first() && !empty() ) { del_front( free_obj ); }
}

void TOrderedObjectDLList::del_after ( Pix p, int free_obj) {
#ifdef DEBUG
  if( checkPixOwnership && !owns(p) ) error( " Pix not owned by Set" );
#endif
  while( p != last() && !empty() ) { del_rear( free_obj ); }
}

void TOrderedObjectDLList::del_front( int free_obj )
{
  if (h == 0)
    error("del_front of empty list");
  TOrderedObjectDLListNode* t = h;
  TOrderedObject& res = *(t->hd);
  if (h->fd == h)
    h = 0;
  else
  {
    h->fd->bk = h->bk;
    h->bk->fd = h->fd;
    h = h->fd;
  }
  if(free_obj) { delete &res; }
}

TOrderedObject& TOrderedObjectDLList::remove_rear()
{
  if (h == 0)
    error("remove_rear of empty list");
  TOrderedObjectDLListNode* t = h->bk;
  TOrderedObject& res = *(t->hd);
  if (h->fd == h)
    h = 0;
  else
  {
    t->fd->bk = t->bk;
    t->bk->fd = t->fd;
  }
  return res;
}


void TOrderedObjectDLList::del_rear( int free_obj)
{
  if (h == 0)
    error("del_rear of empty list");
  TOrderedObjectDLListNode* t = h->bk;
  TOrderedObject& res = *(t->hd);
  if (h->fd == h)
    h = 0;
  else
  {
    t->fd->bk = t->bk;
    t->bk->fd = t->fd;
  }
  if(free_obj) { delete &res; }
}


int TOrderedObjectDLList::OK() const
{
  int v = 1;
  if (h != 0)
  {
    TOrderedObjectDLListNode* t = h;
    long count = LONG_MAX;      // Lots of chances to find h!
    do
    {
      count--;
      v &= t->bk->fd == t;
      v &= t->fd->bk == t;
      t = t->fd;
    } while (v && count > 0 && t != h);
    v &= count > 0;
  }
  if (!v) error("invariant failure");
  return v;
}
