// Encoder classes: encode streams of numbers with various methods
// for generality the output stream is passed with function although
// using class as a filter would be nicer

#ifndef __encode_H
#define __encode_H

#ifndef _STDIO_H
#include <stdio.h>
#endif

typedef void (*output_func)(void*, const char*);

class BaseEncoder 
{

  output_func _func;
  void*       _parms;
  
protected:
  
  output_func outfun()    { return _func;  }
  void* function_parms()  { return _parms; }

public:
  
  // encode stuff using operators
  virtual void operator<<(int)         {}
  virtual void operator<<(long)        {}
  virtual void operator<<(float)       {}
  virtual void operator<<(const char*) {}

  BaseEncoder(output_func f, void* fpar = NULL) : _func(f), _parms(fpar) {}
  virtual ~BaseEncoder() {}
};


// Simple Run Lenght Encoding: encodes ints, longs, floats in RLE strings
// ASCII-represented - simplest of all, quick and dumb
class SRLE_Encoder : public BaseEncoder
{
  float _fvalue;
  float _flast;
  long  _lvalue;
  long  _llast;
  int   _count;
  int   _use_floats;
  int   _started;
  
  float _accuracy;

  void add_value(float);
  void add_value(long);

public:
  
  // call this at the end of the job to flush the last values added
  void flush(int end = 1);
  // set accuracy in comparison between floats
  void set_accuracy(float f) { _accuracy = f; }

  // encode stuff using operators
  virtual void operator<<(int v)     { add_value((long)v); }
  virtual void operator<<(long v)    { add_value(v);       }
  virtual void operator<<(float v)   { add_value(v);       }

 SRLE_Encoder(output_func f, void* fpar = NULL) : 
   BaseEncoder(f, fpar), _accuracy(0.000001), _started(0), _use_floats(0),
   _count(0)
    {}
  virtual ~SRLE_Encoder() 
    {}
};

#endif

