#include "HDepParm.h"
#include "Environ.h"

unsigned char gSectorChar = '';
unsigned char gHabChar = '';
unsigned char gPairChar = '';

FILE* HParm::fFile = NULL;
float* HParm::fTemp = NULL;
int HParm::fHIndex = -1;
int HParm::fSLen[MAX_NHAB];

float* HParm::GetHParm( const char* filename, int sIndex, int pIndex, int& size ) 
{
  int end=0;

  fTemp = new float [ MAX_NHAB ];
  size = MAX_NHAB;
  for(int i=0; i<MAX_NHAB; i++) fTemp[i] = 0.0;
  if(gDebug) { sprintf(gMsgStr,"Reading file %s",filename); gPrintLog(); } 
  fFile = fopen(filename,"r");
  if(fFile==NULL) { sprintf(gMsgStr,"Unable to open dBase file %s",filename); gFatal(); }
	
  for( fHIndex = 1; fHIndex < MAX_NHAB; fHIndex++) {
	
    if( (GoToIndex (gHabChar, fHIndex) == 0) && (fHIndex==1)  ) { 
			sprintf(gMsgStr,"Can't Find HabChar(%d): %c (ASCII %u) in %s",fHIndex, gHabChar, gHabChar, filename); 
			gFatal(); 
		}
    if( (GoToIndex (gSectorChar, sIndex)   == 0) && (fHIndex==1)  ) { 
			sprintf(gMsgStr,"Can't Find SectorChar(%d): %c (ASCII %u) in %s",sIndex, gSectorChar, gSectorChar, filename); 
			gFatal();
		}
    fTemp[fHIndex] = GetNthParm( pIndex, &end );
    if(end) break;
  }
  fclose(fFile);
  return fTemp; 
}

int HParm::GetHParm( const char* filename, int sIndex, int pIndex, floatVec& v ) 
{
  int end=0, cnt = 0;
  if(gDebug) { sprintf(gMsgStr,"Reading file %s",filename); gPrintLog(); } 
  fFile = fopen(filename,"r");
  if(fFile==NULL) { sprintf(gMsgStr,"Unable to open dBase file %s",filename); gFatal();}

	v.clear();
  for( fHIndex = 1; fHIndex < MAX_NHAB; fHIndex++) {	
    if( (GoToIndex (gHabChar, fHIndex) == 0) && (fHIndex==1) ) { 
			sprintf(gMsgStr,"Can't Find HabChar(%d): %c (ASCII %u) in %s",fHIndex, gHabChar, gHabChar, filename); 
			gFatal(); 
		}
    if( (GoToIndex (gSectorChar, sIndex)  == 0) && (fHIndex==1) ) { 
			sprintf(gMsgStr,"Can't Find SectorChar(%d): %c (ASCII %u) in %s",sIndex, gSectorChar, gSectorChar, filename); 
			gFatal();
		}
    v.add(fHIndex) = GetNthParm( pIndex, &end );
    if(end) break;
  }
  fclose(fFile);
  return fHIndex-1; 
}

float* HParm::Read( const char* filename, int sIndex, int pIndex, int index, int order, int& size )
{
  if(order==2) return GetHParm2( filename, sIndex, pIndex, index, size);
  else if (order == 1) return GetHParm( filename, sIndex, pIndex, size);
  else { gFatal("Illegal order in ReadHParm: %d\n",order); }
  return NULL;
}

float* HParm::GetHParm2( const char*  filename, int sIndex, int pIndex, int index, int& size)
{
  int test, cnt=0, i, j, iparm, imax, first = 1, mss;
  int graphSize, *indexTmp, *itmp, n0=0, n1, seriesSize=0; 
  float  fparm, *graphTmp, *fGraph;
	
  graphSize = MAX_NHAB;
  graphTmp = new float [ graphSize ];
  fGraph = new float [ graphSize ];
  indexTmp = new int [ graphSize ];

  if(gDebug) { sprintf(gMsgStr,"Reading file %s",filename); gPrintLog(); } 
  fFile = fopen(filename,"r");
  if(fFile==NULL) { sprintf(gMsgStr,"Unable to open dBase file %s",filename); gFatal(); }
	
  for( fHIndex = 1; fHIndex < MAX_NHAB; fHIndex++) {
    rewind(fFile);	
    if( GoToIndex (gHabChar, fHIndex) ) { 
      if(gDebug) { sprintf(gMsgStr,"}\ngot graph : (Hab = %d)\n{ ",fHIndex); gPrintLog(); }
      GoToIndex ( gSectorChar, sIndex);
      GoToNthParm( pIndex ); imax = 0;	
      while(1) {
	test = fscanf(fFile,"%d",&iparm);
	if( test == 1 ) {
	  if(gDebug) { sprintf(gMsgStr,"%d ",iparm); gPrintLog(); }
	  if(cnt >= graphSize) {
	    delete[] graphTmp;
	    itmp = indexTmp; 
	    graphSize = cnt + 20;
	    graphTmp = new float [graphSize];
	    indexTmp = new int [graphSize];
	    for(i=0; i<cnt; i++) indexTmp[i] = itmp[i];
	    delete[] itmp;
	  }
	  indexTmp[cnt++] = iparm;
	  if( iparm > imax ) imax = iparm;
	}
	else { gFatal("read error in get graph."); }
	test = FindGraphChar();
	if (test == 1) {
	  if(first) { n1 = imax+1; first = 0; }
	  else if ( imax > n1 ) { gFatal("DBase Read Error, Unequal graph sizes"); }
	  if ( (fHIndex+1) > n0 ) n0 = (fHIndex+1);
	  if( n0*n1 > graphSize ) {					
	    fTemp = fGraph; 
	    mss = graphSize;
	    graphSize = (n0+5)*n1*sizeof(float);
	    fGraph = new float[graphSize];
	    for(i=0; i<mss; i++) ((byte*)fGraph)[i] = ((byte*)fTemp)[i];
	    delete[] fTemp;
	  }
	  for (j=0; j<n1; j++) ((float*)fGraph)[fHIndex*n1 + j] = -1;
	  cnt = 0;
	  break; 
	}
	else if(test == -1) break;
      }
      while(1) {
	test = fscanf(fFile,"%f",&fparm);
	if( test == 1 ) {
	  if(gDebug) { sprintf(gMsgStr,"%.2f ",fparm); gPrintLog(); }
	  graphTmp[cnt++] = fparm;
	}
	else { gFatal("read error in get graph"); }
	test = FindGraphChar();
	if(test == 2) { ; }
	else if (test == 1) { 
	  for (j=0; j<cnt; j++) ((float*)fGraph)[ fHIndex*n1 +indexTmp[j] ] = graphTmp[j];
	  cnt = 0;
	  break;
	}
	else break;
      }
    }
  }
  if(index<MAX_NHAB) fSLen[index] = n1;
  delete[] graphTmp;
  delete[] indexTmp;
  fclose(fFile);
  size = graphSize;
  return (float*)fGraph;
} 

int HParm::FindChar (unsigned char tchar) 
{
  unsigned char cchar = '#';
  int in_c=0, test = 0;
		
  while( test != EOF ) {
    test = fgetc(fFile);
    if( test == tchar && in_c==0 ) { return 1; }
    if( test == cchar ) in_c=1;
    if( test == '\n' )  in_c=0;
  }		
  return(0);
}

int HParm::FindSpecChar () 
{
  char cchar = '#';
  int in_c=0, test = 0;
		
  while( ( test = fgetc(fFile) ) != EOF) {
    if(in_c==0) {
      if( test == gHabChar ) return 1;
      if( test == gSectorChar ) return 2;
      if( test == gPairChar ) return 3;
    }
    if( test == cchar ) in_c=1;
    if( test == '\n' )  in_c=0;
  }		
  return(0);
}

int HParm::FindGraphChar () 
{
  int test = 0;		
  while( ( test = fgetc(fFile) ) != EOF ) if( test != ' ' ) {
    if( test == '\t' ) return 1;
    if( test == '' ) return 2;
    else return -1;
  }		
  return(0);
}

int HParm::GetNumber() {
  char ch;
  int rv;
	
  ch = fgetc(fFile);
  if( !isdigit( ch ) ) return(-1);
  rv = ch - '0';
	
  while( isdigit( ch = fgetc(fFile) ) ) 
    rv = rv*10 + ( ch - '0' );
		
  return rv;
}

int HParm::GoToIndex ( unsigned char tchar, int index) 
{
  int rv=1, current_index=-1, itest;

  while(current_index != index) {	
    itest = FindChar (tchar);
    if(itest <= 0) return 0;
    current_index = GetNumber();
    if(current_index < 0) { gFatal("Bad number format in dBase"); }
  }
  return 1;
}

float HParm::GetNthParm(int pIndex, int* end ) 
{
  int i=1, itest=1, ch;
  float rv;
	
  while ( (i++ < pIndex) && itest > 0 ) { itest = FindChar ( '\t' ); }
  if( itest == 0 ) { *end = 1; return(0.0); }
	
  itest = fscanf(fFile,"%f",&rv);
  if(itest==1) { if(gDebug) { sprintf(gMsgStr,"got parm: %f\n",rv); gPrintLog(); }}
  else if ( (ch = fgetc(fFile)) == EOF ) { *end = 1; return(0.0); }
  else {
    if(gDebug) { sprintf(gMsgStr,"Read Error in dBase(%d)\n REad Dump:\n",itest);gPrintLog(); }
    for(i=0; i<12; i++) { 
      ch = fgetc(fFile);
      if(ch==EOF) if(gDebug) { sprintf(gMsgStr,"\nAt EOF\n"); gPrintLog(); break; }
    }
    gFatal("Read Error in dBase");
  }
  *end = 0;
  return(rv);
}

void HParm::GoToNthParm( int pIndex ) 
{
  int i=1;
  while ( i++ < pIndex ) FindChar ( '\t' );
}
