//----------------------------------------------------------------------------------------
//	HDepParm.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------

#ifndef __HDepParm__
#define __HDepParm__

#include "Globals.h"
#include "floatVec.h"

#define MAX_NHAB 255

class HParm {

  static FILE* fFile;
  static float* fTemp;
  static int fHIndex;
  static int fSLen[MAX_NHAB];
  
  static int FindChar (unsigned char tchar);		
  static int FindGraphChar (); 
  static int GetNumber();
  static int GoToIndex ( unsigned char tchar, int index); 
  static float GetNthParm(int pIndex, int* end ); 
  static void GoToNthParm( int pIndex ) ;
  static float* GetHParm( const char* filename, int sIndex, int pIndex, int& size  ) ;
  int GetHParm( const char* filename, int sIndex, int pIndex, floatVec& v ); 
  static float* GetHParm2( const char*  filename, int sIndex, int pIndex, int index, int& size );
  static int FindSpecChar () ;
  
public:
  
  static float* Read( const char* filename, int sIndex, int pIndex, int index, int order, int& size );
};


#endif
