#ifndef _MemoryBlocks_h
#define _MemoryBlocks_h 1

#include "Environ.h"


template<class T>
class MMBuffer {

	T* _data;	
	MMBuffer* _next;
	int _size;
	int _index;
	
public:

	MMBuffer(int size) {
		_size = size;
		_data = new T[size];
		_next = NULL;	
		_index = 0;
	}
	~MMBuffer() { delete[] _data; }
	
	inline void link(MMBuffer* next) { _next = next; }
	inline MMBuffer* next() { return _next; }
	inline T* Allocate() { 
		return ( _index >= _size ) ? (T*)NULL : _data + _index++; 
	}
};


template<class T>
class MemMgr {

	int _bufferSize;
	MMBuffer<T>* _firstMMB;
	MMBuffer<T>* _currentMMB;

public:
	MemMgr(int bufferSize) {
		_bufferSize = bufferSize;
		_currentMMB = NULL;
		_firstMMB = NULL;
	}
	~MemMgr() { Free(); }
	
	inline T* Allocate() { 
		if( _firstMMB == NULL ) { _firstMMB = CreateNewBuffer(); }
		T* rv = _currentMMB->Allocate();
		if( rv == NULL ) {
			CreateNewBuffer();
			rv = _currentMMB->Allocate();
		}
		return rv;
	}

	inline MMBuffer<T>* CreateNewBuffer() {
		MMBuffer<T>* newB = new MMBuffer<T>(_bufferSize);
		if( _currentMMB ) { _currentMMB->link(newB); }
		return ( _currentMMB = newB );
	}

	inline void Free() {
		MMBuffer<T>* mbPtr_next;
		for( MMBuffer<T>* mbPtr = _firstMMB; mbPtr != NULL; mbPtr = mbPtr_next ) {
			mbPtr_next = mbPtr->next();
			delete mbPtr;
		}
		_firstMMB = NULL;
		_currentMMB = NULL;
	}
	
};

#endif
