//----------------------------------------------------------------------------------------
  //	MsgBuff.cc
  //	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
  //	Change History:
  //----------------------------------------------------------------------------------------
 
#ifdef USE_MPI

#include "MsgBuff.h" 

void TMsgBuff::ReAllocBuff(int dataSize, Bool CopyData) { 
  byte* newBuff;
  if(dataSize <= fTempSize) return;
  newBuff = new byte[ dataSize ];
  if( fTemp ) {
    if(CopyData) { memcpy(newBuff,fTemp,fTempSize); }
    delete[] ( fTemp );
  }
  fTempSize = dataSize;
  fTemp = newBuff;
}

void TMsgBuff::UnPack( void* data, int nItems, MPI_Datatype type ) {
	MPI_Unpack( fTemp, fTempSize, &fMemPtr, data, nItems, type,  fComm);
}

int TMsgBuff::Pack( const void* data, int nItems, MPI_Datatype type) {
  int size;
  MPI_Pack_size( nItems, type, fComm, &size );
  CheckBufferSize( fMemPtr+size );
  MPI_Pack( (void*)data, nItems, type, fTemp, fTempSize, &fMemPtr, fComm);
  fDataSize = fMemPtr;
  return fMemPtr;
}
  
void TMsgBuff::Send(int type,int dest) { 
  MPI_Send(fTemp,fMemPtr,MPI_PACKED,dest,type,fComm);
  Clear();
}

MPI_Request TMsgBuff::ISend(int type,int dest) { 
  MPI_Request request;
  MPI_Isend(fTemp,fMemPtr,MPI_PACKED,dest,type,fComm, &request);
  Clear();
  return request;
}

void TMsgBuff::BCast( int root ) { 
	MPI_Bcast(&fMemPtr,1,MPI_INT,root,fComm);
  if( gIProc != root ) { CheckBufferSize(fMemPtr, 0 ); }
  MPI_Bcast(fTemp,fMemPtr,MPI_PACKED,root,fComm);
  Clear();
}

/* 
MPI_Status TMsgBuff::Recv( int tag, int src ) {
  MPI_Status status;
    MPI_Irecv( &value, 1, MPI_FLOAT, MPI_ANY_SOURCE, kRemoteValueTag, fComm, &request ); 
    MPI_Wait(&request,&status); 
  }
  return value;
*/

MPI_Status TMsgBuff::Recv( int tag, int src ) {
  MPI_Status status;
	Clear();
  MPI_Probe(src,tag,fComm,&status);
  int size;
  MPI_Get_count(&status,MPI_BYTE,&size);
  CheckBufferSize(size,False);
  MPI_Recv(fTemp,fTempSize,MPI_BYTE,src,tag,fComm,&status);
  fDataSize = size;
  return status;
}

MPI_Status TMsgBuff::RecvAppend( int tag, int src ) {
  MPI_Status status;
  fMemPtr = 0;
  MPI_Probe(src,tag,fComm,&status);
  int size;
  MPI_Get_count(&status,MPI_BYTE,&size);
  CheckBufferSize( fMemPtr + size );
  MPI_Recv(fTemp+fMemPtr, fTempSize-fMemPtr, MPI_BYTE, src, tag, fComm, &status);
  fDataSize += size;
  return status;
}

#endif
