#include "PathString.h"
#include "Environ.h"

byte CPathString::kNoData = 255;

CPathString::CPathString() { 
	memset(fInfo,0,8); 		
	SetSep();
}

CPathString::CPathString(const CString& path) { 
	memset(fInfo,0,8); 
	SetSep();
	Add(path); 
}

void CPathString::SetSep() {
	switch( Env::OSType() ) {
		case Env::kUnix: fSeparator = '/'; break;
		case Env::kMac: fSeparator = ':'; break;
		case Env::kDOS: fSeparator = '\\'; break;
	}
}

Bool CPathString::FullPath(const CString& path) const {
	switch( Env::OSType() ) {
		case Env::kUnix: return ( path[0] == '/' );
		case Env::kMac: return ( path[0] != ':' );
		case Env::kDOS: return ( path[1] == ':' );
	}
}

CPathString::CPathString(const CPathString& s) { 
	StringPlex::operator= (s);
	fSeparator = s.fSeparator;
	fDrive = s.fDrive;
	memcpy(fInfo,s.fInfo,8);
}

void CPathString::Add( const char* pathElem ) {
	TString x(pathElem);
	int fp = FullPath(x);
	if( fp ) { 
		clear(); 
		if( Env::OSType() == Env::kDOS ) {
			fDrive = x[0];
			x.del(0,2);
		}
	}		
	int sl = x.length();
	int pos = 0;
	while (pos < sl) {
		int p = x.index( fSeparator, pos );
		if ( p < 0 ) { p = sl; }
		if ( p > pos ) {
			CString s( x( pos, p-pos ) );
			add( s );
		}
		pos = p + 1;
	}
}

const CString& CPathString::GeneratePath( int back_steps ) const {
	CString& path = (CString&)fPath;
	switch( Env::OSType() ) {
		case Env::kUnix: path = "/"; break;
		case Env::kMac: path = ""; break;
		case Env::kDOS: path = fDrive; path += ":\\"; break;
	}
	int len = length() - back_steps;
	for( int i=0; i<len; i++ ) {
		path += (*this)[i];
		if( (i < length()-1) ) { path +=  fSeparator; }
	}
	return path;
}

int  CPathString::GeneratePath(CString& s) const {
	switch( Env::OSType() ) {
		case Env::kUnix: s = "/"; break;
		case Env::kMac: s = ""; break;
		case Env::kDOS: s = fDrive; s += ":\\"; break;
	}
	for( int i=0; i< length(); i++ ) {
		s += (*this)[i];
		if( (i < length()-1) ) { s +=  fSeparator; }
	}
	return length();
}

void CPathString::operator= (const CPathString& s) {
	StringPlex::operator= (s);
	fSeparator = s.fSeparator;
	fDrive = s.fDrive;
	memcpy(fInfo,s.fInfo,8);
}
