#ifndef __PixGrid__
#define __PixGrid__

#include "Point1.h"
#include "Point2.h"
#include "Region1.h"
#include "Region2.h"
#include "Environ.h"
#include <math.h>

//----------------------------------------------------------------------------------------
//						PixGrid
//----------------------------------------------------------------------------------------


class PixGrid : public Region2
{
  Pix* fData;
  
  public:
                         // Constructors

  PixGrid(int r0, int c0, int r1, int c1, int r_inc = 1, int c_inc = 1);
  PixGrid(const PixGrid& md);
  PixGrid(const Region2& r);
  inline PixGrid() : Region2() { fData = NULL; }
  
  inline int BSize() { return nelem()*sizeof(int); }
  inline int NElements() { return nelem(); }
  inline void SetFields(int r0, int c0, int r1, int c1, int bytes, int r_inc = 1, int c_inc = 1) 
  { setupper(r1,c1); setlower(r0,c0); setincrement(r_inc,c_inc); }        	  
  
  inline Pix Value( int ir, int ic ) const { 
#ifdef DEBUG
    if( !inside(ir,ic) ) { gPrintErr("Illegal Index");  return Pix(0); }
#endif
    return fData [ bindex(ir,ic) ];
  }
  inline Pix Value( const Point2& p  ) const { return Value(p(0),p(1)); }
  
  inline Pix SetValue( Pix value, int ir, int ic ) { 
#ifdef DEBUG
    if( !inside(ir,ic) )  { gPrintErr("Illegal Index"); return Pix(0); }
#endif
    return ( fData [ bindex(ir,ic) ] = value );
  }
  
  inline void Alloc(Region2& r) {
    ((Region2&)(*this)) = r;
    if(fData) delete[] fData;
    fData = new Pix[nelem()];
  }
  inline void Alloc() {
    if(fData) delete[] fData;
    fData = new Pix[nelem()];
  }
  inline void Set ( Pix p ) { for(int i=0; i<nelem(); i++ ) fData[i] = p; }  
  void ReAlloc(int r0, int c0, int r1, int c1, int r_inc = -1, int c_inc = -1);
  void ReAlloc( const Region2& r );
  void CopyData( Pix* data, const Region2& r);
};

#endif
