#ifdef __GNUG__
#pragma implementation
#endif
// #include <builtin.h>
#include "PixVec.h"
#include "Environ.h"

// error handling
Pix  PixVec::fGarbage = 0;

void PixVec::error(const char* msg)
{
  gFatal(msg);
}

void PixVec::range_error()
{
  gFatal("Index out of range.");
}

PixVec::PixVec(const PixVec& v)
{
  s = new Pix [len = v.len];
  Pix* top = &(s[len]);
  Pix* t = s;
  const Pix* u = v.s;
  while (t < top) *t++ = *u++;
   increment=100;
}

PixVec::PixVec(int l, Pix  fill_value)
{
  s = new Pix [len = l];
  Pix* top = &(s[len]);
  Pix* t = s;
  while (t < top) *t++ = fill_value;
   increment=100;
}

PixVec::PixVec(int l, int inc, Pix  fill_value)
{
  s = new Pix [len = l];
  Pix* top = &(s[len]);
  Pix* t = s;
  while (t < top) *t++ = fill_value;
   increment=inc;
}


PixVec& PixVec::operator = (const PixVec& v)
{
  if (this != &v)
  {
		if( len < v.len ) {
			delete [] s;
			s = new Pix [len = v.len];
		}
    Pix* top = &(s[len]);
    Pix* t = s;
    const Pix* u = v.s;
    while (t < top) *t++ = *u++;
  }
  return *this;
}

int PixVec::copy(const PixVec& v)
{
	int c_index = 0;
  if (this != &v)
  {
		if( len < v.len ) {
			delete [] s;
			s = new Pix [len = v.len];  fill(0);
		}
    Pix* top = &(s[len]);
    Pix* t = s;
    const Pix* u = v.s;
    int count=1;
    while (t < top) {
			if( *u == 0 ) { count = 0; }
			if( count ) { c_index++; }
			*t++ = *u++;
		}
  }
  return c_index;
}

void PixVec::apply(PixProcedure f)
{
  Pix* top = &(s[len]);
  Pix* t = s;
  while (t < top) (*f)(*t++);
}

// can't just realloc since there may be need for constructors/destructors
void PixVec::resize(int newl)
{
  Pix* news = new Pix [newl];
  Pix* p = news;
  int minl = (len < newl)? len : newl;
  Pix* top = &(s[minl]);
  Pix* t = s;
  while (t < top) *p++ = *t++;
  delete [] s;
  s = news;
  len = newl;
}

PixVec concat(PixVec & a, PixVec & b)
{
  int newl = a.len + b.len;
  Pix* news = new Pix [newl];
  Pix* p = news;
  Pix* top = &(a.s[a.len]);
  Pix* t = a.s;
  while (t < top) *p++ = *t++;
  top = &(b.s[b.len]);
  t = b.s;
  while (t < top) *p++ = *t++;
  return PixVec(newl, news);
}


PixVec combine(PixCombiner f, PixVec& a, PixVec& b)
{
  int newl = (a.len < b.len)? a.len : b.len;
  Pix* news = new Pix [newl];
  Pix* p = news;
  Pix* top = &(a.s[newl]);
  Pix* t = a.s;
  Pix* u = b.s;
  while (t < top) *p++ = (*f)(*t++, *u++);
  return PixVec(newl, news);
}

Pix PixVec::reduce(PixCombiner f, Pix  base)
{
  Pix r = base;
  Pix* top = &(s[len]);
  Pix* t = s;
  while (t < top) r = (*f)(r, *t++);
  return r;
}

PixVec reverse(PixVec& a)
{
  Pix* news = new Pix [a.len];
  if (a.len != 0)
  {
    Pix* lo = news;
    Pix* hi = &(news[a.len - 1]);
    while (lo < hi)
    {
      Pix tmp = *lo;
      *lo++ = *hi;
      *hi-- = tmp;
    }
  }
  return PixVec(a.len, news);
}

void PixVec::reverse()
{
  if (len != 0)
  {
    Pix* lo = s;
    Pix* hi = &(s[len - 1]);
    while (lo < hi)
    {
      Pix tmp = *lo;
      *lo++ = *hi;
      *hi-- = tmp;
    }
  }
}

void PixVec::qsort( int lo0, int hi0, PixPredicate pix_index, PixPrinter pix_printer ) {
	int lo = lo0;
	int hi = hi0;
	unsigned int mid;
	
#ifdef DEBUG
	if( (lo<0) || (hi>len) || (s[hi]==0) ) { gPrintErr(" index error in qsort " ); return; }
#endif

	if ( hi0 > lo0) 	{

		 /* Arbitrarily establishing partition element as the midpoint of
			* the array.
			*/
		 mid = (*pix_index)( s[ ( lo0 + hi0 ) / 2 ] );

		 // loop through the array until indices cross
		 while( lo <= hi ) {
				/* find the first element that is greater than or equal to 
				 * the partition element starting from the left Index.
				 */
			 while( ( lo < hi0 ) &&  ( (*pix_index)( s[lo] ) < mid )) ++lo;

				/* find an element that is smaller than or equal to 
				 * the partition element starting from the right Index.
				 */
			 while( ( hi > lo0 ) &&  ( (*pix_index)( s[hi] ) > mid )) --hi;

				// if the indexes have not crossed, swap
				if( lo <= hi )  	{
					if( pix_printer != NULL ) { 
					  (*pix_printer)( s[lo], s[hi] ); 
					}
					 Pix tp = s[lo];
					 s[lo] = s[hi];
					 s[hi] = tp;
					 ++lo;
					 --hi;
				}
		 }

		 /* If the right index has not reached the left side of array
			* must now sort the left partition.
			*/
		 if( lo0 < hi ) qsort( lo0, hi, pix_index );

		 /* If the left index has not reached the right side of array
			* must now sort the right partition.
			*/
		 if( lo < hi0 ) qsort( lo, hi0, pix_index );

	}


}

int PixVec::index(Pix  targ)
{
  for (int i = 0; i < len; ++i) if ( targ == s[i] ) return i;
  return -1;
}

PixVec map(PixMapper f, PixVec& a)
{
  Pix* news = new Pix [a.len];
  Pix* p = news;
  Pix* top = &(a.s[a.len]);
  Pix* t = a.s;
  while(t < top) *p++ = (*f)(*t++);
  return PixVec(a.len, news);
}

int operator == (PixVec& a, PixVec& b)
{
  if (a.len != b.len)
    return 0;
  Pix* top = &(a.s[a.len]);
  Pix* t = a.s;
  Pix* u = b.s;
  while (t < top) if (!(*t++ == *u++)) return 0;
  return 1;
}

int PixVec::fill(Pix  val, int from, int n)
{
  int to;
  if (n < 0) { 
		if(len <= 0) return 0;
		else to = len - 1; 
	}
  else { to = from + n - 1; }
  if ((unsigned)from > (unsigned)to) range_error();
  if( to >= len ) resize(to+1);
  Pix* t = &(s[from]);
  Pix* top = &(s[to]);
  while (t <= top) *t++ = val;
  return to - from;
}

PixVec PixVec::at(int from, int n)
{
  int to;
  if (n < 0)
  {
    n = len - from;
    to = len - 1;
  }
  else
    to = from + n - 1;
  if ((unsigned)from > (unsigned)to)
    range_error();
  Pix* news = new Pix [n];
  Pix* p = news;
  Pix* t = &(s[from]);
  Pix* top = &(s[to]);
  while (t <= top) *p++ = *t++;
  return PixVec(n, news);
}

PixVec merge(PixVec & a, PixVec & b, PixComparator f)
{
  int newl = a.len + b.len;
  Pix* news = new Pix [newl];
  Pix* p = news;
  Pix* topa = &(a.s[a.len]);
  Pix* as = a.s;
  Pix* topb = &(b.s[b.len]);
  Pix* bs = b.s;

  for (;;)
  {
    if (as >= topa)
    {
      while (bs < topb) *p++ = *bs++;
      break;
    }
    else if (bs >= topb)
    {
      while (as < topa) *p++ = *as++;
      break;
    }
    else if ((*f)(*as, *bs) <= 0)
      *p++ = *as++;
    else
      *p++ = *bs++;
  }
  return PixVec(newl, news);
}

