#ifndef _included_Point1_h
#define _included_Point1_h

/*
*************************************************************************
*									*
* Class Point1								*
*									*
* The class implements a simple 1-dimensional integer vector.	*
* This class defines the normal operations of +, -, and so on.		*
*									*
*************************************************************************
*/

class Point1
  {
   protected:

   int p[1];

   /*
     Constructor and destructor for class Point1 -- inline these
   */

public:
   inline Point1() { }

   inline Point1(const int i) { p[0] = i; }

   inline Point1(const Point1& rhs)
     {
      p[0] = rhs.p[0];
      
      
      
     }
   inline Point1& operator = (const Point1& rhs)
     {
      p[0] = rhs.p[0];
      
      
      
      return(*this);
     }

   inline ~Point1() { }

   /*
     Some simple operators on points -- const and non-const ones
   */
   
   inline int& operator () (const int i) { return(p[i]); }
   inline int operator () (const int i) const { return(p[i]); }
   inline operator int * () { return(p); }
   inline operator const int * () const { return(p); }
   inline void Set(const int i) { p[0] = i; }

   /*
     Define all of the operators between two points
   */

#define Point_Point_Operator(ope,op)				\
   inline Point1& operator ope (const Point1& rhs)		\
     {								\
      p[0] ope rhs.p[0];					\
      		\
      		\
      		\
      return(*this);						\
     }								\
   inline Point1 operator op (const Point1& rhs) const		\
     {								\
      Point1 point = *this;					\
      point ope rhs;						\
      return(point);						\
     }
   Point_Point_Operator(+=,+)
   Point_Point_Operator(-=,-)
   Point_Point_Operator(*=,*)
   Point_Point_Operator(/=,/)
   Point_Point_Operator(%=,%)
#undef Point_Point_Operator

   /*
     Define all of the operators between a point and an integer
   */

#define Point_Scalar_Operator(ope,op)				\
   inline Point1& operator ope (const int rhs) 			\
     {								\
      p[0] ope rhs;						\
      			\
      			\
      			\
      return(*this);						\
     }								\
   inline Point1 operator op (const int rhs) const		\
     {								\
      Point1 point = *this;					\
      point ope rhs;						\
      return(point);						\
     }
   Point_Scalar_Operator(+=,+)
   Point_Scalar_Operator(-=,-)
   Point_Scalar_Operator(*=,*)
   Point_Scalar_Operator(/=,/)
   Point_Scalar_Operator(%=,%)
#undef Point_Scalar_Operator

   /*
     Define the negation operator for a point
   */

   inline Point1 operator - () const
     {
      Point1 point;
      point.p[0] = -p[0];
      
      
      
      return(point);
     }

   /*
     Define the equality and inequality operators for points
   */

   inline int operator == (const Point1& rhs) const
     {
      return((p[0] == rhs.p[0])
             
             
             
            );
     }

   inline int operator != (const Point1& rhs) const
     { return(!(*this == rhs)); }

   /*
     Define elementwise minimum and maximum functions for points
   */

   inline void min(const Point1& rhs)
     {
      if (rhs.p[0] < p[0]) p[0] = rhs.p[0];
      
      
      
     }
   inline void max(const Point1& rhs)
     {
      if (rhs.p[0] > p[0]) p[0] = rhs.p[0];
      
      
      
     }
  };

#endif
