#ifndef _included_Point2_h
#define _included_Point2_h

/*
*************************************************************************
*									*
* Class Point2								*
*									*
* The class implements a simple 2-dimensional integer vector.	*
* This class defines the normal operations of +, -, and so on.		*
*									*
*************************************************************************
*/

class Point2
  {
   protected:

   int p[2];

   /*
     Constructor and destructor for class Point2 -- inline these
   */

public:
  inline Point2() { p[0] = -1; p[1] = -1; }
  inline Point2(const int i) { p[0] = i; p[1] = i; }
  inline Point2(const int i, const int j)  { p[0] = i; p[1] = j; }

   inline Point2(const Point2& rhs)
     {
      p[0] = rhs.p[0];
      p[1] = rhs.p[1];
      
      
     }
   inline Point2& operator = (const Point2& rhs)
     {
      p[0] = rhs.p[0];
      p[1] = rhs.p[1];
      
      
      return(*this);
     }

   inline ~Point2() { }

   /*
     Some simple operators on points -- const and non-const ones
   */
   
   inline int& elem(const int i) { return(p[i]); }
   inline int operator () (const int i) const { return(p[i]); }
//   inline operator int * () { return(p); }
   inline operator const int * () const { return(p); }

   /*
     Define all of the operators between two points
   */

#define Point_Point_Operator(ope,op)				\
   inline Point2& operator ope (const Point2& rhs)		\
     {								\
      p[0] ope rhs.p[0];					\
      p[1] ope rhs.p[1];		\
      		\
      		\
      return(*this);						\
     }								\
   inline Point2 operator op (const Point2& rhs) const		\
     {								\
      Point2 point = *this;					\
      point ope rhs;						\
      return(point);						\
     }
   Point_Point_Operator(+=,+)
   Point_Point_Operator(-=,-)
   Point_Point_Operator(*=,*)
   Point_Point_Operator(/=,/)
   Point_Point_Operator(%=,%)
#undef Point_Point_Operator

   /*
     Define all of the operators between a point and an integer
   */

#define Point_Scalar_Operator(ope,op)				\
   inline Point2& operator ope (const int rhs) 			\
     {								\
      p[0] ope rhs;						\
      p[1] ope rhs;			\
      			\
      			\
      return(*this);						\
     }								\
   inline Point2 operator op (const int rhs) const		\
     {								\
      Point2 point = *this;					\
      point ope rhs;						\
      return(point);						\
     }
   Point_Scalar_Operator(+=,+)
   Point_Scalar_Operator(-=,-)
   Point_Scalar_Operator(*=,*)
   Point_Scalar_Operator(/=,/)
   Point_Scalar_Operator(%=,%)
#undef Point_Scalar_Operator


   /*
     Define the equality and inequality operators for points
   */

   inline int operator == (const Point2& rhs) const
     {
      return((p[0] == rhs.p[0])
             && (p[1] == rhs.p[1])
             
             
            );
     }

   inline int operator != (const Point2& rhs) const
     { return(!(*this == rhs)); }

   /*
     Define elementwise minimum and maximum functions for points
   */

   inline void min(const Point2& rhs)
     {
      if (rhs.p[0] < p[0]) p[0] = rhs.p[0];
      if (rhs.p[1] < p[1]) p[1] = rhs.p[1];
      
      
     }
   inline void max(const Point2& rhs)
     {
      if (rhs.p[0] > p[0]) p[0] = rhs.p[0];
      if (rhs.p[1] > p[1]) p[1] = rhs.p[1];
      
      
     }
  };

#endif
