#ifndef _included_Point3_h
#define _included_Point3_h

/*
*************************************************************************
*									*
* Point3.h								*
*									*
* Class Point3 implements a simple integer point in 3-dimensional	*
* space.								*
*									*
* Author:  Scott Kohn (skohn-at-cs.ucsd.edu)				*
*									*
*************************************************************************
*/

// #include <iostream.h>

/*
*************************************************************************
*									*
* Class Point3								*
*									*
* The class implements a simple 3-dimensional integer vector.	*
* This class defines the normal operations of +, -, and so on.		*
*									*
*************************************************************************
*/

class Point3
  {
   protected:

   int p[3];

   /*
     Constructor and destructor for class Point3 -- inline these
   */

public:
   inline Point3() { }

   inline Point3(const int i) { p[0] = p[1] = p[2] = i; }
   inline Point3(const int i, const int j, const int k)
     { p[0] = i; p[1] = j; p[2] = k; }

   inline Point3(const Point3& rhs)
     {
      p[0] = rhs.p[0];
      p[1] = rhs.p[1];
      p[2] = rhs.p[2];
      
     }
   inline Point3& operator = (const Point3& rhs)
     {
      p[0] = rhs.p[0];
      p[1] = rhs.p[1];
      p[2] = rhs.p[2];
      
      return(*this);
     }
   inline void Set (int i0, int i1=0)
     {
      p[0] = i0;
      p[1] = i1;
     }
   inline ~Point3() { }

   /*
     Some simple operators on points -- const and non-const ones
   */
   
   inline int& operator () (const int i) { return(p[i]); }
   inline int operator () (const int i) const { return(p[i]); }
   inline operator int * () { return(p); }
   inline operator const int * () const { return(p); }

   /*
     Define all of the operators between two points
   */

#define Point_Point_Operator(ope,op)				\
   inline Point3& operator ope (const Point3& rhs)		\
     {								\
      p[0] ope rhs.p[0];					\
      p[1] ope rhs.p[1];		\
      p[2] ope rhs.p[2];		\
      		\
      return(*this);						\
     }								\
   inline Point3 operator op (const Point3& rhs) const		\
     {								\
      Point3 point = *this;					\
      point ope rhs;						\
      return(point);						\
     }
   Point_Point_Operator(+=,+)
   Point_Point_Operator(-=,-)
   Point_Point_Operator(*=,*)
   Point_Point_Operator(/=,/)
   Point_Point_Operator(%=,%)
#undef Point_Point_Operator

   /*
     Define all of the operators between a point and an integer
   */

#define Point_Scalar_Operator(ope,op)				\
   inline Point3& operator ope (const int rhs) 			\
     {								\
      p[0] ope rhs;						\
      p[1] ope rhs;			\
      p[2] ope rhs;			\
      			\
      return(*this);						\
     }								\
   inline Point3 operator op (const int rhs) const		\
     {								\
      Point3 point = *this;					\
      point ope rhs;						\
      return(point);						\
     }
   Point_Scalar_Operator(+=,+)
   Point_Scalar_Operator(-=,-)
   Point_Scalar_Operator(*=,*)
   Point_Scalar_Operator(/=,/)
   Point_Scalar_Operator(%=,%)
#undef Point_Scalar_Operator

   /*
     Define the negation operator for a point
   */

   inline Point3 operator - () const
     {
      Point3 point;
      point.p[0] = -p[0];
      point.p[1] = -p[1];
      point.p[2] = -p[2];
      
      return(point);
     }

   /*
     Define the equality and inequality operators for points
   */

   inline int operator == (const Point3& rhs) const
     {
      return((p[0] == rhs.p[0])
             && (p[1] == rhs.p[1])
             && (p[2] == rhs.p[2])
             
            );
     }

   inline int operator != (const Point3& rhs) const
     { return(!(*this == rhs)); }

   /*
     Define elementwise minimum and maximum functions for points
   */

   inline void min(const Point3& rhs)
     {
      if (rhs.p[0] < p[0]) p[0] = rhs.p[0];
      if (rhs.p[1] < p[1]) p[1] = rhs.p[1];
      if (rhs.p[2] < p[2]) p[2] = rhs.p[2];
      
     }
   inline void max(const Point3& rhs)
     {
      if (rhs.p[0] > p[0]) p[0] = rhs.p[0];
      if (rhs.p[1] > p[1]) p[1] = rhs.p[1];
      if (rhs.p[2] > p[2]) p[2] = rhs.p[2];
      
     }
  };

#endif
