
/*
*************************************************************************
*									*
* Region1.C								*
*									*
* Class Region1 implements an 1-dimensional region of  space.	*
* A region is considered empty if any of the elements of the upper	*
* bound is less than the corresponding element of the lower bound.	*
*									*
*									*
*************************************************************************
*/

#include "Region1.h"

#define MATCH(s, c) while ((s).get() != (c))

/*
*************************************************************************
*									*
* Region1& Region1::operator += (const Region1& rhs)			*
* int Region1::operator == (const Region1& rhs) const			*
*									*
* These operators were not inlined because they can generate quite a	*
* bit of code.								*
*									*
*************************************************************************
*/

Region1& Region1::operator += (const Region1& rhs)
  {
   if (empty()) return(*this = rhs);
   if (rhs.empty()) return(*this);
   lwp.min(rhs.lwp);
   upp.max(rhs.upp);
   return(*this);
  }

int Region1::operator == (const Region1& rhs) const
  {
   return(((upp == rhs.upp) && (lwp == rhs.lwp)) || (empty() && rhs.empty()));
  }

/*
*************************************************************************
*									*
* The accrete() and grow() functions increase the size of a region.	*
* Both accrete() and grow() do the same thing.  The CC compiler had	*
* some trouble inlining them, so we define them here.			*
*									*
*************************************************************************
*/

Region1 accrete(const Region1& region, const Point1& p)
  {
   if (region.empty()) return(region);
   return(Region1(region.lower()-p, region.upper()+p));
  }

Region1 grow(const Region1& region, const Point1& p)
  {
   if (region.empty()) return(region);
   return(Region1(region.lower()-p, region.upper()+p));
  }

Region1 accrete(const Region1& region, const int c)
  {
   if (region.empty()) return(region);
   return(Region1(region.lower()-c, region.upper()+c));
  }

Region1 grow(const Region1& region, const int c)
  {
   if (region.empty()) return(region);
   return(Region1(region.lower()-c, region.upper()+c));
  }

Region1* accrete(const Region1 *const region, const int n, const int c)
  {
   Region1 *accreted = new Region1[n];
   for (int i = 0; i < n; i++) accreted[i] = accrete(region[i], c);
   return(accreted);
  }

Region1* grow(const Region1 *const region, const int n, const int c)
  {
   Region1 *grown = new Region1[n];
   for (int i = 0; i < n; i++) grown[i] = grow(region[i], c);
   return(grown);
  }

Region1* accrete(const Region1 *const region, const int n, const Point1& p)
  {
   Region1 *accreted = new Region1[n];
   for (int i = 0; i < n; i++) accreted[i] = accrete(region[i], p);
   return(accreted);
  }

Region1* grow(const Region1 *const region, const int n, const Point1& p)
  {
   Region1 *grown = new Region1[n];
   for (int i = 0; i < n; i++) grown[i] = grow(region[i], p);
   return(grown);
  }
