#ifndef _included_Region1_h
#define _included_Region1_h

#include "Point1.h"

#ifndef LOWERBOUND
#define LOWERBOUND (-1000000000)
#endif
#ifndef UPPERBOUND
#define UPPERBOUND ( 1000000000)
#endif

class Region1
  {
   Point1 lwp, upp, inc;

   /*
     Constructors and destructor for class Region1 -- inline these
   */

public:

   inline Region1() : lwp(UPPERBOUND), upp(LOWERBOUND), inc(1) { }

   inline Region1(const Point1& l, const Point1& u) : lwp(l), upp(u) { }
   inline Region1(const int i, const int ii)
     : lwp(i), upp(ii) { }
   inline Region1(const Region1& r) { lwp = r.lwp; upp = r.upp; }
   inline Region1& operator = (const Region1& r)
     { lwp = r.lwp; upp = r.upp; return(*this); }
   inline ~Region1() { }
   
   /*
     Functions which modify regions -- lower and upper bounds
   */

   inline void setempty()
     {
      lwp(0) = UPPERBOUND; upp(0) = LOWERBOUND;
      
      
      
     }
   inline void setlower(const int i)
     {
      lwp(0) = i;
      
      
      
     }
   inline void setlower(const Point1& l) { lwp = l; }

   inline void setupper(const int i)
     {
      upp(0) = i;
      
      
      
     }
   inline void setupper(const Point1& u) { upp = u; }

   inline void setregion(const int i, const int ii)
     {
      setlower(i);
      setupper(ii);
     }
   inline void setregion(const Point1& l, const Point1& u) { lwp = l; upp = u; }
   inline void setregion(const Region1& r) { lwp = r.lwp; upp = r.upp; }

   /*
     Some simple inline access functions for class Region1
   */

   inline const Point1& lower() const { return(lwp); }
   inline const Point1& upper() const { return(upp); }
   inline int lower(const int i) const { return(lwp(i)); }
   inline int upper(const int i) const { return(upp(i)); }

   inline Point1& lower() { return(lwp); }
   inline Point1& upper() { return(upp); }
   inline int& lower(const int i) { return(lwp(i)); }
   inline int& upper(const int i) { return(upp(i)); }

   inline int extents(const int i) const { return(upp(i)-lwp(i)+1); }
   inline Point1 extents() const { return(upp-lwp+1); }

   /*
     Check to see if this region is empty -- check each of the elements
   */

   inline int empty() const
     {
      return((upp(0) < lwp(0))
             
             
             
            );
     }
   inline int size() const
     {
      return(empty() ? 0 : (upp(0)-lwp(0)+1)
                           
                           
                           
            );
     }

   /*
     Define the bounding box operators + and += (bounding box union)
     Define the intersection operators * and *=
   */

   Region1& operator += (const Region1& rhs);
   inline Region1 operator + (const Region1& rhs) const
     {
      Region1 bbox(*this);
      bbox += rhs;
      return(bbox);
     }
   inline Region1& operator *= (const Region1& rhs)
     {
      lwp.max(rhs.lwp);
      upp.min(rhs.upp);
      return(*this);
     }
   inline Region1 operator * (const Region1& rhs) const
     {
      Region1 both(*this);
      both.lwp.max(rhs.lwp);
      both.upp.min(rhs.upp);
      return(both);
     }

   /*
     Define the comparison operators == and !=
   */

   int operator == (const Region1& rhs) const;
   inline int operator != (const Region1& rhs) const
     { return(!(*this == rhs)); }

   /*
     Member functions inside() return whether a point is inside the region
   */

   inline int inside(const int i) const
     {
      return(((i >= lwp(0)) && (i <= upp(0)))
             
             
             
            );
     }
   inline int inside(const Point1& p) const
     {
      return(Region1::inside(p(0)));
      
      
      
     }

   /*
     Member function accrete() (also grow()) which grows a region
   */

   inline void accrete(const Point1& p)
     { if (!empty()) { lwp -= p; upp += p; } }
   inline void grow(const Point1& p)
     { if (!empty()) { lwp -= p; upp += p; } }
   inline void accrete(const int i)
     { if (!empty()) { lwp -= i; upp += i; } }
   inline void grow(const int i)
     { if (!empty()) { lwp -= i; upp += i; } }

   inline void expand(const int index, const int buf=0) { 
     if (!empty()) { 
       if( index < lwp(0) ) lwp(0) = index-buf; 
       if( index > upp(0) ) upp(0) = index+buf; 
     }
   }
 
};

/*
  Function accrete() increases or decreases the size of the region
*/

Region1 accrete(const Region1& region, const Point1& p);
Region1 grow(const Region1& region, const Point1& p);
Region1 accrete(const Region1& region, const int c);
Region1 grow(const Region1& region, const int c);
Region1* accrete(const Region1 *const region, const int n, const int c);
Region1* grow(const Region1 *const region, const int n, const int c);
Region1* accrete(const Region1 *const region, const int n, const Point1& p);
Region1* grow(const Region1 *const region, const int n, const Point1& p);


/*
  Function shift() shifts the  space of the region
*/

inline Region1 shift(const Region1& region, const Point1& p)
  { return(Region1(region.lower()+p, region.upper()+p)); }


#endif
