/*
*************************************************************************
*									*
* Region2.cc								*
*									*
* Class Region2 implements an 2-dimensional region of  space.	*
* A region is considered empty if any of the elements of the upper	*
* bound is less than the corresponding element of the lower bound.	*
*									*
* Authors:  Scott Kohn (skohn-at-cs.ucsd.edu)				*
*           Tom Maxwell: added inc: Variable increments in dims.	*
*************************************************************************
*/

#include "Region2.h"

/*
*************************************************************************
*									*
* Region2& Region2::operator += (const Region2& rhs)			*
* int Region2::operator == (const Region2& rhs) const			*
*									*
* These operators were not inlined because they can generate quite a	*
* bit of code.								*
*									*
*************************************************************************
*/

Region2& Region2::operator += (const Region2& rhs)
  {
   if (empty()) return(*this = rhs);
   if (rhs.empty()) return(*this);
   lwp.min(rhs.lwp);
   upp.max(rhs.upp);
   return(*this);
  }

int Region2::operator == (const Region2& rhs) const
  {
   return(((upp == rhs.upp) && (lwp == rhs.lwp) && (inc == rhs.inc))  || (empty() && rhs.empty()));
  }

/*
*************************************************************************
*									*
* The accrete() and grow() functions increase the size of a region.	*
* Both accrete() and grow() do the same thing.  The CC compiler had	*
* some trouble inlining them, so we define them here.			*
*									*
*************************************************************************
*/

Region2 accrete(const Region2& region, const Point2& p)
  {
   if (region.empty()) return(region);
   return(Region2(region.lower()-p, region.upper()+p));
  }

Region2 grow(const Region2& region, const Point2& p)
  {
   if (region.empty()) return(region);
   return(Region2(region.lower()-p, region.upper()+p));
  }

Region2 accrete(const Region2& region, const int c)
  {
   if (region.empty()) return(region);
   return(Region2(region.lower()-c, region.upper()+c));
  }

Region2 grow(const Region2& region, const int c)
  {
   if (region.empty()) return(region);
   return(Region2(region.lower()-c, region.upper()+c));
  }

Region2* accrete(const Region2 *const region, const int n, const int c)
  {
   Region2 *accreted = new Region2[n];
   for (int i = 0; i < n; i++) accreted[i] = accrete(region[i], c);
   return(accreted);
  }

Region2* grow(const Region2 *const region, const int n, const int c)
  {
   Region2 *grown = new Region2[n];
   for (int i = 0; i < n; i++) grown[i] = grow(region[i], c);
   return(grown);
  }

Region2* accrete(const Region2 *const region, const int n, const Point2& p)
  {
   Region2 *accreted = new Region2[n];
   for (int i = 0; i < n; i++) accreted[i] = accrete(region[i], p);
   return(accreted);
  }

Region2* grow(const Region2 *const region, const int n, const Point2& p)
  {
   Region2 *grown = new Region2[n];
   for (int i = 0; i < n; i++) grown[i] = grow(region[i], p);
   return(grown);
  }
