/* DO NOT EDIT -- this file created by m4 */














#ifndef _included_Region3_h
#define _included_Region3_h

/*
*************************************************************************
*									*
* Region3.h								*
*									*
* Class Region3 Xmplements a 3-dimensional region of index space.	*
* A region is considered empty if any of the elements of the upper	*
* bound is less	then the corresponding element of the lower bound.	*
*									*
* Author:  Scott Kohn (skohn-at-cs.ucsd.edu)				*
*									*
*************************************************************************
*/

// #include <iostream.h>
#include "Point3.h"

#ifndef LOWERBOUND
#define LOWERBOUND (-1000000000)
#endif
#ifndef UPPERBOUND
#define UPPERBOUND ( 1000000000)
#endif

class Region3
  {
   Point3 lwp, upp;

   /*
     Constructors and destructor for class Region3 -- inline these
   */

public:

   inline Region3() : lwp(UPPERBOUND,UPPERBOUND,UPPERBOUND),
                      upp(LOWERBOUND,LOWERBOUND,LOWERBOUND) { }

   inline Region3(const Point3& l, const Point3& u) : lwp(l), upp(u) { }
   inline Region3(const int i,  const int j,  const int k, const int ii, const int jj, const int kk)
     : lwp(i,  j,  k), upp(ii, jj, kk) { }
   inline Region3(const Region3& r) { lwp = r.lwp; upp = r.upp; }
   inline Region3& operator = (const Region3& r)
     { lwp = r.lwp; upp = r.upp; return(*this); }
   inline ~Region3() { }
   
   /*
     Functions which modify regions -- lower and upper bounds
   */

   inline void setempty()
     {
      lwp(0) = UPPERBOUND; upp(0) = LOWERBOUND;
      lwp(1) = UPPERBOUND; upp(1) = LOWERBOUND;
      lwp(2) = UPPERBOUND; upp(2) = LOWERBOUND;
      
     }
   inline void setlower(const int i,  const int j,  const int k)
     {
      lwp(0) = i;
      lwp(1) = j;
      lwp(2) = k;
      
     }
   inline void setlower(const Point3& l) { lwp = l; }

   inline void setupper(const int i,  const int j,  const int k)
     {
      upp(0) = i;
      upp(1) = j;
      upp(2) = k;
      
     }
   inline void setupper(const Point3& u) { upp = u; }

   inline void setregion(const int i,  const int j,  const int k, const int ii, const int jj, const int kk)
     {
      setlower(i,  j,  k);
      setupper(ii, jj, kk);
     }
   inline void setregion(const Point3& l, const Point3& u) { lwp = l; upp = u; }
   inline void setregion(const Region3& r) { lwp = r.lwp; upp = r.upp; }

   /*
     Some simple inline access functions for class Region3
   */

   inline const Point3& lower() const { return(lwp); }
   inline const Point3& upper() const { return(upp); }
   inline int lower(const int i) const { return(lwp(i)); }
   inline int upper(const int i) const { return(upp(i)); }

   inline Point3& lower() { return(lwp); }
   inline Point3& upper() { return(upp); }
   inline int& lower(const int i) { return(lwp(i)); }
   inline int& upper(const int i) { return(upp(i)); }

   inline int extents(const int i) const { return(upp(i)-lwp(i)+1); }
   inline Point3 extents() const { return(upp-lwp+1); }

   /*
     Check to see if this region is empty -- check each of the elements
   */

   inline int empty() const
     {
      return((upp(0) < lwp(0))
             || (upp(1) < lwp(1))
             || (upp(2) < lwp(2))
             
            );
     }
   inline int size() const
     {
      return(empty() ? 0 : (upp(0)-lwp(0)+1)
                           * (upp(1)-lwp(1)+1)
                           * (upp(2)-lwp(2)+1)
                           
            );
     }

   /*
     Define the bounding box operators + and += (bounding box union)
     Define the intersection operators * and *=
   */

   Region3& operator += (const Region3& rhs);
   inline Region3 operator + (const Region3& rhs) const
     {
      Region3 bbox(*this);
      bbox += rhs;
      return(bbox);
     }
   inline Region3& operator *= (const Region3& rhs)
     {
      lwp.max(rhs.lwp);
      upp.min(rhs.upp);
      return(*this);
     }
   inline Region3 operator * (const Region3& rhs) const
     {
      Region3 both(*this);
      both.lwp.max(rhs.lwp);
      both.upp.min(rhs.upp);
      return(both);
     }

   /*
     Define the comparison operators == and !=
   */

   int operator == (Region3 const & rhs) const;
   inline int operator != (const Region3& rhs) const
     { return(!(*this == rhs)); }

   /*
     Member functions inside() return whether a point is inside the region
   */

   inline int inside(const int i,  const int j,  const int k) const
     {
      return(((i >= lwp(0)) && (i <= upp(0)))
             && ((j >= lwp(1)) && (j <= upp(1)))
             && ((k >= lwp(2)) && (k <= upp(2)))
             
            );
     }
   inline int inside(const Point3& p) const
     {
      
      
      return(Region3::inside(p(0), p(1), p(2)));
      
     }

   /*
     Member function accrete() (also grow()) which grows a region
   */

   inline void accrete(const Point3& p)
     { if (!empty()) { lwp -= p; upp += p; } }
   inline void grow(const Point3& p)
     { if (!empty()) { lwp -= p; upp += p; } }
   inline void accrete(const int i)
     { if (!empty()) { lwp -= i; upp += i; } }
   inline void grow(const int i)
     { if (!empty()) { lwp -= i; upp += i; } }
  };

/*
  Function accrete() increases or decreases the size of the region
*/

Region3 accrete(const Region3& region, const Point3& p);
Region3 grow(const Region3& region, const Point3& p);
Region3 accrete(const Region3& region, const int c);
Region3 grow(const Region3& region, const int c);
Region3* accrete(const Region3 *const region, const int n, const int c);
Region3* grow(const Region3 *const region, const int n, const int c);
Region3* accrete(const Region3 *const region, const int n, const Point3& p);
Region3* grow(const Region3 *const region, const int n, const Point3& p);

/*
  Function shift() shifts the index space of the region
*/

inline Region3 shift(const Region3& region, const Point3& p)
  { return(Region3(region.lower()+p, region.upper()+p)); }

#endif
