//----------------------------------------------------------------------------------------
  //	SList.cc
  //	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
  //	Change History:
  //----------------------------------------------------------------------------------------
  
#include "SList.h"

//========================================================================================
// 								CLASS TNamedObjectList
//========================================================================================
  
int TNamedObjectList::fCount = 0; 
CString TNamedObjectList::fDbgStr; 
int TNamedObjectList::kNoFastFind = -2;
int TNamedObjectList::kUseCount = -1;

//----------------------------------------------------------------------------------------
//			TNamedObjectList::TNamedObjectList:
//----------------------------------------------------------------------------------------
  
TNamedObjectList::TNamedObjectList( char* listName, int size, int listIndex  ) : TOrderedObjectDLList(size)
{
  fListName = listName; 
  if( listIndex == kNoFastFind ) fListIndex = -1;
  else if( listIndex == kUseCount ) fListIndex = fCount++;
  else fListIndex = listIndex;
  
}  // TNamedObjectList::TNamedObjectList

TNamedObjectList::TNamedObjectList( const CString& s, int size, int listIndex  ) : TOrderedObjectDLList(size)
{
  fListName = s; 
  if( listIndex == kNoFastFind ) fListIndex = -1;
  else if( listIndex == kUseCount ) fListIndex = fCount++;
  else fListIndex = listIndex;
  
}  // TNamedObjectList::TNamedObjectList
 
TNamedObjectList::TNamedObjectList(int size, int listIndex ) : TOrderedObjectDLList(size) { 
  if( listIndex == kNoFastFind ) fListIndex = -1;
  else if( listIndex == kUseCount ) fListIndex = fCount++;
  else fListIndex = listIndex;
}  // TNamedObjectList::TNamedObjectList

TNamedObjectList::TNamedObjectList(TNamedObjectList& list, int listIndex  ) : TOrderedObjectDLList(list) {
  fListName = list.fListName; 
  if( listIndex == kNoFastFind ) fListIndex = -1;
  else if( listIndex == kUseCount ) fListIndex = fCount++;
  else fListIndex = listIndex;
}  // TNamedObjectList::TNamedObjectList

void  TNamedObjectList::Init(char* listName)
{
  fListName = listName; 
  
}  // TNamedObjectList::TNamedObjectList

 
  //----------------------------------------------------------------------------------------
  //			TNamedObjectList::InsertObject:
  //----------------------------------------------------------------------------------------
  
Pix TNamedObjectList::InsertObject(TNamedObject& item)  
{
  Pix p = FindObjectFast(item);
  if ( p == 0 ) { 
    item.Register( p = append(item), fListIndex );
    if(gDebug) {      
      sprintf(gMsgStr,"\n List %d Insertion %s <- %s",  fListIndex, Name(), item.Name() );
      gPrintLog();
    }
  } else return 0;
  return p;
} // TNamedObjectList::InsertObject 
  
  //----------------------------------------------------------------------------------------
  //			TNamedObjectList::GetObject:
  //----------------------------------------------------------------------------------------
  
Pix TNamedObjectList::GetObjectByNameP(const char* name) const 
{
  for( Pix pt = first(); pt; next(pt) ) {
    const TNamedObject& aObj = (*this)(pt); 
    if( aObj.SName() == name ) return pt;
  }
  return 0;
} // TNamedObjectList::GetObject
  
  //----------------------------------------------------------------------------------------
  //			TNamedObjectList::GetObject:
  //----------------------------------------------------------------------------------------
  
Pix TNamedObjectList::GetObjectByNameP( const CString& name ) const 
{
  for( Pix pt = first(); pt; next(pt) ) {
    const TNamedObject& aObj = (*this)(pt); 
    if( aObj.SName() == name ) return pt;
  }
  return 0;
} // TNamedObjectList::GetObject
  
  
  //----------------------------------------------------------------------------------------
  //			TNamedObjectList::GetObject:
  //----------------------------------------------------------------------------------------
  
Pix TNamedObjectList::GetObjectByNameP( const char* name, int relativeIndex ) const 
{
  Pix p = GetObjectByName(name);
  if( p==0 || relativeIndex == 0 ) return p;
  if( relativeIndex > 0 ) {
    while( next(p) != 0 ) { if (relativeIndex-- == 0) return p; }
  }
  else if(relativeIndex < 0) {
    while( prev(p) != 0 ) { if (relativeIndex++ == 0) return p; }
  }
  return 0;  
} // TNamedObjectList::GetObject
   
  //----------------------------------------------------------------------------------------
  //				TNamedObjectList::Alphabetize:
  //----------------------------------------------------------------------------------------
  
void TNamedObjectList :: Alphabetize () {
    
startSort:
  for( Pix pt = first(); pt; next(pt) ) {
    const TNamedObject& aTargObj = (*this)(pt); 
    Pix p = pt;
    for( next(p); p; next(p)) {
      const TNamedObject& aObj = (*this)(p); 
      if( aTargObj.SName() > aObj.SName() ) {		
				Move(pt,p);  	// Move aObj in front of aTargObj
				goto startSort; 
      }
    }
  }
}  // TNamedObjectList :: Alphabetize 

//----------------------------------------------------------------------------------------
// TNamedObjectList::Dump: 
//----------------------------------------------------------------------------------------

void TNamedObjectList ::Dump(FILE* oFile) {
  if( oFile==NULL) oFile = Env::LogFile(); 
  fprintf(oFile,"\n ******* List Dump: %s **************\n",(const char*) fListName);
  int cnt=0;
  for( Pix pt = first(); pt; next(pt) ) {
    const TNamedObject& aTargObj = (*this)(pt); 
    fprintf(oFile,"(%d: %s) ",cnt++, aTargObj.Name());
    if( cnt % 10 == 0) fprintf(oFile,"\n");
    if( cnt == 200) break;
  }
  fprintf(oFile,"\n");
  fflush(oFile);
}

//----------------------------------------------------------------------------------------
  // TNamedObjectList::Move: 
  //----------------------------------------------------------------------------------------
   
  void TNamedObjectList::Move( Pix pt, Pix pm0, Pix pm1 )  	// Move pm in front of pt
{
  if( pt && pm0 ) {
    move( pt, pm0, pm1 );
    if(gDebug) {	
      sprintf(gMsgStr,"\nVariable(s) Moved in List %s, %s -> %s", Name(), Name(pm0), Name(pt) );
      gPrintLog();
    }
  }
 } // TNamedObjectList::Move
  
  //----------------------------------------------------------------------------------------
  // TNamedObjectList::Delete: 
  //----------------------------------------------------------------------------------------
  
void TNamedObjectList::Clear()  	
{
  clear();
  
} // TNamedObjectList::Delete

  //----------------------------------------------------------------------------------------
  // TNamedObjectList::Free: 
  //----------------------------------------------------------------------------------------
  
void TNamedObjectList::Free()  	
{
  free();
  
} // TNamedObjectList::Delete

 //----------------------------------------------------------------------------------------
  // TNamedObjectList::SortByLinks: 
  //----------------------------------------------------------------------------------------

unsigned int LinkRanker( TOrderedObjectDLListNode& n  ) {
  unsigned int rv=0, myIndex = n.Index();
  DLLinkIterator iter( &n  );
  for ( Pix p =  iter.first(); p; p= iter.next() ) {
    TOrderedObjectDLListNode* l  = (TOrderedObjectDLListNode*)p;
    if( iter.test_info() ) {
			if( l->Index() >= myIndex ) {
#ifdef DEBUG
				if( gDebug > 2 ) {
					TNamedObject& dep_obj = (TNamedObject&)(l->Object());
					TNamedObject& obj = (TNamedObject&)(n.Object());
					sprintf(gMsgStr,"%s->%s: rank: %u -> %u ", obj.Name(), dep_obj.Name(),  l->Index(), myIndex-1 ); gPrintLog();
				}
#endif
				l->SetIndex(myIndex-1); rv=1;
			}
#ifdef DEBUG
		 else {
 				if( gDebug > 4 ) {
					TNamedObject& dep_obj = (TNamedObject&)(l->Object());
					TNamedObject& obj = (TNamedObject&)(n.Object());
					sprintf(gMsgStr,"%s(%u)->%s(%u): rank OK ", obj.Name(), n.Index(), dep_obj.Name(), l->Index() ); gPrintLog();
				}
			}
#endif
		}
#ifdef DEBUG
	 else {
			if( gDebug > 3 ) {
				TNamedObject& dep_obj = (TNamedObject&)(l->Object());
				TNamedObject& obj = (TNamedObject&)(n.Object());
				sprintf(gMsgStr,"%s->%s inactivated! ", obj.Name(), dep_obj.Name() ); gPrintLog();
			}
		}
#endif
  }
  return rv;
}

int TNamedObjectList::SortByLinks () {
  return qsort( &LinkRanker );
}

int TNamedObjectList::IsLinkSortable () {
  return is_sortable( &LinkRanker );
}

Pix TNamedObjectList::FindObjectFast( TNamedObject& item ) { 
	if( fListIndex >= 0 ) return item.GetListPix(fListIndex);
	else return GetObjectByNameP(item.Name());
}



  
    
  
  
  
