//	DList.h
//----------------------------------------------------------------------------------------
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------
  
#ifndef __DList__
#define __DList__

#include "DLnkList.h"
#include "CString.h"


//----------------------------------------------------------------------------------------
  //						TNamedObjectList
  //----------------------------------------------------------------------------------------
  
  class TNamedObjectList : public TOrderedObjectDLList
{
  static int fCount;

 private:

  CString fListName;
  static CString fDbgStr;
  int fListIndex;
  
 public:

  static int kNoFastFind;
  static int kUseCount;

  TNamedObjectList( int size=32, int listIndex = kNoFastFind   );
  TNamedObjectList(char* listName, int size=32, int listIndex = kNoFastFind   );
  TNamedObjectList( const CString& s, int size=32, int listIndex = kNoFastFind    );
  TNamedObjectList(TNamedObjectList& list, int listIndex = kNoFastFind   );
  
  inline const char* Name() { return (const char*)fListName; }

  inline TNamedObject& elem (Pix p) const {
	#ifdef DEBUG
	  if (p == 0) error("null Pix");
	  if( checkPixOwnership && !owns(p) ) error( " Pix not owned by Set" );
	#endif
	  return (TNamedObject&) ((TOrderedObjectDLListNode*)p)->Object();
  }
  
  inline const TNamedObject& operator() (Pix p) const { return elem(p); }

  inline const CString& SName(Pix p) const { const TNamedObject& obj = (*this)(p); return obj.SName(); }
  inline const char* Name(Pix p) const { const TNamedObject& obj = (*this)(p); return obj.Name(); }

  void Init(char* listName);

  Pix GetObjectByNameP(const char* name) const ;
  Pix GetObjectByNameP( const CString& name ) const ;
  Pix GetObjectByNameP(const char* name, int index) const ;

  inline TNamedObject* GetObjectByName(const char* name) const  {
    Pix p = GetObjectByNameP(name);
    return (TNamedObject*) ( p ? &(*this)(p) : NULL);
  }
  inline TNamedObject* GetObjectByName(const CString& name) const  {
    Pix p = GetObjectByNameP(name);
    return (TNamedObject*) ( p ? &(*this)(p) : NULL);
  }

  Pix FindObjectFast( TNamedObject& item ) ;
  inline Pix FindObjectShallow( TNamedObject* item ) { return find(item); }
  inline Pix FindObjectDeep( TNamedObject& item ) { return find(item); }

  Pix InsertObject(TNamedObject& item);  
  inline Pix Insert(TNamedObject& item) { return InsertObject(item); }    
    
  virtual  void Alphabetize (); 
  virtual int SortByLinks();
  virtual int IsLinkSortable();
  inline int SortByIndex() { return sort(kObjectIndex); }

  int Link( TNamedObject& item1, TNamedObject& item2, int nlink ) {        // establish link from item1 to item2
    TOrderedObjectDLListNode* p1 = (TOrderedObjectDLListNode*)FindObjectFast(item1); 
    TOrderedObjectDLListNode* p2 = (TOrderedObjectDLListNode*)FindObjectFast(item2); 
    if( p1 && p2 ) { 
      if(nlink<0) p1->slink(p2); else  p1->link(p2,nlink); 
      return 1; 
    }
    else return 0;
  }

  virtual void Move( Pix pt, Pix pm0, Pix pm1 = 0 );  
   
  virtual void Clear();   // Delete all links from list; 	
  virtual void Free();   // Delete all links from list and free objects;

  virtual int Delete(TNamedObject& item) {
    Pix p = FindObjectFast( item ); 
    if(p) { del(p); return 1; } else return 0;
  }

  virtual int Delete(Pix p) {
    if(p) { del(p); return 1; } else return 0;
  }
  void Dump( FILE* oFile=NULL);

  void Print (FILE* oFile=NULL) {
    int cnt=0;
    for( Pix p = first(); p; next(p) ) {
      fprintf( oFile, "%s ",(*this)(p).Name() );
      if( cnt++ % 8 == 7 ) fprintf( oFile, "\n");
    } 
    fprintf( oFile, "\n");
  }

  inline const char* dump () {
    for( Pix p = first(); p; next(p) ) {
      fDbgStr += (*this)(p).SName();
      fDbgStr += " ";
    }
    return fDbgStr.chars(); 
  }

};

typedef TOrderedObjectDLList TObjectList;

#endif

