#ifdef __GNUG__
#pragma implementation
#endif

#include "StringPlex.h"
#include "Environ.h"
// #include <builtin.h>
#include "MsgBuff.h"

const int kArgArraySendTag = 1005;
char* ArgArray::_buff[MAX_ARGS];


/*
void CStringPlex::empty_error() const
{
  error("attempted operation on empty plex");
}

void CStringPlex::full_error() const
{
  error("attempt to increase size of plex past limit");
}

// generic plex ops

CStringPlex:: ~CStringPlex()
{
  invalidate();
}  


void CStringPlex::append (const CStringPlex& a)
{
  for (int i = a.low(); i < a.fence(); a.next(i)) add_high(a[i]);
}

void CStringPlex::prepend (const CStringPlex& a)
{
  for (int i = a.high(); i > a.ecnef(); a.prev(i)) add_low(a[i]);
}

void CStringPlex::reverse()
{
  CString tmp;
  int l = low();
  int h = high();
  while (l < h)
  {
    tmp = (*this)[l];
    elem(l) = (*this)[h];
    elem(h) = tmp;
    next(l);
    prev(h);
  }
}


void CStringPlex::fill(const CString  x)
{
  for (int i = lo; i < fnc; ++i) elem(i) = x;
}

void CStringPlex::fill(const CString  x, int low, int hi)
{
  for (int i = low; i <= hi; ++i) elem(i) = x;
}


void CStringPlex::del_chunk(CStringIChunk* x)
{
  if (x != 0)
  {
    x->unlink();
    CString* data = (CString*)(x->invalidate());
    delete [] data;
    delete x;
  }
}


void CStringPlex::invalidate()
{
  CStringIChunk* t = hd;
  if (t != 0)
  {
    CStringIChunk* tail = tl();
    while (t != tail)
    {
      CStringIChunk* nxt = t->next();
      del_chunk(t);
      t = nxt;
    } 
    del_chunk(t);
    hd = 0;
  }
}

int CStringPlex::reset_low(int l)
{
  int old = lo;
  int diff = l - lo;
  if (diff != 0)
  {
    lo += diff;
    fnc += diff;
    CStringIChunk* t = hd;
    do
    {
      t->re_index(t->low_index() + diff);
      t = t->next();
    } while (t != hd);
  }
  return old;
}

CString StringPlex::fDbgStr;
typedef CStringIChunk* _CStringIChunk_ptr;

StringPlex:: StringPlex()
{
  lo = fnc = 0;
  csize = SPLEX_DEFAULT_INITIAL_CAPACITY;
  CString* data = new CString[csize];
  set_cache(new CStringIChunk(data,  lo, lo, fnc, lo+csize));
  hd = ch;
  maxch = MIN_NCHUNKS;
  lch = maxch / 2;
  fch = lch + 1;
  base = ch->base_index() - lch * csize;
  chunks = new _CStringIChunk_ptr[maxch];
  chunks[lch] = ch;
}

StringPlex:: StringPlex(int chunksize)
{
  if (chunksize == 0) error("invalid constructor specification");
  lo = fnc = 0;
  if (chunksize > 0)
  {
    csize = chunksize;
    CString* data = new CString[csize];
    set_cache(new CStringIChunk(data,  lo, lo, fnc, csize+lo));
    hd = ch;
  }
  else
  {
    csize = -chunksize;
    CString* data = new CString[csize];
    set_cache(new CStringIChunk(data,  chunksize+lo, lo, fnc, fnc));
    hd = ch;
  }
  maxch = MIN_NCHUNKS;
  lch = maxch / 2;
  fch = lch + 1;
  base = ch->base_index() - lch * csize;
  chunks = new _CStringIChunk_ptr[maxch];
  chunks[lch] = ch;
}


StringPlex:: StringPlex(int l, int chunksize)
{
  if (chunksize == 0) error("invalid constructor specification");
  lo = fnc = l;
  if (chunksize > 0)
  {
    csize = chunksize;
    CString* data = new CString[csize];
    set_cache(new CStringIChunk(data,  lo, lo, fnc, lo+csize));
    hd = ch;
  }
  else
  {
    csize = -chunksize;
    CString* data = new CString[csize];
    set_cache(new CStringIChunk(data,  chunksize+lo, lo, fnc, fnc));
    hd = ch;
  }
  maxch = MIN_NCHUNKS;
  lch = maxch / 2;
  fch = lch + 1;
  base = ch->base_index() - lch * csize;
  chunks = new _CStringIChunk_ptr[maxch];
  chunks[lch] = ch;
}

void StringPlex::make_initial_chunks(int up)
{
  int count = 0;
  int need = fnc - lo;
  hd = 0;
  if (up)
  {
    int l = lo;
    do
    {
      ++count;
      int sz;
      if (need >= csize)
        sz = csize;
      else
        sz = need;
      CString* data = new CString [csize];
      CStringIChunk* h = new CStringIChunk(data,  l, l, l+sz, l+csize);
      if (hd != 0)
        h->link_to_next(hd);
      else
        hd = h;
      l += sz;
      need -= sz;
    } while (need > 0);
  }
  else
  {
    int hi = fnc;
    do
    {
      ++count;
      int sz;
      if (need >= csize)
        sz = csize;
      else
        sz = need;
      CString* data = new CString [csize];
      CStringIChunk* h = new CStringIChunk(data,  hi-csize, hi-sz, hi, hi);
      if (hd != 0)
        h->link_to_next(hd);
      hd = h;
      hi -= sz;
      need -= sz;
    } while (need > 0);
  }
  set_cache((CStringIChunk*)hd);
  
  maxch = MIN_NCHUNKS;
  if (maxch < count * 2)
    maxch = count * 2;
  chunks = new _CStringIChunk_ptr[maxch];
  lch = maxch / 3;
  fch = lch + count;
  base = ch->base_index() - csize * lch;
  int k = lch;
  do
  {
    chunks[k++] = ch;
    set_cache(ch->next());
  } while (ch != hd);
}

StringPlex:: StringPlex(int l, int hi, const CString  initval, int chunksize)
{
  lo = l;
  fnc = hi + 1;
  if (chunksize == 0)
  {
    csize = fnc - l;
    make_initial_chunks(1);
  }
  else if (chunksize < 0)
  {
    csize = -chunksize;
    make_initial_chunks(0);
  }
  else
  {
    csize = chunksize;
    make_initial_chunks(1);
  }
  fill(initval);
}

StringPlex::StringPlex(const StringPlex& a)
{
  lo = a.lo;
  fnc = a.fnc;
  csize = a.csize;
  make_initial_chunks();
  for (int i = a.low(); i < a.fence(); a.next(i)) { elem(i) = a[i]; }
}

void StringPlex::operator= (const StringPlex& a)
{
  if (&a != this)
  {
    invalidate();
    lo = a.lo;
    fnc = a.fnc;
    csize = a.csize;
    make_initial_chunks();
    for (int i = a.low(); i < a.fence(); a.next(i)) { elem(i) = a[i]; }
  }
}


void StringPlex::cache(const CString* p) const
{
  const CStringIChunk* old = ch;
  const CStringIChunk* t = ch;
  while (!t->actual_pointer(p))
  {
    t = (t->next());
    if (t == old) index_error();
  }
  set_cache(t);
}

int StringPlex::owns(Pix px) const
{
  CString* p = (CString*)px;
  const CStringIChunk* old = ch;
  const CStringIChunk* t = ch;
  while (!t->actual_pointer(p))
  {
    t = (t->next());
    if (t == old) return 0;
  }
  set_cache(t);
  return 1;
}


CString* StringPlex::dosucc(const CString* p) const
{
  if (p == 0) return 0;
  const CStringIChunk* old = ch;
  const CStringIChunk* t = ch;
  while (!t->actual_pointer(p))
  {
    t = (t->next());
    if (t == old) return 0;
  }
  int i = t->index_of(p) + 1;
  if (i >= fnc) return 0;
  if (i >= t->fence_index()) t = (t->next());
  set_cache(t);
  return t->pointer_to(i);
}

CString* StringPlex::dopred(const CString* p) const
{
  if (p == 0) return 0;
  const CStringIChunk* old = ch;
  const CStringIChunk* t = ch;
  while (!t->actual_pointer(p))
  {
    t = (t->prev());
    if (t == old) return 0;
  }
  int i = t->index_of(p) - 1;
  if (i < lo) return 0;
  if (i < t->low_index()) t = (t->prev());
  set_cache(t);
  return (t->pointer_to(i));
}

int StringPlex::add_high(const char* elem)
{
  CStringIChunk* t = tl();
  if (!t->can_grow_high())
  {
    if (t->CStringIChunk::empty() && one_chunk())
    {
      t->clear(fnc);
      base = t->base_index() - lch * csize;
    }
    else
    {
      CString* data = new CString [csize];
      t = (new CStringIChunk(data,  fnc, fnc, fnc,fnc+csize));
      t->link_to_prev(tl());
      if (fch == maxch)
      {
        maxch *= 2;
        CStringIChunk** newch = new _CStringIChunk_ptr [maxch];
        memcpy(newch, chunks, fch * sizeof(_CStringIChunk_ptr));
        delete[] chunks;
        chunks = newch;
      }
      chunks[fch++] = t;
    }
  }
  *((t->CStringIChunk::grow_high())) = elem;
  set_cache(t);
  return fnc++;
}

int StringPlex::grow_high() {
	if( hd==0 ) { csize=16; make_initial_chunks(); }
  CStringIChunk* t = tl();
  if (!t->can_grow_high())
  {
    if (t->CStringIChunk::empty() && one_chunk())
    {
      t->clear(fnc);
      base = t->base_index() - lch * csize;
    }
    else
    {
      CString* data = new CString [csize];
      t = (new CStringIChunk(data,  fnc, fnc, fnc,fnc+csize));
      t->link_to_prev(tl());
      if (fch == maxch)
      {
        maxch *= 2;
        CStringIChunk** newch = new _CStringIChunk_ptr [maxch];
        memcpy(newch, chunks, fch * sizeof(_CStringIChunk_ptr));
        delete[] chunks;
        chunks = newch;
      }
      chunks[fch++] = t;
    }
  }
	set_cache(t);
  return fnc++;
}

int StringPlex::add_high(const CString&  elem)
{
  CStringIChunk* t = tl();
  if (!t->can_grow_high())
  {
    if (t->CStringIChunk::empty() && one_chunk())
    {
      t->clear(fnc);
      base = t->base_index() - lch * csize;
    }
    else
    {
      CString* data = new CString [csize];
      t = (new CStringIChunk(data,  fnc, fnc, fnc,fnc+csize));
      t->link_to_prev(tl());
      if (fch == maxch)
      {
        maxch *= 2;
        CStringIChunk** newch = new _CStringIChunk_ptr [maxch];
        memcpy(newch, chunks, fch * sizeof(_CStringIChunk_ptr));
        delete[] chunks;
        chunks = newch;
      }
      chunks[fch++] = t;
    }
  }
  *((t->CStringIChunk::grow_high())) = elem;
  set_cache(t);
  return fnc++;
}

int StringPlex::del_high ()
{
  if (empty()) empty_error();
  CStringIChunk* t = tl();
  if (t->CStringIChunk::empty()) // kill straggler first
  {
    CStringIChunk* pred = t->prev();
    del_chunk(t);
    t = (pred);
    --fch;
  }
  t->CStringIChunk::shrink_high();
  if (t->CStringIChunk::empty() && !one_chunk())
  {
    CStringIChunk* pred = t->prev();
    del_chunk(t);
    t = (pred);
    --fch;
  }
  set_cache(t);
  return --fnc - 1;
}

int StringPlex::add_low (const CString&  elem)
{
  CStringIChunk* t = hd;
  if (!t->can_grow_low())
  {
    if (t->CStringIChunk::empty() && one_chunk())
    {
      t->cleardown(lo);
      base = t->base_index() - lch * csize;
    }
    else
    {
      CString* data = new CString [csize];
      hd = new CStringIChunk(data,  lo-csize, lo, lo, lo);
      hd->link_to_next(t);
      t = ( hd);
      if (lch == 0)
      {
        lch = maxch;
        fch += maxch;
        maxch *= 2;
        CStringIChunk** newch = new _CStringIChunk_ptr [maxch];
        memcpy(&(newch[lch]), chunks, lch * sizeof(_CStringIChunk_ptr));
        delete[] chunks;
        chunks = newch;
        base = t->base_index() - (lch - 1) * csize;
      }
      chunks[--lch] = t;
    }
  }
  *((t->CStringIChunk::grow_low())) = elem;
  set_cache(t);
  return --lo;
}


int StringPlex::del_low ()
{
  if (empty()) empty_error();
  CStringIChunk* t = hd;
  if (t->CStringIChunk::empty())
  {
    hd = t->next();
    del_chunk(t);
    t = hd;
    ++lch;
  }
  t->CStringIChunk::shrink_low();
  if (t->CStringIChunk::empty() && !one_chunk())
  {
    hd = t->next();
    del_chunk(t);
    t = hd;
    ++lch;
  }
  set_cache(t);
  return ++lo;
}

void StringPlex::reverse()
{
  CString tmp;
  int l = lo;
  int h = fnc - 1;
  CStringIChunk* loch = hd;
  CStringIChunk* hich = tl();
  while (l < h)
  {
    CString* lptr = loch->pointer_to(l);
    CString* hptr = hich->pointer_to(h);
    tmp = *lptr;
    *lptr = *hptr;
    *hptr = tmp;
    if (++l >= loch->fence_index()) loch = loch->next();
    if (--h < hich->low_index()) hich = hich->prev();
  }
}

void StringPlex::fill(const CString  x)
{
  for (int i = lo; i < fnc; ++i) elem(i) = x;
}

void StringPlex::fill(const CString  x, int low, int hi)
{
  for (int i = low; i <= hi; ++i) elem(i) = x;
}


void StringPlex::clear()
{
  for (int i = lch + 1; i < fch; ++i)
    del_chunk(chunks[i]);
  fch = lch + 1;
  set_cache(chunks[lch]);
  ch->CStringIChunk::clear(lo);
  fnc = lo;
}

int StringPlex::reset_low(int l)
{
  int old = lo;
  int diff = l - lo;
  if (diff != 0)
  {
    lo += diff;
    fnc += diff;
    CStringIChunk* t = hd;
    do
    {
      t->re_index(t->low_index() + diff);
      t = t->next();
    } while (t != hd);
  }
  base = hd->base_index() - lch * csize;
  return old;
}


int StringPlex::OK () const
{
  int v = hd != 0 && ch != 0;         // at least one chunk

  v &= fnc == tl()->fence_index();  // last chunk fnc == plex fnc
  v &= lo == hd->CStringIChunk::low_index();    // first lo == plex lo

  v &= base == hd->base_index() - lch * csize; // base is correct;
  v &= lch < fch;
  v &= fch <= maxch;                  // within allocation;

// loop for others:

  int k = lch;                        // to cross-check nch

  int found_ch = 0;                   // to make sure ch is in list;
  const CStringIChunk* t = (hd);
  for (;;)
  {
    v &= chunks[k++] == t;             // each chunk is at proper index
    if (t == ch) ++found_ch;
    v &= t->CStringIChunk::OK();              // each chunk is OK
    if (t == tl())
      break;
    else                              // and has indices contiguous to succ
    {
      v &= t->top_index() == t->next()->base_index();
      if (t != hd)                  // internal chunks full
      {
        v &= !t->empty();
        v &= !t->can_grow_low();
        v &= !t->can_grow_high();
      }
      t = t->next();
    }
  }
  v &= found_ch == 1;
  v &= fch == k;
  if (!v) error("invariant failure");
  return v;
}
*/

void ArgArray::operator= (const ArgArray& a) {
  if (&a != this) {
    Plex::operator= (a);
  }
}

#ifdef USE_MPI

void ArgArray::Pack(TMsgBuff* mb ) {
	mb->PackInt(_items);
	for( int i=0; more(i); next(i) ) { 
		CString& s = elem(i);
		int size = s.size() + 1;
		mb->PackInt(size);
		if( size > 1 ) mb->PackString(s.chars());
	}
}

void ArgArray::UnPack(TMsgBuff* mb ) {
	int nargs = mb->UnPackInt();
	if( nargs >= length() ) {
    const CString elem(" ");
    for(int i=length(); i<=nargs+5; i++) add(elem);
  }
	for( int i=0; i<nargs; i++ ) {
		int size = mb->UnPackInt();
    if( size > 1 ) { 
			CString& s = elem(i);
			s.allocate(size);
			mb->UnPackString(s.data(),size);
			s.resize();
		}
	}
	_items = nargs;
}

int ArgArray::Send( int srcProc, int destProc, MPI_Comm comm  ) { 
	int tag = kArgArraySendTag; 
	TMsgBuff msgBuff(1000,comm);
  if( gIProc == srcProc ) {
		Pack(&msgBuff);
    msgBuff.Send(tag,destProc);
  }
  if( gIProc == destProc ) {
    msgBuff.Recv(tag,srcProc);
		UnPack(&msgBuff);
  } 
  return 0;
}

int ArgArray::BroadCast(  int srcProc, MPI_Comm comm ) { 
	int tag = kArgArraySendTag; 
	TMsgBuff msgBuff(1000,comm);
  if( gIProc == srcProc ) {
		Pack(&msgBuff);
  }
	msgBuff.BCast(srcProc);
  if( gIProc != srcProc ) {
    UnPack(&msgBuff);
  } 
  return 0;
}

#endif // MPI

void ArgArray::ShiftLow() { 
	remove(0,True);
}

int ArgArray::AddList( const char* list , char sep ) {
	char ctmp; CString stmp;
	clear();
	while(1) {
		stmp.clear();
		int in_arg = 0; 
		while( (ctmp = *list) != 0 ) {
			if( in_arg ) {
				if( (sep == 0 && isspace(ctmp)) || ( ctmp == sep ) ) { list++; break; }
				stmp += ctmp;
			} 
			else if(isspace(ctmp)) {;}
			else {
				in_arg = 1;
				stmp += ctmp;
			}
			list++;
		}
		if( in_arg ) { add( stmp ); }
		if(ctmp == 0) return _items; 
	}
}

void ArgArray::Print( FILE* oFile ) {
	fprintf(oFile,"%s\n",(*this)[0].chars() );
	for(int i=1; more(i); next(i)  ) {
		fprintf(oFile,"%s\n",(*this)[i].chars() );
	}
}
void ArgArray::PrintList( FILE* oFile ) const {
	if(_items==0) return;
	fprintf(oFile,"%s",(*this)[0].chars() );
	for(int i=1; more(i); next(i) ) {
		fprintf(oFile,", %s",(*this)[i].chars() );
	}
}

void ArgArray::PrintList( CString& s ) const {
	if(_items==0) return;
	s += (*this)[0].chars();
	for(int i=1; more(i); next(i) ) {
		s +=", "; s+=(*this)[i].chars();
	}
}

const char* ArgArray::string() {
	if(_items==0) return "";
	fBuffer = (*this)[0].chars();
	for( int i=1; more(i); next(i) ) {
		fBuffer +=' '; fBuffer+=(*this)[i].chars();
	}
	return fBuffer.chars();
}


