#ifdef __GNUG__
#pragma implementation
#endif

#include "TObjectList.h"
#include "Environ.h"

void TObjectSLList::error(const char* msg)
{
   gProgramBreak(msg);
}

int TObjectSLList::length()
{
  int l = 0;
  TObjectSLListNode* t = last;
  if (t != 0) do { ++l; t = t->tl; } while (t != last);
  return l;
}

TObjectSLList::TObjectSLList(const TObjectSLList& a)
{
  if (a.last == 0)
    last = 0;
  else
  {
    TObjectSLListNode* p = a.last->tl;
    TObjectSLListNode* h = new TObjectSLListNode(p->hd);
    last = h;
    for (;;)
    {
      if (p == a.last)
      {
        last->tl = h;
        return;
      }
      p = p->tl;
      TObjectSLListNode* n = new TObjectSLListNode(p->hd);
      last->tl = n;
      last = n;
    }
  }
}

TObjectSLList& TObjectSLList::operator = (const TObjectSLList& a)
{
  if (last != a.last)
  {
    clear();
    if (a.last != 0)
    {
      TObjectSLListNode* p = a.last->tl;
      TObjectSLListNode* h = new TObjectSLListNode(p->hd);
      last = h;
      for (;;)
      {
        if (p == a.last)
        {
          last->tl = h;
          break;
        }
        p = p->tl;
        TObjectSLListNode* n = new TObjectSLListNode(p->hd);
        last->tl = n;
        last = n;
      }
    }
  }
  return *this;
}

void TObjectSLList::clear()
{
  if (last == 0)
    return;

  TObjectSLListNode* p = last->tl;
  last->tl = 0;
  last = 0;

  while (p != 0)
  {
    TObjectSLListNode* nxt = p->tl;
    delete(p);
    p = nxt;
  }
}


Pix TObjectSLList::prepend(TObject& item)
{
  TObjectSLListNode* t = new TObjectSLListNode(item);
  if (last == 0)
    t->tl = last = t;
  else
  {
    t->tl = last->tl;
    last->tl = t;
  }
  return Pix(t);
}


Pix TObjectSLList::prepend(TObjectSLListNode* t)
{
  if (t == 0) return 0;
  if (last == 0)
    t->tl = last = t;
  else
  {
    t->tl = last->tl;
    last->tl = t;
  }
  return Pix(t);
}


Pix TObjectSLList::append(TObject& item)
{
  TObjectSLListNode* t = new TObjectSLListNode(item);
  if (last == 0)
    t->tl = last = t;
  else
  {
    t->tl = last->tl;
    last->tl = t;
    last = t;
  }
  return Pix(t);
}

Pix TObjectSLList::append(TObjectSLListNode* t)
{
  if (t == 0) return 0;
  if (last == 0)
    t->tl = last = t;
  else
  {
    t->tl = last->tl;
    last->tl = t;
    last = t;
  }
  return Pix(t);
}

void TObjectSLList::join(TObjectSLList& b)
{
  TObjectSLListNode* t = b.last;
  b.last = 0;
  if (last == 0)
    last = t;
  else if (t != 0)
  {
    TObjectSLListNode* f = last->tl;
    last->tl = t->tl;
    t->tl = f;
    last = t;
  }
}

Pix TObjectSLList::ins_after(Pix p, TObject& item)
{
  TObjectSLListNode* u = (TObjectSLListNode*)p;
  TObjectSLListNode* t = new TObjectSLListNode(item);
  if (last == 0)
    t->tl = last = t;
  else if (u == 0) // ins_after 0 means prepend
  {
    t->tl = last->tl;
    last->tl = t;
  }
  else
  {
    t->tl = u->tl;
    u->tl = t;
    if (u == last) 
      last = t;
  }
  return Pix(t);
}


void TObjectSLList::del_after(Pix p)
{
  TObjectSLListNode* u = (TObjectSLListNode*)p;
  if (last == 0 || u == last) error("cannot del_after last");
  if (u == 0) u = last; // del_after 0 means delete first
  TObjectSLListNode* t = u->tl;
  if (u == t)
    last = 0;
  else
  {
    u->tl = t->tl;
    if (last == t)
      last = u;
  }
  delete t;
}

int TObjectSLList::owns(Pix p)
{
  TObjectSLListNode* t = last;
  if (t != 0 && p != 0)
  {
    do
    {
      if (Pix(t) == p) return 1;
      t = t->tl;
    } while (t != last);
  }
  return 0;
}

TObject TObjectSLList::remove_front()
{
  if (last == 0) error("remove_front of empty list");
  TObjectSLListNode* t = last->tl;
  TObject res = t->hd;
  if (t == last)
    last = 0;
  else
    last->tl = t->tl;
  delete t;
  return res;
}

int TObjectSLList::remove_front(TObject& x)
{
  if (last == 0)
    return 0;
  else
  {
    TObjectSLListNode* t = last->tl;
    x = t->hd;
    if (t == last)
      last = 0;
    else
      last->tl = t->tl;
    delete t;
    return 1;
  }
}


void TObjectSLList::del_front()
{
  if (last == 0) error("del_front of empty list");
  TObjectSLListNode* t = last->tl;
  if (t == last)
    last = 0;
  else
    last->tl = t->tl;
  delete t;
}

int TObjectSLList::OK()
{
  int v = 1;
  if (last != 0)
  {
    TObjectSLListNode* t = last;
    long count = LONG_MAX;      // Lots of chances to find last!
    do
    {
      count--;
      t = t->tl;
    } while (count > 0 && t != last);
    v &= count > 0;
  }
  if (!v) error("invariant failure");
  return v;
}
