#ifndef __DFIT_H
#define __DFIT_H
#endif

// max number of test allowed
#define DFIT_MAXTESTS 24

#include <assoc.h>
#include <dfitm.h>
// #include <fstream.h>

class VDesc;

class DFit : public TObject
{
  TString _id;
  TAssoc_array _vars;
  TArray _varnames;    // variable names in order of definition
  double _score;
  double _ok;
  TArray _outdefs;     // defined in dfitm.H
  Bool   _dataread;
  Bool   _verbose;
  
public:

  int test_id(const char*);
  const char* id_test(int);
  
  void set_id(const char* id) { _id = id; }

  TArray& var_names() {return _varnames; }

  // called to read config file in
  void read_config(const char* file);
  
  // called to fill in data at simulation end if no file read
  // is configured
  
  Bool has_test( VDesc* vdesc, int test_id );
  float* get_refdata( VDesc* vdesc, int& dsize );
  
  void set_data(VDesc* v , double* d, int ndata);

  inline void set_data(const char* varname, double* data, int ndata) { set_data( var_desc(varname), data, ndata); }
 
  void verbose(Bool v) { _verbose = v; }

  // called to start the computation
  void compute();

  // global score for all variables considered
  double score() const { return _score; }

  // global score for all variables considered
  void score(double d) { _score = d; }
  
  // score for a single variable with one or more methods
  double var_score(const char* varname, int method_id = MID_GLOBAL);

  // return variable descriptor
  VDesc* var_desc( const char* varname, Bool create = True );
  
  // configure ref data file input
  int configure_ref_data(const char* varname, const char* data_filename, int* cols = NULL );
  
  // read variable reference data from stored filename
  void read_refdata();

  // read variable actual data from stored filename
  void read_data();

  // return what score would be with new weights (taken from 
  // tokenstring)
  double recalc_score(TToken_string& t);

  // start report generator 
  virtual void report();

  // parse report string for variable (or main if v ==  NULL)
  virtual void report_object(const char* format, const char* f, 
			     VDesc* v = NULL);

  // define tag for new comparison method
  void add_method (const char* name, int method_id);
  
  // define to implement new comparison method
  virtual double compare_vars(int method_id, float* orig, float* cmp, 
			     int norig, int ncmp)
  { return 0.0; }

  // default just prints message and exits
  virtual void error(const char* message);


  // Convenience routines:    
  int register_test( const char* name, const char* test, float weight, 
		     int argc, char *argv[]);
  int set_weight( const char* name, float weight );

  DFit(const char* cfile, const char* id = "") : _ok(FALSE), _id(id),
    _dataread(FALSE), _verbose(FALSE)
  { read_config(cfile); }

  DFit() : _ok(FALSE), _id(""), _dataread(FALSE), _verbose(FALSE)
  {}

  virtual ~DFit() { ; }
};
