#ifndef __DFITM_H
#define __DFITM_H
#endif

// #include <iostream.h>
#include <assoc.h>
#include <stdlib.h>
#include <stdio.h>

#define MID_GLOBAL  0
// method IDs (not enum to make it easier for users to extend)
#define MID_BOUNDS  1   // stupid bounds test
#define MID_WBOUNDS 2   // stupid weighted bounds test
#define MID_FREQ    3   // frequency test
#define MID_DBK     4   // Dent and Blackie deterministic timeseries F
#define MID_CONF    5   // Stupid confidence interval "test"
#define MID_WCONF   6   // Stupid weighted confidence interval "test"
#define MID_THEIL   7   // Theil inequality coefficient
#define MID_ERRCOMP 8   // Error composition coefficient
#define MID_STEADY  9   // Steady state test
#define MID_SHAPE  10   // Shape test (unimplemented)
#define MID_INCREASE 11 // Increase test
#define MID_DECREASE 12 // Increase test
#define MID_TREND    13 // Trend test

// this stores the output report format for main program and variables
class OutDef : public TObject
{
public:
  TString   form;
  TFilename file;

  OutDef (const char* fo, const char* fi = "") : form(fo), file(fi) {}
  virtual ~OutDef() {}
};

// test descriptor: each variable has an array with as many descriptors as
// tests selected
class FitTest : public TObject
{
  int   _test_id;
  double _score;
  double _weight;
  double _missing;
  Bool _misdef;
  Bool _ok;

  TAssoc_array _out_vars;
  TAssoc_array _parms;

  void define_parameters(TArray& pa);

public:

  // this is only for reporting purposes
  virtual int test_id() { return _test_id; }

  // final 'score' of goodness of fit - should be 0 to 1, 1 for perfect
  double score() const { return _score; }
  // final 'score' of goodness of fit - should be 0 to 1, 1 for perfect
  void score(double s) { _score = s; }

  // weight of test in computing final score
  double& weight() { return _weight; }

  // weight of test in computing final score
  double& missing() { return _missing; }

  // weight of test in computing final score
  Bool& misdef() { return _misdef; }

  // ok is TRUE when compute() has been called
  Bool& ok()      { return _ok; }
  
  // this calculates initial statistics on reference data and stores
  // a pointer if needed
  virtual void initialize(double* refdata, int nrdata) = 0;

  // this actually performs the test
  virtual void compute(double* data, int ndata) = 0;

  // Report generation
  // define output variable
  void define_variable(const char*, const char*);
  // get variable value
  const char* get_variable(const char*);

  // access to command line parameters
  Bool is_parameter(const char* n) { return _parms.is_key(n); } 
  const char* sparm(const char* n) { return (TString&)_parms[n]; } 
  double      dparm(const char* n) { return atof(sparm(n)); } 
  int         iparm(const char* n) { return atoi(sparm(n)); } 

  FitTest(int id, TArray& pa) : _ok(FALSE), _test_id(id) 
  { define_parameters(pa); }
  virtual ~FitTest() { ; }
};


// stupid bounds test plus more stupid ones 

class FitTest_bounds : public FitTest
{
  double _max, _min;
  double _mean, _std;

  int _method; /* 1: score = percentage of non-outliers 
                  2: score = perc. weighted by amount of deviation compared to
	 	            min-max range
		  3: score = perc. outside 95% (or other) confidence intervals
		  4: score = perc. outside conf weighted by amount of deviation
		             compared to mean +- req. sd's
	        */ 

public:
  
  virtual int test_id();

  virtual void initialize(double* refdata, int nrdata);
  virtual void compute(double* data, int ndata);
//  virtual void print_on(ostream& out) const;

  FitTest_bounds(int method, TArray& pa) : _method(method),
    FitTest(MID_BOUNDS, pa)
  {;}
  ~FitTest_bounds() {;}
};


class FitTest_Theil : public FitTest
{
  // error allocation
  double _meanp, _varp, _randp;

  double _uval;
  double _mx, _my, _sdx, _sdy;
  
  // score index of performance for error components
  double _sm; 

  double* _data, *_refdata;
  int _ndata, _nrefdata;
  double _corr;

public:
  
  virtual void initialize(double* refdata, int nrdata);
  virtual void compute(double* data, int ndata);
//  virtual void print_on(ostream& out) const;

  FitTest_Theil(TArray& pa) :  FitTest(MID_THEIL, pa)
  {;}
  ~FitTest_Theil() {;}
};


class FitTest_Errcomp : public FitTest
{
  // error allocation allowed
  double _wmean, _wvar, _wrand;
  // error allocation
  double _meanp, _varp, _randp;

  double _uval;
  double _mx, _my, _sdx, _sdy;
  
  // score index of performance for error components
  double _sm; 

  double* _data, *_refdata;
  int _ndata, _nrefdata;
  double _corr;

public:
  
  virtual void initialize(double* refdata, int nrdata);
  virtual void compute(double* data, int ndata);
 // virtual void print_on(ostream& out) const;

  // w0, w1, w2 are the maximum allowed proportions of bias, variance
  // and random error in the residuals between two timeseries; score will 
  // be 1 - the sum of the positive difference between allowed and obs values

  FitTest_Errcomp(TArray& pa) :  
    _wmean(0.0), _wvar(0.0), _wrand(1.0), FitTest(MID_ERRCOMP, pa)
  {;}
  ~FitTest_Errcomp() {;}
};


class FitTest_dbk : public FitTest
{
  double _bmax, _bmin;
  double _mx, _my, _sdx, _sdy;
  double _nstd;
  
  double* _data, *_refdata;
  int _ndata, _nrefdata;
  double _corr;

public:
  
  virtual void initialize(double* refdata, int nrdata);
  virtual void compute(double* data, int ndata);
//  virtual void print_on(ostream& out) const;

  FitTest_dbk(TArray& pa) : FitTest(MID_DBK, pa)
  {;}
  ~FitTest_dbk() {;}
};

class FitTest_steadystate : public FitTest
{

  // check that the mean of a variable first differences between 
  // specified timesteps is/is not significantly different from zero
  // score is either 0 or 1 based on 95% confidence intervals

  // 3rd parameter (steady) can be 0, 1 or -1; if 0 checks for
  // steady state, if 1 for increasing, if -1 for decreasing

  int _t1, _t2;
  int _steady;
  double _dmin, _dmax;

public:

  virtual int test_id();

  virtual void initialize(double* refdata, int nrdata);
  virtual void compute(double* data, int ndata);
 // virtual void print_on(ostream& out) const;

  FitTest_steadystate(int steady, TArray& pa) : 
    _t1(0), _t2(0), _steady(steady), 
    FitTest(MID_STEADY, pa)
  {;}
  ~FitTest_steadystate() {;}
};


class FitTest_Freq : public FitTest
{

  // first idea: calculate power spectrum of both signals and
  // regress it using DBK algorithm. If a set of parameters
  // are passed, these are used to generate
  // a periodic signal to match the data
  
  int _npars;
  double* _parms;
  
  int _acceptable_drift;

  double* _rperiod, *_dperiod;
  int _nrperiod, _ndperiod;

public:
  
  virtual void initialize(double* refdata, int nrdata);
  virtual void compute(double* data, int ndata);
//  virtual void print_on(ostream& out) const;

  FitTest_Freq(TArray& pa) : 
    _acceptable_drift(1), FitTest(MID_FREQ, pa)
  {;}
  ~FitTest_Freq() {;}
};

