#include "Constructor.h"
#include "Model.h"
#include "ExprBuilder.h"

CnfgProcessor TConstructor::fCR;
FILE* TConstructor::fMMLFile;

int TConstructor::Run( ) {

	TModel::I().SetNode(ExprBuilder::GetRootNode());
	TModel::I().ProcessNode();
	TModel::I().RunNodeProcessing(kPCDependencies);
	TModel::I().ReadConfigFiles( );
	TModel::I().RunNodeProcessing(kPCCodeGen);
	TModel::I().WriteMML(fMMLFile);
	TModel::I().WriteConfigFile();
}

int TConstructor::StartUp( int argc, char** argv ) {

	ExprBuilder::SetMode(ExprBuilder::kMML);
	ExprBuilder::SetDefaultLibrary("SL");
	int rv = TModel::I().StartUp(argc, argv );
	
	CString path = Env::ModelPath();
  path += "/Models/"; path += TModel::I().MMLOutFile(); 
  fMMLFile = fopen(path.chars(),"w");
  if(fMMLFile==NULL) { gProgramBreak( CString("Error, unable to open MML file: ") += path.chars() );  exit(0); }
  else { printf("\nOpened MML File: %s.\n",path.chars()); fflush(stdout); }
	return rv;
}






