//-------------------------------------------------------------------------------
//	Model.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//	
//--------------------------------------------------------------------------------

#ifndef __TModel__
#define __TModel__

#include "MML.h"
#include "MML_Model.h"

typedef class TVariable;
typedef class TDerivative;
const int kMaxNHab = 100;


//----------------------------------------------------------------------------------------
  //						TModel 
  //----------------------------------------------------------------------------------------
  
class TModel : public Model
{
 public:

  enum EObjectType { kModel, kModule, kVariable, kGraph, kInput, kFlag };

private:

   int fProcDims[5];
   int fNProcDims;
 
   static TModel* kNullModel;

protected:

  FILE * fCEqnFile;
  FILE * fCHdrFile;
  TNamedObjectList fExternalModulesList;

  TModel();

  void GenerateCode();
  virtual void  WriteDataToConfig( CStream& outStream );
  void SetFieldsFromMML();
  int WriteSetupFile( char* cnfgExtension );
	void CreateUserCodeMakefile();

public:
  
  inline static TModel& I() {
    if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
    else if(fInstance == NULL) {
      fInstance = kNullModel;
      fInstance = new TModel;
      fInstance->Init(); 
    }
    return (TModel&) *fInstance; 
  } 
    
  virtual Module* CreateNewModule( const CString& name );

  void Run(); 
  int  Config(TConfigData& cd);

  virtual int ConfigExternal(TConfigData& cd, Module* m);

  void  Free();

  virtual void  WriteCCode( FILE* CHdrFile, FILE* CEqnFile);
  void ProcessBiflowDeclarations();
};	


typedef TModel Mod;

class ExternalModuleRec : public TNamedObject {
  ArgArray fCmds;
public:
  ArgArray& Cmds() { return fCmds; }
  ExternalModuleRec( const CString& name ) : TNamedObject(name) {;}
};

#endif

