//-------------------------------------------------------------------------------
//	Variable.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//	
//--------------------------------------------------------------------------------

#ifndef __Variable__
#define __Variable__

#include "MML_Variable.h"
#include "MML_Module.h"
#include "MML_Event.h"
#include "StringPlex.h"
#include "Bounds.h"

typedef class TModule;

//----------------------------------------------------------------------------------------
//						TVariable
//----------------------------------------------------------------------------------------

//  TVariable Flags

 extern FlagType	FisGraph ;		//  1 = is Graph
  
//  TVariable Class Definition

class TVariable : public Variable
{
	byte fDerivatives;		  
public:


  TVariable (const char *variable_name);
  ~TVariable () {;}
											
  void  SetFieldsFromValue (CString& value, TEvent::EType et);
  void SetFieldsFromMML ();

  virtual int SplitCondition( int splitIndex );
  
  int LogDependency( Variable* v ) { return 0;}

  void setIntegrationMethod( char* sTemp );

  virtual inline int Config( TConfigData & cd );

  TNamedObjectList* FluxList() {
    return &fFluxList;
  }

  virtual void Dump( FILE* oFile );
		
  Bool  GetNextVar (char* target_str, char *ret_str, char* rel_code, int* offset ); 
						
  virtual void  WriteDataToConfig(CStream& outStream) const; 

  void Free ();

  void PrintSVDebugCode(FILE* cFile);

  inline void FlagInput() { SetF(FisImport,True,"AddConnection"); }
  inline void FlagExport() { SetF(FisExport,True,"AddConnection"); }

  virtual int AddModifier( const CString& mod ); 
  virtual void AddFlags();

}; 


#endif
