#include "CString.h"
#include "Environ.h"
#include "ExprBuilder.h"
#include "Model.h"

int STELLAerror (char* s);
int STELLAlex(void);
int STELLAparse(void);
void STELLAinitParse(int debug_level);

extern int STELLAleng, STELLAdebug;
extern FILE *STELLAin, *STELLAout;

int main( int argc, char** argv ) {
	int token = 1; gMPI = 0;
	CString STELLA_file;
#ifdef BISON_DEBUG
	STELLAdebug = 1;
#endif

	Env::Startup (argc,argv,Env::kMCP);
	int nfiles = TModel::I().StartUp(argc,argv);
	
	for( int i=0; i<nfiles; i++ ) {
	  TModel::I().SetInputFileName(i, STELLA_file);
	  sprintf(gMsgStr,"Parsing input file: %s",STELLA_file.chars());
	  gPrintScreen();
	  STELLAin = fopen( STELLA_file, "r" );
	  if( STELLAin ) {
			STELLAinitParse( TModel::I().ParseDebugLevel() );
	    if( STELLAparse() ) { ExprBuilder::StackDump(stderr); }
	    fclose(STELLAin);
	    ExprBuilder::SetRootNode();
	  } else gPrintErr( STELLA_file += ": Can't open input file" );
	}
	TModel::I().ProcessNode( ExprBuilder::GetRootNode() );
	TModel::I().Run();
	Env::Finalize();	
}
