#include "Model.h"
#include "MML_Module.h"
#include "MML_Variable.h"
  
  //========================================================================================
  // 				CLASS TModel 
  //========================================================================================

Model* TModel :: kNullModel =  (Model*) 0x1; 
  
  //----------------------------------------------------------------------------------------
  //				TModel::IModel:
  //----------------------------------------------------------------------------------------

TModel::TModel (const CString& name) : Model(name) { fFormat = -1; fGlobalModule = NULL; }
 
void TModel :: IModel () { 
    
    fName = Env::ModelName();
    CString name = fName + "_module";
    fGlobalModule = CreateNewModule(name);
    fFormat = 1;

} // TModel::IModel

void TModel::SetInputFileName(int i, CString& sname) {
	if( fInputFileList[i].size() == 0 ) {
	  sname = "";
	} else {
	  CPathString path;  
	  if( Env::TmpPath().empty() ) { 
		  path = Env::ModelPath();
		  path += "Models";
	  } else { path = Env::TmpPath(); }
	  path += fInputFileList[i];
	  sname = path.chars();
	}
}
	
int TModel::WriteSetupFile( char* cnfgExtension ) {
	int rv = 1, i;
  CPathString path(Env::ConfigPath());
  path += Env::ModelName(); 
  FILE* sf = fopen(path.Path(cnfgExtension),"w");
  if( sf ) {
		fprintf(sf,"config input File names = ( ");
		for( i=0; i<fConfigFileList.NArgs(); i++ ) {
			if( i > 0 ) { fprintf(sf,","); }
			fprintf(sf," %s",fConfigFileList[i].chars());
		}
		fprintf(sf," ); ");
		fprintf(sf,"\nstella input File names = ( ");
		for( i=0; i<fInputFileList.NArgs(); i++ ) {
			if( i > 0 ) { fprintf(sf,","); }
			fprintf(sf," %s",fInputFileList[i].chars());
		}
		fprintf(sf," ); ");
		fprintf(sf,"\nconfig output File name = %s;",fConfigOutFile.chars());
		fprintf(sf,"\nmml output File name = %s;\n",fMMLOutFile.chars());
		fprintf(sf,"\nDebug level = 0;");
		fprintf(sf,"\nParserDebug level = 0;");
		fclose(sf);
	} else {
		sprintf(gMsgStr, "Can't generate setup file: %s",path.Path(cnfgExtension).chars() );  gPrintErr();
		rv = 0; 
	} 
  return rv;
}

int TModel :: StartUp( int argc, char** argv ) { 
  int useDefaultConfig=1;
  int useDefaultEqnFile=1;
	ExprBuilder::SetMode(ExprBuilder::kSTELLA );
  ExprBuilder::SetDefaultLibrary("SL");
  fMMLOutFile = Env::ModelName() + ".MML";
  fConfigOutFile = Env::ModelName() + ".MML.config";
  for(int i=0; i<argc; i++) if( argv[i] != NULL ) {
    if (strcmp(argv[i], "-s") == 0) {
      if ((i+1) < argc) fInputFileList.Add(argv[++i]); useDefaultEqnFile = 0;
    } else if (strcmp(argv[i], "-M") == 0) {
      if ((i+1) < argc) fMMLOutFile = argv[++i];
    } else if (strcmp(argv[i], "-co") == 0) {
      if ((i+1) < argc) fConfigOutFile = argv[++i]; 
    } else if (strcmp(argv[i], "-ci") == 0) {
      if ((i+1) < argc) fConfigFileList.Add( argv[++i] ); useDefaultConfig = 0;    
    } else if (strcmp(argv[i], "-pd") == 0) {
      if ((i+1) < argc) fParserDebug = atoi( argv[++i] ); 
    } else if (strcmp(argv[i], "-help") == 0) {
      gPrintScreen("MCP command line Arguments:");
      gPrintScreen(" -s FILE     Use FILE as STELLA equation file (default: <ProjDir>/Models/<ModelName>.eqns)");
      gPrintScreen(" -M FILE     Use FILE as MML output file (default: <ProjDir>/Models/<ModelName>.MML)");
      gPrintScreen(" -co FILE    Use FILE as configuration output file (default: <ProjDir>/Config/<ModelName>.MML.config)");
      gPrintScreen(" -ci FILE	   Use FILE as configuration input file  (default: <ProjDir>/Config/<ModelName>.MML.config)");
      gPrintScreen(" -pd INT     Set parser debug level to INT (default: 0) ");
      exit(0);
    }  
	}
  
	if(useDefaultConfig) { fConfigFileList.Add( Env::ModelName() + ".MML.config" ); }
	if(useDefaultEqnFile) { fInputFileList.Add( Env::ModelName() + ".eqns" ); }
//	WriteSetupFile(".MCP.MML");
  
#ifdef SME_LIBRARY
  CPathString path(SME_LIBRARY);
#else
  CPathString path(Env::DriverPath());
  path += "lib";
#endif
  if (getenv("SME_LIBRARY") != NULL) { path += getenv("SME_LIBRARY"); }	

//  ReadMMLFiles() ;
  
  ReadMMLFile( path, "StellaLib.MML" );
  ReadMMLFile( path, "SpaceLib.MML" );
  

  if( Env::TmpPath().empty() ) { 
	  path = Env::ModelPath();
	  path += "Models"; 
	  path += Env::ModelName(); 
  } else { path = Env::TmpPath();  }
  fXMLFilePath = path.Path(); 
  
  if( Env::TmpPath().empty() ) { 
	  path = Env::ModelPath();
	  path += "Models"; 
  } else { path = Env::TmpPath();  }
  path += TModel::I().MMLOutFile();
  fMMLFile = fopen(path,"w");
  if(fMMLFile==NULL) { gFatal( CString("Error, unable to open MML file: ") += path.chars() ); }
  else { sprintf(gMsgStr,"Opened MML File: %s.",path.chars()); gPrintScreen(); }
  
  return fInputFileList.NArgs();
}

Module* TModel :: CreateNewModule(const CString& s) { 
	Module* m = new Module( s );
	fModuleList.Insert(*m);	
	if( fGlobalModule != NULL ) { fGlobalModule->AddSubModule(m); }
	m->SetModel(this);
	return m;
}

int TModel::Run( ) {

	SetNode(ExprBuilder::GetRootNode());
	if( Env::ReadConf() ) { ReadConfigFiles(); }
	gPrintScreen("Processing dependencies");
	RunNodeProcessing(kPCDependencies);
	gPrintScreen("Generating MML");
	RunNodeProcessing(kPCMMLGen);
	gPrintScreen("Writing MML");
	WriteMML(fMMLFile);
	gPrintScreen("Writing XML");
	WriteXML(fXMLFilePath);
	if( Env::ReadConf() ) { 
		gPrintScreen("Writing Config");
		WriteConfigFile(); 
	}
//	WriteDBParameters();
	WriteUserFunctionRegistration();
	return 0;
}

  //----------------------------------------------------------------------------------------
  //				TModel::GetDataFromConfig:
  //----------------------------------------------------------------------------------------
  
int TModel::Config(TConfigData& cd) 
{
  const CString& cmd = cd.Cmd();
  int iarg; float farg; 
  if(cmd == "f") { 
    cd.IntArg(0, fFormat, CD::kRequired); 
    return 1;
  } 
  return Model::Config(cd);
} // TModel::GetDataFromNewConfig
    
  //----------------------------------------------------------------------------------------
  //				TModel::WriteDataToConfig:
  //----------------------------------------------------------------------------------------
  
void  TModel::WriteDataToConfig( CStream& outStream ) 
{
  outStream << " f(" << fFormat << ")";
  Model::WriteDataToConfig( outStream );
  
} // TModel::WriteDataToConfig
    
//----------------------------------------------------------------------------------------
// TModel::WriteCG_MMLFile: 
//----------------------------------------------------------------------------------------
  
  void TModel::WriteCG_MMLFile() 
{
  CPathString path1;
	if( Env::TmpPath().empty() ) { 
		path1 = Env::ConfigPath();
	} else { path1 = Env::TmpPath();  }
  path1 += Env::ModelName();
  FILE* cFile = fopen(path1.Path(".CG.MML"),"r");
  if(cFile==NULL) {
    FILE* cFile = fopen(path1.Path(".CG.MML"),"w");
    if(cFile==NULL) { sprintf(gMsgStr,"Can't open file %s",(const char*)path1.Path(".CG.MML")); gPrintErr(); }
    else {
      fprintf(cFile,"config input list File names = ( );\n" );
      fprintf(cFile,"mml input list File names = ( %s.MML );\n", (const char*) Env::ModelName() );
      fprintf(cFile,"config output list File names = ( %s.config.new );\n", (const char*) Env::ModelName() );
      fprintf(cFile,"mml output list File names = ( %s.MML.new );\n", (const char*) Env::ModelName() );
      fprintf(cFile,"Debug level = 0;\n");
      fprintf(cFile,"ParserDebug level = 0;\n");
      fclose(cFile);
    }
  }

} // TModel::WriteCG_MMLFile
  
 //----------------------------------------------------------------------------------------
// TModel::WriteUserFunctionRegistration: 
//----------------------------------------------------------------------------------------
  
void TModel::WriteUserFunctionRegistration() 
{
  CPathString path1;
	if( Env::TmpPath().empty() ) { 
		path1 = Env::ModelPath();
		path1 += "UserCode";
	} else { path1 = Env::TmpPath(); }
  path1 += "UserFunctions.MML";
	FILE* cFile = fopen(path1,"w");
	if(cFile==NULL) { sprintf(gMsgStr,"Can't open file %s",path1.chars()); gPrintErr(); }
	else {
		sprintf(gMsgStr,"Writing UserFunction Registration file %s",path1.chars()); gPrintScreen(); 
		TNamedObjectList& fl = TFunction::FunctionList();
		for( Pix p = fl.first(); p; fl.next(p) ) {
			TFunction& f = (TFunction&) fl(p);
			if( f.Source() == kFS_UserLib ) { f.WriteMMLRegistration(cFile); }		
		}
		fputc('\n',cFile);
		fputc('~',cFile);
		fclose(cFile);
	}


} // TModel::WriteUserFunctionRegistration
  
  
  
 
  
