//----------------------------------------------------------------------------------------
  //	Model.h
  //	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
  //	Change History:
  //----------------------------------------------------------------------------------------
  
#ifndef __Model__
#define __Model__
  
#include "Globals.h"
#include "TObjects.h"
#include "Utilities.h"
#include "SList.h"
#include "CStream.h"
#include "ConfigObjects.h"
#include "MML_Model.h"

typedef class Module;

//----------------------------------------------------------------------------------------
//						TModel; 
//----------------------------------------------------------------------------------------;

class TModel : public Model 
{

private:
		
  static Model* kNullModel; 
  Module* fGlobalModule;
  int fFormat;
	CnfgProcessor fCR;
	FILE* fMMLFile;
	CString fXMLFilePath;

	int WriteSetupFile( char* cnfgExtension ) ;
			
 public:

  enum EPrintLevel { kComplete, kSynopsis };

  TModel(const CString& name);

  inline static TModel& I() {
    if(fInstance == kNullModel) { gFatal("Error, Recursive Call of Model Instantiator"); }
    else if(fInstance == NULL) {
      CString name("Model");
      CreateNewModel(name);
    }
    return (TModel&) *fInstance; 
  } 
  
  inline static TModel* CreateNewModel(const CString& s) {
		fInstance = kNullModel;
		fInstance = new TModel(s);
		fModelList.Insert(*fInstance);
		fCurrentModel = fInstance;
		fInstance->Init(); 
		((TModel*)fInstance)->IModel();
		return (TModel*)fInstance;
	}
	
  Module* CreateNewModule(const CString& s);
  
  void IModel ();
  int StartUp( int argc, char** argv );
  int Run();
  
  void SetInputFileName(int i, CString& sname) ;
	
  void WriteCG_MMLFile();
  int Config( TConfigData& cd );
  virtual void  WriteDataToConfig( CStream& outStream ); 
	void WriteUserFunctionRegistration();
	  
	virtual inline int GetFormat() { return fFormat; }
	virtual inline int SetFormat(int f) { return fFormat = f; }

};

#endif
