//----------------------------------------------------------------------------------------
// Config.cp
// Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//----------------------------------------------------------------------------------------

#include "Config.h"

//========================================================================================
// 				CLASS TConfigData
//========================================================================================


CString* TConfigData::Arg( int index, EStatus status) {
  if(index >= fNArgs ) {
    if( status == kRequired ) {
      sprintf(gMsgStr," %s:%s ( %s ) -> Syntax Error in configuration, Not Enough Args\n", 
	      (const char*) Name(), (const char*) Cmd(), fCArg[0].chars() ); 
      gProgramBreak();
    }
    return NULL;
  }
  else return ( &fCArg.elem(index) ); 
}

int TConfigData::IntArg( int index, int& arg, EStatus status ) {    
  if(index >= fNArgs ) {
    if( status == kRequired ) {
      sprintf(gMsgStr," %s:%s -> ( %s ) syntax Error in configuration, Not Enough Args\n",  
	      (const char*) Name(), (const char*) Cmd(), fCArg[0].chars() ); 
      gProgramBreak();
      return -2;
    }
    return 0;
  }
	errno=0;
  arg = atoi( fCArg[index].chars() );
	return !Util::CheckErrors( "IntArg", fCArg[index].chars(), index);
}

int TConfigData::FloatArg( int index, float& arg, EStatus status) { 
  if(index >= fNArgs ) {
    if( status == kRequired ) {
      sprintf(gMsgStr," %s:%s ( %s ) -> Syntax Error in configuration, Not Enough Args\n",  
	      (const char*) Name(), (const char*) Cmd(), fCArg[0].chars() ); 
      gProgramBreak();
      return -2;
    }
    return 0;
  }
	errno=0;
	arg = atof( fCArg[index].chars() );
	return !Util::CheckErrors( "FloatArg", fCArg[index].chars(), index);
}

int TConfigData::Pack() {
  int sLoc=0, i;
  fPackBuf[sLoc++] = fNArgs; 
  fPackBuf[sLoc++] = fLevelIndex; 
  fPackBuf[sLoc++] = fStatus + 100; 
  for(i=0; i<4; i++) { fPackBuf[sLoc++] = fInfo[i]; } 
  if(gDebug>1) {
    fprintf(gLogFile,"\n>>>>>>>>>>>>(%d):%d:PACK:(%c%c%c%c)\n",
	   fStatus,fNArgs,fInfo[0],fInfo[1],fInfo[2],fInfo[3]); 
  }
  for(i=0; i<fNArgs; i++) {
    if( sLoc+fCArg[i].length() + 1 >= kCMaxPackSize ) { fPackBuf[2] = i; return sLoc; }
    strcpy(fPackBuf+sLoc,(const char*)fCArg[i]);
    fPackBuf[sLoc+=fCArg[i].length()] = 0; sLoc++;
    if(gDebug>2) {
      fprintf(gLogFile,"(%d,%d)Py:%s\n",i,sLoc,(const char*)fCArg[i]); 
    }
  }  
  for(i=0; i<=fLevelIndex+1; i++) {
    if( sLoc+fName[i].length() + 1 >= kCMaxPackSize ) { fPackBuf[2] = i; return sLoc; }
    strcpy(fPackBuf+sLoc,(const char*)fName[i]);
    fPackBuf[sLoc+=fCArg[i].length()] = 0; sLoc++;
    if(gDebug>2) {
      fprintf(gLogFile,"(%d,%d)Py:%s\n",i,sLoc,(const char*)fName[i]); 
    }
  }
  return sLoc;
}

int TConfigData::addToString( CString& str ) {
  int i = 0;
  str += " ";
  str += Cmd();
  str += "( ";
  if( fNArgs > 0 ) { str += fCArg[0]; }
  for(i=1; i<fNArgs; i++) {
	str += ", ";
	str += fCArg[i];
  }  
  str += " ) ";
  return i;
}


void TConfigData::UnPack( ) {
  int sLoc=0, j=0, k=0;
  fNArgs = fPackBuf[sLoc++]; 
  fLevelIndex = fPackBuf[sLoc++]; 
  fStatus = fPackBuf[sLoc++]; fStatus -= 100;
  for(int i=0; i<4; i++) { fInfo[i] = fPackBuf[sLoc++]; }
  if(gDebug>2) {
    fprintf(gLogFile,"\n***************************(%d):%d:UPACK:(%c%c%c%c)\n",
	   fStatus,fNArgs,fInfo[0],fInfo[1],fInfo[2],fInfo[3]); 
  } 
  while(1) {
    if( sLoc == kCMaxPackSize ) { return; }
    CString& s = fCArg.elem(j);
    byte c0 = ( s(k++) = fPackBuf[sLoc++] );
    if(c0 == 0) {
      if(++j == fNArgs) break;
      else {
	k=0;
	if(gDebug>2) {
	  fprintf(gLogFile,"(%d,%d,%d)UP:%s\n",k,j,sLoc,(const char*)fCArg[j]);
	}
      }
    }
  }  
  while(1) {
    if( sLoc == kCMaxPackSize ) { return; }
    CString& s = fName.elem(j);
    byte c0 = ( s(k++) = fPackBuf[sLoc++] );
    if(c0 == 0) {
      if(j++ == fLevelIndex+1) break;
      else {
	k=0;
	if(gDebug>2) {
	  fprintf(gLogFile,"(%d,%d,%d)UP:%s\n",k,j,sLoc,(const char*)fName[j]);
	}
      }
    }
  }
}


  //========================================================================================
  // 				CLASS TConfigObject
  //========================================================================================
    
  
 //========================================================================================
 // 				CLASS TCnfgReader
 //========================================================================================

TCnfgReader::TCnfgReader() { 
  fCnfgFile = NULL;
  memset(fTerm,0,8);
  fNTerm = 0;
}

TCnfgReader::~TCnfgReader() { Close(); }
   	
void TCnfgReader::Close() { if(fCnfgFile) { fclose(fCnfgFile); fCnfgFile=NULL; } }

int TCnfgReader::Open(const char* filename, const char* ctrlChars, int NCtrl)
{
  int size=-1;
  fNTerm = NCtrl;
  fCnfgFile = fopen(filename,"r");
  if(fCnfgFile==NULL) { sprintf(gMsgStr,"Can't open file %s\n",filename); gPrintErr(); return 0; }
  for(int i=0; (i<NCtrl && i<6); i++) fTerm[i] = ctrlChars[i];
  Util::skip_white(fCnfgFile);
  sprintf(gMsgStr,"Opening config file: %s: ",filename); gPrintScreen(); 
  return 1;
}


int TCnfgReader::isTerm(char ch) {
  for(int i=0; i<fNTerm; i++ ) if( ch == fTerm[i] ) return i;
  return -1;
}

int TCnfgReader::BracketType(char ch) {
  static int inQuote = 0;
  if( inQuote ) {
	if( ch == '"' ) { inQuote = 0; return 1; }
	else return 0;
  }
  if( ch == '"' ) { inQuote = 1; return 1; }
  if( ch == ',' ) return 3;
  if( ch == ']' || ch == ')' || ch == '}' ) return 2;
  if( ch == '[' || ch == '(' || ch == '{' ) return 1;
  return 0;
}

int TCnfgReader::SkipCSpace(char& tch)
{
  int ch = tch;
  int rv = 1;
  while( isspace(ch) || ch == ',' || ch == '|' ) { 
    if(ch == '|') {
			rv = 2;
      while ( (ch != '\n')  &&  ( ch != EOF ) ) { ch=fgetc(fCnfgFile); fComment += ((char)ch); }
    }
    if( ch == EOF ) {
      fclose(fCnfgFile); fCnfgFile = NULL; tch = ' '; return -3; 
    }
    ch=fgetc(fCnfgFile);
  }
  tch = ch;
  return rv;
}


int TCnfgReader::ReadCmd( int reset ) {
  int msgSize, iproc=gMyID();
  if( gGlobalFileSystem ) { return ParseConfig(reset); }
  else { 
    if( iproc == 0 ) { ParseConfig(reset); }
    if( gNProcs() > 1) {
      if( iproc == 0 ) { msgSize = Pack(); }
#ifdef USE_MPI
	if( gMPI ) {
      MPI_Bcast( &msgSize, 1, MPI_INT, 0, MPI_COMM_WORLD );
      MPI_Bcast( fPackBuf, msgSize, MPI_CHAR, 0, MPI_COMM_WORLD );
	}
#endif
      if( iproc != 0 ) { UnPack(); }
    }
    return fStatus;
  }
}


int TCnfgReader::ReadEnvVar( CString& s ) {
    int test=fgetc(fCnfgFile);
    CString var;
    if( test == '{' ) {
	   while ( ( test = fgetc(fCnfgFile) ) != '}' ) {
		 var += (char)test; 
	   } 
	   s += Env::GetEnv( var );
    } else {
	  s += (char)test; 
	}
	return 0;
}

int TCnfgReader::ReadArg( CString& s, char& ch ) {
  s.clear(); 
  if( BracketType(ch) ) ch = fgetc(fCnfgFile); 
  if( SkipCSpace(ch) < 0 ) return -3;
  int test = ch, bt=0;
  while ( !isspace(test) ) {
    if( bt = BracketType(test) ) break;
    if( test == '$' ) {
	  ReadEnvVar(s);
    } else {
	  s += (char)test; 
	}
    test=fgetc(fCnfgFile); 
    if(test == EOF || test == 0) return -3; 
  }
  while( test == ' ' ) test=fgetc(fCnfgFile);
  if( test == EOF || test == 0 ) return -3; 
  ch = test;
  return ( bt == 0 ) ? BracketType(test) : bt;
}

char getEChar(char ch) {
  switch(ch) {
  case '{': return '}';
  case '(': return ')';
  case '[': return ']';
  }
}
    
int TCnfgReader::ParseConfig(int reset) {
  static char ch = ' '; 
  if( reset ) { ch = ' '; }
  fInfo[kNewObject] = 0;
  fComment.clear();
  if(fCnfgFile == NULL) {  return fStatus = -3; }
  int ctst;
  while (1) {
    if ( (ctst = SkipCSpace(ch)) < 0) {  return fStatus = -3; }
    if( ctst == 2 ) {
			fName.elem(fLevelIndex+1) = "comment";
			fCArg.elem(0) = fComment;
			fNArgs = 1;
			return fStatus = 1; 
		}  // comment.
    int iLevel; 
    if( ( iLevel = isTerm(ch)) >= 0 ) {
      fCnfg = ch; ch = ' ';
      fObjectIndex = fLevelIndex = iLevel;
      fInfo[kNewObject] = 1;
      if ( ReadArg( fName.elem(iLevel), ch) != 0 ) { ch = ' '; return fStatus = -3; }
//	  fprintf(stderr,"\n          ** dbg4: Process %c %s",  fCnfg, fName.elem(iLevel).chars() ); fflush(stderr);
    }
    else break;
  }  
  fInfo[0] = fCnfg;
  char eChar;
  if( ReadArg(fName.elem(fLevelIndex+1),ch) == 1 ) eChar = getEChar(ch); 
  else return fStatus = -3;
  int go = 1, argc = 0;
  while (go) {
    switch( ReadArg( fCArg.elem(argc), ch ) ) {
    case 3: argc++; break;
    case 2:
      if( ch == eChar ) {  argc++; go=0; break;} 
      else { 
				sprintf(gMsgStr, "Syntax error in parse_config, var: %s\n",(const char*)fCArg[0]); gPrintErr();
				return fStatus = -2;
      }
		case -3: 
			sprintf(gMsgStr, "EOF Syntax error in parse_config, var: %s : ",(const char*)fCArg[0]); gPrintErr();
			for(int i=1; i<=argc; i++) { sprintf(gMsgStr, " %s ",(const char*)fCArg[i]); gPrintErr(); }
			return fStatus = -2;	
    }
  }
  fNArgs = argc; ch = ' '; 
//  fprintf(stderr,"\n        ** dbg3: Read cmd: %s", fName[fLevelIndex+1].chars() ); fflush(stderr);
  return fStatus = 1;	
} 

