//----------------------------------------------------------------------------------------
//	MML_Frame.cc
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------
  
#include "MML_Frame.h"
#include "MML_Model.h"
#include "MML_Module.h"
#include "MML_Variable.h"
#include "sme_postgres.h"
#include "GOFCalc.h"

//========================================================================================
// 								CLASS LayerConfig
//========================================================================================

int LayerConfig::fNLinkLayers = 0;
EConfigInfo LayerConfig::kType = kCInfo0;
EConfigInfo LayerConfig::kisSetup = kCInfo1;
EConfigInfo LayerConfig::kSetupMode = kCInfo2;

LayerConfig& LayerConfig::operator= ( LayerConfig& f ) {
  fType = f.fType;
  fMapName = f.fMapName;
  fFormat = f.fMapName;
  fMapSource = f.fMapSource;
  TNamedObject::operator= ( f );
  return *this;
}

float* LayerConfig::GetDepthArray() { 
  if( fDepthArray == NULL ) {
	fDepthArray = new float[fDim[2]];
	for( int i=0; i<fDim[2]; i++ ) fDepthArray[i] = 0.0;
  }
  return fDepthArray;
}

Variable* LayerConfig::GetVariable( CString& name ) {
  Variable* var = NULL;
  name.upcase();
  int mIndex = name.index('.');
  if(  mIndex > 0 ) { 
	CString moduleName(name.before('.'));
	Module* mod = (Module*) Model::I0().GetModule(moduleName);
	if(mod==NULL) { gProgramBreak( CString(moduleName) += ":  Can't find module");  }
	else {
	  CString varName(name.after('.'));
	  var = (Variable*) mod->GetVariable(varName);
	  if(var==NULL) gProgramBreak( CString(varName) += ": Can't find variable");
	}
  } else { 
	for( int i=0; i<fModules.length(); i++ )  {
	  Module* aModule = (Module*) fModules.elem(i);
	  if( aModule != NULL ) {
		Variable* aVar = aModule->GetVariable(name,False);
		if(  aVar != NULL ) {
		   if( aVar->GetF(FisImport) ) {
			 if( var == NULL ) { var = aVar; }
		   } else {
			 var = aVar;
		   }
		}
	  }
	}
  }
  return var;
}

void LayerConfig::SetupMaps() {
  CString* map; int index=0;
  while(  ( map = getMapName( index++ ) ) != NULL ) {
	map->upcase();	
	Variable* var = Model::I0().GetVariable(*map);
	if( var != NULL ) {
	  var->MakeMapInputVariable( 0 );
	} else {
	   sprintf(gMsgStr,"Can't find Variable referenced in Frame Config: %s ",map->chars()); gFatal();
	}
  }
}

int LayerConfig::AddModule( Module* m ) { 
	int idx = fModules.find_elem( m );	
	if( idx < 0 ) { 
		idx = fModules.add_high(m) - 1; 
	} 
	return  idx;
}

void LayerConfig::WriteDataToConfig( CStream& outStream ) { 
    if( fType == 0 ) return;
    if( fType == 'C' ) {
			outStream << " PC( " << fDim[0] << "," << fDim[1]<< "," << fDim[2] << ")";
    }  else  if( fType == 'S' ) {
			outStream << " PS( ";
			outStream << "," << fMethodName; 
			outStream << "," << fFormat; 
			outStream << "," << fOrder; 
			outStream << ") "; 
    } else {
			outStream <<  fType << "(" << fMapSource << "," << fMapName;
			outStream << "," << fMethodName; 
			outStream << "," << fFormat; 
						  
			CString* rv; int index=0;
			while(  (rv = getMapName( index++ ) ) != NULL ) {
			  outStream << "," << *rv;
			}
			
			outStream << ") "; 
		}
}

void LayerConfig::SetDim( int dim, int val ) { 
  fDim[dim] = val; 
}

//========================================================================================
// 								CLASS Frame
//========================================================================================

int MFrame::kMaxArgs = 10;  

LayerConfig* MFrame::getLayerConfig( char type, CString& mapName, CString& mapSource, Module* m  ) {
	fCurrentLayerConfig = NULL;
	for( Pix p = fLayerConfigs.first(); p; fLayerConfigs.next(p) ) {
		LayerConfig& lc = (LayerConfig&) fLayerConfigs(p);
		if( lc.SameConfig ( type, mapName, mapSource  ) ) {
			fCurrentLayerConfig = &lc;
			break;
		}
	}
	if( fCurrentLayerConfig == NULL ) { 
		fCurrentLayerConfig = new LayerConfig(type, mapName, mapSource ); 
		fLayerConfigs.append(*fCurrentLayerConfig);
	}
	if( m ) {
		m->SetLayerConfig(fCurrentLayerConfig);
	}
	return fCurrentLayerConfig;
}

LayerConfig* MFrame::getLayerConfig( CString& mapName, CString& mapSource, CString& arrayName  ) {
	fCurrentLayerConfig = NULL;
	char type = 'A';
	for( Pix p = fLayerConfigs.first(); p; fLayerConfigs.next(p) ) {
		LayerConfig& lc = (LayerConfig&) fLayerConfigs(p);
		if( lc.ArrayName() = arrayName ) {
		  fCurrentLayerConfig = &lc;
		}
	}
	if( fCurrentLayerConfig == NULL ) { 
		fCurrentLayerConfig = new LayerConfig(type, mapName, mapSource, arrayName ); 
		fLayerConfigs.append(*fCurrentLayerConfig);
		fCurrentLayerConfig->SetType( kArray );
	}
	return fCurrentLayerConfig;
}


LayerConfig* MFrame::getLayerConfig( char type, Module* m  ) {
	fCurrentLayerConfig = NULL;
	for( Pix p = fLayerConfigs.first(); p; fLayerConfigs.next(p) ) {
		LayerConfig& lc = (LayerConfig&) fLayerConfigs(p);
		if( lc.SameType ( type ) ) {
			fCurrentLayerConfig = &lc;
			break;
		}
	}
	if( fCurrentLayerConfig == NULL ) { 
		fCurrentLayerConfig = new LayerConfig(type ); 
		fLayerConfigs.append(*fCurrentLayerConfig);
	}
	if( m ) {
		m->SetLayerConfig(fCurrentLayerConfig);
	}
	return fCurrentLayerConfig;
}

void MFrame::ReLink( Module* m ) {
	LayerConfig* lc =  m->getLayerConfig();
	if( lc && lc->FrameLinkBase() ) { lc->FrameLinkBase()->DynamicRelink(); }
}

void MFrame::SetupMaps() {
	for( Pix p = fLayerConfigs.first(); p; fLayerConfigs.next(p) ) {
		LayerConfig& lc = (LayerConfig&) fLayerConfigs(p);
		lc.SetupMaps();
	}
}

LayerConfig* MFrame::getLayerConfig( Module* m  ) {
	for( Pix p = fLayerConfigs.first(); p; fLayerConfigs.next(p) ) {
		LayerConfig& lc = (LayerConfig&) fLayerConfigs(p);
		if( lc.HasModule(m) ) {
			fCurrentLayerConfig = &lc;
			return fCurrentLayerConfig;
		}
	}
	return NULL;
}

int  MFrame::ArrayConfig(CString& mapName, CString& mapSource, CString& arrayName ) {
	LayerConfig* l =  getLayerConfig( mapName, mapSource, arrayName  );
	fMapSource = mapSource;
	fMapName = mapName;
//	l->SetDimensions(rows,cols,nLayers);
}

int  MFrame::Config( TConfigData& cd, Module* m ) {
  const CString& cmd = cd.Cmd();
  int rv = 0;
  if(gDebug) { 
    sprintf(gMsgStr,"Reading Frame Config for %s: Nargs = %d, CMD = %s",
	    fName.chars(), cd.NArgs(), cmd.chars() );	
    gPrintLog();  
  }
  int iarg; float farg; CString* s; 
	fFormat = "";
	char cc = cmd[0];
	LayerConfig* l;
  if( ( cmd == "g" ) || ( cmd == "G" ) || ( cmd == "V" ) ) {
	  rv = 1; 
	  if( (s = cd.Arg(0)) != NULL ) {
		fMapSource = *s;
		if( (s = cd.Arg(1)) != NULL ) {
			fMapName = *s;
			if( (s = cd.Arg(2)) != NULL ) {
				fMethodName = *s;
				if( (s = cd.Arg(3)) != NULL ) { 	
					fFormat = *s;
				} 
			}  else fMethodName = "default";
		}
	  }
	  l = getLayerConfig( cc, fMapName, fMapSource, m );
	  if( (fFormat != "cln.grd")  && ( fFormat != "default" ) ) {
		l->fFormat = fFormat;
	  }
	  l->fMethodName = fMethodName;
	  if( fMethodName.equals_nocase("multigrid") ) {
		l->SetDim( 2, atoi( fFormat.chars() ) );
	  }
	  iarg = 4;
	  while( ( s = cd.Arg(iarg++) ) != NULL ) { l->addMapName(*s); }
	  if( cc == 'V' ) l->SetType( kVolume );
	  else l->SetType( kGrid );
#ifdef OM3
	  if( fFormat == "om3" ) {
		int cols = om3_get_grid_dim( 0 ), rows = om3_get_grid_dim( 1 ), nLayers = om3_get_grid_dim( 2 );
		l->SetDimensions(rows,cols,nLayers);
	  }
#endif
  } else if( ( cmd == "T" ) || ( cmd == "t" ) ) {
		rv = 1; 
    if( (s = cd.Arg(0)) != NULL ) {
      fMapSource = *s;
			if( (s = cd.Arg(1)) != NULL ) {
				fMapName = *s;
				if( (s = cd.Arg(2)) != NULL ) {
					fMethodName = *s;
					if( (s = cd.Arg(3)) != NULL ) { 	
						fFormat = *s;
					} 
				}  else fMethodName = "default";
			}
		}
		l = getLayerConfig( cc, fMapName, fMapSource, m );
		if( (fFormat != "cln.grd") && ( fFormat != "default" ) ) {
		  l->fFormat = fFormat;
		}
		l->fMethodName = fMethodName;
		l->SetType( kTree );
    if( cmd == "T" ) l->SetCInfo(LayerConfig::kSetupMode,1);
  } else if( cmd == "PC"  ) {
		rv = 1; 
		int iarg, rows=1, cols=1, nLayers = 1;
		if( cd.IntArg(0,iarg) > 0 ) rows = iarg;
		if( cd.IntArg(1,iarg) > 0 ) cols = iarg;
		if( cd.IntArg(2,iarg) > 0 ) nLayers = iarg; 
		if(gDebug) { 
			sprintf(gMsgStr,"Creating PointCollection Frame, dims=(%d,%d,%d)",rows,cols,nLayers );	
			gPrintScreen();  
		}
		l = getLayerConfig( 'C', m );
		l->SetType( kCollection );
		l->SetDimensions(rows,cols,nLayers);
		
  } else if( cmd == "PS"  ) {
	rv = 1; 
	int order = 0;
	l = getLayerConfig( 'S', m );
	l->SetType( kParameterSpace );
  
     if( (s = cd.Arg(0)) != NULL ) {
	   fMethodName = *s;
	   l->fMethodName = fMethodName;
#ifdef HAS_MPE
	   GOFCalc::configureGOF( fMethodName,  cd );
#endif
	} 
  }
#ifdef POSTGRESS
	if( fMapSource == "DB" && Model::I0().DataBase() ) { 
		CString filename(fMapName); filename+=".sds";
		pgObjRec::AddDBaseObject(fFormat,fMapName,filename); 
	}
#endif

//  while ( cd.IntArg(fNIargs+2,fIArgs[fNIargs]) > 0 )  { if ( ++fNIargs == kMaxArgs ) break; }
	return rv;
}


