//-------------------------------------------------------------------------------
//	Frame.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//	
//--------------------------------------------------------------------------------

#ifndef __LayerConfig__
#define __LayerConfig__

#include "ConfigObjects.h"
#include "CStream.h"
#include "FLBase.h"
#include "PixPlex.h"
#include "ByteGrid.h"
typedef class Module Module;

enum ETopology { kUndefined, kGrid, kNetwork, kTree, kCollection, kScalar, kVolume, kArray, kParameterSpace  };

class LayerConfig : public TConfigObject {
	friend class MFrame;
	
  CString fMapName;
  CString fMapSource;
  CString fArrayName;
	int fActivationLayer;
	int fCellLayer;
	int fLinkLayer;
	int fOrder;
	CString fMethodName;
  byte fNIargs;
  char fType;
	FLBase* fFLBase;
	CString fFormat;
	int fIArgs[10];
	int fDim[3];
	PixXPlex fModules;
	ByteGrid* _depthMap;
	static int fNLinkLayers;
	StringPlex fMapNames;
	float* fDepthArray;

	
public:

  static EConfigInfo kType;
  static EConfigInfo kisSetup;
  static EConfigInfo kSetupMode;
  	
	LayerConfig(int index) : TConfigObject("Layer",kObject,index) { fType=0; fNIargs=0; fFLBase=0; fMethodName="default"; fFormat="default";  
		fActivationLayer = fCellLayer = 0; fOrder = -1; fLinkLayer = fNLinkLayers++; fDim[0] = 0; fDim[2] = 1; fDepthArray=NULL; 
	} 
	LayerConfig( char type, CString& mapName, CString& mapSource ) : TConfigObject("Layer",kObject) { 
		fType=0; fNIargs=0; fFLBase=0; fMethodName="default"; fFormat="default";   fDim[0] = 0; fDim[2] = 1;  fDepthArray=NULL; 
		fActivationLayer = fCellLayer = 0; fOrder = -1; fLinkLayer = fNLinkLayers++;	fType = type; fMapName = mapName; fMapSource = mapSource;
	}
	LayerConfig( char type, CString& mapName, CString& mapSource, CString& arrayName ) : TConfigObject("Layer",kObject) { 
		fType=0; fNIargs=0; fFLBase=0; fMethodName="default"; fFormat="default";   fDim[0] = 0; fDim[2] = 1;  fDepthArray=NULL; 
		fActivationLayer = fCellLayer = 0; fOrder = -1; fLinkLayer = fNLinkLayers++; fType = type; 
		fMapName = mapName; fMapSource = mapSource; fArrayName	= arrayName; 
	}

	LayerConfig( char type ) : TConfigObject("Layer",kObject) { 
		fType=0; fNIargs=0; fFLBase=0; fMethodName="default"; fFormat="default";  fDim[0] = 0; fDim[2] = 1;  fDepthArray=NULL;
		fActivationLayer = fCellLayer = 0; fOrder = -1; fLinkLayer = fNLinkLayers++;	fType = type; 
	}
	
	LayerConfig& operator= ( LayerConfig& f );
	inline CString& ArrayName() { return fArrayName; }

  inline int  operator== ( const LayerConfig& f ) const {
    return ( (fType == f.fType) && (fMapName == f.fMapName) && (fMapSource == f.fMapSource) );
  }
  
  inline void SetType( ETopology type ) { SetCInfo(kType,type); }
  
  void SetDim( int dim, int val ) ;
  
  inline ETopology Type() { return (ETopology) GetCInfo(kType); }

	inline void SetDimensions( int rows, int cols, int nLayers = 0 ) {
		if( fDim[0] > 0 ) {
			if( (fDim[0] != rows ) || ( fDim[1] != cols ) ) { 
				gPrintErr( "Attempt to change dimensions of Point Collection: not allowed!");
			}
		} else {
			fDim[0] = rows; fDim[1] = cols; 
			if( nLayers > 0 ) { fDim[2] = nLayers; }
		}
	} 
	inline int Dim( unsigned int index ) { 
		if( (index > 2) ) { 
			gPrintErr( "Illegal index in FrameConfig!");
			return 0;
		}
		return fDim[index]; 
	}
  float* GetDepthArray();
  inline CString& MapSource() { return fMapSource; }
  inline CString& MapName() { return fMapName; }
  inline CString& MethodName() { return  fMethodName; }	
  inline CString& Format() { return  fFormat; }	
  inline FLBase* FrameLinkBase() { return fFLBase; }
  inline int HasModule( Module* m ) { 	return ( fModules.find_elem( m ) >= 0 ); }
  int AddModule( Module* m );
  inline Module* GetModule(int index) { return (Module*) (( index >= fModules.length()) ? NULL : fModules.elem(index)); }  
  Variable* GetVariable( CString& name ) ; 
  
  inline void addMapName( CString& map ) { 
	fMapNames.add(map); 
  }
  inline CString* getMapName( int index ) { 
	return fMapNames.get(index); 
  }
  inline void setDepthMap( ByteGrid* map ) { _depthMap = map; }
  inline ByteGrid* getDepthMap() { return _depthMap; } 
  
  inline int activationLayerIndex() { return fActivationLayer; }
	inline int LinkLayer() { return fLinkLayer; }
 	inline int CellLayer() { return fCellLayer; } 	
 
  inline int  SameConfig ( char type, CString mapName, CString mapSource  ) const {
    return ( (fType == type) && (fMapName == mapName) && (fMapSource == mapSource) );
  }
  inline int  SameType ( char type ) const {
    return ( fType == type );
  }
	inline int  SameMap ( const LayerConfig& f ) const {
    return ( (fMapName == f.fMapName) && (fMapSource == f.fMapSource) );
  }
 	
  inline void SetFrameLink(FLBase* f)  { fFLBase = f; }
  void SetupMaps();

	
  void WriteDataToConfig( CStream& outStream );
};

//----------------------------------------------------------------------------------------
//						Frame
//----------------------------------------------------------------------------------------

class MFrame : public TConfigObject
{
protected:

  static int kMaxArgs;
  CString fMapName;
  CString fMapSource;
	CString fFormat;
	CString fMethodName;
  TNamedObjectList fLayerConfigs;
  LayerConfig* fCurrentLayerConfig;

	LayerConfig* getLayerConfig( char type, CString& mapName, CString& mapSource, Module* m   );
	LayerConfig* getLayerConfig( CString& mapName, CString& mapSource, CString& arrayName  ) ;
	LayerConfig* getLayerConfig( char type, Module* m   );
public:
  
  MFrame() : TConfigObject("Frame",kObject) { fCurrentLayerConfig = NULL;  } 
  virtual int Config( TConfigData& cd, Module* m );
	inline LayerConfig* SetDefaultLayers( int& activationLayer, int& linkLayer ) {
		if( fCurrentLayerConfig == NULL ) return NULL; 
		activationLayer = fCurrentLayerConfig->fActivationLayer, linkLayer = fCurrentLayerConfig->fLinkLayer;
		return fCurrentLayerConfig; 
	}
	
  inline void WriteModuleDataToConfig( CStream& outStream, Module* m ) { 
		LayerConfig* l = getLayerConfig( m  );
		if(l) { l->WriteDataToConfig( outStream ); }
	}
  void WriteGlobalDataToConfig( CStream& outStream ) { ; }
  void Dump( FILE* oFile ){;} 

	virtual void* getMultiGrid() { return NULL; }
	LayerConfig* getLayerConfig( Module* m  );
	int  ArrayConfig(CString& mapName, CString& mapSource, CString& arrayName );
	void ReLink( Module* m );
	void SetupMaps();
        
};

#endif
