//----------------------------------------------------------------------------------------
//	LUT.h;
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.;
//	Change History:;
//----------------------------------------------------------------------------------------;
  
#ifndef __MML_LUT__
#define __MML_LUT__
  
#include "ConfigObjects.h"
#include "TimePlex.h"
#include "MML.h"

typedef class Module Module;
typedef class TCommand TCommand;
typedef class TListNode TListNode;
typedef class TGraphNode TGraphNode;
//----------------------------------------------------------------------------------------
//						TLUT; 
//----------------------------------------------------------------------------------------;
  
class TLUT : public TTemporalTimeSliceRPlex, public TNamedObject, public MMLObject
{
 private:
  
  unsigned int fNumLUT;
  unsigned int fLUTIndex;
  byte fDerivative;
  CString fMethodName;
  
 public:
  
  TLUT( const char* name ); 
  
  int ILUT ( Module* aModule );

  inline int Index() { return fLUTIndex; } 
  inline byte Derivative( int d = -1 ) { 
		if( d >= 0 ) { fDerivative = d ; } 
		return fDerivative; 
	}
  
  inline void IndexName() { fName.appendIndex( fLUTIndex ); } 
  
  void  Print(FILE* cEqnFile) const;
  void  Read(FILE* inFile);

  int AddPoint( float x, const float* y, int ngraph );
  int AddPoint( CString res[], int ngraph );
  void Dump(FILE* oFile) { Print(oFile); }

  virtual int AddModifier( const CString& mod, Bool isExtension = False ) { return 0;}
  virtual void WriteMML( FILE* oFile, EWriteMode mode = kDefinition );
  virtual void WriteXML( FILE* oFile );
  virtual void WriteCCode(FILE* cHdrFile, FILE* cEqnFile);
  virtual void WriteDCode(FILE* cHdrFile, FILE* cEqnFile) const;
	virtual void WriteDCode(TCommand* c, CString& s,  TListNode* arg, int isGlobal=0, int wContext=0  );

  virtual int ProcessGeneral(TNode* n);
  virtual int ProcessCommand(const TCommandNode* n);
	virtual int ProcessAttribute(const TAttributeNode* n);
	const CString& MethodName() const { return fMethodName; }

};

#endif

