#include "MML_Method.h"
#include "MML_Module.h"
#include "MML_Event.h"
#include "MML_LUT.h"
#include "ExprBuilder.h"

//========================================================================================
  // 								CLASS TMethod 
  //========================================================================================
  
//----------------------------------------------------------------------------------------
  //				TMethod::TMethod:
  //----------------------------------------------------------------------------------------
  
TMethod :: TMethod (const char* name) : TNamedObject(name) 
{ 
  fMethodIndex = 0; 
  fLUT = NULL; 
} // TMethod :: Initialize
  
  
  //----------------------------------------------------------------------------------------
  //				TMethod::IMethod:
  //----------------------------------------------------------------------------------------
  
  int TMethod :: IMethod ( Module* thisModule ) 
{
  Pix p = thisModule->MethodList().Insert(*this);
  if( p != 0 ) {
	fMethodIndex = (int) thisModule->MethodList().index(p);
	return fMethodIndex;
  }
  return -1;
  
}  // TMethod :: IMethod
  

//----------------------------------------------------------------------------------------
//				TMethod::Print:
//----------------------------------------------------------------------------------------
  
  
  void  TMethod::Print(FILE* oFile) const 
{ 
  fprintf(oFile,"\n\tMethod %s (", (const char*)fName );
  fArgList.PrintList(oFile);
  fprintf(oFile,") {\n\t%s\n\t}\n", (const char*)fValue );  
  
}  //  TMethod::Print

//----------------------------------------------------------------------------------------
//				TMethod::PrintMML:
//----------------------------------------------------------------------------------------

void  TMethod::WriteMML(FILE* oFile, EWriteMode mode) {
  fprintf(oFile,"\tMethod %s {\n\t\tArguments = (  ", (const char*)fName );
  fArgList.PrintList(oFile);
  fprintf(oFile," );\n\t\tValue = { ", (const char*)fValue );
  fprintf(oFile," };\n\t}\n");  
} 

  //----------------------------------------------------------------------------------------
  //				TMethod::WriteCCode:
  //----------------------------------------------------------------------------------------
  
  
  void  TMethod :: WriteCCode(FILE* cHdrFile, FILE* cEqnFile)
{ 
	if(fLUT) return;
	
}  //  TMethod::WriteCCode

void TMethod::WriteCCode( TCommand* c,  CString& s,  TListNode* arg, int isGlobal, int wContext    ) {
	
	s += fName; 
	s += '('; arg->WriteCCode(c,s,isGlobal,wContext); s += ')'; 

}

void TMethod::WriteDCode( TCommand* c, CString& s, TListNode* arg, int isGlobal, int wContext    ) {
	if( fLUT ) { fLUT->WriteDCode( c, s, arg, isGlobal, wContext  ); }
	else { 
		
		s += fDerivative; 
		s += '('; arg->WriteDCode(c,s,isGlobal,wContext); s += ')'; 
	}
}

  //----------------------------------------------------------------------------------------
  //				TMethod::ProcessGeneral:
  //----------------------------------------------------------------------------------------
  

int TMethod :: ProcessGeneral(TNode* n) {
	if( n->NodeType() == TNode::kGraph ) {
		return 0;
	}
	return 0;
}

int TMethod :: ProcessCommand(const TCommandNode* n) { return 0; }

int TMethod :: ProcessAttribute(const TAttributeNode* an) {
	const TDeclarationNode* dn = an->Declaration();
	CString& cmd = (CString&) dn->Command();
	const TNode* vn = an->Value();
	cmd.downcase();
	
	if( cmd == "arguments" ) {
		GetAttributeStringList( vn, fArgList );
		return 1;
	}
	if( cmd == "value" ) {
		fNode = (TNode*)vn;
		return 1;
	}
  return 0;
}



