//----------------------------------------------------------------------------------------
//	Method.h;
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.;
//	Change History:;
//----------------------------------------------------------------------------------------;
  
#ifndef __MML_Method__
#define __MML_Method__
  
#include "ConfigObjects.h"
#include "MML.h"

typedef class Module Module;
typedef class TLUT TLUT;
typedef class TCommand TCommand;
typedef class TListNode TListNode;

//----------------------------------------------------------------------------------------
//						TMethod; 
//----------------------------------------------------------------------------------------;
  
class TMethod : public TNamedObject, public MMLObject
{
 private:
  
  unsigned int fMethodIndex;
  CString fDerivative;
  ArgArray fArgList;
  CString fValue;
  TLUT* fLUT;
  
 public:
  
  TMethod( const char* name ); 
  
  int IMethod ( Module* aModule );

  inline int Index() { return fMethodIndex; } 
  
  inline void IndexName() { fName.appendIndex( fMethodIndex ); } 
  
  void  Print(FILE* cEqnFile) const;
  void Dump(FILE* oFile) { Print(oFile); }

  virtual int AddModifier( const CString& mod, Bool isExtension = False ) { return 0;}
  virtual void WriteMML( FILE* oFile, EWriteMode mode = kDefinition );
  virtual void WriteCCode(FILE* cHdrFile, FILE* cEqnFile);
  void WriteCCode( TCommand* c,  CString& s,  TListNode* arg, int isGlobal=0, int wContext=0  );
	virtual void WriteDCode(TCommand* c, CString& s,  TListNode* arg, int isGlobal=0, int wContext=0  );
	inline int Differentiable() { return !( fDerivative.empty() && (fLUT == NULL) ); }

  virtual int ProcessGeneral(TNode* n);
  virtual int ProcessCommand(const TCommandNode* n);
	virtual int ProcessAttribute(const TAttributeNode* n);
	CString& Value() { return fValue; }
  inline TLUT* GetLUT() { return fLUT; }
  inline TLUT* SetLUT(TLUT* lut) { return fLUT = lut; }
};

#endif

