#include "MML_Module.h"
#include "MML_Model.h"
#include "MML_Variable.h"
#include "MML_Connection.h"
#include "MML_Event.h"
#include "MML_LUT.h"
#include "MML_Method.h"
#include "MML_Pipe.h"
#include "ExprBuilder.h"

int Module::fCount=0;
EConfigInfo Module::kDebug= kCInfo0;
EConfigInfo Module::kIgnorable= kCInfo1;

//----------------------------------------------------------------------------------------
//			       Module
//----------------------------------------------------------------------------------------

Module::Module( CString name ) : TConfigObject ( name, kModule, fCount++ ),  kNewEvent(2),  
  fVarList( name + " Module Variable List" ), fLUTList( name + " Module LUT List" ), fMethodList( name + " Module Method List" ), fSchedule(name) 
{
  SetCInfo( kDebug, kNoConfig );
  Env::EAppType app =  (Env::EAppType) Env::GetInfo(Env::kAppType);
  int ignorable = ( name.index("XXXImports") == 0 ); //  && ( app != Env::kDriver );
  sprintf(gMsgStr,"\nAllocating module %s; ignorable: %d\n",name.chars(),ignorable); gPrintLog();
  SetCInfo( kIgnorable, ignorable );
  fConnectionList = NULL;
  fSuper = NULL;
  fModuleNode = NULL;
  fModel = NULL;
	fActivationLayer = -1;
	fLinkLayer = -1;
	fLayerConfig = NULL;
}

int Module::Config( TConfigData& cd) {
  const CString& cmd = cd.Cmd();

  int iarg; float farg; CString* s;
  if( (iarg = Model::I0().FrameConfig(cd,this)) > 0 ) {
		Model::I0().SetDefaultLayers(fActivationLayer,fLinkLayer);
		return iarg;
  } else if( cmd == "OS" || cmd == "OT"  ) {
		fSchedule.Config(cd);	
		for( Pix p = fEventList.first(); p; fEventList.next(p) ) {
			TEvent& e = (TEvent&) fEventList(p);
			e.SetSchedule(&fSchedule);
		}
	/*
    if( cnt == 0 || Env::GetInfo(Env::kEventsDefined) ) {
			return fSchedule.Config(cd);				
		} 
		*/
  } else if( cmd == "comment" ) {
			if( cd.HasArg(0) ) { fComment = *cd.Arg(0);  }   
   } else if( cmd == "d" ) {
    if( cd.IntArg(0, iarg, CD::kRequired) > 0 ) SetCInfo(kDebug,iarg);
    return 1;
	} else if( cmd == "es" ) {
    CString name("script");
    name.appendIndex(fScriptIndex++);
    TScriptCommand* sc = new TScriptCommand(name,this);
    if( (s = cd.Arg(0)) != NULL ) sc->Script() = *s;
    fCommandList.append(*sc);
  }
  return 0;
}

int  Module::AddModifier( const CString& mod, Bool isExtension ) {
  if( mod == "root" ) { Model::I0().GlobalMod(this); return 1; }
  if( mod == "global" ) { Model::I0().GlobalMod(this); return 1; }
}

void  Module::WriteDataToConfig( CStream& outStream ) 
{
  MFrame& f = Model::I0().Frame();
  f.WriteModuleDataToConfig( outStream, this );  
  if( fSchedule.ScheduleConfigured() ) fSchedule.WriteDataToConfig(outStream);
	if( fActivationLayer >= 0 ) { outStream << " AL(" << fActivationLayer << "," <<  fLinkLayer << ") "; }
  if( GetCInfo(kDebug) != kNoConfig  ) outStream << " d(" <<  (int)GetCInfo(kDebug) <<") ";
	for( Pix pc = fCommandList.first(); pc; fCommandList.next(pc) ) {
		TCommand& c = (TCommand&) fCommandList(pc);
		if( c.GetObjInfo(TCommand::kExType) == TCommand::kScript ) {	  
			TScriptCommand* sc =  (TScriptCommand*) &c;
			outStream << " es("  << sc->Script() << ") ";
		}
	}
	if( !fComment.empty() ) { outStream << " | " << fComment; }

} //	TModule::WriteDataToConfig


int Module::RunNodeProcessing( EProcessContext pc ) { 
	for( Pix p = fVarList.first(); p; fVarList.next(p) ) {
		Variable& v = (Variable&) fVarList(p);
		v.RunNodeProcessing(pc);
	}
/*
	if( fModuleNode == NULL ) { return 0; } 
	const TListNode* ln = fModuleNode->EqnList();
	if( ln == NULL ) { return 0; } 
	const TOrderedObjectDLList& list = ln->List();
	for( Pix p = list.first(); p; list.next(p) ) {
		const TNode* n = (const TNode*) &list(p);
		ProcessNode(n);
	}
*/
	return 1;
}


int Module::ProcessGeneral( TNode* n) {
	switch( n->NodeType() ) {
		case TNode::kModule: {
			fModuleNode = (TModuleNode*) n;
			TListNode* ln = (TListNode*) fModuleNode->EqnList();
			SetNode(ln);
			return ProcessNode();
		} 
		case TNode::kEquation: {
			const TEquationNode* en = (const TEquationNode*)n;
			if( en->GetObjInfo(TEquationNode::kEquationType) == TEquationNode::kRelCode) break;
			Variable* v = CreateNewVariable( en->VarName() );
			v->SetNode( (TNode*) en );
			return v->ProcessNode();
		} 
	}
	return 0;
}

int Module::ProcessCommand(const TCommandNode* cn){
	const TDeclarationNode* dn = cn->Declaration();
	const CString& cmd = dn->Command();
	const CString& name = (dn->Name()) ? dn->Name()->Top() : gNullString;
	int isExtension = dn->IsExtension();

  if( (cmd == "Variable") ||  (cmd == "atom") ||  (cmd == "port") ) {
	Variable* currentVar = (isExtension) ? GetVariable(name,False): GetVariable(name);
	if( currentVar == NULL ) gFatal(name + ": Can't Find Variable for Extension");
	if( currentVar->GetCInfo(Variable::kType) == Variable::kNULL) {
		currentVar->SetCInfo(Variable::kType,Variable::kAux);
	}
	currentVar->AddQualifiers(dn,isExtension);   
	currentVar->SetNode(cn->StatementList());
	currentVar->ProcessNode();
  }
  else if(  (cmd == "Connection") ||  (cmd == "link") ) {
    TConnection* currentConnection = (isExtension) ? FindConnection(name,False) : FindConnection(name);
    if( currentConnection == NULL ) gFatal(name + ": Can't Find Connection for Extension");
    currentConnection->AddQualifiers(dn,isExtension); 	   
	currentConnection->SetNode(cn->StatementList());
	currentConnection->ProcessNode();
//	if( !currentConnection->Valid() ) { RemoveConnection( currentConnection ); }
  }
  else if(  (cmd == "Event") || (cmd == "dynamic")  ) {
    TEvent* currentEvent = (isExtension) ? GetEvent( name, TEvent::kUnknown, False ) : GetEvent(name);
    if( currentEvent == NULL ) gFatal(name + ": Can't Find Event for Extension");
    currentEvent->AddQualifiers(dn,isExtension); 
    currentEvent->SetNode(cn->StatementList());
    currentEvent->ProcessNode();
  }
  else if(  cmd == "Schedule" ) {
    ExSchedule* currentSchedule = (isExtension) ? GetSchedule( name, False ) : GetSchedule(name);
    if( currentSchedule == NULL ) gFatal(name + ": Can't Find Event for Extension");
    currentSchedule->AddQualifiers(dn,isExtension); 
    currentSchedule->SetNode(cn->StatementList());
    currentSchedule->ProcessNode();
  }
  else if(  (cmd == "LUT") || (cmd == "lut") ) {
    TLUT* currentLUT = (isExtension) ? GetLUT(name,False) : GetLUT(name);
    if( currentLUT == NULL ) gFatal(name + ": Can't Find LUT for Extension");
    currentLUT->AddQualifiers(dn,isExtension);   
    currentLUT->SetNode(cn->StatementList());
    currentLUT->ProcessNode();
    TMethod* currentMethod = GetMethod( currentLUT->MethodName() );
    currentMethod->SetLUT(currentLUT);
  } 
	else if(  cmd == "Method" ) {
    TMethod* currentMethod = (isExtension) ? GetMethod(name,False) : GetMethod(name);
    if( currentMethod == NULL ) gFatal(name + ": Can't Find Method for Extension");
    currentMethod->AddQualifiers(dn,isExtension);   
    currentMethod->SetNode(cn->StatementList());
    currentMethod->ProcessNode();
  } 
  else if(  ( cmd == "Module" ) ||  ( cmd == "compound" ) ) {
    Module* m = AddSubModule((const char*)name);
    m->AddQualifiers(dn,isExtension);    
    m->SetNode(cn->StatementList());
    m->ProcessNode();
  } else return 0;

  return 1;
}

int Module::ProcessAttribute(const TAttributeNode* an) {
	const TDeclarationNode* dn = an->Declaration();
	const CString& name = (dn->Name()) ? dn->Name()->Top() : gNullString;
	CString& cmd = (CString&) dn->Command();
	cmd.downcase();

  if( cmd == "submodule" ) {
    AddSubModule( name );
  } else return 0;
  return 1;
}

  //----------------------------------------------------------------------------------------
  //				TModule::GetLUT:
  //----------------------------------------------------------------------------------------
  
  
TLUT* Module :: GetLUT( const char* name, Bool create  )
{
  TLUT* aLUT = NULL;
  CString cName;

  if(name) {
    aLUT = (TLUT*) fLUTList.GetObjectByName( name );
    cName = name;
  }
  else { 
		cName = "Graph"; 
	}

  if( aLUT == NULL && create ) {
    aLUT = new TLUT(cName);						
    int index = aLUT->ILUT( this );	       		
  }
  return aLUT;
  
} // TModule::GetLUT

  //----------------------------------------------------------------------------------------
  //				TModule::GetMethod:
  //----------------------------------------------------------------------------------------
  
  
TMethod* Module :: GetMethod( const char* name, Bool create  )
{
  TMethod* aMethod = (TMethod*) fMethodList.GetObjectByName( name );

  if( aMethod == NULL && create ) {
    aMethod = new TMethod(name);						
    int index = aMethod->IMethod( this );	       		
//    fMethodList.Insert(*aMethod);
//    aMethod->SName().appendIndex(index);
  }
  return aMethod;
  
} // TModule::GetMethod

//----------------------------------------------------------------------------------------
  //				TModule::GetEvent:
  //----------------------------------------------------------------------------------------
  
  
TEvent* Module :: GetEvent( CString cName, TEvent::EType type, Bool create  )
{
	TEvent* aEvent = NULL;
	int op = Model::I0().GetCInfo(Model::kOptLevel);
	Module* gmod = Model::I0().GlobalMod();
	if( gmod == NULL ) { gFatal( "No Root Module Specified." ); }
	
	if( (op >= 5) ) {
		if( type == TEvent::kInit ) {
			cName = "StateVarInit";
		} else {
			cName = "GlobalUpdate";
			type = TEvent::kGlobalUpdate;
		}
		if(gmod != this) { return gmod->GetEvent(cName,type,create); }
	} else if( Env::GlobalSort() ) { 
		if( cName == "VarImport" ) { 
		  cName = "FirstUpdate"; 
		  type = TEvent::kFirstUpdate; 
		}
		if(gmod != this) { return gmod->GetEvent(cName,type,create); }
	}
	
	aEvent = (TEvent*) fEventList.GetObjectByName( cName );

	if( aEvent && create == kNewEvent ) {   
		gProgramBreak( fName + ": Error, Event name already taken."); 
		return NULL;
	}

	if( aEvent && (type != TEvent::kUnknown ) && (aEvent->GetObjInfo( TEvent::kType ) != type) ) { 
		gProgramBreak( SName() + "::" + cName.chars() + ": Error, Event has wrong type" ); 
		return NULL;
	}

	if( aEvent == NULL && create ) {
		aEvent = new TEvent( cName, this );
		fEventList.Insert(*aEvent);
		aEvent->SetObjInfo(TEvent::kType,type);
	}

  return aEvent;
  
} // TModule::CreateNewEvent

void Module ::DeleteEmptyEvents() {
  startDelete:
  for( Pix p = fEventList.first(); p; fEventList.next(p) ) {
    TEvent& aEvent = (TEvent&) fEventList(p);
    if( aEvent.CommandList().empty() ) { 
      fEventList.del(p,1,1);
      goto startDelete;
    }
  }
}

  //----------------------------------------------------------------------------------------
  //				TModule::GetConnection:
  //----------------------------------------------------------------------------------------
  
  
TConnection* Module :: GetConnection( const char* name, Bool create )
{
  if( fConnectionList == NULL ) fConnectionList = new TConnectionList(this);
  int cCnt = fConnectionList->length();
  CString cName = (name==NULL) ? "C0__" : name;
  cName.appendIndex(cCnt++);
  
  TConnection*  aConnection = (TConnection*) fConnectionList->GetObjectByName( name ); 

  if( aConnection == NULL && create ) {
    aConnection = new TConnection(cName);
    aConnection->SetParent(this);						
    fConnectionList->Insert(*aConnection);
  }
  return aConnection;
  
} // TModule::CreateNewConnection

TConnection* Module :: FindConnection( const char* name, Bool create )
{
  if( fConnectionList == NULL ) fConnectionList = new TConnectionList(this);
	int cCnt = fConnectionList->length();

  TConnection* aConnection = NULL;  
  CString cName(name);
  aConnection = (TConnection*) fConnectionList->GetObjectByName( name ); 

  if( aConnection == NULL && create ) {
    aConnection = new TConnection(cName);
    aConnection->SetParent(this);						
    fConnectionList->Insert(*aConnection);
  }
  return aConnection;
  
} // TModule::CreateNewConnection

//----------------------------------------------------------------------------------------
//				TModule::RemoveConnection:
//----------------------------------------------------------------------------------------

int Module :: RemoveConnection( TConnection* c ) {
  return fConnectionList->Delete(*c);
} 
  //----------------------------------------------------------------------------------------
  //				TModule::GetSchedule:
  //----------------------------------------------------------------------------------------
  
  
ExSchedule* Module::GetSchedule( const CString& cName, Bool create )
{
  ExSchedule* thisSchedule = (ExSchedule*) fScheduleList.GetObjectByName( cName );

  if( thisSchedule == NULL ) {
    if( create ) {
      thisSchedule = new ExSchedule(cName);
      fScheduleList.append(*thisSchedule);						
    } else {
      if( gDebug ) fScheduleList.Print(gLogFile);
    }
  }
  return thisSchedule;
  
} // TModule::GetSchedule

  //----------------------------------------------------------------------------------------
  //				TModule::GetVariable:
  //----------------------------------------------------------------------------------------
  
  
Variable* Module :: GetVariable( const CString& name, Bool create ) 
{
  Variable* thisVariable = (Variable*) fVarList.GetObjectByName( name );

  if( thisVariable == NULL ) {
    if( create ) {
      thisVariable = CreateNewVariable(name);						
    }
  }
  return fCurrentVariable = thisVariable;
  
} // TVariable::CreateNewVariable

Pix Module :: AddVariable( Variable* v ) { 
  if( GetCInfo(kIgnorable) ) { v->SetF(FisIgnored,True,"AddVariable"); }
  return fVarList.Insert(*v); 
}

//----------------------------------------------------------------------------------------
//				Module::CreateNewVariable:
//----------------------------------------------------------------------------------------
  
Variable* Module :: CreateNewVariable( const CString& variable_name, Variable* template_var ) { 
  Variable* newVariable = (Variable*) fVarList.GetObjectByName(variable_name);
  
  if( newVariable && newVariable->GetF(FisIgnored) ) {
	fVarList.Delete(*newVariable);
	newVariable = NULL;
  }
  
  if( (newVariable == NULL) ) { 
    newVariable = new Variable(variable_name);
    newVariable->Init(this);
  }
  return newVariable;

} // Module::CreateNewVariable  

//----------------------------------------------------------------------------------------
//				Module::CreateInputVariable:
//----------------------------------------------------------------------------------------

Variable* Module::CreateInputVariable( Variable* remoteVariable, char* cname ) {
		if( fSuper == NULL ) { gPrintErr( SName() + ": no super module!" ); return NULL; }
    Variable* aNewVar = (Variable*) CreateNewVariable(remoteVariable->SName(),remoteVariable);
    aNewVar->SetF(FisImport,True,"CreateInputVariable");
    remoteVariable->SetF(FisExport,True,"CreateInputVariable");
    TConnection* c = fSuper->GetConnection(cname);
    c->IConnection(remoteVariable->GetModule(),remoteVariable,this,aNewVar);
    aNewVar->SetCInfo(Variable::kType,remoteVariable->GetCInfo(Variable::kType));
    aNewVar->SetCInfo(Variable::kInitMode,remoteVariable->GetCInfo(Variable::kInitMode));
		aNewVar->SetCInfo(Variable::kMode,Variable::kInput);
		aNewVar->Connection(remoteVariable);
    return aNewVar;
}

//----------------------------------------------------------------------------------------
//				Module::AddSubModule:
//----------------------------------------------------------------------------------------
  
  
Module* Module :: AddSubModule( const char* module_name, Bool create )
{
  Module* thisModule = (Module*) Model::I0().GetModule(module_name);

  if( thisModule == NULL ) {
	if( create ) {
	  thisModule = new Module(module_name);						// Allocate a new module object;
	  Model::I0().ModuleList().Insert(*thisModule);
      fModuleList.Insert(*thisModule);						// Add to submodule list
	  thisModule->fSuper = this;
	}										
  } else {  
	fModuleList.Insert(*thisModule);						// Add to submodule list
	thisModule->fSuper = this;
  }
  return thisModule;
  
} // Module::AddSubModule

Module* Module :: AddSubModule( Module* m ) {
  fModuleList.Insert(*m);						// Add to submodule list
  m->fSuper = this;
  return m;
  
} // Module::AddSubModule
	
//----------------------------------------------------------------------------------------
//				Module::WriteMML:
//----------------------------------------------------------------------------------------

void Module::Dump( FILE* oFile ){
		Pix p;
    fprintf(oFile,"\n\nModule %s {\n",Name());
    for( p = fModuleList.first(); p; fModuleList.next(p) ) {
      Module& m = (Module&) fModuleList(p);
      fprintf(oFile,"\tSubModule %s;\n",m.Name());
    }
    for( p = fVarList.first(); p; fVarList.next(p) ) {
      Variable& v = (Variable&) fVarList(p);
      v.Dump(oFile);
    }
    if(fConnectionList) { 
      for( p = fConnectionList->first(); p; fConnectionList->next(p) ) {
	TConnection& c = (TConnection&) (*fConnectionList)(p);
	c.Dump(oFile);
      }
    }
    for( p = fLUTList.first(); p; fLUTList.next(p) ) {
      TLUT& c = (TLUT&) fLUTList(p);
      c.Dump(oFile);
    }
    for( p = fMethodList.first(); p; fMethodList.next(p) ) {
      TMethod& c = (TMethod&) fMethodList(p);
      c.Dump(oFile);
    }
    for( p = fEventList.first(); p; fEventList.next(p) ) {
      TEvent& c = (TEvent&) fEventList(p);
      c.Dump(oFile);
    }
    fprintf(oFile,"}\n\n");
}

void  Module::WriteMML( FILE* oFile, EWriteMode mode) {
	Pix p;
  if( mode == kDeclaration) {
    fprintf(oFile,"\tModule %s {}\n",Name());
  } else if( mode == kDefinition) {
		if( fSuper == NULL ) fprintf(oFile,"root ");
    fprintf(oFile,"Module %s {\n",Name());
    for( p = fModuleList.first(); p; fModuleList.next(p) ) {
      Module& m = (Module&) fModuleList(p);
      if( m.GetCInfo(kIgnorable) == 0 ) { 
				m.WriteMML(oFile,kDeclaration);
			}
    }
    for( p = fVarList.first(); p; fVarList.next(p) ) {
      Variable& v = (Variable&) fVarList(p);
      if( !v.GetF(FisIgnored) ) {
		v.WriteMML(oFile);  
	  }  
    }
    if(fConnectionList) { 
      for( p = fConnectionList->first(); p; fConnectionList->next(p) ) {
				TConnection& c = (TConnection&) (*fConnectionList)(p);
				c.WriteMML(oFile);
      }
    }
    for( p = fLUTList.first(); p; fLUTList.next(p) ) {
      TLUT& c = (TLUT&) fLUTList(p);
      c.WriteMML(oFile);
    }
    for( p = fMethodList.first(); p; fMethodList.next(p) ) {
      TMethod& c = (TMethod&) fMethodList(p);
      c.WriteMML(oFile);
    }
    for( p = fEventList.first(); p; fEventList.next(p) ) {
      TEvent& c = (TEvent&) fEventList(p);
      c.WriteMML(oFile);
    }
    fprintf(oFile,"}\n\n");
  }
}

int  Module::BuildConfigXML( ArgArray& msg, int mode ) {
	int rv = 0;
    msg.Add( format("\n\t<compound id=\"%s\" name=\"%s\" >\n", Name(), Name() ) );
	for( Pix p = fVarList.first(); p; fVarList.next(p) ) {
		Variable& v = (Variable&) fVarList(p);
		if( !v.GetF(FisIgnored) ) {
		  if( v.BuildConfigXML( msg, mode ) ) { rv = 1; }
		}  
	}
	msg.Add(format("\n\t</compound>"));
	return rv;
}

void  Module::WriteConfigXML( CString& xmlPath ) {
  CString xmlFile = xmlPath + "/" + Name() + ".xml";
  FILE* oFile = fopen(xmlFile,"w");
  if(oFile==NULL) { gPrintErr(CString("Error, unable to open xml file: ") += xmlFile.chars() ); return; }
  else { sprintf(gMsgStr,"Opened xml File: %s.",xmlFile.chars()); gPrintScreen(); }
  	fprintf(oFile,"<?xml version=\"1.0\"?>\n\n");
	fprintf(oFile,"<!DOCTYPE compound PUBLIC \"-//miiee sme//dtd mml//en\" \"http://iee.umces.edu/SME3/dtd/mml.dtd\">" );
	Pix p;
	fprintf(oFile,"\n\n<compound id=\"%s\" name=\"%s\" >\n",Name(),Name());
	
	for( p = fModuleList.first(); p; fModuleList.next(p) ) {
		Module& m = (Module&) fModuleList(p);
		if( m.GetCInfo(kIgnorable) == 0 ) { 
			m.WriteConfigXML( xmlPath );
			fprintf(oFile,"\n\n\t<compound id=\"%s\" name=\"%s\" location=\"%s.xml\" >\n", m.Name(), m.Name(), m.Name() );
			fprintf(oFile,"\n\t</compound>\n" );
		}
	}
	
	for( p = fVarList.first(); p; fVarList.next(p) ) {
		Variable& v = (Variable&) fVarList(p);
		if( !v.GetF(FisIgnored) ) {
		  v.WriteConfigXML(oFile); 
		}  
	}
	

/*
	for( p = fMethodList.first(); p; fMethodList.next(p) ) {
		TMethod& c = (TMethod&) fMethodList(p);
		c.WriteXML(oFile);
	}
	for( p = fEventList.first(); p; fEventList.next(p) ) {
		TEvent& c = (TEvent&) fEventList(p);
		c.WriteXML(oFile);
	}
*/
	fprintf(oFile,"\n</compound>\n\n");
	fclose(oFile);
}

void  Module::WriteXML( CString& xmlPath ) {
  CString xmlFile = xmlPath + "/" + Name() + ".xml";
  FILE* oFile = fopen(xmlFile,"w");
  if(oFile==NULL) { gPrintErr(CString("Error, unable to open xml file: ") += xmlFile.chars() ); return; }
  else { sprintf(gMsgStr,"Opened xml File: %s.",xmlFile.chars()); gPrintScreen(); }
  	fprintf(oFile,"<?xml version=\"1.0\"?>\n\n");
	fprintf(oFile,"<!DOCTYPE compound PUBLIC \"-//miiee sme//dtd mml//en\" \"http://iee.umces.edu/SME3/dtd/mml.dtd\">" );
	Pix p;
	fprintf(oFile,"\n\n<compound id=\"%s\" name=\"%s\" >\n",Name(),Name());
	
	for( p = fModuleList.first(); p; fModuleList.next(p) ) {
		Module& m = (Module&) fModuleList(p);
		if( m.GetCInfo(kIgnorable) == 0 ) { 
			m.WriteXML( xmlPath );
			fprintf(oFile,"\n\n\t<compound id=\"%s\" name=\"%s\" location=\"%s.xml\" >\n", m.Name(), m.Name(), m.Name() );
			TNamedObjectList& varlist = m.VarList();
			for( Pix vp = varlist.first(); vp; varlist.next(vp) ) {
				Variable& v = (Variable&) varlist(vp);
				if( !v.GetF(FisIgnored) ) {
					if( v.GetF(FisImport ) ) {
						fprintf(oFile,"\n\t\t<port type=\"input\" name=\"%s\" />",v.Name() );
					} else if( v.GetF(FisExport) ) {
						fprintf(oFile,"\n\t\t<port type=\"output\" name=\"%s\" />",v.Name() );
					}
				}
			}
			fprintf(oFile,"\n\t</compound>\n" );
		}
	}
	
	for( p = fVarList.first(); p; fVarList.next(p) ) {
		Variable& v = (Variable&) fVarList(p);
		if( !v.GetF(FisIgnored) ) {
		  v.WriteXML(oFile); 
		  TNamedObjectList& clist = v.CommandList();
		  for( Pix cp = clist.first(); cp; clist.next(cp) ) {
			  TCommand& c = (TCommand&) clist(cp);
			  TNamedObjectList& dl = c.DependencyList();
			  for ( Pix dP =  dl.first(); dP; dl.next(dP) ) {
				  TDependency& d = (TDependency&) dl(dP);
				  Variable* depVar = d.GetVar();
				  if( depVar ) {
					  if( depVar->GetF(FisImport) ) {
						  fprintf( oFile, "\n\t<link origin=\"this.%s\" destination=\"%s.%s\" />", 
						   depVar->Name(), v.Name(), depVar->Name() );
					  } else {
						  fprintf( oFile, "\n\t<link origin = \"%s.out\" destination =  \"%s.%s\" />", 
						   depVar->Name(), v.Name(), depVar->Name() );
					  }
				  }	
			  }
		  } 
		}  
	}
	
	if(fConnectionList) { 
		for( p = fConnectionList->first(); p; fConnectionList->next(p) ) {
			TConnection& c = (TConnection&) (*fConnectionList)(p);
			c.WriteXML(oFile);
		}
	}
		
	for( p = fLUTList.first(); p; fLUTList.next(p) ) {
		TLUT& c = (TLUT&) fLUTList(p);
		c.WriteXML(oFile);
	}
/*
	for( p = fMethodList.first(); p; fMethodList.next(p) ) {
		TMethod& c = (TMethod&) fMethodList(p);
		c.WriteXML(oFile);
	}
	for( p = fEventList.first(); p; fEventList.next(p) ) {
		TEvent& c = (TEvent&) fEventList(p);
		c.WriteXML(oFile);
	}
*/
	fprintf(oFile,"\n</compound>\n\n");
	fclose(oFile);
}

//----------------------------------------------------------------------------------------
//				TModule::WriteCCode:
//----------------------------------------------------------------------------------------

void  Module::PostEventsByType( TEvent::EType type ) {
  if( ( type ==  TEvent::kInit ) && fSuper ) { return; }
  for(  Pix p = fEventList.first(); p; fEventList.next(p) ) {
    TEvent& e = (TEvent&) fEventList(p);
    if( e.GetObjInfo(TEvent::kType) == type ) {
      e.Schedule();
    } 
  } 
}


//----------------------------------------------------------------------------------------
//				TModule::WriteCCode:
//----------------------------------------------------------------------------------------

void  Module::WriteCCode( FILE* CHdrFile, FILE* CEqnFile) {
  fprintf(CEqnFile,"\n// ---------------------------------------------------------------------------");
  fprintf(CEqnFile,"\n//                    Class %s ",Name());
  fprintf(CEqnFile,"\n// ---------------------------------------------------------------------------");
  fprintf(CHdrFile,"\n// ---------------------------------------------------------------------------");
  fprintf(CHdrFile,"\n//                    Class %s ",Name());
  fprintf(CHdrFile,"\n// ---------------------------------------------------------------------------");

  Pix p;
  if( fSuper == NULL ) {  
	fprintf(CHdrFile,"\n\nint kA__Wildcard = %d;", gWildCardIndex ); 
	TNamedObjectList& arrays = Model::I0().getArrayList();
	for( p = arrays.first(); p;  arrays.next(p) ) {
	  ArrayRec& array = (ArrayRec&) arrays.elem(p);
	  CString& cat_name = array.SName(); cat_name.upcase();
	  fprintf(CHdrFile,"\nint kA__%s = -1;",cat_name.chars());
	  fprintf(CHdrFile,"\nint kA__%s__Max = -1;",cat_name.chars());
	  ArgArray* a = array.getArgs(); 
	  int array_order = a->NArgs();
	  for( int iarg=0; iarg<array_order; iarg++ ) {
		CString& arg = a->elem(iarg);
		arg.upcase();
		fprintf(CHdrFile,"\nint kA__%s = -1;",arg.chars() );
	  }
	}
  }

  fprintf(CHdrFile,"\n\nclass %s : public TModule {",Name());
  fprintf(CHdrFile,"\nprotected:\n");
  fprintf(CHdrFile,"\n\t%s(char* name);\n",Name());	
  fprintf(CEqnFile,"\n%s::%s(char* name) :",Name(),Name());	    

  fprintf(CHdrFile,"\npublic:\n");
	
  for( p = fVarList.first(); p; fVarList.next(p) ) {
    Variable& v = (Variable&) fVarList(p);
    v.WriteCCode( CHdrFile, CEqnFile );    
  }

  fprintf(CEqnFile,"\n\tTModule(name) {\n");

  for( p = fVarList.first(); p; fVarList.next(p) ) {
    Variable& v = (Variable&) fVarList(p);
    v.WriteFlags(CEqnFile);    
  }
  fprintf(CEqnFile,"\n}\t");


  fprintf(CHdrFile,"\nprotected:\n");

  for( p = fCommandList.first(); p; fCommandList.next(p) ) {
    TCommand& c = (TCommand&) fCommandList(p);
    if( c.GetObjInfo(TCommand::kStatus) == TCommand::kActive && 
				c.GetObjInfo(TCommand::kExType) == TCommand::kCode    ) {
				c.WriteCCode(CHdrFile,CEqnFile); 
      fprintf(CHdrFile,"\n\tfriend int %s_%s_exe_g( Variable* v );",c.VarC()->Name(),c.Name()); 
    }
  }

  fprintf(CHdrFile,"\n\tstatic %s* fInstance;",Name());
  fprintf(CEqnFile,"\n%s* %s::fInstance = NULL;",Name(),Name());
  fprintf(CHdrFile,"\n\tstatic %s* kNullModel;",Name());
  fprintf(CEqnFile,"\n%s* %s::kNullModel = (%s*)0x1;",Name(),Name(),Name());

  fprintf(CHdrFile,"\npublic:");

  WriteInstantiator(CHdrFile); 

  fprintf(CHdrFile,"\n\tvirtual int InitVars();");
  fprintf(CHdrFile,"\n\tvirtual int InitArrays();");
  
  fprintf(CEqnFile,"\nint %s::InitArrays() {\n\tint index, is_dimension_name;\n\t",Name()); 
  
  TNamedObjectList& arrays = Model::I0().getArrayList();
  for( p = arrays.first(); p;  arrays.next(p) ) {
	ArrayRec& array = (ArrayRec&) arrays.elem(p);
	Variable* avar = array.getMap();
	if( avar->GetModule() == this ) {
	  CString& cat_name = array.SName(); cat_name.upcase();
	  fprintf(CEqnFile,"\n\tkA__%s__Max = %s.GetCategorySize(\"%s\");",cat_name.chars(),avar->Name(),cat_name.chars());
	  ArgArray* a = array.getArgs(); 
	  int array_order = a->NArgs();
	  for( int iarg=0; iarg<array_order; iarg++ ) {
		CString& arg = a->elem(iarg);
		fprintf(CEqnFile,"\n\tkA__%s = %s.GetCategoryIndex(\"%s\");",arg.chars(),avar->Name(),arg.chars());
	  }
	}
  }
  for( p = fVarList.first(); p; fVarList.next(p) ) {
    Variable& v = (Variable&) fVarList(p);
    int order = 0;
    while(1) {
	  ArrayRec* ad = v.getArrayDeclaration( order );
	  if( ad == NULL ) break;
	  fprintf(CEqnFile,"\n\t%s.addArrayDeclaration( Model::I0().getArrayDeclaration( \"%s\", index, is_dimension_name ), %d, is_dimension_name, index ); ",v.Name(),ad->Name(),order++);
	}
  }
  fprintf(CEqnFile,"\n\treturn 0;\n}\n");
     
  fprintf(CEqnFile,"\nint %s::InitVars() {\n\t",Name()); 
  
  int m_external = ( SName().index("XXXImports") == 0 );
  for( p = fVarList.first(); p; fVarList.next(p) ) {
    Variable& v = (Variable&) fVarList(p);
    fprintf(CEqnFile,"\n\t%s.SSInit(this);",v.Name()); 
    if( m_external && !v.GetF(FisIgnored) && ( v.GetCInfo(Variable::kType) !=  Variable::kTime ) ) {
	  fprintf(CEqnFile,"\n\t%s.SetF(FisIgnored,False,\"InitVars\");",v.Name());
	}
    if( v.GetF(FLinkEdges) ) fprintf(CEqnFile,"\n\t%s.SetLinkEdges();",v.Name()); 
    if( v.Origin() && !v.GetF(FisImport) ) {
      if( v.Origin()->GetModule() == this ) 
				fprintf(CEqnFile,"\n\t%s.SetOrigin(&%s);",v.Name(),v.Origin()->Name());
      else fprintf(CEqnFile,"\n\t%s.SetOrigin(&(%s::I().%s));",v.Name(),v.Origin()->GetModule()->Name(),v.Origin()->Name());
    }    
    if( v.Destination() && !v.GetF(FisImport) ) {
      if( v.Destination()->GetModule() == this ) 
				fprintf(CEqnFile,"\n\t%s.SetDestination(&%s);",v.Name(),v.Destination()->Name());
      else fprintf(CEqnFile,"\n\t%s.SetDestination(&(%s::I().%s));",v.Name(),v.Destination()->GetModule()->Name(),v.Destination()->Name());
    }
  }
  fprintf(CEqnFile,"\n\tfVarList.Alphabetize();");
  fprintf(CEqnFile,"\n\treturn 0;\n}\n");

  if( fModuleList.length() == 0 ) fprintf(CHdrFile,"\n\tint Initialize() { InitVars(); return 0; }");
  else {
    fprintf(CHdrFile,"\n\tint Initialize();");
    fprintf(CEqnFile,"\nint %s::Initialize() {",(char*)Name());
		fprintf(CEqnFile,"\n\tInitVars();");
    for( p = fModuleList.first(); p; fModuleList.next(p) ) {
      Module& m = (Module&) fModuleList(p);
      fprintf(CEqnFile,"\n\t%s::I().AddSubModule(&%s::I());",Name(),m.Name());
    }
    if( fSuper == NULL ) fprintf(CEqnFile,"\n\tModel::I0().ModuleList().Alphabetize();");
    fprintf(CEqnFile,"\n\treturn 1;\n}\n");
  }

  if(fConnectionList) { 
    fprintf(CHdrFile,"\n\tint MakeConnections();");
    fprintf(CEqnFile,"\nint %s::MakeConnections() {",(char*)Name());
    for( p = fConnectionList->first(); p; fConnectionList->next(p) ) {
      TConnection& c = (TConnection&) (*fConnectionList)(p);
      Variable* v = c.NodeVar(0);
      Variable* v1 = c.NodeVar(1);
      if( v && v1 ) c.WriteCCode( CHdrFile, CEqnFile );
    }
    fprintf(CEqnFile,"\n\treturn 0;\n}\n");
  } else fprintf(CHdrFile,"\n\tint MakeConnections() { return 0;}");

  for( p = fLUTList.first(); p; fLUTList.next(p) ) {
    TLUT& g = (TLUT&) fLUTList(p);
    g.WriteCCode( CHdrFile, CEqnFile );
    if( g.Derivative() ) { g.WriteDCode( CHdrFile, CEqnFile ); }
  }
  for(  p = fMethodList.first(); p; fMethodList.next(p) ) {
    TMethod& g = (TMethod&) fMethodList(p);
    g.WriteCCode( CHdrFile, CEqnFile );
  }
  
// Write SetupEvents

	fprintf(CHdrFile,"\n\tint SetupEvents();"); 
	fprintf(CEqnFile,"\nint %s::SetupEvents() {",(char*)Name());
	for(  p = fVarList.first(); p; fVarList.next(p) ) {
		Variable& v = (Variable&) fVarList(p);
		v.SetCmdStatus( TCommand::kPipe, TCommand::kInActive );
		v.WriteCCommandCode( CEqnFile );    
	}

	fprintf(CEqnFile,"\n\treturn 0;\n}\n");

	fprintf(CHdrFile,"\n\tint PostFirstUpdate();"); 
	fprintf(CEqnFile,"\nint %s::PostFirstUpdate() {",(char*)Name());
	fprintf(CEqnFile,"\n\tPostEventsByType(TEvent::kFirstUpdate);"); 
	fprintf(CEqnFile,"\n\treturn 0;\n}\n");

	fprintf(CHdrFile,"\n\tint PostFinalUpdate();"); 
	fprintf(CEqnFile,"\nint %s::PostFinalUpdate() {",(char*)Name());
	fprintf(CEqnFile,"\n\tPostEventsByType(TEvent::kFinalUpdate);"); 
	fprintf(CEqnFile,"\n\treturn 0;\n}\n");

	fprintf(CHdrFile,"\n\tint PostImport();"); 
	fprintf(CEqnFile,"\nint %s::PostImport() {",(char*)Name());
	fprintf(CEqnFile,"\n\tPostEventsByType(TEvent::kImport);"); 
	fprintf(CEqnFile,"\n\treturn 0;\n}\n");

	fprintf(CHdrFile,"\n\tint PostIntegrate();"); 
	fprintf(CEqnFile,"\nint %s::PostIntegrate() {",(char*)Name());
	fprintf(CEqnFile,"\n\tPostEventsByType(TEvent::kIntegrate);"); 
	fprintf(CEqnFile,"\n\treturn 0;\n}\n");

	if( fSuper ) { fprintf(CHdrFile,"\n\tint PostInit() { return 0;}"); }
	else {
		fprintf(CHdrFile,"\n\tint PostInit();"); 
		fprintf(CEqnFile,"\nint %s::PostInit() {",(char*)Name());
		fprintf(CEqnFile,"\n\tPostEventsByType(TEvent::kInit);");
		fprintf(CEqnFile,"\n\treturn 1;\n}\n");
	}
	fprintf(CHdrFile,"\n};\n\n");
	
  for(  p = fCommandList.first(); p; fCommandList.next(p) ) {
    const TCommand& c = (const TCommand&) fCommandList(p);
    if( c.GetObjInfo(TCommand::kStatus) == TCommand::kActive && c.GetObjInfo(TCommand::kExType) == TCommand::kCode  ) {
      fprintf(CHdrFile,"\nint %s_%s_exe_g(Variable* obj) { return %s::I().%s_%s_exe(); }",
	      c.VarC()->Name(),c.Name(),Name(),c.VarC()->Name(),c.Name());
    }
  }

}

//----------------------------------------------------------------------------------------
//				TModule::CreateEventLists:
//----------------------------------------------------------------------------------------
  
void Module :: CreateEventLists( TEvent* initEvent ) {
  int icnt=0, icnt1=0;
	Variable* aVar; Pix p;
  for( p = fVarList.first(); p; fVarList.next(p) ) { 
		aVar = (Variable*) &fVarList(p);
    if( (aVar->GetF(FisImport) && ( aVar->GetCInfo(Variable::kType) !=  Variable::kTime ) ) 
	|| aVar->GetCInfo(Variable::kInitMode) == Variable::kPtTimeSeries ) {
		
      CString name( aVar->Name() ); name += "_import"; // name.appendIndex(icnt++);
      TEvent* VarImport =  GetEvent( "VarImport", TEvent::kImport );
      TImportCommand* c = (TImportCommand*) aVar->GetCommand( name, TCommand::kUndefined, TCommand::kImport  ); 
      VarImport->AddCommand(*c);
			if( gDebug > 1 ) {
				sprintf(gMsgStr,"Creating import command %s::%s and adding to event %s",Name(),name.chars(),VarImport->Name());
				gPrintLog();
			}
      Variable* aDepVar =  (Variable*) aVar->Connection();
      if( aDepVar ) {
				TDependency* d = new TDependency(*aDepVar,0);
				TNamedObjectList& dlist = c->DependencyList();
				dlist.append(*d);
      }
    } else {
      if(  aVar->GetCInfo(Variable::kType) ==  Variable::kTime   ) { 
				aVar->SetCmdStatus(TCommand::kInit,TCommand::kInActive);
				aVar->SetCmdStatus(TCommand::kUpdate,TCommand::kInActive);
      }
      else {
				TNamedObjectList& cL = aVar->CommandList();
				for( Pix p1 = cL.first(); p1; cL.next(p1) ) {
					TCommand &c = (TCommand&) cL(p1);
					if( aVar->GetF( FisConstant )  ) {
						if( c.GetObjInfo(TCommand::kType) == TCommand::kUpdate ) {
							initEvent->AddCommand(c);
						}
					} else if( aVar->GetF( FisStateVar )  ) {
						if( c.GetObjInfo(TCommand::kType) == TCommand::kInit ) {
							initEvent->AddCommand(c);
							//	  aVar->SetFieldsFromValue( c.Value(),TEvent::kInit );
						}
					} else if( aVar->GetF( FisExport ) &&  !Env::GlobalSort() ) {
						if( c.GetObjInfo(TCommand::kType) == TCommand::kUpdate ) {
							initEvent->AddCommand(c);
						}
					}
					if( aVar->GetF( FisStateVar ) ) {
						if( c.GetObjInfo(TCommand::kType) == TCommand::kIntegrate ) {
							TEvent* StateVarIntegrate =  GetEvent("StateVarIntegrate", TEvent::kIntegrate );
							StateVarIntegrate->AddCommand(c);
							//	  aVar->SetFieldsFromValue( c.Value(), TEvent::kIntegrate );
						}
						if( c.GetObjInfo(TCommand::kType) == TCommand::kFunction ) {
							const char* cname = c.Name();
							if( cname[1] == 'E' ) {
								TEvent* finalUpdate =  Model::I0().GlobalMod()->GetEvent("FinalUpdate", TEvent::kFinalUpdate );
								finalUpdate->AddCommand(c);
							} else {
								TEvent* StateVarIntegrate =  GetEvent("StateVarIntegrate", TEvent::kIntegrate );
								StateVarIntegrate->AddCommand(c);
							}
						}

					} else {
						if( c.GetObjInfo(TCommand::kType) == TCommand::kUpdate ) {
							EUListStatus list_status = CheckUpdateListInclusion( c );
							if( ( list_status == kULFinalOnly) || ( list_status == kULBoth ) ) {
								TEvent* Update1 =  GetEvent("FinalUpdate", TEvent::kFinalUpdate); 
								Update1->AddCommand(c);
							}
							if ( ( list_status == kULFirstOnly) || ( list_status == kULBoth ) ) {
								TEvent* Update0 =  GetEvent("FirstUpdate", TEvent::kFirstUpdate); 
								Update0->AddCommand(c);
							}
						}
						if( c.GetObjInfo(TCommand::kType) == TCommand::kFunction ) {
							const char* cname = c.Name();
							if( cname[1] == 'E' ) {
								TEvent* finalUpdate =  Model::I0().GlobalMod()->GetEvent("FinalUpdate", TEvent::kFinalUpdate );
								finalUpdate->AddCommand(c);
							} else {
								TEvent* Update =  GetEvent("FirstUpdate", TEvent::kFirstUpdate); 
								Update->AddCommand(c);
							}
						}
					}
				}
      }
    }
  }
	if( ExprBuilder::GetMode() == ExprBuilder::kCCode ) {
		for( p = fVarList.first(); p; fVarList.next(p) ) { 
			aVar = (Variable*) &fVarList(p);
			if( !aVar->GetF(FisImport) && ( aVar->GetCInfo(Variable::kType) !=  Variable::kTime ) ) {
				TNamedObjectList& cL = aVar->CommandList();
				for( Pix p1 = cL.first(); p1; cL.next(p1) ) {
					TCommand &c = (TCommand&) cL(p1);
					switch( aVar->GetCInfo(Variable::kInitMode) ) {
					case Variable::kMap:
						aVar->SetCmdStatus(TCommand::kInit,TCommand::kInActive);
						aVar->SetCmdStatus(TCommand::kUpdate,TCommand::kInActive);
						break;
					case Variable::kTimeSeries:
						aVar->SetCmdStatus(TCommand::kInit,TCommand::kInActive);
						aVar->SetCmdStatus(TCommand::kUpdate,TCommand::kInActive);
						break;
					case Variable::kPtTimeSeries:
						aVar->SetCmdStatus(TCommand::kInit,TCommand::kInActive);
						aVar->SetCmdStatus(TCommand::kUpdate,TCommand::kInActive);
						break;
					case Variable::kDBase:
						aVar->SetCmdStatus(TCommand::kInit,TCommand::kInActive);
						aVar->SetCmdStatus(TCommand::kUpdate,TCommand::kInActive);
						break;
					case Variable::kParameter:
						if( !aVar->GetF(FisClamped) && !aVar->GetF(FisSpatial) ) {
							aVar->SetCmdStatus(TCommand::kInit,TCommand::kInActive);
							aVar->SetCmdStatus(TCommand::kUpdate,TCommand::kInActive);
						}
					}
				}
			}
		}
	}
	
	if( Model::I0().GetCInfo(Model::kOptLevel) < 5 ) { 
		int go = 1;
		TEvent* Update0 =  GetEvent("FirstUpdate", TEvent::kFirstUpdate); 
		TEvent* Update1 =  GetEvent("FinalUpdate", TEvent::kFinalUpdate); 
		TEvent* StateVarIntegrate =  GetEvent("StateVarIntegrate", TEvent::kIntegrate );
		while (go ) {
			go = 0;
			TCommand*  c;
			if( c = Update1->SplitByDependency( *Update0, *Update0 ) ) { go = 1; }
			if( c = Update1->SplitByDependency( *Update0, *StateVarIntegrate ) ) { go = 1; }
		}
	}
}

int Module :: FillInitializationList( TEvent* initEvent ) {	
  int go = 1, repeat=0;	
  while ( go ) {
    go = 0;
    for( Pix p0 = fEventList.first(); p0; fEventList.next(p0) ) {
      TEvent& e0 = (TEvent&) fEventList(p0);
      TEvent::EType etype = (TEvent::EType) e0.GetObjInfo(TEvent::kType);
      if( (etype == TEvent::kFirstUpdate) || (etype == TEvent::kImport) || (etype == TEvent::kGlobalUpdate) ) {
				int localVarsOnly = (etype != TEvent::kGlobalUpdate);  
				if( e0.SplitByDependency( *initEvent, *initEvent, TEvent::kDoNothing, localVarsOnly ) ) {
					go = 1;
					repeat = 1;
				}
      }
    }
  }
  return repeat;
}


Module::EUListStatus Module :: CheckUpdateListInclusion(TCommand& c) {
  EUListStatus list_status = kULNone;
  if( c.Var() == NULL ) return list_status;
  if( c.Var()->GetF(FisConstant) ) return list_status;
  else list_status = kULFirstOnly;
  if( c.Var()->GetF(FisFlux) ) return list_status;
  if( (Model::I0().GetCInfo(Model::kOptLevel) < 5) && !Env::GlobalSort() ) {
		int hasSVdep = 0, hasOtherDep = 0;
		TNamedObjectList& depList = c.DependencyList();
		for( Pix pv = depList.first(); pv; depList.next(pv) ) {
			TDependency& d = (TDependency&) depList(pv);
			const Variable* depVar = d.Var();
			if( depVar ) {
				if( depVar->GetF(FisStateVar) && !depVar->GetF(FisImport) )  { 
					hasSVdep = 1;
				} else if ( !depVar->GetF(FisConstant) ) {
					hasOtherDep = 1;
				}
			}
		}
		if( c.Var()->GetF( FisExport ) && hasSVdep ) {   // is included in final list ?
			if( hasOtherDep )  { list_status = kULBoth;  } // has non-StateVar dependencies ?
			else { list_status = kULFinalOnly; }           // de-activate cmds not to be considered for inclusion in firstUpdate.
		}
	}
  return list_status;
}

//----------------------------------------------------------------------------------------
//				TModule:::ProcessTemporalDependencies:
//----------------------------------------------------------------------------------------
  
Bool Module::ProcessTemporalDependencies () {

  Bool go=True, rGo = False; 
  while(go) {
    go = False;
    for( Pix p = fVarList.first(); p; fVarList.next(p) ) {
      Variable* aVar = (Variable*) &fVarList(p); 
      TNamedObjectList& commandList = aVar->CommandList();
      int isConstant = True;
	  Variable* vdep = NULL;
      if( aVar->GetF(FisIgnored) ) {
				isConstant = True;
      } else if( aVar->GetF(FisStateVar) ) {
				isConstant = False; vdep = aVar;
				for( Pix p0 = commandList.first(); p0; commandList.next(p0) ) {
					TCommand &c0 = (TCommand&) commandList(p0);
					if( c0.GetObjInfo(TCommand::kType) == TCommand::kIntegrate  ) {
						TNamedObjectList& dList = c0.DependencyList();
						for( Pix pd = dList.first(); pd; dList.next(pd) ) {
							TDependency& d = (TDependency&) dList(pd);
							Variable* v1 = (Variable*) d.Var();
							if( v1 ) {
								if( v1->GetF(FisImport) && v1->Connection() != NULL ) { v1 = (Variable*)v1->Connection(); }
								if( aVar->GetF(FisClamped) && ((v1->Origin() == aVar) || (v1->Destination() == aVar)) ) { 
									if( gDebug > 1) { 
										sprintf(gMsgStr,"## %s Clamp -> State Var %s",v1->Name(),aVar->Name()); 
										gPrintLog();
									}
									v1->SetF(FisClamped,True," ProcessTemporalDependencies");
									v1->SetF(FisConstant,False," ProcessTemporalDependencies: Clamped Flux");
									if( v1->Origin() == aVar )           { v1->SetFluxInfo( kF_OriginClamped, 1 );      }
									else if( v1->Destination() == aVar ) { v1->SetFluxInfo( kF_DestinationClamped, 1 ); }
								}
							} 
						}
					}
				}
      } else {
				for( Pix p0 = commandList.first(); p0; commandList.next(p0) ) {
					TCommand &c0 = (TCommand&) commandList(p0);
					TCommand::EExType extype = (TCommand::EExType) c0.GetObjInfo(TCommand::kExType);
					if( c0.GetObjInfo(TCommand::kStatus) == TCommand::kActive && 
							(  extype == TCommand::kImport || extype == TCommand::kCode ) &&
							c0.GetObjInfo(TCommand::kType) != TCommand::kInit ) {
						TNamedObjectList& dList = c0.DependencyList();
						Variable* v0 = (Variable*) c0.Var();
						for( Pix pd = dList.first(); pd; dList.next(pd) ) {
							TDependency& d = (TDependency&) dList(pd);
							Variable* v1 = (Variable*) d.Var();
							if( v1 ) {
								if( v1->GetF(FisImport) && v1->Connection() != NULL ) { v1 = (Variable*)v1->Connection(); }
								if( !v1->GetF(FisConstant) ) { 
									isConstant = False; vdep = v1; 
								}
							} else {
								TConstant* c = d.Constant();
								if( c && c->Dynamic() ) { isConstant = False;  vdep = v1; }
							}
						}
					}
					if( c0.GetObjInfo(TCommand::kType) == TCommand::kFunction ) {
					  isConstant = False; 
					}
				}
      }
      if(  ( isConstant == False  ) && aVar->GetF(FisConstant) && !aVar->GetF(FOverrideInit) ) {
		aVar->SetF(FisConstant, False, (vdep) ? (const char*)(vdep->SName() + ": ProcessDependency ") : " Function Dependency " ); 
		go = True; rGo=True;
      }
    }
  }
  return rGo;
} // TModule:::ProcessTemporalDependencies:

//----------------------------------------------------------------------------------------
//				TModule:::ProcessConnections:
//----------------------------------------------------------------------------------------
  
void Module::ProcessConnections () {
	Pix p;
  for( p = fVarList.first(); p; fVarList.next(p) ) {
    Variable* aVar = (Variable*) &fVarList(p);     Variable* cVar = aVar->Connection();
    if( aVar->GetF(FisImport) && cVar != NULL ) {
      aVar->SetCInfo(Variable::kType,cVar->GetCInfo(Variable::kType));
      aVar->DataType() = cVar->DataType();
      aVar->SetCInfo(Variable::kInitMode,cVar->GetCInfo(Variable::kInitMode));
      TNamedObjectList& commandList = cVar->CommandList();
      for( Pix p0 = commandList.first(); p0; commandList.next(p0) ) {
				TCommand &c0 = (TCommand&) commandList(p0);
				if( c0.GetObjInfo(TCommand::kStatus) == TCommand::kActive && c0.GetObjInfo(TCommand::kExType) == TCommand::kPipe ) {
					Pipe* p = c0.GetPipe();
					aVar->RegisterPipe( *p ); 
				}
      }
    }
  }
/*
  for( p = fVarList.first(); p; fVarList.next(p) ) {
    Variable* aVar = (Variable*) &fVarList(p);     
    if( aVar->GetCInfo(Variable::kInitMode) ==  Variable::kDBase ) aVar->CheckMapInputs();
  }
*/
}

//----------------------------------------------------------------------------------------
//				TModule:::ProcessSpatialDependencies:
//----------------------------------------------------------------------------------------
  
Bool Module::ProcessSpatialDependencies () {

  Bool go=True, rGo = False; 
  while(go) {
    go = False;
    for( Pix p = fVarList.first(); p; fVarList.next(p) ) {
      Variable* aVar = (Variable*) &fVarList(p);     
      Variable* cVar = aVar->Connection();
      if( aVar->GetF(FisImport) && aVar->Connection() != NULL ) {
				if( aVar->Connection()->GetF(FisSpatial) && !aVar->GetF(FisSpatial) && !aVar->GetF(FOverrideInit) ) {
					aVar->SetF(FisSpatial,True,"ProcessSpatialDependencies.Connection"); go=True; rGo=True; 
				}
      }
      TNamedObjectList& commandList = aVar->CommandList();
      for( Pix p0 = commandList.first(); p0; commandList.next(p0) ) {
				TCommand &c0 = (TCommand&) commandList(p0);
				if( c0.GetObjInfo(TCommand::kStatus) == TCommand::kActive ) {
				  TCommand::EType ctype =  (TCommand::EType) c0.GetObjInfo(TCommand::kType);
				  if( gDebug > 1 ) { gPrintLog( format("ProcessSpatialDependencies>> command %s.%s: funcode: %c",aVar->Name(),c0.Name(),c0.Function()) ); }
				  if( (ctype != TCommand::kFunction) || ( c0.Function() == 'S' ) ) {
					TNamedObjectList& dList = c0.DependencyList();
					for( Pix pd = dList.first(); pd; dList.next(pd) ) {
						TDependency& d = (TDependency&) dList(pd);
						Variable* v1 = (Variable*) d.Var();
						if(v1) {
							if( v1->GetF(FisImport) && v1->Connection() != NULL ) { 
								v1 = (Variable*)v1->Connection(); }
							if( aVar->ProcessSpatialDependency(v1,c0.getValueString(0)) ) { 
								go=True; rGo=True; 
							}
						}
					}
				} 
			  }
      }
    }
  }
  return rGo;
} // TModule:::ProcessDependencies:

//----------------------------------------------------------------------------------------
//				TModule::SplitLists:
//----------------------------------------------------------------------------------------
  
void Module ::  SplitListsSpatially() {

  TNamedObjectList eventList;
  int go = 1;
  for( Pix p0 = fEventList.first(); p0; fEventList.next(p0) ) {
    TEvent& e0 = (TEvent&) fEventList(p0);
    CString n = e0.SName() + "__S__";
    TEvent* iS = new TEvent( n, this );
    iS->SetObjInfo( TEvent::kType, e0.GetObjInfo(TEvent::kType) );
    e0.SplitSpatially( *iS  );
    iS->SetObjInfo(TEvent::kSpatial,True);
    eventList.append(*iS);
  }
  fEventList += eventList;  
}

//----------------------------------------------------------------------------------------
//				TModule::CreateDependencyLists:
//----------------------------------------------------------------------------------------
          
void Module :: CreateEventDependencies() { 

  Env::EAppType app =  (Env::EAppType) Env::GetInfo(Env::kAppType);	

  for( Pix p = fEventList.first(); p; fEventList.next(p) ) {
    TEvent& e = (TEvent&) fEventList(p);
    e.CreateDependencies(fVarList);
  }
  if ( app == Env::kCGP ) {
	for( Pix p = fEventList.first(); p; fEventList.next(p) ) {
	  TEvent& e = (TEvent&) fEventList(p);
	  e.AddFluxDependencies();
	}
  }
} //  TModule::CreateDependencyLists

//----------------------------------------------------------------------------------------
//				TModule::SortLists:
//----------------------------------------------------------------------------------------
  
void Module ::  SortLists() {
  for( Pix p0 = fEventList.first(); p0; fEventList.next(p0) ) {
    TEvent& e0 = (TEvent&) fEventList(p0);
	int sort_len = -1;
    if( (e0.GetObjInfo(TEvent::kType) == TEvent::kInit) && fSuper ) {;}
    else { sort_len = e0.Sort(); }
    if( gDebug ) { gPrintLog( format("Sorting List: Event = %s, Sort Length = %d ", e0.Name(), sort_len) ); }
  } 
}  

//----------------------------------------------------------------------------------------
//				Module::ConfigureSchedules:
//----------------------------------------------------------------------------------------

void Module::ConfigureSchedules() {

  if( !fSchedule.ScheduleConfigured() ) fSchedule = *GetSchedule(True);
  fSchedule.SetParent( GetSchedule(True) );
  for( Pix p = fModuleList.first(); p; fModuleList.next(p) ) {
    Module& m = (Module&) fModuleList(p);
    m.ConfigureSchedules();
  }
}

int Module::Finalize() {
	int rv=0;
  for( Pix pv = fVarList.first(); pv; fVarList.next(pv) ) {
    Variable& v = (Variable&) fVarList(pv);
    rv += v.Finalize();
	}
	return rv;
}

//----------------------------------------------------------------------------------------
//				Module::PostCommands:
//----------------------------------------------------------------------------------------

TNamedObjectList* Module::PostCommandsFromConfig() {

	static TNamedObjectList* pipeList = new TNamedObjectList("Pipe List"); 
	for( Pix pc = fCommandList.first(); pc; fCommandList.next(pc) ) {
		TCommand& c = (TCommand&) fCommandList(pc);
		if( c.GetObjInfo(TCommand::kStatus) == TCommand::kActive && 
				c.GetObjInfo(TCommand::kExType) == TCommand::kScript ) {
				TEvent* e = GetEvent("Script",TEvent::kFirstUpdate);	  
				e->AddCommand(c);
				e->Schedule();
		}
	}
  Pix pv; 
  for( pv = fVarList.first(); pv; fVarList.next(pv) ) {
    Variable& v = (Variable&) fVarList(pv);
    TNamedObjectList& cL = v.CommandList();
    for( Pix pc = cL.first(); pc; cL.next(pc) ) {
      TCommand& c = (TCommand&) cL(pc);
      if( c.GetObjInfo(TCommand::kStatus) == TCommand::kActive) {
				if( c.GetObjInfo(TCommand::kExType) == TCommand::kPipe ) {
					TPipeCommand* pc =  (TPipeCommand*) &c;
					Pipe* p = pc->GetPipe();
					p->Initialize();
					PostPipe(*pc);                                               // do module-level post
					if( p->GetObjInfo(Pipe::kMode) == Pipe::kInput) {
						if( p->GetObjInfo(Pipe::kType) == Pipe::kMapInput ) {        // list map inputs first for global (init) post.
							pipeList->prepend(*pc);
						} else {
							pipeList->append(*pc);
						}	
					}				
				} else if  (c.GetObjInfo(TCommand::kExType) == TCommand::kScript ) {	  
						TScriptCommand* sc =  (TScriptCommand*) &c;
						TEvent* e = GetEvent("Script",TEvent::kFirstUpdate);	  
						e->AddCommand(c);
						e->Schedule();
				}
      }
    }
  }
  return pipeList;
}
//----------------------------------------------------------------------------------------
//				Module::PostPipe:
//----------------------------------------------------------------------------------------

Pix Module::PostPipe( TPipeCommand& c ) {
  Pipe* pipe = c.GetPipe();
  if( pipe->GetObjInfo(Pipe::kMode) == (byte)Pipe::kDisplay )  {
	  Module* gm  = Model::I0().GlobalMod();     // Post at end of init event (for initial value).
	  if( gm == NULL ) { gFatal( "No Root Module Specified." ); }
	  TEvent* e = gm->GetEvent("StateVarInit__S__",TEvent::kInit);
	  e->AddCommand(c,TEvent::kEnd);  
      sprintf(gMsgStr,"\nPosting Pipe Command: %s:%s to event %s", Name(), c.Name(), e->Name() ); gPrintLog();
  }
  if( pipe->GetObjInfo(Pipe::kMode) == Pipe::kInput) {
    if( c.Schedule() ) {                               // Post at beginning of update event if Scheduled.
      TEvent* pe = GetEvent("InputPipes",TEvent::kFirstUpdate);	  
      Pix rp  = pe->AddCommand(c);
      pe->Schedule(TEvent::kBeginning);
      sprintf(gMsgStr,"\nPosting Pipe Command: %s:%s to event %s",Name(),c.Name(),pe->Name()); gPrintLog();
      return rp;
    }
  } else {
		if( Model::I0().GetCInfo(Model::kOptLevel) >= 5) {
				TEvent* e = GetEvent("GlobalUpdate",TEvent::kGlobalUpdate);	  
				Pix rp = e->AddCommand(c);
				sprintf(gMsgStr,"\nPosting Pipe Command: %s:%s to event %s",Name(),c.Name(),e->Name()); gPrintLog();
				return rp;
		} else {
		  TEvent* finalUpdate =  GetEvent("FinalUpdate", TEvent::kFinalUpdate );
		  Pix rp = finalUpdate->AddCommand(c);
		  sprintf(gMsgStr,"\nPosting Pipe Command: %s:%s to event %s",Name(),c.Name(),finalUpdate->Name()); gPrintLog();
		  return rp;
		}
  }
}

//----------------------------------------------------------------------------------------
//				Module::WriteInstantiator:
//----------------------------------------------------------------------------------------
   
void Module :: WriteInstantiator (FILE* CHdrFile) const { 

  fprintf(CHdrFile,"\n\tinline static %s& I() {",(const char*)fName);
  fprintf(CHdrFile,"\n\t\tif(fInstance == kNullModel) { gFatal(\"Error, Recursive Call of Model Instantiator\"); }");
  fprintf(CHdrFile,"\n\t\telse if(fInstance == NULL) {");
  fprintf(CHdrFile,"\n\t\t\tfInstance = kNullModel;");
  fprintf(CHdrFile,"\n\t\t\tfInstance = new %s(\"%s\");",(const char*)fName,(const char*)fName);
  fprintf(CHdrFile,"\n\t\t\tModel::I0().ModuleList().Insert(*fInstance);"); 
  fprintf(CHdrFile,"\n\t\t}"); 
  fprintf(CHdrFile,"\n\t\treturn (%s&) *fInstance;\n\t}\n",(const char*)fName); 
} 
           
//----------------------------------------------------------------------------------------
//				TModule::AddCommand:
//----------------------------------------------------------------------------------------

Pix Module::AddCommand( TCommand* c )
{
  TCommand* aCommand = (TCommand*) fCommandList.GetObjectByName( c->Name() );
  if( aCommand != NULL ) { sprintf(gMsgStr," Multiple Commands with same Name: %s", c->Name() ); gPrintErr(); }
  return fCommandList.append(*c);
}

//----------------------------------------------------------------------------------------
//				Module:: GetSchedule:
//----------------------------------------------------------------------------------------

ExSchedule* Module :: GetSchedule( Bool getParent ) { 
  if( !getParent ) return &fSchedule;
  if(fSuper) return fSuper->GetSchedule();
  return Model::I0().GetSchedule();
}
